
package org.hisp.dhis.api.model.v2_35_13;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "attributeValues",
    "code",
    "created",
    "description",
    "displayDescription",
    "displayName",
    "enrollmentCreatedPeriod",
    "enrollmentStatus",
    "eventFilters",
    "externalAccess",
    "favorite",
    "favorites",
    "followup",
    "href",
    "id",
    "lastUpdated",
    "lastUpdatedBy",
    "name",
    "program",
    "publicAccess",
    "sortOrder",
    "style",
    "translations",
    "user",
    "userAccesses",
    "userGroupAccesses"
})
@Generated("jsonschema2pojo")
public class TrackedEntityInstanceFilter implements Serializable
{

    @JsonProperty("access")
    private Access access;
    @JsonProperty("attributeValues")
    private List<AttributeValue> attributeValues;
    @JsonProperty("code")
    private String code;
    @JsonProperty("created")
    private Date created;
    @JsonProperty("description")
    private String description;
    @JsonProperty("displayDescription")
    private String displayDescription;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("enrollmentCreatedPeriod")
    private FilterPeriod enrollmentCreatedPeriod;
    @JsonProperty("enrollmentStatus")
    private org.hisp.dhis.api.model.v2_35_13.EventChart.ProgramStatus enrollmentStatus;
    @JsonProperty("eventFilters")
    private List<EventFilter> eventFilters;
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    @JsonProperty("favorite")
    private Boolean favorite;
    @JsonProperty("favorites")
    private List<String> favorites;
    @JsonProperty("followup")
    private Boolean followup;
    @JsonProperty("href")
    private String href;
    @JsonProperty("id")
    private String id;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    @JsonProperty("lastUpdatedBy")
    private User lastUpdatedBy;
    @JsonProperty("name")
    private String name;
    @JsonProperty("program")
    private Program program;
    @JsonProperty("publicAccess")
    private String publicAccess;
    @JsonProperty("sortOrder")
    private Integer sortOrder;
    @JsonProperty("style")
    private ObjectStyle style;
    @JsonProperty("translations")
    private List<Translation> translations;
    @JsonProperty("user")
    private User user;
    @JsonProperty("userAccesses")
    private List<UserAccess> userAccesses;
    @JsonProperty("userGroupAccesses")
    private List<UserGroupAccess> userGroupAccesses;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 874056136437201167L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TrackedEntityInstanceFilter() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public TrackedEntityInstanceFilter(TrackedEntityInstanceFilter source) {
        super();
        this.access = source.access;
        this.attributeValues = source.attributeValues;
        this.code = source.code;
        this.created = source.created;
        this.description = source.description;
        this.displayDescription = source.displayDescription;
        this.displayName = source.displayName;
        this.enrollmentCreatedPeriod = source.enrollmentCreatedPeriod;
        this.enrollmentStatus = source.enrollmentStatus;
        this.eventFilters = source.eventFilters;
        this.externalAccess = source.externalAccess;
        this.favorite = source.favorite;
        this.favorites = source.favorites;
        this.followup = source.followup;
        this.href = source.href;
        this.id = source.id;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.name = source.name;
        this.program = source.program;
        this.publicAccess = source.publicAccess;
        this.sortOrder = source.sortOrder;
        this.style = source.style;
        this.translations = source.translations;
        this.user = source.user;
        this.userAccesses = source.userAccesses;
        this.userGroupAccesses = source.userGroupAccesses;
    }

    public TrackedEntityInstanceFilter(Access access, List<AttributeValue> attributeValues, String code, Date created, String description, String displayDescription, String displayName, FilterPeriod enrollmentCreatedPeriod, org.hisp.dhis.api.model.v2_35_13.EventChart.ProgramStatus enrollmentStatus, List<EventFilter> eventFilters, Boolean externalAccess, Boolean favorite, List<String> favorites, Boolean followup, String href, String id, Date lastUpdated, User lastUpdatedBy, String name, Program program, String publicAccess, Integer sortOrder, ObjectStyle style, List<Translation> translations, User user, List<UserAccess> userAccesses, List<UserGroupAccess> userGroupAccesses) {
        super();
        this.access = access;
        this.attributeValues = attributeValues;
        this.code = code;
        this.created = created;
        this.description = description;
        this.displayDescription = displayDescription;
        this.displayName = displayName;
        this.enrollmentCreatedPeriod = enrollmentCreatedPeriod;
        this.enrollmentStatus = enrollmentStatus;
        this.eventFilters = eventFilters;
        this.externalAccess = externalAccess;
        this.favorite = favorite;
        this.favorites = favorites;
        this.followup = followup;
        this.href = href;
        this.id = id;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedBy = lastUpdatedBy;
        this.name = name;
        this.program = program;
        this.publicAccess = publicAccess;
        this.sortOrder = sortOrder;
        this.style = style;
        this.translations = translations;
        this.user = user;
        this.userAccesses = userAccesses;
        this.userGroupAccesses = userGroupAccesses;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public TrackedEntityInstanceFilter withAccess(Access access) {
        this.access = access;
        return this;
    }

    @JsonProperty("attributeValues")
    public Optional<List<AttributeValue>> getAttributeValues() {
        return Optional.ofNullable(attributeValues);
    }

    @JsonProperty("attributeValues")
    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public TrackedEntityInstanceFilter withAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public TrackedEntityInstanceFilter withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public TrackedEntityInstanceFilter withCreated(Date created) {
        this.created = created;
        return this;
    }

    @JsonProperty("description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    public TrackedEntityInstanceFilter withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty("displayDescription")
    public Optional<String> getDisplayDescription() {
        return Optional.ofNullable(displayDescription);
    }

    @JsonProperty("displayDescription")
    public void setDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
    }

    public TrackedEntityInstanceFilter withDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public TrackedEntityInstanceFilter withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("enrollmentCreatedPeriod")
    public Optional<FilterPeriod> getEnrollmentCreatedPeriod() {
        return Optional.ofNullable(enrollmentCreatedPeriod);
    }

    @JsonProperty("enrollmentCreatedPeriod")
    public void setEnrollmentCreatedPeriod(FilterPeriod enrollmentCreatedPeriod) {
        this.enrollmentCreatedPeriod = enrollmentCreatedPeriod;
    }

    public TrackedEntityInstanceFilter withEnrollmentCreatedPeriod(FilterPeriod enrollmentCreatedPeriod) {
        this.enrollmentCreatedPeriod = enrollmentCreatedPeriod;
        return this;
    }

    @JsonProperty("enrollmentStatus")
    public Optional<org.hisp.dhis.api.model.v2_35_13.EventChart.ProgramStatus> getEnrollmentStatus() {
        return Optional.ofNullable(enrollmentStatus);
    }

    @JsonProperty("enrollmentStatus")
    public void setEnrollmentStatus(org.hisp.dhis.api.model.v2_35_13.EventChart.ProgramStatus enrollmentStatus) {
        this.enrollmentStatus = enrollmentStatus;
    }

    public TrackedEntityInstanceFilter withEnrollmentStatus(org.hisp.dhis.api.model.v2_35_13.EventChart.ProgramStatus enrollmentStatus) {
        this.enrollmentStatus = enrollmentStatus;
        return this;
    }

    @JsonProperty("eventFilters")
    public Optional<List<EventFilter>> getEventFilters() {
        return Optional.ofNullable(eventFilters);
    }

    @JsonProperty("eventFilters")
    public void setEventFilters(List<EventFilter> eventFilters) {
        this.eventFilters = eventFilters;
    }

    public TrackedEntityInstanceFilter withEventFilters(List<EventFilter> eventFilters) {
        this.eventFilters = eventFilters;
        return this;
    }

    @JsonProperty("externalAccess")
    public Optional<Boolean> getExternalAccess() {
        return Optional.ofNullable(externalAccess);
    }

    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public TrackedEntityInstanceFilter withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    @JsonProperty("favorite")
    public Optional<Boolean> getFavorite() {
        return Optional.ofNullable(favorite);
    }

    @JsonProperty("favorite")
    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public TrackedEntityInstanceFilter withFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public TrackedEntityInstanceFilter withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    @JsonProperty("followup")
    public Optional<Boolean> getFollowup() {
        return Optional.ofNullable(followup);
    }

    @JsonProperty("followup")
    public void setFollowup(Boolean followup) {
        this.followup = followup;
    }

    public TrackedEntityInstanceFilter withFollowup(Boolean followup) {
        this.followup = followup;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public TrackedEntityInstanceFilter withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public TrackedEntityInstanceFilter withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public TrackedEntityInstanceFilter withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    @JsonProperty("lastUpdatedBy")
    public Optional<User> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public TrackedEntityInstanceFilter withLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public TrackedEntityInstanceFilter withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("program")
    public Optional<Program> getProgram() {
        return Optional.ofNullable(program);
    }

    @JsonProperty("program")
    public void setProgram(Program program) {
        this.program = program;
    }

    public TrackedEntityInstanceFilter withProgram(Program program) {
        this.program = program;
        return this;
    }

    @JsonProperty("publicAccess")
    public Optional<String> getPublicAccess() {
        return Optional.ofNullable(publicAccess);
    }

    @JsonProperty("publicAccess")
    public void setPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
    }

    public TrackedEntityInstanceFilter withPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    @JsonProperty("sortOrder")
    public Optional<Integer> getSortOrder() {
        return Optional.ofNullable(sortOrder);
    }

    @JsonProperty("sortOrder")
    public void setSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
    }

    public TrackedEntityInstanceFilter withSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
        return this;
    }

    @JsonProperty("style")
    public Optional<ObjectStyle> getStyle() {
        return Optional.ofNullable(style);
    }

    @JsonProperty("style")
    public void setStyle(ObjectStyle style) {
        this.style = style;
    }

    public TrackedEntityInstanceFilter withStyle(ObjectStyle style) {
        this.style = style;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public TrackedEntityInstanceFilter withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    @JsonProperty("user")
    public Optional<User> getUser() {
        return Optional.ofNullable(user);
    }

    @JsonProperty("user")
    public void setUser(User user) {
        this.user = user;
    }

    public TrackedEntityInstanceFilter withUser(User user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<UserAccess>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public TrackedEntityInstanceFilter withUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<UserGroupAccess>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public TrackedEntityInstanceFilter withUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public TrackedEntityInstanceFilter withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("access".equals(name)) {
            if (value instanceof Access) {
                setAccess(((Access) value));
            } else {
                throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v2_35_13.Access\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("attributeValues".equals(name)) {
                if (value instanceof List) {
                    setAttributeValues(((List<AttributeValue> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.AttributeValue>\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("code".equals(name)) {
                    if (value instanceof String) {
                        setCode(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("created".equals(name)) {
                        if (value instanceof Date) {
                            setCreated(((Date) value));
                        } else {
                            throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("description".equals(name)) {
                            if (value instanceof String) {
                                setDescription(((String) value));
                            } else {
                                throw new IllegalArgumentException(("property \"description\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("displayDescription".equals(name)) {
                                if (value instanceof String) {
                                    setDisplayDescription(((String) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"displayDescription\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("displayName".equals(name)) {
                                    if (value instanceof String) {
                                        setDisplayName(((String) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("enrollmentCreatedPeriod".equals(name)) {
                                        if (value instanceof FilterPeriod) {
                                            setEnrollmentCreatedPeriod(((FilterPeriod) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"enrollmentCreatedPeriod\" is of type \"org.hisp.dhis.api.model.v2_35_13.FilterPeriod\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("enrollmentStatus".equals(name)) {
                                            if (value instanceof org.hisp.dhis.api.model.v2_35_13.EventChart.ProgramStatus) {
                                                setEnrollmentStatus(((org.hisp.dhis.api.model.v2_35_13.EventChart.ProgramStatus) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"enrollmentStatus\" is of type \"org.hisp.dhis.api.model.v2_35_13.EventChart.ProgramStatus\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("eventFilters".equals(name)) {
                                                if (value instanceof List) {
                                                    setEventFilters(((List<EventFilter> ) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"eventFilters\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.EventFilter>\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("externalAccess".equals(name)) {
                                                    if (value instanceof Boolean) {
                                                        setExternalAccess(((Boolean) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("favorite".equals(name)) {
                                                        if (value instanceof Boolean) {
                                                            setFavorite(((Boolean) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"favorite\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("favorites".equals(name)) {
                                                            if (value instanceof List) {
                                                                setFavorites(((List<String> ) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            if ("followup".equals(name)) {
                                                                if (value instanceof Boolean) {
                                                                    setFollowup(((Boolean) value));
                                                                } else {
                                                                    throw new IllegalArgumentException(("property \"followup\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                }
                                                                return true;
                                                            } else {
                                                                if ("href".equals(name)) {
                                                                    if (value instanceof String) {
                                                                        setHref(((String) value));
                                                                    } else {
                                                                        throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                    }
                                                                    return true;
                                                                } else {
                                                                    if ("id".equals(name)) {
                                                                        if (value instanceof String) {
                                                                            setId(((String) value));
                                                                        } else {
                                                                            throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                        }
                                                                        return true;
                                                                    } else {
                                                                        if ("lastUpdated".equals(name)) {
                                                                            if (value instanceof Date) {
                                                                                setLastUpdated(((Date) value));
                                                                            } else {
                                                                                throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                                                            }
                                                                            return true;
                                                                        } else {
                                                                            if ("lastUpdatedBy".equals(name)) {
                                                                                if (value instanceof User) {
                                                                                    setLastUpdatedBy(((User) value));
                                                                                } else {
                                                                                    throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"org.hisp.dhis.api.model.v2_35_13.User\", but got "+ value.getClass().toString()));
                                                                                }
                                                                                return true;
                                                                            } else {
                                                                                if ("name".equals(name)) {
                                                                                    if (value instanceof String) {
                                                                                        setName(((String) value));
                                                                                    } else {
                                                                                        throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                    }
                                                                                    return true;
                                                                                } else {
                                                                                    if ("program".equals(name)) {
                                                                                        if (value instanceof Program) {
                                                                                            setProgram(((Program) value));
                                                                                        } else {
                                                                                            throw new IllegalArgumentException(("property \"program\" is of type \"org.hisp.dhis.api.model.v2_35_13.Program\", but got "+ value.getClass().toString()));
                                                                                        }
                                                                                        return true;
                                                                                    } else {
                                                                                        if ("publicAccess".equals(name)) {
                                                                                            if (value instanceof String) {
                                                                                                setPublicAccess(((String) value));
                                                                                            } else {
                                                                                                throw new IllegalArgumentException(("property \"publicAccess\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                            }
                                                                                            return true;
                                                                                        } else {
                                                                                            if ("sortOrder".equals(name)) {
                                                                                                if (value instanceof Integer) {
                                                                                                    setSortOrder(((Integer) value));
                                                                                                } else {
                                                                                                    throw new IllegalArgumentException(("property \"sortOrder\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                                                                                }
                                                                                                return true;
                                                                                            } else {
                                                                                                if ("style".equals(name)) {
                                                                                                    if (value instanceof ObjectStyle) {
                                                                                                        setStyle(((ObjectStyle) value));
                                                                                                    } else {
                                                                                                        throw new IllegalArgumentException(("property \"style\" is of type \"org.hisp.dhis.api.model.v2_35_13.ObjectStyle\", but got "+ value.getClass().toString()));
                                                                                                    }
                                                                                                    return true;
                                                                                                } else {
                                                                                                    if ("translations".equals(name)) {
                                                                                                        if (value instanceof List) {
                                                                                                            setTranslations(((List<Translation> ) value));
                                                                                                        } else {
                                                                                                            throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.Translation>\", but got "+ value.getClass().toString()));
                                                                                                        }
                                                                                                        return true;
                                                                                                    } else {
                                                                                                        if ("user".equals(name)) {
                                                                                                            if (value instanceof User) {
                                                                                                                setUser(((User) value));
                                                                                                            } else {
                                                                                                                throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v2_35_13.User\", but got "+ value.getClass().toString()));
                                                                                                            }
                                                                                                            return true;
                                                                                                        } else {
                                                                                                            if ("userAccesses".equals(name)) {
                                                                                                                if (value instanceof List) {
                                                                                                                    setUserAccesses(((List<UserAccess> ) value));
                                                                                                                } else {
                                                                                                                    throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.UserAccess>\", but got "+ value.getClass().toString()));
                                                                                                                }
                                                                                                                return true;
                                                                                                            } else {
                                                                                                                if ("userGroupAccesses".equals(name)) {
                                                                                                                    if (value instanceof List) {
                                                                                                                        setUserGroupAccesses(((List<UserGroupAccess> ) value));
                                                                                                                    } else {
                                                                                                                        throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.UserGroupAccess>\", but got "+ value.getClass().toString()));
                                                                                                                    }
                                                                                                                    return true;
                                                                                                                } else {
                                                                                                                    return false;
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("access".equals(name)) {
            return getAccess();
        } else {
            if ("attributeValues".equals(name)) {
                return getAttributeValues();
            } else {
                if ("code".equals(name)) {
                    return getCode();
                } else {
                    if ("created".equals(name)) {
                        return getCreated();
                    } else {
                        if ("description".equals(name)) {
                            return getDescription();
                        } else {
                            if ("displayDescription".equals(name)) {
                                return getDisplayDescription();
                            } else {
                                if ("displayName".equals(name)) {
                                    return getDisplayName();
                                } else {
                                    if ("enrollmentCreatedPeriod".equals(name)) {
                                        return getEnrollmentCreatedPeriod();
                                    } else {
                                        if ("enrollmentStatus".equals(name)) {
                                            return getEnrollmentStatus();
                                        } else {
                                            if ("eventFilters".equals(name)) {
                                                return getEventFilters();
                                            } else {
                                                if ("externalAccess".equals(name)) {
                                                    return getExternalAccess();
                                                } else {
                                                    if ("favorite".equals(name)) {
                                                        return getFavorite();
                                                    } else {
                                                        if ("favorites".equals(name)) {
                                                            return getFavorites();
                                                        } else {
                                                            if ("followup".equals(name)) {
                                                                return getFollowup();
                                                            } else {
                                                                if ("href".equals(name)) {
                                                                    return getHref();
                                                                } else {
                                                                    if ("id".equals(name)) {
                                                                        return getId();
                                                                    } else {
                                                                        if ("lastUpdated".equals(name)) {
                                                                            return getLastUpdated();
                                                                        } else {
                                                                            if ("lastUpdatedBy".equals(name)) {
                                                                                return getLastUpdatedBy();
                                                                            } else {
                                                                                if ("name".equals(name)) {
                                                                                    return getName();
                                                                                } else {
                                                                                    if ("program".equals(name)) {
                                                                                        return getProgram();
                                                                                    } else {
                                                                                        if ("publicAccess".equals(name)) {
                                                                                            return getPublicAccess();
                                                                                        } else {
                                                                                            if ("sortOrder".equals(name)) {
                                                                                                return getSortOrder();
                                                                                            } else {
                                                                                                if ("style".equals(name)) {
                                                                                                    return getStyle();
                                                                                                } else {
                                                                                                    if ("translations".equals(name)) {
                                                                                                        return getTranslations();
                                                                                                    } else {
                                                                                                        if ("user".equals(name)) {
                                                                                                            return getUser();
                                                                                                        } else {
                                                                                                            if ("userAccesses".equals(name)) {
                                                                                                                return getUserAccesses();
                                                                                                            } else {
                                                                                                                if ("userGroupAccesses".equals(name)) {
                                                                                                                    return getUserGroupAccesses();
                                                                                                                } else {
                                                                                                                    return notFoundValue;
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, TrackedEntityInstanceFilter.NOT_FOUND_VALUE);
        if (TrackedEntityInstanceFilter.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public TrackedEntityInstanceFilter with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TrackedEntityInstanceFilter.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("attributeValues");
        sb.append('=');
        sb.append(((this.attributeValues == null)?"<null>":this.attributeValues));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("displayDescription");
        sb.append('=');
        sb.append(((this.displayDescription == null)?"<null>":this.displayDescription));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("enrollmentCreatedPeriod");
        sb.append('=');
        sb.append(((this.enrollmentCreatedPeriod == null)?"<null>":this.enrollmentCreatedPeriod));
        sb.append(',');
        sb.append("enrollmentStatus");
        sb.append('=');
        sb.append(((this.enrollmentStatus == null)?"<null>":this.enrollmentStatus));
        sb.append(',');
        sb.append("eventFilters");
        sb.append('=');
        sb.append(((this.eventFilters == null)?"<null>":this.eventFilters));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("favorite");
        sb.append('=');
        sb.append(((this.favorite == null)?"<null>":this.favorite));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("followup");
        sb.append('=');
        sb.append(((this.followup == null)?"<null>":this.followup));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("program");
        sb.append('=');
        sb.append(((this.program == null)?"<null>":this.program));
        sb.append(',');
        sb.append("publicAccess");
        sb.append('=');
        sb.append(((this.publicAccess == null)?"<null>":this.publicAccess));
        sb.append(',');
        sb.append("sortOrder");
        sb.append('=');
        sb.append(((this.sortOrder == null)?"<null>":this.sortOrder));
        sb.append(',');
        sb.append("style");
        sb.append('=');
        sb.append(((this.style == null)?"<null>":this.style));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.publicAccess == null)? 0 :this.publicAccess.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.program == null)? 0 :this.program.hashCode()));
        result = ((result* 31)+((this.enrollmentCreatedPeriod == null)? 0 :this.enrollmentCreatedPeriod.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.displayDescription == null)? 0 :this.displayDescription.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.attributeValues == null)? 0 :this.attributeValues.hashCode()));
        result = ((result* 31)+((this.followup == null)? 0 :this.followup.hashCode()));
        result = ((result* 31)+((this.eventFilters == null)? 0 :this.eventFilters.hashCode()));
        result = ((result* 31)+((this.enrollmentStatus == null)? 0 :this.enrollmentStatus.hashCode()));
        result = ((result* 31)+((this.sortOrder == null)? 0 :this.sortOrder.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.style == null)? 0 :this.style.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.favorite == null)? 0 :this.favorite.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TrackedEntityInstanceFilter) == false) {
            return false;
        }
        TrackedEntityInstanceFilter rhs = ((TrackedEntityInstanceFilter) other);
        return (((((((((((((((((((((((((((((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites)))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.publicAccess == rhs.publicAccess)||((this.publicAccess!= null)&&this.publicAccess.equals(rhs.publicAccess))))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.program == rhs.program)||((this.program!= null)&&this.program.equals(rhs.program))))&&((this.enrollmentCreatedPeriod == rhs.enrollmentCreatedPeriod)||((this.enrollmentCreatedPeriod!= null)&&this.enrollmentCreatedPeriod.equals(rhs.enrollmentCreatedPeriod))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.displayDescription == rhs.displayDescription)||((this.displayDescription!= null)&&this.displayDescription.equals(rhs.displayDescription))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.attributeValues == rhs.attributeValues)||((this.attributeValues!= null)&&this.attributeValues.equals(rhs.attributeValues))))&&((this.followup == rhs.followup)||((this.followup!= null)&&this.followup.equals(rhs.followup))))&&((this.eventFilters == rhs.eventFilters)||((this.eventFilters!= null)&&this.eventFilters.equals(rhs.eventFilters))))&&((this.enrollmentStatus == rhs.enrollmentStatus)||((this.enrollmentStatus!= null)&&this.enrollmentStatus.equals(rhs.enrollmentStatus))))&&((this.sortOrder == rhs.sortOrder)||((this.sortOrder!= null)&&this.sortOrder.equals(rhs.sortOrder))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.style == rhs.style)||((this.style!= null)&&this.style.equals(rhs.style))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.favorite == rhs.favorite)||((this.favorite!= null)&&this.favorite.equals(rhs.favorite))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))));
    }

}
