
package org.hisp.dhis.api.model.v2_35_13;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "attributes",
    "createdAt",
    "deleted",
    "enrollments",
    "geometry",
    "inactive",
    "orgUnit",
    "programOwners",
    "relationships",
    "storedBy",
    "trackedEntity",
    "trackedEntityType",
    "updatedAt"
})
@Generated("jsonschema2pojo")
public class TrackedEntity implements Serializable
{

    @JsonProperty("attributes")
    private List<Attribute__2> attributes;
    @JsonProperty("createdAt")
    private String createdAt;
    @JsonProperty("deleted")
    private Boolean deleted;
    @JsonProperty("enrollments")
    private List<Enrollment__1> enrollments;
    /**
     * Undefined
     * 
     */
    @JsonProperty("geometry")
    private Object geometry;
    @JsonProperty("inactive")
    private Boolean inactive;
    @JsonProperty("orgUnit")
    private String orgUnit;
    @JsonProperty("programOwners")
    private List<ProgramOwner__1> programOwners;
    @JsonProperty("relationships")
    private List<Relationship__1> relationships;
    @JsonProperty("storedBy")
    private String storedBy;
    @JsonProperty("trackedEntity")
    private String trackedEntity;
    @JsonProperty("trackedEntityType")
    private String trackedEntityType;
    @JsonProperty("updatedAt")
    private String updatedAt;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -4615211228231441538L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TrackedEntity() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public TrackedEntity(TrackedEntity source) {
        super();
        this.attributes = source.attributes;
        this.createdAt = source.createdAt;
        this.deleted = source.deleted;
        this.enrollments = source.enrollments;
        this.geometry = source.geometry;
        this.inactive = source.inactive;
        this.orgUnit = source.orgUnit;
        this.programOwners = source.programOwners;
        this.relationships = source.relationships;
        this.storedBy = source.storedBy;
        this.trackedEntity = source.trackedEntity;
        this.trackedEntityType = source.trackedEntityType;
        this.updatedAt = source.updatedAt;
    }

    public TrackedEntity(List<Attribute__2> attributes, String createdAt, Boolean deleted, List<Enrollment__1> enrollments, Object geometry, Boolean inactive, String orgUnit, List<ProgramOwner__1> programOwners, List<Relationship__1> relationships, String storedBy, String trackedEntity, String trackedEntityType, String updatedAt) {
        super();
        this.attributes = attributes;
        this.createdAt = createdAt;
        this.deleted = deleted;
        this.enrollments = enrollments;
        this.geometry = geometry;
        this.inactive = inactive;
        this.orgUnit = orgUnit;
        this.programOwners = programOwners;
        this.relationships = relationships;
        this.storedBy = storedBy;
        this.trackedEntity = trackedEntity;
        this.trackedEntityType = trackedEntityType;
        this.updatedAt = updatedAt;
    }

    @JsonProperty("attributes")
    public Optional<List<Attribute__2>> getAttributes() {
        return Optional.ofNullable(attributes);
    }

    @JsonProperty("attributes")
    public void setAttributes(List<Attribute__2> attributes) {
        this.attributes = attributes;
    }

    public TrackedEntity withAttributes(List<Attribute__2> attributes) {
        this.attributes = attributes;
        return this;
    }

    @JsonProperty("createdAt")
    public Optional<String> getCreatedAt() {
        return Optional.ofNullable(createdAt);
    }

    @JsonProperty("createdAt")
    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public TrackedEntity withCreatedAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @JsonProperty("deleted")
    public Optional<Boolean> getDeleted() {
        return Optional.ofNullable(deleted);
    }

    @JsonProperty("deleted")
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public TrackedEntity withDeleted(Boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    @JsonProperty("enrollments")
    public Optional<List<Enrollment__1>> getEnrollments() {
        return Optional.ofNullable(enrollments);
    }

    @JsonProperty("enrollments")
    public void setEnrollments(List<Enrollment__1> enrollments) {
        this.enrollments = enrollments;
    }

    public TrackedEntity withEnrollments(List<Enrollment__1> enrollments) {
        this.enrollments = enrollments;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("geometry")
    public Optional<Object> getGeometry() {
        return Optional.ofNullable(geometry);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("geometry")
    public void setGeometry(Object geometry) {
        this.geometry = geometry;
    }

    public TrackedEntity withGeometry(Object geometry) {
        this.geometry = geometry;
        return this;
    }

    @JsonProperty("inactive")
    public Optional<Boolean> getInactive() {
        return Optional.ofNullable(inactive);
    }

    @JsonProperty("inactive")
    public void setInactive(Boolean inactive) {
        this.inactive = inactive;
    }

    public TrackedEntity withInactive(Boolean inactive) {
        this.inactive = inactive;
        return this;
    }

    @JsonProperty("orgUnit")
    public Optional<String> getOrgUnit() {
        return Optional.ofNullable(orgUnit);
    }

    @JsonProperty("orgUnit")
    public void setOrgUnit(String orgUnit) {
        this.orgUnit = orgUnit;
    }

    public TrackedEntity withOrgUnit(String orgUnit) {
        this.orgUnit = orgUnit;
        return this;
    }

    @JsonProperty("programOwners")
    public Optional<List<ProgramOwner__1>> getProgramOwners() {
        return Optional.ofNullable(programOwners);
    }

    @JsonProperty("programOwners")
    public void setProgramOwners(List<ProgramOwner__1> programOwners) {
        this.programOwners = programOwners;
    }

    public TrackedEntity withProgramOwners(List<ProgramOwner__1> programOwners) {
        this.programOwners = programOwners;
        return this;
    }

    @JsonProperty("relationships")
    public Optional<List<Relationship__1>> getRelationships() {
        return Optional.ofNullable(relationships);
    }

    @JsonProperty("relationships")
    public void setRelationships(List<Relationship__1> relationships) {
        this.relationships = relationships;
    }

    public TrackedEntity withRelationships(List<Relationship__1> relationships) {
        this.relationships = relationships;
        return this;
    }

    @JsonProperty("storedBy")
    public Optional<String> getStoredBy() {
        return Optional.ofNullable(storedBy);
    }

    @JsonProperty("storedBy")
    public void setStoredBy(String storedBy) {
        this.storedBy = storedBy;
    }

    public TrackedEntity withStoredBy(String storedBy) {
        this.storedBy = storedBy;
        return this;
    }

    @JsonProperty("trackedEntity")
    public Optional<String> getTrackedEntity() {
        return Optional.ofNullable(trackedEntity);
    }

    @JsonProperty("trackedEntity")
    public void setTrackedEntity(String trackedEntity) {
        this.trackedEntity = trackedEntity;
    }

    public TrackedEntity withTrackedEntity(String trackedEntity) {
        this.trackedEntity = trackedEntity;
        return this;
    }

    @JsonProperty("trackedEntityType")
    public Optional<String> getTrackedEntityType() {
        return Optional.ofNullable(trackedEntityType);
    }

    @JsonProperty("trackedEntityType")
    public void setTrackedEntityType(String trackedEntityType) {
        this.trackedEntityType = trackedEntityType;
    }

    public TrackedEntity withTrackedEntityType(String trackedEntityType) {
        this.trackedEntityType = trackedEntityType;
        return this;
    }

    @JsonProperty("updatedAt")
    public Optional<String> getUpdatedAt() {
        return Optional.ofNullable(updatedAt);
    }

    @JsonProperty("updatedAt")
    public void setUpdatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
    }

    public TrackedEntity withUpdatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public TrackedEntity withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("attributes".equals(name)) {
            if (value instanceof List) {
                setAttributes(((List<Attribute__2> ) value));
            } else {
                throw new IllegalArgumentException(("property \"attributes\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.Attribute__2>\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("createdAt".equals(name)) {
                if (value instanceof String) {
                    setCreatedAt(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"createdAt\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("deleted".equals(name)) {
                    if (value instanceof Boolean) {
                        setDeleted(((Boolean) value));
                    } else {
                        throw new IllegalArgumentException(("property \"deleted\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("enrollments".equals(name)) {
                        if (value instanceof List) {
                            setEnrollments(((List<Enrollment__1> ) value));
                        } else {
                            throw new IllegalArgumentException(("property \"enrollments\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.Enrollment__1>\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("geometry".equals(name)) {
                            if (value instanceof Object) {
                                setGeometry(((Object) value));
                            } else {
                                throw new IllegalArgumentException(("property \"geometry\" is of type \"java.lang.Object\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("inactive".equals(name)) {
                                if (value instanceof Boolean) {
                                    setInactive(((Boolean) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"inactive\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("orgUnit".equals(name)) {
                                    if (value instanceof String) {
                                        setOrgUnit(((String) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"orgUnit\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("programOwners".equals(name)) {
                                        if (value instanceof List) {
                                            setProgramOwners(((List<ProgramOwner__1> ) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"programOwners\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.ProgramOwner__1>\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("relationships".equals(name)) {
                                            if (value instanceof List) {
                                                setRelationships(((List<Relationship__1> ) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"relationships\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.Relationship__1>\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("storedBy".equals(name)) {
                                                if (value instanceof String) {
                                                    setStoredBy(((String) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"storedBy\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("trackedEntity".equals(name)) {
                                                    if (value instanceof String) {
                                                        setTrackedEntity(((String) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"trackedEntity\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("trackedEntityType".equals(name)) {
                                                        if (value instanceof String) {
                                                            setTrackedEntityType(((String) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"trackedEntityType\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("updatedAt".equals(name)) {
                                                            if (value instanceof String) {
                                                                setUpdatedAt(((String) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"updatedAt\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            return false;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("attributes".equals(name)) {
            return getAttributes();
        } else {
            if ("createdAt".equals(name)) {
                return getCreatedAt();
            } else {
                if ("deleted".equals(name)) {
                    return getDeleted();
                } else {
                    if ("enrollments".equals(name)) {
                        return getEnrollments();
                    } else {
                        if ("geometry".equals(name)) {
                            return getGeometry();
                        } else {
                            if ("inactive".equals(name)) {
                                return getInactive();
                            } else {
                                if ("orgUnit".equals(name)) {
                                    return getOrgUnit();
                                } else {
                                    if ("programOwners".equals(name)) {
                                        return getProgramOwners();
                                    } else {
                                        if ("relationships".equals(name)) {
                                            return getRelationships();
                                        } else {
                                            if ("storedBy".equals(name)) {
                                                return getStoredBy();
                                            } else {
                                                if ("trackedEntity".equals(name)) {
                                                    return getTrackedEntity();
                                                } else {
                                                    if ("trackedEntityType".equals(name)) {
                                                        return getTrackedEntityType();
                                                    } else {
                                                        if ("updatedAt".equals(name)) {
                                                            return getUpdatedAt();
                                                        } else {
                                                            return notFoundValue;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, TrackedEntity.NOT_FOUND_VALUE);
        if (TrackedEntity.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public TrackedEntity with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TrackedEntity.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("attributes");
        sb.append('=');
        sb.append(((this.attributes == null)?"<null>":this.attributes));
        sb.append(',');
        sb.append("createdAt");
        sb.append('=');
        sb.append(((this.createdAt == null)?"<null>":this.createdAt));
        sb.append(',');
        sb.append("deleted");
        sb.append('=');
        sb.append(((this.deleted == null)?"<null>":this.deleted));
        sb.append(',');
        sb.append("enrollments");
        sb.append('=');
        sb.append(((this.enrollments == null)?"<null>":this.enrollments));
        sb.append(',');
        sb.append("geometry");
        sb.append('=');
        sb.append(((this.geometry == null)?"<null>":this.geometry));
        sb.append(',');
        sb.append("inactive");
        sb.append('=');
        sb.append(((this.inactive == null)?"<null>":this.inactive));
        sb.append(',');
        sb.append("orgUnit");
        sb.append('=');
        sb.append(((this.orgUnit == null)?"<null>":this.orgUnit));
        sb.append(',');
        sb.append("programOwners");
        sb.append('=');
        sb.append(((this.programOwners == null)?"<null>":this.programOwners));
        sb.append(',');
        sb.append("relationships");
        sb.append('=');
        sb.append(((this.relationships == null)?"<null>":this.relationships));
        sb.append(',');
        sb.append("storedBy");
        sb.append('=');
        sb.append(((this.storedBy == null)?"<null>":this.storedBy));
        sb.append(',');
        sb.append("trackedEntity");
        sb.append('=');
        sb.append(((this.trackedEntity == null)?"<null>":this.trackedEntity));
        sb.append(',');
        sb.append("trackedEntityType");
        sb.append('=');
        sb.append(((this.trackedEntityType == null)?"<null>":this.trackedEntityType));
        sb.append(',');
        sb.append("updatedAt");
        sb.append('=');
        sb.append(((this.updatedAt == null)?"<null>":this.updatedAt));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.trackedEntity == null)? 0 :this.trackedEntity.hashCode()));
        result = ((result* 31)+((this.programOwners == null)? 0 :this.programOwners.hashCode()));
        result = ((result* 31)+((this.storedBy == null)? 0 :this.storedBy.hashCode()));
        result = ((result* 31)+((this.orgUnit == null)? 0 :this.orgUnit.hashCode()));
        result = ((result* 31)+((this.enrollments == null)? 0 :this.enrollments.hashCode()));
        result = ((result* 31)+((this.createdAt == null)? 0 :this.createdAt.hashCode()));
        result = ((result* 31)+((this.relationships == null)? 0 :this.relationships.hashCode()));
        result = ((result* 31)+((this.deleted == null)? 0 :this.deleted.hashCode()));
        result = ((result* 31)+((this.inactive == null)? 0 :this.inactive.hashCode()));
        result = ((result* 31)+((this.trackedEntityType == null)? 0 :this.trackedEntityType.hashCode()));
        result = ((result* 31)+((this.attributes == null)? 0 :this.attributes.hashCode()));
        result = ((result* 31)+((this.geometry == null)? 0 :this.geometry.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.updatedAt == null)? 0 :this.updatedAt.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TrackedEntity) == false) {
            return false;
        }
        TrackedEntity rhs = ((TrackedEntity) other);
        return (((((((((((((((this.trackedEntity == rhs.trackedEntity)||((this.trackedEntity!= null)&&this.trackedEntity.equals(rhs.trackedEntity)))&&((this.programOwners == rhs.programOwners)||((this.programOwners!= null)&&this.programOwners.equals(rhs.programOwners))))&&((this.storedBy == rhs.storedBy)||((this.storedBy!= null)&&this.storedBy.equals(rhs.storedBy))))&&((this.orgUnit == rhs.orgUnit)||((this.orgUnit!= null)&&this.orgUnit.equals(rhs.orgUnit))))&&((this.enrollments == rhs.enrollments)||((this.enrollments!= null)&&this.enrollments.equals(rhs.enrollments))))&&((this.createdAt == rhs.createdAt)||((this.createdAt!= null)&&this.createdAt.equals(rhs.createdAt))))&&((this.relationships == rhs.relationships)||((this.relationships!= null)&&this.relationships.equals(rhs.relationships))))&&((this.deleted == rhs.deleted)||((this.deleted!= null)&&this.deleted.equals(rhs.deleted))))&&((this.inactive == rhs.inactive)||((this.inactive!= null)&&this.inactive.equals(rhs.inactive))))&&((this.trackedEntityType == rhs.trackedEntityType)||((this.trackedEntityType!= null)&&this.trackedEntityType.equals(rhs.trackedEntityType))))&&((this.attributes == rhs.attributes)||((this.attributes!= null)&&this.attributes.equals(rhs.attributes))))&&((this.geometry == rhs.geometry)||((this.geometry!= null)&&this.geometry.equals(rhs.geometry))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.updatedAt == rhs.updatedAt)||((this.updatedAt!= null)&&this.updatedAt.equals(rhs.updatedAt))));
    }

}
