
package org.hisp.dhis.api.model.v2_35_13;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "axis",
    "dimensionItem",
    "type"
})
@Generated("jsonschema2pojo")
public class Series__1 implements Serializable
{

    @JsonProperty("axis")
    private Integer axis;
    @JsonProperty("dimensionItem")
    private String dimensionItem;
    @JsonProperty("type")
    private Series__1 .VisualizationType type;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 7592036390762419018L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Series__1() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public Series__1(Series__1 source) {
        super();
        this.axis = source.axis;
        this.dimensionItem = source.dimensionItem;
        this.type = source.type;
    }

    public Series__1(Integer axis, String dimensionItem, Series__1 .VisualizationType type) {
        super();
        this.axis = axis;
        this.dimensionItem = dimensionItem;
        this.type = type;
    }

    @JsonProperty("axis")
    public Optional<Integer> getAxis() {
        return Optional.ofNullable(axis);
    }

    @JsonProperty("axis")
    public void setAxis(Integer axis) {
        this.axis = axis;
    }

    public Series__1 withAxis(Integer axis) {
        this.axis = axis;
        return this;
    }

    @JsonProperty("dimensionItem")
    public Optional<String> getDimensionItem() {
        return Optional.ofNullable(dimensionItem);
    }

    @JsonProperty("dimensionItem")
    public void setDimensionItem(String dimensionItem) {
        this.dimensionItem = dimensionItem;
    }

    public Series__1 withDimensionItem(String dimensionItem) {
        this.dimensionItem = dimensionItem;
        return this;
    }

    @JsonProperty("type")
    public Optional<Series__1 .VisualizationType> getType() {
        return Optional.ofNullable(type);
    }

    @JsonProperty("type")
    public void setType(Series__1 .VisualizationType type) {
        this.type = type;
    }

    public Series__1 withType(Series__1 .VisualizationType type) {
        this.type = type;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Series__1 withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("axis".equals(name)) {
            if (value instanceof Integer) {
                setAxis(((Integer) value));
            } else {
                throw new IllegalArgumentException(("property \"axis\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("dimensionItem".equals(name)) {
                if (value instanceof String) {
                    setDimensionItem(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"dimensionItem\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("type".equals(name)) {
                    if (value instanceof Series__1 .VisualizationType) {
                        setType(((Series__1 .VisualizationType) value));
                    } else {
                        throw new IllegalArgumentException(("property \"type\" is of type \"org.hisp.dhis.api.model.v2_35_13.Series__1.VisualizationType\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    return false;
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("axis".equals(name)) {
            return getAxis();
        } else {
            if ("dimensionItem".equals(name)) {
                return getDimensionItem();
            } else {
                if ("type".equals(name)) {
                    return getType();
                } else {
                    return notFoundValue;
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, Series__1 .NOT_FOUND_VALUE);
        if (Series__1 .NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public Series__1 with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Series__1 .class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("axis");
        sb.append('=');
        sb.append(((this.axis == null)?"<null>":this.axis));
        sb.append(',');
        sb.append("dimensionItem");
        sb.append('=');
        sb.append(((this.dimensionItem == null)?"<null>":this.dimensionItem));
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(((this.type == null)?"<null>":this.type));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.axis == null)? 0 :this.axis.hashCode()));
        result = ((result* 31)+((this.dimensionItem == null)? 0 :this.dimensionItem.hashCode()));
        result = ((result* 31)+((this.type == null)? 0 :this.type.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Series__1) == false) {
            return false;
        }
        Series__1 rhs = ((Series__1) other);
        return (((((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties)))&&((this.axis == rhs.axis)||((this.axis!= null)&&this.axis.equals(rhs.axis))))&&((this.dimensionItem == rhs.dimensionItem)||((this.dimensionItem!= null)&&this.dimensionItem.equals(rhs.dimensionItem))))&&((this.type == rhs.type)||((this.type!= null)&&this.type.equals(rhs.type))));
    }

    @Generated("jsonschema2pojo")
    public enum VisualizationType {

        COLUMN("COLUMN"),
        STACKED_COLUMN("STACKED_COLUMN"),
        BAR("BAR"),
        STACKED_BAR("STACKED_BAR"),
        LINE("LINE"),
        AREA("AREA"),
        STACKED_AREA("STACKED_AREA"),
        PIE("PIE"),
        RADAR("RADAR"),
        GAUGE("GAUGE"),
        YEAR_OVER_YEAR_LINE("YEAR_OVER_YEAR_LINE"),
        YEAR_OVER_YEAR_COLUMN("YEAR_OVER_YEAR_COLUMN"),
        SINGLE_VALUE("SINGLE_VALUE"),
        PIVOT_TABLE("PIVOT_TABLE");
        private final String value;
        private final static Map<String, Series__1 .VisualizationType> CONSTANTS = new HashMap<String, Series__1 .VisualizationType>();

        static {
            for (Series__1 .VisualizationType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        VisualizationType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Series__1 .VisualizationType fromValue(String value) {
            Series__1 .VisualizationType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
