
package org.hisp.dhis.api.model.v2_35_13;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "fileResource",
    "responseType"
})
@Generated("jsonschema2pojo")
public class FileResourceWebMessageResponse implements Serializable
{

    @JsonProperty("fileResource")
    private FileResource fileResource;
    @JsonProperty("responseType")
    private String responseType;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 4239128273737747393L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public FileResourceWebMessageResponse() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public FileResourceWebMessageResponse(FileResourceWebMessageResponse source) {
        super();
        this.fileResource = source.fileResource;
        this.responseType = source.responseType;
    }

    public FileResourceWebMessageResponse(FileResource fileResource, String responseType) {
        super();
        this.fileResource = fileResource;
        this.responseType = responseType;
    }

    @JsonProperty("fileResource")
    public Optional<FileResource> getFileResource() {
        return Optional.ofNullable(fileResource);
    }

    @JsonProperty("fileResource")
    public void setFileResource(FileResource fileResource) {
        this.fileResource = fileResource;
    }

    public FileResourceWebMessageResponse withFileResource(FileResource fileResource) {
        this.fileResource = fileResource;
        return this;
    }

    @JsonProperty("responseType")
    public Optional<String> getResponseType() {
        return Optional.ofNullable(responseType);
    }

    @JsonProperty("responseType")
    public void setResponseType(String responseType) {
        this.responseType = responseType;
    }

    public FileResourceWebMessageResponse withResponseType(String responseType) {
        this.responseType = responseType;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public FileResourceWebMessageResponse withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("fileResource".equals(name)) {
            if (value instanceof FileResource) {
                setFileResource(((FileResource) value));
            } else {
                throw new IllegalArgumentException(("property \"fileResource\" is of type \"org.hisp.dhis.api.model.v2_35_13.FileResource\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("responseType".equals(name)) {
                if (value instanceof String) {
                    setResponseType(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"responseType\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                return false;
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("fileResource".equals(name)) {
            return getFileResource();
        } else {
            if ("responseType".equals(name)) {
                return getResponseType();
            } else {
                return notFoundValue;
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, FileResourceWebMessageResponse.NOT_FOUND_VALUE);
        if (FileResourceWebMessageResponse.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public FileResourceWebMessageResponse with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(FileResourceWebMessageResponse.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("fileResource");
        sb.append('=');
        sb.append(((this.fileResource == null)?"<null>":this.fileResource));
        sb.append(',');
        sb.append("responseType");
        sb.append('=');
        sb.append(((this.responseType == null)?"<null>":this.responseType));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.responseType == null)? 0 :this.responseType.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.fileResource == null)? 0 :this.fileResource.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof FileResourceWebMessageResponse) == false) {
            return false;
        }
        FileResourceWebMessageResponse rhs = ((FileResourceWebMessageResponse) other);
        return ((((this.responseType == rhs.responseType)||((this.responseType!= null)&&this.responseType.equals(rhs.responseType)))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.fileResource == rhs.fileResource)||((this.fileResource!= null)&&this.fileResource.equals(rhs.fileResource))));
    }

}
