
package org.hisp.dhis.api.model.v2_35_13;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "attributeValues",
    "attribution",
    "code",
    "created",
    "displayName",
    "externalAccess",
    "favorite",
    "favorites",
    "href",
    "id",
    "imageFormat",
    "lastUpdated",
    "lastUpdatedBy",
    "layers",
    "legendSet",
    "legendSetUrl",
    "mapLayerPosition",
    "mapService",
    "name",
    "publicAccess",
    "translations",
    "url",
    "user",
    "userAccesses",
    "userGroupAccesses"
})
@Generated("jsonschema2pojo")
public class ExternalMapLayer implements Serializable
{

    @JsonProperty("access")
    private Access access;
    @JsonProperty("attributeValues")
    private List<AttributeValue> attributeValues;
    @JsonProperty("attribution")
    private String attribution;
    @JsonProperty("code")
    private String code;
    @JsonProperty("created")
    private Date created;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    @JsonProperty("favorite")
    private Boolean favorite;
    @JsonProperty("favorites")
    private List<String> favorites;
    @JsonProperty("href")
    private String href;
    @JsonProperty("id")
    private String id;
    @JsonProperty("imageFormat")
    private ExternalMapLayer.ImageFormat imageFormat;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    @JsonProperty("lastUpdatedBy")
    private User lastUpdatedBy;
    @JsonProperty("layers")
    private String layers;
    @JsonProperty("legendSet")
    private LegendSet legendSet;
    @JsonProperty("legendSetUrl")
    private String legendSetUrl;
    @JsonProperty("mapLayerPosition")
    private ExternalMapLayer.MapLayerPosition mapLayerPosition;
    @JsonProperty("mapService")
    private ExternalMapLayer.MapService mapService;
    @JsonProperty("name")
    private String name;
    @JsonProperty("publicAccess")
    private String publicAccess;
    @JsonProperty("translations")
    private List<Translation> translations;
    @JsonProperty("url")
    private String url;
    @JsonProperty("user")
    private User user;
    @JsonProperty("userAccesses")
    private List<UserAccess> userAccesses;
    @JsonProperty("userGroupAccesses")
    private List<UserGroupAccess> userGroupAccesses;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 466159783387946096L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ExternalMapLayer() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public ExternalMapLayer(ExternalMapLayer source) {
        super();
        this.access = source.access;
        this.attributeValues = source.attributeValues;
        this.attribution = source.attribution;
        this.code = source.code;
        this.created = source.created;
        this.displayName = source.displayName;
        this.externalAccess = source.externalAccess;
        this.favorite = source.favorite;
        this.favorites = source.favorites;
        this.href = source.href;
        this.id = source.id;
        this.imageFormat = source.imageFormat;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.layers = source.layers;
        this.legendSet = source.legendSet;
        this.legendSetUrl = source.legendSetUrl;
        this.mapLayerPosition = source.mapLayerPosition;
        this.mapService = source.mapService;
        this.name = source.name;
        this.publicAccess = source.publicAccess;
        this.translations = source.translations;
        this.url = source.url;
        this.user = source.user;
        this.userAccesses = source.userAccesses;
        this.userGroupAccesses = source.userGroupAccesses;
    }

    public ExternalMapLayer(Access access, List<AttributeValue> attributeValues, String attribution, String code, Date created, String displayName, Boolean externalAccess, Boolean favorite, List<String> favorites, String href, String id, ExternalMapLayer.ImageFormat imageFormat, Date lastUpdated, User lastUpdatedBy, String layers, LegendSet legendSet, String legendSetUrl, ExternalMapLayer.MapLayerPosition mapLayerPosition, ExternalMapLayer.MapService mapService, String name, String publicAccess, List<Translation> translations, String url, User user, List<UserAccess> userAccesses, List<UserGroupAccess> userGroupAccesses) {
        super();
        this.access = access;
        this.attributeValues = attributeValues;
        this.attribution = attribution;
        this.code = code;
        this.created = created;
        this.displayName = displayName;
        this.externalAccess = externalAccess;
        this.favorite = favorite;
        this.favorites = favorites;
        this.href = href;
        this.id = id;
        this.imageFormat = imageFormat;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedBy = lastUpdatedBy;
        this.layers = layers;
        this.legendSet = legendSet;
        this.legendSetUrl = legendSetUrl;
        this.mapLayerPosition = mapLayerPosition;
        this.mapService = mapService;
        this.name = name;
        this.publicAccess = publicAccess;
        this.translations = translations;
        this.url = url;
        this.user = user;
        this.userAccesses = userAccesses;
        this.userGroupAccesses = userGroupAccesses;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public ExternalMapLayer withAccess(Access access) {
        this.access = access;
        return this;
    }

    @JsonProperty("attributeValues")
    public Optional<List<AttributeValue>> getAttributeValues() {
        return Optional.ofNullable(attributeValues);
    }

    @JsonProperty("attributeValues")
    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public ExternalMapLayer withAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    @JsonProperty("attribution")
    public Optional<String> getAttribution() {
        return Optional.ofNullable(attribution);
    }

    @JsonProperty("attribution")
    public void setAttribution(String attribution) {
        this.attribution = attribution;
    }

    public ExternalMapLayer withAttribution(String attribution) {
        this.attribution = attribution;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public ExternalMapLayer withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public ExternalMapLayer withCreated(Date created) {
        this.created = created;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ExternalMapLayer withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("externalAccess")
    public Optional<Boolean> getExternalAccess() {
        return Optional.ofNullable(externalAccess);
    }

    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public ExternalMapLayer withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    @JsonProperty("favorite")
    public Optional<Boolean> getFavorite() {
        return Optional.ofNullable(favorite);
    }

    @JsonProperty("favorite")
    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public ExternalMapLayer withFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public ExternalMapLayer withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public ExternalMapLayer withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public ExternalMapLayer withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("imageFormat")
    public Optional<ExternalMapLayer.ImageFormat> getImageFormat() {
        return Optional.ofNullable(imageFormat);
    }

    @JsonProperty("imageFormat")
    public void setImageFormat(ExternalMapLayer.ImageFormat imageFormat) {
        this.imageFormat = imageFormat;
    }

    public ExternalMapLayer withImageFormat(ExternalMapLayer.ImageFormat imageFormat) {
        this.imageFormat = imageFormat;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public ExternalMapLayer withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    @JsonProperty("lastUpdatedBy")
    public Optional<User> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public ExternalMapLayer withLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    @JsonProperty("layers")
    public Optional<String> getLayers() {
        return Optional.ofNullable(layers);
    }

    @JsonProperty("layers")
    public void setLayers(String layers) {
        this.layers = layers;
    }

    public ExternalMapLayer withLayers(String layers) {
        this.layers = layers;
        return this;
    }

    @JsonProperty("legendSet")
    public Optional<LegendSet> getLegendSet() {
        return Optional.ofNullable(legendSet);
    }

    @JsonProperty("legendSet")
    public void setLegendSet(LegendSet legendSet) {
        this.legendSet = legendSet;
    }

    public ExternalMapLayer withLegendSet(LegendSet legendSet) {
        this.legendSet = legendSet;
        return this;
    }

    @JsonProperty("legendSetUrl")
    public Optional<String> getLegendSetUrl() {
        return Optional.ofNullable(legendSetUrl);
    }

    @JsonProperty("legendSetUrl")
    public void setLegendSetUrl(String legendSetUrl) {
        this.legendSetUrl = legendSetUrl;
    }

    public ExternalMapLayer withLegendSetUrl(String legendSetUrl) {
        this.legendSetUrl = legendSetUrl;
        return this;
    }

    @JsonProperty("mapLayerPosition")
    public Optional<ExternalMapLayer.MapLayerPosition> getMapLayerPosition() {
        return Optional.ofNullable(mapLayerPosition);
    }

    @JsonProperty("mapLayerPosition")
    public void setMapLayerPosition(ExternalMapLayer.MapLayerPosition mapLayerPosition) {
        this.mapLayerPosition = mapLayerPosition;
    }

    public ExternalMapLayer withMapLayerPosition(ExternalMapLayer.MapLayerPosition mapLayerPosition) {
        this.mapLayerPosition = mapLayerPosition;
        return this;
    }

    @JsonProperty("mapService")
    public Optional<ExternalMapLayer.MapService> getMapService() {
        return Optional.ofNullable(mapService);
    }

    @JsonProperty("mapService")
    public void setMapService(ExternalMapLayer.MapService mapService) {
        this.mapService = mapService;
    }

    public ExternalMapLayer withMapService(ExternalMapLayer.MapService mapService) {
        this.mapService = mapService;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public ExternalMapLayer withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("publicAccess")
    public Optional<String> getPublicAccess() {
        return Optional.ofNullable(publicAccess);
    }

    @JsonProperty("publicAccess")
    public void setPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
    }

    public ExternalMapLayer withPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public ExternalMapLayer withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    @JsonProperty("url")
    public Optional<String> getUrl() {
        return Optional.ofNullable(url);
    }

    @JsonProperty("url")
    public void setUrl(String url) {
        this.url = url;
    }

    public ExternalMapLayer withUrl(String url) {
        this.url = url;
        return this;
    }

    @JsonProperty("user")
    public Optional<User> getUser() {
        return Optional.ofNullable(user);
    }

    @JsonProperty("user")
    public void setUser(User user) {
        this.user = user;
    }

    public ExternalMapLayer withUser(User user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<UserAccess>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public ExternalMapLayer withUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<UserGroupAccess>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public ExternalMapLayer withUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ExternalMapLayer withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("access".equals(name)) {
            if (value instanceof Access) {
                setAccess(((Access) value));
            } else {
                throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v2_35_13.Access\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("attributeValues".equals(name)) {
                if (value instanceof List) {
                    setAttributeValues(((List<AttributeValue> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.AttributeValue>\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("attribution".equals(name)) {
                    if (value instanceof String) {
                        setAttribution(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"attribution\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("code".equals(name)) {
                        if (value instanceof String) {
                            setCode(((String) value));
                        } else {
                            throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("created".equals(name)) {
                            if (value instanceof Date) {
                                setCreated(((Date) value));
                            } else {
                                throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("displayName".equals(name)) {
                                if (value instanceof String) {
                                    setDisplayName(((String) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("externalAccess".equals(name)) {
                                    if (value instanceof Boolean) {
                                        setExternalAccess(((Boolean) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("favorite".equals(name)) {
                                        if (value instanceof Boolean) {
                                            setFavorite(((Boolean) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"favorite\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("favorites".equals(name)) {
                                            if (value instanceof List) {
                                                setFavorites(((List<String> ) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("href".equals(name)) {
                                                if (value instanceof String) {
                                                    setHref(((String) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("id".equals(name)) {
                                                    if (value instanceof String) {
                                                        setId(((String) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("imageFormat".equals(name)) {
                                                        if (value instanceof ExternalMapLayer.ImageFormat) {
                                                            setImageFormat(((ExternalMapLayer.ImageFormat) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"imageFormat\" is of type \"org.hisp.dhis.api.model.v2_35_13.ExternalMapLayer.ImageFormat\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("lastUpdated".equals(name)) {
                                                            if (value instanceof Date) {
                                                                setLastUpdated(((Date) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            if ("lastUpdatedBy".equals(name)) {
                                                                if (value instanceof User) {
                                                                    setLastUpdatedBy(((User) value));
                                                                } else {
                                                                    throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"org.hisp.dhis.api.model.v2_35_13.User\", but got "+ value.getClass().toString()));
                                                                }
                                                                return true;
                                                            } else {
                                                                if ("layers".equals(name)) {
                                                                    if (value instanceof String) {
                                                                        setLayers(((String) value));
                                                                    } else {
                                                                        throw new IllegalArgumentException(("property \"layers\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                    }
                                                                    return true;
                                                                } else {
                                                                    if ("legendSet".equals(name)) {
                                                                        if (value instanceof LegendSet) {
                                                                            setLegendSet(((LegendSet) value));
                                                                        } else {
                                                                            throw new IllegalArgumentException(("property \"legendSet\" is of type \"org.hisp.dhis.api.model.v2_35_13.LegendSet\", but got "+ value.getClass().toString()));
                                                                        }
                                                                        return true;
                                                                    } else {
                                                                        if ("legendSetUrl".equals(name)) {
                                                                            if (value instanceof String) {
                                                                                setLegendSetUrl(((String) value));
                                                                            } else {
                                                                                throw new IllegalArgumentException(("property \"legendSetUrl\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                            }
                                                                            return true;
                                                                        } else {
                                                                            if ("mapLayerPosition".equals(name)) {
                                                                                if (value instanceof ExternalMapLayer.MapLayerPosition) {
                                                                                    setMapLayerPosition(((ExternalMapLayer.MapLayerPosition) value));
                                                                                } else {
                                                                                    throw new IllegalArgumentException(("property \"mapLayerPosition\" is of type \"org.hisp.dhis.api.model.v2_35_13.ExternalMapLayer.MapLayerPosition\", but got "+ value.getClass().toString()));
                                                                                }
                                                                                return true;
                                                                            } else {
                                                                                if ("mapService".equals(name)) {
                                                                                    if (value instanceof ExternalMapLayer.MapService) {
                                                                                        setMapService(((ExternalMapLayer.MapService) value));
                                                                                    } else {
                                                                                        throw new IllegalArgumentException(("property \"mapService\" is of type \"org.hisp.dhis.api.model.v2_35_13.ExternalMapLayer.MapService\", but got "+ value.getClass().toString()));
                                                                                    }
                                                                                    return true;
                                                                                } else {
                                                                                    if ("name".equals(name)) {
                                                                                        if (value instanceof String) {
                                                                                            setName(((String) value));
                                                                                        } else {
                                                                                            throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                        }
                                                                                        return true;
                                                                                    } else {
                                                                                        if ("publicAccess".equals(name)) {
                                                                                            if (value instanceof String) {
                                                                                                setPublicAccess(((String) value));
                                                                                            } else {
                                                                                                throw new IllegalArgumentException(("property \"publicAccess\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                            }
                                                                                            return true;
                                                                                        } else {
                                                                                            if ("translations".equals(name)) {
                                                                                                if (value instanceof List) {
                                                                                                    setTranslations(((List<Translation> ) value));
                                                                                                } else {
                                                                                                    throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.Translation>\", but got "+ value.getClass().toString()));
                                                                                                }
                                                                                                return true;
                                                                                            } else {
                                                                                                if ("url".equals(name)) {
                                                                                                    if (value instanceof String) {
                                                                                                        setUrl(((String) value));
                                                                                                    } else {
                                                                                                        throw new IllegalArgumentException(("property \"url\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                    }
                                                                                                    return true;
                                                                                                } else {
                                                                                                    if ("user".equals(name)) {
                                                                                                        if (value instanceof User) {
                                                                                                            setUser(((User) value));
                                                                                                        } else {
                                                                                                            throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v2_35_13.User\", but got "+ value.getClass().toString()));
                                                                                                        }
                                                                                                        return true;
                                                                                                    } else {
                                                                                                        if ("userAccesses".equals(name)) {
                                                                                                            if (value instanceof List) {
                                                                                                                setUserAccesses(((List<UserAccess> ) value));
                                                                                                            } else {
                                                                                                                throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.UserAccess>\", but got "+ value.getClass().toString()));
                                                                                                            }
                                                                                                            return true;
                                                                                                        } else {
                                                                                                            if ("userGroupAccesses".equals(name)) {
                                                                                                                if (value instanceof List) {
                                                                                                                    setUserGroupAccesses(((List<UserGroupAccess> ) value));
                                                                                                                } else {
                                                                                                                    throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.UserGroupAccess>\", but got "+ value.getClass().toString()));
                                                                                                                }
                                                                                                                return true;
                                                                                                            } else {
                                                                                                                return false;
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("access".equals(name)) {
            return getAccess();
        } else {
            if ("attributeValues".equals(name)) {
                return getAttributeValues();
            } else {
                if ("attribution".equals(name)) {
                    return getAttribution();
                } else {
                    if ("code".equals(name)) {
                        return getCode();
                    } else {
                        if ("created".equals(name)) {
                            return getCreated();
                        } else {
                            if ("displayName".equals(name)) {
                                return getDisplayName();
                            } else {
                                if ("externalAccess".equals(name)) {
                                    return getExternalAccess();
                                } else {
                                    if ("favorite".equals(name)) {
                                        return getFavorite();
                                    } else {
                                        if ("favorites".equals(name)) {
                                            return getFavorites();
                                        } else {
                                            if ("href".equals(name)) {
                                                return getHref();
                                            } else {
                                                if ("id".equals(name)) {
                                                    return getId();
                                                } else {
                                                    if ("imageFormat".equals(name)) {
                                                        return getImageFormat();
                                                    } else {
                                                        if ("lastUpdated".equals(name)) {
                                                            return getLastUpdated();
                                                        } else {
                                                            if ("lastUpdatedBy".equals(name)) {
                                                                return getLastUpdatedBy();
                                                            } else {
                                                                if ("layers".equals(name)) {
                                                                    return getLayers();
                                                                } else {
                                                                    if ("legendSet".equals(name)) {
                                                                        return getLegendSet();
                                                                    } else {
                                                                        if ("legendSetUrl".equals(name)) {
                                                                            return getLegendSetUrl();
                                                                        } else {
                                                                            if ("mapLayerPosition".equals(name)) {
                                                                                return getMapLayerPosition();
                                                                            } else {
                                                                                if ("mapService".equals(name)) {
                                                                                    return getMapService();
                                                                                } else {
                                                                                    if ("name".equals(name)) {
                                                                                        return getName();
                                                                                    } else {
                                                                                        if ("publicAccess".equals(name)) {
                                                                                            return getPublicAccess();
                                                                                        } else {
                                                                                            if ("translations".equals(name)) {
                                                                                                return getTranslations();
                                                                                            } else {
                                                                                                if ("url".equals(name)) {
                                                                                                    return getUrl();
                                                                                                } else {
                                                                                                    if ("user".equals(name)) {
                                                                                                        return getUser();
                                                                                                    } else {
                                                                                                        if ("userAccesses".equals(name)) {
                                                                                                            return getUserAccesses();
                                                                                                        } else {
                                                                                                            if ("userGroupAccesses".equals(name)) {
                                                                                                                return getUserGroupAccesses();
                                                                                                            } else {
                                                                                                                return notFoundValue;
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ExternalMapLayer.NOT_FOUND_VALUE);
        if (ExternalMapLayer.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ExternalMapLayer with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ExternalMapLayer.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("attributeValues");
        sb.append('=');
        sb.append(((this.attributeValues == null)?"<null>":this.attributeValues));
        sb.append(',');
        sb.append("attribution");
        sb.append('=');
        sb.append(((this.attribution == null)?"<null>":this.attribution));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("favorite");
        sb.append('=');
        sb.append(((this.favorite == null)?"<null>":this.favorite));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("imageFormat");
        sb.append('=');
        sb.append(((this.imageFormat == null)?"<null>":this.imageFormat));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("layers");
        sb.append('=');
        sb.append(((this.layers == null)?"<null>":this.layers));
        sb.append(',');
        sb.append("legendSet");
        sb.append('=');
        sb.append(((this.legendSet == null)?"<null>":this.legendSet));
        sb.append(',');
        sb.append("legendSetUrl");
        sb.append('=');
        sb.append(((this.legendSetUrl == null)?"<null>":this.legendSetUrl));
        sb.append(',');
        sb.append("mapLayerPosition");
        sb.append('=');
        sb.append(((this.mapLayerPosition == null)?"<null>":this.mapLayerPosition));
        sb.append(',');
        sb.append("mapService");
        sb.append('=');
        sb.append(((this.mapService == null)?"<null>":this.mapService));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("publicAccess");
        sb.append('=');
        sb.append(((this.publicAccess == null)?"<null>":this.publicAccess));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("url");
        sb.append('=');
        sb.append(((this.url == null)?"<null>":this.url));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.imageFormat == null)? 0 :this.imageFormat.hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.publicAccess == null)? 0 :this.publicAccess.hashCode()));
        result = ((result* 31)+((this.legendSetUrl == null)? 0 :this.legendSetUrl.hashCode()));
        result = ((result* 31)+((this.mapService == null)? 0 :this.mapService.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.layers == null)? 0 :this.layers.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.attributeValues == null)? 0 :this.attributeValues.hashCode()));
        result = ((result* 31)+((this.mapLayerPosition == null)? 0 :this.mapLayerPosition.hashCode()));
        result = ((result* 31)+((this.url == null)? 0 :this.url.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.attribution == null)? 0 :this.attribution.hashCode()));
        result = ((result* 31)+((this.legendSet == null)? 0 :this.legendSet.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.favorite == null)? 0 :this.favorite.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ExternalMapLayer) == false) {
            return false;
        }
        ExternalMapLayer rhs = ((ExternalMapLayer) other);
        return ((((((((((((((((((((((((((((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites)))&&((this.imageFormat == rhs.imageFormat)||((this.imageFormat!= null)&&this.imageFormat.equals(rhs.imageFormat))))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.publicAccess == rhs.publicAccess)||((this.publicAccess!= null)&&this.publicAccess.equals(rhs.publicAccess))))&&((this.legendSetUrl == rhs.legendSetUrl)||((this.legendSetUrl!= null)&&this.legendSetUrl.equals(rhs.legendSetUrl))))&&((this.mapService == rhs.mapService)||((this.mapService!= null)&&this.mapService.equals(rhs.mapService))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.layers == rhs.layers)||((this.layers!= null)&&this.layers.equals(rhs.layers))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.attributeValues == rhs.attributeValues)||((this.attributeValues!= null)&&this.attributeValues.equals(rhs.attributeValues))))&&((this.mapLayerPosition == rhs.mapLayerPosition)||((this.mapLayerPosition!= null)&&this.mapLayerPosition.equals(rhs.mapLayerPosition))))&&((this.url == rhs.url)||((this.url!= null)&&this.url.equals(rhs.url))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.attribution == rhs.attribution)||((this.attribution!= null)&&this.attribution.equals(rhs.attribution))))&&((this.legendSet == rhs.legendSet)||((this.legendSet!= null)&&this.legendSet.equals(rhs.legendSet))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.favorite == rhs.favorite)||((this.favorite!= null)&&this.favorite.equals(rhs.favorite))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))));
    }

    @Generated("jsonschema2pojo")
    public enum ImageFormat {

        PNG("PNG"),
        JPG("JPG");
        private final String value;
        private final static Map<String, ExternalMapLayer.ImageFormat> CONSTANTS = new HashMap<String, ExternalMapLayer.ImageFormat>();

        static {
            for (ExternalMapLayer.ImageFormat c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ImageFormat(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ExternalMapLayer.ImageFormat fromValue(String value) {
            ExternalMapLayer.ImageFormat constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum MapLayerPosition {

        BASEMAP("BASEMAP"),
        OVERLAY("OVERLAY");
        private final String value;
        private final static Map<String, ExternalMapLayer.MapLayerPosition> CONSTANTS = new HashMap<String, ExternalMapLayer.MapLayerPosition>();

        static {
            for (ExternalMapLayer.MapLayerPosition c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        MapLayerPosition(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ExternalMapLayer.MapLayerPosition fromValue(String value) {
            ExternalMapLayer.MapLayerPosition constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum MapService {

        WMS("WMS"),
        TMS("TMS"),
        XYZ("XYZ");
        private final String value;
        private final static Map<String, ExternalMapLayer.MapService> CONSTANTS = new HashMap<String, ExternalMapLayer.MapService>();

        static {
            for (ExternalMapLayer.MapService c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        MapService(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ExternalMapLayer.MapService fromValue(String value) {
            ExternalMapLayer.MapService constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
