
package org.hisp.dhis.api.model.v2_35_13;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "recipients",
    "sender",
    "subject",
    "text"
})
@Generated("jsonschema2pojo")
public class Email implements Serializable
{

    @JsonProperty("recipients")
    private List<User> recipients;
    @JsonProperty("sender")
    private User sender;
    @JsonProperty("subject")
    private String subject;
    @JsonProperty("text")
    private String text;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -3865714319175785346L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Email() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public Email(Email source) {
        super();
        this.recipients = source.recipients;
        this.sender = source.sender;
        this.subject = source.subject;
        this.text = source.text;
    }

    public Email(List<User> recipients, User sender, String subject, String text) {
        super();
        this.recipients = recipients;
        this.sender = sender;
        this.subject = subject;
        this.text = text;
    }

    @JsonProperty("recipients")
    public Optional<List<User>> getRecipients() {
        return Optional.ofNullable(recipients);
    }

    @JsonProperty("recipients")
    public void setRecipients(List<User> recipients) {
        this.recipients = recipients;
    }

    public Email withRecipients(List<User> recipients) {
        this.recipients = recipients;
        return this;
    }

    @JsonProperty("sender")
    public Optional<User> getSender() {
        return Optional.ofNullable(sender);
    }

    @JsonProperty("sender")
    public void setSender(User sender) {
        this.sender = sender;
    }

    public Email withSender(User sender) {
        this.sender = sender;
        return this;
    }

    @JsonProperty("subject")
    public Optional<String> getSubject() {
        return Optional.ofNullable(subject);
    }

    @JsonProperty("subject")
    public void setSubject(String subject) {
        this.subject = subject;
    }

    public Email withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    @JsonProperty("text")
    public Optional<String> getText() {
        return Optional.ofNullable(text);
    }

    @JsonProperty("text")
    public void setText(String text) {
        this.text = text;
    }

    public Email withText(String text) {
        this.text = text;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Email withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("recipients".equals(name)) {
            if (value instanceof List) {
                setRecipients(((List<User> ) value));
            } else {
                throw new IllegalArgumentException(("property \"recipients\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.User>\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("sender".equals(name)) {
                if (value instanceof User) {
                    setSender(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"sender\" is of type \"org.hisp.dhis.api.model.v2_35_13.User\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("subject".equals(name)) {
                    if (value instanceof String) {
                        setSubject(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"subject\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("text".equals(name)) {
                        if (value instanceof String) {
                            setText(((String) value));
                        } else {
                            throw new IllegalArgumentException(("property \"text\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("recipients".equals(name)) {
            return getRecipients();
        } else {
            if ("sender".equals(name)) {
                return getSender();
            } else {
                if ("subject".equals(name)) {
                    return getSubject();
                } else {
                    if ("text".equals(name)) {
                        return getText();
                    } else {
                        return notFoundValue;
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, Email.NOT_FOUND_VALUE);
        if (Email.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public Email with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Email.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("recipients");
        sb.append('=');
        sb.append(((this.recipients == null)?"<null>":this.recipients));
        sb.append(',');
        sb.append("sender");
        sb.append('=');
        sb.append(((this.sender == null)?"<null>":this.sender));
        sb.append(',');
        sb.append("subject");
        sb.append('=');
        sb.append(((this.subject == null)?"<null>":this.subject));
        sb.append(',');
        sb.append("text");
        sb.append('=');
        sb.append(((this.text == null)?"<null>":this.text));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.sender == null)? 0 :this.sender.hashCode()));
        result = ((result* 31)+((this.recipients == null)? 0 :this.recipients.hashCode()));
        result = ((result* 31)+((this.subject == null)? 0 :this.subject.hashCode()));
        result = ((result* 31)+((this.text == null)? 0 :this.text.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Email) == false) {
            return false;
        }
        Email rhs = ((Email) other);
        return ((((((this.sender == rhs.sender)||((this.sender!= null)&&this.sender.equals(rhs.sender)))&&((this.recipients == rhs.recipients)||((this.recipients!= null)&&this.recipients.equals(rhs.recipients))))&&((this.subject == rhs.subject)||((this.subject!= null)&&this.subject.equals(rhs.subject))))&&((this.text == rhs.text)||((this.text!= null)&&this.text.equals(rhs.text))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))));
    }

}
