
package org.hisp.dhis.api.model.v2_35_13;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "code",
    "description",
    "devMessage",
    "errorCode",
    "httpStatus",
    "httpStatusCode",
    "message",
    "response",
    "status"
})
@Generated("jsonschema2pojo")
public class DescriptiveWebMessage implements Serializable
{

    @JsonProperty("code")
    private Integer code;
    @JsonProperty("description")
    private String description;
    @JsonProperty("devMessage")
    private String devMessage;
    @JsonProperty("errorCode")
    private DescriptiveWebMessage.ErrorCode errorCode;
    @JsonProperty("httpStatus")
    private String httpStatus;
    @JsonProperty("httpStatusCode")
    private Integer httpStatusCode;
    @JsonProperty("message")
    private String message;
    /**
     * Undefined
     * 
     */
    @JsonProperty("response")
    private Object response;
    @JsonProperty("status")
    private DescriptiveWebMessage.Status status;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -5418848840065195100L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DescriptiveWebMessage() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public DescriptiveWebMessage(DescriptiveWebMessage source) {
        super();
        this.code = source.code;
        this.description = source.description;
        this.devMessage = source.devMessage;
        this.errorCode = source.errorCode;
        this.httpStatus = source.httpStatus;
        this.httpStatusCode = source.httpStatusCode;
        this.message = source.message;
        this.response = source.response;
        this.status = source.status;
    }

    public DescriptiveWebMessage(Integer code, String description, String devMessage, DescriptiveWebMessage.ErrorCode errorCode, String httpStatus, Integer httpStatusCode, String message, Object response, DescriptiveWebMessage.Status status) {
        super();
        this.code = code;
        this.description = description;
        this.devMessage = devMessage;
        this.errorCode = errorCode;
        this.httpStatus = httpStatus;
        this.httpStatusCode = httpStatusCode;
        this.message = message;
        this.response = response;
        this.status = status;
    }

    @JsonProperty("code")
    public Optional<Integer> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(Integer code) {
        this.code = code;
    }

    public DescriptiveWebMessage withCode(Integer code) {
        this.code = code;
        return this;
    }

    @JsonProperty("description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    public DescriptiveWebMessage withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty("devMessage")
    public Optional<String> getDevMessage() {
        return Optional.ofNullable(devMessage);
    }

    @JsonProperty("devMessage")
    public void setDevMessage(String devMessage) {
        this.devMessage = devMessage;
    }

    public DescriptiveWebMessage withDevMessage(String devMessage) {
        this.devMessage = devMessage;
        return this;
    }

    @JsonProperty("errorCode")
    public Optional<DescriptiveWebMessage.ErrorCode> getErrorCode() {
        return Optional.ofNullable(errorCode);
    }

    @JsonProperty("errorCode")
    public void setErrorCode(DescriptiveWebMessage.ErrorCode errorCode) {
        this.errorCode = errorCode;
    }

    public DescriptiveWebMessage withErrorCode(DescriptiveWebMessage.ErrorCode errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    @JsonProperty("httpStatus")
    public Optional<String> getHttpStatus() {
        return Optional.ofNullable(httpStatus);
    }

    @JsonProperty("httpStatus")
    public void setHttpStatus(String httpStatus) {
        this.httpStatus = httpStatus;
    }

    public DescriptiveWebMessage withHttpStatus(String httpStatus) {
        this.httpStatus = httpStatus;
        return this;
    }

    @JsonProperty("httpStatusCode")
    public Optional<Integer> getHttpStatusCode() {
        return Optional.ofNullable(httpStatusCode);
    }

    @JsonProperty("httpStatusCode")
    public void setHttpStatusCode(Integer httpStatusCode) {
        this.httpStatusCode = httpStatusCode;
    }

    public DescriptiveWebMessage withHttpStatusCode(Integer httpStatusCode) {
        this.httpStatusCode = httpStatusCode;
        return this;
    }

    @JsonProperty("message")
    public Optional<String> getMessage() {
        return Optional.ofNullable(message);
    }

    @JsonProperty("message")
    public void setMessage(String message) {
        this.message = message;
    }

    public DescriptiveWebMessage withMessage(String message) {
        this.message = message;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("response")
    public Optional<Object> getResponse() {
        return Optional.ofNullable(response);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("response")
    public void setResponse(Object response) {
        this.response = response;
    }

    public DescriptiveWebMessage withResponse(Object response) {
        this.response = response;
        return this;
    }

    @JsonProperty("status")
    public Optional<DescriptiveWebMessage.Status> getStatus() {
        return Optional.ofNullable(status);
    }

    @JsonProperty("status")
    public void setStatus(DescriptiveWebMessage.Status status) {
        this.status = status;
    }

    public DescriptiveWebMessage withStatus(DescriptiveWebMessage.Status status) {
        this.status = status;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public DescriptiveWebMessage withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("code".equals(name)) {
            if (value instanceof Integer) {
                setCode(((Integer) value));
            } else {
                throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("description".equals(name)) {
                if (value instanceof String) {
                    setDescription(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"description\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("devMessage".equals(name)) {
                    if (value instanceof String) {
                        setDevMessage(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"devMessage\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("errorCode".equals(name)) {
                        if (value instanceof DescriptiveWebMessage.ErrorCode) {
                            setErrorCode(((DescriptiveWebMessage.ErrorCode) value));
                        } else {
                            throw new IllegalArgumentException(("property \"errorCode\" is of type \"org.hisp.dhis.api.model.v2_35_13.DescriptiveWebMessage.ErrorCode\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("httpStatus".equals(name)) {
                            if (value instanceof String) {
                                setHttpStatus(((String) value));
                            } else {
                                throw new IllegalArgumentException(("property \"httpStatus\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("httpStatusCode".equals(name)) {
                                if (value instanceof Integer) {
                                    setHttpStatusCode(((Integer) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"httpStatusCode\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("message".equals(name)) {
                                    if (value instanceof String) {
                                        setMessage(((String) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"message\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("response".equals(name)) {
                                        if (value instanceof Object) {
                                            setResponse(((Object) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"response\" is of type \"java.lang.Object\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("status".equals(name)) {
                                            if (value instanceof DescriptiveWebMessage.Status) {
                                                setStatus(((DescriptiveWebMessage.Status) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"status\" is of type \"org.hisp.dhis.api.model.v2_35_13.DescriptiveWebMessage.Status\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            return false;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("code".equals(name)) {
            return getCode();
        } else {
            if ("description".equals(name)) {
                return getDescription();
            } else {
                if ("devMessage".equals(name)) {
                    return getDevMessage();
                } else {
                    if ("errorCode".equals(name)) {
                        return getErrorCode();
                    } else {
                        if ("httpStatus".equals(name)) {
                            return getHttpStatus();
                        } else {
                            if ("httpStatusCode".equals(name)) {
                                return getHttpStatusCode();
                            } else {
                                if ("message".equals(name)) {
                                    return getMessage();
                                } else {
                                    if ("response".equals(name)) {
                                        return getResponse();
                                    } else {
                                        if ("status".equals(name)) {
                                            return getStatus();
                                        } else {
                                            return notFoundValue;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, DescriptiveWebMessage.NOT_FOUND_VALUE);
        if (DescriptiveWebMessage.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public DescriptiveWebMessage with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DescriptiveWebMessage.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("devMessage");
        sb.append('=');
        sb.append(((this.devMessage == null)?"<null>":this.devMessage));
        sb.append(',');
        sb.append("errorCode");
        sb.append('=');
        sb.append(((this.errorCode == null)?"<null>":this.errorCode));
        sb.append(',');
        sb.append("httpStatus");
        sb.append('=');
        sb.append(((this.httpStatus == null)?"<null>":this.httpStatus));
        sb.append(',');
        sb.append("httpStatusCode");
        sb.append('=');
        sb.append(((this.httpStatusCode == null)?"<null>":this.httpStatusCode));
        sb.append(',');
        sb.append("message");
        sb.append('=');
        sb.append(((this.message == null)?"<null>":this.message));
        sb.append(',');
        sb.append("response");
        sb.append('=');
        sb.append(((this.response == null)?"<null>":this.response));
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(((this.status == null)?"<null>":this.status));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.response == null)? 0 :this.response.hashCode()));
        result = ((result* 31)+((this.httpStatus == null)? 0 :this.httpStatus.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.errorCode == null)? 0 :this.errorCode.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.devMessage == null)? 0 :this.devMessage.hashCode()));
        result = ((result* 31)+((this.message == null)? 0 :this.message.hashCode()));
        result = ((result* 31)+((this.httpStatusCode == null)? 0 :this.httpStatusCode.hashCode()));
        result = ((result* 31)+((this.status == null)? 0 :this.status.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof DescriptiveWebMessage) == false) {
            return false;
        }
        DescriptiveWebMessage rhs = ((DescriptiveWebMessage) other);
        return (((((((((((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code)))&&((this.response == rhs.response)||((this.response!= null)&&this.response.equals(rhs.response))))&&((this.httpStatus == rhs.httpStatus)||((this.httpStatus!= null)&&this.httpStatus.equals(rhs.httpStatus))))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.errorCode == rhs.errorCode)||((this.errorCode!= null)&&this.errorCode.equals(rhs.errorCode))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.devMessage == rhs.devMessage)||((this.devMessage!= null)&&this.devMessage.equals(rhs.devMessage))))&&((this.message == rhs.message)||((this.message!= null)&&this.message.equals(rhs.message))))&&((this.httpStatusCode == rhs.httpStatusCode)||((this.httpStatusCode!= null)&&this.httpStatusCode.equals(rhs.httpStatusCode))))&&((this.status == rhs.status)||((this.status!= null)&&this.status.equals(rhs.status))));
    }

    @Generated("jsonschema2pojo")
    public enum ErrorCode {

        E_1000("E1000"),
        E_1001("E1001"),
        E_1002("E1002"),
        E_2000("E2000"),
        E_2001("E2001"),
        E_2002("E2002"),
        E_2003("E2003"),
        E_2004("E2004"),
        E_2005("E2005"),
        E_2006("E2006"),
        E_2007("E2007"),
        E_2008("E2008"),
        E_2009("E2009"),
        E_2010("E2010"),
        E_2011("E2011"),
        E_2012("E2012"),
        E_2013("E2013"),
        E_2014("E2014"),
        E_2015("E2015"),
        E_2016("E2016"),
        E_2017("E2017"),
        E_2018("E2018"),
        E_2019("E2019"),
        E_2020("E2020"),
        E_3000("E3000"),
        E_3001("E3001"),
        E_3002("E3002"),
        E_3003("E3003"),
        E_3004("E3004"),
        E_3005("E3005"),
        E_3006("E3006"),
        E_3008("E3008"),
        E_3009("E3009"),
        E_3010("E3010"),
        E_3011("E3011"),
        E_3012("E3012"),
        E_4000("E4000"),
        E_4001("E4001"),
        E_4002("E4002"),
        E_4003("E4003"),
        E_4004("E4004"),
        E_4005("E4005"),
        E_4006("E4006"),
        E_4007("E4007"),
        E_4008("E4008"),
        E_4009("E4009"),
        E_4010("E4010"),
        E_4011("E4011"),
        E_4012("E4012"),
        E_4013("E4013"),
        E_4014("E4014"),
        E_4015("E4015"),
        E_4016("E4016"),
        E_4017("E4017"),
        E_4018("E4018"),
        E_4019("E4019"),
        E_4020("E4020"),
        E_4021("E4021"),
        E_4022("E4022"),
        E_4023("E4023"),
        E_4024("E4024"),
        E_4025("E4025"),
        E_4026("E4026"),
        E_4027("E4027"),
        E_4028("E4028"),
        E_4029("E4029"),
        E_4030("E4030"),
        E_4032("E4032"),
        E_4033("E4033"),
        E_4300("E4300"),
        E_4301("E4301"),
        E_4302("E4302"),
        E_4303("E4303"),
        E_4304("E4304"),
        E_4305("E4305"),
        E_4306("E4306"),
        E_4307("E4307"),
        E_4308("E4308"),
        E_4309("E4309"),
        E_4310("E4310"),
        E_4311("E4311"),
        E_5000("E5000"),
        E_5001("E5001"),
        E_5002("E5002"),
        E_5003("E5003"),
        E_5004("E5004"),
        E_6000("E6000"),
        E_6001("E6001"),
        E_6100("E6100"),
        E_6101("E6101"),
        E_6200("E6200"),
        E_7000("E7000"),
        E_7002("E7002"),
        E_7003("E7003"),
        E_7004("E7004"),
        E_7005("E7005"),
        E_7006("E7006"),
        E_7007("E7007"),
        E_7010("E7010"),
        E_7100("E7100"),
        E_7101("E7101"),
        E_7102("E7102"),
        E_7103("E7103"),
        E_7104("E7104"),
        E_7105("E7105"),
        E_7106("E7106"),
        E_7107("E7107"),
        E_7108("E7108"),
        E_7109("E7109"),
        E_7110("E7110"),
        E_7111("E7111"),
        E_7112("E7112"),
        E_7113("E7113"),
        E_7114("E7114"),
        E_7115("E7115"),
        E_7116("E7116"),
        E_7117("E7117"),
        E_7118("E7118"),
        E_7119("E7119"),
        E_7120("E7120"),
        E_7121("E7121"),
        E_7122("E7122"),
        E_7123("E7123"),
        E_7124("E7124"),
        E_7125("E7125"),
        E_7126("E7126"),
        E_7127("E7127"),
        E_7128("E7128"),
        E_7129("E7129"),
        E_7130("E7130"),
        E_7131("E7131"),
        E_7132("E7132"),
        E_7133("E7133"),
        E_7200("E7200"),
        E_7201("E7201"),
        E_7202("E7202"),
        E_7203("E7203"),
        E_7204("E7204"),
        E_7205("E7205"),
        E_7206("E7206"),
        E_7207("E7207"),
        E_7208("E7208"),
        E_7209("E7209"),
        E_7210("E7210"),
        E_7211("E7211"),
        E_7212("E7212"),
        E_7213("E7213"),
        E_7214("E7214"),
        E_7215("E7215"),
        E_7216("E7216"),
        E_7217("E7217"),
        E_7218("E7218"),
        E_7219("E7219"),
        E_7220("E7220"),
        E_7221("E7221"),
        E_7222("E7222"),
        E_7223("E7223"),
        E_7224("E7224"),
        E_7225("E7225"),
        E_7226("E7226"),
        E_7227("E7227"),
        E_7300("E7300"),
        E_7301("E7301"),
        E_7400("E7400");
        private final String value;
        private final static Map<String, DescriptiveWebMessage.ErrorCode> CONSTANTS = new HashMap<String, DescriptiveWebMessage.ErrorCode>();

        static {
            for (DescriptiveWebMessage.ErrorCode c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ErrorCode(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DescriptiveWebMessage.ErrorCode fromValue(String value) {
            DescriptiveWebMessage.ErrorCode constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum Status {

        OK("OK"),
        WARNING("WARNING"),
        ERROR("ERROR");
        private final String value;
        private final static Map<String, DescriptiveWebMessage.Status> CONSTANTS = new HashMap<String, DescriptiveWebMessage.Status>();

        static {
            for (DescriptiveWebMessage.Status c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        Status(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DescriptiveWebMessage.Status fromValue(String value) {
            DescriptiveWebMessage.Status constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
