
package org.hisp.dhis.api.model.v2_35_13;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "mayAccept",
    "mayApprove",
    "mayReadData",
    "mayUnaccept",
    "mayUnapprove",
    "state"
})
@Generated("jsonschema2pojo")
public class DataApprovalPermissions implements Serializable
{

    @JsonProperty("mayAccept")
    private Boolean mayAccept;
    @JsonProperty("mayApprove")
    private Boolean mayApprove;
    @JsonProperty("mayReadData")
    private Boolean mayReadData;
    @JsonProperty("mayUnaccept")
    private Boolean mayUnaccept;
    @JsonProperty("mayUnapprove")
    private Boolean mayUnapprove;
    @JsonProperty("state")
    private String state;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 8680275705228903771L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DataApprovalPermissions() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public DataApprovalPermissions(DataApprovalPermissions source) {
        super();
        this.mayAccept = source.mayAccept;
        this.mayApprove = source.mayApprove;
        this.mayReadData = source.mayReadData;
        this.mayUnaccept = source.mayUnaccept;
        this.mayUnapprove = source.mayUnapprove;
        this.state = source.state;
    }

    public DataApprovalPermissions(Boolean mayAccept, Boolean mayApprove, Boolean mayReadData, Boolean mayUnaccept, Boolean mayUnapprove, String state) {
        super();
        this.mayAccept = mayAccept;
        this.mayApprove = mayApprove;
        this.mayReadData = mayReadData;
        this.mayUnaccept = mayUnaccept;
        this.mayUnapprove = mayUnapprove;
        this.state = state;
    }

    @JsonProperty("mayAccept")
    public Optional<Boolean> getMayAccept() {
        return Optional.ofNullable(mayAccept);
    }

    @JsonProperty("mayAccept")
    public void setMayAccept(Boolean mayAccept) {
        this.mayAccept = mayAccept;
    }

    public DataApprovalPermissions withMayAccept(Boolean mayAccept) {
        this.mayAccept = mayAccept;
        return this;
    }

    @JsonProperty("mayApprove")
    public Optional<Boolean> getMayApprove() {
        return Optional.ofNullable(mayApprove);
    }

    @JsonProperty("mayApprove")
    public void setMayApprove(Boolean mayApprove) {
        this.mayApprove = mayApprove;
    }

    public DataApprovalPermissions withMayApprove(Boolean mayApprove) {
        this.mayApprove = mayApprove;
        return this;
    }

    @JsonProperty("mayReadData")
    public Optional<Boolean> getMayReadData() {
        return Optional.ofNullable(mayReadData);
    }

    @JsonProperty("mayReadData")
    public void setMayReadData(Boolean mayReadData) {
        this.mayReadData = mayReadData;
    }

    public DataApprovalPermissions withMayReadData(Boolean mayReadData) {
        this.mayReadData = mayReadData;
        return this;
    }

    @JsonProperty("mayUnaccept")
    public Optional<Boolean> getMayUnaccept() {
        return Optional.ofNullable(mayUnaccept);
    }

    @JsonProperty("mayUnaccept")
    public void setMayUnaccept(Boolean mayUnaccept) {
        this.mayUnaccept = mayUnaccept;
    }

    public DataApprovalPermissions withMayUnaccept(Boolean mayUnaccept) {
        this.mayUnaccept = mayUnaccept;
        return this;
    }

    @JsonProperty("mayUnapprove")
    public Optional<Boolean> getMayUnapprove() {
        return Optional.ofNullable(mayUnapprove);
    }

    @JsonProperty("mayUnapprove")
    public void setMayUnapprove(Boolean mayUnapprove) {
        this.mayUnapprove = mayUnapprove;
    }

    public DataApprovalPermissions withMayUnapprove(Boolean mayUnapprove) {
        this.mayUnapprove = mayUnapprove;
        return this;
    }

    @JsonProperty("state")
    public Optional<String> getState() {
        return Optional.ofNullable(state);
    }

    @JsonProperty("state")
    public void setState(String state) {
        this.state = state;
    }

    public DataApprovalPermissions withState(String state) {
        this.state = state;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public DataApprovalPermissions withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("mayAccept".equals(name)) {
            if (value instanceof Boolean) {
                setMayAccept(((Boolean) value));
            } else {
                throw new IllegalArgumentException(("property \"mayAccept\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("mayApprove".equals(name)) {
                if (value instanceof Boolean) {
                    setMayApprove(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"mayApprove\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("mayReadData".equals(name)) {
                    if (value instanceof Boolean) {
                        setMayReadData(((Boolean) value));
                    } else {
                        throw new IllegalArgumentException(("property \"mayReadData\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("mayUnaccept".equals(name)) {
                        if (value instanceof Boolean) {
                            setMayUnaccept(((Boolean) value));
                        } else {
                            throw new IllegalArgumentException(("property \"mayUnaccept\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("mayUnapprove".equals(name)) {
                            if (value instanceof Boolean) {
                                setMayUnapprove(((Boolean) value));
                            } else {
                                throw new IllegalArgumentException(("property \"mayUnapprove\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("state".equals(name)) {
                                if (value instanceof String) {
                                    setState(((String) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"state\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                return false;
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("mayAccept".equals(name)) {
            return getMayAccept();
        } else {
            if ("mayApprove".equals(name)) {
                return getMayApprove();
            } else {
                if ("mayReadData".equals(name)) {
                    return getMayReadData();
                } else {
                    if ("mayUnaccept".equals(name)) {
                        return getMayUnaccept();
                    } else {
                        if ("mayUnapprove".equals(name)) {
                            return getMayUnapprove();
                        } else {
                            if ("state".equals(name)) {
                                return getState();
                            } else {
                                return notFoundValue;
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, DataApprovalPermissions.NOT_FOUND_VALUE);
        if (DataApprovalPermissions.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public DataApprovalPermissions with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DataApprovalPermissions.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("mayAccept");
        sb.append('=');
        sb.append(((this.mayAccept == null)?"<null>":this.mayAccept));
        sb.append(',');
        sb.append("mayApprove");
        sb.append('=');
        sb.append(((this.mayApprove == null)?"<null>":this.mayApprove));
        sb.append(',');
        sb.append("mayReadData");
        sb.append('=');
        sb.append(((this.mayReadData == null)?"<null>":this.mayReadData));
        sb.append(',');
        sb.append("mayUnaccept");
        sb.append('=');
        sb.append(((this.mayUnaccept == null)?"<null>":this.mayUnaccept));
        sb.append(',');
        sb.append("mayUnapprove");
        sb.append('=');
        sb.append(((this.mayUnapprove == null)?"<null>":this.mayUnapprove));
        sb.append(',');
        sb.append("state");
        sb.append('=');
        sb.append(((this.state == null)?"<null>":this.state));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.mayUnaccept == null)? 0 :this.mayUnaccept.hashCode()));
        result = ((result* 31)+((this.mayUnapprove == null)? 0 :this.mayUnapprove.hashCode()));
        result = ((result* 31)+((this.state == null)? 0 :this.state.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.mayReadData == null)? 0 :this.mayReadData.hashCode()));
        result = ((result* 31)+((this.mayApprove == null)? 0 :this.mayApprove.hashCode()));
        result = ((result* 31)+((this.mayAccept == null)? 0 :this.mayAccept.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof DataApprovalPermissions) == false) {
            return false;
        }
        DataApprovalPermissions rhs = ((DataApprovalPermissions) other);
        return ((((((((this.mayUnaccept == rhs.mayUnaccept)||((this.mayUnaccept!= null)&&this.mayUnaccept.equals(rhs.mayUnaccept)))&&((this.mayUnapprove == rhs.mayUnapprove)||((this.mayUnapprove!= null)&&this.mayUnapprove.equals(rhs.mayUnapprove))))&&((this.state == rhs.state)||((this.state!= null)&&this.state.equals(rhs.state))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.mayReadData == rhs.mayReadData)||((this.mayReadData!= null)&&this.mayReadData.equals(rhs.mayReadData))))&&((this.mayApprove == rhs.mayApprove)||((this.mayApprove!= null)&&this.mayApprove.equals(rhs.mayApprove))))&&((this.mayAccept == rhs.mayAccept)||((this.mayAccept!= null)&&this.mayAccept.equals(rhs.mayAccept))));
    }

}
