
package org.hisp.dhis.api.model.v2_35_13;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "aggregationType",
    "attributeDimensions",
    "attributeValues",
    "categoryDimensions",
    "categoryOptionGroupSetDimensions",
    "code",
    "columns",
    "completedOnly",
    "created",
    "dataDimensionItems",
    "dataElementDimensions",
    "dataElementGroupSetDimensions",
    "description",
    "digitGroupSeparator",
    "displayDescription",
    "displayFormName",
    "displayName",
    "displayShortName",
    "displaySubtitle",
    "displayTitle",
    "endDate",
    "externalAccess",
    "favorite",
    "favorites",
    "filters",
    "formName",
    "hideSubtitle",
    "hideTitle",
    "href",
    "id",
    "interpretations",
    "itemOrganisationUnitGroups",
    "lastUpdated",
    "lastUpdatedBy",
    "name",
    "orgUnitField",
    "organisationUnitGroupSetDimensions",
    "organisationUnitLevels",
    "organisationUnits",
    "parentGraphMap",
    "periods",
    "programIndicatorDimensions",
    "publicAccess",
    "relativePeriods",
    "rows",
    "shortName",
    "sortOrder",
    "startDate",
    "subscribed",
    "subscribers",
    "subtitle",
    "timeField",
    "title",
    "topLimit",
    "translations",
    "user",
    "userAccesses",
    "userGroupAccesses",
    "userOrgUnitType",
    "userOrganisationUnit",
    "userOrganisationUnitChildren",
    "userOrganisationUnitGrandChildren"
})
@Generated("jsonschema2pojo")
public class BaseAnalyticalObject implements Serializable
{

    @JsonProperty("access")
    private Access access;
    @JsonProperty("aggregationType")
    private AggregationType aggregationType;
    @JsonProperty("attributeDimensions")
    private List<TrackedEntityAttributeDimension> attributeDimensions;
    @JsonProperty("attributeValues")
    private List<AttributeValue> attributeValues;
    @JsonProperty("categoryDimensions")
    private List<CategoryDimension> categoryDimensions;
    @JsonProperty("categoryOptionGroupSetDimensions")
    private List<CategoryOptionGroupSetDimension> categoryOptionGroupSetDimensions;
    @JsonProperty("code")
    private String code;
    @JsonProperty("columns")
    private List<Object> columns;
    @JsonProperty("completedOnly")
    private Boolean completedOnly;
    @JsonProperty("created")
    private Date created;
    @JsonProperty("dataDimensionItems")
    private List<DataDimensionItem> dataDimensionItems;
    @JsonProperty("dataElementDimensions")
    private List<TrackedEntityDataElementDimension> dataElementDimensions;
    @JsonProperty("dataElementGroupSetDimensions")
    private List<DataElementGroupSetDimension> dataElementGroupSetDimensions;
    @JsonProperty("description")
    private String description;
    @JsonProperty("digitGroupSeparator")
    private org.hisp.dhis.api.model.v2_35_13.Chart.DigitGroupSeparator digitGroupSeparator;
    @JsonProperty("displayDescription")
    private String displayDescription;
    @JsonProperty("displayFormName")
    private String displayFormName;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("displayShortName")
    private String displayShortName;
    @JsonProperty("displaySubtitle")
    private String displaySubtitle;
    @JsonProperty("displayTitle")
    private String displayTitle;
    @JsonProperty("endDate")
    private Date endDate;
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    @JsonProperty("favorite")
    private Boolean favorite;
    @JsonProperty("favorites")
    private List<String> favorites;
    @JsonProperty("filters")
    private List<Object> filters;
    @JsonProperty("formName")
    private String formName;
    @JsonProperty("hideSubtitle")
    private Boolean hideSubtitle;
    @JsonProperty("hideTitle")
    private Boolean hideTitle;
    @JsonProperty("href")
    private String href;
    @JsonProperty("id")
    private String id;
    @JsonProperty("interpretations")
    private List<Interpretation> interpretations;
    @JsonProperty("itemOrganisationUnitGroups")
    private List<OrganisationUnitGroup> itemOrganisationUnitGroups;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    @JsonProperty("lastUpdatedBy")
    private User lastUpdatedBy;
    @JsonProperty("name")
    private String name;
    @JsonProperty("orgUnitField")
    private String orgUnitField;
    @JsonProperty("organisationUnitGroupSetDimensions")
    private List<OrganisationUnitGroupSetDimension> organisationUnitGroupSetDimensions;
    @JsonProperty("organisationUnitLevels")
    private List<Integer> organisationUnitLevels;
    @JsonProperty("organisationUnits")
    private List<OrganisationUnit> organisationUnits;
    /**
     * Undefined
     * 
     */
    @JsonProperty("parentGraphMap")
    private ParentGraphMap__6 parentGraphMap;
    @JsonProperty("periods")
    private List<Period> periods;
    @JsonProperty("programIndicatorDimensions")
    private List<TrackedEntityProgramIndicatorDimension> programIndicatorDimensions;
    @JsonProperty("publicAccess")
    private String publicAccess;
    @JsonProperty("relativePeriods")
    private RelativePeriods relativePeriods;
    @JsonProperty("rows")
    private List<Object> rows;
    @JsonProperty("shortName")
    private String shortName;
    @JsonProperty("sortOrder")
    private Integer sortOrder;
    @JsonProperty("startDate")
    private Date startDate;
    @JsonProperty("subscribed")
    private Boolean subscribed;
    @JsonProperty("subscribers")
    private List<String> subscribers;
    @JsonProperty("subtitle")
    private String subtitle;
    @JsonProperty("timeField")
    private String timeField;
    @JsonProperty("title")
    private String title;
    @JsonProperty("topLimit")
    private Integer topLimit;
    @JsonProperty("translations")
    private List<Translation> translations;
    @JsonProperty("user")
    private User user;
    @JsonProperty("userAccesses")
    private List<UserAccess> userAccesses;
    @JsonProperty("userGroupAccesses")
    private List<UserGroupAccess> userGroupAccesses;
    @JsonProperty("userOrgUnitType")
    private org.hisp.dhis.api.model.v2_35_13.Chart.UserOrgUnitType userOrgUnitType;
    @JsonProperty("userOrganisationUnit")
    private Boolean userOrganisationUnit;
    @JsonProperty("userOrganisationUnitChildren")
    private Boolean userOrganisationUnitChildren;
    @JsonProperty("userOrganisationUnitGrandChildren")
    private Boolean userOrganisationUnitGrandChildren;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 6787383377705105635L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public BaseAnalyticalObject() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public BaseAnalyticalObject(BaseAnalyticalObject source) {
        super();
        this.access = source.access;
        this.aggregationType = source.aggregationType;
        this.attributeDimensions = source.attributeDimensions;
        this.attributeValues = source.attributeValues;
        this.categoryDimensions = source.categoryDimensions;
        this.categoryOptionGroupSetDimensions = source.categoryOptionGroupSetDimensions;
        this.code = source.code;
        this.columns = source.columns;
        this.completedOnly = source.completedOnly;
        this.created = source.created;
        this.dataDimensionItems = source.dataDimensionItems;
        this.dataElementDimensions = source.dataElementDimensions;
        this.dataElementGroupSetDimensions = source.dataElementGroupSetDimensions;
        this.description = source.description;
        this.digitGroupSeparator = source.digitGroupSeparator;
        this.displayDescription = source.displayDescription;
        this.displayFormName = source.displayFormName;
        this.displayName = source.displayName;
        this.displayShortName = source.displayShortName;
        this.displaySubtitle = source.displaySubtitle;
        this.displayTitle = source.displayTitle;
        this.endDate = source.endDate;
        this.externalAccess = source.externalAccess;
        this.favorite = source.favorite;
        this.favorites = source.favorites;
        this.filters = source.filters;
        this.formName = source.formName;
        this.hideSubtitle = source.hideSubtitle;
        this.hideTitle = source.hideTitle;
        this.href = source.href;
        this.id = source.id;
        this.interpretations = source.interpretations;
        this.itemOrganisationUnitGroups = source.itemOrganisationUnitGroups;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.name = source.name;
        this.orgUnitField = source.orgUnitField;
        this.organisationUnitGroupSetDimensions = source.organisationUnitGroupSetDimensions;
        this.organisationUnitLevels = source.organisationUnitLevels;
        this.organisationUnits = source.organisationUnits;
        this.parentGraphMap = source.parentGraphMap;
        this.periods = source.periods;
        this.programIndicatorDimensions = source.programIndicatorDimensions;
        this.publicAccess = source.publicAccess;
        this.relativePeriods = source.relativePeriods;
        this.rows = source.rows;
        this.shortName = source.shortName;
        this.sortOrder = source.sortOrder;
        this.startDate = source.startDate;
        this.subscribed = source.subscribed;
        this.subscribers = source.subscribers;
        this.subtitle = source.subtitle;
        this.timeField = source.timeField;
        this.title = source.title;
        this.topLimit = source.topLimit;
        this.translations = source.translations;
        this.user = source.user;
        this.userAccesses = source.userAccesses;
        this.userGroupAccesses = source.userGroupAccesses;
        this.userOrgUnitType = source.userOrgUnitType;
        this.userOrganisationUnit = source.userOrganisationUnit;
        this.userOrganisationUnitChildren = source.userOrganisationUnitChildren;
        this.userOrganisationUnitGrandChildren = source.userOrganisationUnitGrandChildren;
    }

    public BaseAnalyticalObject(Access access, AggregationType aggregationType, List<TrackedEntityAttributeDimension> attributeDimensions, List<AttributeValue> attributeValues, List<CategoryDimension> categoryDimensions, List<CategoryOptionGroupSetDimension> categoryOptionGroupSetDimensions, String code, List<Object> columns, Boolean completedOnly, Date created, List<DataDimensionItem> dataDimensionItems, List<TrackedEntityDataElementDimension> dataElementDimensions, List<DataElementGroupSetDimension> dataElementGroupSetDimensions, String description, org.hisp.dhis.api.model.v2_35_13.Chart.DigitGroupSeparator digitGroupSeparator, String displayDescription, String displayFormName, String displayName, String displayShortName, String displaySubtitle, String displayTitle, Date endDate, Boolean externalAccess, Boolean favorite, List<String> favorites, List<Object> filters, String formName, Boolean hideSubtitle, Boolean hideTitle, String href, String id, List<Interpretation> interpretations, List<OrganisationUnitGroup> itemOrganisationUnitGroups, Date lastUpdated, User lastUpdatedBy, String name, String orgUnitField, List<OrganisationUnitGroupSetDimension> organisationUnitGroupSetDimensions, List<Integer> organisationUnitLevels, List<OrganisationUnit> organisationUnits, ParentGraphMap__6 parentGraphMap, List<Period> periods, List<TrackedEntityProgramIndicatorDimension> programIndicatorDimensions, String publicAccess, RelativePeriods relativePeriods, List<Object> rows, String shortName, Integer sortOrder, Date startDate, Boolean subscribed, List<String> subscribers, String subtitle, String timeField, String title, Integer topLimit, List<Translation> translations, User user, List<UserAccess> userAccesses, List<UserGroupAccess> userGroupAccesses, org.hisp.dhis.api.model.v2_35_13.Chart.UserOrgUnitType userOrgUnitType, Boolean userOrganisationUnit, Boolean userOrganisationUnitChildren, Boolean userOrganisationUnitGrandChildren) {
        super();
        this.access = access;
        this.aggregationType = aggregationType;
        this.attributeDimensions = attributeDimensions;
        this.attributeValues = attributeValues;
        this.categoryDimensions = categoryDimensions;
        this.categoryOptionGroupSetDimensions = categoryOptionGroupSetDimensions;
        this.code = code;
        this.columns = columns;
        this.completedOnly = completedOnly;
        this.created = created;
        this.dataDimensionItems = dataDimensionItems;
        this.dataElementDimensions = dataElementDimensions;
        this.dataElementGroupSetDimensions = dataElementGroupSetDimensions;
        this.description = description;
        this.digitGroupSeparator = digitGroupSeparator;
        this.displayDescription = displayDescription;
        this.displayFormName = displayFormName;
        this.displayName = displayName;
        this.displayShortName = displayShortName;
        this.displaySubtitle = displaySubtitle;
        this.displayTitle = displayTitle;
        this.endDate = endDate;
        this.externalAccess = externalAccess;
        this.favorite = favorite;
        this.favorites = favorites;
        this.filters = filters;
        this.formName = formName;
        this.hideSubtitle = hideSubtitle;
        this.hideTitle = hideTitle;
        this.href = href;
        this.id = id;
        this.interpretations = interpretations;
        this.itemOrganisationUnitGroups = itemOrganisationUnitGroups;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedBy = lastUpdatedBy;
        this.name = name;
        this.orgUnitField = orgUnitField;
        this.organisationUnitGroupSetDimensions = organisationUnitGroupSetDimensions;
        this.organisationUnitLevels = organisationUnitLevels;
        this.organisationUnits = organisationUnits;
        this.parentGraphMap = parentGraphMap;
        this.periods = periods;
        this.programIndicatorDimensions = programIndicatorDimensions;
        this.publicAccess = publicAccess;
        this.relativePeriods = relativePeriods;
        this.rows = rows;
        this.shortName = shortName;
        this.sortOrder = sortOrder;
        this.startDate = startDate;
        this.subscribed = subscribed;
        this.subscribers = subscribers;
        this.subtitle = subtitle;
        this.timeField = timeField;
        this.title = title;
        this.topLimit = topLimit;
        this.translations = translations;
        this.user = user;
        this.userAccesses = userAccesses;
        this.userGroupAccesses = userGroupAccesses;
        this.userOrgUnitType = userOrgUnitType;
        this.userOrganisationUnit = userOrganisationUnit;
        this.userOrganisationUnitChildren = userOrganisationUnitChildren;
        this.userOrganisationUnitGrandChildren = userOrganisationUnitGrandChildren;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public BaseAnalyticalObject withAccess(Access access) {
        this.access = access;
        return this;
    }

    @JsonProperty("aggregationType")
    public Optional<AggregationType> getAggregationType() {
        return Optional.ofNullable(aggregationType);
    }

    @JsonProperty("aggregationType")
    public void setAggregationType(AggregationType aggregationType) {
        this.aggregationType = aggregationType;
    }

    public BaseAnalyticalObject withAggregationType(AggregationType aggregationType) {
        this.aggregationType = aggregationType;
        return this;
    }

    @JsonProperty("attributeDimensions")
    public Optional<List<TrackedEntityAttributeDimension>> getAttributeDimensions() {
        return Optional.ofNullable(attributeDimensions);
    }

    @JsonProperty("attributeDimensions")
    public void setAttributeDimensions(List<TrackedEntityAttributeDimension> attributeDimensions) {
        this.attributeDimensions = attributeDimensions;
    }

    public BaseAnalyticalObject withAttributeDimensions(List<TrackedEntityAttributeDimension> attributeDimensions) {
        this.attributeDimensions = attributeDimensions;
        return this;
    }

    @JsonProperty("attributeValues")
    public Optional<List<AttributeValue>> getAttributeValues() {
        return Optional.ofNullable(attributeValues);
    }

    @JsonProperty("attributeValues")
    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public BaseAnalyticalObject withAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    @JsonProperty("categoryDimensions")
    public Optional<List<CategoryDimension>> getCategoryDimensions() {
        return Optional.ofNullable(categoryDimensions);
    }

    @JsonProperty("categoryDimensions")
    public void setCategoryDimensions(List<CategoryDimension> categoryDimensions) {
        this.categoryDimensions = categoryDimensions;
    }

    public BaseAnalyticalObject withCategoryDimensions(List<CategoryDimension> categoryDimensions) {
        this.categoryDimensions = categoryDimensions;
        return this;
    }

    @JsonProperty("categoryOptionGroupSetDimensions")
    public Optional<List<CategoryOptionGroupSetDimension>> getCategoryOptionGroupSetDimensions() {
        return Optional.ofNullable(categoryOptionGroupSetDimensions);
    }

    @JsonProperty("categoryOptionGroupSetDimensions")
    public void setCategoryOptionGroupSetDimensions(List<CategoryOptionGroupSetDimension> categoryOptionGroupSetDimensions) {
        this.categoryOptionGroupSetDimensions = categoryOptionGroupSetDimensions;
    }

    public BaseAnalyticalObject withCategoryOptionGroupSetDimensions(List<CategoryOptionGroupSetDimension> categoryOptionGroupSetDimensions) {
        this.categoryOptionGroupSetDimensions = categoryOptionGroupSetDimensions;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public BaseAnalyticalObject withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("columns")
    public Optional<List<Object>> getColumns() {
        return Optional.ofNullable(columns);
    }

    @JsonProperty("columns")
    public void setColumns(List<Object> columns) {
        this.columns = columns;
    }

    public BaseAnalyticalObject withColumns(List<Object> columns) {
        this.columns = columns;
        return this;
    }

    @JsonProperty("completedOnly")
    public Optional<Boolean> getCompletedOnly() {
        return Optional.ofNullable(completedOnly);
    }

    @JsonProperty("completedOnly")
    public void setCompletedOnly(Boolean completedOnly) {
        this.completedOnly = completedOnly;
    }

    public BaseAnalyticalObject withCompletedOnly(Boolean completedOnly) {
        this.completedOnly = completedOnly;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public BaseAnalyticalObject withCreated(Date created) {
        this.created = created;
        return this;
    }

    @JsonProperty("dataDimensionItems")
    public Optional<List<DataDimensionItem>> getDataDimensionItems() {
        return Optional.ofNullable(dataDimensionItems);
    }

    @JsonProperty("dataDimensionItems")
    public void setDataDimensionItems(List<DataDimensionItem> dataDimensionItems) {
        this.dataDimensionItems = dataDimensionItems;
    }

    public BaseAnalyticalObject withDataDimensionItems(List<DataDimensionItem> dataDimensionItems) {
        this.dataDimensionItems = dataDimensionItems;
        return this;
    }

    @JsonProperty("dataElementDimensions")
    public Optional<List<TrackedEntityDataElementDimension>> getDataElementDimensions() {
        return Optional.ofNullable(dataElementDimensions);
    }

    @JsonProperty("dataElementDimensions")
    public void setDataElementDimensions(List<TrackedEntityDataElementDimension> dataElementDimensions) {
        this.dataElementDimensions = dataElementDimensions;
    }

    public BaseAnalyticalObject withDataElementDimensions(List<TrackedEntityDataElementDimension> dataElementDimensions) {
        this.dataElementDimensions = dataElementDimensions;
        return this;
    }

    @JsonProperty("dataElementGroupSetDimensions")
    public Optional<List<DataElementGroupSetDimension>> getDataElementGroupSetDimensions() {
        return Optional.ofNullable(dataElementGroupSetDimensions);
    }

    @JsonProperty("dataElementGroupSetDimensions")
    public void setDataElementGroupSetDimensions(List<DataElementGroupSetDimension> dataElementGroupSetDimensions) {
        this.dataElementGroupSetDimensions = dataElementGroupSetDimensions;
    }

    public BaseAnalyticalObject withDataElementGroupSetDimensions(List<DataElementGroupSetDimension> dataElementGroupSetDimensions) {
        this.dataElementGroupSetDimensions = dataElementGroupSetDimensions;
        return this;
    }

    @JsonProperty("description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    public BaseAnalyticalObject withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty("digitGroupSeparator")
    public Optional<org.hisp.dhis.api.model.v2_35_13.Chart.DigitGroupSeparator> getDigitGroupSeparator() {
        return Optional.ofNullable(digitGroupSeparator);
    }

    @JsonProperty("digitGroupSeparator")
    public void setDigitGroupSeparator(org.hisp.dhis.api.model.v2_35_13.Chart.DigitGroupSeparator digitGroupSeparator) {
        this.digitGroupSeparator = digitGroupSeparator;
    }

    public BaseAnalyticalObject withDigitGroupSeparator(org.hisp.dhis.api.model.v2_35_13.Chart.DigitGroupSeparator digitGroupSeparator) {
        this.digitGroupSeparator = digitGroupSeparator;
        return this;
    }

    @JsonProperty("displayDescription")
    public Optional<String> getDisplayDescription() {
        return Optional.ofNullable(displayDescription);
    }

    @JsonProperty("displayDescription")
    public void setDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
    }

    public BaseAnalyticalObject withDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
        return this;
    }

    @JsonProperty("displayFormName")
    public Optional<String> getDisplayFormName() {
        return Optional.ofNullable(displayFormName);
    }

    @JsonProperty("displayFormName")
    public void setDisplayFormName(String displayFormName) {
        this.displayFormName = displayFormName;
    }

    public BaseAnalyticalObject withDisplayFormName(String displayFormName) {
        this.displayFormName = displayFormName;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public BaseAnalyticalObject withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("displayShortName")
    public Optional<String> getDisplayShortName() {
        return Optional.ofNullable(displayShortName);
    }

    @JsonProperty("displayShortName")
    public void setDisplayShortName(String displayShortName) {
        this.displayShortName = displayShortName;
    }

    public BaseAnalyticalObject withDisplayShortName(String displayShortName) {
        this.displayShortName = displayShortName;
        return this;
    }

    @JsonProperty("displaySubtitle")
    public Optional<String> getDisplaySubtitle() {
        return Optional.ofNullable(displaySubtitle);
    }

    @JsonProperty("displaySubtitle")
    public void setDisplaySubtitle(String displaySubtitle) {
        this.displaySubtitle = displaySubtitle;
    }

    public BaseAnalyticalObject withDisplaySubtitle(String displaySubtitle) {
        this.displaySubtitle = displaySubtitle;
        return this;
    }

    @JsonProperty("displayTitle")
    public Optional<String> getDisplayTitle() {
        return Optional.ofNullable(displayTitle);
    }

    @JsonProperty("displayTitle")
    public void setDisplayTitle(String displayTitle) {
        this.displayTitle = displayTitle;
    }

    public BaseAnalyticalObject withDisplayTitle(String displayTitle) {
        this.displayTitle = displayTitle;
        return this;
    }

    @JsonProperty("endDate")
    public Optional<Date> getEndDate() {
        return Optional.ofNullable(endDate);
    }

    @JsonProperty("endDate")
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public BaseAnalyticalObject withEndDate(Date endDate) {
        this.endDate = endDate;
        return this;
    }

    @JsonProperty("externalAccess")
    public Optional<Boolean> getExternalAccess() {
        return Optional.ofNullable(externalAccess);
    }

    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public BaseAnalyticalObject withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    @JsonProperty("favorite")
    public Optional<Boolean> getFavorite() {
        return Optional.ofNullable(favorite);
    }

    @JsonProperty("favorite")
    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public BaseAnalyticalObject withFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public BaseAnalyticalObject withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    @JsonProperty("filters")
    public Optional<List<Object>> getFilters() {
        return Optional.ofNullable(filters);
    }

    @JsonProperty("filters")
    public void setFilters(List<Object> filters) {
        this.filters = filters;
    }

    public BaseAnalyticalObject withFilters(List<Object> filters) {
        this.filters = filters;
        return this;
    }

    @JsonProperty("formName")
    public Optional<String> getFormName() {
        return Optional.ofNullable(formName);
    }

    @JsonProperty("formName")
    public void setFormName(String formName) {
        this.formName = formName;
    }

    public BaseAnalyticalObject withFormName(String formName) {
        this.formName = formName;
        return this;
    }

    @JsonProperty("hideSubtitle")
    public Optional<Boolean> getHideSubtitle() {
        return Optional.ofNullable(hideSubtitle);
    }

    @JsonProperty("hideSubtitle")
    public void setHideSubtitle(Boolean hideSubtitle) {
        this.hideSubtitle = hideSubtitle;
    }

    public BaseAnalyticalObject withHideSubtitle(Boolean hideSubtitle) {
        this.hideSubtitle = hideSubtitle;
        return this;
    }

    @JsonProperty("hideTitle")
    public Optional<Boolean> getHideTitle() {
        return Optional.ofNullable(hideTitle);
    }

    @JsonProperty("hideTitle")
    public void setHideTitle(Boolean hideTitle) {
        this.hideTitle = hideTitle;
    }

    public BaseAnalyticalObject withHideTitle(Boolean hideTitle) {
        this.hideTitle = hideTitle;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public BaseAnalyticalObject withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public BaseAnalyticalObject withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("interpretations")
    public Optional<List<Interpretation>> getInterpretations() {
        return Optional.ofNullable(interpretations);
    }

    @JsonProperty("interpretations")
    public void setInterpretations(List<Interpretation> interpretations) {
        this.interpretations = interpretations;
    }

    public BaseAnalyticalObject withInterpretations(List<Interpretation> interpretations) {
        this.interpretations = interpretations;
        return this;
    }

    @JsonProperty("itemOrganisationUnitGroups")
    public Optional<List<OrganisationUnitGroup>> getItemOrganisationUnitGroups() {
        return Optional.ofNullable(itemOrganisationUnitGroups);
    }

    @JsonProperty("itemOrganisationUnitGroups")
    public void setItemOrganisationUnitGroups(List<OrganisationUnitGroup> itemOrganisationUnitGroups) {
        this.itemOrganisationUnitGroups = itemOrganisationUnitGroups;
    }

    public BaseAnalyticalObject withItemOrganisationUnitGroups(List<OrganisationUnitGroup> itemOrganisationUnitGroups) {
        this.itemOrganisationUnitGroups = itemOrganisationUnitGroups;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public BaseAnalyticalObject withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    @JsonProperty("lastUpdatedBy")
    public Optional<User> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public BaseAnalyticalObject withLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public BaseAnalyticalObject withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("orgUnitField")
    public Optional<String> getOrgUnitField() {
        return Optional.ofNullable(orgUnitField);
    }

    @JsonProperty("orgUnitField")
    public void setOrgUnitField(String orgUnitField) {
        this.orgUnitField = orgUnitField;
    }

    public BaseAnalyticalObject withOrgUnitField(String orgUnitField) {
        this.orgUnitField = orgUnitField;
        return this;
    }

    @JsonProperty("organisationUnitGroupSetDimensions")
    public Optional<List<OrganisationUnitGroupSetDimension>> getOrganisationUnitGroupSetDimensions() {
        return Optional.ofNullable(organisationUnitGroupSetDimensions);
    }

    @JsonProperty("organisationUnitGroupSetDimensions")
    public void setOrganisationUnitGroupSetDimensions(List<OrganisationUnitGroupSetDimension> organisationUnitGroupSetDimensions) {
        this.organisationUnitGroupSetDimensions = organisationUnitGroupSetDimensions;
    }

    public BaseAnalyticalObject withOrganisationUnitGroupSetDimensions(List<OrganisationUnitGroupSetDimension> organisationUnitGroupSetDimensions) {
        this.organisationUnitGroupSetDimensions = organisationUnitGroupSetDimensions;
        return this;
    }

    @JsonProperty("organisationUnitLevels")
    public Optional<List<Integer>> getOrganisationUnitLevels() {
        return Optional.ofNullable(organisationUnitLevels);
    }

    @JsonProperty("organisationUnitLevels")
    public void setOrganisationUnitLevels(List<Integer> organisationUnitLevels) {
        this.organisationUnitLevels = organisationUnitLevels;
    }

    public BaseAnalyticalObject withOrganisationUnitLevels(List<Integer> organisationUnitLevels) {
        this.organisationUnitLevels = organisationUnitLevels;
        return this;
    }

    @JsonProperty("organisationUnits")
    public Optional<List<OrganisationUnit>> getOrganisationUnits() {
        return Optional.ofNullable(organisationUnits);
    }

    @JsonProperty("organisationUnits")
    public void setOrganisationUnits(List<OrganisationUnit> organisationUnits) {
        this.organisationUnits = organisationUnits;
    }

    public BaseAnalyticalObject withOrganisationUnits(List<OrganisationUnit> organisationUnits) {
        this.organisationUnits = organisationUnits;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("parentGraphMap")
    public Optional<ParentGraphMap__6> getParentGraphMap() {
        return Optional.ofNullable(parentGraphMap);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("parentGraphMap")
    public void setParentGraphMap(ParentGraphMap__6 parentGraphMap) {
        this.parentGraphMap = parentGraphMap;
    }

    public BaseAnalyticalObject withParentGraphMap(ParentGraphMap__6 parentGraphMap) {
        this.parentGraphMap = parentGraphMap;
        return this;
    }

    @JsonProperty("periods")
    public Optional<List<Period>> getPeriods() {
        return Optional.ofNullable(periods);
    }

    @JsonProperty("periods")
    public void setPeriods(List<Period> periods) {
        this.periods = periods;
    }

    public BaseAnalyticalObject withPeriods(List<Period> periods) {
        this.periods = periods;
        return this;
    }

    @JsonProperty("programIndicatorDimensions")
    public Optional<List<TrackedEntityProgramIndicatorDimension>> getProgramIndicatorDimensions() {
        return Optional.ofNullable(programIndicatorDimensions);
    }

    @JsonProperty("programIndicatorDimensions")
    public void setProgramIndicatorDimensions(List<TrackedEntityProgramIndicatorDimension> programIndicatorDimensions) {
        this.programIndicatorDimensions = programIndicatorDimensions;
    }

    public BaseAnalyticalObject withProgramIndicatorDimensions(List<TrackedEntityProgramIndicatorDimension> programIndicatorDimensions) {
        this.programIndicatorDimensions = programIndicatorDimensions;
        return this;
    }

    @JsonProperty("publicAccess")
    public Optional<String> getPublicAccess() {
        return Optional.ofNullable(publicAccess);
    }

    @JsonProperty("publicAccess")
    public void setPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
    }

    public BaseAnalyticalObject withPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    @JsonProperty("relativePeriods")
    public Optional<RelativePeriods> getRelativePeriods() {
        return Optional.ofNullable(relativePeriods);
    }

    @JsonProperty("relativePeriods")
    public void setRelativePeriods(RelativePeriods relativePeriods) {
        this.relativePeriods = relativePeriods;
    }

    public BaseAnalyticalObject withRelativePeriods(RelativePeriods relativePeriods) {
        this.relativePeriods = relativePeriods;
        return this;
    }

    @JsonProperty("rows")
    public Optional<List<Object>> getRows() {
        return Optional.ofNullable(rows);
    }

    @JsonProperty("rows")
    public void setRows(List<Object> rows) {
        this.rows = rows;
    }

    public BaseAnalyticalObject withRows(List<Object> rows) {
        this.rows = rows;
        return this;
    }

    @JsonProperty("shortName")
    public Optional<String> getShortName() {
        return Optional.ofNullable(shortName);
    }

    @JsonProperty("shortName")
    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public BaseAnalyticalObject withShortName(String shortName) {
        this.shortName = shortName;
        return this;
    }

    @JsonProperty("sortOrder")
    public Optional<Integer> getSortOrder() {
        return Optional.ofNullable(sortOrder);
    }

    @JsonProperty("sortOrder")
    public void setSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
    }

    public BaseAnalyticalObject withSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
        return this;
    }

    @JsonProperty("startDate")
    public Optional<Date> getStartDate() {
        return Optional.ofNullable(startDate);
    }

    @JsonProperty("startDate")
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public BaseAnalyticalObject withStartDate(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    @JsonProperty("subscribed")
    public Optional<Boolean> getSubscribed() {
        return Optional.ofNullable(subscribed);
    }

    @JsonProperty("subscribed")
    public void setSubscribed(Boolean subscribed) {
        this.subscribed = subscribed;
    }

    public BaseAnalyticalObject withSubscribed(Boolean subscribed) {
        this.subscribed = subscribed;
        return this;
    }

    @JsonProperty("subscribers")
    public Optional<List<String>> getSubscribers() {
        return Optional.ofNullable(subscribers);
    }

    @JsonProperty("subscribers")
    public void setSubscribers(List<String> subscribers) {
        this.subscribers = subscribers;
    }

    public BaseAnalyticalObject withSubscribers(List<String> subscribers) {
        this.subscribers = subscribers;
        return this;
    }

    @JsonProperty("subtitle")
    public Optional<String> getSubtitle() {
        return Optional.ofNullable(subtitle);
    }

    @JsonProperty("subtitle")
    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    public BaseAnalyticalObject withSubtitle(String subtitle) {
        this.subtitle = subtitle;
        return this;
    }

    @JsonProperty("timeField")
    public Optional<String> getTimeField() {
        return Optional.ofNullable(timeField);
    }

    @JsonProperty("timeField")
    public void setTimeField(String timeField) {
        this.timeField = timeField;
    }

    public BaseAnalyticalObject withTimeField(String timeField) {
        this.timeField = timeField;
        return this;
    }

    @JsonProperty("title")
    public Optional<String> getTitle() {
        return Optional.ofNullable(title);
    }

    @JsonProperty("title")
    public void setTitle(String title) {
        this.title = title;
    }

    public BaseAnalyticalObject withTitle(String title) {
        this.title = title;
        return this;
    }

    @JsonProperty("topLimit")
    public Optional<Integer> getTopLimit() {
        return Optional.ofNullable(topLimit);
    }

    @JsonProperty("topLimit")
    public void setTopLimit(Integer topLimit) {
        this.topLimit = topLimit;
    }

    public BaseAnalyticalObject withTopLimit(Integer topLimit) {
        this.topLimit = topLimit;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public BaseAnalyticalObject withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    @JsonProperty("user")
    public Optional<User> getUser() {
        return Optional.ofNullable(user);
    }

    @JsonProperty("user")
    public void setUser(User user) {
        this.user = user;
    }

    public BaseAnalyticalObject withUser(User user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<UserAccess>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public BaseAnalyticalObject withUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<UserGroupAccess>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public BaseAnalyticalObject withUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    @JsonProperty("userOrgUnitType")
    public Optional<org.hisp.dhis.api.model.v2_35_13.Chart.UserOrgUnitType> getUserOrgUnitType() {
        return Optional.ofNullable(userOrgUnitType);
    }

    @JsonProperty("userOrgUnitType")
    public void setUserOrgUnitType(org.hisp.dhis.api.model.v2_35_13.Chart.UserOrgUnitType userOrgUnitType) {
        this.userOrgUnitType = userOrgUnitType;
    }

    public BaseAnalyticalObject withUserOrgUnitType(org.hisp.dhis.api.model.v2_35_13.Chart.UserOrgUnitType userOrgUnitType) {
        this.userOrgUnitType = userOrgUnitType;
        return this;
    }

    @JsonProperty("userOrganisationUnit")
    public Optional<Boolean> getUserOrganisationUnit() {
        return Optional.ofNullable(userOrganisationUnit);
    }

    @JsonProperty("userOrganisationUnit")
    public void setUserOrganisationUnit(Boolean userOrganisationUnit) {
        this.userOrganisationUnit = userOrganisationUnit;
    }

    public BaseAnalyticalObject withUserOrganisationUnit(Boolean userOrganisationUnit) {
        this.userOrganisationUnit = userOrganisationUnit;
        return this;
    }

    @JsonProperty("userOrganisationUnitChildren")
    public Optional<Boolean> getUserOrganisationUnitChildren() {
        return Optional.ofNullable(userOrganisationUnitChildren);
    }

    @JsonProperty("userOrganisationUnitChildren")
    public void setUserOrganisationUnitChildren(Boolean userOrganisationUnitChildren) {
        this.userOrganisationUnitChildren = userOrganisationUnitChildren;
    }

    public BaseAnalyticalObject withUserOrganisationUnitChildren(Boolean userOrganisationUnitChildren) {
        this.userOrganisationUnitChildren = userOrganisationUnitChildren;
        return this;
    }

    @JsonProperty("userOrganisationUnitGrandChildren")
    public Optional<Boolean> getUserOrganisationUnitGrandChildren() {
        return Optional.ofNullable(userOrganisationUnitGrandChildren);
    }

    @JsonProperty("userOrganisationUnitGrandChildren")
    public void setUserOrganisationUnitGrandChildren(Boolean userOrganisationUnitGrandChildren) {
        this.userOrganisationUnitGrandChildren = userOrganisationUnitGrandChildren;
    }

    public BaseAnalyticalObject withUserOrganisationUnitGrandChildren(Boolean userOrganisationUnitGrandChildren) {
        this.userOrganisationUnitGrandChildren = userOrganisationUnitGrandChildren;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public BaseAnalyticalObject withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("access".equals(name)) {
            if (value instanceof Access) {
                setAccess(((Access) value));
            } else {
                throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v2_35_13.Access\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("aggregationType".equals(name)) {
                if (value instanceof AggregationType) {
                    setAggregationType(((AggregationType) value));
                } else {
                    throw new IllegalArgumentException(("property \"aggregationType\" is of type \"org.hisp.dhis.api.model.v2_35_13.AggregationType\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("attributeDimensions".equals(name)) {
                    if (value instanceof List) {
                        setAttributeDimensions(((List<TrackedEntityAttributeDimension> ) value));
                    } else {
                        throw new IllegalArgumentException(("property \"attributeDimensions\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.TrackedEntityAttributeDimension>\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("attributeValues".equals(name)) {
                        if (value instanceof List) {
                            setAttributeValues(((List<AttributeValue> ) value));
                        } else {
                            throw new IllegalArgumentException(("property \"attributeValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.AttributeValue>\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("categoryDimensions".equals(name)) {
                            if (value instanceof List) {
                                setCategoryDimensions(((List<CategoryDimension> ) value));
                            } else {
                                throw new IllegalArgumentException(("property \"categoryDimensions\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.CategoryDimension>\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("categoryOptionGroupSetDimensions".equals(name)) {
                                if (value instanceof List) {
                                    setCategoryOptionGroupSetDimensions(((List<CategoryOptionGroupSetDimension> ) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"categoryOptionGroupSetDimensions\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.CategoryOptionGroupSetDimension>\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("code".equals(name)) {
                                    if (value instanceof String) {
                                        setCode(((String) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("columns".equals(name)) {
                                        if (value instanceof List) {
                                            setColumns(((List<Object> ) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"columns\" is of type \"java.util.List<java.lang.Object>\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("completedOnly".equals(name)) {
                                            if (value instanceof Boolean) {
                                                setCompletedOnly(((Boolean) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"completedOnly\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("created".equals(name)) {
                                                if (value instanceof Date) {
                                                    setCreated(((Date) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("dataDimensionItems".equals(name)) {
                                                    if (value instanceof List) {
                                                        setDataDimensionItems(((List<DataDimensionItem> ) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"dataDimensionItems\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.DataDimensionItem>\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("dataElementDimensions".equals(name)) {
                                                        if (value instanceof List) {
                                                            setDataElementDimensions(((List<TrackedEntityDataElementDimension> ) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"dataElementDimensions\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.TrackedEntityDataElementDimension>\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("dataElementGroupSetDimensions".equals(name)) {
                                                            if (value instanceof List) {
                                                                setDataElementGroupSetDimensions(((List<DataElementGroupSetDimension> ) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"dataElementGroupSetDimensions\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.DataElementGroupSetDimension>\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            if ("description".equals(name)) {
                                                                if (value instanceof String) {
                                                                    setDescription(((String) value));
                                                                } else {
                                                                    throw new IllegalArgumentException(("property \"description\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                }
                                                                return true;
                                                            } else {
                                                                if ("digitGroupSeparator".equals(name)) {
                                                                    if (value instanceof org.hisp.dhis.api.model.v2_35_13.Chart.DigitGroupSeparator) {
                                                                        setDigitGroupSeparator(((org.hisp.dhis.api.model.v2_35_13.Chart.DigitGroupSeparator) value));
                                                                    } else {
                                                                        throw new IllegalArgumentException(("property \"digitGroupSeparator\" is of type \"org.hisp.dhis.api.model.v2_35_13.Chart.DigitGroupSeparator\", but got "+ value.getClass().toString()));
                                                                    }
                                                                    return true;
                                                                } else {
                                                                    if ("displayDescription".equals(name)) {
                                                                        if (value instanceof String) {
                                                                            setDisplayDescription(((String) value));
                                                                        } else {
                                                                            throw new IllegalArgumentException(("property \"displayDescription\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                        }
                                                                        return true;
                                                                    } else {
                                                                        if ("displayFormName".equals(name)) {
                                                                            if (value instanceof String) {
                                                                                setDisplayFormName(((String) value));
                                                                            } else {
                                                                                throw new IllegalArgumentException(("property \"displayFormName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                            }
                                                                            return true;
                                                                        } else {
                                                                            if ("displayName".equals(name)) {
                                                                                if (value instanceof String) {
                                                                                    setDisplayName(((String) value));
                                                                                } else {
                                                                                    throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                }
                                                                                return true;
                                                                            } else {
                                                                                if ("displayShortName".equals(name)) {
                                                                                    if (value instanceof String) {
                                                                                        setDisplayShortName(((String) value));
                                                                                    } else {
                                                                                        throw new IllegalArgumentException(("property \"displayShortName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                    }
                                                                                    return true;
                                                                                } else {
                                                                                    if ("displaySubtitle".equals(name)) {
                                                                                        if (value instanceof String) {
                                                                                            setDisplaySubtitle(((String) value));
                                                                                        } else {
                                                                                            throw new IllegalArgumentException(("property \"displaySubtitle\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                        }
                                                                                        return true;
                                                                                    } else {
                                                                                        if ("displayTitle".equals(name)) {
                                                                                            if (value instanceof String) {
                                                                                                setDisplayTitle(((String) value));
                                                                                            } else {
                                                                                                throw new IllegalArgumentException(("property \"displayTitle\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                            }
                                                                                            return true;
                                                                                        } else {
                                                                                            if ("endDate".equals(name)) {
                                                                                                if (value instanceof Date) {
                                                                                                    setEndDate(((Date) value));
                                                                                                } else {
                                                                                                    throw new IllegalArgumentException(("property \"endDate\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                                                                                }
                                                                                                return true;
                                                                                            } else {
                                                                                                if ("externalAccess".equals(name)) {
                                                                                                    if (value instanceof Boolean) {
                                                                                                        setExternalAccess(((Boolean) value));
                                                                                                    } else {
                                                                                                        throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                    }
                                                                                                    return true;
                                                                                                } else {
                                                                                                    if ("favorite".equals(name)) {
                                                                                                        if (value instanceof Boolean) {
                                                                                                            setFavorite(((Boolean) value));
                                                                                                        } else {
                                                                                                            throw new IllegalArgumentException(("property \"favorite\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                        }
                                                                                                        return true;
                                                                                                    } else {
                                                                                                        if ("favorites".equals(name)) {
                                                                                                            if (value instanceof List) {
                                                                                                                setFavorites(((List<String> ) value));
                                                                                                            } else {
                                                                                                                throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                                                                                            }
                                                                                                            return true;
                                                                                                        } else {
                                                                                                            if ("filters".equals(name)) {
                                                                                                                if (value instanceof List) {
                                                                                                                    setFilters(((List<Object> ) value));
                                                                                                                } else {
                                                                                                                    throw new IllegalArgumentException(("property \"filters\" is of type \"java.util.List<java.lang.Object>\", but got "+ value.getClass().toString()));
                                                                                                                }
                                                                                                                return true;
                                                                                                            } else {
                                                                                                                if ("formName".equals(name)) {
                                                                                                                    if (value instanceof String) {
                                                                                                                        setFormName(((String) value));
                                                                                                                    } else {
                                                                                                                        throw new IllegalArgumentException(("property \"formName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                    }
                                                                                                                    return true;
                                                                                                                } else {
                                                                                                                    if ("hideSubtitle".equals(name)) {
                                                                                                                        if (value instanceof Boolean) {
                                                                                                                            setHideSubtitle(((Boolean) value));
                                                                                                                        } else {
                                                                                                                            throw new IllegalArgumentException(("property \"hideSubtitle\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                        }
                                                                                                                        return true;
                                                                                                                    } else {
                                                                                                                        if ("hideTitle".equals(name)) {
                                                                                                                            if (value instanceof Boolean) {
                                                                                                                                setHideTitle(((Boolean) value));
                                                                                                                            } else {
                                                                                                                                throw new IllegalArgumentException(("property \"hideTitle\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                            }
                                                                                                                            return true;
                                                                                                                        } else {
                                                                                                                            if ("href".equals(name)) {
                                                                                                                                if (value instanceof String) {
                                                                                                                                    setHref(((String) value));
                                                                                                                                } else {
                                                                                                                                    throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                }
                                                                                                                                return true;
                                                                                                                            } else {
                                                                                                                                if ("id".equals(name)) {
                                                                                                                                    if (value instanceof String) {
                                                                                                                                        setId(((String) value));
                                                                                                                                    } else {
                                                                                                                                        throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                    }
                                                                                                                                    return true;
                                                                                                                                } else {
                                                                                                                                    if ("interpretations".equals(name)) {
                                                                                                                                        if (value instanceof List) {
                                                                                                                                            setInterpretations(((List<Interpretation> ) value));
                                                                                                                                        } else {
                                                                                                                                            throw new IllegalArgumentException(("property \"interpretations\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.Interpretation>\", but got "+ value.getClass().toString()));
                                                                                                                                        }
                                                                                                                                        return true;
                                                                                                                                    } else {
                                                                                                                                        if ("itemOrganisationUnitGroups".equals(name)) {
                                                                                                                                            if (value instanceof List) {
                                                                                                                                                setItemOrganisationUnitGroups(((List<OrganisationUnitGroup> ) value));
                                                                                                                                            } else {
                                                                                                                                                throw new IllegalArgumentException(("property \"itemOrganisationUnitGroups\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.OrganisationUnitGroup>\", but got "+ value.getClass().toString()));
                                                                                                                                            }
                                                                                                                                            return true;
                                                                                                                                        } else {
                                                                                                                                            if ("lastUpdated".equals(name)) {
                                                                                                                                                if (value instanceof Date) {
                                                                                                                                                    setLastUpdated(((Date) value));
                                                                                                                                                } else {
                                                                                                                                                    throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                                                                                                                                }
                                                                                                                                                return true;
                                                                                                                                            } else {
                                                                                                                                                if ("lastUpdatedBy".equals(name)) {
                                                                                                                                                    if (value instanceof User) {
                                                                                                                                                        setLastUpdatedBy(((User) value));
                                                                                                                                                    } else {
                                                                                                                                                        throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"org.hisp.dhis.api.model.v2_35_13.User\", but got "+ value.getClass().toString()));
                                                                                                                                                    }
                                                                                                                                                    return true;
                                                                                                                                                } else {
                                                                                                                                                    if ("name".equals(name)) {
                                                                                                                                                        if (value instanceof String) {
                                                                                                                                                            setName(((String) value));
                                                                                                                                                        } else {
                                                                                                                                                            throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                        }
                                                                                                                                                        return true;
                                                                                                                                                    } else {
                                                                                                                                                        if ("orgUnitField".equals(name)) {
                                                                                                                                                            if (value instanceof String) {
                                                                                                                                                                setOrgUnitField(((String) value));
                                                                                                                                                            } else {
                                                                                                                                                                throw new IllegalArgumentException(("property \"orgUnitField\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                            }
                                                                                                                                                            return true;
                                                                                                                                                        } else {
                                                                                                                                                            if ("organisationUnitGroupSetDimensions".equals(name)) {
                                                                                                                                                                if (value instanceof List) {
                                                                                                                                                                    setOrganisationUnitGroupSetDimensions(((List<OrganisationUnitGroupSetDimension> ) value));
                                                                                                                                                                } else {
                                                                                                                                                                    throw new IllegalArgumentException(("property \"organisationUnitGroupSetDimensions\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.OrganisationUnitGroupSetDimension>\", but got "+ value.getClass().toString()));
                                                                                                                                                                }
                                                                                                                                                                return true;
                                                                                                                                                            } else {
                                                                                                                                                                if ("organisationUnitLevels".equals(name)) {
                                                                                                                                                                    if (value instanceof List) {
                                                                                                                                                                        setOrganisationUnitLevels(((List<Integer> ) value));
                                                                                                                                                                    } else {
                                                                                                                                                                        throw new IllegalArgumentException(("property \"organisationUnitLevels\" is of type \"java.util.List<java.lang.Integer>\", but got "+ value.getClass().toString()));
                                                                                                                                                                    }
                                                                                                                                                                    return true;
                                                                                                                                                                } else {
                                                                                                                                                                    if ("organisationUnits".equals(name)) {
                                                                                                                                                                        if (value instanceof List) {
                                                                                                                                                                            setOrganisationUnits(((List<OrganisationUnit> ) value));
                                                                                                                                                                        } else {
                                                                                                                                                                            throw new IllegalArgumentException(("property \"organisationUnits\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.OrganisationUnit>\", but got "+ value.getClass().toString()));
                                                                                                                                                                        }
                                                                                                                                                                        return true;
                                                                                                                                                                    } else {
                                                                                                                                                                        if ("parentGraphMap".equals(name)) {
                                                                                                                                                                            if (value instanceof ParentGraphMap__6) {
                                                                                                                                                                                setParentGraphMap(((ParentGraphMap__6) value));
                                                                                                                                                                            } else {
                                                                                                                                                                                throw new IllegalArgumentException(("property \"parentGraphMap\" is of type \"org.hisp.dhis.api.model.v2_35_13.ParentGraphMap__6\", but got "+ value.getClass().toString()));
                                                                                                                                                                            }
                                                                                                                                                                            return true;
                                                                                                                                                                        } else {
                                                                                                                                                                            if ("periods".equals(name)) {
                                                                                                                                                                                if (value instanceof List) {
                                                                                                                                                                                    setPeriods(((List<Period> ) value));
                                                                                                                                                                                } else {
                                                                                                                                                                                    throw new IllegalArgumentException(("property \"periods\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.Period>\", but got "+ value.getClass().toString()));
                                                                                                                                                                                }
                                                                                                                                                                                return true;
                                                                                                                                                                            } else {
                                                                                                                                                                                if ("programIndicatorDimensions".equals(name)) {
                                                                                                                                                                                    if (value instanceof List) {
                                                                                                                                                                                        setProgramIndicatorDimensions(((List<TrackedEntityProgramIndicatorDimension> ) value));
                                                                                                                                                                                    } else {
                                                                                                                                                                                        throw new IllegalArgumentException(("property \"programIndicatorDimensions\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.TrackedEntityProgramIndicatorDimension>\", but got "+ value.getClass().toString()));
                                                                                                                                                                                    }
                                                                                                                                                                                    return true;
                                                                                                                                                                                } else {
                                                                                                                                                                                    if ("publicAccess".equals(name)) {
                                                                                                                                                                                        if (value instanceof String) {
                                                                                                                                                                                            setPublicAccess(((String) value));
                                                                                                                                                                                        } else {
                                                                                                                                                                                            throw new IllegalArgumentException(("property \"publicAccess\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                                                        }
                                                                                                                                                                                        return true;
                                                                                                                                                                                    } else {
                                                                                                                                                                                        if ("relativePeriods".equals(name)) {
                                                                                                                                                                                            if (value instanceof RelativePeriods) {
                                                                                                                                                                                                setRelativePeriods(((RelativePeriods) value));
                                                                                                                                                                                            } else {
                                                                                                                                                                                                throw new IllegalArgumentException(("property \"relativePeriods\" is of type \"org.hisp.dhis.api.model.v2_35_13.RelativePeriods\", but got "+ value.getClass().toString()));
                                                                                                                                                                                            }
                                                                                                                                                                                            return true;
                                                                                                                                                                                        } else {
                                                                                                                                                                                            if ("rows".equals(name)) {
                                                                                                                                                                                                if (value instanceof List) {
                                                                                                                                                                                                    setRows(((List<Object> ) value));
                                                                                                                                                                                                } else {
                                                                                                                                                                                                    throw new IllegalArgumentException(("property \"rows\" is of type \"java.util.List<java.lang.Object>\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                }
                                                                                                                                                                                                return true;
                                                                                                                                                                                            } else {
                                                                                                                                                                                                if ("shortName".equals(name)) {
                                                                                                                                                                                                    if (value instanceof String) {
                                                                                                                                                                                                        setShortName(((String) value));
                                                                                                                                                                                                    } else {
                                                                                                                                                                                                        throw new IllegalArgumentException(("property \"shortName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                    }
                                                                                                                                                                                                    return true;
                                                                                                                                                                                                } else {
                                                                                                                                                                                                    if ("sortOrder".equals(name)) {
                                                                                                                                                                                                        if (value instanceof Integer) {
                                                                                                                                                                                                            setSortOrder(((Integer) value));
                                                                                                                                                                                                        } else {
                                                                                                                                                                                                            throw new IllegalArgumentException(("property \"sortOrder\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                        }
                                                                                                                                                                                                        return true;
                                                                                                                                                                                                    } else {
                                                                                                                                                                                                        if ("startDate".equals(name)) {
                                                                                                                                                                                                            if (value instanceof Date) {
                                                                                                                                                                                                                setStartDate(((Date) value));
                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                throw new IllegalArgumentException(("property \"startDate\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                            }
                                                                                                                                                                                                            return true;
                                                                                                                                                                                                        } else {
                                                                                                                                                                                                            if ("subscribed".equals(name)) {
                                                                                                                                                                                                                if (value instanceof Boolean) {
                                                                                                                                                                                                                    setSubscribed(((Boolean) value));
                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                    throw new IllegalArgumentException(("property \"subscribed\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                }
                                                                                                                                                                                                                return true;
                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                if ("subscribers".equals(name)) {
                                                                                                                                                                                                                    if (value instanceof List) {
                                                                                                                                                                                                                        setSubscribers(((List<String> ) value));
                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                        throw new IllegalArgumentException(("property \"subscribers\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    return true;
                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                    if ("subtitle".equals(name)) {
                                                                                                                                                                                                                        if (value instanceof String) {
                                                                                                                                                                                                                            setSubtitle(((String) value));
                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                            throw new IllegalArgumentException(("property \"subtitle\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        return true;
                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                        if ("timeField".equals(name)) {
                                                                                                                                                                                                                            if (value instanceof String) {
                                                                                                                                                                                                                                setTimeField(((String) value));
                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                throw new IllegalArgumentException(("property \"timeField\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                            return true;
                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                            if ("title".equals(name)) {
                                                                                                                                                                                                                                if (value instanceof String) {
                                                                                                                                                                                                                                    setTitle(((String) value));
                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                    throw new IllegalArgumentException(("property \"title\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                return true;
                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                if ("topLimit".equals(name)) {
                                                                                                                                                                                                                                    if (value instanceof Integer) {
                                                                                                                                                                                                                                        setTopLimit(((Integer) value));
                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                        throw new IllegalArgumentException(("property \"topLimit\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    return true;
                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                    if ("translations".equals(name)) {
                                                                                                                                                                                                                                        if (value instanceof List) {
                                                                                                                                                                                                                                            setTranslations(((List<Translation> ) value));
                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                            throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.Translation>\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        return true;
                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                        if ("user".equals(name)) {
                                                                                                                                                                                                                                            if (value instanceof User) {
                                                                                                                                                                                                                                                setUser(((User) value));
                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v2_35_13.User\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            return true;
                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                            if ("userAccesses".equals(name)) {
                                                                                                                                                                                                                                                if (value instanceof List) {
                                                                                                                                                                                                                                                    setUserAccesses(((List<UserAccess> ) value));
                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                    throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.UserAccess>\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                return true;
                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                if ("userGroupAccesses".equals(name)) {
                                                                                                                                                                                                                                                    if (value instanceof List) {
                                                                                                                                                                                                                                                        setUserGroupAccesses(((List<UserGroupAccess> ) value));
                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                        throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.UserGroupAccess>\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    return true;
                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                    if ("userOrgUnitType".equals(name)) {
                                                                                                                                                                                                                                                        if (value instanceof org.hisp.dhis.api.model.v2_35_13.Chart.UserOrgUnitType) {
                                                                                                                                                                                                                                                            setUserOrgUnitType(((org.hisp.dhis.api.model.v2_35_13.Chart.UserOrgUnitType) value));
                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                            throw new IllegalArgumentException(("property \"userOrgUnitType\" is of type \"org.hisp.dhis.api.model.v2_35_13.Chart.UserOrgUnitType\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                        return true;
                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                        if ("userOrganisationUnit".equals(name)) {
                                                                                                                                                                                                                                                            if (value instanceof Boolean) {
                                                                                                                                                                                                                                                                setUserOrganisationUnit(((Boolean) value));
                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                throw new IllegalArgumentException(("property \"userOrganisationUnit\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                            return true;
                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                            if ("userOrganisationUnitChildren".equals(name)) {
                                                                                                                                                                                                                                                                if (value instanceof Boolean) {
                                                                                                                                                                                                                                                                    setUserOrganisationUnitChildren(((Boolean) value));
                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                    throw new IllegalArgumentException(("property \"userOrganisationUnitChildren\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                return true;
                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                if ("userOrganisationUnitGrandChildren".equals(name)) {
                                                                                                                                                                                                                                                                    if (value instanceof Boolean) {
                                                                                                                                                                                                                                                                        setUserOrganisationUnitGrandChildren(((Boolean) value));
                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                        throw new IllegalArgumentException(("property \"userOrganisationUnitGrandChildren\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                    return true;
                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                }
                                                                                                                                                                                                            }
                                                                                                                                                                                                        }
                                                                                                                                                                                                    }
                                                                                                                                                                                                }
                                                                                                                                                                                            }
                                                                                                                                                                                        }
                                                                                                                                                                                    }
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("access".equals(name)) {
            return getAccess();
        } else {
            if ("aggregationType".equals(name)) {
                return getAggregationType();
            } else {
                if ("attributeDimensions".equals(name)) {
                    return getAttributeDimensions();
                } else {
                    if ("attributeValues".equals(name)) {
                        return getAttributeValues();
                    } else {
                        if ("categoryDimensions".equals(name)) {
                            return getCategoryDimensions();
                        } else {
                            if ("categoryOptionGroupSetDimensions".equals(name)) {
                                return getCategoryOptionGroupSetDimensions();
                            } else {
                                if ("code".equals(name)) {
                                    return getCode();
                                } else {
                                    if ("columns".equals(name)) {
                                        return getColumns();
                                    } else {
                                        if ("completedOnly".equals(name)) {
                                            return getCompletedOnly();
                                        } else {
                                            if ("created".equals(name)) {
                                                return getCreated();
                                            } else {
                                                if ("dataDimensionItems".equals(name)) {
                                                    return getDataDimensionItems();
                                                } else {
                                                    if ("dataElementDimensions".equals(name)) {
                                                        return getDataElementDimensions();
                                                    } else {
                                                        if ("dataElementGroupSetDimensions".equals(name)) {
                                                            return getDataElementGroupSetDimensions();
                                                        } else {
                                                            if ("description".equals(name)) {
                                                                return getDescription();
                                                            } else {
                                                                if ("digitGroupSeparator".equals(name)) {
                                                                    return getDigitGroupSeparator();
                                                                } else {
                                                                    if ("displayDescription".equals(name)) {
                                                                        return getDisplayDescription();
                                                                    } else {
                                                                        if ("displayFormName".equals(name)) {
                                                                            return getDisplayFormName();
                                                                        } else {
                                                                            if ("displayName".equals(name)) {
                                                                                return getDisplayName();
                                                                            } else {
                                                                                if ("displayShortName".equals(name)) {
                                                                                    return getDisplayShortName();
                                                                                } else {
                                                                                    if ("displaySubtitle".equals(name)) {
                                                                                        return getDisplaySubtitle();
                                                                                    } else {
                                                                                        if ("displayTitle".equals(name)) {
                                                                                            return getDisplayTitle();
                                                                                        } else {
                                                                                            if ("endDate".equals(name)) {
                                                                                                return getEndDate();
                                                                                            } else {
                                                                                                if ("externalAccess".equals(name)) {
                                                                                                    return getExternalAccess();
                                                                                                } else {
                                                                                                    if ("favorite".equals(name)) {
                                                                                                        return getFavorite();
                                                                                                    } else {
                                                                                                        if ("favorites".equals(name)) {
                                                                                                            return getFavorites();
                                                                                                        } else {
                                                                                                            if ("filters".equals(name)) {
                                                                                                                return getFilters();
                                                                                                            } else {
                                                                                                                if ("formName".equals(name)) {
                                                                                                                    return getFormName();
                                                                                                                } else {
                                                                                                                    if ("hideSubtitle".equals(name)) {
                                                                                                                        return getHideSubtitle();
                                                                                                                    } else {
                                                                                                                        if ("hideTitle".equals(name)) {
                                                                                                                            return getHideTitle();
                                                                                                                        } else {
                                                                                                                            if ("href".equals(name)) {
                                                                                                                                return getHref();
                                                                                                                            } else {
                                                                                                                                if ("id".equals(name)) {
                                                                                                                                    return getId();
                                                                                                                                } else {
                                                                                                                                    if ("interpretations".equals(name)) {
                                                                                                                                        return getInterpretations();
                                                                                                                                    } else {
                                                                                                                                        if ("itemOrganisationUnitGroups".equals(name)) {
                                                                                                                                            return getItemOrganisationUnitGroups();
                                                                                                                                        } else {
                                                                                                                                            if ("lastUpdated".equals(name)) {
                                                                                                                                                return getLastUpdated();
                                                                                                                                            } else {
                                                                                                                                                if ("lastUpdatedBy".equals(name)) {
                                                                                                                                                    return getLastUpdatedBy();
                                                                                                                                                } else {
                                                                                                                                                    if ("name".equals(name)) {
                                                                                                                                                        return getName();
                                                                                                                                                    } else {
                                                                                                                                                        if ("orgUnitField".equals(name)) {
                                                                                                                                                            return getOrgUnitField();
                                                                                                                                                        } else {
                                                                                                                                                            if ("organisationUnitGroupSetDimensions".equals(name)) {
                                                                                                                                                                return getOrganisationUnitGroupSetDimensions();
                                                                                                                                                            } else {
                                                                                                                                                                if ("organisationUnitLevels".equals(name)) {
                                                                                                                                                                    return getOrganisationUnitLevels();
                                                                                                                                                                } else {
                                                                                                                                                                    if ("organisationUnits".equals(name)) {
                                                                                                                                                                        return getOrganisationUnits();
                                                                                                                                                                    } else {
                                                                                                                                                                        if ("parentGraphMap".equals(name)) {
                                                                                                                                                                            return getParentGraphMap();
                                                                                                                                                                        } else {
                                                                                                                                                                            if ("periods".equals(name)) {
                                                                                                                                                                                return getPeriods();
                                                                                                                                                                            } else {
                                                                                                                                                                                if ("programIndicatorDimensions".equals(name)) {
                                                                                                                                                                                    return getProgramIndicatorDimensions();
                                                                                                                                                                                } else {
                                                                                                                                                                                    if ("publicAccess".equals(name)) {
                                                                                                                                                                                        return getPublicAccess();
                                                                                                                                                                                    } else {
                                                                                                                                                                                        if ("relativePeriods".equals(name)) {
                                                                                                                                                                                            return getRelativePeriods();
                                                                                                                                                                                        } else {
                                                                                                                                                                                            if ("rows".equals(name)) {
                                                                                                                                                                                                return getRows();
                                                                                                                                                                                            } else {
                                                                                                                                                                                                if ("shortName".equals(name)) {
                                                                                                                                                                                                    return getShortName();
                                                                                                                                                                                                } else {
                                                                                                                                                                                                    if ("sortOrder".equals(name)) {
                                                                                                                                                                                                        return getSortOrder();
                                                                                                                                                                                                    } else {
                                                                                                                                                                                                        if ("startDate".equals(name)) {
                                                                                                                                                                                                            return getStartDate();
                                                                                                                                                                                                        } else {
                                                                                                                                                                                                            if ("subscribed".equals(name)) {
                                                                                                                                                                                                                return getSubscribed();
                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                if ("subscribers".equals(name)) {
                                                                                                                                                                                                                    return getSubscribers();
                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                    if ("subtitle".equals(name)) {
                                                                                                                                                                                                                        return getSubtitle();
                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                        if ("timeField".equals(name)) {
                                                                                                                                                                                                                            return getTimeField();
                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                            if ("title".equals(name)) {
                                                                                                                                                                                                                                return getTitle();
                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                if ("topLimit".equals(name)) {
                                                                                                                                                                                                                                    return getTopLimit();
                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                    if ("translations".equals(name)) {
                                                                                                                                                                                                                                        return getTranslations();
                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                        if ("user".equals(name)) {
                                                                                                                                                                                                                                            return getUser();
                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                            if ("userAccesses".equals(name)) {
                                                                                                                                                                                                                                                return getUserAccesses();
                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                if ("userGroupAccesses".equals(name)) {
                                                                                                                                                                                                                                                    return getUserGroupAccesses();
                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                    if ("userOrgUnitType".equals(name)) {
                                                                                                                                                                                                                                                        return getUserOrgUnitType();
                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                        if ("userOrganisationUnit".equals(name)) {
                                                                                                                                                                                                                                                            return getUserOrganisationUnit();
                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                            if ("userOrganisationUnitChildren".equals(name)) {
                                                                                                                                                                                                                                                                return getUserOrganisationUnitChildren();
                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                if ("userOrganisationUnitGrandChildren".equals(name)) {
                                                                                                                                                                                                                                                                    return getUserOrganisationUnitGrandChildren();
                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                    return notFoundValue;
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                }
                                                                                                                                                                                                            }
                                                                                                                                                                                                        }
                                                                                                                                                                                                    }
                                                                                                                                                                                                }
                                                                                                                                                                                            }
                                                                                                                                                                                        }
                                                                                                                                                                                    }
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, BaseAnalyticalObject.NOT_FOUND_VALUE);
        if (BaseAnalyticalObject.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public BaseAnalyticalObject with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(BaseAnalyticalObject.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("aggregationType");
        sb.append('=');
        sb.append(((this.aggregationType == null)?"<null>":this.aggregationType));
        sb.append(',');
        sb.append("attributeDimensions");
        sb.append('=');
        sb.append(((this.attributeDimensions == null)?"<null>":this.attributeDimensions));
        sb.append(',');
        sb.append("attributeValues");
        sb.append('=');
        sb.append(((this.attributeValues == null)?"<null>":this.attributeValues));
        sb.append(',');
        sb.append("categoryDimensions");
        sb.append('=');
        sb.append(((this.categoryDimensions == null)?"<null>":this.categoryDimensions));
        sb.append(',');
        sb.append("categoryOptionGroupSetDimensions");
        sb.append('=');
        sb.append(((this.categoryOptionGroupSetDimensions == null)?"<null>":this.categoryOptionGroupSetDimensions));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("columns");
        sb.append('=');
        sb.append(((this.columns == null)?"<null>":this.columns));
        sb.append(',');
        sb.append("completedOnly");
        sb.append('=');
        sb.append(((this.completedOnly == null)?"<null>":this.completedOnly));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("dataDimensionItems");
        sb.append('=');
        sb.append(((this.dataDimensionItems == null)?"<null>":this.dataDimensionItems));
        sb.append(',');
        sb.append("dataElementDimensions");
        sb.append('=');
        sb.append(((this.dataElementDimensions == null)?"<null>":this.dataElementDimensions));
        sb.append(',');
        sb.append("dataElementGroupSetDimensions");
        sb.append('=');
        sb.append(((this.dataElementGroupSetDimensions == null)?"<null>":this.dataElementGroupSetDimensions));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("digitGroupSeparator");
        sb.append('=');
        sb.append(((this.digitGroupSeparator == null)?"<null>":this.digitGroupSeparator));
        sb.append(',');
        sb.append("displayDescription");
        sb.append('=');
        sb.append(((this.displayDescription == null)?"<null>":this.displayDescription));
        sb.append(',');
        sb.append("displayFormName");
        sb.append('=');
        sb.append(((this.displayFormName == null)?"<null>":this.displayFormName));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("displayShortName");
        sb.append('=');
        sb.append(((this.displayShortName == null)?"<null>":this.displayShortName));
        sb.append(',');
        sb.append("displaySubtitle");
        sb.append('=');
        sb.append(((this.displaySubtitle == null)?"<null>":this.displaySubtitle));
        sb.append(',');
        sb.append("displayTitle");
        sb.append('=');
        sb.append(((this.displayTitle == null)?"<null>":this.displayTitle));
        sb.append(',');
        sb.append("endDate");
        sb.append('=');
        sb.append(((this.endDate == null)?"<null>":this.endDate));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("favorite");
        sb.append('=');
        sb.append(((this.favorite == null)?"<null>":this.favorite));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("filters");
        sb.append('=');
        sb.append(((this.filters == null)?"<null>":this.filters));
        sb.append(',');
        sb.append("formName");
        sb.append('=');
        sb.append(((this.formName == null)?"<null>":this.formName));
        sb.append(',');
        sb.append("hideSubtitle");
        sb.append('=');
        sb.append(((this.hideSubtitle == null)?"<null>":this.hideSubtitle));
        sb.append(',');
        sb.append("hideTitle");
        sb.append('=');
        sb.append(((this.hideTitle == null)?"<null>":this.hideTitle));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("interpretations");
        sb.append('=');
        sb.append(((this.interpretations == null)?"<null>":this.interpretations));
        sb.append(',');
        sb.append("itemOrganisationUnitGroups");
        sb.append('=');
        sb.append(((this.itemOrganisationUnitGroups == null)?"<null>":this.itemOrganisationUnitGroups));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("orgUnitField");
        sb.append('=');
        sb.append(((this.orgUnitField == null)?"<null>":this.orgUnitField));
        sb.append(',');
        sb.append("organisationUnitGroupSetDimensions");
        sb.append('=');
        sb.append(((this.organisationUnitGroupSetDimensions == null)?"<null>":this.organisationUnitGroupSetDimensions));
        sb.append(',');
        sb.append("organisationUnitLevels");
        sb.append('=');
        sb.append(((this.organisationUnitLevels == null)?"<null>":this.organisationUnitLevels));
        sb.append(',');
        sb.append("organisationUnits");
        sb.append('=');
        sb.append(((this.organisationUnits == null)?"<null>":this.organisationUnits));
        sb.append(',');
        sb.append("parentGraphMap");
        sb.append('=');
        sb.append(((this.parentGraphMap == null)?"<null>":this.parentGraphMap));
        sb.append(',');
        sb.append("periods");
        sb.append('=');
        sb.append(((this.periods == null)?"<null>":this.periods));
        sb.append(',');
        sb.append("programIndicatorDimensions");
        sb.append('=');
        sb.append(((this.programIndicatorDimensions == null)?"<null>":this.programIndicatorDimensions));
        sb.append(',');
        sb.append("publicAccess");
        sb.append('=');
        sb.append(((this.publicAccess == null)?"<null>":this.publicAccess));
        sb.append(',');
        sb.append("relativePeriods");
        sb.append('=');
        sb.append(((this.relativePeriods == null)?"<null>":this.relativePeriods));
        sb.append(',');
        sb.append("rows");
        sb.append('=');
        sb.append(((this.rows == null)?"<null>":this.rows));
        sb.append(',');
        sb.append("shortName");
        sb.append('=');
        sb.append(((this.shortName == null)?"<null>":this.shortName));
        sb.append(',');
        sb.append("sortOrder");
        sb.append('=');
        sb.append(((this.sortOrder == null)?"<null>":this.sortOrder));
        sb.append(',');
        sb.append("startDate");
        sb.append('=');
        sb.append(((this.startDate == null)?"<null>":this.startDate));
        sb.append(',');
        sb.append("subscribed");
        sb.append('=');
        sb.append(((this.subscribed == null)?"<null>":this.subscribed));
        sb.append(',');
        sb.append("subscribers");
        sb.append('=');
        sb.append(((this.subscribers == null)?"<null>":this.subscribers));
        sb.append(',');
        sb.append("subtitle");
        sb.append('=');
        sb.append(((this.subtitle == null)?"<null>":this.subtitle));
        sb.append(',');
        sb.append("timeField");
        sb.append('=');
        sb.append(((this.timeField == null)?"<null>":this.timeField));
        sb.append(',');
        sb.append("title");
        sb.append('=');
        sb.append(((this.title == null)?"<null>":this.title));
        sb.append(',');
        sb.append("topLimit");
        sb.append('=');
        sb.append(((this.topLimit == null)?"<null>":this.topLimit));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("userOrgUnitType");
        sb.append('=');
        sb.append(((this.userOrgUnitType == null)?"<null>":this.userOrgUnitType));
        sb.append(',');
        sb.append("userOrganisationUnit");
        sb.append('=');
        sb.append(((this.userOrganisationUnit == null)?"<null>":this.userOrganisationUnit));
        sb.append(',');
        sb.append("userOrganisationUnitChildren");
        sb.append('=');
        sb.append(((this.userOrganisationUnitChildren == null)?"<null>":this.userOrganisationUnitChildren));
        sb.append(',');
        sb.append("userOrganisationUnitGrandChildren");
        sb.append('=');
        sb.append(((this.userOrganisationUnitGrandChildren == null)?"<null>":this.userOrganisationUnitGrandChildren));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.dataElementGroupSetDimensions == null)? 0 :this.dataElementGroupSetDimensions.hashCode()));
        result = ((result* 31)+((this.orgUnitField == null)? 0 :this.orgUnitField.hashCode()));
        result = ((result* 31)+((this.endDate == null)? 0 :this.endDate.hashCode()));
        result = ((result* 31)+((this.publicAccess == null)? 0 :this.publicAccess.hashCode()));
        result = ((result* 31)+((this.userOrganisationUnitChildren == null)? 0 :this.userOrganisationUnitChildren.hashCode()));
        result = ((result* 31)+((this.displaySubtitle == null)? 0 :this.displaySubtitle.hashCode()));
        result = ((result* 31)+((this.displayTitle == null)? 0 :this.displayTitle.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.subscribed == null)? 0 :this.subscribed.hashCode()));
        result = ((result* 31)+((this.attributeDimensions == null)? 0 :this.attributeDimensions.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.parentGraphMap == null)? 0 :this.parentGraphMap.hashCode()));
        result = ((result* 31)+((this.userOrganisationUnit == null)? 0 :this.userOrganisationUnit.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.interpretations == null)? 0 :this.interpretations.hashCode()));
        result = ((result* 31)+((this.itemOrganisationUnitGroups == null)? 0 :this.itemOrganisationUnitGroups.hashCode()));
        result = ((result* 31)+((this.displayDescription == null)? 0 :this.displayDescription.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.programIndicatorDimensions == null)? 0 :this.programIndicatorDimensions.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.subscribers == null)? 0 :this.subscribers.hashCode()));
        result = ((result* 31)+((this.attributeValues == null)? 0 :this.attributeValues.hashCode()));
        result = ((result* 31)+((this.completedOnly == null)? 0 :this.completedOnly.hashCode()));
        result = ((result* 31)+((this.displayFormName == null)? 0 :this.displayFormName.hashCode()));
        result = ((result* 31)+((this.sortOrder == null)? 0 :this.sortOrder.hashCode()));
        result = ((result* 31)+((this.subtitle == null)? 0 :this.subtitle.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.shortName == null)? 0 :this.shortName.hashCode()));
        result = ((result* 31)+((this.favorite == null)? 0 :this.favorite.hashCode()));
        result = ((result* 31)+((this.topLimit == null)? 0 :this.topLimit.hashCode()));
        result = ((result* 31)+((this.startDate == null)? 0 :this.startDate.hashCode()));
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.aggregationType == null)? 0 :this.aggregationType.hashCode()));
        result = ((result* 31)+((this.dataDimensionItems == null)? 0 :this.dataDimensionItems.hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.categoryOptionGroupSetDimensions == null)? 0 :this.categoryOptionGroupSetDimensions.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.userOrganisationUnitGrandChildren == null)? 0 :this.userOrganisationUnitGrandChildren.hashCode()));
        result = ((result* 31)+((this.columns == null)? 0 :this.columns.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.hideSubtitle == null)? 0 :this.hideSubtitle.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.organisationUnitGroupSetDimensions == null)? 0 :this.organisationUnitGroupSetDimensions.hashCode()));
        result = ((result* 31)+((this.title == null)? 0 :this.title.hashCode()));
        result = ((result* 31)+((this.displayShortName == null)? 0 :this.displayShortName.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.organisationUnitLevels == null)? 0 :this.organisationUnitLevels.hashCode()));
        result = ((result* 31)+((this.dataElementDimensions == null)? 0 :this.dataElementDimensions.hashCode()));
        result = ((result* 31)+((this.relativePeriods == null)? 0 :this.relativePeriods.hashCode()));
        result = ((result* 31)+((this.formName == null)? 0 :this.formName.hashCode()));
        result = ((result* 31)+((this.periods == null)? 0 :this.periods.hashCode()));
        result = ((result* 31)+((this.organisationUnits == null)? 0 :this.organisationUnits.hashCode()));
        result = ((result* 31)+((this.categoryDimensions == null)? 0 :this.categoryDimensions.hashCode()));
        result = ((result* 31)+((this.timeField == null)? 0 :this.timeField.hashCode()));
        result = ((result* 31)+((this.filters == null)? 0 :this.filters.hashCode()));
        result = ((result* 31)+((this.rows == null)? 0 :this.rows.hashCode()));
        result = ((result* 31)+((this.digitGroupSeparator == null)? 0 :this.digitGroupSeparator.hashCode()));
        result = ((result* 31)+((this.hideTitle == null)? 0 :this.hideTitle.hashCode()));
        result = ((result* 31)+((this.userOrgUnitType == null)? 0 :this.userOrgUnitType.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof BaseAnalyticalObject) == false) {
            return false;
        }
        BaseAnalyticalObject rhs = ((BaseAnalyticalObject) other);
        return (((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((this.dataElementGroupSetDimensions == rhs.dataElementGroupSetDimensions)||((this.dataElementGroupSetDimensions!= null)&&this.dataElementGroupSetDimensions.equals(rhs.dataElementGroupSetDimensions)))&&((this.orgUnitField == rhs.orgUnitField)||((this.orgUnitField!= null)&&this.orgUnitField.equals(rhs.orgUnitField))))&&((this.endDate == rhs.endDate)||((this.endDate!= null)&&this.endDate.equals(rhs.endDate))))&&((this.publicAccess == rhs.publicAccess)||((this.publicAccess!= null)&&this.publicAccess.equals(rhs.publicAccess))))&&((this.userOrganisationUnitChildren == rhs.userOrganisationUnitChildren)||((this.userOrganisationUnitChildren!= null)&&this.userOrganisationUnitChildren.equals(rhs.userOrganisationUnitChildren))))&&((this.displaySubtitle == rhs.displaySubtitle)||((this.displaySubtitle!= null)&&this.displaySubtitle.equals(rhs.displaySubtitle))))&&((this.displayTitle == rhs.displayTitle)||((this.displayTitle!= null)&&this.displayTitle.equals(rhs.displayTitle))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.subscribed == rhs.subscribed)||((this.subscribed!= null)&&this.subscribed.equals(rhs.subscribed))))&&((this.attributeDimensions == rhs.attributeDimensions)||((this.attributeDimensions!= null)&&this.attributeDimensions.equals(rhs.attributeDimensions))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.parentGraphMap == rhs.parentGraphMap)||((this.parentGraphMap!= null)&&this.parentGraphMap.equals(rhs.parentGraphMap))))&&((this.userOrganisationUnit == rhs.userOrganisationUnit)||((this.userOrganisationUnit!= null)&&this.userOrganisationUnit.equals(rhs.userOrganisationUnit))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.interpretations == rhs.interpretations)||((this.interpretations!= null)&&this.interpretations.equals(rhs.interpretations))))&&((this.itemOrganisationUnitGroups == rhs.itemOrganisationUnitGroups)||((this.itemOrganisationUnitGroups!= null)&&this.itemOrganisationUnitGroups.equals(rhs.itemOrganisationUnitGroups))))&&((this.displayDescription == rhs.displayDescription)||((this.displayDescription!= null)&&this.displayDescription.equals(rhs.displayDescription))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.programIndicatorDimensions == rhs.programIndicatorDimensions)||((this.programIndicatorDimensions!= null)&&this.programIndicatorDimensions.equals(rhs.programIndicatorDimensions))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.subscribers == rhs.subscribers)||((this.subscribers!= null)&&this.subscribers.equals(rhs.subscribers))))&&((this.attributeValues == rhs.attributeValues)||((this.attributeValues!= null)&&this.attributeValues.equals(rhs.attributeValues))))&&((this.completedOnly == rhs.completedOnly)||((this.completedOnly!= null)&&this.completedOnly.equals(rhs.completedOnly))))&&((this.displayFormName == rhs.displayFormName)||((this.displayFormName!= null)&&this.displayFormName.equals(rhs.displayFormName))))&&((this.sortOrder == rhs.sortOrder)||((this.sortOrder!= null)&&this.sortOrder.equals(rhs.sortOrder))))&&((this.subtitle == rhs.subtitle)||((this.subtitle!= null)&&this.subtitle.equals(rhs.subtitle))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.shortName == rhs.shortName)||((this.shortName!= null)&&this.shortName.equals(rhs.shortName))))&&((this.favorite == rhs.favorite)||((this.favorite!= null)&&this.favorite.equals(rhs.favorite))))&&((this.topLimit == rhs.topLimit)||((this.topLimit!= null)&&this.topLimit.equals(rhs.topLimit))))&&((this.startDate == rhs.startDate)||((this.startDate!= null)&&this.startDate.equals(rhs.startDate))))&&((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites))))&&((this.aggregationType == rhs.aggregationType)||((this.aggregationType!= null)&&this.aggregationType.equals(rhs.aggregationType))))&&((this.dataDimensionItems == rhs.dataDimensionItems)||((this.dataDimensionItems!= null)&&this.dataDimensionItems.equals(rhs.dataDimensionItems))))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.categoryOptionGroupSetDimensions == rhs.categoryOptionGroupSetDimensions)||((this.categoryOptionGroupSetDimensions!= null)&&this.categoryOptionGroupSetDimensions.equals(rhs.categoryOptionGroupSetDimensions))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.userOrganisationUnitGrandChildren == rhs.userOrganisationUnitGrandChildren)||((this.userOrganisationUnitGrandChildren!= null)&&this.userOrganisationUnitGrandChildren.equals(rhs.userOrganisationUnitGrandChildren))))&&((this.columns == rhs.columns)||((this.columns!= null)&&this.columns.equals(rhs.columns))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.hideSubtitle == rhs.hideSubtitle)||((this.hideSubtitle!= null)&&this.hideSubtitle.equals(rhs.hideSubtitle))))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.organisationUnitGroupSetDimensions == rhs.organisationUnitGroupSetDimensions)||((this.organisationUnitGroupSetDimensions!= null)&&this.organisationUnitGroupSetDimensions.equals(rhs.organisationUnitGroupSetDimensions))))&&((this.title == rhs.title)||((this.title!= null)&&this.title.equals(rhs.title))))&&((this.displayShortName == rhs.displayShortName)||((this.displayShortName!= null)&&this.displayShortName.equals(rhs.displayShortName))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.organisationUnitLevels == rhs.organisationUnitLevels)||((this.organisationUnitLevels!= null)&&this.organisationUnitLevels.equals(rhs.organisationUnitLevels))))&&((this.dataElementDimensions == rhs.dataElementDimensions)||((this.dataElementDimensions!= null)&&this.dataElementDimensions.equals(rhs.dataElementDimensions))))&&((this.relativePeriods == rhs.relativePeriods)||((this.relativePeriods!= null)&&this.relativePeriods.equals(rhs.relativePeriods))))&&((this.formName == rhs.formName)||((this.formName!= null)&&this.formName.equals(rhs.formName))))&&((this.periods == rhs.periods)||((this.periods!= null)&&this.periods.equals(rhs.periods))))&&((this.organisationUnits == rhs.organisationUnits)||((this.organisationUnits!= null)&&this.organisationUnits.equals(rhs.organisationUnits))))&&((this.categoryDimensions == rhs.categoryDimensions)||((this.categoryDimensions!= null)&&this.categoryDimensions.equals(rhs.categoryDimensions))))&&((this.timeField == rhs.timeField)||((this.timeField!= null)&&this.timeField.equals(rhs.timeField))))&&((this.filters == rhs.filters)||((this.filters!= null)&&this.filters.equals(rhs.filters))))&&((this.rows == rhs.rows)||((this.rows!= null)&&this.rows.equals(rhs.rows))))&&((this.digitGroupSeparator == rhs.digitGroupSeparator)||((this.digitGroupSeparator!= null)&&this.digitGroupSeparator.equals(rhs.digitGroupSeparator))))&&((this.hideTitle == rhs.hideTitle)||((this.hideTitle!= null)&&this.hideTitle.equals(rhs.hideTitle))))&&((this.userOrgUnitType == rhs.userOrgUnitType)||((this.userOrgUnitType!= null)&&this.userOrgUnitType.equals(rhs.userOrgUnitType))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))));
    }

}
