/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v2_39_1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum CacheType {
    NONE("NONE"),
    IN_MEMORY("IN_MEMORY"),
    REDIS("REDIS");

    private final String value;
    private static final Map<String, CacheType> CONSTANTS;

    private CacheType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static CacheType fromValue(String value) {
        CacheType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, CacheType>();
        for (CacheType c : CacheType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

