
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "aggregationType",
    "attributeDimensions",
    "attributeValues",
    "axes",
    "baseLineLabel",
    "baseLineValue",
    "categoryDimensions",
    "categoryOptionGroupSetDimensions",
    "code",
    "colSubTotals",
    "colTotals",
    "colorSet",
    "columnDimensions",
    "columns",
    "completedOnly",
    "created",
    "createdBy",
    "cumulativeValues",
    "dataDimensionItems",
    "dataElementDimensions",
    "dataElementGroupSetDimensions",
    "description",
    "digitGroupSeparator",
    "displayBaseLineLabel",
    "displayDensity",
    "displayDescription",
    "displayDomainAxisLabel",
    "displayFormName",
    "displayName",
    "displayRangeAxisLabel",
    "displayShortName",
    "displaySubtitle",
    "displayTargetLineLabel",
    "displayTitle",
    "domainAxisLabel",
    "endDate",
    "externalAccess",
    "favorite",
    "favorites",
    "filterDimensions",
    "filters",
    "fixColumnHeaders",
    "fixRowHeaders",
    "fontSize",
    "fontStyle",
    "formName",
    "hideEmptyColumns",
    "hideEmptyRowItems",
    "hideEmptyRows",
    "hideLegend",
    "hideSubtitle",
    "hideTitle",
    "href",
    "icons",
    "id",
    "interpretations",
    "itemOrganisationUnitGroups",
    "lastUpdated",
    "lastUpdatedBy",
    "legend",
    "measureCriteria",
    "name",
    "noSpaceBetweenColumns",
    "numberType",
    "optionalAxes",
    "orgUnitField",
    "organisationUnitGroupSetDimensions",
    "organisationUnitLevels",
    "organisationUnits",
    "outlierAnalysis",
    "parentGraphMap",
    "percentStackedValues",
    "periods",
    "programIndicatorDimensions",
    "publicAccess",
    "rangeAxisDecimals",
    "rangeAxisLabel",
    "rangeAxisMaxValue",
    "rangeAxisMinValue",
    "rangeAxisSteps",
    "regression",
    "regressionType",
    "relativePeriods",
    "reportingParams",
    "rowDimensions",
    "rowSubTotals",
    "rowTotals",
    "rows",
    "series",
    "seriesKey",
    "sharing",
    "shortName",
    "showData",
    "showDimensionLabels",
    "showHierarchy",
    "skipRounding",
    "sortOrder",
    "startDate",
    "subscribed",
    "subscribers",
    "subtitle",
    "targetLineLabel",
    "targetLineValue",
    "timeField",
    "title",
    "topLimit",
    "translations",
    "type",
    "user",
    "userAccesses",
    "userGroupAccesses",
    "userOrgUnitType",
    "userOrganisationUnit",
    "userOrganisationUnitChildren",
    "userOrganisationUnitGrandChildren",
    "visualizationPeriodName",
    "yearlySeries"
})
@Generated("jsonschema2pojo")
public class Visualization implements Serializable
{

    @JsonProperty("access")
    private Access access;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("aggregationType")
    private Visualization.AggregationType aggregationType;
    @JsonProperty("attributeDimensions")
    private List<TrackedEntityAttributeDimension> attributeDimensions = null;
    @JsonProperty("attributeValues")
    private List<AttributeValue> attributeValues = null;
    @JsonProperty("axes")
    private List<AxisV2> axes = null;
    @JsonProperty("baseLineLabel")
    private String baseLineLabel;
    @JsonProperty("baseLineValue")
    private Double baseLineValue;
    @JsonProperty("categoryDimensions")
    private List<CategoryDimension> categoryDimensions = null;
    @JsonProperty("categoryOptionGroupSetDimensions")
    private List<CategoryOptionGroupSetDimension> categoryOptionGroupSetDimensions = null;
    @JsonProperty("code")
    private String code;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("colSubTotals")
    private Boolean colSubTotals;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("colTotals")
    private Boolean colTotals;
    @JsonProperty("colorSet")
    private String colorSet;
    @JsonProperty("columnDimensions")
    private List<String> columnDimensions = null;
    @JsonProperty("columns")
    private List<RefDimensionalObject> columns = null;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("completedOnly")
    private Boolean completedOnly;
    @JsonProperty("created")
    private Date created;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private RefUser createdBy;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("cumulativeValues")
    private Boolean cumulativeValues;
    @JsonProperty("dataDimensionItems")
    private List<DataDimensionItem> dataDimensionItems = null;
    @JsonProperty("dataElementDimensions")
    private List<TrackedEntityDataElementDimension> dataElementDimensions = null;
    @JsonProperty("dataElementGroupSetDimensions")
    private List<DataElementGroupSetDimension> dataElementGroupSetDimensions = null;
    @JsonProperty("description")
    private String description;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("digitGroupSeparator")
    private Visualization.DigitGroupSeparator digitGroupSeparator;
    @JsonProperty("displayBaseLineLabel")
    private String displayBaseLineLabel;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("displayDensity")
    private Visualization.DisplayDensity displayDensity;
    @JsonProperty("displayDescription")
    private String displayDescription;
    @JsonProperty("displayDomainAxisLabel")
    private String displayDomainAxisLabel;
    @JsonProperty("displayFormName")
    private String displayFormName;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("displayRangeAxisLabel")
    private String displayRangeAxisLabel;
    @JsonProperty("displayShortName")
    private String displayShortName;
    @JsonProperty("displaySubtitle")
    private String displaySubtitle;
    @JsonProperty("displayTargetLineLabel")
    private String displayTargetLineLabel;
    @JsonProperty("displayTitle")
    private String displayTitle;
    @JsonProperty("domainAxisLabel")
    private String domainAxisLabel;
    @JsonProperty("endDate")
    private Date endDate;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("favorite")
    private Boolean favorite;
    @JsonProperty("favorites")
    private List<String> favorites = null;
    @JsonProperty("filterDimensions")
    private List<String> filterDimensions = null;
    @JsonProperty("filters")
    private List<RefDimensionalObject> filters = null;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("fixColumnHeaders")
    private Boolean fixColumnHeaders;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("fixRowHeaders")
    private Boolean fixRowHeaders;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("fontSize")
    private Visualization.FontSize fontSize;
    @JsonProperty("fontStyle")
    private VisualizationFontStyle fontStyle;
    @JsonProperty("formName")
    private String formName;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("hideEmptyColumns")
    private Boolean hideEmptyColumns;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("hideEmptyRowItems")
    private Visualization.HideEmptyRowItems hideEmptyRowItems;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("hideEmptyRows")
    private Boolean hideEmptyRows;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("hideLegend")
    private Boolean hideLegend;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("hideSubtitle")
    private Boolean hideSubtitle;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("hideTitle")
    private Boolean hideTitle;
    @JsonProperty("href")
    private String href;
    @JsonProperty("icons")
    private List<Icon> icons = null;
    @JsonProperty("id")
    private String id;
    @JsonProperty("interpretations")
    private List<RefInterpretation> interpretations = null;
    @JsonProperty("itemOrganisationUnitGroups")
    private List<RefOrganisationUnitGroup> itemOrganisationUnitGroups = null;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private RefUser lastUpdatedBy;
    @JsonProperty("legend")
    private LegendDefinitions legend;
    @JsonProperty("measureCriteria")
    private String measureCriteria;
    @JsonProperty("name")
    private String name;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("noSpaceBetweenColumns")
    private Boolean noSpaceBetweenColumns;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("numberType")
    private Visualization.NumberType numberType;
    @JsonProperty("optionalAxes")
    private List<Axis> optionalAxes = null;
    @JsonProperty("orgUnitField")
    private String orgUnitField;
    @JsonProperty("organisationUnitGroupSetDimensions")
    private List<OrganisationUnitGroupSetDimension> organisationUnitGroupSetDimensions = null;
    @JsonProperty("organisationUnitLevels")
    private List<Integer> organisationUnitLevels = null;
    @JsonProperty("organisationUnits")
    private List<RefOrganisationUnit> organisationUnits = null;
    @JsonProperty("outlierAnalysis")
    private OutlierAnalysis outlierAnalysis;
    @JsonProperty("parentGraphMap")
    private ParentGraphMap__2 parentGraphMap;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("percentStackedValues")
    private Boolean percentStackedValues;
    @JsonProperty("periods")
    private List<String> periods = null;
    @JsonProperty("programIndicatorDimensions")
    private List<TrackedEntityProgramIndicatorDimension> programIndicatorDimensions = null;
    @JsonProperty("publicAccess")
    private String publicAccess;
    @JsonProperty("rangeAxisDecimals")
    private Integer rangeAxisDecimals;
    @JsonProperty("rangeAxisLabel")
    private String rangeAxisLabel;
    @JsonProperty("rangeAxisMaxValue")
    private Double rangeAxisMaxValue;
    @JsonProperty("rangeAxisMinValue")
    private Double rangeAxisMinValue;
    @JsonProperty("rangeAxisSteps")
    private Integer rangeAxisSteps;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("regression")
    private Boolean regression;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("regressionType")
    private Visualization.RegressionType regressionType;
    @JsonProperty("relativePeriods")
    private RelativePeriods relativePeriods;
    @JsonProperty("reportingParams")
    private ReportingParams reportingParams;
    @JsonProperty("rowDimensions")
    private List<String> rowDimensions = null;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("rowSubTotals")
    private Boolean rowSubTotals;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("rowTotals")
    private Boolean rowTotals;
    @JsonProperty("rows")
    private List<RefDimensionalObject> rows = null;
    @JsonProperty("series")
    private List<Series> series = null;
    @JsonProperty("seriesKey")
    private SeriesKey seriesKey;
    @JsonProperty("sharing")
    private Sharing sharing;
    @JsonProperty("shortName")
    private String shortName;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("showData")
    private Boolean showData;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("showDimensionLabels")
    private Boolean showDimensionLabels;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("showHierarchy")
    private Boolean showHierarchy;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("skipRounding")
    private Boolean skipRounding;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("sortOrder")
    private Integer sortOrder;
    @JsonProperty("startDate")
    private Date startDate;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("subscribed")
    private Boolean subscribed;
    @JsonProperty("subscribers")
    private List<String> subscribers = null;
    @JsonProperty("subtitle")
    private String subtitle;
    @JsonProperty("targetLineLabel")
    private String targetLineLabel;
    @JsonProperty("targetLineValue")
    private Double targetLineValue;
    @JsonProperty("timeField")
    private String timeField;
    @JsonProperty("title")
    private String title;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("topLimit")
    private Integer topLimit;
    @JsonProperty("translations")
    private List<Translation> translations = null;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("type")
    private Visualization.Type type;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private RefUser user;
    @JsonProperty("userAccesses")
    private List<UserAccess> userAccesses = null;
    @JsonProperty("userGroupAccesses")
    private List<UserGroupAccess> userGroupAccesses = null;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("userOrgUnitType")
    private Visualization.UserOrgUnitType userOrgUnitType;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("userOrganisationUnit")
    private Boolean userOrganisationUnit;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("userOrganisationUnitChildren")
    private Boolean userOrganisationUnitChildren;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("userOrganisationUnitGrandChildren")
    private Boolean userOrganisationUnitGrandChildren;
    @JsonProperty("visualizationPeriodName")
    private String visualizationPeriodName;
    @JsonProperty("yearlySeries")
    private List<String> yearlySeries = null;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 2009192433816761503L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Visualization() {
    }

    /**
     * 
     * @param source
     */
    public Visualization(Visualization source) {
        super();
        this.access = source.access;
        this.aggregationType = source.aggregationType;
        this.attributeDimensions = source.attributeDimensions;
        this.attributeValues = source.attributeValues;
        this.axes = source.axes;
        this.baseLineLabel = source.baseLineLabel;
        this.baseLineValue = source.baseLineValue;
        this.categoryDimensions = source.categoryDimensions;
        this.categoryOptionGroupSetDimensions = source.categoryOptionGroupSetDimensions;
        this.code = source.code;
        this.colSubTotals = source.colSubTotals;
        this.colTotals = source.colTotals;
        this.colorSet = source.colorSet;
        this.columnDimensions = source.columnDimensions;
        this.columns = source.columns;
        this.completedOnly = source.completedOnly;
        this.created = source.created;
        this.createdBy = source.createdBy;
        this.cumulativeValues = source.cumulativeValues;
        this.dataDimensionItems = source.dataDimensionItems;
        this.dataElementDimensions = source.dataElementDimensions;
        this.dataElementGroupSetDimensions = source.dataElementGroupSetDimensions;
        this.description = source.description;
        this.digitGroupSeparator = source.digitGroupSeparator;
        this.displayBaseLineLabel = source.displayBaseLineLabel;
        this.displayDensity = source.displayDensity;
        this.displayDescription = source.displayDescription;
        this.displayDomainAxisLabel = source.displayDomainAxisLabel;
        this.displayFormName = source.displayFormName;
        this.displayName = source.displayName;
        this.displayRangeAxisLabel = source.displayRangeAxisLabel;
        this.displayShortName = source.displayShortName;
        this.displaySubtitle = source.displaySubtitle;
        this.displayTargetLineLabel = source.displayTargetLineLabel;
        this.displayTitle = source.displayTitle;
        this.domainAxisLabel = source.domainAxisLabel;
        this.endDate = source.endDate;
        this.externalAccess = source.externalAccess;
        this.favorite = source.favorite;
        this.favorites = source.favorites;
        this.filterDimensions = source.filterDimensions;
        this.filters = source.filters;
        this.fixColumnHeaders = source.fixColumnHeaders;
        this.fixRowHeaders = source.fixRowHeaders;
        this.fontSize = source.fontSize;
        this.fontStyle = source.fontStyle;
        this.formName = source.formName;
        this.hideEmptyColumns = source.hideEmptyColumns;
        this.hideEmptyRowItems = source.hideEmptyRowItems;
        this.hideEmptyRows = source.hideEmptyRows;
        this.hideLegend = source.hideLegend;
        this.hideSubtitle = source.hideSubtitle;
        this.hideTitle = source.hideTitle;
        this.href = source.href;
        this.icons = source.icons;
        this.id = source.id;
        this.interpretations = source.interpretations;
        this.itemOrganisationUnitGroups = source.itemOrganisationUnitGroups;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.legend = source.legend;
        this.measureCriteria = source.measureCriteria;
        this.name = source.name;
        this.noSpaceBetweenColumns = source.noSpaceBetweenColumns;
        this.numberType = source.numberType;
        this.optionalAxes = source.optionalAxes;
        this.orgUnitField = source.orgUnitField;
        this.organisationUnitGroupSetDimensions = source.organisationUnitGroupSetDimensions;
        this.organisationUnitLevels = source.organisationUnitLevels;
        this.organisationUnits = source.organisationUnits;
        this.outlierAnalysis = source.outlierAnalysis;
        this.parentGraphMap = source.parentGraphMap;
        this.percentStackedValues = source.percentStackedValues;
        this.periods = source.periods;
        this.programIndicatorDimensions = source.programIndicatorDimensions;
        this.publicAccess = source.publicAccess;
        this.rangeAxisDecimals = source.rangeAxisDecimals;
        this.rangeAxisLabel = source.rangeAxisLabel;
        this.rangeAxisMaxValue = source.rangeAxisMaxValue;
        this.rangeAxisMinValue = source.rangeAxisMinValue;
        this.rangeAxisSteps = source.rangeAxisSteps;
        this.regression = source.regression;
        this.regressionType = source.regressionType;
        this.relativePeriods = source.relativePeriods;
        this.reportingParams = source.reportingParams;
        this.rowDimensions = source.rowDimensions;
        this.rowSubTotals = source.rowSubTotals;
        this.rowTotals = source.rowTotals;
        this.rows = source.rows;
        this.series = source.series;
        this.seriesKey = source.seriesKey;
        this.sharing = source.sharing;
        this.shortName = source.shortName;
        this.showData = source.showData;
        this.showDimensionLabels = source.showDimensionLabels;
        this.showHierarchy = source.showHierarchy;
        this.skipRounding = source.skipRounding;
        this.sortOrder = source.sortOrder;
        this.startDate = source.startDate;
        this.subscribed = source.subscribed;
        this.subscribers = source.subscribers;
        this.subtitle = source.subtitle;
        this.targetLineLabel = source.targetLineLabel;
        this.targetLineValue = source.targetLineValue;
        this.timeField = source.timeField;
        this.title = source.title;
        this.topLimit = source.topLimit;
        this.translations = source.translations;
        this.type = source.type;
        this.user = source.user;
        this.userAccesses = source.userAccesses;
        this.userGroupAccesses = source.userGroupAccesses;
        this.userOrgUnitType = source.userOrgUnitType;
        this.userOrganisationUnit = source.userOrganisationUnit;
        this.userOrganisationUnitChildren = source.userOrganisationUnitChildren;
        this.userOrganisationUnitGrandChildren = source.userOrganisationUnitGrandChildren;
        this.visualizationPeriodName = source.visualizationPeriodName;
        this.yearlySeries = source.yearlySeries;
    }

    /**
     * 
     * @param dataElementGroupSetDimensions
     * @param orgUnitField
     * @param endDate
     * @param baseLineValue
     * @param legend
     * @param publicAccess
     * @param userOrganisationUnitChildren
     * @param axes
     * @param displaySubtitle
     * @param type
     * @param hideEmptyColumns
     * @param measureCriteria
     * @param displayTitle
     * @param lastUpdated
     * @param subscribed
     * @param displayTargetLineLabel
     * @param attributeDimensions
     * @param translations
     * @param yearlySeries
     * @param userOrganisationUnit
     * @param filterDimensions
     * @param href
     * @param id
     * @param rowSubTotals
     * @param interpretations
     * @param displayDescription
     * @param visualizationPeriodName
     * @param userGroupAccesses
     * @param domainAxisLabel
     * @param subscribers
     * @param cumulativeValues
     * @param fontStyle
     * @param optionalAxes
     * @param showDimensionLabels
     * @param sortOrder
     * @param subtitle
     * @param fontSize
     * @param rangeAxisDecimals
     * @param shortName
     * @param favorite
     * @param topLimit
     * @param startDate
     * @param access
     * @param userOrganisationUnitGrandChildren
     * @param columns
     * @param displayName
     * @param displayShortName
     * @param percentStackedValues
     * @param noSpaceBetweenColumns
     * @param dataElementDimensions
     * @param rangeAxisSteps
     * @param formName
     * @param periods
     * @param categoryDimensions
     * @param showHierarchy
     * @param displayRangeAxisLabel
     * @param seriesKey
     * @param reportingParams
     * @param hideTitle
     * @param rowDimensions
     * @param series
     * @param colorSet
     * @param displayBaseLineLabel
     * @param skipRounding
     * @param showData
     * @param fixRowHeaders
     * @param numberType
     * @param hideEmptyRows
     * @param parentGraphMap
     * @param itemOrganisationUnitGroups
     * @param displayDensity
     * @param lastUpdatedBy
     * @param displayDomainAxisLabel
     * @param programIndicatorDimensions
     * @param created
     * @param rangeAxisLabel
     * @param attributeValues
     * @param columnDimensions
     * @param regressionType
     * @param completedOnly
     * @param colTotals
     * @param sharing
     * @param displayFormName
     * @param userAccesses
     * @param name
     * @param hideEmptyRowItems
     * @param favorites
     * @param aggregationType
     * @param dataDimensionItems
     * @param categoryOptionGroupSetDimensions
     * @param code
     * @param hideSubtitle
     * @param description
     * @param organisationUnitGroupSetDimensions
     * @param title
     * @param hideLegend
     * @param fixColumnHeaders
     * @param externalAccess
     * @param organisationUnitLevels
     * @param rangeAxisMinValue
     * @param colSubTotals
     * @param relativePeriods
     * @param targetLineLabel
     * @param organisationUnits
     * @param rowTotals
     * @param timeField
     * @param targetLineValue
     * @param filters
     * @param icons
     * @param rows
     * @param outlierAnalysis
     * @param baseLineLabel
     * @param digitGroupSeparator
     * @param createdBy
     * @param regression
     * @param userOrgUnitType
     * @param rangeAxisMaxValue
     * @param user
     */
    public Visualization(Access access, Visualization.AggregationType aggregationType, List<TrackedEntityAttributeDimension> attributeDimensions, List<AttributeValue> attributeValues, List<AxisV2> axes, String baseLineLabel, Double baseLineValue, List<CategoryDimension> categoryDimensions, List<CategoryOptionGroupSetDimension> categoryOptionGroupSetDimensions, String code, Boolean colSubTotals, Boolean colTotals, String colorSet, List<String> columnDimensions, List<RefDimensionalObject> columns, Boolean completedOnly, Date created, RefUser createdBy, Boolean cumulativeValues, List<DataDimensionItem> dataDimensionItems, List<TrackedEntityDataElementDimension> dataElementDimensions, List<DataElementGroupSetDimension> dataElementGroupSetDimensions, String description, Visualization.DigitGroupSeparator digitGroupSeparator, String displayBaseLineLabel, Visualization.DisplayDensity displayDensity, String displayDescription, String displayDomainAxisLabel, String displayFormName, String displayName, String displayRangeAxisLabel, String displayShortName, String displaySubtitle, String displayTargetLineLabel, String displayTitle, String domainAxisLabel, Date endDate, Boolean externalAccess, Boolean favorite, List<String> favorites, List<String> filterDimensions, List<RefDimensionalObject> filters, Boolean fixColumnHeaders, Boolean fixRowHeaders, Visualization.FontSize fontSize, VisualizationFontStyle fontStyle, String formName, Boolean hideEmptyColumns, Visualization.HideEmptyRowItems hideEmptyRowItems, Boolean hideEmptyRows, Boolean hideLegend, Boolean hideSubtitle, Boolean hideTitle, String href, List<Icon> icons, String id, List<RefInterpretation> interpretations, List<RefOrganisationUnitGroup> itemOrganisationUnitGroups, Date lastUpdated, RefUser lastUpdatedBy, LegendDefinitions legend, String measureCriteria, String name, Boolean noSpaceBetweenColumns, Visualization.NumberType numberType, List<Axis> optionalAxes, String orgUnitField, List<OrganisationUnitGroupSetDimension> organisationUnitGroupSetDimensions, List<Integer> organisationUnitLevels, List<RefOrganisationUnit> organisationUnits, OutlierAnalysis outlierAnalysis, ParentGraphMap__2 parentGraphMap, Boolean percentStackedValues, List<String> periods, List<TrackedEntityProgramIndicatorDimension> programIndicatorDimensions, String publicAccess, Integer rangeAxisDecimals, String rangeAxisLabel, Double rangeAxisMaxValue, Double rangeAxisMinValue, Integer rangeAxisSteps, Boolean regression, Visualization.RegressionType regressionType, RelativePeriods relativePeriods, ReportingParams reportingParams, List<String> rowDimensions, Boolean rowSubTotals, Boolean rowTotals, List<RefDimensionalObject> rows, List<Series> series, SeriesKey seriesKey, Sharing sharing, String shortName, Boolean showData, Boolean showDimensionLabels, Boolean showHierarchy, Boolean skipRounding, Integer sortOrder, Date startDate, Boolean subscribed, List<String> subscribers, String subtitle, String targetLineLabel, Double targetLineValue, String timeField, String title, Integer topLimit, List<Translation> translations, Visualization.Type type, RefUser user, List<UserAccess> userAccesses, List<UserGroupAccess> userGroupAccesses, Visualization.UserOrgUnitType userOrgUnitType, Boolean userOrganisationUnit, Boolean userOrganisationUnitChildren, Boolean userOrganisationUnitGrandChildren, String visualizationPeriodName, List<String> yearlySeries) {
        super();
        this.access = access;
        this.aggregationType = aggregationType;
        this.attributeDimensions = attributeDimensions;
        this.attributeValues = attributeValues;
        this.axes = axes;
        this.baseLineLabel = baseLineLabel;
        this.baseLineValue = baseLineValue;
        this.categoryDimensions = categoryDimensions;
        this.categoryOptionGroupSetDimensions = categoryOptionGroupSetDimensions;
        this.code = code;
        this.colSubTotals = colSubTotals;
        this.colTotals = colTotals;
        this.colorSet = colorSet;
        this.columnDimensions = columnDimensions;
        this.columns = columns;
        this.completedOnly = completedOnly;
        this.created = created;
        this.createdBy = createdBy;
        this.cumulativeValues = cumulativeValues;
        this.dataDimensionItems = dataDimensionItems;
        this.dataElementDimensions = dataElementDimensions;
        this.dataElementGroupSetDimensions = dataElementGroupSetDimensions;
        this.description = description;
        this.digitGroupSeparator = digitGroupSeparator;
        this.displayBaseLineLabel = displayBaseLineLabel;
        this.displayDensity = displayDensity;
        this.displayDescription = displayDescription;
        this.displayDomainAxisLabel = displayDomainAxisLabel;
        this.displayFormName = displayFormName;
        this.displayName = displayName;
        this.displayRangeAxisLabel = displayRangeAxisLabel;
        this.displayShortName = displayShortName;
        this.displaySubtitle = displaySubtitle;
        this.displayTargetLineLabel = displayTargetLineLabel;
        this.displayTitle = displayTitle;
        this.domainAxisLabel = domainAxisLabel;
        this.endDate = endDate;
        this.externalAccess = externalAccess;
        this.favorite = favorite;
        this.favorites = favorites;
        this.filterDimensions = filterDimensions;
        this.filters = filters;
        this.fixColumnHeaders = fixColumnHeaders;
        this.fixRowHeaders = fixRowHeaders;
        this.fontSize = fontSize;
        this.fontStyle = fontStyle;
        this.formName = formName;
        this.hideEmptyColumns = hideEmptyColumns;
        this.hideEmptyRowItems = hideEmptyRowItems;
        this.hideEmptyRows = hideEmptyRows;
        this.hideLegend = hideLegend;
        this.hideSubtitle = hideSubtitle;
        this.hideTitle = hideTitle;
        this.href = href;
        this.icons = icons;
        this.id = id;
        this.interpretations = interpretations;
        this.itemOrganisationUnitGroups = itemOrganisationUnitGroups;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedBy = lastUpdatedBy;
        this.legend = legend;
        this.measureCriteria = measureCriteria;
        this.name = name;
        this.noSpaceBetweenColumns = noSpaceBetweenColumns;
        this.numberType = numberType;
        this.optionalAxes = optionalAxes;
        this.orgUnitField = orgUnitField;
        this.organisationUnitGroupSetDimensions = organisationUnitGroupSetDimensions;
        this.organisationUnitLevels = organisationUnitLevels;
        this.organisationUnits = organisationUnits;
        this.outlierAnalysis = outlierAnalysis;
        this.parentGraphMap = parentGraphMap;
        this.percentStackedValues = percentStackedValues;
        this.periods = periods;
        this.programIndicatorDimensions = programIndicatorDimensions;
        this.publicAccess = publicAccess;
        this.rangeAxisDecimals = rangeAxisDecimals;
        this.rangeAxisLabel = rangeAxisLabel;
        this.rangeAxisMaxValue = rangeAxisMaxValue;
        this.rangeAxisMinValue = rangeAxisMinValue;
        this.rangeAxisSteps = rangeAxisSteps;
        this.regression = regression;
        this.regressionType = regressionType;
        this.relativePeriods = relativePeriods;
        this.reportingParams = reportingParams;
        this.rowDimensions = rowDimensions;
        this.rowSubTotals = rowSubTotals;
        this.rowTotals = rowTotals;
        this.rows = rows;
        this.series = series;
        this.seriesKey = seriesKey;
        this.sharing = sharing;
        this.shortName = shortName;
        this.showData = showData;
        this.showDimensionLabels = showDimensionLabels;
        this.showHierarchy = showHierarchy;
        this.skipRounding = skipRounding;
        this.sortOrder = sortOrder;
        this.startDate = startDate;
        this.subscribed = subscribed;
        this.subscribers = subscribers;
        this.subtitle = subtitle;
        this.targetLineLabel = targetLineLabel;
        this.targetLineValue = targetLineValue;
        this.timeField = timeField;
        this.title = title;
        this.topLimit = topLimit;
        this.translations = translations;
        this.type = type;
        this.user = user;
        this.userAccesses = userAccesses;
        this.userGroupAccesses = userGroupAccesses;
        this.userOrgUnitType = userOrgUnitType;
        this.userOrganisationUnit = userOrganisationUnit;
        this.userOrganisationUnitChildren = userOrganisationUnitChildren;
        this.userOrganisationUnitGrandChildren = userOrganisationUnitGrandChildren;
        this.visualizationPeriodName = visualizationPeriodName;
        this.yearlySeries = yearlySeries;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public Visualization withAccess(Access access) {
        this.access = access;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("aggregationType")
    public Visualization.AggregationType getAggregationType() {
        return aggregationType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("aggregationType")
    public void setAggregationType(Visualization.AggregationType aggregationType) {
        this.aggregationType = aggregationType;
    }

    public Visualization withAggregationType(Visualization.AggregationType aggregationType) {
        this.aggregationType = aggregationType;
        return this;
    }

    @JsonProperty("attributeDimensions")
    public Optional<List<TrackedEntityAttributeDimension>> getAttributeDimensions() {
        return Optional.ofNullable(attributeDimensions);
    }

    @JsonProperty("attributeDimensions")
    public void setAttributeDimensions(List<TrackedEntityAttributeDimension> attributeDimensions) {
        this.attributeDimensions = attributeDimensions;
    }

    public Visualization withAttributeDimensions(List<TrackedEntityAttributeDimension> attributeDimensions) {
        this.attributeDimensions = attributeDimensions;
        return this;
    }

    @JsonProperty("attributeValues")
    public Optional<List<AttributeValue>> getAttributeValues() {
        return Optional.ofNullable(attributeValues);
    }

    @JsonProperty("attributeValues")
    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public Visualization withAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    @JsonProperty("axes")
    public Optional<List<AxisV2>> getAxes() {
        return Optional.ofNullable(axes);
    }

    @JsonProperty("axes")
    public void setAxes(List<AxisV2> axes) {
        this.axes = axes;
    }

    public Visualization withAxes(List<AxisV2> axes) {
        this.axes = axes;
        return this;
    }

    @JsonProperty("baseLineLabel")
    public Optional<String> getBaseLineLabel() {
        return Optional.ofNullable(baseLineLabel);
    }

    @JsonProperty("baseLineLabel")
    public void setBaseLineLabel(String baseLineLabel) {
        this.baseLineLabel = baseLineLabel;
    }

    public Visualization withBaseLineLabel(String baseLineLabel) {
        this.baseLineLabel = baseLineLabel;
        return this;
    }

    @JsonProperty("baseLineValue")
    public Optional<Double> getBaseLineValue() {
        return Optional.ofNullable(baseLineValue);
    }

    @JsonProperty("baseLineValue")
    public void setBaseLineValue(Double baseLineValue) {
        this.baseLineValue = baseLineValue;
    }

    public Visualization withBaseLineValue(Double baseLineValue) {
        this.baseLineValue = baseLineValue;
        return this;
    }

    @JsonProperty("categoryDimensions")
    public Optional<List<CategoryDimension>> getCategoryDimensions() {
        return Optional.ofNullable(categoryDimensions);
    }

    @JsonProperty("categoryDimensions")
    public void setCategoryDimensions(List<CategoryDimension> categoryDimensions) {
        this.categoryDimensions = categoryDimensions;
    }

    public Visualization withCategoryDimensions(List<CategoryDimension> categoryDimensions) {
        this.categoryDimensions = categoryDimensions;
        return this;
    }

    @JsonProperty("categoryOptionGroupSetDimensions")
    public Optional<List<CategoryOptionGroupSetDimension>> getCategoryOptionGroupSetDimensions() {
        return Optional.ofNullable(categoryOptionGroupSetDimensions);
    }

    @JsonProperty("categoryOptionGroupSetDimensions")
    public void setCategoryOptionGroupSetDimensions(List<CategoryOptionGroupSetDimension> categoryOptionGroupSetDimensions) {
        this.categoryOptionGroupSetDimensions = categoryOptionGroupSetDimensions;
    }

    public Visualization withCategoryOptionGroupSetDimensions(List<CategoryOptionGroupSetDimension> categoryOptionGroupSetDimensions) {
        this.categoryOptionGroupSetDimensions = categoryOptionGroupSetDimensions;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public Visualization withCode(String code) {
        this.code = code;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("colSubTotals")
    public Boolean getColSubTotals() {
        return colSubTotals;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("colSubTotals")
    public void setColSubTotals(Boolean colSubTotals) {
        this.colSubTotals = colSubTotals;
    }

    public Visualization withColSubTotals(Boolean colSubTotals) {
        this.colSubTotals = colSubTotals;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("colTotals")
    public Boolean getColTotals() {
        return colTotals;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("colTotals")
    public void setColTotals(Boolean colTotals) {
        this.colTotals = colTotals;
    }

    public Visualization withColTotals(Boolean colTotals) {
        this.colTotals = colTotals;
        return this;
    }

    @JsonProperty("colorSet")
    public Optional<String> getColorSet() {
        return Optional.ofNullable(colorSet);
    }

    @JsonProperty("colorSet")
    public void setColorSet(String colorSet) {
        this.colorSet = colorSet;
    }

    public Visualization withColorSet(String colorSet) {
        this.colorSet = colorSet;
        return this;
    }

    @JsonProperty("columnDimensions")
    public Optional<List<String>> getColumnDimensions() {
        return Optional.ofNullable(columnDimensions);
    }

    @JsonProperty("columnDimensions")
    public void setColumnDimensions(List<String> columnDimensions) {
        this.columnDimensions = columnDimensions;
    }

    public Visualization withColumnDimensions(List<String> columnDimensions) {
        this.columnDimensions = columnDimensions;
        return this;
    }

    @JsonProperty("columns")
    public Optional<List<RefDimensionalObject>> getColumns() {
        return Optional.ofNullable(columns);
    }

    @JsonProperty("columns")
    public void setColumns(List<RefDimensionalObject> columns) {
        this.columns = columns;
    }

    public Visualization withColumns(List<RefDimensionalObject> columns) {
        this.columns = columns;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("completedOnly")
    public Boolean getCompletedOnly() {
        return completedOnly;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("completedOnly")
    public void setCompletedOnly(Boolean completedOnly) {
        this.completedOnly = completedOnly;
    }

    public Visualization withCompletedOnly(Boolean completedOnly) {
        this.completedOnly = completedOnly;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public Visualization withCreated(Date created) {
        this.created = created;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    public Optional<RefUser> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    public void setCreatedBy(RefUser createdBy) {
        this.createdBy = createdBy;
    }

    public Visualization withCreatedBy(RefUser createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("cumulativeValues")
    public Boolean getCumulativeValues() {
        return cumulativeValues;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("cumulativeValues")
    public void setCumulativeValues(Boolean cumulativeValues) {
        this.cumulativeValues = cumulativeValues;
    }

    public Visualization withCumulativeValues(Boolean cumulativeValues) {
        this.cumulativeValues = cumulativeValues;
        return this;
    }

    @JsonProperty("dataDimensionItems")
    public Optional<List<DataDimensionItem>> getDataDimensionItems() {
        return Optional.ofNullable(dataDimensionItems);
    }

    @JsonProperty("dataDimensionItems")
    public void setDataDimensionItems(List<DataDimensionItem> dataDimensionItems) {
        this.dataDimensionItems = dataDimensionItems;
    }

    public Visualization withDataDimensionItems(List<DataDimensionItem> dataDimensionItems) {
        this.dataDimensionItems = dataDimensionItems;
        return this;
    }

    @JsonProperty("dataElementDimensions")
    public Optional<List<TrackedEntityDataElementDimension>> getDataElementDimensions() {
        return Optional.ofNullable(dataElementDimensions);
    }

    @JsonProperty("dataElementDimensions")
    public void setDataElementDimensions(List<TrackedEntityDataElementDimension> dataElementDimensions) {
        this.dataElementDimensions = dataElementDimensions;
    }

    public Visualization withDataElementDimensions(List<TrackedEntityDataElementDimension> dataElementDimensions) {
        this.dataElementDimensions = dataElementDimensions;
        return this;
    }

    @JsonProperty("dataElementGroupSetDimensions")
    public Optional<List<DataElementGroupSetDimension>> getDataElementGroupSetDimensions() {
        return Optional.ofNullable(dataElementGroupSetDimensions);
    }

    @JsonProperty("dataElementGroupSetDimensions")
    public void setDataElementGroupSetDimensions(List<DataElementGroupSetDimension> dataElementGroupSetDimensions) {
        this.dataElementGroupSetDimensions = dataElementGroupSetDimensions;
    }

    public Visualization withDataElementGroupSetDimensions(List<DataElementGroupSetDimension> dataElementGroupSetDimensions) {
        this.dataElementGroupSetDimensions = dataElementGroupSetDimensions;
        return this;
    }

    @JsonProperty("description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    public Visualization withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("digitGroupSeparator")
    public Visualization.DigitGroupSeparator getDigitGroupSeparator() {
        return digitGroupSeparator;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("digitGroupSeparator")
    public void setDigitGroupSeparator(Visualization.DigitGroupSeparator digitGroupSeparator) {
        this.digitGroupSeparator = digitGroupSeparator;
    }

    public Visualization withDigitGroupSeparator(Visualization.DigitGroupSeparator digitGroupSeparator) {
        this.digitGroupSeparator = digitGroupSeparator;
        return this;
    }

    @JsonProperty("displayBaseLineLabel")
    public Optional<String> getDisplayBaseLineLabel() {
        return Optional.ofNullable(displayBaseLineLabel);
    }

    @JsonProperty("displayBaseLineLabel")
    public void setDisplayBaseLineLabel(String displayBaseLineLabel) {
        this.displayBaseLineLabel = displayBaseLineLabel;
    }

    public Visualization withDisplayBaseLineLabel(String displayBaseLineLabel) {
        this.displayBaseLineLabel = displayBaseLineLabel;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("displayDensity")
    public Visualization.DisplayDensity getDisplayDensity() {
        return displayDensity;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("displayDensity")
    public void setDisplayDensity(Visualization.DisplayDensity displayDensity) {
        this.displayDensity = displayDensity;
    }

    public Visualization withDisplayDensity(Visualization.DisplayDensity displayDensity) {
        this.displayDensity = displayDensity;
        return this;
    }

    @JsonProperty("displayDescription")
    public Optional<String> getDisplayDescription() {
        return Optional.ofNullable(displayDescription);
    }

    @JsonProperty("displayDescription")
    public void setDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
    }

    public Visualization withDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
        return this;
    }

    @JsonProperty("displayDomainAxisLabel")
    public Optional<String> getDisplayDomainAxisLabel() {
        return Optional.ofNullable(displayDomainAxisLabel);
    }

    @JsonProperty("displayDomainAxisLabel")
    public void setDisplayDomainAxisLabel(String displayDomainAxisLabel) {
        this.displayDomainAxisLabel = displayDomainAxisLabel;
    }

    public Visualization withDisplayDomainAxisLabel(String displayDomainAxisLabel) {
        this.displayDomainAxisLabel = displayDomainAxisLabel;
        return this;
    }

    @JsonProperty("displayFormName")
    public Optional<String> getDisplayFormName() {
        return Optional.ofNullable(displayFormName);
    }

    @JsonProperty("displayFormName")
    public void setDisplayFormName(String displayFormName) {
        this.displayFormName = displayFormName;
    }

    public Visualization withDisplayFormName(String displayFormName) {
        this.displayFormName = displayFormName;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Visualization withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("displayRangeAxisLabel")
    public Optional<String> getDisplayRangeAxisLabel() {
        return Optional.ofNullable(displayRangeAxisLabel);
    }

    @JsonProperty("displayRangeAxisLabel")
    public void setDisplayRangeAxisLabel(String displayRangeAxisLabel) {
        this.displayRangeAxisLabel = displayRangeAxisLabel;
    }

    public Visualization withDisplayRangeAxisLabel(String displayRangeAxisLabel) {
        this.displayRangeAxisLabel = displayRangeAxisLabel;
        return this;
    }

    @JsonProperty("displayShortName")
    public Optional<String> getDisplayShortName() {
        return Optional.ofNullable(displayShortName);
    }

    @JsonProperty("displayShortName")
    public void setDisplayShortName(String displayShortName) {
        this.displayShortName = displayShortName;
    }

    public Visualization withDisplayShortName(String displayShortName) {
        this.displayShortName = displayShortName;
        return this;
    }

    @JsonProperty("displaySubtitle")
    public Optional<String> getDisplaySubtitle() {
        return Optional.ofNullable(displaySubtitle);
    }

    @JsonProperty("displaySubtitle")
    public void setDisplaySubtitle(String displaySubtitle) {
        this.displaySubtitle = displaySubtitle;
    }

    public Visualization withDisplaySubtitle(String displaySubtitle) {
        this.displaySubtitle = displaySubtitle;
        return this;
    }

    @JsonProperty("displayTargetLineLabel")
    public Optional<String> getDisplayTargetLineLabel() {
        return Optional.ofNullable(displayTargetLineLabel);
    }

    @JsonProperty("displayTargetLineLabel")
    public void setDisplayTargetLineLabel(String displayTargetLineLabel) {
        this.displayTargetLineLabel = displayTargetLineLabel;
    }

    public Visualization withDisplayTargetLineLabel(String displayTargetLineLabel) {
        this.displayTargetLineLabel = displayTargetLineLabel;
        return this;
    }

    @JsonProperty("displayTitle")
    public Optional<String> getDisplayTitle() {
        return Optional.ofNullable(displayTitle);
    }

    @JsonProperty("displayTitle")
    public void setDisplayTitle(String displayTitle) {
        this.displayTitle = displayTitle;
    }

    public Visualization withDisplayTitle(String displayTitle) {
        this.displayTitle = displayTitle;
        return this;
    }

    @JsonProperty("domainAxisLabel")
    public Optional<String> getDomainAxisLabel() {
        return Optional.ofNullable(domainAxisLabel);
    }

    @JsonProperty("domainAxisLabel")
    public void setDomainAxisLabel(String domainAxisLabel) {
        this.domainAxisLabel = domainAxisLabel;
    }

    public Visualization withDomainAxisLabel(String domainAxisLabel) {
        this.domainAxisLabel = domainAxisLabel;
        return this;
    }

    @JsonProperty("endDate")
    public Optional<Date> getEndDate() {
        return Optional.ofNullable(endDate);
    }

    @JsonProperty("endDate")
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Visualization withEndDate(Date endDate) {
        this.endDate = endDate;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("externalAccess")
    public Boolean getExternalAccess() {
        return externalAccess;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public Visualization withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("favorite")
    public Boolean getFavorite() {
        return favorite;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("favorite")
    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public Visualization withFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public Visualization withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    @JsonProperty("filterDimensions")
    public Optional<List<String>> getFilterDimensions() {
        return Optional.ofNullable(filterDimensions);
    }

    @JsonProperty("filterDimensions")
    public void setFilterDimensions(List<String> filterDimensions) {
        this.filterDimensions = filterDimensions;
    }

    public Visualization withFilterDimensions(List<String> filterDimensions) {
        this.filterDimensions = filterDimensions;
        return this;
    }

    @JsonProperty("filters")
    public Optional<List<RefDimensionalObject>> getFilters() {
        return Optional.ofNullable(filters);
    }

    @JsonProperty("filters")
    public void setFilters(List<RefDimensionalObject> filters) {
        this.filters = filters;
    }

    public Visualization withFilters(List<RefDimensionalObject> filters) {
        this.filters = filters;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("fixColumnHeaders")
    public Boolean getFixColumnHeaders() {
        return fixColumnHeaders;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("fixColumnHeaders")
    public void setFixColumnHeaders(Boolean fixColumnHeaders) {
        this.fixColumnHeaders = fixColumnHeaders;
    }

    public Visualization withFixColumnHeaders(Boolean fixColumnHeaders) {
        this.fixColumnHeaders = fixColumnHeaders;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("fixRowHeaders")
    public Boolean getFixRowHeaders() {
        return fixRowHeaders;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("fixRowHeaders")
    public void setFixRowHeaders(Boolean fixRowHeaders) {
        this.fixRowHeaders = fixRowHeaders;
    }

    public Visualization withFixRowHeaders(Boolean fixRowHeaders) {
        this.fixRowHeaders = fixRowHeaders;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("fontSize")
    public Visualization.FontSize getFontSize() {
        return fontSize;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("fontSize")
    public void setFontSize(Visualization.FontSize fontSize) {
        this.fontSize = fontSize;
    }

    public Visualization withFontSize(Visualization.FontSize fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    @JsonProperty("fontStyle")
    public Optional<VisualizationFontStyle> getFontStyle() {
        return Optional.ofNullable(fontStyle);
    }

    @JsonProperty("fontStyle")
    public void setFontStyle(VisualizationFontStyle fontStyle) {
        this.fontStyle = fontStyle;
    }

    public Visualization withFontStyle(VisualizationFontStyle fontStyle) {
        this.fontStyle = fontStyle;
        return this;
    }

    @JsonProperty("formName")
    public Optional<String> getFormName() {
        return Optional.ofNullable(formName);
    }

    @JsonProperty("formName")
    public void setFormName(String formName) {
        this.formName = formName;
    }

    public Visualization withFormName(String formName) {
        this.formName = formName;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("hideEmptyColumns")
    public Boolean getHideEmptyColumns() {
        return hideEmptyColumns;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("hideEmptyColumns")
    public void setHideEmptyColumns(Boolean hideEmptyColumns) {
        this.hideEmptyColumns = hideEmptyColumns;
    }

    public Visualization withHideEmptyColumns(Boolean hideEmptyColumns) {
        this.hideEmptyColumns = hideEmptyColumns;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("hideEmptyRowItems")
    public Visualization.HideEmptyRowItems getHideEmptyRowItems() {
        return hideEmptyRowItems;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("hideEmptyRowItems")
    public void setHideEmptyRowItems(Visualization.HideEmptyRowItems hideEmptyRowItems) {
        this.hideEmptyRowItems = hideEmptyRowItems;
    }

    public Visualization withHideEmptyRowItems(Visualization.HideEmptyRowItems hideEmptyRowItems) {
        this.hideEmptyRowItems = hideEmptyRowItems;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("hideEmptyRows")
    public Boolean getHideEmptyRows() {
        return hideEmptyRows;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("hideEmptyRows")
    public void setHideEmptyRows(Boolean hideEmptyRows) {
        this.hideEmptyRows = hideEmptyRows;
    }

    public Visualization withHideEmptyRows(Boolean hideEmptyRows) {
        this.hideEmptyRows = hideEmptyRows;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("hideLegend")
    public Boolean getHideLegend() {
        return hideLegend;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("hideLegend")
    public void setHideLegend(Boolean hideLegend) {
        this.hideLegend = hideLegend;
    }

    public Visualization withHideLegend(Boolean hideLegend) {
        this.hideLegend = hideLegend;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("hideSubtitle")
    public Boolean getHideSubtitle() {
        return hideSubtitle;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("hideSubtitle")
    public void setHideSubtitle(Boolean hideSubtitle) {
        this.hideSubtitle = hideSubtitle;
    }

    public Visualization withHideSubtitle(Boolean hideSubtitle) {
        this.hideSubtitle = hideSubtitle;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("hideTitle")
    public Boolean getHideTitle() {
        return hideTitle;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("hideTitle")
    public void setHideTitle(Boolean hideTitle) {
        this.hideTitle = hideTitle;
    }

    public Visualization withHideTitle(Boolean hideTitle) {
        this.hideTitle = hideTitle;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public Visualization withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("icons")
    public Optional<List<Icon>> getIcons() {
        return Optional.ofNullable(icons);
    }

    @JsonProperty("icons")
    public void setIcons(List<Icon> icons) {
        this.icons = icons;
    }

    public Visualization withIcons(List<Icon> icons) {
        this.icons = icons;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public Visualization withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("interpretations")
    public Optional<List<RefInterpretation>> getInterpretations() {
        return Optional.ofNullable(interpretations);
    }

    @JsonProperty("interpretations")
    public void setInterpretations(List<RefInterpretation> interpretations) {
        this.interpretations = interpretations;
    }

    public Visualization withInterpretations(List<RefInterpretation> interpretations) {
        this.interpretations = interpretations;
        return this;
    }

    @JsonProperty("itemOrganisationUnitGroups")
    public Optional<List<RefOrganisationUnitGroup>> getItemOrganisationUnitGroups() {
        return Optional.ofNullable(itemOrganisationUnitGroups);
    }

    @JsonProperty("itemOrganisationUnitGroups")
    public void setItemOrganisationUnitGroups(List<RefOrganisationUnitGroup> itemOrganisationUnitGroups) {
        this.itemOrganisationUnitGroups = itemOrganisationUnitGroups;
    }

    public Visualization withItemOrganisationUnitGroups(List<RefOrganisationUnitGroup> itemOrganisationUnitGroups) {
        this.itemOrganisationUnitGroups = itemOrganisationUnitGroups;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public Visualization withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    public Optional<RefUser> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(RefUser lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public Visualization withLastUpdatedBy(RefUser lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    @JsonProperty("legend")
    public Optional<LegendDefinitions> getLegend() {
        return Optional.ofNullable(legend);
    }

    @JsonProperty("legend")
    public void setLegend(LegendDefinitions legend) {
        this.legend = legend;
    }

    public Visualization withLegend(LegendDefinitions legend) {
        this.legend = legend;
        return this;
    }

    @JsonProperty("measureCriteria")
    public Optional<String> getMeasureCriteria() {
        return Optional.ofNullable(measureCriteria);
    }

    @JsonProperty("measureCriteria")
    public void setMeasureCriteria(String measureCriteria) {
        this.measureCriteria = measureCriteria;
    }

    public Visualization withMeasureCriteria(String measureCriteria) {
        this.measureCriteria = measureCriteria;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public Visualization withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("noSpaceBetweenColumns")
    public Boolean getNoSpaceBetweenColumns() {
        return noSpaceBetweenColumns;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("noSpaceBetweenColumns")
    public void setNoSpaceBetweenColumns(Boolean noSpaceBetweenColumns) {
        this.noSpaceBetweenColumns = noSpaceBetweenColumns;
    }

    public Visualization withNoSpaceBetweenColumns(Boolean noSpaceBetweenColumns) {
        this.noSpaceBetweenColumns = noSpaceBetweenColumns;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("numberType")
    public Visualization.NumberType getNumberType() {
        return numberType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("numberType")
    public void setNumberType(Visualization.NumberType numberType) {
        this.numberType = numberType;
    }

    public Visualization withNumberType(Visualization.NumberType numberType) {
        this.numberType = numberType;
        return this;
    }

    @JsonProperty("optionalAxes")
    public Optional<List<Axis>> getOptionalAxes() {
        return Optional.ofNullable(optionalAxes);
    }

    @JsonProperty("optionalAxes")
    public void setOptionalAxes(List<Axis> optionalAxes) {
        this.optionalAxes = optionalAxes;
    }

    public Visualization withOptionalAxes(List<Axis> optionalAxes) {
        this.optionalAxes = optionalAxes;
        return this;
    }

    @JsonProperty("orgUnitField")
    public Optional<String> getOrgUnitField() {
        return Optional.ofNullable(orgUnitField);
    }

    @JsonProperty("orgUnitField")
    public void setOrgUnitField(String orgUnitField) {
        this.orgUnitField = orgUnitField;
    }

    public Visualization withOrgUnitField(String orgUnitField) {
        this.orgUnitField = orgUnitField;
        return this;
    }

    @JsonProperty("organisationUnitGroupSetDimensions")
    public Optional<List<OrganisationUnitGroupSetDimension>> getOrganisationUnitGroupSetDimensions() {
        return Optional.ofNullable(organisationUnitGroupSetDimensions);
    }

    @JsonProperty("organisationUnitGroupSetDimensions")
    public void setOrganisationUnitGroupSetDimensions(List<OrganisationUnitGroupSetDimension> organisationUnitGroupSetDimensions) {
        this.organisationUnitGroupSetDimensions = organisationUnitGroupSetDimensions;
    }

    public Visualization withOrganisationUnitGroupSetDimensions(List<OrganisationUnitGroupSetDimension> organisationUnitGroupSetDimensions) {
        this.organisationUnitGroupSetDimensions = organisationUnitGroupSetDimensions;
        return this;
    }

    @JsonProperty("organisationUnitLevels")
    public Optional<List<Integer>> getOrganisationUnitLevels() {
        return Optional.ofNullable(organisationUnitLevels);
    }

    @JsonProperty("organisationUnitLevels")
    public void setOrganisationUnitLevels(List<Integer> organisationUnitLevels) {
        this.organisationUnitLevels = organisationUnitLevels;
    }

    public Visualization withOrganisationUnitLevels(List<Integer> organisationUnitLevels) {
        this.organisationUnitLevels = organisationUnitLevels;
        return this;
    }

    @JsonProperty("organisationUnits")
    public Optional<List<RefOrganisationUnit>> getOrganisationUnits() {
        return Optional.ofNullable(organisationUnits);
    }

    @JsonProperty("organisationUnits")
    public void setOrganisationUnits(List<RefOrganisationUnit> organisationUnits) {
        this.organisationUnits = organisationUnits;
    }

    public Visualization withOrganisationUnits(List<RefOrganisationUnit> organisationUnits) {
        this.organisationUnits = organisationUnits;
        return this;
    }

    @JsonProperty("outlierAnalysis")
    public Optional<OutlierAnalysis> getOutlierAnalysis() {
        return Optional.ofNullable(outlierAnalysis);
    }

    @JsonProperty("outlierAnalysis")
    public void setOutlierAnalysis(OutlierAnalysis outlierAnalysis) {
        this.outlierAnalysis = outlierAnalysis;
    }

    public Visualization withOutlierAnalysis(OutlierAnalysis outlierAnalysis) {
        this.outlierAnalysis = outlierAnalysis;
        return this;
    }

    @JsonProperty("parentGraphMap")
    public Optional<ParentGraphMap__2> getParentGraphMap() {
        return Optional.ofNullable(parentGraphMap);
    }

    @JsonProperty("parentGraphMap")
    public void setParentGraphMap(ParentGraphMap__2 parentGraphMap) {
        this.parentGraphMap = parentGraphMap;
    }

    public Visualization withParentGraphMap(ParentGraphMap__2 parentGraphMap) {
        this.parentGraphMap = parentGraphMap;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("percentStackedValues")
    public Boolean getPercentStackedValues() {
        return percentStackedValues;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("percentStackedValues")
    public void setPercentStackedValues(Boolean percentStackedValues) {
        this.percentStackedValues = percentStackedValues;
    }

    public Visualization withPercentStackedValues(Boolean percentStackedValues) {
        this.percentStackedValues = percentStackedValues;
        return this;
    }

    @JsonProperty("periods")
    public Optional<List<String>> getPeriods() {
        return Optional.ofNullable(periods);
    }

    @JsonProperty("periods")
    public void setPeriods(List<String> periods) {
        this.periods = periods;
    }

    public Visualization withPeriods(List<String> periods) {
        this.periods = periods;
        return this;
    }

    @JsonProperty("programIndicatorDimensions")
    public Optional<List<TrackedEntityProgramIndicatorDimension>> getProgramIndicatorDimensions() {
        return Optional.ofNullable(programIndicatorDimensions);
    }

    @JsonProperty("programIndicatorDimensions")
    public void setProgramIndicatorDimensions(List<TrackedEntityProgramIndicatorDimension> programIndicatorDimensions) {
        this.programIndicatorDimensions = programIndicatorDimensions;
    }

    public Visualization withProgramIndicatorDimensions(List<TrackedEntityProgramIndicatorDimension> programIndicatorDimensions) {
        this.programIndicatorDimensions = programIndicatorDimensions;
        return this;
    }

    @JsonProperty("publicAccess")
    public Optional<String> getPublicAccess() {
        return Optional.ofNullable(publicAccess);
    }

    @JsonProperty("publicAccess")
    public void setPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
    }

    public Visualization withPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    @JsonProperty("rangeAxisDecimals")
    public Optional<Integer> getRangeAxisDecimals() {
        return Optional.ofNullable(rangeAxisDecimals);
    }

    @JsonProperty("rangeAxisDecimals")
    public void setRangeAxisDecimals(Integer rangeAxisDecimals) {
        this.rangeAxisDecimals = rangeAxisDecimals;
    }

    public Visualization withRangeAxisDecimals(Integer rangeAxisDecimals) {
        this.rangeAxisDecimals = rangeAxisDecimals;
        return this;
    }

    @JsonProperty("rangeAxisLabel")
    public Optional<String> getRangeAxisLabel() {
        return Optional.ofNullable(rangeAxisLabel);
    }

    @JsonProperty("rangeAxisLabel")
    public void setRangeAxisLabel(String rangeAxisLabel) {
        this.rangeAxisLabel = rangeAxisLabel;
    }

    public Visualization withRangeAxisLabel(String rangeAxisLabel) {
        this.rangeAxisLabel = rangeAxisLabel;
        return this;
    }

    @JsonProperty("rangeAxisMaxValue")
    public Optional<Double> getRangeAxisMaxValue() {
        return Optional.ofNullable(rangeAxisMaxValue);
    }

    @JsonProperty("rangeAxisMaxValue")
    public void setRangeAxisMaxValue(Double rangeAxisMaxValue) {
        this.rangeAxisMaxValue = rangeAxisMaxValue;
    }

    public Visualization withRangeAxisMaxValue(Double rangeAxisMaxValue) {
        this.rangeAxisMaxValue = rangeAxisMaxValue;
        return this;
    }

    @JsonProperty("rangeAxisMinValue")
    public Optional<Double> getRangeAxisMinValue() {
        return Optional.ofNullable(rangeAxisMinValue);
    }

    @JsonProperty("rangeAxisMinValue")
    public void setRangeAxisMinValue(Double rangeAxisMinValue) {
        this.rangeAxisMinValue = rangeAxisMinValue;
    }

    public Visualization withRangeAxisMinValue(Double rangeAxisMinValue) {
        this.rangeAxisMinValue = rangeAxisMinValue;
        return this;
    }

    @JsonProperty("rangeAxisSteps")
    public Optional<Integer> getRangeAxisSteps() {
        return Optional.ofNullable(rangeAxisSteps);
    }

    @JsonProperty("rangeAxisSteps")
    public void setRangeAxisSteps(Integer rangeAxisSteps) {
        this.rangeAxisSteps = rangeAxisSteps;
    }

    public Visualization withRangeAxisSteps(Integer rangeAxisSteps) {
        this.rangeAxisSteps = rangeAxisSteps;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("regression")
    public Boolean getRegression() {
        return regression;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("regression")
    public void setRegression(Boolean regression) {
        this.regression = regression;
    }

    public Visualization withRegression(Boolean regression) {
        this.regression = regression;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("regressionType")
    public Visualization.RegressionType getRegressionType() {
        return regressionType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("regressionType")
    public void setRegressionType(Visualization.RegressionType regressionType) {
        this.regressionType = regressionType;
    }

    public Visualization withRegressionType(Visualization.RegressionType regressionType) {
        this.regressionType = regressionType;
        return this;
    }

    @JsonProperty("relativePeriods")
    public Optional<RelativePeriods> getRelativePeriods() {
        return Optional.ofNullable(relativePeriods);
    }

    @JsonProperty("relativePeriods")
    public void setRelativePeriods(RelativePeriods relativePeriods) {
        this.relativePeriods = relativePeriods;
    }

    public Visualization withRelativePeriods(RelativePeriods relativePeriods) {
        this.relativePeriods = relativePeriods;
        return this;
    }

    @JsonProperty("reportingParams")
    public Optional<ReportingParams> getReportingParams() {
        return Optional.ofNullable(reportingParams);
    }

    @JsonProperty("reportingParams")
    public void setReportingParams(ReportingParams reportingParams) {
        this.reportingParams = reportingParams;
    }

    public Visualization withReportingParams(ReportingParams reportingParams) {
        this.reportingParams = reportingParams;
        return this;
    }

    @JsonProperty("rowDimensions")
    public Optional<List<String>> getRowDimensions() {
        return Optional.ofNullable(rowDimensions);
    }

    @JsonProperty("rowDimensions")
    public void setRowDimensions(List<String> rowDimensions) {
        this.rowDimensions = rowDimensions;
    }

    public Visualization withRowDimensions(List<String> rowDimensions) {
        this.rowDimensions = rowDimensions;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("rowSubTotals")
    public Boolean getRowSubTotals() {
        return rowSubTotals;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("rowSubTotals")
    public void setRowSubTotals(Boolean rowSubTotals) {
        this.rowSubTotals = rowSubTotals;
    }

    public Visualization withRowSubTotals(Boolean rowSubTotals) {
        this.rowSubTotals = rowSubTotals;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("rowTotals")
    public Boolean getRowTotals() {
        return rowTotals;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("rowTotals")
    public void setRowTotals(Boolean rowTotals) {
        this.rowTotals = rowTotals;
    }

    public Visualization withRowTotals(Boolean rowTotals) {
        this.rowTotals = rowTotals;
        return this;
    }

    @JsonProperty("rows")
    public Optional<List<RefDimensionalObject>> getRows() {
        return Optional.ofNullable(rows);
    }

    @JsonProperty("rows")
    public void setRows(List<RefDimensionalObject> rows) {
        this.rows = rows;
    }

    public Visualization withRows(List<RefDimensionalObject> rows) {
        this.rows = rows;
        return this;
    }

    @JsonProperty("series")
    public Optional<List<Series>> getSeries() {
        return Optional.ofNullable(series);
    }

    @JsonProperty("series")
    public void setSeries(List<Series> series) {
        this.series = series;
    }

    public Visualization withSeries(List<Series> series) {
        this.series = series;
        return this;
    }

    @JsonProperty("seriesKey")
    public Optional<SeriesKey> getSeriesKey() {
        return Optional.ofNullable(seriesKey);
    }

    @JsonProperty("seriesKey")
    public void setSeriesKey(SeriesKey seriesKey) {
        this.seriesKey = seriesKey;
    }

    public Visualization withSeriesKey(SeriesKey seriesKey) {
        this.seriesKey = seriesKey;
        return this;
    }

    @JsonProperty("sharing")
    public Optional<Sharing> getSharing() {
        return Optional.ofNullable(sharing);
    }

    @JsonProperty("sharing")
    public void setSharing(Sharing sharing) {
        this.sharing = sharing;
    }

    public Visualization withSharing(Sharing sharing) {
        this.sharing = sharing;
        return this;
    }

    @JsonProperty("shortName")
    public Optional<String> getShortName() {
        return Optional.ofNullable(shortName);
    }

    @JsonProperty("shortName")
    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public Visualization withShortName(String shortName) {
        this.shortName = shortName;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("showData")
    public Boolean getShowData() {
        return showData;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("showData")
    public void setShowData(Boolean showData) {
        this.showData = showData;
    }

    public Visualization withShowData(Boolean showData) {
        this.showData = showData;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("showDimensionLabels")
    public Boolean getShowDimensionLabels() {
        return showDimensionLabels;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("showDimensionLabels")
    public void setShowDimensionLabels(Boolean showDimensionLabels) {
        this.showDimensionLabels = showDimensionLabels;
    }

    public Visualization withShowDimensionLabels(Boolean showDimensionLabels) {
        this.showDimensionLabels = showDimensionLabels;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("showHierarchy")
    public Boolean getShowHierarchy() {
        return showHierarchy;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("showHierarchy")
    public void setShowHierarchy(Boolean showHierarchy) {
        this.showHierarchy = showHierarchy;
    }

    public Visualization withShowHierarchy(Boolean showHierarchy) {
        this.showHierarchy = showHierarchy;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("skipRounding")
    public Boolean getSkipRounding() {
        return skipRounding;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("skipRounding")
    public void setSkipRounding(Boolean skipRounding) {
        this.skipRounding = skipRounding;
    }

    public Visualization withSkipRounding(Boolean skipRounding) {
        this.skipRounding = skipRounding;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("sortOrder")
    public Integer getSortOrder() {
        return sortOrder;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("sortOrder")
    public void setSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
    }

    public Visualization withSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
        return this;
    }

    @JsonProperty("startDate")
    public Optional<Date> getStartDate() {
        return Optional.ofNullable(startDate);
    }

    @JsonProperty("startDate")
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Visualization withStartDate(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("subscribed")
    public Boolean getSubscribed() {
        return subscribed;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("subscribed")
    public void setSubscribed(Boolean subscribed) {
        this.subscribed = subscribed;
    }

    public Visualization withSubscribed(Boolean subscribed) {
        this.subscribed = subscribed;
        return this;
    }

    @JsonProperty("subscribers")
    public Optional<List<String>> getSubscribers() {
        return Optional.ofNullable(subscribers);
    }

    @JsonProperty("subscribers")
    public void setSubscribers(List<String> subscribers) {
        this.subscribers = subscribers;
    }

    public Visualization withSubscribers(List<String> subscribers) {
        this.subscribers = subscribers;
        return this;
    }

    @JsonProperty("subtitle")
    public Optional<String> getSubtitle() {
        return Optional.ofNullable(subtitle);
    }

    @JsonProperty("subtitle")
    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    public Visualization withSubtitle(String subtitle) {
        this.subtitle = subtitle;
        return this;
    }

    @JsonProperty("targetLineLabel")
    public Optional<String> getTargetLineLabel() {
        return Optional.ofNullable(targetLineLabel);
    }

    @JsonProperty("targetLineLabel")
    public void setTargetLineLabel(String targetLineLabel) {
        this.targetLineLabel = targetLineLabel;
    }

    public Visualization withTargetLineLabel(String targetLineLabel) {
        this.targetLineLabel = targetLineLabel;
        return this;
    }

    @JsonProperty("targetLineValue")
    public Optional<Double> getTargetLineValue() {
        return Optional.ofNullable(targetLineValue);
    }

    @JsonProperty("targetLineValue")
    public void setTargetLineValue(Double targetLineValue) {
        this.targetLineValue = targetLineValue;
    }

    public Visualization withTargetLineValue(Double targetLineValue) {
        this.targetLineValue = targetLineValue;
        return this;
    }

    @JsonProperty("timeField")
    public Optional<String> getTimeField() {
        return Optional.ofNullable(timeField);
    }

    @JsonProperty("timeField")
    public void setTimeField(String timeField) {
        this.timeField = timeField;
    }

    public Visualization withTimeField(String timeField) {
        this.timeField = timeField;
        return this;
    }

    @JsonProperty("title")
    public Optional<String> getTitle() {
        return Optional.ofNullable(title);
    }

    @JsonProperty("title")
    public void setTitle(String title) {
        this.title = title;
    }

    public Visualization withTitle(String title) {
        this.title = title;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("topLimit")
    public Integer getTopLimit() {
        return topLimit;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("topLimit")
    public void setTopLimit(Integer topLimit) {
        this.topLimit = topLimit;
    }

    public Visualization withTopLimit(Integer topLimit) {
        this.topLimit = topLimit;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public Visualization withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("type")
    public Visualization.Type getType() {
        return type;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("type")
    public void setType(Visualization.Type type) {
        this.type = type;
    }

    public Visualization withType(Visualization.Type type) {
        this.type = type;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    public Optional<RefUser> getUser() {
        return Optional.ofNullable(user);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    public void setUser(RefUser user) {
        this.user = user;
    }

    public Visualization withUser(RefUser user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<UserAccess>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public Visualization withUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<UserGroupAccess>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public Visualization withUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("userOrgUnitType")
    public Visualization.UserOrgUnitType getUserOrgUnitType() {
        return userOrgUnitType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("userOrgUnitType")
    public void setUserOrgUnitType(Visualization.UserOrgUnitType userOrgUnitType) {
        this.userOrgUnitType = userOrgUnitType;
    }

    public Visualization withUserOrgUnitType(Visualization.UserOrgUnitType userOrgUnitType) {
        this.userOrgUnitType = userOrgUnitType;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("userOrganisationUnit")
    public Boolean getUserOrganisationUnit() {
        return userOrganisationUnit;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("userOrganisationUnit")
    public void setUserOrganisationUnit(Boolean userOrganisationUnit) {
        this.userOrganisationUnit = userOrganisationUnit;
    }

    public Visualization withUserOrganisationUnit(Boolean userOrganisationUnit) {
        this.userOrganisationUnit = userOrganisationUnit;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("userOrganisationUnitChildren")
    public Boolean getUserOrganisationUnitChildren() {
        return userOrganisationUnitChildren;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("userOrganisationUnitChildren")
    public void setUserOrganisationUnitChildren(Boolean userOrganisationUnitChildren) {
        this.userOrganisationUnitChildren = userOrganisationUnitChildren;
    }

    public Visualization withUserOrganisationUnitChildren(Boolean userOrganisationUnitChildren) {
        this.userOrganisationUnitChildren = userOrganisationUnitChildren;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("userOrganisationUnitGrandChildren")
    public Boolean getUserOrganisationUnitGrandChildren() {
        return userOrganisationUnitGrandChildren;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("userOrganisationUnitGrandChildren")
    public void setUserOrganisationUnitGrandChildren(Boolean userOrganisationUnitGrandChildren) {
        this.userOrganisationUnitGrandChildren = userOrganisationUnitGrandChildren;
    }

    public Visualization withUserOrganisationUnitGrandChildren(Boolean userOrganisationUnitGrandChildren) {
        this.userOrganisationUnitGrandChildren = userOrganisationUnitGrandChildren;
        return this;
    }

    @JsonProperty("visualizationPeriodName")
    public Optional<String> getVisualizationPeriodName() {
        return Optional.ofNullable(visualizationPeriodName);
    }

    @JsonProperty("visualizationPeriodName")
    public void setVisualizationPeriodName(String visualizationPeriodName) {
        this.visualizationPeriodName = visualizationPeriodName;
    }

    public Visualization withVisualizationPeriodName(String visualizationPeriodName) {
        this.visualizationPeriodName = visualizationPeriodName;
        return this;
    }

    @JsonProperty("yearlySeries")
    public Optional<List<String>> getYearlySeries() {
        return Optional.ofNullable(yearlySeries);
    }

    @JsonProperty("yearlySeries")
    public void setYearlySeries(List<String> yearlySeries) {
        this.yearlySeries = yearlySeries;
    }

    public Visualization withYearlySeries(List<String> yearlySeries) {
        this.yearlySeries = yearlySeries;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Visualization withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "access":
                if (value instanceof Access) {
                    setAccess(((Access) value));
                } else {
                    throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v40_0.Access\", but got "+ value.getClass().toString()));
                }
                return true;
            case "aggregationType":
                if (value instanceof Visualization.AggregationType) {
                    setAggregationType(((Visualization.AggregationType) value));
                } else {
                    throw new IllegalArgumentException(("property \"aggregationType\" is of type \"org.hisp.dhis.api.model.v40_0.Visualization.AggregationType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "attributeDimensions":
                if (value instanceof List) {
                    setAttributeDimensions(((List<TrackedEntityAttributeDimension> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeDimensions\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.TrackedEntityAttributeDimension>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "attributeValues":
                if (value instanceof List) {
                    setAttributeValues(((List<AttributeValue> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.AttributeValue>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "axes":
                if (value instanceof List) {
                    setAxes(((List<AxisV2> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"axes\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.AxisV2>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "baseLineLabel":
                if (value instanceof String) {
                    setBaseLineLabel(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"baseLineLabel\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "baseLineValue":
                if (value instanceof Double) {
                    setBaseLineValue(((Double) value));
                } else {
                    throw new IllegalArgumentException(("property \"baseLineValue\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                }
                return true;
            case "categoryDimensions":
                if (value instanceof List) {
                    setCategoryDimensions(((List<CategoryDimension> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"categoryDimensions\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.CategoryDimension>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "categoryOptionGroupSetDimensions":
                if (value instanceof List) {
                    setCategoryOptionGroupSetDimensions(((List<CategoryOptionGroupSetDimension> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"categoryOptionGroupSetDimensions\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.CategoryOptionGroupSetDimension>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "code":
                if (value instanceof String) {
                    setCode(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "colSubTotals":
                if (value instanceof Boolean) {
                    setColSubTotals(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"colSubTotals\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "colTotals":
                if (value instanceof Boolean) {
                    setColTotals(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"colTotals\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "colorSet":
                if (value instanceof String) {
                    setColorSet(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"colorSet\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "columnDimensions":
                if (value instanceof List) {
                    setColumnDimensions(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"columnDimensions\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "columns":
                if (value instanceof List) {
                    setColumns(((List<RefDimensionalObject> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"columns\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.RefDimensionalObject>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "completedOnly":
                if (value instanceof Boolean) {
                    setCompletedOnly(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"completedOnly\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "created":
                if (value instanceof Date) {
                    setCreated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "createdBy":
                if (value instanceof RefUser) {
                    setCreatedBy(((RefUser) value));
                } else {
                    throw new IllegalArgumentException(("property \"createdBy\" is of type \"org.hisp.dhis.api.model.v40_0.RefUser\", but got "+ value.getClass().toString()));
                }
                return true;
            case "cumulativeValues":
                if (value instanceof Boolean) {
                    setCumulativeValues(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"cumulativeValues\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataDimensionItems":
                if (value instanceof List) {
                    setDataDimensionItems(((List<DataDimensionItem> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataDimensionItems\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.DataDimensionItem>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataElementDimensions":
                if (value instanceof List) {
                    setDataElementDimensions(((List<TrackedEntityDataElementDimension> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataElementDimensions\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.TrackedEntityDataElementDimension>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataElementGroupSetDimensions":
                if (value instanceof List) {
                    setDataElementGroupSetDimensions(((List<DataElementGroupSetDimension> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataElementGroupSetDimensions\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.DataElementGroupSetDimension>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "description":
                if (value instanceof String) {
                    setDescription(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"description\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "digitGroupSeparator":
                if (value instanceof Visualization.DigitGroupSeparator) {
                    setDigitGroupSeparator(((Visualization.DigitGroupSeparator) value));
                } else {
                    throw new IllegalArgumentException(("property \"digitGroupSeparator\" is of type \"org.hisp.dhis.api.model.v40_0.Visualization.DigitGroupSeparator\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayBaseLineLabel":
                if (value instanceof String) {
                    setDisplayBaseLineLabel(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayBaseLineLabel\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayDensity":
                if (value instanceof Visualization.DisplayDensity) {
                    setDisplayDensity(((Visualization.DisplayDensity) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayDensity\" is of type \"org.hisp.dhis.api.model.v40_0.Visualization.DisplayDensity\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayDescription":
                if (value instanceof String) {
                    setDisplayDescription(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayDescription\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayDomainAxisLabel":
                if (value instanceof String) {
                    setDisplayDomainAxisLabel(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayDomainAxisLabel\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayFormName":
                if (value instanceof String) {
                    setDisplayFormName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayFormName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayName":
                if (value instanceof String) {
                    setDisplayName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayRangeAxisLabel":
                if (value instanceof String) {
                    setDisplayRangeAxisLabel(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayRangeAxisLabel\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayShortName":
                if (value instanceof String) {
                    setDisplayShortName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayShortName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displaySubtitle":
                if (value instanceof String) {
                    setDisplaySubtitle(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displaySubtitle\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayTargetLineLabel":
                if (value instanceof String) {
                    setDisplayTargetLineLabel(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayTargetLineLabel\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayTitle":
                if (value instanceof String) {
                    setDisplayTitle(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayTitle\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "domainAxisLabel":
                if (value instanceof String) {
                    setDomainAxisLabel(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"domainAxisLabel\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "endDate":
                if (value instanceof Date) {
                    setEndDate(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"endDate\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "externalAccess":
                if (value instanceof Boolean) {
                    setExternalAccess(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "favorite":
                if (value instanceof Boolean) {
                    setFavorite(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"favorite\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "favorites":
                if (value instanceof List) {
                    setFavorites(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "filterDimensions":
                if (value instanceof List) {
                    setFilterDimensions(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"filterDimensions\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "filters":
                if (value instanceof List) {
                    setFilters(((List<RefDimensionalObject> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"filters\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.RefDimensionalObject>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "fixColumnHeaders":
                if (value instanceof Boolean) {
                    setFixColumnHeaders(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"fixColumnHeaders\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "fixRowHeaders":
                if (value instanceof Boolean) {
                    setFixRowHeaders(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"fixRowHeaders\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "fontSize":
                if (value instanceof Visualization.FontSize) {
                    setFontSize(((Visualization.FontSize) value));
                } else {
                    throw new IllegalArgumentException(("property \"fontSize\" is of type \"org.hisp.dhis.api.model.v40_0.Visualization.FontSize\", but got "+ value.getClass().toString()));
                }
                return true;
            case "fontStyle":
                if (value instanceof VisualizationFontStyle) {
                    setFontStyle(((VisualizationFontStyle) value));
                } else {
                    throw new IllegalArgumentException(("property \"fontStyle\" is of type \"org.hisp.dhis.api.model.v40_0.VisualizationFontStyle\", but got "+ value.getClass().toString()));
                }
                return true;
            case "formName":
                if (value instanceof String) {
                    setFormName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"formName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "hideEmptyColumns":
                if (value instanceof Boolean) {
                    setHideEmptyColumns(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"hideEmptyColumns\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "hideEmptyRowItems":
                if (value instanceof Visualization.HideEmptyRowItems) {
                    setHideEmptyRowItems(((Visualization.HideEmptyRowItems) value));
                } else {
                    throw new IllegalArgumentException(("property \"hideEmptyRowItems\" is of type \"org.hisp.dhis.api.model.v40_0.Visualization.HideEmptyRowItems\", but got "+ value.getClass().toString()));
                }
                return true;
            case "hideEmptyRows":
                if (value instanceof Boolean) {
                    setHideEmptyRows(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"hideEmptyRows\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "hideLegend":
                if (value instanceof Boolean) {
                    setHideLegend(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"hideLegend\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "hideSubtitle":
                if (value instanceof Boolean) {
                    setHideSubtitle(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"hideSubtitle\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "hideTitle":
                if (value instanceof Boolean) {
                    setHideTitle(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"hideTitle\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "href":
                if (value instanceof String) {
                    setHref(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "icons":
                if (value instanceof List) {
                    setIcons(((List<Icon> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"icons\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.Icon>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "id":
                if (value instanceof String) {
                    setId(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "interpretations":
                if (value instanceof List) {
                    setInterpretations(((List<RefInterpretation> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"interpretations\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.RefInterpretation>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "itemOrganisationUnitGroups":
                if (value instanceof List) {
                    setItemOrganisationUnitGroups(((List<RefOrganisationUnitGroup> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"itemOrganisationUnitGroups\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.RefOrganisationUnitGroup>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdated":
                if (value instanceof Date) {
                    setLastUpdated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdatedBy":
                if (value instanceof RefUser) {
                    setLastUpdatedBy(((RefUser) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"org.hisp.dhis.api.model.v40_0.RefUser\", but got "+ value.getClass().toString()));
                }
                return true;
            case "legend":
                if (value instanceof LegendDefinitions) {
                    setLegend(((LegendDefinitions) value));
                } else {
                    throw new IllegalArgumentException(("property \"legend\" is of type \"org.hisp.dhis.api.model.v40_0.LegendDefinitions\", but got "+ value.getClass().toString()));
                }
                return true;
            case "measureCriteria":
                if (value instanceof String) {
                    setMeasureCriteria(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"measureCriteria\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "name":
                if (value instanceof String) {
                    setName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "noSpaceBetweenColumns":
                if (value instanceof Boolean) {
                    setNoSpaceBetweenColumns(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"noSpaceBetweenColumns\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "numberType":
                if (value instanceof Visualization.NumberType) {
                    setNumberType(((Visualization.NumberType) value));
                } else {
                    throw new IllegalArgumentException(("property \"numberType\" is of type \"org.hisp.dhis.api.model.v40_0.Visualization.NumberType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "optionalAxes":
                if (value instanceof List) {
                    setOptionalAxes(((List<Axis> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"optionalAxes\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.Axis>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "orgUnitField":
                if (value instanceof String) {
                    setOrgUnitField(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"orgUnitField\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "organisationUnitGroupSetDimensions":
                if (value instanceof List) {
                    setOrganisationUnitGroupSetDimensions(((List<OrganisationUnitGroupSetDimension> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"organisationUnitGroupSetDimensions\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.OrganisationUnitGroupSetDimension>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "organisationUnitLevels":
                if (value instanceof List) {
                    setOrganisationUnitLevels(((List<Integer> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"organisationUnitLevels\" is of type \"java.util.List<java.lang.Integer>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "organisationUnits":
                if (value instanceof List) {
                    setOrganisationUnits(((List<RefOrganisationUnit> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"organisationUnits\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.RefOrganisationUnit>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "outlierAnalysis":
                if (value instanceof OutlierAnalysis) {
                    setOutlierAnalysis(((OutlierAnalysis) value));
                } else {
                    throw new IllegalArgumentException(("property \"outlierAnalysis\" is of type \"org.hisp.dhis.api.model.v40_0.OutlierAnalysis\", but got "+ value.getClass().toString()));
                }
                return true;
            case "parentGraphMap":
                if (value instanceof ParentGraphMap__2) {
                    setParentGraphMap(((ParentGraphMap__2) value));
                } else {
                    throw new IllegalArgumentException(("property \"parentGraphMap\" is of type \"org.hisp.dhis.api.model.v40_0.ParentGraphMap__2\", but got "+ value.getClass().toString()));
                }
                return true;
            case "percentStackedValues":
                if (value instanceof Boolean) {
                    setPercentStackedValues(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"percentStackedValues\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "periods":
                if (value instanceof List) {
                    setPeriods(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"periods\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "programIndicatorDimensions":
                if (value instanceof List) {
                    setProgramIndicatorDimensions(((List<TrackedEntityProgramIndicatorDimension> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"programIndicatorDimensions\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.TrackedEntityProgramIndicatorDimension>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "publicAccess":
                if (value instanceof String) {
                    setPublicAccess(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"publicAccess\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "rangeAxisDecimals":
                if (value instanceof Integer) {
                    setRangeAxisDecimals(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"rangeAxisDecimals\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "rangeAxisLabel":
                if (value instanceof String) {
                    setRangeAxisLabel(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"rangeAxisLabel\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "rangeAxisMaxValue":
                if (value instanceof Double) {
                    setRangeAxisMaxValue(((Double) value));
                } else {
                    throw new IllegalArgumentException(("property \"rangeAxisMaxValue\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                }
                return true;
            case "rangeAxisMinValue":
                if (value instanceof Double) {
                    setRangeAxisMinValue(((Double) value));
                } else {
                    throw new IllegalArgumentException(("property \"rangeAxisMinValue\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                }
                return true;
            case "rangeAxisSteps":
                if (value instanceof Integer) {
                    setRangeAxisSteps(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"rangeAxisSteps\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "regression":
                if (value instanceof Boolean) {
                    setRegression(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"regression\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "regressionType":
                if (value instanceof Visualization.RegressionType) {
                    setRegressionType(((Visualization.RegressionType) value));
                } else {
                    throw new IllegalArgumentException(("property \"regressionType\" is of type \"org.hisp.dhis.api.model.v40_0.Visualization.RegressionType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "relativePeriods":
                if (value instanceof RelativePeriods) {
                    setRelativePeriods(((RelativePeriods) value));
                } else {
                    throw new IllegalArgumentException(("property \"relativePeriods\" is of type \"org.hisp.dhis.api.model.v40_0.RelativePeriods\", but got "+ value.getClass().toString()));
                }
                return true;
            case "reportingParams":
                if (value instanceof ReportingParams) {
                    setReportingParams(((ReportingParams) value));
                } else {
                    throw new IllegalArgumentException(("property \"reportingParams\" is of type \"org.hisp.dhis.api.model.v40_0.ReportingParams\", but got "+ value.getClass().toString()));
                }
                return true;
            case "rowDimensions":
                if (value instanceof List) {
                    setRowDimensions(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"rowDimensions\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "rowSubTotals":
                if (value instanceof Boolean) {
                    setRowSubTotals(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"rowSubTotals\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "rowTotals":
                if (value instanceof Boolean) {
                    setRowTotals(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"rowTotals\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "rows":
                if (value instanceof List) {
                    setRows(((List<RefDimensionalObject> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"rows\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.RefDimensionalObject>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "series":
                if (value instanceof List) {
                    setSeries(((List<Series> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"series\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.Series>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "seriesKey":
                if (value instanceof SeriesKey) {
                    setSeriesKey(((SeriesKey) value));
                } else {
                    throw new IllegalArgumentException(("property \"seriesKey\" is of type \"org.hisp.dhis.api.model.v40_0.SeriesKey\", but got "+ value.getClass().toString()));
                }
                return true;
            case "sharing":
                if (value instanceof Sharing) {
                    setSharing(((Sharing) value));
                } else {
                    throw new IllegalArgumentException(("property \"sharing\" is of type \"org.hisp.dhis.api.model.v40_0.Sharing\", but got "+ value.getClass().toString()));
                }
                return true;
            case "shortName":
                if (value instanceof String) {
                    setShortName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"shortName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "showData":
                if (value instanceof Boolean) {
                    setShowData(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"showData\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "showDimensionLabels":
                if (value instanceof Boolean) {
                    setShowDimensionLabels(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"showDimensionLabels\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "showHierarchy":
                if (value instanceof Boolean) {
                    setShowHierarchy(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"showHierarchy\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "skipRounding":
                if (value instanceof Boolean) {
                    setSkipRounding(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"skipRounding\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "sortOrder":
                if (value instanceof Integer) {
                    setSortOrder(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"sortOrder\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "startDate":
                if (value instanceof Date) {
                    setStartDate(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"startDate\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "subscribed":
                if (value instanceof Boolean) {
                    setSubscribed(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"subscribed\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "subscribers":
                if (value instanceof List) {
                    setSubscribers(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"subscribers\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "subtitle":
                if (value instanceof String) {
                    setSubtitle(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"subtitle\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "targetLineLabel":
                if (value instanceof String) {
                    setTargetLineLabel(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"targetLineLabel\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "targetLineValue":
                if (value instanceof Double) {
                    setTargetLineValue(((Double) value));
                } else {
                    throw new IllegalArgumentException(("property \"targetLineValue\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                }
                return true;
            case "timeField":
                if (value instanceof String) {
                    setTimeField(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"timeField\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "title":
                if (value instanceof String) {
                    setTitle(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"title\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "topLimit":
                if (value instanceof Integer) {
                    setTopLimit(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"topLimit\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "translations":
                if (value instanceof List) {
                    setTranslations(((List<Translation> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.Translation>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "type":
                if (value instanceof Visualization.Type) {
                    setType(((Visualization.Type) value));
                } else {
                    throw new IllegalArgumentException(("property \"type\" is of type \"org.hisp.dhis.api.model.v40_0.Visualization.Type\", but got "+ value.getClass().toString()));
                }
                return true;
            case "user":
                if (value instanceof RefUser) {
                    setUser(((RefUser) value));
                } else {
                    throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v40_0.RefUser\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userAccesses":
                if (value instanceof List) {
                    setUserAccesses(((List<UserAccess> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.UserAccess>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userGroupAccesses":
                if (value instanceof List) {
                    setUserGroupAccesses(((List<UserGroupAccess> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.UserGroupAccess>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userOrgUnitType":
                if (value instanceof Visualization.UserOrgUnitType) {
                    setUserOrgUnitType(((Visualization.UserOrgUnitType) value));
                } else {
                    throw new IllegalArgumentException(("property \"userOrgUnitType\" is of type \"org.hisp.dhis.api.model.v40_0.Visualization.UserOrgUnitType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userOrganisationUnit":
                if (value instanceof Boolean) {
                    setUserOrganisationUnit(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"userOrganisationUnit\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userOrganisationUnitChildren":
                if (value instanceof Boolean) {
                    setUserOrganisationUnitChildren(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"userOrganisationUnitChildren\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userOrganisationUnitGrandChildren":
                if (value instanceof Boolean) {
                    setUserOrganisationUnitGrandChildren(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"userOrganisationUnitGrandChildren\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "visualizationPeriodName":
                if (value instanceof String) {
                    setVisualizationPeriodName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"visualizationPeriodName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "yearlySeries":
                if (value instanceof List) {
                    setYearlySeries(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"yearlySeries\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "access":
                return getAccess();
            case "aggregationType":
                return getAggregationType();
            case "attributeDimensions":
                return getAttributeDimensions();
            case "attributeValues":
                return getAttributeValues();
            case "axes":
                return getAxes();
            case "baseLineLabel":
                return getBaseLineLabel();
            case "baseLineValue":
                return getBaseLineValue();
            case "categoryDimensions":
                return getCategoryDimensions();
            case "categoryOptionGroupSetDimensions":
                return getCategoryOptionGroupSetDimensions();
            case "code":
                return getCode();
            case "colSubTotals":
                return getColSubTotals();
            case "colTotals":
                return getColTotals();
            case "colorSet":
                return getColorSet();
            case "columnDimensions":
                return getColumnDimensions();
            case "columns":
                return getColumns();
            case "completedOnly":
                return getCompletedOnly();
            case "created":
                return getCreated();
            case "createdBy":
                return getCreatedBy();
            case "cumulativeValues":
                return getCumulativeValues();
            case "dataDimensionItems":
                return getDataDimensionItems();
            case "dataElementDimensions":
                return getDataElementDimensions();
            case "dataElementGroupSetDimensions":
                return getDataElementGroupSetDimensions();
            case "description":
                return getDescription();
            case "digitGroupSeparator":
                return getDigitGroupSeparator();
            case "displayBaseLineLabel":
                return getDisplayBaseLineLabel();
            case "displayDensity":
                return getDisplayDensity();
            case "displayDescription":
                return getDisplayDescription();
            case "displayDomainAxisLabel":
                return getDisplayDomainAxisLabel();
            case "displayFormName":
                return getDisplayFormName();
            case "displayName":
                return getDisplayName();
            case "displayRangeAxisLabel":
                return getDisplayRangeAxisLabel();
            case "displayShortName":
                return getDisplayShortName();
            case "displaySubtitle":
                return getDisplaySubtitle();
            case "displayTargetLineLabel":
                return getDisplayTargetLineLabel();
            case "displayTitle":
                return getDisplayTitle();
            case "domainAxisLabel":
                return getDomainAxisLabel();
            case "endDate":
                return getEndDate();
            case "externalAccess":
                return getExternalAccess();
            case "favorite":
                return getFavorite();
            case "favorites":
                return getFavorites();
            case "filterDimensions":
                return getFilterDimensions();
            case "filters":
                return getFilters();
            case "fixColumnHeaders":
                return getFixColumnHeaders();
            case "fixRowHeaders":
                return getFixRowHeaders();
            case "fontSize":
                return getFontSize();
            case "fontStyle":
                return getFontStyle();
            case "formName":
                return getFormName();
            case "hideEmptyColumns":
                return getHideEmptyColumns();
            case "hideEmptyRowItems":
                return getHideEmptyRowItems();
            case "hideEmptyRows":
                return getHideEmptyRows();
            case "hideLegend":
                return getHideLegend();
            case "hideSubtitle":
                return getHideSubtitle();
            case "hideTitle":
                return getHideTitle();
            case "href":
                return getHref();
            case "icons":
                return getIcons();
            case "id":
                return getId();
            case "interpretations":
                return getInterpretations();
            case "itemOrganisationUnitGroups":
                return getItemOrganisationUnitGroups();
            case "lastUpdated":
                return getLastUpdated();
            case "lastUpdatedBy":
                return getLastUpdatedBy();
            case "legend":
                return getLegend();
            case "measureCriteria":
                return getMeasureCriteria();
            case "name":
                return getName();
            case "noSpaceBetweenColumns":
                return getNoSpaceBetweenColumns();
            case "numberType":
                return getNumberType();
            case "optionalAxes":
                return getOptionalAxes();
            case "orgUnitField":
                return getOrgUnitField();
            case "organisationUnitGroupSetDimensions":
                return getOrganisationUnitGroupSetDimensions();
            case "organisationUnitLevels":
                return getOrganisationUnitLevels();
            case "organisationUnits":
                return getOrganisationUnits();
            case "outlierAnalysis":
                return getOutlierAnalysis();
            case "parentGraphMap":
                return getParentGraphMap();
            case "percentStackedValues":
                return getPercentStackedValues();
            case "periods":
                return getPeriods();
            case "programIndicatorDimensions":
                return getProgramIndicatorDimensions();
            case "publicAccess":
                return getPublicAccess();
            case "rangeAxisDecimals":
                return getRangeAxisDecimals();
            case "rangeAxisLabel":
                return getRangeAxisLabel();
            case "rangeAxisMaxValue":
                return getRangeAxisMaxValue();
            case "rangeAxisMinValue":
                return getRangeAxisMinValue();
            case "rangeAxisSteps":
                return getRangeAxisSteps();
            case "regression":
                return getRegression();
            case "regressionType":
                return getRegressionType();
            case "relativePeriods":
                return getRelativePeriods();
            case "reportingParams":
                return getReportingParams();
            case "rowDimensions":
                return getRowDimensions();
            case "rowSubTotals":
                return getRowSubTotals();
            case "rowTotals":
                return getRowTotals();
            case "rows":
                return getRows();
            case "series":
                return getSeries();
            case "seriesKey":
                return getSeriesKey();
            case "sharing":
                return getSharing();
            case "shortName":
                return getShortName();
            case "showData":
                return getShowData();
            case "showDimensionLabels":
                return getShowDimensionLabels();
            case "showHierarchy":
                return getShowHierarchy();
            case "skipRounding":
                return getSkipRounding();
            case "sortOrder":
                return getSortOrder();
            case "startDate":
                return getStartDate();
            case "subscribed":
                return getSubscribed();
            case "subscribers":
                return getSubscribers();
            case "subtitle":
                return getSubtitle();
            case "targetLineLabel":
                return getTargetLineLabel();
            case "targetLineValue":
                return getTargetLineValue();
            case "timeField":
                return getTimeField();
            case "title":
                return getTitle();
            case "topLimit":
                return getTopLimit();
            case "translations":
                return getTranslations();
            case "type":
                return getType();
            case "user":
                return getUser();
            case "userAccesses":
                return getUserAccesses();
            case "userGroupAccesses":
                return getUserGroupAccesses();
            case "userOrgUnitType":
                return getUserOrgUnitType();
            case "userOrganisationUnit":
                return getUserOrganisationUnit();
            case "userOrganisationUnitChildren":
                return getUserOrganisationUnitChildren();
            case "userOrganisationUnitGrandChildren":
                return getUserOrganisationUnitGrandChildren();
            case "visualizationPeriodName":
                return getVisualizationPeriodName();
            case "yearlySeries":
                return getYearlySeries();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, Visualization.NOT_FOUND_VALUE);
        if (Visualization.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public Visualization with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Visualization.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("aggregationType");
        sb.append('=');
        sb.append(((this.aggregationType == null)?"<null>":this.aggregationType));
        sb.append(',');
        sb.append("attributeDimensions");
        sb.append('=');
        sb.append(((this.attributeDimensions == null)?"<null>":this.attributeDimensions));
        sb.append(',');
        sb.append("attributeValues");
        sb.append('=');
        sb.append(((this.attributeValues == null)?"<null>":this.attributeValues));
        sb.append(',');
        sb.append("axes");
        sb.append('=');
        sb.append(((this.axes == null)?"<null>":this.axes));
        sb.append(',');
        sb.append("baseLineLabel");
        sb.append('=');
        sb.append(((this.baseLineLabel == null)?"<null>":this.baseLineLabel));
        sb.append(',');
        sb.append("baseLineValue");
        sb.append('=');
        sb.append(((this.baseLineValue == null)?"<null>":this.baseLineValue));
        sb.append(',');
        sb.append("categoryDimensions");
        sb.append('=');
        sb.append(((this.categoryDimensions == null)?"<null>":this.categoryDimensions));
        sb.append(',');
        sb.append("categoryOptionGroupSetDimensions");
        sb.append('=');
        sb.append(((this.categoryOptionGroupSetDimensions == null)?"<null>":this.categoryOptionGroupSetDimensions));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("colSubTotals");
        sb.append('=');
        sb.append(((this.colSubTotals == null)?"<null>":this.colSubTotals));
        sb.append(',');
        sb.append("colTotals");
        sb.append('=');
        sb.append(((this.colTotals == null)?"<null>":this.colTotals));
        sb.append(',');
        sb.append("colorSet");
        sb.append('=');
        sb.append(((this.colorSet == null)?"<null>":this.colorSet));
        sb.append(',');
        sb.append("columnDimensions");
        sb.append('=');
        sb.append(((this.columnDimensions == null)?"<null>":this.columnDimensions));
        sb.append(',');
        sb.append("columns");
        sb.append('=');
        sb.append(((this.columns == null)?"<null>":this.columns));
        sb.append(',');
        sb.append("completedOnly");
        sb.append('=');
        sb.append(((this.completedOnly == null)?"<null>":this.completedOnly));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("createdBy");
        sb.append('=');
        sb.append(((this.createdBy == null)?"<null>":this.createdBy));
        sb.append(',');
        sb.append("cumulativeValues");
        sb.append('=');
        sb.append(((this.cumulativeValues == null)?"<null>":this.cumulativeValues));
        sb.append(',');
        sb.append("dataDimensionItems");
        sb.append('=');
        sb.append(((this.dataDimensionItems == null)?"<null>":this.dataDimensionItems));
        sb.append(',');
        sb.append("dataElementDimensions");
        sb.append('=');
        sb.append(((this.dataElementDimensions == null)?"<null>":this.dataElementDimensions));
        sb.append(',');
        sb.append("dataElementGroupSetDimensions");
        sb.append('=');
        sb.append(((this.dataElementGroupSetDimensions == null)?"<null>":this.dataElementGroupSetDimensions));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("digitGroupSeparator");
        sb.append('=');
        sb.append(((this.digitGroupSeparator == null)?"<null>":this.digitGroupSeparator));
        sb.append(',');
        sb.append("displayBaseLineLabel");
        sb.append('=');
        sb.append(((this.displayBaseLineLabel == null)?"<null>":this.displayBaseLineLabel));
        sb.append(',');
        sb.append("displayDensity");
        sb.append('=');
        sb.append(((this.displayDensity == null)?"<null>":this.displayDensity));
        sb.append(',');
        sb.append("displayDescription");
        sb.append('=');
        sb.append(((this.displayDescription == null)?"<null>":this.displayDescription));
        sb.append(',');
        sb.append("displayDomainAxisLabel");
        sb.append('=');
        sb.append(((this.displayDomainAxisLabel == null)?"<null>":this.displayDomainAxisLabel));
        sb.append(',');
        sb.append("displayFormName");
        sb.append('=');
        sb.append(((this.displayFormName == null)?"<null>":this.displayFormName));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("displayRangeAxisLabel");
        sb.append('=');
        sb.append(((this.displayRangeAxisLabel == null)?"<null>":this.displayRangeAxisLabel));
        sb.append(',');
        sb.append("displayShortName");
        sb.append('=');
        sb.append(((this.displayShortName == null)?"<null>":this.displayShortName));
        sb.append(',');
        sb.append("displaySubtitle");
        sb.append('=');
        sb.append(((this.displaySubtitle == null)?"<null>":this.displaySubtitle));
        sb.append(',');
        sb.append("displayTargetLineLabel");
        sb.append('=');
        sb.append(((this.displayTargetLineLabel == null)?"<null>":this.displayTargetLineLabel));
        sb.append(',');
        sb.append("displayTitle");
        sb.append('=');
        sb.append(((this.displayTitle == null)?"<null>":this.displayTitle));
        sb.append(',');
        sb.append("domainAxisLabel");
        sb.append('=');
        sb.append(((this.domainAxisLabel == null)?"<null>":this.domainAxisLabel));
        sb.append(',');
        sb.append("endDate");
        sb.append('=');
        sb.append(((this.endDate == null)?"<null>":this.endDate));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("favorite");
        sb.append('=');
        sb.append(((this.favorite == null)?"<null>":this.favorite));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("filterDimensions");
        sb.append('=');
        sb.append(((this.filterDimensions == null)?"<null>":this.filterDimensions));
        sb.append(',');
        sb.append("filters");
        sb.append('=');
        sb.append(((this.filters == null)?"<null>":this.filters));
        sb.append(',');
        sb.append("fixColumnHeaders");
        sb.append('=');
        sb.append(((this.fixColumnHeaders == null)?"<null>":this.fixColumnHeaders));
        sb.append(',');
        sb.append("fixRowHeaders");
        sb.append('=');
        sb.append(((this.fixRowHeaders == null)?"<null>":this.fixRowHeaders));
        sb.append(',');
        sb.append("fontSize");
        sb.append('=');
        sb.append(((this.fontSize == null)?"<null>":this.fontSize));
        sb.append(',');
        sb.append("fontStyle");
        sb.append('=');
        sb.append(((this.fontStyle == null)?"<null>":this.fontStyle));
        sb.append(',');
        sb.append("formName");
        sb.append('=');
        sb.append(((this.formName == null)?"<null>":this.formName));
        sb.append(',');
        sb.append("hideEmptyColumns");
        sb.append('=');
        sb.append(((this.hideEmptyColumns == null)?"<null>":this.hideEmptyColumns));
        sb.append(',');
        sb.append("hideEmptyRowItems");
        sb.append('=');
        sb.append(((this.hideEmptyRowItems == null)?"<null>":this.hideEmptyRowItems));
        sb.append(',');
        sb.append("hideEmptyRows");
        sb.append('=');
        sb.append(((this.hideEmptyRows == null)?"<null>":this.hideEmptyRows));
        sb.append(',');
        sb.append("hideLegend");
        sb.append('=');
        sb.append(((this.hideLegend == null)?"<null>":this.hideLegend));
        sb.append(',');
        sb.append("hideSubtitle");
        sb.append('=');
        sb.append(((this.hideSubtitle == null)?"<null>":this.hideSubtitle));
        sb.append(',');
        sb.append("hideTitle");
        sb.append('=');
        sb.append(((this.hideTitle == null)?"<null>":this.hideTitle));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("icons");
        sb.append('=');
        sb.append(((this.icons == null)?"<null>":this.icons));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("interpretations");
        sb.append('=');
        sb.append(((this.interpretations == null)?"<null>":this.interpretations));
        sb.append(',');
        sb.append("itemOrganisationUnitGroups");
        sb.append('=');
        sb.append(((this.itemOrganisationUnitGroups == null)?"<null>":this.itemOrganisationUnitGroups));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("legend");
        sb.append('=');
        sb.append(((this.legend == null)?"<null>":this.legend));
        sb.append(',');
        sb.append("measureCriteria");
        sb.append('=');
        sb.append(((this.measureCriteria == null)?"<null>":this.measureCriteria));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("noSpaceBetweenColumns");
        sb.append('=');
        sb.append(((this.noSpaceBetweenColumns == null)?"<null>":this.noSpaceBetweenColumns));
        sb.append(',');
        sb.append("numberType");
        sb.append('=');
        sb.append(((this.numberType == null)?"<null>":this.numberType));
        sb.append(',');
        sb.append("optionalAxes");
        sb.append('=');
        sb.append(((this.optionalAxes == null)?"<null>":this.optionalAxes));
        sb.append(',');
        sb.append("orgUnitField");
        sb.append('=');
        sb.append(((this.orgUnitField == null)?"<null>":this.orgUnitField));
        sb.append(',');
        sb.append("organisationUnitGroupSetDimensions");
        sb.append('=');
        sb.append(((this.organisationUnitGroupSetDimensions == null)?"<null>":this.organisationUnitGroupSetDimensions));
        sb.append(',');
        sb.append("organisationUnitLevels");
        sb.append('=');
        sb.append(((this.organisationUnitLevels == null)?"<null>":this.organisationUnitLevels));
        sb.append(',');
        sb.append("organisationUnits");
        sb.append('=');
        sb.append(((this.organisationUnits == null)?"<null>":this.organisationUnits));
        sb.append(',');
        sb.append("outlierAnalysis");
        sb.append('=');
        sb.append(((this.outlierAnalysis == null)?"<null>":this.outlierAnalysis));
        sb.append(',');
        sb.append("parentGraphMap");
        sb.append('=');
        sb.append(((this.parentGraphMap == null)?"<null>":this.parentGraphMap));
        sb.append(',');
        sb.append("percentStackedValues");
        sb.append('=');
        sb.append(((this.percentStackedValues == null)?"<null>":this.percentStackedValues));
        sb.append(',');
        sb.append("periods");
        sb.append('=');
        sb.append(((this.periods == null)?"<null>":this.periods));
        sb.append(',');
        sb.append("programIndicatorDimensions");
        sb.append('=');
        sb.append(((this.programIndicatorDimensions == null)?"<null>":this.programIndicatorDimensions));
        sb.append(',');
        sb.append("publicAccess");
        sb.append('=');
        sb.append(((this.publicAccess == null)?"<null>":this.publicAccess));
        sb.append(',');
        sb.append("rangeAxisDecimals");
        sb.append('=');
        sb.append(((this.rangeAxisDecimals == null)?"<null>":this.rangeAxisDecimals));
        sb.append(',');
        sb.append("rangeAxisLabel");
        sb.append('=');
        sb.append(((this.rangeAxisLabel == null)?"<null>":this.rangeAxisLabel));
        sb.append(',');
        sb.append("rangeAxisMaxValue");
        sb.append('=');
        sb.append(((this.rangeAxisMaxValue == null)?"<null>":this.rangeAxisMaxValue));
        sb.append(',');
        sb.append("rangeAxisMinValue");
        sb.append('=');
        sb.append(((this.rangeAxisMinValue == null)?"<null>":this.rangeAxisMinValue));
        sb.append(',');
        sb.append("rangeAxisSteps");
        sb.append('=');
        sb.append(((this.rangeAxisSteps == null)?"<null>":this.rangeAxisSteps));
        sb.append(',');
        sb.append("regression");
        sb.append('=');
        sb.append(((this.regression == null)?"<null>":this.regression));
        sb.append(',');
        sb.append("regressionType");
        sb.append('=');
        sb.append(((this.regressionType == null)?"<null>":this.regressionType));
        sb.append(',');
        sb.append("relativePeriods");
        sb.append('=');
        sb.append(((this.relativePeriods == null)?"<null>":this.relativePeriods));
        sb.append(',');
        sb.append("reportingParams");
        sb.append('=');
        sb.append(((this.reportingParams == null)?"<null>":this.reportingParams));
        sb.append(',');
        sb.append("rowDimensions");
        sb.append('=');
        sb.append(((this.rowDimensions == null)?"<null>":this.rowDimensions));
        sb.append(',');
        sb.append("rowSubTotals");
        sb.append('=');
        sb.append(((this.rowSubTotals == null)?"<null>":this.rowSubTotals));
        sb.append(',');
        sb.append("rowTotals");
        sb.append('=');
        sb.append(((this.rowTotals == null)?"<null>":this.rowTotals));
        sb.append(',');
        sb.append("rows");
        sb.append('=');
        sb.append(((this.rows == null)?"<null>":this.rows));
        sb.append(',');
        sb.append("series");
        sb.append('=');
        sb.append(((this.series == null)?"<null>":this.series));
        sb.append(',');
        sb.append("seriesKey");
        sb.append('=');
        sb.append(((this.seriesKey == null)?"<null>":this.seriesKey));
        sb.append(',');
        sb.append("sharing");
        sb.append('=');
        sb.append(((this.sharing == null)?"<null>":this.sharing));
        sb.append(',');
        sb.append("shortName");
        sb.append('=');
        sb.append(((this.shortName == null)?"<null>":this.shortName));
        sb.append(',');
        sb.append("showData");
        sb.append('=');
        sb.append(((this.showData == null)?"<null>":this.showData));
        sb.append(',');
        sb.append("showDimensionLabels");
        sb.append('=');
        sb.append(((this.showDimensionLabels == null)?"<null>":this.showDimensionLabels));
        sb.append(',');
        sb.append("showHierarchy");
        sb.append('=');
        sb.append(((this.showHierarchy == null)?"<null>":this.showHierarchy));
        sb.append(',');
        sb.append("skipRounding");
        sb.append('=');
        sb.append(((this.skipRounding == null)?"<null>":this.skipRounding));
        sb.append(',');
        sb.append("sortOrder");
        sb.append('=');
        sb.append(((this.sortOrder == null)?"<null>":this.sortOrder));
        sb.append(',');
        sb.append("startDate");
        sb.append('=');
        sb.append(((this.startDate == null)?"<null>":this.startDate));
        sb.append(',');
        sb.append("subscribed");
        sb.append('=');
        sb.append(((this.subscribed == null)?"<null>":this.subscribed));
        sb.append(',');
        sb.append("subscribers");
        sb.append('=');
        sb.append(((this.subscribers == null)?"<null>":this.subscribers));
        sb.append(',');
        sb.append("subtitle");
        sb.append('=');
        sb.append(((this.subtitle == null)?"<null>":this.subtitle));
        sb.append(',');
        sb.append("targetLineLabel");
        sb.append('=');
        sb.append(((this.targetLineLabel == null)?"<null>":this.targetLineLabel));
        sb.append(',');
        sb.append("targetLineValue");
        sb.append('=');
        sb.append(((this.targetLineValue == null)?"<null>":this.targetLineValue));
        sb.append(',');
        sb.append("timeField");
        sb.append('=');
        sb.append(((this.timeField == null)?"<null>":this.timeField));
        sb.append(',');
        sb.append("title");
        sb.append('=');
        sb.append(((this.title == null)?"<null>":this.title));
        sb.append(',');
        sb.append("topLimit");
        sb.append('=');
        sb.append(((this.topLimit == null)?"<null>":this.topLimit));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(((this.type == null)?"<null>":this.type));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("userOrgUnitType");
        sb.append('=');
        sb.append(((this.userOrgUnitType == null)?"<null>":this.userOrgUnitType));
        sb.append(',');
        sb.append("userOrganisationUnit");
        sb.append('=');
        sb.append(((this.userOrganisationUnit == null)?"<null>":this.userOrganisationUnit));
        sb.append(',');
        sb.append("userOrganisationUnitChildren");
        sb.append('=');
        sb.append(((this.userOrganisationUnitChildren == null)?"<null>":this.userOrganisationUnitChildren));
        sb.append(',');
        sb.append("userOrganisationUnitGrandChildren");
        sb.append('=');
        sb.append(((this.userOrganisationUnitGrandChildren == null)?"<null>":this.userOrganisationUnitGrandChildren));
        sb.append(',');
        sb.append("visualizationPeriodName");
        sb.append('=');
        sb.append(((this.visualizationPeriodName == null)?"<null>":this.visualizationPeriodName));
        sb.append(',');
        sb.append("yearlySeries");
        sb.append('=');
        sb.append(((this.yearlySeries == null)?"<null>":this.yearlySeries));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.dataElementGroupSetDimensions == null)? 0 :this.dataElementGroupSetDimensions.hashCode()));
        result = ((result* 31)+((this.orgUnitField == null)? 0 :this.orgUnitField.hashCode()));
        result = ((result* 31)+((this.endDate == null)? 0 :this.endDate.hashCode()));
        result = ((result* 31)+((this.baseLineValue == null)? 0 :this.baseLineValue.hashCode()));
        result = ((result* 31)+((this.legend == null)? 0 :this.legend.hashCode()));
        result = ((result* 31)+((this.publicAccess == null)? 0 :this.publicAccess.hashCode()));
        result = ((result* 31)+((this.userOrganisationUnitChildren == null)? 0 :this.userOrganisationUnitChildren.hashCode()));
        result = ((result* 31)+((this.axes == null)? 0 :this.axes.hashCode()));
        result = ((result* 31)+((this.displaySubtitle == null)? 0 :this.displaySubtitle.hashCode()));
        result = ((result* 31)+((this.type == null)? 0 :this.type.hashCode()));
        result = ((result* 31)+((this.hideEmptyColumns == null)? 0 :this.hideEmptyColumns.hashCode()));
        result = ((result* 31)+((this.measureCriteria == null)? 0 :this.measureCriteria.hashCode()));
        result = ((result* 31)+((this.displayTitle == null)? 0 :this.displayTitle.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.subscribed == null)? 0 :this.subscribed.hashCode()));
        result = ((result* 31)+((this.displayTargetLineLabel == null)? 0 :this.displayTargetLineLabel.hashCode()));
        result = ((result* 31)+((this.attributeDimensions == null)? 0 :this.attributeDimensions.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.yearlySeries == null)? 0 :this.yearlySeries.hashCode()));
        result = ((result* 31)+((this.userOrganisationUnit == null)? 0 :this.userOrganisationUnit.hashCode()));
        result = ((result* 31)+((this.filterDimensions == null)? 0 :this.filterDimensions.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.rowSubTotals == null)? 0 :this.rowSubTotals.hashCode()));
        result = ((result* 31)+((this.interpretations == null)? 0 :this.interpretations.hashCode()));
        result = ((result* 31)+((this.displayDescription == null)? 0 :this.displayDescription.hashCode()));
        result = ((result* 31)+((this.visualizationPeriodName == null)? 0 :this.visualizationPeriodName.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.domainAxisLabel == null)? 0 :this.domainAxisLabel.hashCode()));
        result = ((result* 31)+((this.subscribers == null)? 0 :this.subscribers.hashCode()));
        result = ((result* 31)+((this.cumulativeValues == null)? 0 :this.cumulativeValues.hashCode()));
        result = ((result* 31)+((this.fontStyle == null)? 0 :this.fontStyle.hashCode()));
        result = ((result* 31)+((this.optionalAxes == null)? 0 :this.optionalAxes.hashCode()));
        result = ((result* 31)+((this.showDimensionLabels == null)? 0 :this.showDimensionLabels.hashCode()));
        result = ((result* 31)+((this.sortOrder == null)? 0 :this.sortOrder.hashCode()));
        result = ((result* 31)+((this.subtitle == null)? 0 :this.subtitle.hashCode()));
        result = ((result* 31)+((this.fontSize == null)? 0 :this.fontSize.hashCode()));
        result = ((result* 31)+((this.rangeAxisDecimals == null)? 0 :this.rangeAxisDecimals.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.shortName == null)? 0 :this.shortName.hashCode()));
        result = ((result* 31)+((this.favorite == null)? 0 :this.favorite.hashCode()));
        result = ((result* 31)+((this.topLimit == null)? 0 :this.topLimit.hashCode()));
        result = ((result* 31)+((this.startDate == null)? 0 :this.startDate.hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.userOrganisationUnitGrandChildren == null)? 0 :this.userOrganisationUnitGrandChildren.hashCode()));
        result = ((result* 31)+((this.columns == null)? 0 :this.columns.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.displayShortName == null)? 0 :this.displayShortName.hashCode()));
        result = ((result* 31)+((this.percentStackedValues == null)? 0 :this.percentStackedValues.hashCode()));
        result = ((result* 31)+((this.noSpaceBetweenColumns == null)? 0 :this.noSpaceBetweenColumns.hashCode()));
        result = ((result* 31)+((this.dataElementDimensions == null)? 0 :this.dataElementDimensions.hashCode()));
        result = ((result* 31)+((this.rangeAxisSteps == null)? 0 :this.rangeAxisSteps.hashCode()));
        result = ((result* 31)+((this.formName == null)? 0 :this.formName.hashCode()));
        result = ((result* 31)+((this.periods == null)? 0 :this.periods.hashCode()));
        result = ((result* 31)+((this.categoryDimensions == null)? 0 :this.categoryDimensions.hashCode()));
        result = ((result* 31)+((this.showHierarchy == null)? 0 :this.showHierarchy.hashCode()));
        result = ((result* 31)+((this.displayRangeAxisLabel == null)? 0 :this.displayRangeAxisLabel.hashCode()));
        result = ((result* 31)+((this.seriesKey == null)? 0 :this.seriesKey.hashCode()));
        result = ((result* 31)+((this.reportingParams == null)? 0 :this.reportingParams.hashCode()));
        result = ((result* 31)+((this.hideTitle == null)? 0 :this.hideTitle.hashCode()));
        result = ((result* 31)+((this.rowDimensions == null)? 0 :this.rowDimensions.hashCode()));
        result = ((result* 31)+((this.series == null)? 0 :this.series.hashCode()));
        result = ((result* 31)+((this.colorSet == null)? 0 :this.colorSet.hashCode()));
        result = ((result* 31)+((this.displayBaseLineLabel == null)? 0 :this.displayBaseLineLabel.hashCode()));
        result = ((result* 31)+((this.skipRounding == null)? 0 :this.skipRounding.hashCode()));
        result = ((result* 31)+((this.showData == null)? 0 :this.showData.hashCode()));
        result = ((result* 31)+((this.fixRowHeaders == null)? 0 :this.fixRowHeaders.hashCode()));
        result = ((result* 31)+((this.numberType == null)? 0 :this.numberType.hashCode()));
        result = ((result* 31)+((this.hideEmptyRows == null)? 0 :this.hideEmptyRows.hashCode()));
        result = ((result* 31)+((this.parentGraphMap == null)? 0 :this.parentGraphMap.hashCode()));
        result = ((result* 31)+((this.itemOrganisationUnitGroups == null)? 0 :this.itemOrganisationUnitGroups.hashCode()));
        result = ((result* 31)+((this.displayDensity == null)? 0 :this.displayDensity.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.displayDomainAxisLabel == null)? 0 :this.displayDomainAxisLabel.hashCode()));
        result = ((result* 31)+((this.programIndicatorDimensions == null)? 0 :this.programIndicatorDimensions.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.rangeAxisLabel == null)? 0 :this.rangeAxisLabel.hashCode()));
        result = ((result* 31)+((this.attributeValues == null)? 0 :this.attributeValues.hashCode()));
        result = ((result* 31)+((this.columnDimensions == null)? 0 :this.columnDimensions.hashCode()));
        result = ((result* 31)+((this.regressionType == null)? 0 :this.regressionType.hashCode()));
        result = ((result* 31)+((this.completedOnly == null)? 0 :this.completedOnly.hashCode()));
        result = ((result* 31)+((this.colTotals == null)? 0 :this.colTotals.hashCode()));
        result = ((result* 31)+((this.sharing == null)? 0 :this.sharing.hashCode()));
        result = ((result* 31)+((this.displayFormName == null)? 0 :this.displayFormName.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.hideEmptyRowItems == null)? 0 :this.hideEmptyRowItems.hashCode()));
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.aggregationType == null)? 0 :this.aggregationType.hashCode()));
        result = ((result* 31)+((this.dataDimensionItems == null)? 0 :this.dataDimensionItems.hashCode()));
        result = ((result* 31)+((this.categoryOptionGroupSetDimensions == null)? 0 :this.categoryOptionGroupSetDimensions.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.hideSubtitle == null)? 0 :this.hideSubtitle.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.organisationUnitGroupSetDimensions == null)? 0 :this.organisationUnitGroupSetDimensions.hashCode()));
        result = ((result* 31)+((this.title == null)? 0 :this.title.hashCode()));
        result = ((result* 31)+((this.hideLegend == null)? 0 :this.hideLegend.hashCode()));
        result = ((result* 31)+((this.fixColumnHeaders == null)? 0 :this.fixColumnHeaders.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.organisationUnitLevels == null)? 0 :this.organisationUnitLevels.hashCode()));
        result = ((result* 31)+((this.rangeAxisMinValue == null)? 0 :this.rangeAxisMinValue.hashCode()));
        result = ((result* 31)+((this.colSubTotals == null)? 0 :this.colSubTotals.hashCode()));
        result = ((result* 31)+((this.relativePeriods == null)? 0 :this.relativePeriods.hashCode()));
        result = ((result* 31)+((this.targetLineLabel == null)? 0 :this.targetLineLabel.hashCode()));
        result = ((result* 31)+((this.organisationUnits == null)? 0 :this.organisationUnits.hashCode()));
        result = ((result* 31)+((this.rowTotals == null)? 0 :this.rowTotals.hashCode()));
        result = ((result* 31)+((this.timeField == null)? 0 :this.timeField.hashCode()));
        result = ((result* 31)+((this.targetLineValue == null)? 0 :this.targetLineValue.hashCode()));
        result = ((result* 31)+((this.filters == null)? 0 :this.filters.hashCode()));
        result = ((result* 31)+((this.icons == null)? 0 :this.icons.hashCode()));
        result = ((result* 31)+((this.rows == null)? 0 :this.rows.hashCode()));
        result = ((result* 31)+((this.outlierAnalysis == null)? 0 :this.outlierAnalysis.hashCode()));
        result = ((result* 31)+((this.baseLineLabel == null)? 0 :this.baseLineLabel.hashCode()));
        result = ((result* 31)+((this.digitGroupSeparator == null)? 0 :this.digitGroupSeparator.hashCode()));
        result = ((result* 31)+((this.createdBy == null)? 0 :this.createdBy.hashCode()));
        result = ((result* 31)+((this.regression == null)? 0 :this.regression.hashCode()));
        result = ((result* 31)+((this.userOrgUnitType == null)? 0 :this.userOrgUnitType.hashCode()));
        result = ((result* 31)+((this.rangeAxisMaxValue == null)? 0 :this.rangeAxisMaxValue.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Visualization) == false) {
            return false;
        }
        Visualization rhs = ((Visualization) other);
        return ((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((this.dataElementGroupSetDimensions == rhs.dataElementGroupSetDimensions)||((this.dataElementGroupSetDimensions!= null)&&this.dataElementGroupSetDimensions.equals(rhs.dataElementGroupSetDimensions)))&&((this.orgUnitField == rhs.orgUnitField)||((this.orgUnitField!= null)&&this.orgUnitField.equals(rhs.orgUnitField))))&&((this.endDate == rhs.endDate)||((this.endDate!= null)&&this.endDate.equals(rhs.endDate))))&&((this.baseLineValue == rhs.baseLineValue)||((this.baseLineValue!= null)&&this.baseLineValue.equals(rhs.baseLineValue))))&&((this.legend == rhs.legend)||((this.legend!= null)&&this.legend.equals(rhs.legend))))&&((this.publicAccess == rhs.publicAccess)||((this.publicAccess!= null)&&this.publicAccess.equals(rhs.publicAccess))))&&((this.userOrganisationUnitChildren == rhs.userOrganisationUnitChildren)||((this.userOrganisationUnitChildren!= null)&&this.userOrganisationUnitChildren.equals(rhs.userOrganisationUnitChildren))))&&((this.axes == rhs.axes)||((this.axes!= null)&&this.axes.equals(rhs.axes))))&&((this.displaySubtitle == rhs.displaySubtitle)||((this.displaySubtitle!= null)&&this.displaySubtitle.equals(rhs.displaySubtitle))))&&((this.type == rhs.type)||((this.type!= null)&&this.type.equals(rhs.type))))&&((this.hideEmptyColumns == rhs.hideEmptyColumns)||((this.hideEmptyColumns!= null)&&this.hideEmptyColumns.equals(rhs.hideEmptyColumns))))&&((this.measureCriteria == rhs.measureCriteria)||((this.measureCriteria!= null)&&this.measureCriteria.equals(rhs.measureCriteria))))&&((this.displayTitle == rhs.displayTitle)||((this.displayTitle!= null)&&this.displayTitle.equals(rhs.displayTitle))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.subscribed == rhs.subscribed)||((this.subscribed!= null)&&this.subscribed.equals(rhs.subscribed))))&&((this.displayTargetLineLabel == rhs.displayTargetLineLabel)||((this.displayTargetLineLabel!= null)&&this.displayTargetLineLabel.equals(rhs.displayTargetLineLabel))))&&((this.attributeDimensions == rhs.attributeDimensions)||((this.attributeDimensions!= null)&&this.attributeDimensions.equals(rhs.attributeDimensions))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.yearlySeries == rhs.yearlySeries)||((this.yearlySeries!= null)&&this.yearlySeries.equals(rhs.yearlySeries))))&&((this.userOrganisationUnit == rhs.userOrganisationUnit)||((this.userOrganisationUnit!= null)&&this.userOrganisationUnit.equals(rhs.userOrganisationUnit))))&&((this.filterDimensions == rhs.filterDimensions)||((this.filterDimensions!= null)&&this.filterDimensions.equals(rhs.filterDimensions))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.rowSubTotals == rhs.rowSubTotals)||((this.rowSubTotals!= null)&&this.rowSubTotals.equals(rhs.rowSubTotals))))&&((this.interpretations == rhs.interpretations)||((this.interpretations!= null)&&this.interpretations.equals(rhs.interpretations))))&&((this.displayDescription == rhs.displayDescription)||((this.displayDescription!= null)&&this.displayDescription.equals(rhs.displayDescription))))&&((this.visualizationPeriodName == rhs.visualizationPeriodName)||((this.visualizationPeriodName!= null)&&this.visualizationPeriodName.equals(rhs.visualizationPeriodName))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.domainAxisLabel == rhs.domainAxisLabel)||((this.domainAxisLabel!= null)&&this.domainAxisLabel.equals(rhs.domainAxisLabel))))&&((this.subscribers == rhs.subscribers)||((this.subscribers!= null)&&this.subscribers.equals(rhs.subscribers))))&&((this.cumulativeValues == rhs.cumulativeValues)||((this.cumulativeValues!= null)&&this.cumulativeValues.equals(rhs.cumulativeValues))))&&((this.fontStyle == rhs.fontStyle)||((this.fontStyle!= null)&&this.fontStyle.equals(rhs.fontStyle))))&&((this.optionalAxes == rhs.optionalAxes)||((this.optionalAxes!= null)&&this.optionalAxes.equals(rhs.optionalAxes))))&&((this.showDimensionLabels == rhs.showDimensionLabels)||((this.showDimensionLabels!= null)&&this.showDimensionLabels.equals(rhs.showDimensionLabels))))&&((this.sortOrder == rhs.sortOrder)||((this.sortOrder!= null)&&this.sortOrder.equals(rhs.sortOrder))))&&((this.subtitle == rhs.subtitle)||((this.subtitle!= null)&&this.subtitle.equals(rhs.subtitle))))&&((this.fontSize == rhs.fontSize)||((this.fontSize!= null)&&this.fontSize.equals(rhs.fontSize))))&&((this.rangeAxisDecimals == rhs.rangeAxisDecimals)||((this.rangeAxisDecimals!= null)&&this.rangeAxisDecimals.equals(rhs.rangeAxisDecimals))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.shortName == rhs.shortName)||((this.shortName!= null)&&this.shortName.equals(rhs.shortName))))&&((this.favorite == rhs.favorite)||((this.favorite!= null)&&this.favorite.equals(rhs.favorite))))&&((this.topLimit == rhs.topLimit)||((this.topLimit!= null)&&this.topLimit.equals(rhs.topLimit))))&&((this.startDate == rhs.startDate)||((this.startDate!= null)&&this.startDate.equals(rhs.startDate))))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.userOrganisationUnitGrandChildren == rhs.userOrganisationUnitGrandChildren)||((this.userOrganisationUnitGrandChildren!= null)&&this.userOrganisationUnitGrandChildren.equals(rhs.userOrganisationUnitGrandChildren))))&&((this.columns == rhs.columns)||((this.columns!= null)&&this.columns.equals(rhs.columns))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.displayShortName == rhs.displayShortName)||((this.displayShortName!= null)&&this.displayShortName.equals(rhs.displayShortName))))&&((this.percentStackedValues == rhs.percentStackedValues)||((this.percentStackedValues!= null)&&this.percentStackedValues.equals(rhs.percentStackedValues))))&&((this.noSpaceBetweenColumns == rhs.noSpaceBetweenColumns)||((this.noSpaceBetweenColumns!= null)&&this.noSpaceBetweenColumns.equals(rhs.noSpaceBetweenColumns))))&&((this.dataElementDimensions == rhs.dataElementDimensions)||((this.dataElementDimensions!= null)&&this.dataElementDimensions.equals(rhs.dataElementDimensions))))&&((this.rangeAxisSteps == rhs.rangeAxisSteps)||((this.rangeAxisSteps!= null)&&this.rangeAxisSteps.equals(rhs.rangeAxisSteps))))&&((this.formName == rhs.formName)||((this.formName!= null)&&this.formName.equals(rhs.formName))))&&((this.periods == rhs.periods)||((this.periods!= null)&&this.periods.equals(rhs.periods))))&&((this.categoryDimensions == rhs.categoryDimensions)||((this.categoryDimensions!= null)&&this.categoryDimensions.equals(rhs.categoryDimensions))))&&((this.showHierarchy == rhs.showHierarchy)||((this.showHierarchy!= null)&&this.showHierarchy.equals(rhs.showHierarchy))))&&((this.displayRangeAxisLabel == rhs.displayRangeAxisLabel)||((this.displayRangeAxisLabel!= null)&&this.displayRangeAxisLabel.equals(rhs.displayRangeAxisLabel))))&&((this.seriesKey == rhs.seriesKey)||((this.seriesKey!= null)&&this.seriesKey.equals(rhs.seriesKey))))&&((this.reportingParams == rhs.reportingParams)||((this.reportingParams!= null)&&this.reportingParams.equals(rhs.reportingParams))))&&((this.hideTitle == rhs.hideTitle)||((this.hideTitle!= null)&&this.hideTitle.equals(rhs.hideTitle))))&&((this.rowDimensions == rhs.rowDimensions)||((this.rowDimensions!= null)&&this.rowDimensions.equals(rhs.rowDimensions))))&&((this.series == rhs.series)||((this.series!= null)&&this.series.equals(rhs.series))))&&((this.colorSet == rhs.colorSet)||((this.colorSet!= null)&&this.colorSet.equals(rhs.colorSet))))&&((this.displayBaseLineLabel == rhs.displayBaseLineLabel)||((this.displayBaseLineLabel!= null)&&this.displayBaseLineLabel.equals(rhs.displayBaseLineLabel))))&&((this.skipRounding == rhs.skipRounding)||((this.skipRounding!= null)&&this.skipRounding.equals(rhs.skipRounding))))&&((this.showData == rhs.showData)||((this.showData!= null)&&this.showData.equals(rhs.showData))))&&((this.fixRowHeaders == rhs.fixRowHeaders)||((this.fixRowHeaders!= null)&&this.fixRowHeaders.equals(rhs.fixRowHeaders))))&&((this.numberType == rhs.numberType)||((this.numberType!= null)&&this.numberType.equals(rhs.numberType))))&&((this.hideEmptyRows == rhs.hideEmptyRows)||((this.hideEmptyRows!= null)&&this.hideEmptyRows.equals(rhs.hideEmptyRows))))&&((this.parentGraphMap == rhs.parentGraphMap)||((this.parentGraphMap!= null)&&this.parentGraphMap.equals(rhs.parentGraphMap))))&&((this.itemOrganisationUnitGroups == rhs.itemOrganisationUnitGroups)||((this.itemOrganisationUnitGroups!= null)&&this.itemOrganisationUnitGroups.equals(rhs.itemOrganisationUnitGroups))))&&((this.displayDensity == rhs.displayDensity)||((this.displayDensity!= null)&&this.displayDensity.equals(rhs.displayDensity))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.displayDomainAxisLabel == rhs.displayDomainAxisLabel)||((this.displayDomainAxisLabel!= null)&&this.displayDomainAxisLabel.equals(rhs.displayDomainAxisLabel))))&&((this.programIndicatorDimensions == rhs.programIndicatorDimensions)||((this.programIndicatorDimensions!= null)&&this.programIndicatorDimensions.equals(rhs.programIndicatorDimensions))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.rangeAxisLabel == rhs.rangeAxisLabel)||((this.rangeAxisLabel!= null)&&this.rangeAxisLabel.equals(rhs.rangeAxisLabel))))&&((this.attributeValues == rhs.attributeValues)||((this.attributeValues!= null)&&this.attributeValues.equals(rhs.attributeValues))))&&((this.columnDimensions == rhs.columnDimensions)||((this.columnDimensions!= null)&&this.columnDimensions.equals(rhs.columnDimensions))))&&((this.regressionType == rhs.regressionType)||((this.regressionType!= null)&&this.regressionType.equals(rhs.regressionType))))&&((this.completedOnly == rhs.completedOnly)||((this.completedOnly!= null)&&this.completedOnly.equals(rhs.completedOnly))))&&((this.colTotals == rhs.colTotals)||((this.colTotals!= null)&&this.colTotals.equals(rhs.colTotals))))&&((this.sharing == rhs.sharing)||((this.sharing!= null)&&this.sharing.equals(rhs.sharing))))&&((this.displayFormName == rhs.displayFormName)||((this.displayFormName!= null)&&this.displayFormName.equals(rhs.displayFormName))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.hideEmptyRowItems == rhs.hideEmptyRowItems)||((this.hideEmptyRowItems!= null)&&this.hideEmptyRowItems.equals(rhs.hideEmptyRowItems))))&&((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites))))&&((this.aggregationType == rhs.aggregationType)||((this.aggregationType!= null)&&this.aggregationType.equals(rhs.aggregationType))))&&((this.dataDimensionItems == rhs.dataDimensionItems)||((this.dataDimensionItems!= null)&&this.dataDimensionItems.equals(rhs.dataDimensionItems))))&&((this.categoryOptionGroupSetDimensions == rhs.categoryOptionGroupSetDimensions)||((this.categoryOptionGroupSetDimensions!= null)&&this.categoryOptionGroupSetDimensions.equals(rhs.categoryOptionGroupSetDimensions))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.hideSubtitle == rhs.hideSubtitle)||((this.hideSubtitle!= null)&&this.hideSubtitle.equals(rhs.hideSubtitle))))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.organisationUnitGroupSetDimensions == rhs.organisationUnitGroupSetDimensions)||((this.organisationUnitGroupSetDimensions!= null)&&this.organisationUnitGroupSetDimensions.equals(rhs.organisationUnitGroupSetDimensions))))&&((this.title == rhs.title)||((this.title!= null)&&this.title.equals(rhs.title))))&&((this.hideLegend == rhs.hideLegend)||((this.hideLegend!= null)&&this.hideLegend.equals(rhs.hideLegend))))&&((this.fixColumnHeaders == rhs.fixColumnHeaders)||((this.fixColumnHeaders!= null)&&this.fixColumnHeaders.equals(rhs.fixColumnHeaders))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.organisationUnitLevels == rhs.organisationUnitLevels)||((this.organisationUnitLevels!= null)&&this.organisationUnitLevels.equals(rhs.organisationUnitLevels))))&&((this.rangeAxisMinValue == rhs.rangeAxisMinValue)||((this.rangeAxisMinValue!= null)&&this.rangeAxisMinValue.equals(rhs.rangeAxisMinValue))))&&((this.colSubTotals == rhs.colSubTotals)||((this.colSubTotals!= null)&&this.colSubTotals.equals(rhs.colSubTotals))))&&((this.relativePeriods == rhs.relativePeriods)||((this.relativePeriods!= null)&&this.relativePeriods.equals(rhs.relativePeriods))))&&((this.targetLineLabel == rhs.targetLineLabel)||((this.targetLineLabel!= null)&&this.targetLineLabel.equals(rhs.targetLineLabel))))&&((this.organisationUnits == rhs.organisationUnits)||((this.organisationUnits!= null)&&this.organisationUnits.equals(rhs.organisationUnits))))&&((this.rowTotals == rhs.rowTotals)||((this.rowTotals!= null)&&this.rowTotals.equals(rhs.rowTotals))))&&((this.timeField == rhs.timeField)||((this.timeField!= null)&&this.timeField.equals(rhs.timeField))))&&((this.targetLineValue == rhs.targetLineValue)||((this.targetLineValue!= null)&&this.targetLineValue.equals(rhs.targetLineValue))))&&((this.filters == rhs.filters)||((this.filters!= null)&&this.filters.equals(rhs.filters))))&&((this.icons == rhs.icons)||((this.icons!= null)&&this.icons.equals(rhs.icons))))&&((this.rows == rhs.rows)||((this.rows!= null)&&this.rows.equals(rhs.rows))))&&((this.outlierAnalysis == rhs.outlierAnalysis)||((this.outlierAnalysis!= null)&&this.outlierAnalysis.equals(rhs.outlierAnalysis))))&&((this.baseLineLabel == rhs.baseLineLabel)||((this.baseLineLabel!= null)&&this.baseLineLabel.equals(rhs.baseLineLabel))))&&((this.digitGroupSeparator == rhs.digitGroupSeparator)||((this.digitGroupSeparator!= null)&&this.digitGroupSeparator.equals(rhs.digitGroupSeparator))))&&((this.createdBy == rhs.createdBy)||((this.createdBy!= null)&&this.createdBy.equals(rhs.createdBy))))&&((this.regression == rhs.regression)||((this.regression!= null)&&this.regression.equals(rhs.regression))))&&((this.userOrgUnitType == rhs.userOrgUnitType)||((this.userOrgUnitType!= null)&&this.userOrgUnitType.equals(rhs.userOrgUnitType))))&&((this.rangeAxisMaxValue == rhs.rangeAxisMaxValue)||((this.rangeAxisMaxValue!= null)&&this.rangeAxisMaxValue.equals(rhs.rangeAxisMaxValue))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))));
    }

    @Generated("jsonschema2pojo")
    public enum AggregationType {

        SUM("SUM"),
        AVERAGE("AVERAGE"),
        AVERAGE_SUM_ORG_UNIT("AVERAGE_SUM_ORG_UNIT"),
        LAST("LAST"),
        LAST_AVERAGE_ORG_UNIT("LAST_AVERAGE_ORG_UNIT"),
        LAST_LAST_ORG_UNIT("LAST_LAST_ORG_UNIT"),
        LAST_IN_PERIOD("LAST_IN_PERIOD"),
        LAST_IN_PERIOD_AVERAGE_ORG_UNIT("LAST_IN_PERIOD_AVERAGE_ORG_UNIT"),
        FIRST("FIRST"),
        FIRST_AVERAGE_ORG_UNIT("FIRST_AVERAGE_ORG_UNIT"),
        FIRST_FIRST_ORG_UNIT("FIRST_FIRST_ORG_UNIT"),
        COUNT("COUNT"),
        STDDEV("STDDEV"),
        VARIANCE("VARIANCE"),
        MIN("MIN"),
        MAX("MAX"),
        MIN_SUM_ORG_UNIT("MIN_SUM_ORG_UNIT"),
        MAX_SUM_ORG_UNIT("MAX_SUM_ORG_UNIT"),
        NONE("NONE"),
        CUSTOM("CUSTOM"),
        DEFAULT("DEFAULT");
        private final String value;
        private final static Map<String, Visualization.AggregationType> CONSTANTS = new HashMap<String, Visualization.AggregationType>();

        static {
            for (Visualization.AggregationType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        AggregationType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Visualization.AggregationType fromValue(String value) {
            Visualization.AggregationType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum DigitGroupSeparator {

        COMMA("COMMA"),
        SPACE("SPACE"),
        NONE("NONE");
        private final String value;
        private final static Map<String, Visualization.DigitGroupSeparator> CONSTANTS = new HashMap<String, Visualization.DigitGroupSeparator>();

        static {
            for (Visualization.DigitGroupSeparator c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        DigitGroupSeparator(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Visualization.DigitGroupSeparator fromValue(String value) {
            Visualization.DigitGroupSeparator constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum DisplayDensity {

        COMFORTABLE("COMFORTABLE"),
        NORMAL("NORMAL"),
        COMPACT("COMPACT"),
        NONE("NONE");
        private final String value;
        private final static Map<String, Visualization.DisplayDensity> CONSTANTS = new HashMap<String, Visualization.DisplayDensity>();

        static {
            for (Visualization.DisplayDensity c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        DisplayDensity(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Visualization.DisplayDensity fromValue(String value) {
            Visualization.DisplayDensity constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum FontSize {

        LARGE("LARGE"),
        NORMAL("NORMAL"),
        SMALL("SMALL");
        private final String value;
        private final static Map<String, Visualization.FontSize> CONSTANTS = new HashMap<String, Visualization.FontSize>();

        static {
            for (Visualization.FontSize c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        FontSize(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Visualization.FontSize fromValue(String value) {
            Visualization.FontSize constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum HideEmptyRowItems {

        NONE("NONE"),
        BEFORE_FIRST("BEFORE_FIRST"),
        AFTER_LAST("AFTER_LAST"),
        BEFORE_FIRST_AFTER_LAST("BEFORE_FIRST_AFTER_LAST"),
        ALL("ALL");
        private final String value;
        private final static Map<String, Visualization.HideEmptyRowItems> CONSTANTS = new HashMap<String, Visualization.HideEmptyRowItems>();

        static {
            for (Visualization.HideEmptyRowItems c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        HideEmptyRowItems(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Visualization.HideEmptyRowItems fromValue(String value) {
            Visualization.HideEmptyRowItems constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum NumberType {

        VALUE("VALUE"),
        ROW_PERCENTAGE("ROW_PERCENTAGE"),
        COLUMN_PERCENTAGE("COLUMN_PERCENTAGE");
        private final String value;
        private final static Map<String, Visualization.NumberType> CONSTANTS = new HashMap<String, Visualization.NumberType>();

        static {
            for (Visualization.NumberType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        NumberType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Visualization.NumberType fromValue(String value) {
            Visualization.NumberType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum RegressionType {

        NONE("NONE"),
        LINEAR("LINEAR"),
        POLYNOMIAL("POLYNOMIAL"),
        LOESS("LOESS");
        private final String value;
        private final static Map<String, Visualization.RegressionType> CONSTANTS = new HashMap<String, Visualization.RegressionType>();

        static {
            for (Visualization.RegressionType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        RegressionType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Visualization.RegressionType fromValue(String value) {
            Visualization.RegressionType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum Type {

        COLUMN("COLUMN"),
        STACKED_COLUMN("STACKED_COLUMN"),
        BAR("BAR"),
        STACKED_BAR("STACKED_BAR"),
        LINE("LINE"),
        AREA("AREA"),
        STACKED_AREA("STACKED_AREA"),
        PIE("PIE"),
        RADAR("RADAR"),
        GAUGE("GAUGE"),
        YEAR_OVER_YEAR_LINE("YEAR_OVER_YEAR_LINE"),
        YEAR_OVER_YEAR_COLUMN("YEAR_OVER_YEAR_COLUMN"),
        SCATTER("SCATTER"),
        BUBBLE("BUBBLE"),
        SINGLE_VALUE("SINGLE_VALUE"),
        PIVOT_TABLE("PIVOT_TABLE");
        private final String value;
        private final static Map<String, Visualization.Type> CONSTANTS = new HashMap<String, Visualization.Type>();

        static {
            for (Visualization.Type c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        Type(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Visualization.Type fromValue(String value) {
            Visualization.Type constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum UserOrgUnitType {

        DATA_CAPTURE("DATA_CAPTURE"),
        DATA_OUTPUT("DATA_OUTPUT"),
        TEI_SEARCH("TEI_SEARCH");
        private final String value;
        private final static Map<String, Visualization.UserOrgUnitType> CONSTANTS = new HashMap<String, Visualization.UserOrgUnitType>();

        static {
            for (Visualization.UserOrgUnitType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        UserOrgUnitType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Visualization.UserOrgUnitType fromValue(String value) {
            Visualization.UserOrgUnitType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
