
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "complete",
    "completedTime",
    "description",
    "duration",
    "error",
    "items",
    "onFailure",
    "status",
    "summary",
    "totalItems"
})
@Generated("jsonschema2pojo")
public class Stage implements Serializable
{

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("complete")
    private Boolean complete;
    @JsonProperty("completedTime")
    private Date completedTime;
    @JsonProperty("description")
    private String description;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("duration")
    private Integer duration;
    @JsonProperty("error")
    private String error;
    @JsonProperty("items")
    private List<Item> items = null;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("onFailure")
    private Stage.OnFailure onFailure;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("status")
    private Stage.Status status;
    @JsonProperty("summary")
    private String summary;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("totalItems")
    private Integer totalItems;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 6950909872826840583L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Stage() {
    }

    /**
     * 
     * @param source
     */
    public Stage(Stage source) {
        super();
        this.complete = source.complete;
        this.completedTime = source.completedTime;
        this.description = source.description;
        this.duration = source.duration;
        this.error = source.error;
        this.items = source.items;
        this.onFailure = source.onFailure;
        this.status = source.status;
        this.summary = source.summary;
        this.totalItems = source.totalItems;
    }

    /**
     * 
     * @param duration
     * @param summary
     * @param totalItems
     * @param completedTime
     * @param description
     * @param onFailure
     * @param complete
     * @param error
     * @param items
     * @param status
     */
    public Stage(Boolean complete, Date completedTime, String description, Integer duration, String error, List<Item> items, Stage.OnFailure onFailure, Stage.Status status, String summary, Integer totalItems) {
        super();
        this.complete = complete;
        this.completedTime = completedTime;
        this.description = description;
        this.duration = duration;
        this.error = error;
        this.items = items;
        this.onFailure = onFailure;
        this.status = status;
        this.summary = summary;
        this.totalItems = totalItems;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("complete")
    public Boolean getComplete() {
        return complete;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("complete")
    public void setComplete(Boolean complete) {
        this.complete = complete;
    }

    public Stage withComplete(Boolean complete) {
        this.complete = complete;
        return this;
    }

    @JsonProperty("completedTime")
    public Optional<Date> getCompletedTime() {
        return Optional.ofNullable(completedTime);
    }

    @JsonProperty("completedTime")
    public void setCompletedTime(Date completedTime) {
        this.completedTime = completedTime;
    }

    public Stage withCompletedTime(Date completedTime) {
        this.completedTime = completedTime;
        return this;
    }

    @JsonProperty("description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    public Stage withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("duration")
    public Integer getDuration() {
        return duration;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("duration")
    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public Stage withDuration(Integer duration) {
        this.duration = duration;
        return this;
    }

    @JsonProperty("error")
    public Optional<String> getError() {
        return Optional.ofNullable(error);
    }

    @JsonProperty("error")
    public void setError(String error) {
        this.error = error;
    }

    public Stage withError(String error) {
        this.error = error;
        return this;
    }

    @JsonProperty("items")
    public Optional<List<Item>> getItems() {
        return Optional.ofNullable(items);
    }

    @JsonProperty("items")
    public void setItems(List<Item> items) {
        this.items = items;
    }

    public Stage withItems(List<Item> items) {
        this.items = items;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("onFailure")
    public Stage.OnFailure getOnFailure() {
        return onFailure;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("onFailure")
    public void setOnFailure(Stage.OnFailure onFailure) {
        this.onFailure = onFailure;
    }

    public Stage withOnFailure(Stage.OnFailure onFailure) {
        this.onFailure = onFailure;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("status")
    public Stage.Status getStatus() {
        return status;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("status")
    public void setStatus(Stage.Status status) {
        this.status = status;
    }

    public Stage withStatus(Stage.Status status) {
        this.status = status;
        return this;
    }

    @JsonProperty("summary")
    public Optional<String> getSummary() {
        return Optional.ofNullable(summary);
    }

    @JsonProperty("summary")
    public void setSummary(String summary) {
        this.summary = summary;
    }

    public Stage withSummary(String summary) {
        this.summary = summary;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("totalItems")
    public Integer getTotalItems() {
        return totalItems;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("totalItems")
    public void setTotalItems(Integer totalItems) {
        this.totalItems = totalItems;
    }

    public Stage withTotalItems(Integer totalItems) {
        this.totalItems = totalItems;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Stage withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "complete":
                if (value instanceof Boolean) {
                    setComplete(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"complete\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "completedTime":
                if (value instanceof Date) {
                    setCompletedTime(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"completedTime\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "description":
                if (value instanceof String) {
                    setDescription(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"description\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "duration":
                if (value instanceof Integer) {
                    setDuration(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"duration\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "error":
                if (value instanceof String) {
                    setError(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"error\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "items":
                if (value instanceof List) {
                    setItems(((List<Item> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"items\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.Item>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "onFailure":
                if (value instanceof Stage.OnFailure) {
                    setOnFailure(((Stage.OnFailure) value));
                } else {
                    throw new IllegalArgumentException(("property \"onFailure\" is of type \"org.hisp.dhis.api.model.v40_0.Stage.OnFailure\", but got "+ value.getClass().toString()));
                }
                return true;
            case "status":
                if (value instanceof Stage.Status) {
                    setStatus(((Stage.Status) value));
                } else {
                    throw new IllegalArgumentException(("property \"status\" is of type \"org.hisp.dhis.api.model.v40_0.Stage.Status\", but got "+ value.getClass().toString()));
                }
                return true;
            case "summary":
                if (value instanceof String) {
                    setSummary(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"summary\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "totalItems":
                if (value instanceof Integer) {
                    setTotalItems(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"totalItems\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "complete":
                return getComplete();
            case "completedTime":
                return getCompletedTime();
            case "description":
                return getDescription();
            case "duration":
                return getDuration();
            case "error":
                return getError();
            case "items":
                return getItems();
            case "onFailure":
                return getOnFailure();
            case "status":
                return getStatus();
            case "summary":
                return getSummary();
            case "totalItems":
                return getTotalItems();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, Stage.NOT_FOUND_VALUE);
        if (Stage.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public Stage with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Stage.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("complete");
        sb.append('=');
        sb.append(((this.complete == null)?"<null>":this.complete));
        sb.append(',');
        sb.append("completedTime");
        sb.append('=');
        sb.append(((this.completedTime == null)?"<null>":this.completedTime));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("duration");
        sb.append('=');
        sb.append(((this.duration == null)?"<null>":this.duration));
        sb.append(',');
        sb.append("error");
        sb.append('=');
        sb.append(((this.error == null)?"<null>":this.error));
        sb.append(',');
        sb.append("items");
        sb.append('=');
        sb.append(((this.items == null)?"<null>":this.items));
        sb.append(',');
        sb.append("onFailure");
        sb.append('=');
        sb.append(((this.onFailure == null)?"<null>":this.onFailure));
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(((this.status == null)?"<null>":this.status));
        sb.append(',');
        sb.append("summary");
        sb.append('=');
        sb.append(((this.summary == null)?"<null>":this.summary));
        sb.append(',');
        sb.append("totalItems");
        sb.append('=');
        sb.append(((this.totalItems == null)?"<null>":this.totalItems));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.summary == null)? 0 :this.summary.hashCode()));
        result = ((result* 31)+((this.totalItems == null)? 0 :this.totalItems.hashCode()));
        result = ((result* 31)+((this.completedTime == null)? 0 :this.completedTime.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.onFailure == null)? 0 :this.onFailure.hashCode()));
        result = ((result* 31)+((this.error == null)? 0 :this.error.hashCode()));
        result = ((result* 31)+((this.duration == null)? 0 :this.duration.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.complete == null)? 0 :this.complete.hashCode()));
        result = ((result* 31)+((this.items == null)? 0 :this.items.hashCode()));
        result = ((result* 31)+((this.status == null)? 0 :this.status.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Stage) == false) {
            return false;
        }
        Stage rhs = ((Stage) other);
        return ((((((((((((this.summary == rhs.summary)||((this.summary!= null)&&this.summary.equals(rhs.summary)))&&((this.totalItems == rhs.totalItems)||((this.totalItems!= null)&&this.totalItems.equals(rhs.totalItems))))&&((this.completedTime == rhs.completedTime)||((this.completedTime!= null)&&this.completedTime.equals(rhs.completedTime))))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.onFailure == rhs.onFailure)||((this.onFailure!= null)&&this.onFailure.equals(rhs.onFailure))))&&((this.error == rhs.error)||((this.error!= null)&&this.error.equals(rhs.error))))&&((this.duration == rhs.duration)||((this.duration!= null)&&this.duration.equals(rhs.duration))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.complete == rhs.complete)||((this.complete!= null)&&this.complete.equals(rhs.complete))))&&((this.items == rhs.items)||((this.items!= null)&&this.items.equals(rhs.items))))&&((this.status == rhs.status)||((this.status!= null)&&this.status.equals(rhs.status))));
    }

    @Generated("jsonschema2pojo")
    public enum OnFailure {

        PARENT("PARENT"),
        FAIL("FAIL"),
        SKIP_STAGE("SKIP_STAGE"),
        SKIP_ITEM("SKIP_ITEM"),
        SKIP_ITEM_OUTLIER("SKIP_ITEM_OUTLIER");
        private final String value;
        private final static Map<String, Stage.OnFailure> CONSTANTS = new HashMap<String, Stage.OnFailure>();

        static {
            for (Stage.OnFailure c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        OnFailure(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Stage.OnFailure fromValue(String value) {
            Stage.OnFailure constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum Status {

        RUNNING("RUNNING"),
        SUCCESS("SUCCESS"),
        ERROR("ERROR"),
        CANCELLED("CANCELLED");
        private final String value;
        private final static Map<String, Stage.Status> CONSTANTS = new HashMap<String, Stage.Status>();

        static {
            for (Stage.Status c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        Status(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Stage.Status fromValue(String value) {
            Stage.Status constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
