
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "code",
    "compulsory",
    "dataElement",
    "formula",
    "optionId",
    "trackedEntityAttribute"
})
@Generated("jsonschema2pojo")
public class SMSCode implements Serializable
{

    @JsonProperty("code")
    private String code;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("compulsory")
    private Boolean compulsory;
    /**
     * A UID reference to a DataElement  
     * (Java name `org.hisp.dhis.dataelement.DataElement`)
     * 
     */
    @JsonProperty("dataElement")
    @JsonPropertyDescription("A UID reference to a DataElement  \n(Java name `org.hisp.dhis.dataelement.DataElement`)")
    private RefDataElement dataElement;
    @JsonProperty("formula")
    private String formula;
    /**
     * A UID reference to a CategoryOptionCombo  
     * (Java name `org.hisp.dhis.category.CategoryOptionCombo`)
     * 
     */
    @JsonProperty("optionId")
    @JsonPropertyDescription("A UID reference to a CategoryOptionCombo  \n(Java name `org.hisp.dhis.category.CategoryOptionCombo`)")
    private RefCategoryOptionCombo optionId;
    /**
     * A UID reference to a TrackedEntityAttribute  
     * (Java name `org.hisp.dhis.trackedentity.TrackedEntityAttribute`)
     * 
     */
    @JsonProperty("trackedEntityAttribute")
    @JsonPropertyDescription("A UID reference to a TrackedEntityAttribute  \n(Java name `org.hisp.dhis.trackedentity.TrackedEntityAttribute`)")
    private RefTrackedEntityAttribute trackedEntityAttribute;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 3700718662016029743L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public SMSCode() {
    }

    /**
     * 
     * @param source
     */
    public SMSCode(SMSCode source) {
        super();
        this.code = source.code;
        this.compulsory = source.compulsory;
        this.dataElement = source.dataElement;
        this.formula = source.formula;
        this.optionId = source.optionId;
        this.trackedEntityAttribute = source.trackedEntityAttribute;
    }

    /**
     * 
     * @param compulsory
     * @param code
     * @param formula
     * @param optionId
     * @param dataElement
     * @param trackedEntityAttribute
     */
    public SMSCode(String code, Boolean compulsory, RefDataElement dataElement, String formula, RefCategoryOptionCombo optionId, RefTrackedEntityAttribute trackedEntityAttribute) {
        super();
        this.code = code;
        this.compulsory = compulsory;
        this.dataElement = dataElement;
        this.formula = formula;
        this.optionId = optionId;
        this.trackedEntityAttribute = trackedEntityAttribute;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public SMSCode withCode(String code) {
        this.code = code;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("compulsory")
    public Boolean getCompulsory() {
        return compulsory;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("compulsory")
    public void setCompulsory(Boolean compulsory) {
        this.compulsory = compulsory;
    }

    public SMSCode withCompulsory(Boolean compulsory) {
        this.compulsory = compulsory;
        return this;
    }

    /**
     * A UID reference to a DataElement  
     * (Java name `org.hisp.dhis.dataelement.DataElement`)
     * 
     */
    @JsonProperty("dataElement")
    public Optional<RefDataElement> getDataElement() {
        return Optional.ofNullable(dataElement);
    }

    /**
     * A UID reference to a DataElement  
     * (Java name `org.hisp.dhis.dataelement.DataElement`)
     * 
     */
    @JsonProperty("dataElement")
    public void setDataElement(RefDataElement dataElement) {
        this.dataElement = dataElement;
    }

    public SMSCode withDataElement(RefDataElement dataElement) {
        this.dataElement = dataElement;
        return this;
    }

    @JsonProperty("formula")
    public Optional<String> getFormula() {
        return Optional.ofNullable(formula);
    }

    @JsonProperty("formula")
    public void setFormula(String formula) {
        this.formula = formula;
    }

    public SMSCode withFormula(String formula) {
        this.formula = formula;
        return this;
    }

    /**
     * A UID reference to a CategoryOptionCombo  
     * (Java name `org.hisp.dhis.category.CategoryOptionCombo`)
     * 
     */
    @JsonProperty("optionId")
    public Optional<RefCategoryOptionCombo> getOptionId() {
        return Optional.ofNullable(optionId);
    }

    /**
     * A UID reference to a CategoryOptionCombo  
     * (Java name `org.hisp.dhis.category.CategoryOptionCombo`)
     * 
     */
    @JsonProperty("optionId")
    public void setOptionId(RefCategoryOptionCombo optionId) {
        this.optionId = optionId;
    }

    public SMSCode withOptionId(RefCategoryOptionCombo optionId) {
        this.optionId = optionId;
        return this;
    }

    /**
     * A UID reference to a TrackedEntityAttribute  
     * (Java name `org.hisp.dhis.trackedentity.TrackedEntityAttribute`)
     * 
     */
    @JsonProperty("trackedEntityAttribute")
    public Optional<RefTrackedEntityAttribute> getTrackedEntityAttribute() {
        return Optional.ofNullable(trackedEntityAttribute);
    }

    /**
     * A UID reference to a TrackedEntityAttribute  
     * (Java name `org.hisp.dhis.trackedentity.TrackedEntityAttribute`)
     * 
     */
    @JsonProperty("trackedEntityAttribute")
    public void setTrackedEntityAttribute(RefTrackedEntityAttribute trackedEntityAttribute) {
        this.trackedEntityAttribute = trackedEntityAttribute;
    }

    public SMSCode withTrackedEntityAttribute(RefTrackedEntityAttribute trackedEntityAttribute) {
        this.trackedEntityAttribute = trackedEntityAttribute;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public SMSCode withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "code":
                if (value instanceof String) {
                    setCode(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "compulsory":
                if (value instanceof Boolean) {
                    setCompulsory(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"compulsory\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataElement":
                if (value instanceof RefDataElement) {
                    setDataElement(((RefDataElement) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataElement\" is of type \"org.hisp.dhis.api.model.v40_0.RefDataElement\", but got "+ value.getClass().toString()));
                }
                return true;
            case "formula":
                if (value instanceof String) {
                    setFormula(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"formula\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "optionId":
                if (value instanceof RefCategoryOptionCombo) {
                    setOptionId(((RefCategoryOptionCombo) value));
                } else {
                    throw new IllegalArgumentException(("property \"optionId\" is of type \"org.hisp.dhis.api.model.v40_0.RefCategoryOptionCombo\", but got "+ value.getClass().toString()));
                }
                return true;
            case "trackedEntityAttribute":
                if (value instanceof RefTrackedEntityAttribute) {
                    setTrackedEntityAttribute(((RefTrackedEntityAttribute) value));
                } else {
                    throw new IllegalArgumentException(("property \"trackedEntityAttribute\" is of type \"org.hisp.dhis.api.model.v40_0.RefTrackedEntityAttribute\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "code":
                return getCode();
            case "compulsory":
                return getCompulsory();
            case "dataElement":
                return getDataElement();
            case "formula":
                return getFormula();
            case "optionId":
                return getOptionId();
            case "trackedEntityAttribute":
                return getTrackedEntityAttribute();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, SMSCode.NOT_FOUND_VALUE);
        if (SMSCode.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public SMSCode with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(SMSCode.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("compulsory");
        sb.append('=');
        sb.append(((this.compulsory == null)?"<null>":this.compulsory));
        sb.append(',');
        sb.append("dataElement");
        sb.append('=');
        sb.append(((this.dataElement == null)?"<null>":this.dataElement));
        sb.append(',');
        sb.append("formula");
        sb.append('=');
        sb.append(((this.formula == null)?"<null>":this.formula));
        sb.append(',');
        sb.append("optionId");
        sb.append('=');
        sb.append(((this.optionId == null)?"<null>":this.optionId));
        sb.append(',');
        sb.append("trackedEntityAttribute");
        sb.append('=');
        sb.append(((this.trackedEntityAttribute == null)?"<null>":this.trackedEntityAttribute));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.compulsory == null)? 0 :this.compulsory.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.formula == null)? 0 :this.formula.hashCode()));
        result = ((result* 31)+((this.optionId == null)? 0 :this.optionId.hashCode()));
        result = ((result* 31)+((this.dataElement == null)? 0 :this.dataElement.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.trackedEntityAttribute == null)? 0 :this.trackedEntityAttribute.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof SMSCode) == false) {
            return false;
        }
        SMSCode rhs = ((SMSCode) other);
        return ((((((((this.compulsory == rhs.compulsory)||((this.compulsory!= null)&&this.compulsory.equals(rhs.compulsory)))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.formula == rhs.formula)||((this.formula!= null)&&this.formula.equals(rhs.formula))))&&((this.optionId == rhs.optionId)||((this.optionId!= null)&&this.optionId.equals(rhs.optionId))))&&((this.dataElement == rhs.dataElement)||((this.dataElement!= null)&&this.dataElement.equals(rhs.dataElement))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.trackedEntityAttribute == rhs.trackedEntityAttribute)||((this.trackedEntityAttribute!= null)&&this.trackedEntityAttribute.equals(rhs.trackedEntityAttribute))));
    }

}
