
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "batchType",
    "errorMessage",
    "failed",
    "pending",
    "responseMessage",
    "sent",
    "status",
    "total"
})
@Generated("jsonschema2pojo")
public class OutboundMessageResponseSummary implements Serializable
{

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("batchType")
    private OutboundMessageResponseSummary.BatchType batchType;
    @JsonProperty("errorMessage")
    private String errorMessage;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("failed")
    private Integer failed;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("pending")
    private Integer pending;
    @JsonProperty("responseMessage")
    private String responseMessage;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("sent")
    private Integer sent;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("status")
    private OutboundMessageResponseSummary.Status status;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("total")
    private Integer total;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 8753116954620848000L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public OutboundMessageResponseSummary() {
    }

    /**
     * 
     * @param source
     */
    public OutboundMessageResponseSummary(OutboundMessageResponseSummary source) {
        super();
        this.batchType = source.batchType;
        this.errorMessage = source.errorMessage;
        this.failed = source.failed;
        this.pending = source.pending;
        this.responseMessage = source.responseMessage;
        this.sent = source.sent;
        this.status = source.status;
        this.total = source.total;
    }

    /**
     * 
     * @param total
     * @param pending
     * @param errorMessage
     * @param failed
     * @param batchType
     * @param responseMessage
     * @param sent
     * @param status
     */
    public OutboundMessageResponseSummary(OutboundMessageResponseSummary.BatchType batchType, String errorMessage, Integer failed, Integer pending, String responseMessage, Integer sent, OutboundMessageResponseSummary.Status status, Integer total) {
        super();
        this.batchType = batchType;
        this.errorMessage = errorMessage;
        this.failed = failed;
        this.pending = pending;
        this.responseMessage = responseMessage;
        this.sent = sent;
        this.status = status;
        this.total = total;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("batchType")
    public OutboundMessageResponseSummary.BatchType getBatchType() {
        return batchType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("batchType")
    public void setBatchType(OutboundMessageResponseSummary.BatchType batchType) {
        this.batchType = batchType;
    }

    public OutboundMessageResponseSummary withBatchType(OutboundMessageResponseSummary.BatchType batchType) {
        this.batchType = batchType;
        return this;
    }

    @JsonProperty("errorMessage")
    public Optional<String> getErrorMessage() {
        return Optional.ofNullable(errorMessage);
    }

    @JsonProperty("errorMessage")
    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public OutboundMessageResponseSummary withErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("failed")
    public Integer getFailed() {
        return failed;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("failed")
    public void setFailed(Integer failed) {
        this.failed = failed;
    }

    public OutboundMessageResponseSummary withFailed(Integer failed) {
        this.failed = failed;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("pending")
    public Integer getPending() {
        return pending;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("pending")
    public void setPending(Integer pending) {
        this.pending = pending;
    }

    public OutboundMessageResponseSummary withPending(Integer pending) {
        this.pending = pending;
        return this;
    }

    @JsonProperty("responseMessage")
    public Optional<String> getResponseMessage() {
        return Optional.ofNullable(responseMessage);
    }

    @JsonProperty("responseMessage")
    public void setResponseMessage(String responseMessage) {
        this.responseMessage = responseMessage;
    }

    public OutboundMessageResponseSummary withResponseMessage(String responseMessage) {
        this.responseMessage = responseMessage;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("sent")
    public Integer getSent() {
        return sent;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("sent")
    public void setSent(Integer sent) {
        this.sent = sent;
    }

    public OutboundMessageResponseSummary withSent(Integer sent) {
        this.sent = sent;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("status")
    public OutboundMessageResponseSummary.Status getStatus() {
        return status;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("status")
    public void setStatus(OutboundMessageResponseSummary.Status status) {
        this.status = status;
    }

    public OutboundMessageResponseSummary withStatus(OutboundMessageResponseSummary.Status status) {
        this.status = status;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("total")
    public Integer getTotal() {
        return total;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("total")
    public void setTotal(Integer total) {
        this.total = total;
    }

    public OutboundMessageResponseSummary withTotal(Integer total) {
        this.total = total;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public OutboundMessageResponseSummary withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "batchType":
                if (value instanceof OutboundMessageResponseSummary.BatchType) {
                    setBatchType(((OutboundMessageResponseSummary.BatchType) value));
                } else {
                    throw new IllegalArgumentException(("property \"batchType\" is of type \"org.hisp.dhis.api.model.v40_0.OutboundMessageResponseSummary.BatchType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "errorMessage":
                if (value instanceof String) {
                    setErrorMessage(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"errorMessage\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "failed":
                if (value instanceof Integer) {
                    setFailed(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"failed\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "pending":
                if (value instanceof Integer) {
                    setPending(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"pending\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "responseMessage":
                if (value instanceof String) {
                    setResponseMessage(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"responseMessage\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "sent":
                if (value instanceof Integer) {
                    setSent(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"sent\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "status":
                if (value instanceof OutboundMessageResponseSummary.Status) {
                    setStatus(((OutboundMessageResponseSummary.Status) value));
                } else {
                    throw new IllegalArgumentException(("property \"status\" is of type \"org.hisp.dhis.api.model.v40_0.OutboundMessageResponseSummary.Status\", but got "+ value.getClass().toString()));
                }
                return true;
            case "total":
                if (value instanceof Integer) {
                    setTotal(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"total\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "batchType":
                return getBatchType();
            case "errorMessage":
                return getErrorMessage();
            case "failed":
                return getFailed();
            case "pending":
                return getPending();
            case "responseMessage":
                return getResponseMessage();
            case "sent":
                return getSent();
            case "status":
                return getStatus();
            case "total":
                return getTotal();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, OutboundMessageResponseSummary.NOT_FOUND_VALUE);
        if (OutboundMessageResponseSummary.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public OutboundMessageResponseSummary with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OutboundMessageResponseSummary.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("batchType");
        sb.append('=');
        sb.append(((this.batchType == null)?"<null>":this.batchType));
        sb.append(',');
        sb.append("errorMessage");
        sb.append('=');
        sb.append(((this.errorMessage == null)?"<null>":this.errorMessage));
        sb.append(',');
        sb.append("failed");
        sb.append('=');
        sb.append(((this.failed == null)?"<null>":this.failed));
        sb.append(',');
        sb.append("pending");
        sb.append('=');
        sb.append(((this.pending == null)?"<null>":this.pending));
        sb.append(',');
        sb.append("responseMessage");
        sb.append('=');
        sb.append(((this.responseMessage == null)?"<null>":this.responseMessage));
        sb.append(',');
        sb.append("sent");
        sb.append('=');
        sb.append(((this.sent == null)?"<null>":this.sent));
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(((this.status == null)?"<null>":this.status));
        sb.append(',');
        sb.append("total");
        sb.append('=');
        sb.append(((this.total == null)?"<null>":this.total));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.total == null)? 0 :this.total.hashCode()));
        result = ((result* 31)+((this.pending == null)? 0 :this.pending.hashCode()));
        result = ((result* 31)+((this.errorMessage == null)? 0 :this.errorMessage.hashCode()));
        result = ((result* 31)+((this.failed == null)? 0 :this.failed.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.batchType == null)? 0 :this.batchType.hashCode()));
        result = ((result* 31)+((this.responseMessage == null)? 0 :this.responseMessage.hashCode()));
        result = ((result* 31)+((this.sent == null)? 0 :this.sent.hashCode()));
        result = ((result* 31)+((this.status == null)? 0 :this.status.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OutboundMessageResponseSummary) == false) {
            return false;
        }
        OutboundMessageResponseSummary rhs = ((OutboundMessageResponseSummary) other);
        return ((((((((((this.total == rhs.total)||((this.total!= null)&&this.total.equals(rhs.total)))&&((this.pending == rhs.pending)||((this.pending!= null)&&this.pending.equals(rhs.pending))))&&((this.errorMessage == rhs.errorMessage)||((this.errorMessage!= null)&&this.errorMessage.equals(rhs.errorMessage))))&&((this.failed == rhs.failed)||((this.failed!= null)&&this.failed.equals(rhs.failed))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.batchType == rhs.batchType)||((this.batchType!= null)&&this.batchType.equals(rhs.batchType))))&&((this.responseMessage == rhs.responseMessage)||((this.responseMessage!= null)&&this.responseMessage.equals(rhs.responseMessage))))&&((this.sent == rhs.sent)||((this.sent!= null)&&this.sent.equals(rhs.sent))))&&((this.status == rhs.status)||((this.status!= null)&&this.status.equals(rhs.status))));
    }

    @Generated("jsonschema2pojo")
    public enum BatchType {

        SMS("SMS"),
        EMAIL("EMAIL"),
        HTTP("HTTP");
        private final String value;
        private final static Map<String, OutboundMessageResponseSummary.BatchType> CONSTANTS = new HashMap<String, OutboundMessageResponseSummary.BatchType>();

        static {
            for (OutboundMessageResponseSummary.BatchType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        BatchType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OutboundMessageResponseSummary.BatchType fromValue(String value) {
            OutboundMessageResponseSummary.BatchType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum Status {

        COMPLETED("COMPLETED"),
        FAILED("FAILED"),
        PENDING("PENDING"),
        ABORTED("ABORTED");
        private final String value;
        private final static Map<String, OutboundMessageResponseSummary.Status> CONSTANTS = new HashMap<String, OutboundMessageResponseSummary.Status>();

        static {
            for (OutboundMessageResponseSummary.Status c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        Status(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OutboundMessageResponseSummary.Status fromValue(String value) {
            OutboundMessageResponseSummary.Status constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
