
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "deleteSource",
    "primaryTarget",
    "source",
    "targets"
})
@Generated("jsonschema2pojo")
public class OrgUnitSplitQuery implements Serializable
{

    @JsonProperty("deleteSource")
    private Boolean deleteSource;
    @JsonProperty("primaryTarget")
    private String primaryTarget;
    @JsonProperty("source")
    private String source;
    @JsonProperty("targets")
    private List<String> targets = null;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 1004044003471420726L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public OrgUnitSplitQuery() {
    }

    /**
     * 
     * @param source
     */
    public OrgUnitSplitQuery(OrgUnitSplitQuery source) {
        super();
        this.deleteSource = source.deleteSource;
        this.primaryTarget = source.primaryTarget;
        this.source = source.source;
        this.targets = source.targets;
    }

    /**
     * 
     * @param primaryTarget
     * @param deleteSource
     * @param source
     * @param targets
     */
    public OrgUnitSplitQuery(Boolean deleteSource, String primaryTarget, String source, List<String> targets) {
        super();
        this.deleteSource = deleteSource;
        this.primaryTarget = primaryTarget;
        this.source = source;
        this.targets = targets;
    }

    @JsonProperty("deleteSource")
    public Optional<Boolean> getDeleteSource() {
        return Optional.ofNullable(deleteSource);
    }

    @JsonProperty("deleteSource")
    public void setDeleteSource(Boolean deleteSource) {
        this.deleteSource = deleteSource;
    }

    public OrgUnitSplitQuery withDeleteSource(Boolean deleteSource) {
        this.deleteSource = deleteSource;
        return this;
    }

    @JsonProperty("primaryTarget")
    public Optional<String> getPrimaryTarget() {
        return Optional.ofNullable(primaryTarget);
    }

    @JsonProperty("primaryTarget")
    public void setPrimaryTarget(String primaryTarget) {
        this.primaryTarget = primaryTarget;
    }

    public OrgUnitSplitQuery withPrimaryTarget(String primaryTarget) {
        this.primaryTarget = primaryTarget;
        return this;
    }

    @JsonProperty("source")
    public Optional<String> getSource() {
        return Optional.ofNullable(source);
    }

    @JsonProperty("source")
    public void setSource(String source) {
        this.source = source;
    }

    public OrgUnitSplitQuery withSource(String source) {
        this.source = source;
        return this;
    }

    @JsonProperty("targets")
    public Optional<List<String>> getTargets() {
        return Optional.ofNullable(targets);
    }

    @JsonProperty("targets")
    public void setTargets(List<String> targets) {
        this.targets = targets;
    }

    public OrgUnitSplitQuery withTargets(List<String> targets) {
        this.targets = targets;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public OrgUnitSplitQuery withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "deleteSource":
                if (value instanceof Boolean) {
                    setDeleteSource(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"deleteSource\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "primaryTarget":
                if (value instanceof String) {
                    setPrimaryTarget(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"primaryTarget\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "source":
                if (value instanceof String) {
                    setSource(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"source\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "targets":
                if (value instanceof List) {
                    setTargets(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"targets\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "deleteSource":
                return getDeleteSource();
            case "primaryTarget":
                return getPrimaryTarget();
            case "source":
                return getSource();
            case "targets":
                return getTargets();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, OrgUnitSplitQuery.NOT_FOUND_VALUE);
        if (OrgUnitSplitQuery.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public OrgUnitSplitQuery with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OrgUnitSplitQuery.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("deleteSource");
        sb.append('=');
        sb.append(((this.deleteSource == null)?"<null>":this.deleteSource));
        sb.append(',');
        sb.append("primaryTarget");
        sb.append('=');
        sb.append(((this.primaryTarget == null)?"<null>":this.primaryTarget));
        sb.append(',');
        sb.append("source");
        sb.append('=');
        sb.append(((this.source == null)?"<null>":this.source));
        sb.append(',');
        sb.append("targets");
        sb.append('=');
        sb.append(((this.targets == null)?"<null>":this.targets));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.primaryTarget == null)? 0 :this.primaryTarget.hashCode()));
        result = ((result* 31)+((this.deleteSource == null)? 0 :this.deleteSource.hashCode()));
        result = ((result* 31)+((this.source == null)? 0 :this.source.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.targets == null)? 0 :this.targets.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OrgUnitSplitQuery) == false) {
            return false;
        }
        OrgUnitSplitQuery rhs = ((OrgUnitSplitQuery) other);
        return ((((((this.primaryTarget == rhs.primaryTarget)||((this.primaryTarget!= null)&&this.primaryTarget.equals(rhs.primaryTarget)))&&((this.deleteSource == rhs.deleteSource)||((this.deleteSource!= null)&&this.deleteSource.equals(rhs.deleteSource))))&&((this.source == rhs.source)||((this.source!= null)&&this.source.equals(rhs.source))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.targets == rhs.targets)||((this.targets!= null)&&this.targets.equals(rhs.targets))));
    }

}
