
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "aggregationType",
    "code",
    "description",
    "dimensionItemType",
    "dimensionType",
    "endDate",
    "expression",
    "indicatorType",
    "legendSet",
    "name",
    "startDate",
    "style",
    "totalAggregationType",
    "uid",
    "valueType"
})
@Generated("jsonschema2pojo")
public class MetadataItem implements Serializable
{

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("aggregationType")
    private MetadataItem.AggregationType aggregationType;
    @JsonProperty("code")
    private String code;
    @JsonProperty("description")
    private String description;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dimensionItemType")
    private MetadataItem.DimensionItemType dimensionItemType;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dimensionType")
    private MetadataItem.DimensionType dimensionType;
    @JsonProperty("endDate")
    private Date endDate;
    @JsonProperty("expression")
    private String expression;
    /**
     * A UID reference to a IndicatorType  
     * (Java name `org.hisp.dhis.indicator.IndicatorType`)
     * 
     */
    @JsonProperty("indicatorType")
    @JsonPropertyDescription("A UID reference to a IndicatorType  \n(Java name `org.hisp.dhis.indicator.IndicatorType`)")
    private RefIndicatorType indicatorType;
    @JsonProperty("legendSet")
    private String legendSet;
    @JsonProperty("name")
    private String name;
    @JsonProperty("startDate")
    private Date startDate;
    @JsonProperty("style")
    private ObjectStyle style;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("totalAggregationType")
    private MetadataItem.TotalAggregationType totalAggregationType;
    @JsonProperty("uid")
    private String uid;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("valueType")
    private MetadataItem.ValueType valueType;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 4639834864120455194L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public MetadataItem() {
    }

    /**
     * 
     * @param source
     */
    public MetadataItem(MetadataItem source) {
        super();
        this.aggregationType = source.aggregationType;
        this.code = source.code;
        this.description = source.description;
        this.dimensionItemType = source.dimensionItemType;
        this.dimensionType = source.dimensionType;
        this.endDate = source.endDate;
        this.expression = source.expression;
        this.indicatorType = source.indicatorType;
        this.legendSet = source.legendSet;
        this.name = source.name;
        this.startDate = source.startDate;
        this.style = source.style;
        this.totalAggregationType = source.totalAggregationType;
        this.uid = source.uid;
        this.valueType = source.valueType;
    }

    /**
     * 
     * @param aggregationType
     * @param dimensionType
     * @param code
     * @param expression
     * @param endDate
     * @param description
     * @param uid
     * @param indicatorType
     * @param valueType
     * @param legendSet
     * @param name
     * @param style
     * @param startDate
     * @param dimensionItemType
     * @param totalAggregationType
     */
    public MetadataItem(MetadataItem.AggregationType aggregationType, String code, String description, MetadataItem.DimensionItemType dimensionItemType, MetadataItem.DimensionType dimensionType, Date endDate, String expression, RefIndicatorType indicatorType, String legendSet, String name, Date startDate, ObjectStyle style, MetadataItem.TotalAggregationType totalAggregationType, String uid, MetadataItem.ValueType valueType) {
        super();
        this.aggregationType = aggregationType;
        this.code = code;
        this.description = description;
        this.dimensionItemType = dimensionItemType;
        this.dimensionType = dimensionType;
        this.endDate = endDate;
        this.expression = expression;
        this.indicatorType = indicatorType;
        this.legendSet = legendSet;
        this.name = name;
        this.startDate = startDate;
        this.style = style;
        this.totalAggregationType = totalAggregationType;
        this.uid = uid;
        this.valueType = valueType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("aggregationType")
    public MetadataItem.AggregationType getAggregationType() {
        return aggregationType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("aggregationType")
    public void setAggregationType(MetadataItem.AggregationType aggregationType) {
        this.aggregationType = aggregationType;
    }

    public MetadataItem withAggregationType(MetadataItem.AggregationType aggregationType) {
        this.aggregationType = aggregationType;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public MetadataItem withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    public MetadataItem withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dimensionItemType")
    public MetadataItem.DimensionItemType getDimensionItemType() {
        return dimensionItemType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dimensionItemType")
    public void setDimensionItemType(MetadataItem.DimensionItemType dimensionItemType) {
        this.dimensionItemType = dimensionItemType;
    }

    public MetadataItem withDimensionItemType(MetadataItem.DimensionItemType dimensionItemType) {
        this.dimensionItemType = dimensionItemType;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dimensionType")
    public MetadataItem.DimensionType getDimensionType() {
        return dimensionType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dimensionType")
    public void setDimensionType(MetadataItem.DimensionType dimensionType) {
        this.dimensionType = dimensionType;
    }

    public MetadataItem withDimensionType(MetadataItem.DimensionType dimensionType) {
        this.dimensionType = dimensionType;
        return this;
    }

    @JsonProperty("endDate")
    public Optional<Date> getEndDate() {
        return Optional.ofNullable(endDate);
    }

    @JsonProperty("endDate")
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public MetadataItem withEndDate(Date endDate) {
        this.endDate = endDate;
        return this;
    }

    @JsonProperty("expression")
    public Optional<String> getExpression() {
        return Optional.ofNullable(expression);
    }

    @JsonProperty("expression")
    public void setExpression(String expression) {
        this.expression = expression;
    }

    public MetadataItem withExpression(String expression) {
        this.expression = expression;
        return this;
    }

    /**
     * A UID reference to a IndicatorType  
     * (Java name `org.hisp.dhis.indicator.IndicatorType`)
     * 
     */
    @JsonProperty("indicatorType")
    public Optional<RefIndicatorType> getIndicatorType() {
        return Optional.ofNullable(indicatorType);
    }

    /**
     * A UID reference to a IndicatorType  
     * (Java name `org.hisp.dhis.indicator.IndicatorType`)
     * 
     */
    @JsonProperty("indicatorType")
    public void setIndicatorType(RefIndicatorType indicatorType) {
        this.indicatorType = indicatorType;
    }

    public MetadataItem withIndicatorType(RefIndicatorType indicatorType) {
        this.indicatorType = indicatorType;
        return this;
    }

    @JsonProperty("legendSet")
    public Optional<String> getLegendSet() {
        return Optional.ofNullable(legendSet);
    }

    @JsonProperty("legendSet")
    public void setLegendSet(String legendSet) {
        this.legendSet = legendSet;
    }

    public MetadataItem withLegendSet(String legendSet) {
        this.legendSet = legendSet;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public MetadataItem withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("startDate")
    public Optional<Date> getStartDate() {
        return Optional.ofNullable(startDate);
    }

    @JsonProperty("startDate")
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public MetadataItem withStartDate(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    @JsonProperty("style")
    public Optional<ObjectStyle> getStyle() {
        return Optional.ofNullable(style);
    }

    @JsonProperty("style")
    public void setStyle(ObjectStyle style) {
        this.style = style;
    }

    public MetadataItem withStyle(ObjectStyle style) {
        this.style = style;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("totalAggregationType")
    public MetadataItem.TotalAggregationType getTotalAggregationType() {
        return totalAggregationType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("totalAggregationType")
    public void setTotalAggregationType(MetadataItem.TotalAggregationType totalAggregationType) {
        this.totalAggregationType = totalAggregationType;
    }

    public MetadataItem withTotalAggregationType(MetadataItem.TotalAggregationType totalAggregationType) {
        this.totalAggregationType = totalAggregationType;
        return this;
    }

    @JsonProperty("uid")
    public Optional<String> getUid() {
        return Optional.ofNullable(uid);
    }

    @JsonProperty("uid")
    public void setUid(String uid) {
        this.uid = uid;
    }

    public MetadataItem withUid(String uid) {
        this.uid = uid;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("valueType")
    public MetadataItem.ValueType getValueType() {
        return valueType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("valueType")
    public void setValueType(MetadataItem.ValueType valueType) {
        this.valueType = valueType;
    }

    public MetadataItem withValueType(MetadataItem.ValueType valueType) {
        this.valueType = valueType;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public MetadataItem withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "aggregationType":
                if (value instanceof MetadataItem.AggregationType) {
                    setAggregationType(((MetadataItem.AggregationType) value));
                } else {
                    throw new IllegalArgumentException(("property \"aggregationType\" is of type \"org.hisp.dhis.api.model.v40_0.MetadataItem.AggregationType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "code":
                if (value instanceof String) {
                    setCode(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "description":
                if (value instanceof String) {
                    setDescription(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"description\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dimensionItemType":
                if (value instanceof MetadataItem.DimensionItemType) {
                    setDimensionItemType(((MetadataItem.DimensionItemType) value));
                } else {
                    throw new IllegalArgumentException(("property \"dimensionItemType\" is of type \"org.hisp.dhis.api.model.v40_0.MetadataItem.DimensionItemType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dimensionType":
                if (value instanceof MetadataItem.DimensionType) {
                    setDimensionType(((MetadataItem.DimensionType) value));
                } else {
                    throw new IllegalArgumentException(("property \"dimensionType\" is of type \"org.hisp.dhis.api.model.v40_0.MetadataItem.DimensionType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "endDate":
                if (value instanceof Date) {
                    setEndDate(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"endDate\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "expression":
                if (value instanceof String) {
                    setExpression(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"expression\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "indicatorType":
                if (value instanceof RefIndicatorType) {
                    setIndicatorType(((RefIndicatorType) value));
                } else {
                    throw new IllegalArgumentException(("property \"indicatorType\" is of type \"org.hisp.dhis.api.model.v40_0.RefIndicatorType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "legendSet":
                if (value instanceof String) {
                    setLegendSet(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"legendSet\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "name":
                if (value instanceof String) {
                    setName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "startDate":
                if (value instanceof Date) {
                    setStartDate(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"startDate\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "style":
                if (value instanceof ObjectStyle) {
                    setStyle(((ObjectStyle) value));
                } else {
                    throw new IllegalArgumentException(("property \"style\" is of type \"org.hisp.dhis.api.model.v40_0.ObjectStyle\", but got "+ value.getClass().toString()));
                }
                return true;
            case "totalAggregationType":
                if (value instanceof MetadataItem.TotalAggregationType) {
                    setTotalAggregationType(((MetadataItem.TotalAggregationType) value));
                } else {
                    throw new IllegalArgumentException(("property \"totalAggregationType\" is of type \"org.hisp.dhis.api.model.v40_0.MetadataItem.TotalAggregationType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "uid":
                if (value instanceof String) {
                    setUid(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"uid\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "valueType":
                if (value instanceof MetadataItem.ValueType) {
                    setValueType(((MetadataItem.ValueType) value));
                } else {
                    throw new IllegalArgumentException(("property \"valueType\" is of type \"org.hisp.dhis.api.model.v40_0.MetadataItem.ValueType\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "aggregationType":
                return getAggregationType();
            case "code":
                return getCode();
            case "description":
                return getDescription();
            case "dimensionItemType":
                return getDimensionItemType();
            case "dimensionType":
                return getDimensionType();
            case "endDate":
                return getEndDate();
            case "expression":
                return getExpression();
            case "indicatorType":
                return getIndicatorType();
            case "legendSet":
                return getLegendSet();
            case "name":
                return getName();
            case "startDate":
                return getStartDate();
            case "style":
                return getStyle();
            case "totalAggregationType":
                return getTotalAggregationType();
            case "uid":
                return getUid();
            case "valueType":
                return getValueType();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, MetadataItem.NOT_FOUND_VALUE);
        if (MetadataItem.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public MetadataItem with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(MetadataItem.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("aggregationType");
        sb.append('=');
        sb.append(((this.aggregationType == null)?"<null>":this.aggregationType));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("dimensionItemType");
        sb.append('=');
        sb.append(((this.dimensionItemType == null)?"<null>":this.dimensionItemType));
        sb.append(',');
        sb.append("dimensionType");
        sb.append('=');
        sb.append(((this.dimensionType == null)?"<null>":this.dimensionType));
        sb.append(',');
        sb.append("endDate");
        sb.append('=');
        sb.append(((this.endDate == null)?"<null>":this.endDate));
        sb.append(',');
        sb.append("expression");
        sb.append('=');
        sb.append(((this.expression == null)?"<null>":this.expression));
        sb.append(',');
        sb.append("indicatorType");
        sb.append('=');
        sb.append(((this.indicatorType == null)?"<null>":this.indicatorType));
        sb.append(',');
        sb.append("legendSet");
        sb.append('=');
        sb.append(((this.legendSet == null)?"<null>":this.legendSet));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("startDate");
        sb.append('=');
        sb.append(((this.startDate == null)?"<null>":this.startDate));
        sb.append(',');
        sb.append("style");
        sb.append('=');
        sb.append(((this.style == null)?"<null>":this.style));
        sb.append(',');
        sb.append("totalAggregationType");
        sb.append('=');
        sb.append(((this.totalAggregationType == null)?"<null>":this.totalAggregationType));
        sb.append(',');
        sb.append("uid");
        sb.append('=');
        sb.append(((this.uid == null)?"<null>":this.uid));
        sb.append(',');
        sb.append("valueType");
        sb.append('=');
        sb.append(((this.valueType == null)?"<null>":this.valueType));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.aggregationType == null)? 0 :this.aggregationType.hashCode()));
        result = ((result* 31)+((this.dimensionType == null)? 0 :this.dimensionType.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.expression == null)? 0 :this.expression.hashCode()));
        result = ((result* 31)+((this.endDate == null)? 0 :this.endDate.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.uid == null)? 0 :this.uid.hashCode()));
        result = ((result* 31)+((this.indicatorType == null)? 0 :this.indicatorType.hashCode()));
        result = ((result* 31)+((this.valueType == null)? 0 :this.valueType.hashCode()));
        result = ((result* 31)+((this.legendSet == null)? 0 :this.legendSet.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.style == null)? 0 :this.style.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.startDate == null)? 0 :this.startDate.hashCode()));
        result = ((result* 31)+((this.dimensionItemType == null)? 0 :this.dimensionItemType.hashCode()));
        result = ((result* 31)+((this.totalAggregationType == null)? 0 :this.totalAggregationType.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof MetadataItem) == false) {
            return false;
        }
        MetadataItem rhs = ((MetadataItem) other);
        return (((((((((((((((((this.aggregationType == rhs.aggregationType)||((this.aggregationType!= null)&&this.aggregationType.equals(rhs.aggregationType)))&&((this.dimensionType == rhs.dimensionType)||((this.dimensionType!= null)&&this.dimensionType.equals(rhs.dimensionType))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.expression == rhs.expression)||((this.expression!= null)&&this.expression.equals(rhs.expression))))&&((this.endDate == rhs.endDate)||((this.endDate!= null)&&this.endDate.equals(rhs.endDate))))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.uid == rhs.uid)||((this.uid!= null)&&this.uid.equals(rhs.uid))))&&((this.indicatorType == rhs.indicatorType)||((this.indicatorType!= null)&&this.indicatorType.equals(rhs.indicatorType))))&&((this.valueType == rhs.valueType)||((this.valueType!= null)&&this.valueType.equals(rhs.valueType))))&&((this.legendSet == rhs.legendSet)||((this.legendSet!= null)&&this.legendSet.equals(rhs.legendSet))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.style == rhs.style)||((this.style!= null)&&this.style.equals(rhs.style))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.startDate == rhs.startDate)||((this.startDate!= null)&&this.startDate.equals(rhs.startDate))))&&((this.dimensionItemType == rhs.dimensionItemType)||((this.dimensionItemType!= null)&&this.dimensionItemType.equals(rhs.dimensionItemType))))&&((this.totalAggregationType == rhs.totalAggregationType)||((this.totalAggregationType!= null)&&this.totalAggregationType.equals(rhs.totalAggregationType))));
    }

    @Generated("jsonschema2pojo")
    public enum AggregationType {

        SUM("SUM"),
        AVERAGE("AVERAGE"),
        AVERAGE_SUM_ORG_UNIT("AVERAGE_SUM_ORG_UNIT"),
        LAST("LAST"),
        LAST_AVERAGE_ORG_UNIT("LAST_AVERAGE_ORG_UNIT"),
        LAST_LAST_ORG_UNIT("LAST_LAST_ORG_UNIT"),
        LAST_IN_PERIOD("LAST_IN_PERIOD"),
        LAST_IN_PERIOD_AVERAGE_ORG_UNIT("LAST_IN_PERIOD_AVERAGE_ORG_UNIT"),
        FIRST("FIRST"),
        FIRST_AVERAGE_ORG_UNIT("FIRST_AVERAGE_ORG_UNIT"),
        FIRST_FIRST_ORG_UNIT("FIRST_FIRST_ORG_UNIT"),
        COUNT("COUNT"),
        STDDEV("STDDEV"),
        VARIANCE("VARIANCE"),
        MIN("MIN"),
        MAX("MAX"),
        MIN_SUM_ORG_UNIT("MIN_SUM_ORG_UNIT"),
        MAX_SUM_ORG_UNIT("MAX_SUM_ORG_UNIT"),
        NONE("NONE"),
        CUSTOM("CUSTOM"),
        DEFAULT("DEFAULT");
        private final String value;
        private final static Map<String, MetadataItem.AggregationType> CONSTANTS = new HashMap<String, MetadataItem.AggregationType>();

        static {
            for (MetadataItem.AggregationType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        AggregationType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static MetadataItem.AggregationType fromValue(String value) {
            MetadataItem.AggregationType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum DimensionItemType {

        DATA_ELEMENT("DATA_ELEMENT"),
        DATA_ELEMENT_OPERAND("DATA_ELEMENT_OPERAND"),
        INDICATOR("INDICATOR"),
        REPORTING_RATE("REPORTING_RATE"),
        PROGRAM_DATA_ELEMENT("PROGRAM_DATA_ELEMENT"),
        PROGRAM_ATTRIBUTE("PROGRAM_ATTRIBUTE"),
        PROGRAM_INDICATOR("PROGRAM_INDICATOR"),
        PERIOD("PERIOD"),
        ORGANISATION_UNIT("ORGANISATION_UNIT"),
        CATEGORY_OPTION("CATEGORY_OPTION"),
        OPTION_GROUP("OPTION_GROUP"),
        DATA_ELEMENT_GROUP("DATA_ELEMENT_GROUP"),
        ORGANISATION_UNIT_GROUP("ORGANISATION_UNIT_GROUP"),
        CATEGORY_OPTION_GROUP("CATEGORY_OPTION_GROUP"),
        EXPRESSION_DIMENSION_ITEM("EXPRESSION_DIMENSION_ITEM");
        private final String value;
        private final static Map<String, MetadataItem.DimensionItemType> CONSTANTS = new HashMap<String, MetadataItem.DimensionItemType>();

        static {
            for (MetadataItem.DimensionItemType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        DimensionItemType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static MetadataItem.DimensionItemType fromValue(String value) {
            MetadataItem.DimensionItemType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum DimensionType {

        DATA_X("DATA_X"),
        PROGRAM_DATA_ELEMENT("PROGRAM_DATA_ELEMENT"),
        PROGRAM_ATTRIBUTE("PROGRAM_ATTRIBUTE"),
        PROGRAM_INDICATOR("PROGRAM_INDICATOR"),
        DATA_COLLAPSED("DATA_COLLAPSED"),
        CATEGORY_OPTION_COMBO("CATEGORY_OPTION_COMBO"),
        ATTRIBUTE_OPTION_COMBO("ATTRIBUTE_OPTION_COMBO"),
        PERIOD("PERIOD"),
        ORGANISATION_UNIT("ORGANISATION_UNIT"),
        CATEGORY_OPTION_GROUP_SET("CATEGORY_OPTION_GROUP_SET"),
        DATA_ELEMENT_GROUP_SET("DATA_ELEMENT_GROUP_SET"),
        ORGANISATION_UNIT_GROUP_SET("ORGANISATION_UNIT_GROUP_SET"),
        ORGANISATION_UNIT_GROUP("ORGANISATION_UNIT_GROUP"),
        CATEGORY("CATEGORY"),
        OPTION_GROUP_SET("OPTION_GROUP_SET"),
        VALIDATION_RULE("VALIDATION_RULE"),
        STATIC("STATIC"),
        ORGANISATION_UNIT_LEVEL("ORGANISATION_UNIT_LEVEL");
        private final String value;
        private final static Map<String, MetadataItem.DimensionType> CONSTANTS = new HashMap<String, MetadataItem.DimensionType>();

        static {
            for (MetadataItem.DimensionType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        DimensionType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static MetadataItem.DimensionType fromValue(String value) {
            MetadataItem.DimensionType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum TotalAggregationType {

        SUM("SUM"),
        AVERAGE("AVERAGE");
        private final String value;
        private final static Map<String, MetadataItem.TotalAggregationType> CONSTANTS = new HashMap<String, MetadataItem.TotalAggregationType>();

        static {
            for (MetadataItem.TotalAggregationType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        TotalAggregationType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static MetadataItem.TotalAggregationType fromValue(String value) {
            MetadataItem.TotalAggregationType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum ValueType {

        TEXT("TEXT"),
        LONG_TEXT("LONG_TEXT"),
        MULTI_TEXT("MULTI_TEXT"),
        LETTER("LETTER"),
        PHONE_NUMBER("PHONE_NUMBER"),
        EMAIL("EMAIL"),
        BOOLEAN("BOOLEAN"),
        TRUE_ONLY("TRUE_ONLY"),
        DATE("DATE"),
        DATETIME("DATETIME"),
        TIME("TIME"),
        NUMBER("NUMBER"),
        UNIT_INTERVAL("UNIT_INTERVAL"),
        PERCENTAGE("PERCENTAGE"),
        INTEGER("INTEGER"),
        INTEGER_POSITIVE("INTEGER_POSITIVE"),
        INTEGER_NEGATIVE("INTEGER_NEGATIVE"),
        INTEGER_ZERO_OR_POSITIVE("INTEGER_ZERO_OR_POSITIVE"),
        TRACKER_ASSOCIATE("TRACKER_ASSOCIATE"),
        USERNAME("USERNAME"),
        COORDINATE("COORDINATE"),
        ORGANISATION_UNIT("ORGANISATION_UNIT"),
        REFERENCE("REFERENCE"),
        AGE("AGE"),
        URL("URL"),
        FILE_RESOURCE("FILE_RESOURCE"),
        IMAGE("IMAGE"),
        GEOJSON("GEOJSON");
        private final String value;
        private final static Map<String, MetadataItem.ValueType> CONSTANTS = new HashMap<String, MetadataItem.ValueType>();

        static {
            for (MetadataItem.ValueType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ValueType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static MetadataItem.ValueType fromValue(String value) {
            MetadataItem.ValueType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
