
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "columns",
    "spacing"
})
@Generated("jsonschema2pojo")
public class Layout implements Serializable
{

    @JsonProperty("columns")
    private List<Column> columns = null;
    @JsonProperty("spacing")
    private Spacing spacing;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 1078193794032174470L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Layout() {
    }

    /**
     * 
     * @param source
     */
    public Layout(Layout source) {
        super();
        this.columns = source.columns;
        this.spacing = source.spacing;
    }

    /**
     * 
     * @param spacing
     * @param columns
     */
    public Layout(List<Column> columns, Spacing spacing) {
        super();
        this.columns = columns;
        this.spacing = spacing;
    }

    @JsonProperty("columns")
    public Optional<List<Column>> getColumns() {
        return Optional.ofNullable(columns);
    }

    @JsonProperty("columns")
    public void setColumns(List<Column> columns) {
        this.columns = columns;
    }

    public Layout withColumns(List<Column> columns) {
        this.columns = columns;
        return this;
    }

    @JsonProperty("spacing")
    public Optional<Spacing> getSpacing() {
        return Optional.ofNullable(spacing);
    }

    @JsonProperty("spacing")
    public void setSpacing(Spacing spacing) {
        this.spacing = spacing;
    }

    public Layout withSpacing(Spacing spacing) {
        this.spacing = spacing;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Layout withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "columns":
                if (value instanceof List) {
                    setColumns(((List<Column> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"columns\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.Column>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "spacing":
                if (value instanceof Spacing) {
                    setSpacing(((Spacing) value));
                } else {
                    throw new IllegalArgumentException(("property \"spacing\" is of type \"org.hisp.dhis.api.model.v40_0.Spacing\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "columns":
                return getColumns();
            case "spacing":
                return getSpacing();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, Layout.NOT_FOUND_VALUE);
        if (Layout.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public Layout with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Layout.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("columns");
        sb.append('=');
        sb.append(((this.columns == null)?"<null>":this.columns));
        sb.append(',');
        sb.append("spacing");
        sb.append('=');
        sb.append(((this.spacing == null)?"<null>":this.spacing));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.spacing == null)? 0 :this.spacing.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.columns == null)? 0 :this.columns.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Layout) == false) {
            return false;
        }
        Layout rhs = ((Layout) other);
        return ((((this.spacing == rhs.spacing)||((this.spacing!= null)&&this.spacing.equals(rhs.spacing)))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.columns == rhs.columns)||((this.columns!= null)&&this.columns.equals(rhs.columns))));
    }

}
