
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "address",
    "brokerUrl",
    "clientId",
    "groupId",
    "password",
    "type",
    "useQueue",
    "username"
})
@Generated("jsonschema2pojo")
public class JmsTarget implements Serializable
{

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("address")
    private String address;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("brokerUrl")
    private String brokerUrl;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("clientId")
    private String clientId;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("groupId")
    private String groupId;
    @JsonProperty("password")
    private String password;
    @JsonProperty("type")
    private String type;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("useQueue")
    private Boolean useQueue;
    @JsonProperty("username")
    private String username;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -3462050866105971637L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public JmsTarget() {
    }

    /**
     * 
     * @param source
     */
    public JmsTarget(JmsTarget source) {
        super();
        this.address = source.address;
        this.brokerUrl = source.brokerUrl;
        this.clientId = source.clientId;
        this.groupId = source.groupId;
        this.password = source.password;
        this.type = source.type;
        this.useQueue = source.useQueue;
        this.username = source.username;
    }

    /**
     * 
     * @param brokerUrl
     * @param useQueue
     * @param password
     * @param address
     * @param clientId
     * @param groupId
     * @param type
     * @param username
     */
    public JmsTarget(String address, String brokerUrl, String clientId, String groupId, String password, String type, Boolean useQueue, String username) {
        super();
        this.address = address;
        this.brokerUrl = brokerUrl;
        this.clientId = clientId;
        this.groupId = groupId;
        this.password = password;
        this.type = type;
        this.useQueue = useQueue;
        this.username = username;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("address")
    public String getAddress() {
        return address;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("address")
    public void setAddress(String address) {
        this.address = address;
    }

    public JmsTarget withAddress(String address) {
        this.address = address;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("brokerUrl")
    public String getBrokerUrl() {
        return brokerUrl;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("brokerUrl")
    public void setBrokerUrl(String brokerUrl) {
        this.brokerUrl = brokerUrl;
    }

    public JmsTarget withBrokerUrl(String brokerUrl) {
        this.brokerUrl = brokerUrl;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("clientId")
    public String getClientId() {
        return clientId;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("clientId")
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public JmsTarget withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("groupId")
    public String getGroupId() {
        return groupId;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("groupId")
    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public JmsTarget withGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    @JsonProperty("password")
    public Optional<String> getPassword() {
        return Optional.ofNullable(password);
    }

    @JsonProperty("password")
    public void setPassword(String password) {
        this.password = password;
    }

    public JmsTarget withPassword(String password) {
        this.password = password;
        return this;
    }

    @JsonProperty("type")
    public Optional<String> getType() {
        return Optional.ofNullable(type);
    }

    @JsonProperty("type")
    public void setType(String type) {
        this.type = type;
    }

    public JmsTarget withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("useQueue")
    public Boolean getUseQueue() {
        return useQueue;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("useQueue")
    public void setUseQueue(Boolean useQueue) {
        this.useQueue = useQueue;
    }

    public JmsTarget withUseQueue(Boolean useQueue) {
        this.useQueue = useQueue;
        return this;
    }

    @JsonProperty("username")
    public Optional<String> getUsername() {
        return Optional.ofNullable(username);
    }

    @JsonProperty("username")
    public void setUsername(String username) {
        this.username = username;
    }

    public JmsTarget withUsername(String username) {
        this.username = username;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public JmsTarget withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "address":
                if (value instanceof String) {
                    setAddress(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"address\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "brokerUrl":
                if (value instanceof String) {
                    setBrokerUrl(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"brokerUrl\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "clientId":
                if (value instanceof String) {
                    setClientId(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"clientId\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "groupId":
                if (value instanceof String) {
                    setGroupId(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"groupId\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "password":
                if (value instanceof String) {
                    setPassword(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"password\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "type":
                if (value instanceof String) {
                    setType(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"type\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "useQueue":
                if (value instanceof Boolean) {
                    setUseQueue(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"useQueue\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "username":
                if (value instanceof String) {
                    setUsername(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"username\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "address":
                return getAddress();
            case "brokerUrl":
                return getBrokerUrl();
            case "clientId":
                return getClientId();
            case "groupId":
                return getGroupId();
            case "password":
                return getPassword();
            case "type":
                return getType();
            case "useQueue":
                return getUseQueue();
            case "username":
                return getUsername();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, JmsTarget.NOT_FOUND_VALUE);
        if (JmsTarget.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public JmsTarget with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(JmsTarget.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("address");
        sb.append('=');
        sb.append(((this.address == null)?"<null>":this.address));
        sb.append(',');
        sb.append("brokerUrl");
        sb.append('=');
        sb.append(((this.brokerUrl == null)?"<null>":this.brokerUrl));
        sb.append(',');
        sb.append("clientId");
        sb.append('=');
        sb.append(((this.clientId == null)?"<null>":this.clientId));
        sb.append(',');
        sb.append("groupId");
        sb.append('=');
        sb.append(((this.groupId == null)?"<null>":this.groupId));
        sb.append(',');
        sb.append("password");
        sb.append('=');
        sb.append(((this.password == null)?"<null>":this.password));
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(((this.type == null)?"<null>":this.type));
        sb.append(',');
        sb.append("useQueue");
        sb.append('=');
        sb.append(((this.useQueue == null)?"<null>":this.useQueue));
        sb.append(',');
        sb.append("username");
        sb.append('=');
        sb.append(((this.username == null)?"<null>":this.username));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.brokerUrl == null)? 0 :this.brokerUrl.hashCode()));
        result = ((result* 31)+((this.useQueue == null)? 0 :this.useQueue.hashCode()));
        result = ((result* 31)+((this.password == null)? 0 :this.password.hashCode()));
        result = ((result* 31)+((this.address == null)? 0 :this.address.hashCode()));
        result = ((result* 31)+((this.clientId == null)? 0 :this.clientId.hashCode()));
        result = ((result* 31)+((this.groupId == null)? 0 :this.groupId.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.type == null)? 0 :this.type.hashCode()));
        result = ((result* 31)+((this.username == null)? 0 :this.username.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof JmsTarget) == false) {
            return false;
        }
        JmsTarget rhs = ((JmsTarget) other);
        return ((((((((((this.brokerUrl == rhs.brokerUrl)||((this.brokerUrl!= null)&&this.brokerUrl.equals(rhs.brokerUrl)))&&((this.useQueue == rhs.useQueue)||((this.useQueue!= null)&&this.useQueue.equals(rhs.useQueue))))&&((this.password == rhs.password)||((this.password!= null)&&this.password.equals(rhs.password))))&&((this.address == rhs.address)||((this.address!= null)&&this.address.equals(rhs.address))))&&((this.clientId == rhs.clientId)||((this.clientId!= null)&&this.clientId.equals(rhs.clientId))))&&((this.groupId == rhs.groupId)||((this.groupId!= null)&&this.groupId.equals(rhs.groupId))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.type == rhs.type)||((this.type!= null)&&this.type.equals(rhs.type))))&&((this.username == rhs.username)||((this.username!= null)&&this.username.equals(rhs.username))));
    }

}
