
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "attributeOptionComboIdScheme",
    "categoryIdScheme",
    "categoryOptionComboIdScheme",
    "categoryOptionIdScheme",
    "dataElementGroupIdScheme",
    "dataElementIdScheme",
    "dataSetIdScheme",
    "idScheme",
    "orgUnitGroupIdScheme",
    "orgUnitIdScheme",
    "programIdScheme",
    "programStageIdScheme",
    "programStageInstanceIdScheme",
    "trackedEntityAttributeIdScheme",
    "trackedEntityIdScheme"
})
@Generated("jsonschema2pojo")
public class IdSchemes implements Serializable
{

    @JsonProperty("attributeOptionComboIdScheme")
    private IdScheme attributeOptionComboIdScheme;
    @JsonProperty("categoryIdScheme")
    private IdScheme categoryIdScheme;
    @JsonProperty("categoryOptionComboIdScheme")
    private IdScheme categoryOptionComboIdScheme;
    @JsonProperty("categoryOptionIdScheme")
    private IdScheme categoryOptionIdScheme;
    @JsonProperty("dataElementGroupIdScheme")
    private IdScheme dataElementGroupIdScheme;
    @JsonProperty("dataElementIdScheme")
    private IdScheme dataElementIdScheme;
    @JsonProperty("dataSetIdScheme")
    private IdScheme dataSetIdScheme;
    @JsonProperty("idScheme")
    private IdScheme idScheme;
    @JsonProperty("orgUnitGroupIdScheme")
    private IdScheme orgUnitGroupIdScheme;
    @JsonProperty("orgUnitIdScheme")
    private IdScheme orgUnitIdScheme;
    @JsonProperty("programIdScheme")
    private IdScheme programIdScheme;
    @JsonProperty("programStageIdScheme")
    private IdScheme programStageIdScheme;
    @JsonProperty("programStageInstanceIdScheme")
    private IdScheme programStageInstanceIdScheme;
    @JsonProperty("trackedEntityAttributeIdScheme")
    private IdScheme trackedEntityAttributeIdScheme;
    @JsonProperty("trackedEntityIdScheme")
    private IdScheme trackedEntityIdScheme;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 2992472091379201242L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public IdSchemes() {
    }

    /**
     * 
     * @param source
     */
    public IdSchemes(IdSchemes source) {
        super();
        this.attributeOptionComboIdScheme = source.attributeOptionComboIdScheme;
        this.categoryIdScheme = source.categoryIdScheme;
        this.categoryOptionComboIdScheme = source.categoryOptionComboIdScheme;
        this.categoryOptionIdScheme = source.categoryOptionIdScheme;
        this.dataElementGroupIdScheme = source.dataElementGroupIdScheme;
        this.dataElementIdScheme = source.dataElementIdScheme;
        this.dataSetIdScheme = source.dataSetIdScheme;
        this.idScheme = source.idScheme;
        this.orgUnitGroupIdScheme = source.orgUnitGroupIdScheme;
        this.orgUnitIdScheme = source.orgUnitIdScheme;
        this.programIdScheme = source.programIdScheme;
        this.programStageIdScheme = source.programStageIdScheme;
        this.programStageInstanceIdScheme = source.programStageInstanceIdScheme;
        this.trackedEntityAttributeIdScheme = source.trackedEntityAttributeIdScheme;
        this.trackedEntityIdScheme = source.trackedEntityIdScheme;
    }

    /**
     * 
     * @param dataElementIdScheme
     * @param orgUnitGroupIdScheme
     * @param attributeOptionComboIdScheme
     * @param programIdScheme
     * @param dataSetIdScheme
     * @param orgUnitIdScheme
     * @param trackedEntityAttributeIdScheme
     * @param categoryIdScheme
     * @param trackedEntityIdScheme
     * @param categoryOptionIdScheme
     * @param idScheme
     * @param programStageInstanceIdScheme
     * @param categoryOptionComboIdScheme
     * @param programStageIdScheme
     * @param dataElementGroupIdScheme
     */
    public IdSchemes(IdScheme attributeOptionComboIdScheme, IdScheme categoryIdScheme, IdScheme categoryOptionComboIdScheme, IdScheme categoryOptionIdScheme, IdScheme dataElementGroupIdScheme, IdScheme dataElementIdScheme, IdScheme dataSetIdScheme, IdScheme idScheme, IdScheme orgUnitGroupIdScheme, IdScheme orgUnitIdScheme, IdScheme programIdScheme, IdScheme programStageIdScheme, IdScheme programStageInstanceIdScheme, IdScheme trackedEntityAttributeIdScheme, IdScheme trackedEntityIdScheme) {
        super();
        this.attributeOptionComboIdScheme = attributeOptionComboIdScheme;
        this.categoryIdScheme = categoryIdScheme;
        this.categoryOptionComboIdScheme = categoryOptionComboIdScheme;
        this.categoryOptionIdScheme = categoryOptionIdScheme;
        this.dataElementGroupIdScheme = dataElementGroupIdScheme;
        this.dataElementIdScheme = dataElementIdScheme;
        this.dataSetIdScheme = dataSetIdScheme;
        this.idScheme = idScheme;
        this.orgUnitGroupIdScheme = orgUnitGroupIdScheme;
        this.orgUnitIdScheme = orgUnitIdScheme;
        this.programIdScheme = programIdScheme;
        this.programStageIdScheme = programStageIdScheme;
        this.programStageInstanceIdScheme = programStageInstanceIdScheme;
        this.trackedEntityAttributeIdScheme = trackedEntityAttributeIdScheme;
        this.trackedEntityIdScheme = trackedEntityIdScheme;
    }

    @JsonProperty("attributeOptionComboIdScheme")
    public Optional<IdScheme> getAttributeOptionComboIdScheme() {
        return Optional.ofNullable(attributeOptionComboIdScheme);
    }

    @JsonProperty("attributeOptionComboIdScheme")
    public void setAttributeOptionComboIdScheme(IdScheme attributeOptionComboIdScheme) {
        this.attributeOptionComboIdScheme = attributeOptionComboIdScheme;
    }

    public IdSchemes withAttributeOptionComboIdScheme(IdScheme attributeOptionComboIdScheme) {
        this.attributeOptionComboIdScheme = attributeOptionComboIdScheme;
        return this;
    }

    @JsonProperty("categoryIdScheme")
    public Optional<IdScheme> getCategoryIdScheme() {
        return Optional.ofNullable(categoryIdScheme);
    }

    @JsonProperty("categoryIdScheme")
    public void setCategoryIdScheme(IdScheme categoryIdScheme) {
        this.categoryIdScheme = categoryIdScheme;
    }

    public IdSchemes withCategoryIdScheme(IdScheme categoryIdScheme) {
        this.categoryIdScheme = categoryIdScheme;
        return this;
    }

    @JsonProperty("categoryOptionComboIdScheme")
    public Optional<IdScheme> getCategoryOptionComboIdScheme() {
        return Optional.ofNullable(categoryOptionComboIdScheme);
    }

    @JsonProperty("categoryOptionComboIdScheme")
    public void setCategoryOptionComboIdScheme(IdScheme categoryOptionComboIdScheme) {
        this.categoryOptionComboIdScheme = categoryOptionComboIdScheme;
    }

    public IdSchemes withCategoryOptionComboIdScheme(IdScheme categoryOptionComboIdScheme) {
        this.categoryOptionComboIdScheme = categoryOptionComboIdScheme;
        return this;
    }

    @JsonProperty("categoryOptionIdScheme")
    public Optional<IdScheme> getCategoryOptionIdScheme() {
        return Optional.ofNullable(categoryOptionIdScheme);
    }

    @JsonProperty("categoryOptionIdScheme")
    public void setCategoryOptionIdScheme(IdScheme categoryOptionIdScheme) {
        this.categoryOptionIdScheme = categoryOptionIdScheme;
    }

    public IdSchemes withCategoryOptionIdScheme(IdScheme categoryOptionIdScheme) {
        this.categoryOptionIdScheme = categoryOptionIdScheme;
        return this;
    }

    @JsonProperty("dataElementGroupIdScheme")
    public Optional<IdScheme> getDataElementGroupIdScheme() {
        return Optional.ofNullable(dataElementGroupIdScheme);
    }

    @JsonProperty("dataElementGroupIdScheme")
    public void setDataElementGroupIdScheme(IdScheme dataElementGroupIdScheme) {
        this.dataElementGroupIdScheme = dataElementGroupIdScheme;
    }

    public IdSchemes withDataElementGroupIdScheme(IdScheme dataElementGroupIdScheme) {
        this.dataElementGroupIdScheme = dataElementGroupIdScheme;
        return this;
    }

    @JsonProperty("dataElementIdScheme")
    public Optional<IdScheme> getDataElementIdScheme() {
        return Optional.ofNullable(dataElementIdScheme);
    }

    @JsonProperty("dataElementIdScheme")
    public void setDataElementIdScheme(IdScheme dataElementIdScheme) {
        this.dataElementIdScheme = dataElementIdScheme;
    }

    public IdSchemes withDataElementIdScheme(IdScheme dataElementIdScheme) {
        this.dataElementIdScheme = dataElementIdScheme;
        return this;
    }

    @JsonProperty("dataSetIdScheme")
    public Optional<IdScheme> getDataSetIdScheme() {
        return Optional.ofNullable(dataSetIdScheme);
    }

    @JsonProperty("dataSetIdScheme")
    public void setDataSetIdScheme(IdScheme dataSetIdScheme) {
        this.dataSetIdScheme = dataSetIdScheme;
    }

    public IdSchemes withDataSetIdScheme(IdScheme dataSetIdScheme) {
        this.dataSetIdScheme = dataSetIdScheme;
        return this;
    }

    @JsonProperty("idScheme")
    public Optional<IdScheme> getIdScheme() {
        return Optional.ofNullable(idScheme);
    }

    @JsonProperty("idScheme")
    public void setIdScheme(IdScheme idScheme) {
        this.idScheme = idScheme;
    }

    public IdSchemes withIdScheme(IdScheme idScheme) {
        this.idScheme = idScheme;
        return this;
    }

    @JsonProperty("orgUnitGroupIdScheme")
    public Optional<IdScheme> getOrgUnitGroupIdScheme() {
        return Optional.ofNullable(orgUnitGroupIdScheme);
    }

    @JsonProperty("orgUnitGroupIdScheme")
    public void setOrgUnitGroupIdScheme(IdScheme orgUnitGroupIdScheme) {
        this.orgUnitGroupIdScheme = orgUnitGroupIdScheme;
    }

    public IdSchemes withOrgUnitGroupIdScheme(IdScheme orgUnitGroupIdScheme) {
        this.orgUnitGroupIdScheme = orgUnitGroupIdScheme;
        return this;
    }

    @JsonProperty("orgUnitIdScheme")
    public Optional<IdScheme> getOrgUnitIdScheme() {
        return Optional.ofNullable(orgUnitIdScheme);
    }

    @JsonProperty("orgUnitIdScheme")
    public void setOrgUnitIdScheme(IdScheme orgUnitIdScheme) {
        this.orgUnitIdScheme = orgUnitIdScheme;
    }

    public IdSchemes withOrgUnitIdScheme(IdScheme orgUnitIdScheme) {
        this.orgUnitIdScheme = orgUnitIdScheme;
        return this;
    }

    @JsonProperty("programIdScheme")
    public Optional<IdScheme> getProgramIdScheme() {
        return Optional.ofNullable(programIdScheme);
    }

    @JsonProperty("programIdScheme")
    public void setProgramIdScheme(IdScheme programIdScheme) {
        this.programIdScheme = programIdScheme;
    }

    public IdSchemes withProgramIdScheme(IdScheme programIdScheme) {
        this.programIdScheme = programIdScheme;
        return this;
    }

    @JsonProperty("programStageIdScheme")
    public Optional<IdScheme> getProgramStageIdScheme() {
        return Optional.ofNullable(programStageIdScheme);
    }

    @JsonProperty("programStageIdScheme")
    public void setProgramStageIdScheme(IdScheme programStageIdScheme) {
        this.programStageIdScheme = programStageIdScheme;
    }

    public IdSchemes withProgramStageIdScheme(IdScheme programStageIdScheme) {
        this.programStageIdScheme = programStageIdScheme;
        return this;
    }

    @JsonProperty("programStageInstanceIdScheme")
    public Optional<IdScheme> getProgramStageInstanceIdScheme() {
        return Optional.ofNullable(programStageInstanceIdScheme);
    }

    @JsonProperty("programStageInstanceIdScheme")
    public void setProgramStageInstanceIdScheme(IdScheme programStageInstanceIdScheme) {
        this.programStageInstanceIdScheme = programStageInstanceIdScheme;
    }

    public IdSchemes withProgramStageInstanceIdScheme(IdScheme programStageInstanceIdScheme) {
        this.programStageInstanceIdScheme = programStageInstanceIdScheme;
        return this;
    }

    @JsonProperty("trackedEntityAttributeIdScheme")
    public Optional<IdScheme> getTrackedEntityAttributeIdScheme() {
        return Optional.ofNullable(trackedEntityAttributeIdScheme);
    }

    @JsonProperty("trackedEntityAttributeIdScheme")
    public void setTrackedEntityAttributeIdScheme(IdScheme trackedEntityAttributeIdScheme) {
        this.trackedEntityAttributeIdScheme = trackedEntityAttributeIdScheme;
    }

    public IdSchemes withTrackedEntityAttributeIdScheme(IdScheme trackedEntityAttributeIdScheme) {
        this.trackedEntityAttributeIdScheme = trackedEntityAttributeIdScheme;
        return this;
    }

    @JsonProperty("trackedEntityIdScheme")
    public Optional<IdScheme> getTrackedEntityIdScheme() {
        return Optional.ofNullable(trackedEntityIdScheme);
    }

    @JsonProperty("trackedEntityIdScheme")
    public void setTrackedEntityIdScheme(IdScheme trackedEntityIdScheme) {
        this.trackedEntityIdScheme = trackedEntityIdScheme;
    }

    public IdSchemes withTrackedEntityIdScheme(IdScheme trackedEntityIdScheme) {
        this.trackedEntityIdScheme = trackedEntityIdScheme;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public IdSchemes withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "attributeOptionComboIdScheme":
                if (value instanceof IdScheme) {
                    setAttributeOptionComboIdScheme(((IdScheme) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeOptionComboIdScheme\" is of type \"org.hisp.dhis.api.model.v40_0.IdScheme\", but got "+ value.getClass().toString()));
                }
                return true;
            case "categoryIdScheme":
                if (value instanceof IdScheme) {
                    setCategoryIdScheme(((IdScheme) value));
                } else {
                    throw new IllegalArgumentException(("property \"categoryIdScheme\" is of type \"org.hisp.dhis.api.model.v40_0.IdScheme\", but got "+ value.getClass().toString()));
                }
                return true;
            case "categoryOptionComboIdScheme":
                if (value instanceof IdScheme) {
                    setCategoryOptionComboIdScheme(((IdScheme) value));
                } else {
                    throw new IllegalArgumentException(("property \"categoryOptionComboIdScheme\" is of type \"org.hisp.dhis.api.model.v40_0.IdScheme\", but got "+ value.getClass().toString()));
                }
                return true;
            case "categoryOptionIdScheme":
                if (value instanceof IdScheme) {
                    setCategoryOptionIdScheme(((IdScheme) value));
                } else {
                    throw new IllegalArgumentException(("property \"categoryOptionIdScheme\" is of type \"org.hisp.dhis.api.model.v40_0.IdScheme\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataElementGroupIdScheme":
                if (value instanceof IdScheme) {
                    setDataElementGroupIdScheme(((IdScheme) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataElementGroupIdScheme\" is of type \"org.hisp.dhis.api.model.v40_0.IdScheme\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataElementIdScheme":
                if (value instanceof IdScheme) {
                    setDataElementIdScheme(((IdScheme) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataElementIdScheme\" is of type \"org.hisp.dhis.api.model.v40_0.IdScheme\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataSetIdScheme":
                if (value instanceof IdScheme) {
                    setDataSetIdScheme(((IdScheme) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataSetIdScheme\" is of type \"org.hisp.dhis.api.model.v40_0.IdScheme\", but got "+ value.getClass().toString()));
                }
                return true;
            case "idScheme":
                if (value instanceof IdScheme) {
                    setIdScheme(((IdScheme) value));
                } else {
                    throw new IllegalArgumentException(("property \"idScheme\" is of type \"org.hisp.dhis.api.model.v40_0.IdScheme\", but got "+ value.getClass().toString()));
                }
                return true;
            case "orgUnitGroupIdScheme":
                if (value instanceof IdScheme) {
                    setOrgUnitGroupIdScheme(((IdScheme) value));
                } else {
                    throw new IllegalArgumentException(("property \"orgUnitGroupIdScheme\" is of type \"org.hisp.dhis.api.model.v40_0.IdScheme\", but got "+ value.getClass().toString()));
                }
                return true;
            case "orgUnitIdScheme":
                if (value instanceof IdScheme) {
                    setOrgUnitIdScheme(((IdScheme) value));
                } else {
                    throw new IllegalArgumentException(("property \"orgUnitIdScheme\" is of type \"org.hisp.dhis.api.model.v40_0.IdScheme\", but got "+ value.getClass().toString()));
                }
                return true;
            case "programIdScheme":
                if (value instanceof IdScheme) {
                    setProgramIdScheme(((IdScheme) value));
                } else {
                    throw new IllegalArgumentException(("property \"programIdScheme\" is of type \"org.hisp.dhis.api.model.v40_0.IdScheme\", but got "+ value.getClass().toString()));
                }
                return true;
            case "programStageIdScheme":
                if (value instanceof IdScheme) {
                    setProgramStageIdScheme(((IdScheme) value));
                } else {
                    throw new IllegalArgumentException(("property \"programStageIdScheme\" is of type \"org.hisp.dhis.api.model.v40_0.IdScheme\", but got "+ value.getClass().toString()));
                }
                return true;
            case "programStageInstanceIdScheme":
                if (value instanceof IdScheme) {
                    setProgramStageInstanceIdScheme(((IdScheme) value));
                } else {
                    throw new IllegalArgumentException(("property \"programStageInstanceIdScheme\" is of type \"org.hisp.dhis.api.model.v40_0.IdScheme\", but got "+ value.getClass().toString()));
                }
                return true;
            case "trackedEntityAttributeIdScheme":
                if (value instanceof IdScheme) {
                    setTrackedEntityAttributeIdScheme(((IdScheme) value));
                } else {
                    throw new IllegalArgumentException(("property \"trackedEntityAttributeIdScheme\" is of type \"org.hisp.dhis.api.model.v40_0.IdScheme\", but got "+ value.getClass().toString()));
                }
                return true;
            case "trackedEntityIdScheme":
                if (value instanceof IdScheme) {
                    setTrackedEntityIdScheme(((IdScheme) value));
                } else {
                    throw new IllegalArgumentException(("property \"trackedEntityIdScheme\" is of type \"org.hisp.dhis.api.model.v40_0.IdScheme\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "attributeOptionComboIdScheme":
                return getAttributeOptionComboIdScheme();
            case "categoryIdScheme":
                return getCategoryIdScheme();
            case "categoryOptionComboIdScheme":
                return getCategoryOptionComboIdScheme();
            case "categoryOptionIdScheme":
                return getCategoryOptionIdScheme();
            case "dataElementGroupIdScheme":
                return getDataElementGroupIdScheme();
            case "dataElementIdScheme":
                return getDataElementIdScheme();
            case "dataSetIdScheme":
                return getDataSetIdScheme();
            case "idScheme":
                return getIdScheme();
            case "orgUnitGroupIdScheme":
                return getOrgUnitGroupIdScheme();
            case "orgUnitIdScheme":
                return getOrgUnitIdScheme();
            case "programIdScheme":
                return getProgramIdScheme();
            case "programStageIdScheme":
                return getProgramStageIdScheme();
            case "programStageInstanceIdScheme":
                return getProgramStageInstanceIdScheme();
            case "trackedEntityAttributeIdScheme":
                return getTrackedEntityAttributeIdScheme();
            case "trackedEntityIdScheme":
                return getTrackedEntityIdScheme();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, IdSchemes.NOT_FOUND_VALUE);
        if (IdSchemes.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public IdSchemes with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(IdSchemes.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("attributeOptionComboIdScheme");
        sb.append('=');
        sb.append(((this.attributeOptionComboIdScheme == null)?"<null>":this.attributeOptionComboIdScheme));
        sb.append(',');
        sb.append("categoryIdScheme");
        sb.append('=');
        sb.append(((this.categoryIdScheme == null)?"<null>":this.categoryIdScheme));
        sb.append(',');
        sb.append("categoryOptionComboIdScheme");
        sb.append('=');
        sb.append(((this.categoryOptionComboIdScheme == null)?"<null>":this.categoryOptionComboIdScheme));
        sb.append(',');
        sb.append("categoryOptionIdScheme");
        sb.append('=');
        sb.append(((this.categoryOptionIdScheme == null)?"<null>":this.categoryOptionIdScheme));
        sb.append(',');
        sb.append("dataElementGroupIdScheme");
        sb.append('=');
        sb.append(((this.dataElementGroupIdScheme == null)?"<null>":this.dataElementGroupIdScheme));
        sb.append(',');
        sb.append("dataElementIdScheme");
        sb.append('=');
        sb.append(((this.dataElementIdScheme == null)?"<null>":this.dataElementIdScheme));
        sb.append(',');
        sb.append("dataSetIdScheme");
        sb.append('=');
        sb.append(((this.dataSetIdScheme == null)?"<null>":this.dataSetIdScheme));
        sb.append(',');
        sb.append("idScheme");
        sb.append('=');
        sb.append(((this.idScheme == null)?"<null>":this.idScheme));
        sb.append(',');
        sb.append("orgUnitGroupIdScheme");
        sb.append('=');
        sb.append(((this.orgUnitGroupIdScheme == null)?"<null>":this.orgUnitGroupIdScheme));
        sb.append(',');
        sb.append("orgUnitIdScheme");
        sb.append('=');
        sb.append(((this.orgUnitIdScheme == null)?"<null>":this.orgUnitIdScheme));
        sb.append(',');
        sb.append("programIdScheme");
        sb.append('=');
        sb.append(((this.programIdScheme == null)?"<null>":this.programIdScheme));
        sb.append(',');
        sb.append("programStageIdScheme");
        sb.append('=');
        sb.append(((this.programStageIdScheme == null)?"<null>":this.programStageIdScheme));
        sb.append(',');
        sb.append("programStageInstanceIdScheme");
        sb.append('=');
        sb.append(((this.programStageInstanceIdScheme == null)?"<null>":this.programStageInstanceIdScheme));
        sb.append(',');
        sb.append("trackedEntityAttributeIdScheme");
        sb.append('=');
        sb.append(((this.trackedEntityAttributeIdScheme == null)?"<null>":this.trackedEntityAttributeIdScheme));
        sb.append(',');
        sb.append("trackedEntityIdScheme");
        sb.append('=');
        sb.append(((this.trackedEntityIdScheme == null)?"<null>":this.trackedEntityIdScheme));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.dataElementIdScheme == null)? 0 :this.dataElementIdScheme.hashCode()));
        result = ((result* 31)+((this.orgUnitGroupIdScheme == null)? 0 :this.orgUnitGroupIdScheme.hashCode()));
        result = ((result* 31)+((this.attributeOptionComboIdScheme == null)? 0 :this.attributeOptionComboIdScheme.hashCode()));
        result = ((result* 31)+((this.programIdScheme == null)? 0 :this.programIdScheme.hashCode()));
        result = ((result* 31)+((this.dataSetIdScheme == null)? 0 :this.dataSetIdScheme.hashCode()));
        result = ((result* 31)+((this.orgUnitIdScheme == null)? 0 :this.orgUnitIdScheme.hashCode()));
        result = ((result* 31)+((this.trackedEntityAttributeIdScheme == null)? 0 :this.trackedEntityAttributeIdScheme.hashCode()));
        result = ((result* 31)+((this.categoryIdScheme == null)? 0 :this.categoryIdScheme.hashCode()));
        result = ((result* 31)+((this.trackedEntityIdScheme == null)? 0 :this.trackedEntityIdScheme.hashCode()));
        result = ((result* 31)+((this.categoryOptionIdScheme == null)? 0 :this.categoryOptionIdScheme.hashCode()));
        result = ((result* 31)+((this.idScheme == null)? 0 :this.idScheme.hashCode()));
        result = ((result* 31)+((this.programStageInstanceIdScheme == null)? 0 :this.programStageInstanceIdScheme.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.categoryOptionComboIdScheme == null)? 0 :this.categoryOptionComboIdScheme.hashCode()));
        result = ((result* 31)+((this.programStageIdScheme == null)? 0 :this.programStageIdScheme.hashCode()));
        result = ((result* 31)+((this.dataElementGroupIdScheme == null)? 0 :this.dataElementGroupIdScheme.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof IdSchemes) == false) {
            return false;
        }
        IdSchemes rhs = ((IdSchemes) other);
        return (((((((((((((((((this.dataElementIdScheme == rhs.dataElementIdScheme)||((this.dataElementIdScheme!= null)&&this.dataElementIdScheme.equals(rhs.dataElementIdScheme)))&&((this.orgUnitGroupIdScheme == rhs.orgUnitGroupIdScheme)||((this.orgUnitGroupIdScheme!= null)&&this.orgUnitGroupIdScheme.equals(rhs.orgUnitGroupIdScheme))))&&((this.attributeOptionComboIdScheme == rhs.attributeOptionComboIdScheme)||((this.attributeOptionComboIdScheme!= null)&&this.attributeOptionComboIdScheme.equals(rhs.attributeOptionComboIdScheme))))&&((this.programIdScheme == rhs.programIdScheme)||((this.programIdScheme!= null)&&this.programIdScheme.equals(rhs.programIdScheme))))&&((this.dataSetIdScheme == rhs.dataSetIdScheme)||((this.dataSetIdScheme!= null)&&this.dataSetIdScheme.equals(rhs.dataSetIdScheme))))&&((this.orgUnitIdScheme == rhs.orgUnitIdScheme)||((this.orgUnitIdScheme!= null)&&this.orgUnitIdScheme.equals(rhs.orgUnitIdScheme))))&&((this.trackedEntityAttributeIdScheme == rhs.trackedEntityAttributeIdScheme)||((this.trackedEntityAttributeIdScheme!= null)&&this.trackedEntityAttributeIdScheme.equals(rhs.trackedEntityAttributeIdScheme))))&&((this.categoryIdScheme == rhs.categoryIdScheme)||((this.categoryIdScheme!= null)&&this.categoryIdScheme.equals(rhs.categoryIdScheme))))&&((this.trackedEntityIdScheme == rhs.trackedEntityIdScheme)||((this.trackedEntityIdScheme!= null)&&this.trackedEntityIdScheme.equals(rhs.trackedEntityIdScheme))))&&((this.categoryOptionIdScheme == rhs.categoryOptionIdScheme)||((this.categoryOptionIdScheme!= null)&&this.categoryOptionIdScheme.equals(rhs.categoryOptionIdScheme))))&&((this.idScheme == rhs.idScheme)||((this.idScheme!= null)&&this.idScheme.equals(rhs.idScheme))))&&((this.programStageInstanceIdScheme == rhs.programStageInstanceIdScheme)||((this.programStageInstanceIdScheme!= null)&&this.programStageInstanceIdScheme.equals(rhs.programStageInstanceIdScheme))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.categoryOptionComboIdScheme == rhs.categoryOptionComboIdScheme)||((this.categoryOptionComboIdScheme!= null)&&this.categoryOptionComboIdScheme.equals(rhs.categoryOptionComboIdScheme))))&&((this.programStageIdScheme == rhs.programStageIdScheme)||((this.programStageIdScheme!= null)&&this.programStageIdScheme.equals(rhs.programStageIdScheme))))&&((this.dataElementGroupIdScheme == rhs.dataElementGroupIdScheme)||((this.dataElementGroupIdScheme!= null)&&this.dataElementGroupIdScheme.equals(rhs.dataElementGroupIdScheme))));
    }

}
