
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access_token",
    "client_id",
    "expires_in"
})
@Generated("jsonschema2pojo")
public class GoogleAccessToken implements Serializable
{

    @JsonProperty("access_token")
    private String accessToken;
    @JsonProperty("client_id")
    private String clientId;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("expires_in")
    private Integer expiresIn;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 397485957030413527L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public GoogleAccessToken() {
    }

    /**
     * 
     * @param source
     */
    public GoogleAccessToken(GoogleAccessToken source) {
        super();
        this.accessToken = source.accessToken;
        this.clientId = source.clientId;
        this.expiresIn = source.expiresIn;
    }

    /**
     * 
     * @param expiresIn
     * @param clientId
     * @param accessToken
     */
    public GoogleAccessToken(String accessToken, String clientId, Integer expiresIn) {
        super();
        this.accessToken = accessToken;
        this.clientId = clientId;
        this.expiresIn = expiresIn;
    }

    @JsonProperty("access_token")
    public Optional<String> getAccessToken() {
        return Optional.ofNullable(accessToken);
    }

    @JsonProperty("access_token")
    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public GoogleAccessToken withAccessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    @JsonProperty("client_id")
    public Optional<String> getClientId() {
        return Optional.ofNullable(clientId);
    }

    @JsonProperty("client_id")
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public GoogleAccessToken withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("expires_in")
    public Integer getExpiresIn() {
        return expiresIn;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("expires_in")
    public void setExpiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
    }

    public GoogleAccessToken withExpiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public GoogleAccessToken withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "access_token":
                if (value instanceof String) {
                    setAccessToken(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"access_token\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "client_id":
                if (value instanceof String) {
                    setClientId(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"client_id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "expires_in":
                if (value instanceof Integer) {
                    setExpiresIn(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"expires_in\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "access_token":
                return getAccessToken();
            case "client_id":
                return getClientId();
            case "expires_in":
                return getExpiresIn();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, GoogleAccessToken.NOT_FOUND_VALUE);
        if (GoogleAccessToken.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public GoogleAccessToken with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(GoogleAccessToken.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("accessToken");
        sb.append('=');
        sb.append(((this.accessToken == null)?"<null>":this.accessToken));
        sb.append(',');
        sb.append("clientId");
        sb.append('=');
        sb.append(((this.clientId == null)?"<null>":this.clientId));
        sb.append(',');
        sb.append("expiresIn");
        sb.append('=');
        sb.append(((this.expiresIn == null)?"<null>":this.expiresIn));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.expiresIn == null)? 0 :this.expiresIn.hashCode()));
        result = ((result* 31)+((this.clientId == null)? 0 :this.clientId.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.accessToken == null)? 0 :this.accessToken.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof GoogleAccessToken) == false) {
            return false;
        }
        GoogleAccessToken rhs = ((GoogleAccessToken) other);
        return (((((this.expiresIn == rhs.expiresIn)||((this.expiresIn!= null)&&this.expiresIn.equals(rhs.expiresIn)))&&((this.clientId == rhs.clientId)||((this.clientId!= null)&&this.clientId.equals(rhs.clientId))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.accessToken == rhs.accessToken)||((this.accessToken!= null)&&this.accessToken.equals(rhs.accessToken))));
    }

}
