
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "followupValues",
    "metadata"
})
@Generated("jsonschema2pojo")
public class FollowupAnalysisResponse implements Serializable
{

    @JsonProperty("followupValues")
    private List<FollowupValue> followupValues = null;
    @JsonProperty("metadata")
    private FollowupAnalysisMetadata metadata;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 2861203702761947519L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public FollowupAnalysisResponse() {
    }

    /**
     * 
     * @param source
     */
    public FollowupAnalysisResponse(FollowupAnalysisResponse source) {
        super();
        this.followupValues = source.followupValues;
        this.metadata = source.metadata;
    }

    /**
     * 
     * @param metadata
     * @param followupValues
     */
    public FollowupAnalysisResponse(List<FollowupValue> followupValues, FollowupAnalysisMetadata metadata) {
        super();
        this.followupValues = followupValues;
        this.metadata = metadata;
    }

    @JsonProperty("followupValues")
    public Optional<List<FollowupValue>> getFollowupValues() {
        return Optional.ofNullable(followupValues);
    }

    @JsonProperty("followupValues")
    public void setFollowupValues(List<FollowupValue> followupValues) {
        this.followupValues = followupValues;
    }

    public FollowupAnalysisResponse withFollowupValues(List<FollowupValue> followupValues) {
        this.followupValues = followupValues;
        return this;
    }

    @JsonProperty("metadata")
    public Optional<FollowupAnalysisMetadata> getMetadata() {
        return Optional.ofNullable(metadata);
    }

    @JsonProperty("metadata")
    public void setMetadata(FollowupAnalysisMetadata metadata) {
        this.metadata = metadata;
    }

    public FollowupAnalysisResponse withMetadata(FollowupAnalysisMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public FollowupAnalysisResponse withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "followupValues":
                if (value instanceof List) {
                    setFollowupValues(((List<FollowupValue> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"followupValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.FollowupValue>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "metadata":
                if (value instanceof FollowupAnalysisMetadata) {
                    setMetadata(((FollowupAnalysisMetadata) value));
                } else {
                    throw new IllegalArgumentException(("property \"metadata\" is of type \"org.hisp.dhis.api.model.v40_0.FollowupAnalysisMetadata\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "followupValues":
                return getFollowupValues();
            case "metadata":
                return getMetadata();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, FollowupAnalysisResponse.NOT_FOUND_VALUE);
        if (FollowupAnalysisResponse.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public FollowupAnalysisResponse with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(FollowupAnalysisResponse.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("followupValues");
        sb.append('=');
        sb.append(((this.followupValues == null)?"<null>":this.followupValues));
        sb.append(',');
        sb.append("metadata");
        sb.append('=');
        sb.append(((this.metadata == null)?"<null>":this.metadata));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.metadata == null)? 0 :this.metadata.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.followupValues == null)? 0 :this.followupValues.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof FollowupAnalysisResponse) == false) {
            return false;
        }
        FollowupAnalysisResponse rhs = ((FollowupAnalysisResponse) other);
        return ((((this.metadata == rhs.metadata)||((this.metadata!= null)&&this.metadata.equals(rhs.metadata)))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.followupValues == rhs.followupValues)||((this.followupValues!= null)&&this.followupValues.equals(rhs.followupValues))));
    }

}
