
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "allowedContentTypes",
    "maxFileSize",
    "version"
})
@Generated("jsonschema2pojo")
public class FileTypeValueOptions implements Serializable
{

    @JsonProperty("allowedContentTypes")
    private List<String> allowedContentTypes = null;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("maxFileSize")
    private Integer maxFileSize;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("version")
    private Integer version;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 3500232675489238348L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public FileTypeValueOptions() {
    }

    /**
     * 
     * @param source
     */
    public FileTypeValueOptions(FileTypeValueOptions source) {
        super();
        this.allowedContentTypes = source.allowedContentTypes;
        this.maxFileSize = source.maxFileSize;
        this.version = source.version;
    }

    /**
     * 
     * @param allowedContentTypes
     * @param maxFileSize
     * @param version
     */
    public FileTypeValueOptions(List<String> allowedContentTypes, Integer maxFileSize, Integer version) {
        super();
        this.allowedContentTypes = allowedContentTypes;
        this.maxFileSize = maxFileSize;
        this.version = version;
    }

    @JsonProperty("allowedContentTypes")
    public Optional<List<String>> getAllowedContentTypes() {
        return Optional.ofNullable(allowedContentTypes);
    }

    @JsonProperty("allowedContentTypes")
    public void setAllowedContentTypes(List<String> allowedContentTypes) {
        this.allowedContentTypes = allowedContentTypes;
    }

    public FileTypeValueOptions withAllowedContentTypes(List<String> allowedContentTypes) {
        this.allowedContentTypes = allowedContentTypes;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("maxFileSize")
    public Integer getMaxFileSize() {
        return maxFileSize;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("maxFileSize")
    public void setMaxFileSize(Integer maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public FileTypeValueOptions withMaxFileSize(Integer maxFileSize) {
        this.maxFileSize = maxFileSize;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("version")
    public Integer getVersion() {
        return version;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("version")
    public void setVersion(Integer version) {
        this.version = version;
    }

    public FileTypeValueOptions withVersion(Integer version) {
        this.version = version;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public FileTypeValueOptions withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "allowedContentTypes":
                if (value instanceof List) {
                    setAllowedContentTypes(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"allowedContentTypes\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "maxFileSize":
                if (value instanceof Integer) {
                    setMaxFileSize(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"maxFileSize\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "version":
                if (value instanceof Integer) {
                    setVersion(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"version\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "allowedContentTypes":
                return getAllowedContentTypes();
            case "maxFileSize":
                return getMaxFileSize();
            case "version":
                return getVersion();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, FileTypeValueOptions.NOT_FOUND_VALUE);
        if (FileTypeValueOptions.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public FileTypeValueOptions with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(FileTypeValueOptions.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("allowedContentTypes");
        sb.append('=');
        sb.append(((this.allowedContentTypes == null)?"<null>":this.allowedContentTypes));
        sb.append(',');
        sb.append("maxFileSize");
        sb.append('=');
        sb.append(((this.maxFileSize == null)?"<null>":this.maxFileSize));
        sb.append(',');
        sb.append("version");
        sb.append('=');
        sb.append(((this.version == null)?"<null>":this.version));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.allowedContentTypes == null)? 0 :this.allowedContentTypes.hashCode()));
        result = ((result* 31)+((this.maxFileSize == null)? 0 :this.maxFileSize.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.version == null)? 0 :this.version.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof FileTypeValueOptions) == false) {
            return false;
        }
        FileTypeValueOptions rhs = ((FileTypeValueOptions) other);
        return (((((this.allowedContentTypes == rhs.allowedContentTypes)||((this.allowedContentTypes!= null)&&this.allowedContentTypes.equals(rhs.allowedContentTypes)))&&((this.maxFileSize == rhs.maxFileSize)||((this.maxFileSize!= null)&&this.maxFileSize.equals(rhs.maxFileSize))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.version == rhs.version)||((this.version!= null)&&this.version.equals(rhs.version))));
    }

}
