
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "attributes",
    "coordinates",
    "created",
    "createdAtClient",
    "createdByUserInfo",
    "deleted",
    "enrollments",
    "featureType",
    "geometry",
    "inactive",
    "lastUpdated",
    "lastUpdatedAtClient",
    "lastUpdatedByUserInfo",
    "orgUnit",
    "potentialDuplicate",
    "programOwners",
    "relationships",
    "storedBy",
    "trackedEntityInstance",
    "trackedEntityType"
})
@Generated("jsonschema2pojo")
public class Dxf2EventsTrackedentityTrackedEntityInstance implements Serializable
{

    @JsonProperty("attributes")
    private List<Dxf2EventsTrackedentityAttribute> attributes = null;
    @JsonProperty("coordinates")
    private String coordinates;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("created")
    private String created;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("createdAtClient")
    private String createdAtClient;
    @JsonProperty("createdByUserInfo")
    private UserInfoSnapshot createdByUserInfo;
    @JsonProperty("deleted")
    private Boolean deleted;
    @JsonProperty("enrollments")
    private List<Enrollment> enrollments = null;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("featureType")
    private Dxf2EventsTrackedentityTrackedEntityInstance.FeatureType featureType;
    @JsonProperty("geometry")
    private Geometry__8 geometry;
    @JsonProperty("inactive")
    private Boolean inactive;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("lastUpdated")
    private String lastUpdated;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("lastUpdatedAtClient")
    private String lastUpdatedAtClient;
    @JsonProperty("lastUpdatedByUserInfo")
    private UserInfoSnapshot lastUpdatedByUserInfo;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("orgUnit")
    private String orgUnit;
    @JsonProperty("potentialDuplicate")
    private Boolean potentialDuplicate;
    @JsonProperty("programOwners")
    private List<ProgramOwner> programOwners = null;
    @JsonProperty("relationships")
    private List<Relationship> relationships = null;
    @JsonProperty("storedBy")
    private String storedBy;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("trackedEntityInstance")
    private String trackedEntityInstance;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("trackedEntityType")
    private String trackedEntityType;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -113621187162326768L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Dxf2EventsTrackedentityTrackedEntityInstance() {
    }

    /**
     * 
     * @param source
     */
    public Dxf2EventsTrackedentityTrackedEntityInstance(Dxf2EventsTrackedentityTrackedEntityInstance source) {
        super();
        this.attributes = source.attributes;
        this.coordinates = source.coordinates;
        this.created = source.created;
        this.createdAtClient = source.createdAtClient;
        this.createdByUserInfo = source.createdByUserInfo;
        this.deleted = source.deleted;
        this.enrollments = source.enrollments;
        this.featureType = source.featureType;
        this.geometry = source.geometry;
        this.inactive = source.inactive;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedAtClient = source.lastUpdatedAtClient;
        this.lastUpdatedByUserInfo = source.lastUpdatedByUserInfo;
        this.orgUnit = source.orgUnit;
        this.potentialDuplicate = source.potentialDuplicate;
        this.programOwners = source.programOwners;
        this.relationships = source.relationships;
        this.storedBy = source.storedBy;
        this.trackedEntityInstance = source.trackedEntityInstance;
        this.trackedEntityType = source.trackedEntityType;
    }

    /**
     * 
     * @param programOwners
     * @param storedBy
     * @param created
     * @param orgUnit
     * @param coordinates
     * @param createdAtClient
     * @param potentialDuplicate
     * @param enrollments
     * @param lastUpdatedByUserInfo
     * @param trackedEntityInstance
     * @param lastUpdated
     * @param relationships
     * @param deleted
     * @param inactive
     * @param trackedEntityType
     * @param featureType
     * @param attributes
     * @param geometry
     * @param createdByUserInfo
     * @param lastUpdatedAtClient
     */
    public Dxf2EventsTrackedentityTrackedEntityInstance(List<Dxf2EventsTrackedentityAttribute> attributes, String coordinates, String created, String createdAtClient, UserInfoSnapshot createdByUserInfo, Boolean deleted, List<Enrollment> enrollments, Dxf2EventsTrackedentityTrackedEntityInstance.FeatureType featureType, Geometry__8 geometry, Boolean inactive, String lastUpdated, String lastUpdatedAtClient, UserInfoSnapshot lastUpdatedByUserInfo, String orgUnit, Boolean potentialDuplicate, List<ProgramOwner> programOwners, List<Relationship> relationships, String storedBy, String trackedEntityInstance, String trackedEntityType) {
        super();
        this.attributes = attributes;
        this.coordinates = coordinates;
        this.created = created;
        this.createdAtClient = createdAtClient;
        this.createdByUserInfo = createdByUserInfo;
        this.deleted = deleted;
        this.enrollments = enrollments;
        this.featureType = featureType;
        this.geometry = geometry;
        this.inactive = inactive;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedAtClient = lastUpdatedAtClient;
        this.lastUpdatedByUserInfo = lastUpdatedByUserInfo;
        this.orgUnit = orgUnit;
        this.potentialDuplicate = potentialDuplicate;
        this.programOwners = programOwners;
        this.relationships = relationships;
        this.storedBy = storedBy;
        this.trackedEntityInstance = trackedEntityInstance;
        this.trackedEntityType = trackedEntityType;
    }

    @JsonProperty("attributes")
    public Optional<List<Dxf2EventsTrackedentityAttribute>> getAttributes() {
        return Optional.ofNullable(attributes);
    }

    @JsonProperty("attributes")
    public void setAttributes(List<Dxf2EventsTrackedentityAttribute> attributes) {
        this.attributes = attributes;
    }

    public Dxf2EventsTrackedentityTrackedEntityInstance withAttributes(List<Dxf2EventsTrackedentityAttribute> attributes) {
        this.attributes = attributes;
        return this;
    }

    @JsonProperty("coordinates")
    public Optional<String> getCoordinates() {
        return Optional.ofNullable(coordinates);
    }

    @JsonProperty("coordinates")
    public void setCoordinates(String coordinates) {
        this.coordinates = coordinates;
    }

    public Dxf2EventsTrackedentityTrackedEntityInstance withCoordinates(String coordinates) {
        this.coordinates = coordinates;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("created")
    public String getCreated() {
        return created;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("created")
    public void setCreated(String created) {
        this.created = created;
    }

    public Dxf2EventsTrackedentityTrackedEntityInstance withCreated(String created) {
        this.created = created;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("createdAtClient")
    public String getCreatedAtClient() {
        return createdAtClient;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("createdAtClient")
    public void setCreatedAtClient(String createdAtClient) {
        this.createdAtClient = createdAtClient;
    }

    public Dxf2EventsTrackedentityTrackedEntityInstance withCreatedAtClient(String createdAtClient) {
        this.createdAtClient = createdAtClient;
        return this;
    }

    @JsonProperty("createdByUserInfo")
    public Optional<UserInfoSnapshot> getCreatedByUserInfo() {
        return Optional.ofNullable(createdByUserInfo);
    }

    @JsonProperty("createdByUserInfo")
    public void setCreatedByUserInfo(UserInfoSnapshot createdByUserInfo) {
        this.createdByUserInfo = createdByUserInfo;
    }

    public Dxf2EventsTrackedentityTrackedEntityInstance withCreatedByUserInfo(UserInfoSnapshot createdByUserInfo) {
        this.createdByUserInfo = createdByUserInfo;
        return this;
    }

    @JsonProperty("deleted")
    public Optional<Boolean> getDeleted() {
        return Optional.ofNullable(deleted);
    }

    @JsonProperty("deleted")
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public Dxf2EventsTrackedentityTrackedEntityInstance withDeleted(Boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    @JsonProperty("enrollments")
    public Optional<List<Enrollment>> getEnrollments() {
        return Optional.ofNullable(enrollments);
    }

    @JsonProperty("enrollments")
    public void setEnrollments(List<Enrollment> enrollments) {
        this.enrollments = enrollments;
    }

    public Dxf2EventsTrackedentityTrackedEntityInstance withEnrollments(List<Enrollment> enrollments) {
        this.enrollments = enrollments;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("featureType")
    public Dxf2EventsTrackedentityTrackedEntityInstance.FeatureType getFeatureType() {
        return featureType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("featureType")
    public void setFeatureType(Dxf2EventsTrackedentityTrackedEntityInstance.FeatureType featureType) {
        this.featureType = featureType;
    }

    public Dxf2EventsTrackedentityTrackedEntityInstance withFeatureType(Dxf2EventsTrackedentityTrackedEntityInstance.FeatureType featureType) {
        this.featureType = featureType;
        return this;
    }

    @JsonProperty("geometry")
    public Optional<Geometry__8> getGeometry() {
        return Optional.ofNullable(geometry);
    }

    @JsonProperty("geometry")
    public void setGeometry(Geometry__8 geometry) {
        this.geometry = geometry;
    }

    public Dxf2EventsTrackedentityTrackedEntityInstance withGeometry(Geometry__8 geometry) {
        this.geometry = geometry;
        return this;
    }

    @JsonProperty("inactive")
    public Optional<Boolean> getInactive() {
        return Optional.ofNullable(inactive);
    }

    @JsonProperty("inactive")
    public void setInactive(Boolean inactive) {
        this.inactive = inactive;
    }

    public Dxf2EventsTrackedentityTrackedEntityInstance withInactive(Boolean inactive) {
        this.inactive = inactive;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("lastUpdated")
    public String getLastUpdated() {
        return lastUpdated;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("lastUpdated")
    public void setLastUpdated(String lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public Dxf2EventsTrackedentityTrackedEntityInstance withLastUpdated(String lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("lastUpdatedAtClient")
    public String getLastUpdatedAtClient() {
        return lastUpdatedAtClient;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("lastUpdatedAtClient")
    public void setLastUpdatedAtClient(String lastUpdatedAtClient) {
        this.lastUpdatedAtClient = lastUpdatedAtClient;
    }

    public Dxf2EventsTrackedentityTrackedEntityInstance withLastUpdatedAtClient(String lastUpdatedAtClient) {
        this.lastUpdatedAtClient = lastUpdatedAtClient;
        return this;
    }

    @JsonProperty("lastUpdatedByUserInfo")
    public Optional<UserInfoSnapshot> getLastUpdatedByUserInfo() {
        return Optional.ofNullable(lastUpdatedByUserInfo);
    }

    @JsonProperty("lastUpdatedByUserInfo")
    public void setLastUpdatedByUserInfo(UserInfoSnapshot lastUpdatedByUserInfo) {
        this.lastUpdatedByUserInfo = lastUpdatedByUserInfo;
    }

    public Dxf2EventsTrackedentityTrackedEntityInstance withLastUpdatedByUserInfo(UserInfoSnapshot lastUpdatedByUserInfo) {
        this.lastUpdatedByUserInfo = lastUpdatedByUserInfo;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("orgUnit")
    public String getOrgUnit() {
        return orgUnit;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("orgUnit")
    public void setOrgUnit(String orgUnit) {
        this.orgUnit = orgUnit;
    }

    public Dxf2EventsTrackedentityTrackedEntityInstance withOrgUnit(String orgUnit) {
        this.orgUnit = orgUnit;
        return this;
    }

    @JsonProperty("potentialDuplicate")
    public Optional<Boolean> getPotentialDuplicate() {
        return Optional.ofNullable(potentialDuplicate);
    }

    @JsonProperty("potentialDuplicate")
    public void setPotentialDuplicate(Boolean potentialDuplicate) {
        this.potentialDuplicate = potentialDuplicate;
    }

    public Dxf2EventsTrackedentityTrackedEntityInstance withPotentialDuplicate(Boolean potentialDuplicate) {
        this.potentialDuplicate = potentialDuplicate;
        return this;
    }

    @JsonProperty("programOwners")
    public Optional<List<ProgramOwner>> getProgramOwners() {
        return Optional.ofNullable(programOwners);
    }

    @JsonProperty("programOwners")
    public void setProgramOwners(List<ProgramOwner> programOwners) {
        this.programOwners = programOwners;
    }

    public Dxf2EventsTrackedentityTrackedEntityInstance withProgramOwners(List<ProgramOwner> programOwners) {
        this.programOwners = programOwners;
        return this;
    }

    @JsonProperty("relationships")
    public Optional<List<Relationship>> getRelationships() {
        return Optional.ofNullable(relationships);
    }

    @JsonProperty("relationships")
    public void setRelationships(List<Relationship> relationships) {
        this.relationships = relationships;
    }

    public Dxf2EventsTrackedentityTrackedEntityInstance withRelationships(List<Relationship> relationships) {
        this.relationships = relationships;
        return this;
    }

    @JsonProperty("storedBy")
    public Optional<String> getStoredBy() {
        return Optional.ofNullable(storedBy);
    }

    @JsonProperty("storedBy")
    public void setStoredBy(String storedBy) {
        this.storedBy = storedBy;
    }

    public Dxf2EventsTrackedentityTrackedEntityInstance withStoredBy(String storedBy) {
        this.storedBy = storedBy;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("trackedEntityInstance")
    public String getTrackedEntityInstance() {
        return trackedEntityInstance;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("trackedEntityInstance")
    public void setTrackedEntityInstance(String trackedEntityInstance) {
        this.trackedEntityInstance = trackedEntityInstance;
    }

    public Dxf2EventsTrackedentityTrackedEntityInstance withTrackedEntityInstance(String trackedEntityInstance) {
        this.trackedEntityInstance = trackedEntityInstance;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("trackedEntityType")
    public String getTrackedEntityType() {
        return trackedEntityType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("trackedEntityType")
    public void setTrackedEntityType(String trackedEntityType) {
        this.trackedEntityType = trackedEntityType;
    }

    public Dxf2EventsTrackedentityTrackedEntityInstance withTrackedEntityType(String trackedEntityType) {
        this.trackedEntityType = trackedEntityType;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Dxf2EventsTrackedentityTrackedEntityInstance withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "attributes":
                if (value instanceof List) {
                    setAttributes(((List<Dxf2EventsTrackedentityAttribute> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributes\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.Dxf2EventsTrackedentityAttribute>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "coordinates":
                if (value instanceof String) {
                    setCoordinates(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"coordinates\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "created":
                if (value instanceof String) {
                    setCreated(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"created\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "createdAtClient":
                if (value instanceof String) {
                    setCreatedAtClient(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"createdAtClient\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "createdByUserInfo":
                if (value instanceof UserInfoSnapshot) {
                    setCreatedByUserInfo(((UserInfoSnapshot) value));
                } else {
                    throw new IllegalArgumentException(("property \"createdByUserInfo\" is of type \"org.hisp.dhis.api.model.v40_0.UserInfoSnapshot\", but got "+ value.getClass().toString()));
                }
                return true;
            case "deleted":
                if (value instanceof Boolean) {
                    setDeleted(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"deleted\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "enrollments":
                if (value instanceof List) {
                    setEnrollments(((List<Enrollment> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"enrollments\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.Enrollment>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "featureType":
                if (value instanceof Dxf2EventsTrackedentityTrackedEntityInstance.FeatureType) {
                    setFeatureType(((Dxf2EventsTrackedentityTrackedEntityInstance.FeatureType) value));
                } else {
                    throw new IllegalArgumentException(("property \"featureType\" is of type \"org.hisp.dhis.api.model.v40_0.Dxf2EventsTrackedentityTrackedEntityInstance.FeatureType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "geometry":
                if (value instanceof Geometry__8) {
                    setGeometry(((Geometry__8) value));
                } else {
                    throw new IllegalArgumentException(("property \"geometry\" is of type \"org.hisp.dhis.api.model.v40_0.Geometry__8\", but got "+ value.getClass().toString()));
                }
                return true;
            case "inactive":
                if (value instanceof Boolean) {
                    setInactive(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"inactive\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdated":
                if (value instanceof String) {
                    setLastUpdated(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdatedAtClient":
                if (value instanceof String) {
                    setLastUpdatedAtClient(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdatedAtClient\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdatedByUserInfo":
                if (value instanceof UserInfoSnapshot) {
                    setLastUpdatedByUserInfo(((UserInfoSnapshot) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdatedByUserInfo\" is of type \"org.hisp.dhis.api.model.v40_0.UserInfoSnapshot\", but got "+ value.getClass().toString()));
                }
                return true;
            case "orgUnit":
                if (value instanceof String) {
                    setOrgUnit(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"orgUnit\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "potentialDuplicate":
                if (value instanceof Boolean) {
                    setPotentialDuplicate(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"potentialDuplicate\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "programOwners":
                if (value instanceof List) {
                    setProgramOwners(((List<ProgramOwner> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"programOwners\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.ProgramOwner>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "relationships":
                if (value instanceof List) {
                    setRelationships(((List<Relationship> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"relationships\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.Relationship>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "storedBy":
                if (value instanceof String) {
                    setStoredBy(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"storedBy\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "trackedEntityInstance":
                if (value instanceof String) {
                    setTrackedEntityInstance(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"trackedEntityInstance\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "trackedEntityType":
                if (value instanceof String) {
                    setTrackedEntityType(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"trackedEntityType\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "attributes":
                return getAttributes();
            case "coordinates":
                return getCoordinates();
            case "created":
                return getCreated();
            case "createdAtClient":
                return getCreatedAtClient();
            case "createdByUserInfo":
                return getCreatedByUserInfo();
            case "deleted":
                return getDeleted();
            case "enrollments":
                return getEnrollments();
            case "featureType":
                return getFeatureType();
            case "geometry":
                return getGeometry();
            case "inactive":
                return getInactive();
            case "lastUpdated":
                return getLastUpdated();
            case "lastUpdatedAtClient":
                return getLastUpdatedAtClient();
            case "lastUpdatedByUserInfo":
                return getLastUpdatedByUserInfo();
            case "orgUnit":
                return getOrgUnit();
            case "potentialDuplicate":
                return getPotentialDuplicate();
            case "programOwners":
                return getProgramOwners();
            case "relationships":
                return getRelationships();
            case "storedBy":
                return getStoredBy();
            case "trackedEntityInstance":
                return getTrackedEntityInstance();
            case "trackedEntityType":
                return getTrackedEntityType();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, Dxf2EventsTrackedentityTrackedEntityInstance.NOT_FOUND_VALUE);
        if (Dxf2EventsTrackedentityTrackedEntityInstance.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public Dxf2EventsTrackedentityTrackedEntityInstance with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Dxf2EventsTrackedentityTrackedEntityInstance.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("attributes");
        sb.append('=');
        sb.append(((this.attributes == null)?"<null>":this.attributes));
        sb.append(',');
        sb.append("coordinates");
        sb.append('=');
        sb.append(((this.coordinates == null)?"<null>":this.coordinates));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("createdAtClient");
        sb.append('=');
        sb.append(((this.createdAtClient == null)?"<null>":this.createdAtClient));
        sb.append(',');
        sb.append("createdByUserInfo");
        sb.append('=');
        sb.append(((this.createdByUserInfo == null)?"<null>":this.createdByUserInfo));
        sb.append(',');
        sb.append("deleted");
        sb.append('=');
        sb.append(((this.deleted == null)?"<null>":this.deleted));
        sb.append(',');
        sb.append("enrollments");
        sb.append('=');
        sb.append(((this.enrollments == null)?"<null>":this.enrollments));
        sb.append(',');
        sb.append("featureType");
        sb.append('=');
        sb.append(((this.featureType == null)?"<null>":this.featureType));
        sb.append(',');
        sb.append("geometry");
        sb.append('=');
        sb.append(((this.geometry == null)?"<null>":this.geometry));
        sb.append(',');
        sb.append("inactive");
        sb.append('=');
        sb.append(((this.inactive == null)?"<null>":this.inactive));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedAtClient");
        sb.append('=');
        sb.append(((this.lastUpdatedAtClient == null)?"<null>":this.lastUpdatedAtClient));
        sb.append(',');
        sb.append("lastUpdatedByUserInfo");
        sb.append('=');
        sb.append(((this.lastUpdatedByUserInfo == null)?"<null>":this.lastUpdatedByUserInfo));
        sb.append(',');
        sb.append("orgUnit");
        sb.append('=');
        sb.append(((this.orgUnit == null)?"<null>":this.orgUnit));
        sb.append(',');
        sb.append("potentialDuplicate");
        sb.append('=');
        sb.append(((this.potentialDuplicate == null)?"<null>":this.potentialDuplicate));
        sb.append(',');
        sb.append("programOwners");
        sb.append('=');
        sb.append(((this.programOwners == null)?"<null>":this.programOwners));
        sb.append(',');
        sb.append("relationships");
        sb.append('=');
        sb.append(((this.relationships == null)?"<null>":this.relationships));
        sb.append(',');
        sb.append("storedBy");
        sb.append('=');
        sb.append(((this.storedBy == null)?"<null>":this.storedBy));
        sb.append(',');
        sb.append("trackedEntityInstance");
        sb.append('=');
        sb.append(((this.trackedEntityInstance == null)?"<null>":this.trackedEntityInstance));
        sb.append(',');
        sb.append("trackedEntityType");
        sb.append('=');
        sb.append(((this.trackedEntityType == null)?"<null>":this.trackedEntityType));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.programOwners == null)? 0 :this.programOwners.hashCode()));
        result = ((result* 31)+((this.storedBy == null)? 0 :this.storedBy.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.orgUnit == null)? 0 :this.orgUnit.hashCode()));
        result = ((result* 31)+((this.coordinates == null)? 0 :this.coordinates.hashCode()));
        result = ((result* 31)+((this.createdAtClient == null)? 0 :this.createdAtClient.hashCode()));
        result = ((result* 31)+((this.potentialDuplicate == null)? 0 :this.potentialDuplicate.hashCode()));
        result = ((result* 31)+((this.enrollments == null)? 0 :this.enrollments.hashCode()));
        result = ((result* 31)+((this.lastUpdatedByUserInfo == null)? 0 :this.lastUpdatedByUserInfo.hashCode()));
        result = ((result* 31)+((this.trackedEntityInstance == null)? 0 :this.trackedEntityInstance.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.relationships == null)? 0 :this.relationships.hashCode()));
        result = ((result* 31)+((this.deleted == null)? 0 :this.deleted.hashCode()));
        result = ((result* 31)+((this.inactive == null)? 0 :this.inactive.hashCode()));
        result = ((result* 31)+((this.trackedEntityType == null)? 0 :this.trackedEntityType.hashCode()));
        result = ((result* 31)+((this.featureType == null)? 0 :this.featureType.hashCode()));
        result = ((result* 31)+((this.attributes == null)? 0 :this.attributes.hashCode()));
        result = ((result* 31)+((this.geometry == null)? 0 :this.geometry.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.createdByUserInfo == null)? 0 :this.createdByUserInfo.hashCode()));
        result = ((result* 31)+((this.lastUpdatedAtClient == null)? 0 :this.lastUpdatedAtClient.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Dxf2EventsTrackedentityTrackedEntityInstance) == false) {
            return false;
        }
        Dxf2EventsTrackedentityTrackedEntityInstance rhs = ((Dxf2EventsTrackedentityTrackedEntityInstance) other);
        return ((((((((((((((((((((((this.programOwners == rhs.programOwners)||((this.programOwners!= null)&&this.programOwners.equals(rhs.programOwners)))&&((this.storedBy == rhs.storedBy)||((this.storedBy!= null)&&this.storedBy.equals(rhs.storedBy))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.orgUnit == rhs.orgUnit)||((this.orgUnit!= null)&&this.orgUnit.equals(rhs.orgUnit))))&&((this.coordinates == rhs.coordinates)||((this.coordinates!= null)&&this.coordinates.equals(rhs.coordinates))))&&((this.createdAtClient == rhs.createdAtClient)||((this.createdAtClient!= null)&&this.createdAtClient.equals(rhs.createdAtClient))))&&((this.potentialDuplicate == rhs.potentialDuplicate)||((this.potentialDuplicate!= null)&&this.potentialDuplicate.equals(rhs.potentialDuplicate))))&&((this.enrollments == rhs.enrollments)||((this.enrollments!= null)&&this.enrollments.equals(rhs.enrollments))))&&((this.lastUpdatedByUserInfo == rhs.lastUpdatedByUserInfo)||((this.lastUpdatedByUserInfo!= null)&&this.lastUpdatedByUserInfo.equals(rhs.lastUpdatedByUserInfo))))&&((this.trackedEntityInstance == rhs.trackedEntityInstance)||((this.trackedEntityInstance!= null)&&this.trackedEntityInstance.equals(rhs.trackedEntityInstance))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.relationships == rhs.relationships)||((this.relationships!= null)&&this.relationships.equals(rhs.relationships))))&&((this.deleted == rhs.deleted)||((this.deleted!= null)&&this.deleted.equals(rhs.deleted))))&&((this.inactive == rhs.inactive)||((this.inactive!= null)&&this.inactive.equals(rhs.inactive))))&&((this.trackedEntityType == rhs.trackedEntityType)||((this.trackedEntityType!= null)&&this.trackedEntityType.equals(rhs.trackedEntityType))))&&((this.featureType == rhs.featureType)||((this.featureType!= null)&&this.featureType.equals(rhs.featureType))))&&((this.attributes == rhs.attributes)||((this.attributes!= null)&&this.attributes.equals(rhs.attributes))))&&((this.geometry == rhs.geometry)||((this.geometry!= null)&&this.geometry.equals(rhs.geometry))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.createdByUserInfo == rhs.createdByUserInfo)||((this.createdByUserInfo!= null)&&this.createdByUserInfo.equals(rhs.createdByUserInfo))))&&((this.lastUpdatedAtClient == rhs.lastUpdatedAtClient)||((this.lastUpdatedAtClient!= null)&&this.lastUpdatedAtClient.equals(rhs.lastUpdatedAtClient))));
    }

    @Generated("jsonschema2pojo")
    public enum FeatureType {

        NONE("NONE"),
        MULTI_POLYGON("MULTI_POLYGON"),
        POLYGON("POLYGON"),
        POINT("POINT"),
        SYMBOL("SYMBOL");
        private final String value;
        private final static Map<String, Dxf2EventsTrackedentityTrackedEntityInstance.FeatureType> CONSTANTS = new HashMap<String, Dxf2EventsTrackedentityTrackedEntityInstance.FeatureType>();

        static {
            for (Dxf2EventsTrackedentityTrackedEntityInstance.FeatureType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        FeatureType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Dxf2EventsTrackedentityTrackedEntityInstance.FeatureType fromValue(String value) {
            Dxf2EventsTrackedentityTrackedEntityInstance.FeatureType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
