
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "aggregationType",
    "allItems",
    "analyticsType",
    "attributeValues",
    "code",
    "created",
    "createdBy",
    "dataDimension",
    "dataDimensionType",
    "description",
    "dimension",
    "dimensionDisplayName",
    "dimensionItemKeywords",
    "dimensionName",
    "dimensionType",
    "displayDescription",
    "displayName",
    "displayShortName",
    "eventRepetition",
    "externalAccess",
    "favorite",
    "favorites",
    "filter",
    "fixed",
    "groupUUID",
    "href",
    "id",
    "items",
    "key",
    "lastUpdated",
    "lastUpdatedBy",
    "legendSet",
    "name",
    "optionSet",
    "programStage",
    "publicAccess",
    "sharing",
    "shortName",
    "translations",
    "uid",
    "user",
    "userAccesses",
    "userGroupAccesses",
    "valueType"
})
@Generated("jsonschema2pojo")
public class DimensionalObject implements Serializable
{

    @JsonProperty("access")
    private Access access;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("aggregationType")
    private DimensionalObject.AggregationType aggregationType;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("allItems")
    private Boolean allItems;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("analyticsType")
    private DimensionalObject.AnalyticsType analyticsType;
    @JsonProperty("attributeValues")
    private List<AttributeValue> attributeValues = null;
    @JsonProperty("code")
    private String code;
    @JsonProperty("created")
    private Date created;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private RefUser createdBy;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dataDimension")
    private Boolean dataDimension;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dataDimensionType")
    private DimensionalObject.DataDimensionType dataDimensionType;
    @JsonProperty("description")
    private String description;
    @JsonProperty("dimension")
    private String dimension;
    @JsonProperty("dimensionDisplayName")
    private String dimensionDisplayName;
    @JsonProperty("dimensionItemKeywords")
    private DimensionItemKeywords dimensionItemKeywords;
    @JsonProperty("dimensionName")
    private String dimensionName;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dimensionType")
    private DimensionalObject.DimensionType dimensionType;
    @JsonProperty("displayDescription")
    private String displayDescription;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("displayShortName")
    private String displayShortName;
    @JsonProperty("eventRepetition")
    private EventRepetition eventRepetition;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("favorite")
    private Boolean favorite;
    @JsonProperty("favorites")
    private List<String> favorites = null;
    @JsonProperty("filter")
    private String filter;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("fixed")
    private Boolean fixed;
    @JsonProperty("groupUUID")
    private UUID groupUUID;
    @JsonProperty("href")
    private String href;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("id")
    private Integer id;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("items")
    private Boolean items;
    @JsonProperty("key")
    private String key;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private RefUser lastUpdatedBy;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("legendSet")
    private Boolean legendSet;
    @JsonProperty("name")
    private String name;
    /**
     * A UID reference to a OptionSet  
     * (Java name `org.hisp.dhis.option.OptionSet`)
     * 
     */
    @JsonProperty("optionSet")
    @JsonPropertyDescription("A UID reference to a OptionSet  \n(Java name `org.hisp.dhis.option.OptionSet`)")
    private RefOptionSet optionSet;
    /**
     * A UID reference to a ProgramStage  
     * (Java name `org.hisp.dhis.program.ProgramStage`)
     * 
     */
    @JsonProperty("programStage")
    @JsonPropertyDescription("A UID reference to a ProgramStage  \n(Java name `org.hisp.dhis.program.ProgramStage`)")
    private RefProgramStage programStage;
    @JsonProperty("publicAccess")
    private String publicAccess;
    @JsonProperty("sharing")
    private Sharing sharing;
    @JsonProperty("shortName")
    private String shortName;
    @JsonProperty("translations")
    private List<Translation> translations = null;
    @JsonProperty("uid")
    private String uid;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private RefUser user;
    @JsonProperty("userAccesses")
    private List<UserAccess> userAccesses = null;
    @JsonProperty("userGroupAccesses")
    private List<UserGroupAccess> userGroupAccesses = null;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("valueType")
    private DimensionalObject.ValueType valueType;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -3726764948751136489L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DimensionalObject() {
    }

    /**
     * 
     * @param source
     */
    public DimensionalObject(DimensionalObject source) {
        super();
        this.access = source.access;
        this.aggregationType = source.aggregationType;
        this.allItems = source.allItems;
        this.analyticsType = source.analyticsType;
        this.attributeValues = source.attributeValues;
        this.code = source.code;
        this.created = source.created;
        this.createdBy = source.createdBy;
        this.dataDimension = source.dataDimension;
        this.dataDimensionType = source.dataDimensionType;
        this.description = source.description;
        this.dimension = source.dimension;
        this.dimensionDisplayName = source.dimensionDisplayName;
        this.dimensionItemKeywords = source.dimensionItemKeywords;
        this.dimensionName = source.dimensionName;
        this.dimensionType = source.dimensionType;
        this.displayDescription = source.displayDescription;
        this.displayName = source.displayName;
        this.displayShortName = source.displayShortName;
        this.eventRepetition = source.eventRepetition;
        this.externalAccess = source.externalAccess;
        this.favorite = source.favorite;
        this.favorites = source.favorites;
        this.filter = source.filter;
        this.fixed = source.fixed;
        this.groupUUID = source.groupUUID;
        this.href = source.href;
        this.id = source.id;
        this.items = source.items;
        this.key = source.key;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.legendSet = source.legendSet;
        this.name = source.name;
        this.optionSet = source.optionSet;
        this.programStage = source.programStage;
        this.publicAccess = source.publicAccess;
        this.sharing = source.sharing;
        this.shortName = source.shortName;
        this.translations = source.translations;
        this.uid = source.uid;
        this.user = source.user;
        this.userAccesses = source.userAccesses;
        this.userGroupAccesses = source.userGroupAccesses;
        this.valueType = source.valueType;
    }

    /**
     * 
     * @param dataDimensionType
     * @param dimensionItemKeywords
     * @param favorites
     * @param aggregationType
     * @param dimensionType
     * @param access
     * @param code
     * @param displayName
     * @param publicAccess
     * @param description
     * @param dimensionDisplayName
     * @param displayShortName
     * @param externalAccess
     * @param lastUpdated
     * @param uid
     * @param optionSet
     * @param translations
     * @param valueType
     * @param href
     * @param id
     * @param dimension
     * @param key
     * @param displayDescription
     * @param groupUUID
     * @param lastUpdatedBy
     * @param programStage
     * @param userGroupAccesses
     * @param allItems
     * @param created
     * @param attributeValues
     * @param eventRepetition
     * @param sharing
     * @param dimensionName
     * @param filter
     * @param createdBy
     * @param userAccesses
     * @param legendSet
     * @param name
     * @param analyticsType
     * @param fixed
     * @param dataDimension
     * @param shortName
     * @param favorite
     * @param items
     * @param user
     */
    public DimensionalObject(Access access, DimensionalObject.AggregationType aggregationType, Boolean allItems, DimensionalObject.AnalyticsType analyticsType, List<AttributeValue> attributeValues, String code, Date created, RefUser createdBy, Boolean dataDimension, DimensionalObject.DataDimensionType dataDimensionType, String description, String dimension, String dimensionDisplayName, DimensionItemKeywords dimensionItemKeywords, String dimensionName, DimensionalObject.DimensionType dimensionType, String displayDescription, String displayName, String displayShortName, EventRepetition eventRepetition, Boolean externalAccess, Boolean favorite, List<String> favorites, String filter, Boolean fixed, UUID groupUUID, String href, Integer id, Boolean items, String key, Date lastUpdated, RefUser lastUpdatedBy, Boolean legendSet, String name, RefOptionSet optionSet, RefProgramStage programStage, String publicAccess, Sharing sharing, String shortName, List<Translation> translations, String uid, RefUser user, List<UserAccess> userAccesses, List<UserGroupAccess> userGroupAccesses, DimensionalObject.ValueType valueType) {
        super();
        this.access = access;
        this.aggregationType = aggregationType;
        this.allItems = allItems;
        this.analyticsType = analyticsType;
        this.attributeValues = attributeValues;
        this.code = code;
        this.created = created;
        this.createdBy = createdBy;
        this.dataDimension = dataDimension;
        this.dataDimensionType = dataDimensionType;
        this.description = description;
        this.dimension = dimension;
        this.dimensionDisplayName = dimensionDisplayName;
        this.dimensionItemKeywords = dimensionItemKeywords;
        this.dimensionName = dimensionName;
        this.dimensionType = dimensionType;
        this.displayDescription = displayDescription;
        this.displayName = displayName;
        this.displayShortName = displayShortName;
        this.eventRepetition = eventRepetition;
        this.externalAccess = externalAccess;
        this.favorite = favorite;
        this.favorites = favorites;
        this.filter = filter;
        this.fixed = fixed;
        this.groupUUID = groupUUID;
        this.href = href;
        this.id = id;
        this.items = items;
        this.key = key;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedBy = lastUpdatedBy;
        this.legendSet = legendSet;
        this.name = name;
        this.optionSet = optionSet;
        this.programStage = programStage;
        this.publicAccess = publicAccess;
        this.sharing = sharing;
        this.shortName = shortName;
        this.translations = translations;
        this.uid = uid;
        this.user = user;
        this.userAccesses = userAccesses;
        this.userGroupAccesses = userGroupAccesses;
        this.valueType = valueType;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public DimensionalObject withAccess(Access access) {
        this.access = access;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("aggregationType")
    public DimensionalObject.AggregationType getAggregationType() {
        return aggregationType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("aggregationType")
    public void setAggregationType(DimensionalObject.AggregationType aggregationType) {
        this.aggregationType = aggregationType;
    }

    public DimensionalObject withAggregationType(DimensionalObject.AggregationType aggregationType) {
        this.aggregationType = aggregationType;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("allItems")
    public Boolean getAllItems() {
        return allItems;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("allItems")
    public void setAllItems(Boolean allItems) {
        this.allItems = allItems;
    }

    public DimensionalObject withAllItems(Boolean allItems) {
        this.allItems = allItems;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("analyticsType")
    public DimensionalObject.AnalyticsType getAnalyticsType() {
        return analyticsType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("analyticsType")
    public void setAnalyticsType(DimensionalObject.AnalyticsType analyticsType) {
        this.analyticsType = analyticsType;
    }

    public DimensionalObject withAnalyticsType(DimensionalObject.AnalyticsType analyticsType) {
        this.analyticsType = analyticsType;
        return this;
    }

    @JsonProperty("attributeValues")
    public Optional<List<AttributeValue>> getAttributeValues() {
        return Optional.ofNullable(attributeValues);
    }

    @JsonProperty("attributeValues")
    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public DimensionalObject withAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public DimensionalObject withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public DimensionalObject withCreated(Date created) {
        this.created = created;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    public Optional<RefUser> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    public void setCreatedBy(RefUser createdBy) {
        this.createdBy = createdBy;
    }

    public DimensionalObject withCreatedBy(RefUser createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dataDimension")
    public Boolean getDataDimension() {
        return dataDimension;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dataDimension")
    public void setDataDimension(Boolean dataDimension) {
        this.dataDimension = dataDimension;
    }

    public DimensionalObject withDataDimension(Boolean dataDimension) {
        this.dataDimension = dataDimension;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dataDimensionType")
    public DimensionalObject.DataDimensionType getDataDimensionType() {
        return dataDimensionType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dataDimensionType")
    public void setDataDimensionType(DimensionalObject.DataDimensionType dataDimensionType) {
        this.dataDimensionType = dataDimensionType;
    }

    public DimensionalObject withDataDimensionType(DimensionalObject.DataDimensionType dataDimensionType) {
        this.dataDimensionType = dataDimensionType;
        return this;
    }

    @JsonProperty("description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    public DimensionalObject withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty("dimension")
    public Optional<String> getDimension() {
        return Optional.ofNullable(dimension);
    }

    @JsonProperty("dimension")
    public void setDimension(String dimension) {
        this.dimension = dimension;
    }

    public DimensionalObject withDimension(String dimension) {
        this.dimension = dimension;
        return this;
    }

    @JsonProperty("dimensionDisplayName")
    public Optional<String> getDimensionDisplayName() {
        return Optional.ofNullable(dimensionDisplayName);
    }

    @JsonProperty("dimensionDisplayName")
    public void setDimensionDisplayName(String dimensionDisplayName) {
        this.dimensionDisplayName = dimensionDisplayName;
    }

    public DimensionalObject withDimensionDisplayName(String dimensionDisplayName) {
        this.dimensionDisplayName = dimensionDisplayName;
        return this;
    }

    @JsonProperty("dimensionItemKeywords")
    public Optional<DimensionItemKeywords> getDimensionItemKeywords() {
        return Optional.ofNullable(dimensionItemKeywords);
    }

    @JsonProperty("dimensionItemKeywords")
    public void setDimensionItemKeywords(DimensionItemKeywords dimensionItemKeywords) {
        this.dimensionItemKeywords = dimensionItemKeywords;
    }

    public DimensionalObject withDimensionItemKeywords(DimensionItemKeywords dimensionItemKeywords) {
        this.dimensionItemKeywords = dimensionItemKeywords;
        return this;
    }

    @JsonProperty("dimensionName")
    public Optional<String> getDimensionName() {
        return Optional.ofNullable(dimensionName);
    }

    @JsonProperty("dimensionName")
    public void setDimensionName(String dimensionName) {
        this.dimensionName = dimensionName;
    }

    public DimensionalObject withDimensionName(String dimensionName) {
        this.dimensionName = dimensionName;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dimensionType")
    public DimensionalObject.DimensionType getDimensionType() {
        return dimensionType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dimensionType")
    public void setDimensionType(DimensionalObject.DimensionType dimensionType) {
        this.dimensionType = dimensionType;
    }

    public DimensionalObject withDimensionType(DimensionalObject.DimensionType dimensionType) {
        this.dimensionType = dimensionType;
        return this;
    }

    @JsonProperty("displayDescription")
    public Optional<String> getDisplayDescription() {
        return Optional.ofNullable(displayDescription);
    }

    @JsonProperty("displayDescription")
    public void setDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
    }

    public DimensionalObject withDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public DimensionalObject withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("displayShortName")
    public Optional<String> getDisplayShortName() {
        return Optional.ofNullable(displayShortName);
    }

    @JsonProperty("displayShortName")
    public void setDisplayShortName(String displayShortName) {
        this.displayShortName = displayShortName;
    }

    public DimensionalObject withDisplayShortName(String displayShortName) {
        this.displayShortName = displayShortName;
        return this;
    }

    @JsonProperty("eventRepetition")
    public Optional<EventRepetition> getEventRepetition() {
        return Optional.ofNullable(eventRepetition);
    }

    @JsonProperty("eventRepetition")
    public void setEventRepetition(EventRepetition eventRepetition) {
        this.eventRepetition = eventRepetition;
    }

    public DimensionalObject withEventRepetition(EventRepetition eventRepetition) {
        this.eventRepetition = eventRepetition;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("externalAccess")
    public Boolean getExternalAccess() {
        return externalAccess;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public DimensionalObject withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("favorite")
    public Boolean getFavorite() {
        return favorite;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("favorite")
    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public DimensionalObject withFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public DimensionalObject withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    @JsonProperty("filter")
    public Optional<String> getFilter() {
        return Optional.ofNullable(filter);
    }

    @JsonProperty("filter")
    public void setFilter(String filter) {
        this.filter = filter;
    }

    public DimensionalObject withFilter(String filter) {
        this.filter = filter;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("fixed")
    public Boolean getFixed() {
        return fixed;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("fixed")
    public void setFixed(Boolean fixed) {
        this.fixed = fixed;
    }

    public DimensionalObject withFixed(Boolean fixed) {
        this.fixed = fixed;
        return this;
    }

    @JsonProperty("groupUUID")
    public Optional<UUID> getGroupUUID() {
        return Optional.ofNullable(groupUUID);
    }

    @JsonProperty("groupUUID")
    public void setGroupUUID(UUID groupUUID) {
        this.groupUUID = groupUUID;
    }

    public DimensionalObject withGroupUUID(UUID groupUUID) {
        this.groupUUID = groupUUID;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public DimensionalObject withHref(String href) {
        this.href = href;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("id")
    public Integer getId() {
        return id;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("id")
    public void setId(Integer id) {
        this.id = id;
    }

    public DimensionalObject withId(Integer id) {
        this.id = id;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("items")
    public Boolean getItems() {
        return items;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("items")
    public void setItems(Boolean items) {
        this.items = items;
    }

    public DimensionalObject withItems(Boolean items) {
        this.items = items;
        return this;
    }

    @JsonProperty("key")
    public Optional<String> getKey() {
        return Optional.ofNullable(key);
    }

    @JsonProperty("key")
    public void setKey(String key) {
        this.key = key;
    }

    public DimensionalObject withKey(String key) {
        this.key = key;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public DimensionalObject withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    public Optional<RefUser> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(RefUser lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public DimensionalObject withLastUpdatedBy(RefUser lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("legendSet")
    public Boolean getLegendSet() {
        return legendSet;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("legendSet")
    public void setLegendSet(Boolean legendSet) {
        this.legendSet = legendSet;
    }

    public DimensionalObject withLegendSet(Boolean legendSet) {
        this.legendSet = legendSet;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public DimensionalObject withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * A UID reference to a OptionSet  
     * (Java name `org.hisp.dhis.option.OptionSet`)
     * 
     */
    @JsonProperty("optionSet")
    public Optional<RefOptionSet> getOptionSet() {
        return Optional.ofNullable(optionSet);
    }

    /**
     * A UID reference to a OptionSet  
     * (Java name `org.hisp.dhis.option.OptionSet`)
     * 
     */
    @JsonProperty("optionSet")
    public void setOptionSet(RefOptionSet optionSet) {
        this.optionSet = optionSet;
    }

    public DimensionalObject withOptionSet(RefOptionSet optionSet) {
        this.optionSet = optionSet;
        return this;
    }

    /**
     * A UID reference to a ProgramStage  
     * (Java name `org.hisp.dhis.program.ProgramStage`)
     * 
     */
    @JsonProperty("programStage")
    public Optional<RefProgramStage> getProgramStage() {
        return Optional.ofNullable(programStage);
    }

    /**
     * A UID reference to a ProgramStage  
     * (Java name `org.hisp.dhis.program.ProgramStage`)
     * 
     */
    @JsonProperty("programStage")
    public void setProgramStage(RefProgramStage programStage) {
        this.programStage = programStage;
    }

    public DimensionalObject withProgramStage(RefProgramStage programStage) {
        this.programStage = programStage;
        return this;
    }

    @JsonProperty("publicAccess")
    public Optional<String> getPublicAccess() {
        return Optional.ofNullable(publicAccess);
    }

    @JsonProperty("publicAccess")
    public void setPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
    }

    public DimensionalObject withPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    @JsonProperty("sharing")
    public Optional<Sharing> getSharing() {
        return Optional.ofNullable(sharing);
    }

    @JsonProperty("sharing")
    public void setSharing(Sharing sharing) {
        this.sharing = sharing;
    }

    public DimensionalObject withSharing(Sharing sharing) {
        this.sharing = sharing;
        return this;
    }

    @JsonProperty("shortName")
    public Optional<String> getShortName() {
        return Optional.ofNullable(shortName);
    }

    @JsonProperty("shortName")
    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public DimensionalObject withShortName(String shortName) {
        this.shortName = shortName;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public DimensionalObject withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    @JsonProperty("uid")
    public Optional<String> getUid() {
        return Optional.ofNullable(uid);
    }

    @JsonProperty("uid")
    public void setUid(String uid) {
        this.uid = uid;
    }

    public DimensionalObject withUid(String uid) {
        this.uid = uid;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    public Optional<RefUser> getUser() {
        return Optional.ofNullable(user);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    public void setUser(RefUser user) {
        this.user = user;
    }

    public DimensionalObject withUser(RefUser user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<UserAccess>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public DimensionalObject withUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<UserGroupAccess>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public DimensionalObject withUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("valueType")
    public DimensionalObject.ValueType getValueType() {
        return valueType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("valueType")
    public void setValueType(DimensionalObject.ValueType valueType) {
        this.valueType = valueType;
    }

    public DimensionalObject withValueType(DimensionalObject.ValueType valueType) {
        this.valueType = valueType;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public DimensionalObject withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "access":
                if (value instanceof Access) {
                    setAccess(((Access) value));
                } else {
                    throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v40_0.Access\", but got "+ value.getClass().toString()));
                }
                return true;
            case "aggregationType":
                if (value instanceof DimensionalObject.AggregationType) {
                    setAggregationType(((DimensionalObject.AggregationType) value));
                } else {
                    throw new IllegalArgumentException(("property \"aggregationType\" is of type \"org.hisp.dhis.api.model.v40_0.DimensionalObject.AggregationType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "allItems":
                if (value instanceof Boolean) {
                    setAllItems(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"allItems\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "analyticsType":
                if (value instanceof DimensionalObject.AnalyticsType) {
                    setAnalyticsType(((DimensionalObject.AnalyticsType) value));
                } else {
                    throw new IllegalArgumentException(("property \"analyticsType\" is of type \"org.hisp.dhis.api.model.v40_0.DimensionalObject.AnalyticsType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "attributeValues":
                if (value instanceof List) {
                    setAttributeValues(((List<AttributeValue> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.AttributeValue>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "code":
                if (value instanceof String) {
                    setCode(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "created":
                if (value instanceof Date) {
                    setCreated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "createdBy":
                if (value instanceof RefUser) {
                    setCreatedBy(((RefUser) value));
                } else {
                    throw new IllegalArgumentException(("property \"createdBy\" is of type \"org.hisp.dhis.api.model.v40_0.RefUser\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataDimension":
                if (value instanceof Boolean) {
                    setDataDimension(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataDimension\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataDimensionType":
                if (value instanceof DimensionalObject.DataDimensionType) {
                    setDataDimensionType(((DimensionalObject.DataDimensionType) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataDimensionType\" is of type \"org.hisp.dhis.api.model.v40_0.DimensionalObject.DataDimensionType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "description":
                if (value instanceof String) {
                    setDescription(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"description\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dimension":
                if (value instanceof String) {
                    setDimension(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"dimension\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dimensionDisplayName":
                if (value instanceof String) {
                    setDimensionDisplayName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"dimensionDisplayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dimensionItemKeywords":
                if (value instanceof DimensionItemKeywords) {
                    setDimensionItemKeywords(((DimensionItemKeywords) value));
                } else {
                    throw new IllegalArgumentException(("property \"dimensionItemKeywords\" is of type \"org.hisp.dhis.api.model.v40_0.DimensionItemKeywords\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dimensionName":
                if (value instanceof String) {
                    setDimensionName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"dimensionName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dimensionType":
                if (value instanceof DimensionalObject.DimensionType) {
                    setDimensionType(((DimensionalObject.DimensionType) value));
                } else {
                    throw new IllegalArgumentException(("property \"dimensionType\" is of type \"org.hisp.dhis.api.model.v40_0.DimensionalObject.DimensionType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayDescription":
                if (value instanceof String) {
                    setDisplayDescription(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayDescription\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayName":
                if (value instanceof String) {
                    setDisplayName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayShortName":
                if (value instanceof String) {
                    setDisplayShortName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayShortName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "eventRepetition":
                if (value instanceof EventRepetition) {
                    setEventRepetition(((EventRepetition) value));
                } else {
                    throw new IllegalArgumentException(("property \"eventRepetition\" is of type \"org.hisp.dhis.api.model.v40_0.EventRepetition\", but got "+ value.getClass().toString()));
                }
                return true;
            case "externalAccess":
                if (value instanceof Boolean) {
                    setExternalAccess(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "favorite":
                if (value instanceof Boolean) {
                    setFavorite(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"favorite\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "favorites":
                if (value instanceof List) {
                    setFavorites(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "filter":
                if (value instanceof String) {
                    setFilter(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"filter\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "fixed":
                if (value instanceof Boolean) {
                    setFixed(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"fixed\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "groupUUID":
                if (value instanceof UUID) {
                    setGroupUUID(((UUID) value));
                } else {
                    throw new IllegalArgumentException(("property \"groupUUID\" is of type \"java.util.UUID\", but got "+ value.getClass().toString()));
                }
                return true;
            case "href":
                if (value instanceof String) {
                    setHref(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "id":
                if (value instanceof Integer) {
                    setId(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "items":
                if (value instanceof Boolean) {
                    setItems(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"items\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "key":
                if (value instanceof String) {
                    setKey(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"key\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdated":
                if (value instanceof Date) {
                    setLastUpdated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdatedBy":
                if (value instanceof RefUser) {
                    setLastUpdatedBy(((RefUser) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"org.hisp.dhis.api.model.v40_0.RefUser\", but got "+ value.getClass().toString()));
                }
                return true;
            case "legendSet":
                if (value instanceof Boolean) {
                    setLegendSet(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"legendSet\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "name":
                if (value instanceof String) {
                    setName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "optionSet":
                if (value instanceof RefOptionSet) {
                    setOptionSet(((RefOptionSet) value));
                } else {
                    throw new IllegalArgumentException(("property \"optionSet\" is of type \"org.hisp.dhis.api.model.v40_0.RefOptionSet\", but got "+ value.getClass().toString()));
                }
                return true;
            case "programStage":
                if (value instanceof RefProgramStage) {
                    setProgramStage(((RefProgramStage) value));
                } else {
                    throw new IllegalArgumentException(("property \"programStage\" is of type \"org.hisp.dhis.api.model.v40_0.RefProgramStage\", but got "+ value.getClass().toString()));
                }
                return true;
            case "publicAccess":
                if (value instanceof String) {
                    setPublicAccess(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"publicAccess\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "sharing":
                if (value instanceof Sharing) {
                    setSharing(((Sharing) value));
                } else {
                    throw new IllegalArgumentException(("property \"sharing\" is of type \"org.hisp.dhis.api.model.v40_0.Sharing\", but got "+ value.getClass().toString()));
                }
                return true;
            case "shortName":
                if (value instanceof String) {
                    setShortName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"shortName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "translations":
                if (value instanceof List) {
                    setTranslations(((List<Translation> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.Translation>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "uid":
                if (value instanceof String) {
                    setUid(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"uid\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "user":
                if (value instanceof RefUser) {
                    setUser(((RefUser) value));
                } else {
                    throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v40_0.RefUser\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userAccesses":
                if (value instanceof List) {
                    setUserAccesses(((List<UserAccess> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.UserAccess>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userGroupAccesses":
                if (value instanceof List) {
                    setUserGroupAccesses(((List<UserGroupAccess> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.UserGroupAccess>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "valueType":
                if (value instanceof DimensionalObject.ValueType) {
                    setValueType(((DimensionalObject.ValueType) value));
                } else {
                    throw new IllegalArgumentException(("property \"valueType\" is of type \"org.hisp.dhis.api.model.v40_0.DimensionalObject.ValueType\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "access":
                return getAccess();
            case "aggregationType":
                return getAggregationType();
            case "allItems":
                return getAllItems();
            case "analyticsType":
                return getAnalyticsType();
            case "attributeValues":
                return getAttributeValues();
            case "code":
                return getCode();
            case "created":
                return getCreated();
            case "createdBy":
                return getCreatedBy();
            case "dataDimension":
                return getDataDimension();
            case "dataDimensionType":
                return getDataDimensionType();
            case "description":
                return getDescription();
            case "dimension":
                return getDimension();
            case "dimensionDisplayName":
                return getDimensionDisplayName();
            case "dimensionItemKeywords":
                return getDimensionItemKeywords();
            case "dimensionName":
                return getDimensionName();
            case "dimensionType":
                return getDimensionType();
            case "displayDescription":
                return getDisplayDescription();
            case "displayName":
                return getDisplayName();
            case "displayShortName":
                return getDisplayShortName();
            case "eventRepetition":
                return getEventRepetition();
            case "externalAccess":
                return getExternalAccess();
            case "favorite":
                return getFavorite();
            case "favorites":
                return getFavorites();
            case "filter":
                return getFilter();
            case "fixed":
                return getFixed();
            case "groupUUID":
                return getGroupUUID();
            case "href":
                return getHref();
            case "id":
                return getId();
            case "items":
                return getItems();
            case "key":
                return getKey();
            case "lastUpdated":
                return getLastUpdated();
            case "lastUpdatedBy":
                return getLastUpdatedBy();
            case "legendSet":
                return getLegendSet();
            case "name":
                return getName();
            case "optionSet":
                return getOptionSet();
            case "programStage":
                return getProgramStage();
            case "publicAccess":
                return getPublicAccess();
            case "sharing":
                return getSharing();
            case "shortName":
                return getShortName();
            case "translations":
                return getTranslations();
            case "uid":
                return getUid();
            case "user":
                return getUser();
            case "userAccesses":
                return getUserAccesses();
            case "userGroupAccesses":
                return getUserGroupAccesses();
            case "valueType":
                return getValueType();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, DimensionalObject.NOT_FOUND_VALUE);
        if (DimensionalObject.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public DimensionalObject with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DimensionalObject.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("aggregationType");
        sb.append('=');
        sb.append(((this.aggregationType == null)?"<null>":this.aggregationType));
        sb.append(',');
        sb.append("allItems");
        sb.append('=');
        sb.append(((this.allItems == null)?"<null>":this.allItems));
        sb.append(',');
        sb.append("analyticsType");
        sb.append('=');
        sb.append(((this.analyticsType == null)?"<null>":this.analyticsType));
        sb.append(',');
        sb.append("attributeValues");
        sb.append('=');
        sb.append(((this.attributeValues == null)?"<null>":this.attributeValues));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("createdBy");
        sb.append('=');
        sb.append(((this.createdBy == null)?"<null>":this.createdBy));
        sb.append(',');
        sb.append("dataDimension");
        sb.append('=');
        sb.append(((this.dataDimension == null)?"<null>":this.dataDimension));
        sb.append(',');
        sb.append("dataDimensionType");
        sb.append('=');
        sb.append(((this.dataDimensionType == null)?"<null>":this.dataDimensionType));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("dimension");
        sb.append('=');
        sb.append(((this.dimension == null)?"<null>":this.dimension));
        sb.append(',');
        sb.append("dimensionDisplayName");
        sb.append('=');
        sb.append(((this.dimensionDisplayName == null)?"<null>":this.dimensionDisplayName));
        sb.append(',');
        sb.append("dimensionItemKeywords");
        sb.append('=');
        sb.append(((this.dimensionItemKeywords == null)?"<null>":this.dimensionItemKeywords));
        sb.append(',');
        sb.append("dimensionName");
        sb.append('=');
        sb.append(((this.dimensionName == null)?"<null>":this.dimensionName));
        sb.append(',');
        sb.append("dimensionType");
        sb.append('=');
        sb.append(((this.dimensionType == null)?"<null>":this.dimensionType));
        sb.append(',');
        sb.append("displayDescription");
        sb.append('=');
        sb.append(((this.displayDescription == null)?"<null>":this.displayDescription));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("displayShortName");
        sb.append('=');
        sb.append(((this.displayShortName == null)?"<null>":this.displayShortName));
        sb.append(',');
        sb.append("eventRepetition");
        sb.append('=');
        sb.append(((this.eventRepetition == null)?"<null>":this.eventRepetition));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("favorite");
        sb.append('=');
        sb.append(((this.favorite == null)?"<null>":this.favorite));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("filter");
        sb.append('=');
        sb.append(((this.filter == null)?"<null>":this.filter));
        sb.append(',');
        sb.append("fixed");
        sb.append('=');
        sb.append(((this.fixed == null)?"<null>":this.fixed));
        sb.append(',');
        sb.append("groupUUID");
        sb.append('=');
        sb.append(((this.groupUUID == null)?"<null>":this.groupUUID));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("items");
        sb.append('=');
        sb.append(((this.items == null)?"<null>":this.items));
        sb.append(',');
        sb.append("key");
        sb.append('=');
        sb.append(((this.key == null)?"<null>":this.key));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("legendSet");
        sb.append('=');
        sb.append(((this.legendSet == null)?"<null>":this.legendSet));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("optionSet");
        sb.append('=');
        sb.append(((this.optionSet == null)?"<null>":this.optionSet));
        sb.append(',');
        sb.append("programStage");
        sb.append('=');
        sb.append(((this.programStage == null)?"<null>":this.programStage));
        sb.append(',');
        sb.append("publicAccess");
        sb.append('=');
        sb.append(((this.publicAccess == null)?"<null>":this.publicAccess));
        sb.append(',');
        sb.append("sharing");
        sb.append('=');
        sb.append(((this.sharing == null)?"<null>":this.sharing));
        sb.append(',');
        sb.append("shortName");
        sb.append('=');
        sb.append(((this.shortName == null)?"<null>":this.shortName));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("uid");
        sb.append('=');
        sb.append(((this.uid == null)?"<null>":this.uid));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("valueType");
        sb.append('=');
        sb.append(((this.valueType == null)?"<null>":this.valueType));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.dataDimensionType == null)? 0 :this.dataDimensionType.hashCode()));
        result = ((result* 31)+((this.dimensionItemKeywords == null)? 0 :this.dimensionItemKeywords.hashCode()));
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.aggregationType == null)? 0 :this.aggregationType.hashCode()));
        result = ((result* 31)+((this.dimensionType == null)? 0 :this.dimensionType.hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.publicAccess == null)? 0 :this.publicAccess.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.dimensionDisplayName == null)? 0 :this.dimensionDisplayName.hashCode()));
        result = ((result* 31)+((this.displayShortName == null)? 0 :this.displayShortName.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.uid == null)? 0 :this.uid.hashCode()));
        result = ((result* 31)+((this.optionSet == null)? 0 :this.optionSet.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.valueType == null)? 0 :this.valueType.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.dimension == null)? 0 :this.dimension.hashCode()));
        result = ((result* 31)+((this.key == null)? 0 :this.key.hashCode()));
        result = ((result* 31)+((this.displayDescription == null)? 0 :this.displayDescription.hashCode()));
        result = ((result* 31)+((this.groupUUID == null)? 0 :this.groupUUID.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.programStage == null)? 0 :this.programStage.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.allItems == null)? 0 :this.allItems.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.attributeValues == null)? 0 :this.attributeValues.hashCode()));
        result = ((result* 31)+((this.eventRepetition == null)? 0 :this.eventRepetition.hashCode()));
        result = ((result* 31)+((this.sharing == null)? 0 :this.sharing.hashCode()));
        result = ((result* 31)+((this.dimensionName == null)? 0 :this.dimensionName.hashCode()));
        result = ((result* 31)+((this.filter == null)? 0 :this.filter.hashCode()));
        result = ((result* 31)+((this.createdBy == null)? 0 :this.createdBy.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.legendSet == null)? 0 :this.legendSet.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.analyticsType == null)? 0 :this.analyticsType.hashCode()));
        result = ((result* 31)+((this.fixed == null)? 0 :this.fixed.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.dataDimension == null)? 0 :this.dataDimension.hashCode()));
        result = ((result* 31)+((this.shortName == null)? 0 :this.shortName.hashCode()));
        result = ((result* 31)+((this.favorite == null)? 0 :this.favorite.hashCode()));
        result = ((result* 31)+((this.items == null)? 0 :this.items.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof DimensionalObject) == false) {
            return false;
        }
        DimensionalObject rhs = ((DimensionalObject) other);
        return (((((((((((((((((((((((((((((((((((((((((((((((this.dataDimensionType == rhs.dataDimensionType)||((this.dataDimensionType!= null)&&this.dataDimensionType.equals(rhs.dataDimensionType)))&&((this.dimensionItemKeywords == rhs.dimensionItemKeywords)||((this.dimensionItemKeywords!= null)&&this.dimensionItemKeywords.equals(rhs.dimensionItemKeywords))))&&((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites))))&&((this.aggregationType == rhs.aggregationType)||((this.aggregationType!= null)&&this.aggregationType.equals(rhs.aggregationType))))&&((this.dimensionType == rhs.dimensionType)||((this.dimensionType!= null)&&this.dimensionType.equals(rhs.dimensionType))))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.publicAccess == rhs.publicAccess)||((this.publicAccess!= null)&&this.publicAccess.equals(rhs.publicAccess))))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.dimensionDisplayName == rhs.dimensionDisplayName)||((this.dimensionDisplayName!= null)&&this.dimensionDisplayName.equals(rhs.dimensionDisplayName))))&&((this.displayShortName == rhs.displayShortName)||((this.displayShortName!= null)&&this.displayShortName.equals(rhs.displayShortName))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.uid == rhs.uid)||((this.uid!= null)&&this.uid.equals(rhs.uid))))&&((this.optionSet == rhs.optionSet)||((this.optionSet!= null)&&this.optionSet.equals(rhs.optionSet))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.valueType == rhs.valueType)||((this.valueType!= null)&&this.valueType.equals(rhs.valueType))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.dimension == rhs.dimension)||((this.dimension!= null)&&this.dimension.equals(rhs.dimension))))&&((this.key == rhs.key)||((this.key!= null)&&this.key.equals(rhs.key))))&&((this.displayDescription == rhs.displayDescription)||((this.displayDescription!= null)&&this.displayDescription.equals(rhs.displayDescription))))&&((this.groupUUID == rhs.groupUUID)||((this.groupUUID!= null)&&this.groupUUID.equals(rhs.groupUUID))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.programStage == rhs.programStage)||((this.programStage!= null)&&this.programStage.equals(rhs.programStage))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.allItems == rhs.allItems)||((this.allItems!= null)&&this.allItems.equals(rhs.allItems))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.attributeValues == rhs.attributeValues)||((this.attributeValues!= null)&&this.attributeValues.equals(rhs.attributeValues))))&&((this.eventRepetition == rhs.eventRepetition)||((this.eventRepetition!= null)&&this.eventRepetition.equals(rhs.eventRepetition))))&&((this.sharing == rhs.sharing)||((this.sharing!= null)&&this.sharing.equals(rhs.sharing))))&&((this.dimensionName == rhs.dimensionName)||((this.dimensionName!= null)&&this.dimensionName.equals(rhs.dimensionName))))&&((this.filter == rhs.filter)||((this.filter!= null)&&this.filter.equals(rhs.filter))))&&((this.createdBy == rhs.createdBy)||((this.createdBy!= null)&&this.createdBy.equals(rhs.createdBy))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.legendSet == rhs.legendSet)||((this.legendSet!= null)&&this.legendSet.equals(rhs.legendSet))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.analyticsType == rhs.analyticsType)||((this.analyticsType!= null)&&this.analyticsType.equals(rhs.analyticsType))))&&((this.fixed == rhs.fixed)||((this.fixed!= null)&&this.fixed.equals(rhs.fixed))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.dataDimension == rhs.dataDimension)||((this.dataDimension!= null)&&this.dataDimension.equals(rhs.dataDimension))))&&((this.shortName == rhs.shortName)||((this.shortName!= null)&&this.shortName.equals(rhs.shortName))))&&((this.favorite == rhs.favorite)||((this.favorite!= null)&&this.favorite.equals(rhs.favorite))))&&((this.items == rhs.items)||((this.items!= null)&&this.items.equals(rhs.items))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))));
    }

    @Generated("jsonschema2pojo")
    public enum AggregationType {

        SUM("SUM"),
        AVERAGE("AVERAGE"),
        AVERAGE_SUM_ORG_UNIT("AVERAGE_SUM_ORG_UNIT"),
        LAST("LAST"),
        LAST_AVERAGE_ORG_UNIT("LAST_AVERAGE_ORG_UNIT"),
        LAST_LAST_ORG_UNIT("LAST_LAST_ORG_UNIT"),
        LAST_IN_PERIOD("LAST_IN_PERIOD"),
        LAST_IN_PERIOD_AVERAGE_ORG_UNIT("LAST_IN_PERIOD_AVERAGE_ORG_UNIT"),
        FIRST("FIRST"),
        FIRST_AVERAGE_ORG_UNIT("FIRST_AVERAGE_ORG_UNIT"),
        FIRST_FIRST_ORG_UNIT("FIRST_FIRST_ORG_UNIT"),
        COUNT("COUNT"),
        STDDEV("STDDEV"),
        VARIANCE("VARIANCE"),
        MIN("MIN"),
        MAX("MAX"),
        MIN_SUM_ORG_UNIT("MIN_SUM_ORG_UNIT"),
        MAX_SUM_ORG_UNIT("MAX_SUM_ORG_UNIT"),
        NONE("NONE"),
        CUSTOM("CUSTOM"),
        DEFAULT("DEFAULT");
        private final String value;
        private final static Map<String, DimensionalObject.AggregationType> CONSTANTS = new HashMap<String, DimensionalObject.AggregationType>();

        static {
            for (DimensionalObject.AggregationType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        AggregationType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DimensionalObject.AggregationType fromValue(String value) {
            DimensionalObject.AggregationType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum AnalyticsType {

        AGGREGATE("AGGREGATE"),
        EVENT("EVENT");
        private final String value;
        private final static Map<String, DimensionalObject.AnalyticsType> CONSTANTS = new HashMap<String, DimensionalObject.AnalyticsType>();

        static {
            for (DimensionalObject.AnalyticsType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        AnalyticsType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DimensionalObject.AnalyticsType fromValue(String value) {
            DimensionalObject.AnalyticsType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum DataDimensionType {

        DISAGGREGATION("DISAGGREGATION"),
        ATTRIBUTE("ATTRIBUTE");
        private final String value;
        private final static Map<String, DimensionalObject.DataDimensionType> CONSTANTS = new HashMap<String, DimensionalObject.DataDimensionType>();

        static {
            for (DimensionalObject.DataDimensionType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        DataDimensionType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DimensionalObject.DataDimensionType fromValue(String value) {
            DimensionalObject.DataDimensionType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum DimensionType {

        DATA_X("DATA_X"),
        PROGRAM_DATA_ELEMENT("PROGRAM_DATA_ELEMENT"),
        PROGRAM_ATTRIBUTE("PROGRAM_ATTRIBUTE"),
        PROGRAM_INDICATOR("PROGRAM_INDICATOR"),
        DATA_COLLAPSED("DATA_COLLAPSED"),
        CATEGORY_OPTION_COMBO("CATEGORY_OPTION_COMBO"),
        ATTRIBUTE_OPTION_COMBO("ATTRIBUTE_OPTION_COMBO"),
        PERIOD("PERIOD"),
        ORGANISATION_UNIT("ORGANISATION_UNIT"),
        CATEGORY_OPTION_GROUP_SET("CATEGORY_OPTION_GROUP_SET"),
        DATA_ELEMENT_GROUP_SET("DATA_ELEMENT_GROUP_SET"),
        ORGANISATION_UNIT_GROUP_SET("ORGANISATION_UNIT_GROUP_SET"),
        ORGANISATION_UNIT_GROUP("ORGANISATION_UNIT_GROUP"),
        CATEGORY("CATEGORY"),
        OPTION_GROUP_SET("OPTION_GROUP_SET"),
        VALIDATION_RULE("VALIDATION_RULE"),
        STATIC("STATIC"),
        ORGANISATION_UNIT_LEVEL("ORGANISATION_UNIT_LEVEL");
        private final String value;
        private final static Map<String, DimensionalObject.DimensionType> CONSTANTS = new HashMap<String, DimensionalObject.DimensionType>();

        static {
            for (DimensionalObject.DimensionType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        DimensionType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DimensionalObject.DimensionType fromValue(String value) {
            DimensionalObject.DimensionType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum ValueType {

        TEXT("TEXT"),
        LONG_TEXT("LONG_TEXT"),
        MULTI_TEXT("MULTI_TEXT"),
        LETTER("LETTER"),
        PHONE_NUMBER("PHONE_NUMBER"),
        EMAIL("EMAIL"),
        BOOLEAN("BOOLEAN"),
        TRUE_ONLY("TRUE_ONLY"),
        DATE("DATE"),
        DATETIME("DATETIME"),
        TIME("TIME"),
        NUMBER("NUMBER"),
        UNIT_INTERVAL("UNIT_INTERVAL"),
        PERCENTAGE("PERCENTAGE"),
        INTEGER("INTEGER"),
        INTEGER_POSITIVE("INTEGER_POSITIVE"),
        INTEGER_NEGATIVE("INTEGER_NEGATIVE"),
        INTEGER_ZERO_OR_POSITIVE("INTEGER_ZERO_OR_POSITIVE"),
        TRACKER_ASSOCIATE("TRACKER_ASSOCIATE"),
        USERNAME("USERNAME"),
        COORDINATE("COORDINATE"),
        ORGANISATION_UNIT("ORGANISATION_UNIT"),
        REFERENCE("REFERENCE"),
        AGE("AGE"),
        URL("URL"),
        FILE_RESOURCE("FILE_RESOURCE"),
        IMAGE("IMAGE"),
        GEOJSON("GEOJSON");
        private final String value;
        private final static Map<String, DimensionalObject.ValueType> CONSTANTS = new HashMap<String, DimensionalObject.ValueType>();

        static {
            for (DimensionalObject.ValueType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ValueType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DimensionalObject.ValueType fromValue(String value) {
            DimensionalObject.ValueType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
