
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "attributeOptionComboId",
    "categoryOptionComboId",
    "categoryOptionComboName",
    "comment",
    "dataElementId",
    "dataElementName",
    "deleted",
    "followup",
    "max",
    "min",
    "period",
    "periodId",
    "sourceId",
    "sourceName",
    "sourcePath",
    "value"
})
@Generated("jsonschema2pojo")
public class DeflatedDataValue implements Serializable
{

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("attributeOptionComboId")
    private Integer attributeOptionComboId;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("categoryOptionComboId")
    private Integer categoryOptionComboId;
    @JsonProperty("categoryOptionComboName")
    private String categoryOptionComboName;
    @JsonProperty("comment")
    private String comment;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dataElementId")
    private Integer dataElementId;
    @JsonProperty("dataElementName")
    private String dataElementName;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("deleted")
    private Boolean deleted;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("followup")
    private Boolean followup;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("max")
    private Integer max;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("min")
    private Integer min;
    @JsonProperty("period")
    private String period;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("periodId")
    private Integer periodId;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("sourceId")
    private Integer sourceId;
    @JsonProperty("sourceName")
    private String sourceName;
    @JsonProperty("sourcePath")
    private String sourcePath;
    @JsonProperty("value")
    private String value;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -6477596415096561502L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DeflatedDataValue() {
    }

    /**
     * 
     * @param source
     */
    public DeflatedDataValue(DeflatedDataValue source) {
        super();
        this.attributeOptionComboId = source.attributeOptionComboId;
        this.categoryOptionComboId = source.categoryOptionComboId;
        this.categoryOptionComboName = source.categoryOptionComboName;
        this.comment = source.comment;
        this.dataElementId = source.dataElementId;
        this.dataElementName = source.dataElementName;
        this.deleted = source.deleted;
        this.followup = source.followup;
        this.max = source.max;
        this.min = source.min;
        this.period = source.period;
        this.periodId = source.periodId;
        this.sourceId = source.sourceId;
        this.sourceName = source.sourceName;
        this.sourcePath = source.sourcePath;
        this.value = source.value;
    }

    /**
     * 
     * @param sourceId
     * @param periodId
     * @param dataElementName
     * @param period
     * @param max
     * @param attributeOptionComboId
     * @param categoryOptionComboName
     * @param dataElementId
     * @param followup
     * @param deleted
     * @param min
     * @param comment
     * @param sourceName
     * @param categoryOptionComboId
     * @param value
     * @param sourcePath
     */
    public DeflatedDataValue(Integer attributeOptionComboId, Integer categoryOptionComboId, String categoryOptionComboName, String comment, Integer dataElementId, String dataElementName, Boolean deleted, Boolean followup, Integer max, Integer min, String period, Integer periodId, Integer sourceId, String sourceName, String sourcePath, String value) {
        super();
        this.attributeOptionComboId = attributeOptionComboId;
        this.categoryOptionComboId = categoryOptionComboId;
        this.categoryOptionComboName = categoryOptionComboName;
        this.comment = comment;
        this.dataElementId = dataElementId;
        this.dataElementName = dataElementName;
        this.deleted = deleted;
        this.followup = followup;
        this.max = max;
        this.min = min;
        this.period = period;
        this.periodId = periodId;
        this.sourceId = sourceId;
        this.sourceName = sourceName;
        this.sourcePath = sourcePath;
        this.value = value;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("attributeOptionComboId")
    public Integer getAttributeOptionComboId() {
        return attributeOptionComboId;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("attributeOptionComboId")
    public void setAttributeOptionComboId(Integer attributeOptionComboId) {
        this.attributeOptionComboId = attributeOptionComboId;
    }

    public DeflatedDataValue withAttributeOptionComboId(Integer attributeOptionComboId) {
        this.attributeOptionComboId = attributeOptionComboId;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("categoryOptionComboId")
    public Integer getCategoryOptionComboId() {
        return categoryOptionComboId;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("categoryOptionComboId")
    public void setCategoryOptionComboId(Integer categoryOptionComboId) {
        this.categoryOptionComboId = categoryOptionComboId;
    }

    public DeflatedDataValue withCategoryOptionComboId(Integer categoryOptionComboId) {
        this.categoryOptionComboId = categoryOptionComboId;
        return this;
    }

    @JsonProperty("categoryOptionComboName")
    public Optional<String> getCategoryOptionComboName() {
        return Optional.ofNullable(categoryOptionComboName);
    }

    @JsonProperty("categoryOptionComboName")
    public void setCategoryOptionComboName(String categoryOptionComboName) {
        this.categoryOptionComboName = categoryOptionComboName;
    }

    public DeflatedDataValue withCategoryOptionComboName(String categoryOptionComboName) {
        this.categoryOptionComboName = categoryOptionComboName;
        return this;
    }

    @JsonProperty("comment")
    public Optional<String> getComment() {
        return Optional.ofNullable(comment);
    }

    @JsonProperty("comment")
    public void setComment(String comment) {
        this.comment = comment;
    }

    public DeflatedDataValue withComment(String comment) {
        this.comment = comment;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dataElementId")
    public Integer getDataElementId() {
        return dataElementId;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dataElementId")
    public void setDataElementId(Integer dataElementId) {
        this.dataElementId = dataElementId;
    }

    public DeflatedDataValue withDataElementId(Integer dataElementId) {
        this.dataElementId = dataElementId;
        return this;
    }

    @JsonProperty("dataElementName")
    public Optional<String> getDataElementName() {
        return Optional.ofNullable(dataElementName);
    }

    @JsonProperty("dataElementName")
    public void setDataElementName(String dataElementName) {
        this.dataElementName = dataElementName;
    }

    public DeflatedDataValue withDataElementName(String dataElementName) {
        this.dataElementName = dataElementName;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("deleted")
    public Boolean getDeleted() {
        return deleted;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("deleted")
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public DeflatedDataValue withDeleted(Boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("followup")
    public Boolean getFollowup() {
        return followup;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("followup")
    public void setFollowup(Boolean followup) {
        this.followup = followup;
    }

    public DeflatedDataValue withFollowup(Boolean followup) {
        this.followup = followup;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("max")
    public Integer getMax() {
        return max;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("max")
    public void setMax(Integer max) {
        this.max = max;
    }

    public DeflatedDataValue withMax(Integer max) {
        this.max = max;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("min")
    public Integer getMin() {
        return min;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("min")
    public void setMin(Integer min) {
        this.min = min;
    }

    public DeflatedDataValue withMin(Integer min) {
        this.min = min;
        return this;
    }

    @JsonProperty("period")
    public Optional<String> getPeriod() {
        return Optional.ofNullable(period);
    }

    @JsonProperty("period")
    public void setPeriod(String period) {
        this.period = period;
    }

    public DeflatedDataValue withPeriod(String period) {
        this.period = period;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("periodId")
    public Integer getPeriodId() {
        return periodId;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("periodId")
    public void setPeriodId(Integer periodId) {
        this.periodId = periodId;
    }

    public DeflatedDataValue withPeriodId(Integer periodId) {
        this.periodId = periodId;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("sourceId")
    public Integer getSourceId() {
        return sourceId;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("sourceId")
    public void setSourceId(Integer sourceId) {
        this.sourceId = sourceId;
    }

    public DeflatedDataValue withSourceId(Integer sourceId) {
        this.sourceId = sourceId;
        return this;
    }

    @JsonProperty("sourceName")
    public Optional<String> getSourceName() {
        return Optional.ofNullable(sourceName);
    }

    @JsonProperty("sourceName")
    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public DeflatedDataValue withSourceName(String sourceName) {
        this.sourceName = sourceName;
        return this;
    }

    @JsonProperty("sourcePath")
    public Optional<String> getSourcePath() {
        return Optional.ofNullable(sourcePath);
    }

    @JsonProperty("sourcePath")
    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    public DeflatedDataValue withSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
        return this;
    }

    @JsonProperty("value")
    public Optional<String> getValue() {
        return Optional.ofNullable(value);
    }

    @JsonProperty("value")
    public void setValue(String value) {
        this.value = value;
    }

    public DeflatedDataValue withValue(String value) {
        this.value = value;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public DeflatedDataValue withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "attributeOptionComboId":
                if (value instanceof Integer) {
                    setAttributeOptionComboId(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeOptionComboId\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "categoryOptionComboId":
                if (value instanceof Integer) {
                    setCategoryOptionComboId(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"categoryOptionComboId\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "categoryOptionComboName":
                if (value instanceof String) {
                    setCategoryOptionComboName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"categoryOptionComboName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "comment":
                if (value instanceof String) {
                    setComment(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"comment\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataElementId":
                if (value instanceof Integer) {
                    setDataElementId(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataElementId\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataElementName":
                if (value instanceof String) {
                    setDataElementName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataElementName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "deleted":
                if (value instanceof Boolean) {
                    setDeleted(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"deleted\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "followup":
                if (value instanceof Boolean) {
                    setFollowup(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"followup\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "max":
                if (value instanceof Integer) {
                    setMax(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"max\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "min":
                if (value instanceof Integer) {
                    setMin(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"min\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "period":
                if (value instanceof String) {
                    setPeriod(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"period\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "periodId":
                if (value instanceof Integer) {
                    setPeriodId(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"periodId\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "sourceId":
                if (value instanceof Integer) {
                    setSourceId(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"sourceId\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "sourceName":
                if (value instanceof String) {
                    setSourceName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"sourceName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "sourcePath":
                if (value instanceof String) {
                    setSourcePath(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"sourcePath\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "value":
                if (value instanceof String) {
                    setValue(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"value\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "attributeOptionComboId":
                return getAttributeOptionComboId();
            case "categoryOptionComboId":
                return getCategoryOptionComboId();
            case "categoryOptionComboName":
                return getCategoryOptionComboName();
            case "comment":
                return getComment();
            case "dataElementId":
                return getDataElementId();
            case "dataElementName":
                return getDataElementName();
            case "deleted":
                return getDeleted();
            case "followup":
                return getFollowup();
            case "max":
                return getMax();
            case "min":
                return getMin();
            case "period":
                return getPeriod();
            case "periodId":
                return getPeriodId();
            case "sourceId":
                return getSourceId();
            case "sourceName":
                return getSourceName();
            case "sourcePath":
                return getSourcePath();
            case "value":
                return getValue();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, DeflatedDataValue.NOT_FOUND_VALUE);
        if (DeflatedDataValue.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public DeflatedDataValue with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DeflatedDataValue.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("attributeOptionComboId");
        sb.append('=');
        sb.append(((this.attributeOptionComboId == null)?"<null>":this.attributeOptionComboId));
        sb.append(',');
        sb.append("categoryOptionComboId");
        sb.append('=');
        sb.append(((this.categoryOptionComboId == null)?"<null>":this.categoryOptionComboId));
        sb.append(',');
        sb.append("categoryOptionComboName");
        sb.append('=');
        sb.append(((this.categoryOptionComboName == null)?"<null>":this.categoryOptionComboName));
        sb.append(',');
        sb.append("comment");
        sb.append('=');
        sb.append(((this.comment == null)?"<null>":this.comment));
        sb.append(',');
        sb.append("dataElementId");
        sb.append('=');
        sb.append(((this.dataElementId == null)?"<null>":this.dataElementId));
        sb.append(',');
        sb.append("dataElementName");
        sb.append('=');
        sb.append(((this.dataElementName == null)?"<null>":this.dataElementName));
        sb.append(',');
        sb.append("deleted");
        sb.append('=');
        sb.append(((this.deleted == null)?"<null>":this.deleted));
        sb.append(',');
        sb.append("followup");
        sb.append('=');
        sb.append(((this.followup == null)?"<null>":this.followup));
        sb.append(',');
        sb.append("max");
        sb.append('=');
        sb.append(((this.max == null)?"<null>":this.max));
        sb.append(',');
        sb.append("min");
        sb.append('=');
        sb.append(((this.min == null)?"<null>":this.min));
        sb.append(',');
        sb.append("period");
        sb.append('=');
        sb.append(((this.period == null)?"<null>":this.period));
        sb.append(',');
        sb.append("periodId");
        sb.append('=');
        sb.append(((this.periodId == null)?"<null>":this.periodId));
        sb.append(',');
        sb.append("sourceId");
        sb.append('=');
        sb.append(((this.sourceId == null)?"<null>":this.sourceId));
        sb.append(',');
        sb.append("sourceName");
        sb.append('=');
        sb.append(((this.sourceName == null)?"<null>":this.sourceName));
        sb.append(',');
        sb.append("sourcePath");
        sb.append('=');
        sb.append(((this.sourcePath == null)?"<null>":this.sourcePath));
        sb.append(',');
        sb.append("value");
        sb.append('=');
        sb.append(((this.value == null)?"<null>":this.value));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.sourceId == null)? 0 :this.sourceId.hashCode()));
        result = ((result* 31)+((this.periodId == null)? 0 :this.periodId.hashCode()));
        result = ((result* 31)+((this.dataElementName == null)? 0 :this.dataElementName.hashCode()));
        result = ((result* 31)+((this.period == null)? 0 :this.period.hashCode()));
        result = ((result* 31)+((this.max == null)? 0 :this.max.hashCode()));
        result = ((result* 31)+((this.attributeOptionComboId == null)? 0 :this.attributeOptionComboId.hashCode()));
        result = ((result* 31)+((this.categoryOptionComboName == null)? 0 :this.categoryOptionComboName.hashCode()));
        result = ((result* 31)+((this.dataElementId == null)? 0 :this.dataElementId.hashCode()));
        result = ((result* 31)+((this.followup == null)? 0 :this.followup.hashCode()));
        result = ((result* 31)+((this.deleted == null)? 0 :this.deleted.hashCode()));
        result = ((result* 31)+((this.min == null)? 0 :this.min.hashCode()));
        result = ((result* 31)+((this.comment == null)? 0 :this.comment.hashCode()));
        result = ((result* 31)+((this.sourceName == null)? 0 :this.sourceName.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.categoryOptionComboId == null)? 0 :this.categoryOptionComboId.hashCode()));
        result = ((result* 31)+((this.value == null)? 0 :this.value.hashCode()));
        result = ((result* 31)+((this.sourcePath == null)? 0 :this.sourcePath.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof DeflatedDataValue) == false) {
            return false;
        }
        DeflatedDataValue rhs = ((DeflatedDataValue) other);
        return ((((((((((((((((((this.sourceId == rhs.sourceId)||((this.sourceId!= null)&&this.sourceId.equals(rhs.sourceId)))&&((this.periodId == rhs.periodId)||((this.periodId!= null)&&this.periodId.equals(rhs.periodId))))&&((this.dataElementName == rhs.dataElementName)||((this.dataElementName!= null)&&this.dataElementName.equals(rhs.dataElementName))))&&((this.period == rhs.period)||((this.period!= null)&&this.period.equals(rhs.period))))&&((this.max == rhs.max)||((this.max!= null)&&this.max.equals(rhs.max))))&&((this.attributeOptionComboId == rhs.attributeOptionComboId)||((this.attributeOptionComboId!= null)&&this.attributeOptionComboId.equals(rhs.attributeOptionComboId))))&&((this.categoryOptionComboName == rhs.categoryOptionComboName)||((this.categoryOptionComboName!= null)&&this.categoryOptionComboName.equals(rhs.categoryOptionComboName))))&&((this.dataElementId == rhs.dataElementId)||((this.dataElementId!= null)&&this.dataElementId.equals(rhs.dataElementId))))&&((this.followup == rhs.followup)||((this.followup!= null)&&this.followup.equals(rhs.followup))))&&((this.deleted == rhs.deleted)||((this.deleted!= null)&&this.deleted.equals(rhs.deleted))))&&((this.min == rhs.min)||((this.min!= null)&&this.min.equals(rhs.min))))&&((this.comment == rhs.comment)||((this.comment!= null)&&this.comment.equals(rhs.comment))))&&((this.sourceName == rhs.sourceName)||((this.sourceName!= null)&&this.sourceName.equals(rhs.sourceName))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.categoryOptionComboId == rhs.categoryOptionComboId)||((this.categoryOptionComboId!= null)&&this.categoryOptionComboId.equals(rhs.categoryOptionComboId))))&&((this.value == rhs.value)||((this.value!= null)&&this.value.equals(rhs.value))))&&((this.sourcePath == rhs.sourcePath)||((this.sourcePath!= null)&&this.sourcePath.equals(rhs.sourcePath))));
    }

}
