
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "completeStatus",
    "dataValues",
    "lockStatus",
    "minMaxValues"
})
@Generated("jsonschema2pojo")
public class DataValuesDto implements Serializable
{

    @JsonProperty("completeStatus")
    private CompleteStatusDto completeStatus;
    @JsonProperty("dataValues")
    private List<DataValueDto> dataValues = null;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("lockStatus")
    private DataValuesDto.LockStatus lockStatus;
    @JsonProperty("minMaxValues")
    private List<MinMaxValueDto> minMaxValues = null;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -4765211621746918669L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DataValuesDto() {
    }

    /**
     * 
     * @param source
     */
    public DataValuesDto(DataValuesDto source) {
        super();
        this.completeStatus = source.completeStatus;
        this.dataValues = source.dataValues;
        this.lockStatus = source.lockStatus;
        this.minMaxValues = source.minMaxValues;
    }

    /**
     * 
     * @param dataValues
     * @param lockStatus
     * @param completeStatus
     * @param minMaxValues
     */
    public DataValuesDto(CompleteStatusDto completeStatus, List<DataValueDto> dataValues, DataValuesDto.LockStatus lockStatus, List<MinMaxValueDto> minMaxValues) {
        super();
        this.completeStatus = completeStatus;
        this.dataValues = dataValues;
        this.lockStatus = lockStatus;
        this.minMaxValues = minMaxValues;
    }

    @JsonProperty("completeStatus")
    public Optional<CompleteStatusDto> getCompleteStatus() {
        return Optional.ofNullable(completeStatus);
    }

    @JsonProperty("completeStatus")
    public void setCompleteStatus(CompleteStatusDto completeStatus) {
        this.completeStatus = completeStatus;
    }

    public DataValuesDto withCompleteStatus(CompleteStatusDto completeStatus) {
        this.completeStatus = completeStatus;
        return this;
    }

    @JsonProperty("dataValues")
    public Optional<List<DataValueDto>> getDataValues() {
        return Optional.ofNullable(dataValues);
    }

    @JsonProperty("dataValues")
    public void setDataValues(List<DataValueDto> dataValues) {
        this.dataValues = dataValues;
    }

    public DataValuesDto withDataValues(List<DataValueDto> dataValues) {
        this.dataValues = dataValues;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("lockStatus")
    public DataValuesDto.LockStatus getLockStatus() {
        return lockStatus;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("lockStatus")
    public void setLockStatus(DataValuesDto.LockStatus lockStatus) {
        this.lockStatus = lockStatus;
    }

    public DataValuesDto withLockStatus(DataValuesDto.LockStatus lockStatus) {
        this.lockStatus = lockStatus;
        return this;
    }

    @JsonProperty("minMaxValues")
    public Optional<List<MinMaxValueDto>> getMinMaxValues() {
        return Optional.ofNullable(minMaxValues);
    }

    @JsonProperty("minMaxValues")
    public void setMinMaxValues(List<MinMaxValueDto> minMaxValues) {
        this.minMaxValues = minMaxValues;
    }

    public DataValuesDto withMinMaxValues(List<MinMaxValueDto> minMaxValues) {
        this.minMaxValues = minMaxValues;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public DataValuesDto withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "completeStatus":
                if (value instanceof CompleteStatusDto) {
                    setCompleteStatus(((CompleteStatusDto) value));
                } else {
                    throw new IllegalArgumentException(("property \"completeStatus\" is of type \"org.hisp.dhis.api.model.v40_0.CompleteStatusDto\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataValues":
                if (value instanceof List) {
                    setDataValues(((List<DataValueDto> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.DataValueDto>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lockStatus":
                if (value instanceof DataValuesDto.LockStatus) {
                    setLockStatus(((DataValuesDto.LockStatus) value));
                } else {
                    throw new IllegalArgumentException(("property \"lockStatus\" is of type \"org.hisp.dhis.api.model.v40_0.DataValuesDto.LockStatus\", but got "+ value.getClass().toString()));
                }
                return true;
            case "minMaxValues":
                if (value instanceof List) {
                    setMinMaxValues(((List<MinMaxValueDto> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"minMaxValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.MinMaxValueDto>\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "completeStatus":
                return getCompleteStatus();
            case "dataValues":
                return getDataValues();
            case "lockStatus":
                return getLockStatus();
            case "minMaxValues":
                return getMinMaxValues();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, DataValuesDto.NOT_FOUND_VALUE);
        if (DataValuesDto.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public DataValuesDto with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DataValuesDto.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("completeStatus");
        sb.append('=');
        sb.append(((this.completeStatus == null)?"<null>":this.completeStatus));
        sb.append(',');
        sb.append("dataValues");
        sb.append('=');
        sb.append(((this.dataValues == null)?"<null>":this.dataValues));
        sb.append(',');
        sb.append("lockStatus");
        sb.append('=');
        sb.append(((this.lockStatus == null)?"<null>":this.lockStatus));
        sb.append(',');
        sb.append("minMaxValues");
        sb.append('=');
        sb.append(((this.minMaxValues == null)?"<null>":this.minMaxValues));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.dataValues == null)? 0 :this.dataValues.hashCode()));
        result = ((result* 31)+((this.lockStatus == null)? 0 :this.lockStatus.hashCode()));
        result = ((result* 31)+((this.completeStatus == null)? 0 :this.completeStatus.hashCode()));
        result = ((result* 31)+((this.minMaxValues == null)? 0 :this.minMaxValues.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof DataValuesDto) == false) {
            return false;
        }
        DataValuesDto rhs = ((DataValuesDto) other);
        return ((((((this.dataValues == rhs.dataValues)||((this.dataValues!= null)&&this.dataValues.equals(rhs.dataValues)))&&((this.lockStatus == rhs.lockStatus)||((this.lockStatus!= null)&&this.lockStatus.equals(rhs.lockStatus))))&&((this.completeStatus == rhs.completeStatus)||((this.completeStatus!= null)&&this.completeStatus.equals(rhs.completeStatus))))&&((this.minMaxValues == rhs.minMaxValues)||((this.minMaxValues!= null)&&this.minMaxValues.equals(rhs.minMaxValues))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))));
    }

    @Generated("jsonschema2pojo")
    public enum LockStatus {

        LOCKED("LOCKED"),
        APPROVED("APPROVED"),
        OPEN("OPEN");
        private final String value;
        private final static Map<String, DataValuesDto.LockStatus> CONSTANTS = new HashMap<String, DataValuesDto.LockStatus>();

        static {
            for (DataValuesDto.LockStatus c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        LockStatus(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DataValuesDto.LockStatus fromValue(String value) {
            DataValuesDto.LockStatus constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
