
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "audits",
    "history"
})
@Generated("jsonschema2pojo")
public class DataValueContextDto implements Serializable
{

    @JsonProperty("audits")
    private List<DataValueAuditDto> audits = null;
    @JsonProperty("history")
    private List<DataValueDto> history = null;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -6527954182298346437L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DataValueContextDto() {
    }

    /**
     * 
     * @param source
     */
    public DataValueContextDto(DataValueContextDto source) {
        super();
        this.audits = source.audits;
        this.history = source.history;
    }

    /**
     * 
     * @param history
     * @param audits
     */
    public DataValueContextDto(List<DataValueAuditDto> audits, List<DataValueDto> history) {
        super();
        this.audits = audits;
        this.history = history;
    }

    @JsonProperty("audits")
    public Optional<List<DataValueAuditDto>> getAudits() {
        return Optional.ofNullable(audits);
    }

    @JsonProperty("audits")
    public void setAudits(List<DataValueAuditDto> audits) {
        this.audits = audits;
    }

    public DataValueContextDto withAudits(List<DataValueAuditDto> audits) {
        this.audits = audits;
        return this;
    }

    @JsonProperty("history")
    public Optional<List<DataValueDto>> getHistory() {
        return Optional.ofNullable(history);
    }

    @JsonProperty("history")
    public void setHistory(List<DataValueDto> history) {
        this.history = history;
    }

    public DataValueContextDto withHistory(List<DataValueDto> history) {
        this.history = history;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public DataValueContextDto withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "audits":
                if (value instanceof List) {
                    setAudits(((List<DataValueAuditDto> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"audits\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.DataValueAuditDto>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "history":
                if (value instanceof List) {
                    setHistory(((List<DataValueDto> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"history\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.DataValueDto>\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "audits":
                return getAudits();
            case "history":
                return getHistory();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, DataValueContextDto.NOT_FOUND_VALUE);
        if (DataValueContextDto.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public DataValueContextDto with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DataValueContextDto.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("audits");
        sb.append('=');
        sb.append(((this.audits == null)?"<null>":this.audits));
        sb.append(',');
        sb.append("history");
        sb.append('=');
        sb.append(((this.history == null)?"<null>":this.history));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.history == null)? 0 :this.history.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.audits == null)? 0 :this.audits.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof DataValueContextDto) == false) {
            return false;
        }
        DataValueContextDto rhs = ((DataValueContextDto) other);
        return ((((this.history == rhs.history)||((this.history!= null)&&this.history.equals(rhs.history)))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.audits == rhs.audits)||((this.audits!= null)&&this.audits.equals(rhs.audits))));
    }

}
