
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "combo",
    "options"
})
@Generated("jsonschema2pojo")
public class DataValueCategoryDto implements Serializable
{

    /**
     * A UID for an CategoryCombo object  
     * (Java name `org.hisp.dhis.category.CategoryCombo`)
     * 
     */
    @JsonProperty("combo")
    @JsonPropertyDescription("A UID for an CategoryCombo object  \n(Java name `org.hisp.dhis.category.CategoryCombo`)")
    private String combo;
    @JsonProperty("options")
    private List<String> options = null;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -5078293512594597197L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DataValueCategoryDto() {
    }

    /**
     * 
     * @param source
     */
    public DataValueCategoryDto(DataValueCategoryDto source) {
        super();
        this.combo = source.combo;
        this.options = source.options;
    }

    /**
     * 
     * @param options
     * @param combo
     */
    public DataValueCategoryDto(String combo, List<String> options) {
        super();
        this.combo = combo;
        this.options = options;
    }

    /**
     * A UID for an CategoryCombo object  
     * (Java name `org.hisp.dhis.category.CategoryCombo`)
     * 
     */
    @JsonProperty("combo")
    public Optional<String> getCombo() {
        return Optional.ofNullable(combo);
    }

    /**
     * A UID for an CategoryCombo object  
     * (Java name `org.hisp.dhis.category.CategoryCombo`)
     * 
     */
    @JsonProperty("combo")
    public void setCombo(String combo) {
        this.combo = combo;
    }

    public DataValueCategoryDto withCombo(String combo) {
        this.combo = combo;
        return this;
    }

    @JsonProperty("options")
    public Optional<List<String>> getOptions() {
        return Optional.ofNullable(options);
    }

    @JsonProperty("options")
    public void setOptions(List<String> options) {
        this.options = options;
    }

    public DataValueCategoryDto withOptions(List<String> options) {
        this.options = options;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public DataValueCategoryDto withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "combo":
                if (value instanceof String) {
                    setCombo(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"combo\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "options":
                if (value instanceof List) {
                    setOptions(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"options\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "combo":
                return getCombo();
            case "options":
                return getOptions();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, DataValueCategoryDto.NOT_FOUND_VALUE);
        if (DataValueCategoryDto.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public DataValueCategoryDto with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DataValueCategoryDto.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("combo");
        sb.append('=');
        sb.append(((this.combo == null)?"<null>":this.combo));
        sb.append(',');
        sb.append("options");
        sb.append('=');
        sb.append(((this.options == null)?"<null>":this.options));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.options == null)? 0 :this.options.hashCode()));
        result = ((result* 31)+((this.combo == null)? 0 :this.combo.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof DataValueCategoryDto) == false) {
            return false;
        }
        DataValueCategoryDto rhs = ((DataValueCategoryDto) other);
        return ((((this.options == rhs.options)||((this.options!= null)&&this.options.equals(rhs.options)))&&((this.combo == rhs.combo)||((this.combo!= null)&&this.combo.equals(rhs.combo))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))));
    }

}
