
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "attributeOptionCombo",
    "categoryOptionCombo",
    "comment",
    "created",
    "dataElement",
    "deleted",
    "followup",
    "lastUpdated",
    "orgUnit",
    "period",
    "storedBy",
    "value"
})
@Generated("jsonschema2pojo")
public class DataValue implements Serializable
{

    @JsonProperty("attributeOptionCombo")
    private String attributeOptionCombo;
    @JsonProperty("categoryOptionCombo")
    private String categoryOptionCombo;
    @JsonProperty("comment")
    private String comment;
    @JsonProperty("created")
    private String created;
    @JsonProperty("dataElement")
    private String dataElement;
    @JsonProperty("deleted")
    private Boolean deleted;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("followup")
    private Boolean followup;
    @JsonProperty("lastUpdated")
    private String lastUpdated;
    @JsonProperty("orgUnit")
    private String orgUnit;
    @JsonProperty("period")
    private String period;
    @JsonProperty("storedBy")
    private String storedBy;
    @JsonProperty("value")
    private String value;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 1995439110668784381L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DataValue() {
    }

    /**
     * 
     * @param source
     */
    public DataValue(DataValue source) {
        super();
        this.attributeOptionCombo = source.attributeOptionCombo;
        this.categoryOptionCombo = source.categoryOptionCombo;
        this.comment = source.comment;
        this.created = source.created;
        this.dataElement = source.dataElement;
        this.deleted = source.deleted;
        this.followup = source.followup;
        this.lastUpdated = source.lastUpdated;
        this.orgUnit = source.orgUnit;
        this.period = source.period;
        this.storedBy = source.storedBy;
        this.value = source.value;
    }

    /**
     * 
     * @param followup
     * @param lastUpdated
     * @param period
     * @param deleted
     * @param storedBy
     * @param created
     * @param attributeOptionCombo
     * @param orgUnit
     * @param categoryOptionCombo
     * @param comment
     * @param dataElement
     * @param value
     */
    public DataValue(String attributeOptionCombo, String categoryOptionCombo, String comment, String created, String dataElement, Boolean deleted, Boolean followup, String lastUpdated, String orgUnit, String period, String storedBy, String value) {
        super();
        this.attributeOptionCombo = attributeOptionCombo;
        this.categoryOptionCombo = categoryOptionCombo;
        this.comment = comment;
        this.created = created;
        this.dataElement = dataElement;
        this.deleted = deleted;
        this.followup = followup;
        this.lastUpdated = lastUpdated;
        this.orgUnit = orgUnit;
        this.period = period;
        this.storedBy = storedBy;
        this.value = value;
    }

    @JsonProperty("attributeOptionCombo")
    public Optional<String> getAttributeOptionCombo() {
        return Optional.ofNullable(attributeOptionCombo);
    }

    @JsonProperty("attributeOptionCombo")
    public void setAttributeOptionCombo(String attributeOptionCombo) {
        this.attributeOptionCombo = attributeOptionCombo;
    }

    public DataValue withAttributeOptionCombo(String attributeOptionCombo) {
        this.attributeOptionCombo = attributeOptionCombo;
        return this;
    }

    @JsonProperty("categoryOptionCombo")
    public Optional<String> getCategoryOptionCombo() {
        return Optional.ofNullable(categoryOptionCombo);
    }

    @JsonProperty("categoryOptionCombo")
    public void setCategoryOptionCombo(String categoryOptionCombo) {
        this.categoryOptionCombo = categoryOptionCombo;
    }

    public DataValue withCategoryOptionCombo(String categoryOptionCombo) {
        this.categoryOptionCombo = categoryOptionCombo;
        return this;
    }

    @JsonProperty("comment")
    public Optional<String> getComment() {
        return Optional.ofNullable(comment);
    }

    @JsonProperty("comment")
    public void setComment(String comment) {
        this.comment = comment;
    }

    public DataValue withComment(String comment) {
        this.comment = comment;
        return this;
    }

    @JsonProperty("created")
    public Optional<String> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(String created) {
        this.created = created;
    }

    public DataValue withCreated(String created) {
        this.created = created;
        return this;
    }

    @JsonProperty("dataElement")
    public Optional<String> getDataElement() {
        return Optional.ofNullable(dataElement);
    }

    @JsonProperty("dataElement")
    public void setDataElement(String dataElement) {
        this.dataElement = dataElement;
    }

    public DataValue withDataElement(String dataElement) {
        this.dataElement = dataElement;
        return this;
    }

    @JsonProperty("deleted")
    public Optional<Boolean> getDeleted() {
        return Optional.ofNullable(deleted);
    }

    @JsonProperty("deleted")
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public DataValue withDeleted(Boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("followup")
    public Boolean getFollowup() {
        return followup;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("followup")
    public void setFollowup(Boolean followup) {
        this.followup = followup;
    }

    public DataValue withFollowup(Boolean followup) {
        this.followup = followup;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<String> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(String lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public DataValue withLastUpdated(String lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    @JsonProperty("orgUnit")
    public Optional<String> getOrgUnit() {
        return Optional.ofNullable(orgUnit);
    }

    @JsonProperty("orgUnit")
    public void setOrgUnit(String orgUnit) {
        this.orgUnit = orgUnit;
    }

    public DataValue withOrgUnit(String orgUnit) {
        this.orgUnit = orgUnit;
        return this;
    }

    @JsonProperty("period")
    public Optional<String> getPeriod() {
        return Optional.ofNullable(period);
    }

    @JsonProperty("period")
    public void setPeriod(String period) {
        this.period = period;
    }

    public DataValue withPeriod(String period) {
        this.period = period;
        return this;
    }

    @JsonProperty("storedBy")
    public Optional<String> getStoredBy() {
        return Optional.ofNullable(storedBy);
    }

    @JsonProperty("storedBy")
    public void setStoredBy(String storedBy) {
        this.storedBy = storedBy;
    }

    public DataValue withStoredBy(String storedBy) {
        this.storedBy = storedBy;
        return this;
    }

    @JsonProperty("value")
    public Optional<String> getValue() {
        return Optional.ofNullable(value);
    }

    @JsonProperty("value")
    public void setValue(String value) {
        this.value = value;
    }

    public DataValue withValue(String value) {
        this.value = value;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public DataValue withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "attributeOptionCombo":
                if (value instanceof String) {
                    setAttributeOptionCombo(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeOptionCombo\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "categoryOptionCombo":
                if (value instanceof String) {
                    setCategoryOptionCombo(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"categoryOptionCombo\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "comment":
                if (value instanceof String) {
                    setComment(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"comment\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "created":
                if (value instanceof String) {
                    setCreated(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"created\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataElement":
                if (value instanceof String) {
                    setDataElement(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataElement\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "deleted":
                if (value instanceof Boolean) {
                    setDeleted(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"deleted\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "followup":
                if (value instanceof Boolean) {
                    setFollowup(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"followup\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdated":
                if (value instanceof String) {
                    setLastUpdated(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "orgUnit":
                if (value instanceof String) {
                    setOrgUnit(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"orgUnit\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "period":
                if (value instanceof String) {
                    setPeriod(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"period\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "storedBy":
                if (value instanceof String) {
                    setStoredBy(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"storedBy\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "value":
                if (value instanceof String) {
                    setValue(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"value\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "attributeOptionCombo":
                return getAttributeOptionCombo();
            case "categoryOptionCombo":
                return getCategoryOptionCombo();
            case "comment":
                return getComment();
            case "created":
                return getCreated();
            case "dataElement":
                return getDataElement();
            case "deleted":
                return getDeleted();
            case "followup":
                return getFollowup();
            case "lastUpdated":
                return getLastUpdated();
            case "orgUnit":
                return getOrgUnit();
            case "period":
                return getPeriod();
            case "storedBy":
                return getStoredBy();
            case "value":
                return getValue();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, DataValue.NOT_FOUND_VALUE);
        if (DataValue.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public DataValue with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DataValue.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("attributeOptionCombo");
        sb.append('=');
        sb.append(((this.attributeOptionCombo == null)?"<null>":this.attributeOptionCombo));
        sb.append(',');
        sb.append("categoryOptionCombo");
        sb.append('=');
        sb.append(((this.categoryOptionCombo == null)?"<null>":this.categoryOptionCombo));
        sb.append(',');
        sb.append("comment");
        sb.append('=');
        sb.append(((this.comment == null)?"<null>":this.comment));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("dataElement");
        sb.append('=');
        sb.append(((this.dataElement == null)?"<null>":this.dataElement));
        sb.append(',');
        sb.append("deleted");
        sb.append('=');
        sb.append(((this.deleted == null)?"<null>":this.deleted));
        sb.append(',');
        sb.append("followup");
        sb.append('=');
        sb.append(((this.followup == null)?"<null>":this.followup));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("orgUnit");
        sb.append('=');
        sb.append(((this.orgUnit == null)?"<null>":this.orgUnit));
        sb.append(',');
        sb.append("period");
        sb.append('=');
        sb.append(((this.period == null)?"<null>":this.period));
        sb.append(',');
        sb.append("storedBy");
        sb.append('=');
        sb.append(((this.storedBy == null)?"<null>":this.storedBy));
        sb.append(',');
        sb.append("value");
        sb.append('=');
        sb.append(((this.value == null)?"<null>":this.value));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.period == null)? 0 :this.period.hashCode()));
        result = ((result* 31)+((this.storedBy == null)? 0 :this.storedBy.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.orgUnit == null)? 0 :this.orgUnit.hashCode()));
        result = ((result* 31)+((this.categoryOptionCombo == null)? 0 :this.categoryOptionCombo.hashCode()));
        result = ((result* 31)+((this.dataElement == null)? 0 :this.dataElement.hashCode()));
        result = ((result* 31)+((this.followup == null)? 0 :this.followup.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.deleted == null)? 0 :this.deleted.hashCode()));
        result = ((result* 31)+((this.attributeOptionCombo == null)? 0 :this.attributeOptionCombo.hashCode()));
        result = ((result* 31)+((this.comment == null)? 0 :this.comment.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.value == null)? 0 :this.value.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof DataValue) == false) {
            return false;
        }
        DataValue rhs = ((DataValue) other);
        return ((((((((((((((this.period == rhs.period)||((this.period!= null)&&this.period.equals(rhs.period)))&&((this.storedBy == rhs.storedBy)||((this.storedBy!= null)&&this.storedBy.equals(rhs.storedBy))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.orgUnit == rhs.orgUnit)||((this.orgUnit!= null)&&this.orgUnit.equals(rhs.orgUnit))))&&((this.categoryOptionCombo == rhs.categoryOptionCombo)||((this.categoryOptionCombo!= null)&&this.categoryOptionCombo.equals(rhs.categoryOptionCombo))))&&((this.dataElement == rhs.dataElement)||((this.dataElement!= null)&&this.dataElement.equals(rhs.dataElement))))&&((this.followup == rhs.followup)||((this.followup!= null)&&this.followup.equals(rhs.followup))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.deleted == rhs.deleted)||((this.deleted!= null)&&this.deleted.equals(rhs.deleted))))&&((this.attributeOptionCombo == rhs.attributeOptionCombo)||((this.attributeOptionCombo!= null)&&this.attributeOptionCombo.equals(rhs.attributeOptionCombo))))&&((this.comment == rhs.comment)||((this.comment!= null)&&this.comment.equals(rhs.comment))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.value == rhs.value)||((this.value!= null)&&this.value.equals(rhs.value))));
    }

}
