
package org.hisp.dhis.api.model.v2_39_1;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "decimalPoints",
    "max",
    "min",
    "step",
    "type"
})
@Generated("jsonschema2pojo")
public class ValueTypeRenderingObject implements Serializable
{

    @JsonProperty("decimalPoints")
    private Integer decimalPoints;
    @JsonProperty("max")
    private Integer max;
    @JsonProperty("min")
    private Integer min;
    @JsonProperty("step")
    private Integer step;
    @JsonProperty("type")
    private ValueTypeRenderingObject.ValueTypeRenderingType type;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 7765784531514686989L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ValueTypeRenderingObject() {
    }

    /**
     * 
     * @param source
     */
    public ValueTypeRenderingObject(ValueTypeRenderingObject source) {
        super();
        this.decimalPoints = source.decimalPoints;
        this.max = source.max;
        this.min = source.min;
        this.step = source.step;
        this.type = source.type;
    }

    /**
     * 
     * @param min
     * @param max
     * @param decimalPoints
     * @param step
     * @param type
     */
    public ValueTypeRenderingObject(Integer decimalPoints, Integer max, Integer min, Integer step, ValueTypeRenderingObject.ValueTypeRenderingType type) {
        super();
        this.decimalPoints = decimalPoints;
        this.max = max;
        this.min = min;
        this.step = step;
        this.type = type;
    }

    @JsonProperty("decimalPoints")
    public Optional<Integer> getDecimalPoints() {
        return Optional.ofNullable(decimalPoints);
    }

    @JsonProperty("decimalPoints")
    public void setDecimalPoints(Integer decimalPoints) {
        this.decimalPoints = decimalPoints;
    }

    public ValueTypeRenderingObject withDecimalPoints(Integer decimalPoints) {
        this.decimalPoints = decimalPoints;
        return this;
    }

    @JsonProperty("max")
    public Optional<Integer> getMax() {
        return Optional.ofNullable(max);
    }

    @JsonProperty("max")
    public void setMax(Integer max) {
        this.max = max;
    }

    public ValueTypeRenderingObject withMax(Integer max) {
        this.max = max;
        return this;
    }

    @JsonProperty("min")
    public Optional<Integer> getMin() {
        return Optional.ofNullable(min);
    }

    @JsonProperty("min")
    public void setMin(Integer min) {
        this.min = min;
    }

    public ValueTypeRenderingObject withMin(Integer min) {
        this.min = min;
        return this;
    }

    @JsonProperty("step")
    public Optional<Integer> getStep() {
        return Optional.ofNullable(step);
    }

    @JsonProperty("step")
    public void setStep(Integer step) {
        this.step = step;
    }

    public ValueTypeRenderingObject withStep(Integer step) {
        this.step = step;
        return this;
    }

    @JsonProperty("type")
    public Optional<ValueTypeRenderingObject.ValueTypeRenderingType> getType() {
        return Optional.ofNullable(type);
    }

    @JsonProperty("type")
    public void setType(ValueTypeRenderingObject.ValueTypeRenderingType type) {
        this.type = type;
    }

    public ValueTypeRenderingObject withType(ValueTypeRenderingObject.ValueTypeRenderingType type) {
        this.type = type;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ValueTypeRenderingObject withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "decimalPoints":
                if (value instanceof Integer) {
                    setDecimalPoints(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"decimalPoints\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "max":
                if (value instanceof Integer) {
                    setMax(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"max\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "min":
                if (value instanceof Integer) {
                    setMin(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"min\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "step":
                if (value instanceof Integer) {
                    setStep(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"step\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "type":
                if (value instanceof ValueTypeRenderingObject.ValueTypeRenderingType) {
                    setType(((ValueTypeRenderingObject.ValueTypeRenderingType) value));
                } else {
                    throw new IllegalArgumentException(("property \"type\" is of type \"org.hisp.dhis.api.model.v2_39_1.ValueTypeRenderingObject.ValueTypeRenderingType\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "decimalPoints":
                return getDecimalPoints();
            case "max":
                return getMax();
            case "min":
                return getMin();
            case "step":
                return getStep();
            case "type":
                return getType();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ValueTypeRenderingObject.NOT_FOUND_VALUE);
        if (ValueTypeRenderingObject.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ValueTypeRenderingObject with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ValueTypeRenderingObject.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("decimalPoints");
        sb.append('=');
        sb.append(((this.decimalPoints == null)?"<null>":this.decimalPoints));
        sb.append(',');
        sb.append("max");
        sb.append('=');
        sb.append(((this.max == null)?"<null>":this.max));
        sb.append(',');
        sb.append("min");
        sb.append('=');
        sb.append(((this.min == null)?"<null>":this.min));
        sb.append(',');
        sb.append("step");
        sb.append('=');
        sb.append(((this.step == null)?"<null>":this.step));
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(((this.type == null)?"<null>":this.type));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.min == null)? 0 :this.min.hashCode()));
        result = ((result* 31)+((this.max == null)? 0 :this.max.hashCode()));
        result = ((result* 31)+((this.decimalPoints == null)? 0 :this.decimalPoints.hashCode()));
        result = ((result* 31)+((this.step == null)? 0 :this.step.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.type == null)? 0 :this.type.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ValueTypeRenderingObject) == false) {
            return false;
        }
        ValueTypeRenderingObject rhs = ((ValueTypeRenderingObject) other);
        return (((((((this.min == rhs.min)||((this.min!= null)&&this.min.equals(rhs.min)))&&((this.max == rhs.max)||((this.max!= null)&&this.max.equals(rhs.max))))&&((this.decimalPoints == rhs.decimalPoints)||((this.decimalPoints!= null)&&this.decimalPoints.equals(rhs.decimalPoints))))&&((this.step == rhs.step)||((this.step!= null)&&this.step.equals(rhs.step))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.type == rhs.type)||((this.type!= null)&&this.type.equals(rhs.type))));
    }

    @Generated("jsonschema2pojo")
    public enum ValueTypeRenderingType {

        DEFAULT("DEFAULT"),
        DROPDOWN("DROPDOWN"),
        VERTICAL_RADIOBUTTONS("VERTICAL_RADIOBUTTONS"),
        HORIZONTAL_RADIOBUTTONS("HORIZONTAL_RADIOBUTTONS"),
        VERTICAL_CHECKBOXES("VERTICAL_CHECKBOXES"),
        HORIZONTAL_CHECKBOXES("HORIZONTAL_CHECKBOXES"),
        SHARED_HEADER_RADIOBUTTONS("SHARED_HEADER_RADIOBUTTONS"),
        ICONS_AS_BUTTONS("ICONS_AS_BUTTONS"),
        SPINNER("SPINNER"),
        ICON("ICON"),
        TOGGLE("TOGGLE"),
        VALUE("VALUE"),
        SLIDER("SLIDER"),
        LINEAR_SCALE("LINEAR_SCALE"),
        AUTOCOMPLETE("AUTOCOMPLETE"),
        QR_CODE("QR_CODE"),
        BAR_CODE("BAR_CODE"),
        GS_1_DATAMATRIX("GS1_DATAMATRIX");
        private final String value;
        private final static Map<String, ValueTypeRenderingObject.ValueTypeRenderingType> CONSTANTS = new HashMap<String, ValueTypeRenderingObject.ValueTypeRenderingType>();

        static {
            for (ValueTypeRenderingObject.ValueTypeRenderingType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ValueTypeRenderingType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ValueTypeRenderingObject.ValueTypeRenderingType fromValue(String value) {
            ValueTypeRenderingObject.ValueTypeRenderingType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
