
package org.hisp.dhis.api.model.v2_39_1;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "aggregationType",
    "maxDate",
    "minDate",
    "periodOffset",
    "subExpression",
    "valueType",
    "yearToDate"
})
@Generated("jsonschema2pojo")
public class QueryModifiers implements Serializable
{

    @JsonProperty("aggregationType")
    private org.hisp.dhis.api.model.v2_39_1.Category.AggregationType aggregationType;
    @JsonProperty("maxDate")
    private Date maxDate;
    @JsonProperty("minDate")
    private Date minDate;
    @JsonProperty("periodOffset")
    private Integer periodOffset;
    @JsonProperty("subExpression")
    private String subExpression;
    @JsonProperty("valueType")
    private org.hisp.dhis.api.model.v2_39_1.OptionSet.ValueType valueType;
    @JsonProperty("yearToDate")
    private Boolean yearToDate;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -3126865972649667696L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public QueryModifiers() {
    }

    /**
     * 
     * @param source
     */
    public QueryModifiers(QueryModifiers source) {
        super();
        this.aggregationType = source.aggregationType;
        this.maxDate = source.maxDate;
        this.minDate = source.minDate;
        this.periodOffset = source.periodOffset;
        this.subExpression = source.subExpression;
        this.valueType = source.valueType;
        this.yearToDate = source.yearToDate;
    }

    /**
     * 
     * @param aggregationType
     * @param minDate
     * @param periodOffset
     * @param yearToDate
     * @param valueType
     * @param maxDate
     * @param subExpression
     */
    public QueryModifiers(org.hisp.dhis.api.model.v2_39_1.Category.AggregationType aggregationType, Date maxDate, Date minDate, Integer periodOffset, String subExpression, org.hisp.dhis.api.model.v2_39_1.OptionSet.ValueType valueType, Boolean yearToDate) {
        super();
        this.aggregationType = aggregationType;
        this.maxDate = maxDate;
        this.minDate = minDate;
        this.periodOffset = periodOffset;
        this.subExpression = subExpression;
        this.valueType = valueType;
        this.yearToDate = yearToDate;
    }

    @JsonProperty("aggregationType")
    public Optional<org.hisp.dhis.api.model.v2_39_1.Category.AggregationType> getAggregationType() {
        return Optional.ofNullable(aggregationType);
    }

    @JsonProperty("aggregationType")
    public void setAggregationType(org.hisp.dhis.api.model.v2_39_1.Category.AggregationType aggregationType) {
        this.aggregationType = aggregationType;
    }

    public QueryModifiers withAggregationType(org.hisp.dhis.api.model.v2_39_1.Category.AggregationType aggregationType) {
        this.aggregationType = aggregationType;
        return this;
    }

    @JsonProperty("maxDate")
    public Optional<Date> getMaxDate() {
        return Optional.ofNullable(maxDate);
    }

    @JsonProperty("maxDate")
    public void setMaxDate(Date maxDate) {
        this.maxDate = maxDate;
    }

    public QueryModifiers withMaxDate(Date maxDate) {
        this.maxDate = maxDate;
        return this;
    }

    @JsonProperty("minDate")
    public Optional<Date> getMinDate() {
        return Optional.ofNullable(minDate);
    }

    @JsonProperty("minDate")
    public void setMinDate(Date minDate) {
        this.minDate = minDate;
    }

    public QueryModifiers withMinDate(Date minDate) {
        this.minDate = minDate;
        return this;
    }

    @JsonProperty("periodOffset")
    public Optional<Integer> getPeriodOffset() {
        return Optional.ofNullable(periodOffset);
    }

    @JsonProperty("periodOffset")
    public void setPeriodOffset(Integer periodOffset) {
        this.periodOffset = periodOffset;
    }

    public QueryModifiers withPeriodOffset(Integer periodOffset) {
        this.periodOffset = periodOffset;
        return this;
    }

    @JsonProperty("subExpression")
    public Optional<String> getSubExpression() {
        return Optional.ofNullable(subExpression);
    }

    @JsonProperty("subExpression")
    public void setSubExpression(String subExpression) {
        this.subExpression = subExpression;
    }

    public QueryModifiers withSubExpression(String subExpression) {
        this.subExpression = subExpression;
        return this;
    }

    @JsonProperty("valueType")
    public Optional<org.hisp.dhis.api.model.v2_39_1.OptionSet.ValueType> getValueType() {
        return Optional.ofNullable(valueType);
    }

    @JsonProperty("valueType")
    public void setValueType(org.hisp.dhis.api.model.v2_39_1.OptionSet.ValueType valueType) {
        this.valueType = valueType;
    }

    public QueryModifiers withValueType(org.hisp.dhis.api.model.v2_39_1.OptionSet.ValueType valueType) {
        this.valueType = valueType;
        return this;
    }

    @JsonProperty("yearToDate")
    public Optional<Boolean> getYearToDate() {
        return Optional.ofNullable(yearToDate);
    }

    @JsonProperty("yearToDate")
    public void setYearToDate(Boolean yearToDate) {
        this.yearToDate = yearToDate;
    }

    public QueryModifiers withYearToDate(Boolean yearToDate) {
        this.yearToDate = yearToDate;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public QueryModifiers withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "aggregationType":
                if (value instanceof org.hisp.dhis.api.model.v2_39_1.Category.AggregationType) {
                    setAggregationType(((org.hisp.dhis.api.model.v2_39_1.Category.AggregationType) value));
                } else {
                    throw new IllegalArgumentException(("property \"aggregationType\" is of type \"org.hisp.dhis.api.model.v2_39_1.Category.AggregationType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "maxDate":
                if (value instanceof Date) {
                    setMaxDate(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"maxDate\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "minDate":
                if (value instanceof Date) {
                    setMinDate(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"minDate\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "periodOffset":
                if (value instanceof Integer) {
                    setPeriodOffset(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"periodOffset\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "subExpression":
                if (value instanceof String) {
                    setSubExpression(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"subExpression\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "valueType":
                if (value instanceof org.hisp.dhis.api.model.v2_39_1.OptionSet.ValueType) {
                    setValueType(((org.hisp.dhis.api.model.v2_39_1.OptionSet.ValueType) value));
                } else {
                    throw new IllegalArgumentException(("property \"valueType\" is of type \"org.hisp.dhis.api.model.v2_39_1.OptionSet.ValueType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "yearToDate":
                if (value instanceof Boolean) {
                    setYearToDate(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"yearToDate\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "aggregationType":
                return getAggregationType();
            case "maxDate":
                return getMaxDate();
            case "minDate":
                return getMinDate();
            case "periodOffset":
                return getPeriodOffset();
            case "subExpression":
                return getSubExpression();
            case "valueType":
                return getValueType();
            case "yearToDate":
                return getYearToDate();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, QueryModifiers.NOT_FOUND_VALUE);
        if (QueryModifiers.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public QueryModifiers with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(QueryModifiers.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("aggregationType");
        sb.append('=');
        sb.append(((this.aggregationType == null)?"<null>":this.aggregationType));
        sb.append(',');
        sb.append("maxDate");
        sb.append('=');
        sb.append(((this.maxDate == null)?"<null>":this.maxDate));
        sb.append(',');
        sb.append("minDate");
        sb.append('=');
        sb.append(((this.minDate == null)?"<null>":this.minDate));
        sb.append(',');
        sb.append("periodOffset");
        sb.append('=');
        sb.append(((this.periodOffset == null)?"<null>":this.periodOffset));
        sb.append(',');
        sb.append("subExpression");
        sb.append('=');
        sb.append(((this.subExpression == null)?"<null>":this.subExpression));
        sb.append(',');
        sb.append("valueType");
        sb.append('=');
        sb.append(((this.valueType == null)?"<null>":this.valueType));
        sb.append(',');
        sb.append("yearToDate");
        sb.append('=');
        sb.append(((this.yearToDate == null)?"<null>":this.yearToDate));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.aggregationType == null)? 0 :this.aggregationType.hashCode()));
        result = ((result* 31)+((this.minDate == null)? 0 :this.minDate.hashCode()));
        result = ((result* 31)+((this.periodOffset == null)? 0 :this.periodOffset.hashCode()));
        result = ((result* 31)+((this.yearToDate == null)? 0 :this.yearToDate.hashCode()));
        result = ((result* 31)+((this.valueType == null)? 0 :this.valueType.hashCode()));
        result = ((result* 31)+((this.maxDate == null)? 0 :this.maxDate.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.subExpression == null)? 0 :this.subExpression.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof QueryModifiers) == false) {
            return false;
        }
        QueryModifiers rhs = ((QueryModifiers) other);
        return (((((((((this.aggregationType == rhs.aggregationType)||((this.aggregationType!= null)&&this.aggregationType.equals(rhs.aggregationType)))&&((this.minDate == rhs.minDate)||((this.minDate!= null)&&this.minDate.equals(rhs.minDate))))&&((this.periodOffset == rhs.periodOffset)||((this.periodOffset!= null)&&this.periodOffset.equals(rhs.periodOffset))))&&((this.yearToDate == rhs.yearToDate)||((this.yearToDate!= null)&&this.yearToDate.equals(rhs.yearToDate))))&&((this.valueType == rhs.valueType)||((this.valueType!= null)&&this.valueType.equals(rhs.valueType))))&&((this.maxDate == rhs.maxDate)||((this.maxDate!= null)&&this.maxDate.equals(rhs.maxDate))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.subExpression == rhs.subExpression)||((this.subExpression!= null)&&this.subExpression.equals(rhs.subExpression))));
    }

}
