
package org.hisp.dhis.api.model.v2_39_1;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "analyticalObject",
    "apiEndpoint",
    "attribute",
    "cascade",
    "collection",
    "collectionName",
    "collectionWrapping",
    "constants",
    "defaultValue",
    "description",
    "embeddedObject",
    "fieldName",
    "gistPreferences",
    "href",
    "i18nTranslationKey",
    "identifiableObject",
    "inverseRole",
    "itemKlass",
    "itemPropertyType",
    "klass",
    "length",
    "manyToMany",
    "manyToOne",
    "max",
    "min",
    "name",
    "nameableObject",
    "namespace",
    "oneToMany",
    "oneToOne",
    "ordered",
    "owner",
    "owningRole",
    "persisted",
    "propertyTransformer",
    "propertyType",
    "readable",
    "relativeApiEndpoint",
    "required",
    "simple",
    "translatable",
    "translationKey",
    "unique",
    "writable"
})
@Generated("jsonschema2pojo")
public class Property implements Serializable
{

    @JsonProperty("analyticalObject")
    private Boolean analyticalObject;
    @JsonProperty("apiEndpoint")
    private String apiEndpoint;
    @JsonProperty("attribute")
    private Boolean attribute;
    @JsonProperty("cascade")
    private String cascade;
    @JsonProperty("collection")
    private Boolean collection;
    @JsonProperty("collectionName")
    private String collectionName;
    @JsonProperty("collectionWrapping")
    private Boolean collectionWrapping;
    @JsonProperty("constants")
    private List<String> constants = null;
    /**
     * Undefined
     * 
     */
    @JsonProperty("defaultValue")
    private Object defaultValue;
    @JsonProperty("description")
    private String description;
    @JsonProperty("embeddedObject")
    private Boolean embeddedObject;
    @JsonProperty("fieldName")
    private String fieldName;
    @JsonProperty("gistPreferences")
    private GistPreferences gistPreferences;
    @JsonProperty("href")
    private String href;
    @JsonProperty("i18nTranslationKey")
    private String i18nTranslationKey;
    @JsonProperty("identifiableObject")
    private Boolean identifiableObject;
    @JsonProperty("inverseRole")
    private String inverseRole;
    @JsonProperty("itemKlass")
    private String itemKlass;
    @JsonProperty("itemPropertyType")
    private Property.PropertyType itemPropertyType;
    @JsonProperty("klass")
    private String klass;
    @JsonProperty("length")
    private Integer length;
    @JsonProperty("manyToMany")
    private Boolean manyToMany;
    @JsonProperty("manyToOne")
    private Boolean manyToOne;
    @JsonProperty("max")
    private Double max;
    @JsonProperty("min")
    private Double min;
    @JsonProperty("name")
    private String name;
    @JsonProperty("nameableObject")
    private Boolean nameableObject;
    @JsonProperty("namespace")
    private String namespace;
    @JsonProperty("oneToMany")
    private Boolean oneToMany;
    @JsonProperty("oneToOne")
    private Boolean oneToOne;
    @JsonProperty("ordered")
    private Boolean ordered;
    @JsonProperty("owner")
    private Boolean owner;
    @JsonProperty("owningRole")
    private String owningRole;
    @JsonProperty("persisted")
    private Boolean persisted;
    @JsonProperty("propertyTransformer")
    private Boolean propertyTransformer;
    @JsonProperty("propertyType")
    private Property.PropertyType propertyType;
    @JsonProperty("readable")
    private Boolean readable;
    @JsonProperty("relativeApiEndpoint")
    private String relativeApiEndpoint;
    @JsonProperty("required")
    private Boolean required;
    @JsonProperty("simple")
    private Boolean simple;
    @JsonProperty("translatable")
    private Boolean translatable;
    @JsonProperty("translationKey")
    private String translationKey;
    @JsonProperty("unique")
    private Boolean unique;
    @JsonProperty("writable")
    private Boolean writable;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 9121945262348149789L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Property() {
    }

    /**
     * 
     * @param source
     */
    public Property(Property source) {
        super();
        this.analyticalObject = source.analyticalObject;
        this.apiEndpoint = source.apiEndpoint;
        this.attribute = source.attribute;
        this.cascade = source.cascade;
        this.collection = source.collection;
        this.collectionName = source.collectionName;
        this.collectionWrapping = source.collectionWrapping;
        this.constants = source.constants;
        this.defaultValue = source.defaultValue;
        this.description = source.description;
        this.embeddedObject = source.embeddedObject;
        this.fieldName = source.fieldName;
        this.gistPreferences = source.gistPreferences;
        this.href = source.href;
        this.i18nTranslationKey = source.i18nTranslationKey;
        this.identifiableObject = source.identifiableObject;
        this.inverseRole = source.inverseRole;
        this.itemKlass = source.itemKlass;
        this.itemPropertyType = source.itemPropertyType;
        this.klass = source.klass;
        this.length = source.length;
        this.manyToMany = source.manyToMany;
        this.manyToOne = source.manyToOne;
        this.max = source.max;
        this.min = source.min;
        this.name = source.name;
        this.nameableObject = source.nameableObject;
        this.namespace = source.namespace;
        this.oneToMany = source.oneToMany;
        this.oneToOne = source.oneToOne;
        this.ordered = source.ordered;
        this.owner = source.owner;
        this.owningRole = source.owningRole;
        this.persisted = source.persisted;
        this.propertyTransformer = source.propertyTransformer;
        this.propertyType = source.propertyType;
        this.readable = source.readable;
        this.relativeApiEndpoint = source.relativeApiEndpoint;
        this.required = source.required;
        this.simple = source.simple;
        this.translatable = source.translatable;
        this.translationKey = source.translationKey;
        this.unique = source.unique;
        this.writable = source.writable;
    }

    /**
     * 
     * @param relativeApiEndpoint
     * @param fieldName
     * @param translationKey
     * @param defaultValue
     * @param description
     * @param simple
     * @param required
     * @param collectionName
     * @param writable
     * @param min
     * @param nameableObject
     * @param i18nTranslationKey
     * @param klass
     * @param propertyType
     * @param oneToOne
     * @param oneToMany
     * @param attribute
     * @param constants
     * @param href
     * @param propertyTransformer
     * @param owner
     * @param readable
     * @param ordered
     * @param translatable
     * @param identifiableObject
     * @param max
     * @param cascade
     * @param manyToMany
     * @param length
     * @param collection
     * @param gistPreferences
     * @param itemPropertyType
     * @param owningRole
     * @param collectionWrapping
     * @param itemKlass
     * @param inverseRole
     * @param apiEndpoint
     * @param analyticalObject
     * @param embeddedObject
     * @param unique
     * @param name
     * @param namespace
     * @param persisted
     * @param manyToOne
     */
    public Property(Boolean analyticalObject, String apiEndpoint, Boolean attribute, String cascade, Boolean collection, String collectionName, Boolean collectionWrapping, List<String> constants, Object defaultValue, String description, Boolean embeddedObject, String fieldName, GistPreferences gistPreferences, String href, String i18nTranslationKey, Boolean identifiableObject, String inverseRole, String itemKlass, Property.PropertyType itemPropertyType, String klass, Integer length, Boolean manyToMany, Boolean manyToOne, Double max, Double min, String name, Boolean nameableObject, String namespace, Boolean oneToMany, Boolean oneToOne, Boolean ordered, Boolean owner, String owningRole, Boolean persisted, Boolean propertyTransformer, Property.PropertyType propertyType, Boolean readable, String relativeApiEndpoint, Boolean required, Boolean simple, Boolean translatable, String translationKey, Boolean unique, Boolean writable) {
        super();
        this.analyticalObject = analyticalObject;
        this.apiEndpoint = apiEndpoint;
        this.attribute = attribute;
        this.cascade = cascade;
        this.collection = collection;
        this.collectionName = collectionName;
        this.collectionWrapping = collectionWrapping;
        this.constants = constants;
        this.defaultValue = defaultValue;
        this.description = description;
        this.embeddedObject = embeddedObject;
        this.fieldName = fieldName;
        this.gistPreferences = gistPreferences;
        this.href = href;
        this.i18nTranslationKey = i18nTranslationKey;
        this.identifiableObject = identifiableObject;
        this.inverseRole = inverseRole;
        this.itemKlass = itemKlass;
        this.itemPropertyType = itemPropertyType;
        this.klass = klass;
        this.length = length;
        this.manyToMany = manyToMany;
        this.manyToOne = manyToOne;
        this.max = max;
        this.min = min;
        this.name = name;
        this.nameableObject = nameableObject;
        this.namespace = namespace;
        this.oneToMany = oneToMany;
        this.oneToOne = oneToOne;
        this.ordered = ordered;
        this.owner = owner;
        this.owningRole = owningRole;
        this.persisted = persisted;
        this.propertyTransformer = propertyTransformer;
        this.propertyType = propertyType;
        this.readable = readable;
        this.relativeApiEndpoint = relativeApiEndpoint;
        this.required = required;
        this.simple = simple;
        this.translatable = translatable;
        this.translationKey = translationKey;
        this.unique = unique;
        this.writable = writable;
    }

    @JsonProperty("analyticalObject")
    public Optional<Boolean> getAnalyticalObject() {
        return Optional.ofNullable(analyticalObject);
    }

    @JsonProperty("analyticalObject")
    public void setAnalyticalObject(Boolean analyticalObject) {
        this.analyticalObject = analyticalObject;
    }

    public Property withAnalyticalObject(Boolean analyticalObject) {
        this.analyticalObject = analyticalObject;
        return this;
    }

    @JsonProperty("apiEndpoint")
    public Optional<String> getApiEndpoint() {
        return Optional.ofNullable(apiEndpoint);
    }

    @JsonProperty("apiEndpoint")
    public void setApiEndpoint(String apiEndpoint) {
        this.apiEndpoint = apiEndpoint;
    }

    public Property withApiEndpoint(String apiEndpoint) {
        this.apiEndpoint = apiEndpoint;
        return this;
    }

    @JsonProperty("attribute")
    public Optional<Boolean> getAttribute() {
        return Optional.ofNullable(attribute);
    }

    @JsonProperty("attribute")
    public void setAttribute(Boolean attribute) {
        this.attribute = attribute;
    }

    public Property withAttribute(Boolean attribute) {
        this.attribute = attribute;
        return this;
    }

    @JsonProperty("cascade")
    public Optional<String> getCascade() {
        return Optional.ofNullable(cascade);
    }

    @JsonProperty("cascade")
    public void setCascade(String cascade) {
        this.cascade = cascade;
    }

    public Property withCascade(String cascade) {
        this.cascade = cascade;
        return this;
    }

    @JsonProperty("collection")
    public Optional<Boolean> getCollection() {
        return Optional.ofNullable(collection);
    }

    @JsonProperty("collection")
    public void setCollection(Boolean collection) {
        this.collection = collection;
    }

    public Property withCollection(Boolean collection) {
        this.collection = collection;
        return this;
    }

    @JsonProperty("collectionName")
    public Optional<String> getCollectionName() {
        return Optional.ofNullable(collectionName);
    }

    @JsonProperty("collectionName")
    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public Property withCollectionName(String collectionName) {
        this.collectionName = collectionName;
        return this;
    }

    @JsonProperty("collectionWrapping")
    public Optional<Boolean> getCollectionWrapping() {
        return Optional.ofNullable(collectionWrapping);
    }

    @JsonProperty("collectionWrapping")
    public void setCollectionWrapping(Boolean collectionWrapping) {
        this.collectionWrapping = collectionWrapping;
    }

    public Property withCollectionWrapping(Boolean collectionWrapping) {
        this.collectionWrapping = collectionWrapping;
        return this;
    }

    @JsonProperty("constants")
    public Optional<List<String>> getConstants() {
        return Optional.ofNullable(constants);
    }

    @JsonProperty("constants")
    public void setConstants(List<String> constants) {
        this.constants = constants;
    }

    public Property withConstants(List<String> constants) {
        this.constants = constants;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("defaultValue")
    public Optional<Object> getDefaultValue() {
        return Optional.ofNullable(defaultValue);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("defaultValue")
    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Property withDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    @JsonProperty("description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    public Property withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty("embeddedObject")
    public Optional<Boolean> getEmbeddedObject() {
        return Optional.ofNullable(embeddedObject);
    }

    @JsonProperty("embeddedObject")
    public void setEmbeddedObject(Boolean embeddedObject) {
        this.embeddedObject = embeddedObject;
    }

    public Property withEmbeddedObject(Boolean embeddedObject) {
        this.embeddedObject = embeddedObject;
        return this;
    }

    @JsonProperty("fieldName")
    public Optional<String> getFieldName() {
        return Optional.ofNullable(fieldName);
    }

    @JsonProperty("fieldName")
    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public Property withFieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    @JsonProperty("gistPreferences")
    public Optional<GistPreferences> getGistPreferences() {
        return Optional.ofNullable(gistPreferences);
    }

    @JsonProperty("gistPreferences")
    public void setGistPreferences(GistPreferences gistPreferences) {
        this.gistPreferences = gistPreferences;
    }

    public Property withGistPreferences(GistPreferences gistPreferences) {
        this.gistPreferences = gistPreferences;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public Property withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("i18nTranslationKey")
    public Optional<String> getI18nTranslationKey() {
        return Optional.ofNullable(i18nTranslationKey);
    }

    @JsonProperty("i18nTranslationKey")
    public void setI18nTranslationKey(String i18nTranslationKey) {
        this.i18nTranslationKey = i18nTranslationKey;
    }

    public Property withI18nTranslationKey(String i18nTranslationKey) {
        this.i18nTranslationKey = i18nTranslationKey;
        return this;
    }

    @JsonProperty("identifiableObject")
    public Optional<Boolean> getIdentifiableObject() {
        return Optional.ofNullable(identifiableObject);
    }

    @JsonProperty("identifiableObject")
    public void setIdentifiableObject(Boolean identifiableObject) {
        this.identifiableObject = identifiableObject;
    }

    public Property withIdentifiableObject(Boolean identifiableObject) {
        this.identifiableObject = identifiableObject;
        return this;
    }

    @JsonProperty("inverseRole")
    public Optional<String> getInverseRole() {
        return Optional.ofNullable(inverseRole);
    }

    @JsonProperty("inverseRole")
    public void setInverseRole(String inverseRole) {
        this.inverseRole = inverseRole;
    }

    public Property withInverseRole(String inverseRole) {
        this.inverseRole = inverseRole;
        return this;
    }

    @JsonProperty("itemKlass")
    public Optional<String> getItemKlass() {
        return Optional.ofNullable(itemKlass);
    }

    @JsonProperty("itemKlass")
    public void setItemKlass(String itemKlass) {
        this.itemKlass = itemKlass;
    }

    public Property withItemKlass(String itemKlass) {
        this.itemKlass = itemKlass;
        return this;
    }

    @JsonProperty("itemPropertyType")
    public Optional<Property.PropertyType> getItemPropertyType() {
        return Optional.ofNullable(itemPropertyType);
    }

    @JsonProperty("itemPropertyType")
    public void setItemPropertyType(Property.PropertyType itemPropertyType) {
        this.itemPropertyType = itemPropertyType;
    }

    public Property withItemPropertyType(Property.PropertyType itemPropertyType) {
        this.itemPropertyType = itemPropertyType;
        return this;
    }

    @JsonProperty("klass")
    public Optional<String> getKlass() {
        return Optional.ofNullable(klass);
    }

    @JsonProperty("klass")
    public void setKlass(String klass) {
        this.klass = klass;
    }

    public Property withKlass(String klass) {
        this.klass = klass;
        return this;
    }

    @JsonProperty("length")
    public Optional<Integer> getLength() {
        return Optional.ofNullable(length);
    }

    @JsonProperty("length")
    public void setLength(Integer length) {
        this.length = length;
    }

    public Property withLength(Integer length) {
        this.length = length;
        return this;
    }

    @JsonProperty("manyToMany")
    public Optional<Boolean> getManyToMany() {
        return Optional.ofNullable(manyToMany);
    }

    @JsonProperty("manyToMany")
    public void setManyToMany(Boolean manyToMany) {
        this.manyToMany = manyToMany;
    }

    public Property withManyToMany(Boolean manyToMany) {
        this.manyToMany = manyToMany;
        return this;
    }

    @JsonProperty("manyToOne")
    public Optional<Boolean> getManyToOne() {
        return Optional.ofNullable(manyToOne);
    }

    @JsonProperty("manyToOne")
    public void setManyToOne(Boolean manyToOne) {
        this.manyToOne = manyToOne;
    }

    public Property withManyToOne(Boolean manyToOne) {
        this.manyToOne = manyToOne;
        return this;
    }

    @JsonProperty("max")
    public Optional<Double> getMax() {
        return Optional.ofNullable(max);
    }

    @JsonProperty("max")
    public void setMax(Double max) {
        this.max = max;
    }

    public Property withMax(Double max) {
        this.max = max;
        return this;
    }

    @JsonProperty("min")
    public Optional<Double> getMin() {
        return Optional.ofNullable(min);
    }

    @JsonProperty("min")
    public void setMin(Double min) {
        this.min = min;
    }

    public Property withMin(Double min) {
        this.min = min;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public Property withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("nameableObject")
    public Optional<Boolean> getNameableObject() {
        return Optional.ofNullable(nameableObject);
    }

    @JsonProperty("nameableObject")
    public void setNameableObject(Boolean nameableObject) {
        this.nameableObject = nameableObject;
    }

    public Property withNameableObject(Boolean nameableObject) {
        this.nameableObject = nameableObject;
        return this;
    }

    @JsonProperty("namespace")
    public Optional<String> getNamespace() {
        return Optional.ofNullable(namespace);
    }

    @JsonProperty("namespace")
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public Property withNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    @JsonProperty("oneToMany")
    public Optional<Boolean> getOneToMany() {
        return Optional.ofNullable(oneToMany);
    }

    @JsonProperty("oneToMany")
    public void setOneToMany(Boolean oneToMany) {
        this.oneToMany = oneToMany;
    }

    public Property withOneToMany(Boolean oneToMany) {
        this.oneToMany = oneToMany;
        return this;
    }

    @JsonProperty("oneToOne")
    public Optional<Boolean> getOneToOne() {
        return Optional.ofNullable(oneToOne);
    }

    @JsonProperty("oneToOne")
    public void setOneToOne(Boolean oneToOne) {
        this.oneToOne = oneToOne;
    }

    public Property withOneToOne(Boolean oneToOne) {
        this.oneToOne = oneToOne;
        return this;
    }

    @JsonProperty("ordered")
    public Optional<Boolean> getOrdered() {
        return Optional.ofNullable(ordered);
    }

    @JsonProperty("ordered")
    public void setOrdered(Boolean ordered) {
        this.ordered = ordered;
    }

    public Property withOrdered(Boolean ordered) {
        this.ordered = ordered;
        return this;
    }

    @JsonProperty("owner")
    public Optional<Boolean> getOwner() {
        return Optional.ofNullable(owner);
    }

    @JsonProperty("owner")
    public void setOwner(Boolean owner) {
        this.owner = owner;
    }

    public Property withOwner(Boolean owner) {
        this.owner = owner;
        return this;
    }

    @JsonProperty("owningRole")
    public Optional<String> getOwningRole() {
        return Optional.ofNullable(owningRole);
    }

    @JsonProperty("owningRole")
    public void setOwningRole(String owningRole) {
        this.owningRole = owningRole;
    }

    public Property withOwningRole(String owningRole) {
        this.owningRole = owningRole;
        return this;
    }

    @JsonProperty("persisted")
    public Optional<Boolean> getPersisted() {
        return Optional.ofNullable(persisted);
    }

    @JsonProperty("persisted")
    public void setPersisted(Boolean persisted) {
        this.persisted = persisted;
    }

    public Property withPersisted(Boolean persisted) {
        this.persisted = persisted;
        return this;
    }

    @JsonProperty("propertyTransformer")
    public Optional<Boolean> getPropertyTransformer() {
        return Optional.ofNullable(propertyTransformer);
    }

    @JsonProperty("propertyTransformer")
    public void setPropertyTransformer(Boolean propertyTransformer) {
        this.propertyTransformer = propertyTransformer;
    }

    public Property withPropertyTransformer(Boolean propertyTransformer) {
        this.propertyTransformer = propertyTransformer;
        return this;
    }

    @JsonProperty("propertyType")
    public Optional<Property.PropertyType> getPropertyType() {
        return Optional.ofNullable(propertyType);
    }

    @JsonProperty("propertyType")
    public void setPropertyType(Property.PropertyType propertyType) {
        this.propertyType = propertyType;
    }

    public Property withPropertyType(Property.PropertyType propertyType) {
        this.propertyType = propertyType;
        return this;
    }

    @JsonProperty("readable")
    public Optional<Boolean> getReadable() {
        return Optional.ofNullable(readable);
    }

    @JsonProperty("readable")
    public void setReadable(Boolean readable) {
        this.readable = readable;
    }

    public Property withReadable(Boolean readable) {
        this.readable = readable;
        return this;
    }

    @JsonProperty("relativeApiEndpoint")
    public Optional<String> getRelativeApiEndpoint() {
        return Optional.ofNullable(relativeApiEndpoint);
    }

    @JsonProperty("relativeApiEndpoint")
    public void setRelativeApiEndpoint(String relativeApiEndpoint) {
        this.relativeApiEndpoint = relativeApiEndpoint;
    }

    public Property withRelativeApiEndpoint(String relativeApiEndpoint) {
        this.relativeApiEndpoint = relativeApiEndpoint;
        return this;
    }

    @JsonProperty("required")
    public Optional<Boolean> getRequired() {
        return Optional.ofNullable(required);
    }

    @JsonProperty("required")
    public void setRequired(Boolean required) {
        this.required = required;
    }

    public Property withRequired(Boolean required) {
        this.required = required;
        return this;
    }

    @JsonProperty("simple")
    public Optional<Boolean> getSimple() {
        return Optional.ofNullable(simple);
    }

    @JsonProperty("simple")
    public void setSimple(Boolean simple) {
        this.simple = simple;
    }

    public Property withSimple(Boolean simple) {
        this.simple = simple;
        return this;
    }

    @JsonProperty("translatable")
    public Optional<Boolean> getTranslatable() {
        return Optional.ofNullable(translatable);
    }

    @JsonProperty("translatable")
    public void setTranslatable(Boolean translatable) {
        this.translatable = translatable;
    }

    public Property withTranslatable(Boolean translatable) {
        this.translatable = translatable;
        return this;
    }

    @JsonProperty("translationKey")
    public Optional<String> getTranslationKey() {
        return Optional.ofNullable(translationKey);
    }

    @JsonProperty("translationKey")
    public void setTranslationKey(String translationKey) {
        this.translationKey = translationKey;
    }

    public Property withTranslationKey(String translationKey) {
        this.translationKey = translationKey;
        return this;
    }

    @JsonProperty("unique")
    public Optional<Boolean> getUnique() {
        return Optional.ofNullable(unique);
    }

    @JsonProperty("unique")
    public void setUnique(Boolean unique) {
        this.unique = unique;
    }

    public Property withUnique(Boolean unique) {
        this.unique = unique;
        return this;
    }

    @JsonProperty("writable")
    public Optional<Boolean> getWritable() {
        return Optional.ofNullable(writable);
    }

    @JsonProperty("writable")
    public void setWritable(Boolean writable) {
        this.writable = writable;
    }

    public Property withWritable(Boolean writable) {
        this.writable = writable;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Property withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "analyticalObject":
                if (value instanceof Boolean) {
                    setAnalyticalObject(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"analyticalObject\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "apiEndpoint":
                if (value instanceof String) {
                    setApiEndpoint(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"apiEndpoint\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "attribute":
                if (value instanceof Boolean) {
                    setAttribute(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"attribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "cascade":
                if (value instanceof String) {
                    setCascade(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"cascade\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "collection":
                if (value instanceof Boolean) {
                    setCollection(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"collection\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "collectionName":
                if (value instanceof String) {
                    setCollectionName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"collectionName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "collectionWrapping":
                if (value instanceof Boolean) {
                    setCollectionWrapping(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"collectionWrapping\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "constants":
                if (value instanceof List) {
                    setConstants(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"constants\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "defaultValue":
                if (value instanceof Object) {
                    setDefaultValue(((Object) value));
                } else {
                    throw new IllegalArgumentException(("property \"defaultValue\" is of type \"java.lang.Object\", but got "+ value.getClass().toString()));
                }
                return true;
            case "description":
                if (value instanceof String) {
                    setDescription(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"description\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "embeddedObject":
                if (value instanceof Boolean) {
                    setEmbeddedObject(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"embeddedObject\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "fieldName":
                if (value instanceof String) {
                    setFieldName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"fieldName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "gistPreferences":
                if (value instanceof GistPreferences) {
                    setGistPreferences(((GistPreferences) value));
                } else {
                    throw new IllegalArgumentException(("property \"gistPreferences\" is of type \"org.hisp.dhis.api.model.v2_39_1.GistPreferences\", but got "+ value.getClass().toString()));
                }
                return true;
            case "href":
                if (value instanceof String) {
                    setHref(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "i18nTranslationKey":
                if (value instanceof String) {
                    setI18nTranslationKey(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"i18nTranslationKey\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "identifiableObject":
                if (value instanceof Boolean) {
                    setIdentifiableObject(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"identifiableObject\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "inverseRole":
                if (value instanceof String) {
                    setInverseRole(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"inverseRole\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "itemKlass":
                if (value instanceof String) {
                    setItemKlass(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"itemKlass\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "itemPropertyType":
                if (value instanceof Property.PropertyType) {
                    setItemPropertyType(((Property.PropertyType) value));
                } else {
                    throw new IllegalArgumentException(("property \"itemPropertyType\" is of type \"org.hisp.dhis.api.model.v2_39_1.Property.PropertyType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "klass":
                if (value instanceof String) {
                    setKlass(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"klass\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "length":
                if (value instanceof Integer) {
                    setLength(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"length\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "manyToMany":
                if (value instanceof Boolean) {
                    setManyToMany(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"manyToMany\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "manyToOne":
                if (value instanceof Boolean) {
                    setManyToOne(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"manyToOne\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "max":
                if (value instanceof Double) {
                    setMax(((Double) value));
                } else {
                    throw new IllegalArgumentException(("property \"max\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                }
                return true;
            case "min":
                if (value instanceof Double) {
                    setMin(((Double) value));
                } else {
                    throw new IllegalArgumentException(("property \"min\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                }
                return true;
            case "name":
                if (value instanceof String) {
                    setName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "nameableObject":
                if (value instanceof Boolean) {
                    setNameableObject(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"nameableObject\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "namespace":
                if (value instanceof String) {
                    setNamespace(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"namespace\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "oneToMany":
                if (value instanceof Boolean) {
                    setOneToMany(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"oneToMany\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "oneToOne":
                if (value instanceof Boolean) {
                    setOneToOne(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"oneToOne\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "ordered":
                if (value instanceof Boolean) {
                    setOrdered(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"ordered\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "owner":
                if (value instanceof Boolean) {
                    setOwner(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"owner\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "owningRole":
                if (value instanceof String) {
                    setOwningRole(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"owningRole\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "persisted":
                if (value instanceof Boolean) {
                    setPersisted(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"persisted\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "propertyTransformer":
                if (value instanceof Boolean) {
                    setPropertyTransformer(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"propertyTransformer\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "propertyType":
                if (value instanceof Property.PropertyType) {
                    setPropertyType(((Property.PropertyType) value));
                } else {
                    throw new IllegalArgumentException(("property \"propertyType\" is of type \"org.hisp.dhis.api.model.v2_39_1.Property.PropertyType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "readable":
                if (value instanceof Boolean) {
                    setReadable(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"readable\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "relativeApiEndpoint":
                if (value instanceof String) {
                    setRelativeApiEndpoint(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"relativeApiEndpoint\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "required":
                if (value instanceof Boolean) {
                    setRequired(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"required\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "simple":
                if (value instanceof Boolean) {
                    setSimple(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"simple\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "translatable":
                if (value instanceof Boolean) {
                    setTranslatable(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"translatable\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "translationKey":
                if (value instanceof String) {
                    setTranslationKey(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"translationKey\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "unique":
                if (value instanceof Boolean) {
                    setUnique(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"unique\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "writable":
                if (value instanceof Boolean) {
                    setWritable(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"writable\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "analyticalObject":
                return getAnalyticalObject();
            case "apiEndpoint":
                return getApiEndpoint();
            case "attribute":
                return getAttribute();
            case "cascade":
                return getCascade();
            case "collection":
                return getCollection();
            case "collectionName":
                return getCollectionName();
            case "collectionWrapping":
                return getCollectionWrapping();
            case "constants":
                return getConstants();
            case "defaultValue":
                return getDefaultValue();
            case "description":
                return getDescription();
            case "embeddedObject":
                return getEmbeddedObject();
            case "fieldName":
                return getFieldName();
            case "gistPreferences":
                return getGistPreferences();
            case "href":
                return getHref();
            case "i18nTranslationKey":
                return getI18nTranslationKey();
            case "identifiableObject":
                return getIdentifiableObject();
            case "inverseRole":
                return getInverseRole();
            case "itemKlass":
                return getItemKlass();
            case "itemPropertyType":
                return getItemPropertyType();
            case "klass":
                return getKlass();
            case "length":
                return getLength();
            case "manyToMany":
                return getManyToMany();
            case "manyToOne":
                return getManyToOne();
            case "max":
                return getMax();
            case "min":
                return getMin();
            case "name":
                return getName();
            case "nameableObject":
                return getNameableObject();
            case "namespace":
                return getNamespace();
            case "oneToMany":
                return getOneToMany();
            case "oneToOne":
                return getOneToOne();
            case "ordered":
                return getOrdered();
            case "owner":
                return getOwner();
            case "owningRole":
                return getOwningRole();
            case "persisted":
                return getPersisted();
            case "propertyTransformer":
                return getPropertyTransformer();
            case "propertyType":
                return getPropertyType();
            case "readable":
                return getReadable();
            case "relativeApiEndpoint":
                return getRelativeApiEndpoint();
            case "required":
                return getRequired();
            case "simple":
                return getSimple();
            case "translatable":
                return getTranslatable();
            case "translationKey":
                return getTranslationKey();
            case "unique":
                return getUnique();
            case "writable":
                return getWritable();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, Property.NOT_FOUND_VALUE);
        if (Property.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public Property with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Property.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("analyticalObject");
        sb.append('=');
        sb.append(((this.analyticalObject == null)?"<null>":this.analyticalObject));
        sb.append(',');
        sb.append("apiEndpoint");
        sb.append('=');
        sb.append(((this.apiEndpoint == null)?"<null>":this.apiEndpoint));
        sb.append(',');
        sb.append("attribute");
        sb.append('=');
        sb.append(((this.attribute == null)?"<null>":this.attribute));
        sb.append(',');
        sb.append("cascade");
        sb.append('=');
        sb.append(((this.cascade == null)?"<null>":this.cascade));
        sb.append(',');
        sb.append("collection");
        sb.append('=');
        sb.append(((this.collection == null)?"<null>":this.collection));
        sb.append(',');
        sb.append("collectionName");
        sb.append('=');
        sb.append(((this.collectionName == null)?"<null>":this.collectionName));
        sb.append(',');
        sb.append("collectionWrapping");
        sb.append('=');
        sb.append(((this.collectionWrapping == null)?"<null>":this.collectionWrapping));
        sb.append(',');
        sb.append("constants");
        sb.append('=');
        sb.append(((this.constants == null)?"<null>":this.constants));
        sb.append(',');
        sb.append("defaultValue");
        sb.append('=');
        sb.append(((this.defaultValue == null)?"<null>":this.defaultValue));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("embeddedObject");
        sb.append('=');
        sb.append(((this.embeddedObject == null)?"<null>":this.embeddedObject));
        sb.append(',');
        sb.append("fieldName");
        sb.append('=');
        sb.append(((this.fieldName == null)?"<null>":this.fieldName));
        sb.append(',');
        sb.append("gistPreferences");
        sb.append('=');
        sb.append(((this.gistPreferences == null)?"<null>":this.gistPreferences));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("i18nTranslationKey");
        sb.append('=');
        sb.append(((this.i18nTranslationKey == null)?"<null>":this.i18nTranslationKey));
        sb.append(',');
        sb.append("identifiableObject");
        sb.append('=');
        sb.append(((this.identifiableObject == null)?"<null>":this.identifiableObject));
        sb.append(',');
        sb.append("inverseRole");
        sb.append('=');
        sb.append(((this.inverseRole == null)?"<null>":this.inverseRole));
        sb.append(',');
        sb.append("itemKlass");
        sb.append('=');
        sb.append(((this.itemKlass == null)?"<null>":this.itemKlass));
        sb.append(',');
        sb.append("itemPropertyType");
        sb.append('=');
        sb.append(((this.itemPropertyType == null)?"<null>":this.itemPropertyType));
        sb.append(',');
        sb.append("klass");
        sb.append('=');
        sb.append(((this.klass == null)?"<null>":this.klass));
        sb.append(',');
        sb.append("length");
        sb.append('=');
        sb.append(((this.length == null)?"<null>":this.length));
        sb.append(',');
        sb.append("manyToMany");
        sb.append('=');
        sb.append(((this.manyToMany == null)?"<null>":this.manyToMany));
        sb.append(',');
        sb.append("manyToOne");
        sb.append('=');
        sb.append(((this.manyToOne == null)?"<null>":this.manyToOne));
        sb.append(',');
        sb.append("max");
        sb.append('=');
        sb.append(((this.max == null)?"<null>":this.max));
        sb.append(',');
        sb.append("min");
        sb.append('=');
        sb.append(((this.min == null)?"<null>":this.min));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("nameableObject");
        sb.append('=');
        sb.append(((this.nameableObject == null)?"<null>":this.nameableObject));
        sb.append(',');
        sb.append("namespace");
        sb.append('=');
        sb.append(((this.namespace == null)?"<null>":this.namespace));
        sb.append(',');
        sb.append("oneToMany");
        sb.append('=');
        sb.append(((this.oneToMany == null)?"<null>":this.oneToMany));
        sb.append(',');
        sb.append("oneToOne");
        sb.append('=');
        sb.append(((this.oneToOne == null)?"<null>":this.oneToOne));
        sb.append(',');
        sb.append("ordered");
        sb.append('=');
        sb.append(((this.ordered == null)?"<null>":this.ordered));
        sb.append(',');
        sb.append("owner");
        sb.append('=');
        sb.append(((this.owner == null)?"<null>":this.owner));
        sb.append(',');
        sb.append("owningRole");
        sb.append('=');
        sb.append(((this.owningRole == null)?"<null>":this.owningRole));
        sb.append(',');
        sb.append("persisted");
        sb.append('=');
        sb.append(((this.persisted == null)?"<null>":this.persisted));
        sb.append(',');
        sb.append("propertyTransformer");
        sb.append('=');
        sb.append(((this.propertyTransformer == null)?"<null>":this.propertyTransformer));
        sb.append(',');
        sb.append("propertyType");
        sb.append('=');
        sb.append(((this.propertyType == null)?"<null>":this.propertyType));
        sb.append(',');
        sb.append("readable");
        sb.append('=');
        sb.append(((this.readable == null)?"<null>":this.readable));
        sb.append(',');
        sb.append("relativeApiEndpoint");
        sb.append('=');
        sb.append(((this.relativeApiEndpoint == null)?"<null>":this.relativeApiEndpoint));
        sb.append(',');
        sb.append("required");
        sb.append('=');
        sb.append(((this.required == null)?"<null>":this.required));
        sb.append(',');
        sb.append("simple");
        sb.append('=');
        sb.append(((this.simple == null)?"<null>":this.simple));
        sb.append(',');
        sb.append("translatable");
        sb.append('=');
        sb.append(((this.translatable == null)?"<null>":this.translatable));
        sb.append(',');
        sb.append("translationKey");
        sb.append('=');
        sb.append(((this.translationKey == null)?"<null>":this.translationKey));
        sb.append(',');
        sb.append("unique");
        sb.append('=');
        sb.append(((this.unique == null)?"<null>":this.unique));
        sb.append(',');
        sb.append("writable");
        sb.append('=');
        sb.append(((this.writable == null)?"<null>":this.writable));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.relativeApiEndpoint == null)? 0 :this.relativeApiEndpoint.hashCode()));
        result = ((result* 31)+((this.fieldName == null)? 0 :this.fieldName.hashCode()));
        result = ((result* 31)+((this.translationKey == null)? 0 :this.translationKey.hashCode()));
        result = ((result* 31)+((this.defaultValue == null)? 0 :this.defaultValue.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.simple == null)? 0 :this.simple.hashCode()));
        result = ((result* 31)+((this.required == null)? 0 :this.required.hashCode()));
        result = ((result* 31)+((this.collectionName == null)? 0 :this.collectionName.hashCode()));
        result = ((result* 31)+((this.writable == null)? 0 :this.writable.hashCode()));
        result = ((result* 31)+((this.min == null)? 0 :this.min.hashCode()));
        result = ((result* 31)+((this.nameableObject == null)? 0 :this.nameableObject.hashCode()));
        result = ((result* 31)+((this.i18nTranslationKey == null)? 0 :this.i18nTranslationKey.hashCode()));
        result = ((result* 31)+((this.klass == null)? 0 :this.klass.hashCode()));
        result = ((result* 31)+((this.propertyType == null)? 0 :this.propertyType.hashCode()));
        result = ((result* 31)+((this.oneToOne == null)? 0 :this.oneToOne.hashCode()));
        result = ((result* 31)+((this.oneToMany == null)? 0 :this.oneToMany.hashCode()));
        result = ((result* 31)+((this.attribute == null)? 0 :this.attribute.hashCode()));
        result = ((result* 31)+((this.constants == null)? 0 :this.constants.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.propertyTransformer == null)? 0 :this.propertyTransformer.hashCode()));
        result = ((result* 31)+((this.owner == null)? 0 :this.owner.hashCode()));
        result = ((result* 31)+((this.readable == null)? 0 :this.readable.hashCode()));
        result = ((result* 31)+((this.ordered == null)? 0 :this.ordered.hashCode()));
        result = ((result* 31)+((this.translatable == null)? 0 :this.translatable.hashCode()));
        result = ((result* 31)+((this.identifiableObject == null)? 0 :this.identifiableObject.hashCode()));
        result = ((result* 31)+((this.max == null)? 0 :this.max.hashCode()));
        result = ((result* 31)+((this.cascade == null)? 0 :this.cascade.hashCode()));
        result = ((result* 31)+((this.manyToMany == null)? 0 :this.manyToMany.hashCode()));
        result = ((result* 31)+((this.length == null)? 0 :this.length.hashCode()));
        result = ((result* 31)+((this.collection == null)? 0 :this.collection.hashCode()));
        result = ((result* 31)+((this.gistPreferences == null)? 0 :this.gistPreferences.hashCode()));
        result = ((result* 31)+((this.itemPropertyType == null)? 0 :this.itemPropertyType.hashCode()));
        result = ((result* 31)+((this.owningRole == null)? 0 :this.owningRole.hashCode()));
        result = ((result* 31)+((this.collectionWrapping == null)? 0 :this.collectionWrapping.hashCode()));
        result = ((result* 31)+((this.itemKlass == null)? 0 :this.itemKlass.hashCode()));
        result = ((result* 31)+((this.inverseRole == null)? 0 :this.inverseRole.hashCode()));
        result = ((result* 31)+((this.apiEndpoint == null)? 0 :this.apiEndpoint.hashCode()));
        result = ((result* 31)+((this.analyticalObject == null)? 0 :this.analyticalObject.hashCode()));
        result = ((result* 31)+((this.embeddedObject == null)? 0 :this.embeddedObject.hashCode()));
        result = ((result* 31)+((this.unique == null)? 0 :this.unique.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.namespace == null)? 0 :this.namespace.hashCode()));
        result = ((result* 31)+((this.persisted == null)? 0 :this.persisted.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.manyToOne == null)? 0 :this.manyToOne.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Property) == false) {
            return false;
        }
        Property rhs = ((Property) other);
        return ((((((((((((((((((((((((((((((((((((((((((((((this.relativeApiEndpoint == rhs.relativeApiEndpoint)||((this.relativeApiEndpoint!= null)&&this.relativeApiEndpoint.equals(rhs.relativeApiEndpoint)))&&((this.fieldName == rhs.fieldName)||((this.fieldName!= null)&&this.fieldName.equals(rhs.fieldName))))&&((this.translationKey == rhs.translationKey)||((this.translationKey!= null)&&this.translationKey.equals(rhs.translationKey))))&&((this.defaultValue == rhs.defaultValue)||((this.defaultValue!= null)&&this.defaultValue.equals(rhs.defaultValue))))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.simple == rhs.simple)||((this.simple!= null)&&this.simple.equals(rhs.simple))))&&((this.required == rhs.required)||((this.required!= null)&&this.required.equals(rhs.required))))&&((this.collectionName == rhs.collectionName)||((this.collectionName!= null)&&this.collectionName.equals(rhs.collectionName))))&&((this.writable == rhs.writable)||((this.writable!= null)&&this.writable.equals(rhs.writable))))&&((this.min == rhs.min)||((this.min!= null)&&this.min.equals(rhs.min))))&&((this.nameableObject == rhs.nameableObject)||((this.nameableObject!= null)&&this.nameableObject.equals(rhs.nameableObject))))&&((this.i18nTranslationKey == rhs.i18nTranslationKey)||((this.i18nTranslationKey!= null)&&this.i18nTranslationKey.equals(rhs.i18nTranslationKey))))&&((this.klass == rhs.klass)||((this.klass!= null)&&this.klass.equals(rhs.klass))))&&((this.propertyType == rhs.propertyType)||((this.propertyType!= null)&&this.propertyType.equals(rhs.propertyType))))&&((this.oneToOne == rhs.oneToOne)||((this.oneToOne!= null)&&this.oneToOne.equals(rhs.oneToOne))))&&((this.oneToMany == rhs.oneToMany)||((this.oneToMany!= null)&&this.oneToMany.equals(rhs.oneToMany))))&&((this.attribute == rhs.attribute)||((this.attribute!= null)&&this.attribute.equals(rhs.attribute))))&&((this.constants == rhs.constants)||((this.constants!= null)&&this.constants.equals(rhs.constants))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.propertyTransformer == rhs.propertyTransformer)||((this.propertyTransformer!= null)&&this.propertyTransformer.equals(rhs.propertyTransformer))))&&((this.owner == rhs.owner)||((this.owner!= null)&&this.owner.equals(rhs.owner))))&&((this.readable == rhs.readable)||((this.readable!= null)&&this.readable.equals(rhs.readable))))&&((this.ordered == rhs.ordered)||((this.ordered!= null)&&this.ordered.equals(rhs.ordered))))&&((this.translatable == rhs.translatable)||((this.translatable!= null)&&this.translatable.equals(rhs.translatable))))&&((this.identifiableObject == rhs.identifiableObject)||((this.identifiableObject!= null)&&this.identifiableObject.equals(rhs.identifiableObject))))&&((this.max == rhs.max)||((this.max!= null)&&this.max.equals(rhs.max))))&&((this.cascade == rhs.cascade)||((this.cascade!= null)&&this.cascade.equals(rhs.cascade))))&&((this.manyToMany == rhs.manyToMany)||((this.manyToMany!= null)&&this.manyToMany.equals(rhs.manyToMany))))&&((this.length == rhs.length)||((this.length!= null)&&this.length.equals(rhs.length))))&&((this.collection == rhs.collection)||((this.collection!= null)&&this.collection.equals(rhs.collection))))&&((this.gistPreferences == rhs.gistPreferences)||((this.gistPreferences!= null)&&this.gistPreferences.equals(rhs.gistPreferences))))&&((this.itemPropertyType == rhs.itemPropertyType)||((this.itemPropertyType!= null)&&this.itemPropertyType.equals(rhs.itemPropertyType))))&&((this.owningRole == rhs.owningRole)||((this.owningRole!= null)&&this.owningRole.equals(rhs.owningRole))))&&((this.collectionWrapping == rhs.collectionWrapping)||((this.collectionWrapping!= null)&&this.collectionWrapping.equals(rhs.collectionWrapping))))&&((this.itemKlass == rhs.itemKlass)||((this.itemKlass!= null)&&this.itemKlass.equals(rhs.itemKlass))))&&((this.inverseRole == rhs.inverseRole)||((this.inverseRole!= null)&&this.inverseRole.equals(rhs.inverseRole))))&&((this.apiEndpoint == rhs.apiEndpoint)||((this.apiEndpoint!= null)&&this.apiEndpoint.equals(rhs.apiEndpoint))))&&((this.analyticalObject == rhs.analyticalObject)||((this.analyticalObject!= null)&&this.analyticalObject.equals(rhs.analyticalObject))))&&((this.embeddedObject == rhs.embeddedObject)||((this.embeddedObject!= null)&&this.embeddedObject.equals(rhs.embeddedObject))))&&((this.unique == rhs.unique)||((this.unique!= null)&&this.unique.equals(rhs.unique))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.namespace == rhs.namespace)||((this.namespace!= null)&&this.namespace.equals(rhs.namespace))))&&((this.persisted == rhs.persisted)||((this.persisted!= null)&&this.persisted.equals(rhs.persisted))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.manyToOne == rhs.manyToOne)||((this.manyToOne!= null)&&this.manyToOne.equals(rhs.manyToOne))));
    }

    @Generated("jsonschema2pojo")
    public enum PropertyType {

        IDENTIFIER("IDENTIFIER"),
        TEXT("TEXT"),
        NUMBER("NUMBER"),
        INTEGER("INTEGER"),
        BOOLEAN("BOOLEAN"),
        USERNAME("USERNAME"),
        EMAIL("EMAIL"),
        PASSWORD("PASSWORD"),
        URL("URL"),
        DATE("DATE"),
        PHONENUMBER("PHONENUMBER"),
        GEOLOCATION("GEOLOCATION"),
        COLOR("COLOR"),
        CONSTANT("CONSTANT"),
        COMPLEX("COMPLEX"),
        COLLECTION("COLLECTION"),
        REFERENCE("REFERENCE");
        private final String value;
        private final static Map<String, Property.PropertyType> CONSTANTS = new HashMap<String, Property.PropertyType>();

        static {
            for (Property.PropertyType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        PropertyType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Property.PropertyType fromValue(String value) {
            Property.PropertyType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
