
package org.hisp.dhis.api.model.v2_39_1;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "annualSampleCount",
    "attributeValues",
    "code",
    "created",
    "createdBy",
    "description",
    "displayDescription",
    "displayFormName",
    "displayName",
    "displayShortName",
    "externalAccess",
    "favorite",
    "favorites",
    "formName",
    "generator",
    "href",
    "id",
    "lastUpdated",
    "lastUpdatedBy",
    "name",
    "organisationUnitDescendants",
    "organisationUnitLevels",
    "output",
    "outputCombo",
    "periodType",
    "predictorGroups",
    "publicAccess",
    "sampleSkipTest",
    "sequentialSampleCount",
    "sequentialSkipCount",
    "sharing",
    "shortName",
    "translations",
    "user",
    "userAccesses",
    "userGroupAccesses"
})
@Generated("jsonschema2pojo")
public class Predictor implements Serializable
{

    @JsonProperty("access")
    private Access access;
    @JsonProperty("annualSampleCount")
    private Integer annualSampleCount;
    @JsonProperty("attributeValues")
    private List<AttributeValue> attributeValues = null;
    @JsonProperty("code")
    private String code;
    @JsonProperty("created")
    private Date created;
    @JsonProperty("createdBy")
    private User createdBy;
    @JsonProperty("description")
    private String description;
    @JsonProperty("displayDescription")
    private String displayDescription;
    @JsonProperty("displayFormName")
    private String displayFormName;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("displayShortName")
    private String displayShortName;
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    @JsonProperty("favorite")
    private Boolean favorite;
    @JsonProperty("favorites")
    private List<String> favorites = null;
    @JsonProperty("formName")
    private String formName;
    @JsonProperty("generator")
    private Expression generator;
    @JsonProperty("href")
    private String href;
    @JsonProperty("id")
    private String id;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    @JsonProperty("lastUpdatedBy")
    private User lastUpdatedBy;
    @JsonProperty("name")
    private String name;
    @JsonProperty("organisationUnitDescendants")
    private Predictor.OrganisationUnitDescendants organisationUnitDescendants;
    @JsonProperty("organisationUnitLevels")
    private List<OrganisationUnitLevel> organisationUnitLevels = null;
    @JsonProperty("output")
    private DataElement output;
    @JsonProperty("outputCombo")
    private CategoryOptionCombo outputCombo;
    /**
     * Undefined
     * 
     */
    @JsonProperty("periodType")
    private Object periodType;
    @JsonProperty("predictorGroups")
    private List<PredictorGroup> predictorGroups = null;
    @JsonProperty("publicAccess")
    private String publicAccess;
    @JsonProperty("sampleSkipTest")
    private Expression sampleSkipTest;
    @JsonProperty("sequentialSampleCount")
    private Integer sequentialSampleCount;
    @JsonProperty("sequentialSkipCount")
    private Integer sequentialSkipCount;
    @JsonProperty("sharing")
    private Sharing sharing;
    @JsonProperty("shortName")
    private String shortName;
    @JsonProperty("translations")
    private List<Translation> translations = null;
    @JsonProperty("user")
    private User user;
    @JsonProperty("userAccesses")
    private List<UserAccess> userAccesses = null;
    @JsonProperty("userGroupAccesses")
    private List<UserGroupAccess> userGroupAccesses = null;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -5961737323281020972L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Predictor() {
    }

    /**
     * 
     * @param source
     */
    public Predictor(Predictor source) {
        super();
        this.access = source.access;
        this.annualSampleCount = source.annualSampleCount;
        this.attributeValues = source.attributeValues;
        this.code = source.code;
        this.created = source.created;
        this.createdBy = source.createdBy;
        this.description = source.description;
        this.displayDescription = source.displayDescription;
        this.displayFormName = source.displayFormName;
        this.displayName = source.displayName;
        this.displayShortName = source.displayShortName;
        this.externalAccess = source.externalAccess;
        this.favorite = source.favorite;
        this.favorites = source.favorites;
        this.formName = source.formName;
        this.generator = source.generator;
        this.href = source.href;
        this.id = source.id;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.name = source.name;
        this.organisationUnitDescendants = source.organisationUnitDescendants;
        this.organisationUnitLevels = source.organisationUnitLevels;
        this.output = source.output;
        this.outputCombo = source.outputCombo;
        this.periodType = source.periodType;
        this.predictorGroups = source.predictorGroups;
        this.publicAccess = source.publicAccess;
        this.sampleSkipTest = source.sampleSkipTest;
        this.sequentialSampleCount = source.sequentialSampleCount;
        this.sequentialSkipCount = source.sequentialSkipCount;
        this.sharing = source.sharing;
        this.shortName = source.shortName;
        this.translations = source.translations;
        this.user = source.user;
        this.userAccesses = source.userAccesses;
        this.userGroupAccesses = source.userGroupAccesses;
    }

    /**
     * 
     * @param favorites
     * @param outputCombo
     * @param access
     * @param code
     * @param displayName
     * @param publicAccess
     * @param description
     * @param generator
     * @param displayShortName
     * @param externalAccess
     * @param organisationUnitLevels
     * @param output
     * @param lastUpdated
     * @param organisationUnitDescendants
     * @param sampleSkipTest
     * @param translations
     * @param formName
     * @param href
     * @param id
     * @param sequentialSampleCount
     * @param annualSampleCount
     * @param displayDescription
     * @param lastUpdatedBy
     * @param userGroupAccesses
     * @param created
     * @param attributeValues
     * @param sequentialSkipCount
     * @param predictorGroups
     * @param sharing
     * @param displayFormName
     * @param periodType
     * @param createdBy
     * @param userAccesses
     * @param name
     * @param shortName
     * @param favorite
     * @param user
     */
    public Predictor(Access access, Integer annualSampleCount, List<AttributeValue> attributeValues, String code, Date created, User createdBy, String description, String displayDescription, String displayFormName, String displayName, String displayShortName, Boolean externalAccess, Boolean favorite, List<String> favorites, String formName, Expression generator, String href, String id, Date lastUpdated, User lastUpdatedBy, String name, Predictor.OrganisationUnitDescendants organisationUnitDescendants, List<OrganisationUnitLevel> organisationUnitLevels, DataElement output, CategoryOptionCombo outputCombo, Object periodType, List<PredictorGroup> predictorGroups, String publicAccess, Expression sampleSkipTest, Integer sequentialSampleCount, Integer sequentialSkipCount, Sharing sharing, String shortName, List<Translation> translations, User user, List<UserAccess> userAccesses, List<UserGroupAccess> userGroupAccesses) {
        super();
        this.access = access;
        this.annualSampleCount = annualSampleCount;
        this.attributeValues = attributeValues;
        this.code = code;
        this.created = created;
        this.createdBy = createdBy;
        this.description = description;
        this.displayDescription = displayDescription;
        this.displayFormName = displayFormName;
        this.displayName = displayName;
        this.displayShortName = displayShortName;
        this.externalAccess = externalAccess;
        this.favorite = favorite;
        this.favorites = favorites;
        this.formName = formName;
        this.generator = generator;
        this.href = href;
        this.id = id;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedBy = lastUpdatedBy;
        this.name = name;
        this.organisationUnitDescendants = organisationUnitDescendants;
        this.organisationUnitLevels = organisationUnitLevels;
        this.output = output;
        this.outputCombo = outputCombo;
        this.periodType = periodType;
        this.predictorGroups = predictorGroups;
        this.publicAccess = publicAccess;
        this.sampleSkipTest = sampleSkipTest;
        this.sequentialSampleCount = sequentialSampleCount;
        this.sequentialSkipCount = sequentialSkipCount;
        this.sharing = sharing;
        this.shortName = shortName;
        this.translations = translations;
        this.user = user;
        this.userAccesses = userAccesses;
        this.userGroupAccesses = userGroupAccesses;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public Predictor withAccess(Access access) {
        this.access = access;
        return this;
    }

    @JsonProperty("annualSampleCount")
    public Optional<Integer> getAnnualSampleCount() {
        return Optional.ofNullable(annualSampleCount);
    }

    @JsonProperty("annualSampleCount")
    public void setAnnualSampleCount(Integer annualSampleCount) {
        this.annualSampleCount = annualSampleCount;
    }

    public Predictor withAnnualSampleCount(Integer annualSampleCount) {
        this.annualSampleCount = annualSampleCount;
        return this;
    }

    @JsonProperty("attributeValues")
    public Optional<List<AttributeValue>> getAttributeValues() {
        return Optional.ofNullable(attributeValues);
    }

    @JsonProperty("attributeValues")
    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public Predictor withAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public Predictor withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public Predictor withCreated(Date created) {
        this.created = created;
        return this;
    }

    @JsonProperty("createdBy")
    public Optional<User> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    @JsonProperty("createdBy")
    public void setCreatedBy(User createdBy) {
        this.createdBy = createdBy;
    }

    public Predictor withCreatedBy(User createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @JsonProperty("description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    public Predictor withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty("displayDescription")
    public Optional<String> getDisplayDescription() {
        return Optional.ofNullable(displayDescription);
    }

    @JsonProperty("displayDescription")
    public void setDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
    }

    public Predictor withDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
        return this;
    }

    @JsonProperty("displayFormName")
    public Optional<String> getDisplayFormName() {
        return Optional.ofNullable(displayFormName);
    }

    @JsonProperty("displayFormName")
    public void setDisplayFormName(String displayFormName) {
        this.displayFormName = displayFormName;
    }

    public Predictor withDisplayFormName(String displayFormName) {
        this.displayFormName = displayFormName;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Predictor withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("displayShortName")
    public Optional<String> getDisplayShortName() {
        return Optional.ofNullable(displayShortName);
    }

    @JsonProperty("displayShortName")
    public void setDisplayShortName(String displayShortName) {
        this.displayShortName = displayShortName;
    }

    public Predictor withDisplayShortName(String displayShortName) {
        this.displayShortName = displayShortName;
        return this;
    }

    @JsonProperty("externalAccess")
    public Optional<Boolean> getExternalAccess() {
        return Optional.ofNullable(externalAccess);
    }

    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public Predictor withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    @JsonProperty("favorite")
    public Optional<Boolean> getFavorite() {
        return Optional.ofNullable(favorite);
    }

    @JsonProperty("favorite")
    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public Predictor withFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public Predictor withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    @JsonProperty("formName")
    public Optional<String> getFormName() {
        return Optional.ofNullable(formName);
    }

    @JsonProperty("formName")
    public void setFormName(String formName) {
        this.formName = formName;
    }

    public Predictor withFormName(String formName) {
        this.formName = formName;
        return this;
    }

    @JsonProperty("generator")
    public Optional<Expression> getGenerator() {
        return Optional.ofNullable(generator);
    }

    @JsonProperty("generator")
    public void setGenerator(Expression generator) {
        this.generator = generator;
    }

    public Predictor withGenerator(Expression generator) {
        this.generator = generator;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public Predictor withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public Predictor withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public Predictor withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    @JsonProperty("lastUpdatedBy")
    public Optional<User> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public Predictor withLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public Predictor withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("organisationUnitDescendants")
    public Optional<Predictor.OrganisationUnitDescendants> getOrganisationUnitDescendants() {
        return Optional.ofNullable(organisationUnitDescendants);
    }

    @JsonProperty("organisationUnitDescendants")
    public void setOrganisationUnitDescendants(Predictor.OrganisationUnitDescendants organisationUnitDescendants) {
        this.organisationUnitDescendants = organisationUnitDescendants;
    }

    public Predictor withOrganisationUnitDescendants(Predictor.OrganisationUnitDescendants organisationUnitDescendants) {
        this.organisationUnitDescendants = organisationUnitDescendants;
        return this;
    }

    @JsonProperty("organisationUnitLevels")
    public Optional<List<OrganisationUnitLevel>> getOrganisationUnitLevels() {
        return Optional.ofNullable(organisationUnitLevels);
    }

    @JsonProperty("organisationUnitLevels")
    public void setOrganisationUnitLevels(List<OrganisationUnitLevel> organisationUnitLevels) {
        this.organisationUnitLevels = organisationUnitLevels;
    }

    public Predictor withOrganisationUnitLevels(List<OrganisationUnitLevel> organisationUnitLevels) {
        this.organisationUnitLevels = organisationUnitLevels;
        return this;
    }

    @JsonProperty("output")
    public Optional<DataElement> getOutput() {
        return Optional.ofNullable(output);
    }

    @JsonProperty("output")
    public void setOutput(DataElement output) {
        this.output = output;
    }

    public Predictor withOutput(DataElement output) {
        this.output = output;
        return this;
    }

    @JsonProperty("outputCombo")
    public Optional<CategoryOptionCombo> getOutputCombo() {
        return Optional.ofNullable(outputCombo);
    }

    @JsonProperty("outputCombo")
    public void setOutputCombo(CategoryOptionCombo outputCombo) {
        this.outputCombo = outputCombo;
    }

    public Predictor withOutputCombo(CategoryOptionCombo outputCombo) {
        this.outputCombo = outputCombo;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("periodType")
    public Optional<Object> getPeriodType() {
        return Optional.ofNullable(periodType);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("periodType")
    public void setPeriodType(Object periodType) {
        this.periodType = periodType;
    }

    public Predictor withPeriodType(Object periodType) {
        this.periodType = periodType;
        return this;
    }

    @JsonProperty("predictorGroups")
    public Optional<List<PredictorGroup>> getPredictorGroups() {
        return Optional.ofNullable(predictorGroups);
    }

    @JsonProperty("predictorGroups")
    public void setPredictorGroups(List<PredictorGroup> predictorGroups) {
        this.predictorGroups = predictorGroups;
    }

    public Predictor withPredictorGroups(List<PredictorGroup> predictorGroups) {
        this.predictorGroups = predictorGroups;
        return this;
    }

    @JsonProperty("publicAccess")
    public Optional<String> getPublicAccess() {
        return Optional.ofNullable(publicAccess);
    }

    @JsonProperty("publicAccess")
    public void setPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
    }

    public Predictor withPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    @JsonProperty("sampleSkipTest")
    public Optional<Expression> getSampleSkipTest() {
        return Optional.ofNullable(sampleSkipTest);
    }

    @JsonProperty("sampleSkipTest")
    public void setSampleSkipTest(Expression sampleSkipTest) {
        this.sampleSkipTest = sampleSkipTest;
    }

    public Predictor withSampleSkipTest(Expression sampleSkipTest) {
        this.sampleSkipTest = sampleSkipTest;
        return this;
    }

    @JsonProperty("sequentialSampleCount")
    public Optional<Integer> getSequentialSampleCount() {
        return Optional.ofNullable(sequentialSampleCount);
    }

    @JsonProperty("sequentialSampleCount")
    public void setSequentialSampleCount(Integer sequentialSampleCount) {
        this.sequentialSampleCount = sequentialSampleCount;
    }

    public Predictor withSequentialSampleCount(Integer sequentialSampleCount) {
        this.sequentialSampleCount = sequentialSampleCount;
        return this;
    }

    @JsonProperty("sequentialSkipCount")
    public Optional<Integer> getSequentialSkipCount() {
        return Optional.ofNullable(sequentialSkipCount);
    }

    @JsonProperty("sequentialSkipCount")
    public void setSequentialSkipCount(Integer sequentialSkipCount) {
        this.sequentialSkipCount = sequentialSkipCount;
    }

    public Predictor withSequentialSkipCount(Integer sequentialSkipCount) {
        this.sequentialSkipCount = sequentialSkipCount;
        return this;
    }

    @JsonProperty("sharing")
    public Optional<Sharing> getSharing() {
        return Optional.ofNullable(sharing);
    }

    @JsonProperty("sharing")
    public void setSharing(Sharing sharing) {
        this.sharing = sharing;
    }

    public Predictor withSharing(Sharing sharing) {
        this.sharing = sharing;
        return this;
    }

    @JsonProperty("shortName")
    public Optional<String> getShortName() {
        return Optional.ofNullable(shortName);
    }

    @JsonProperty("shortName")
    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public Predictor withShortName(String shortName) {
        this.shortName = shortName;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public Predictor withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    @JsonProperty("user")
    public Optional<User> getUser() {
        return Optional.ofNullable(user);
    }

    @JsonProperty("user")
    public void setUser(User user) {
        this.user = user;
    }

    public Predictor withUser(User user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<UserAccess>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public Predictor withUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<UserGroupAccess>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public Predictor withUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Predictor withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "access":
                if (value instanceof Access) {
                    setAccess(((Access) value));
                } else {
                    throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v2_39_1.Access\", but got "+ value.getClass().toString()));
                }
                return true;
            case "annualSampleCount":
                if (value instanceof Integer) {
                    setAnnualSampleCount(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"annualSampleCount\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "attributeValues":
                if (value instanceof List) {
                    setAttributeValues(((List<AttributeValue> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.AttributeValue>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "code":
                if (value instanceof String) {
                    setCode(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "created":
                if (value instanceof Date) {
                    setCreated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "createdBy":
                if (value instanceof User) {
                    setCreatedBy(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"createdBy\" is of type \"org.hisp.dhis.api.model.v2_39_1.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "description":
                if (value instanceof String) {
                    setDescription(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"description\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayDescription":
                if (value instanceof String) {
                    setDisplayDescription(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayDescription\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayFormName":
                if (value instanceof String) {
                    setDisplayFormName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayFormName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayName":
                if (value instanceof String) {
                    setDisplayName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayShortName":
                if (value instanceof String) {
                    setDisplayShortName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayShortName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "externalAccess":
                if (value instanceof Boolean) {
                    setExternalAccess(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "favorite":
                if (value instanceof Boolean) {
                    setFavorite(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"favorite\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "favorites":
                if (value instanceof List) {
                    setFavorites(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "formName":
                if (value instanceof String) {
                    setFormName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"formName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "generator":
                if (value instanceof Expression) {
                    setGenerator(((Expression) value));
                } else {
                    throw new IllegalArgumentException(("property \"generator\" is of type \"org.hisp.dhis.api.model.v2_39_1.Expression\", but got "+ value.getClass().toString()));
                }
                return true;
            case "href":
                if (value instanceof String) {
                    setHref(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "id":
                if (value instanceof String) {
                    setId(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdated":
                if (value instanceof Date) {
                    setLastUpdated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdatedBy":
                if (value instanceof User) {
                    setLastUpdatedBy(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"org.hisp.dhis.api.model.v2_39_1.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "name":
                if (value instanceof String) {
                    setName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "organisationUnitDescendants":
                if (value instanceof Predictor.OrganisationUnitDescendants) {
                    setOrganisationUnitDescendants(((Predictor.OrganisationUnitDescendants) value));
                } else {
                    throw new IllegalArgumentException(("property \"organisationUnitDescendants\" is of type \"org.hisp.dhis.api.model.v2_39_1.Predictor.OrganisationUnitDescendants\", but got "+ value.getClass().toString()));
                }
                return true;
            case "organisationUnitLevels":
                if (value instanceof List) {
                    setOrganisationUnitLevels(((List<OrganisationUnitLevel> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"organisationUnitLevels\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.OrganisationUnitLevel>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "output":
                if (value instanceof DataElement) {
                    setOutput(((DataElement) value));
                } else {
                    throw new IllegalArgumentException(("property \"output\" is of type \"org.hisp.dhis.api.model.v2_39_1.DataElement\", but got "+ value.getClass().toString()));
                }
                return true;
            case "outputCombo":
                if (value instanceof CategoryOptionCombo) {
                    setOutputCombo(((CategoryOptionCombo) value));
                } else {
                    throw new IllegalArgumentException(("property \"outputCombo\" is of type \"org.hisp.dhis.api.model.v2_39_1.CategoryOptionCombo\", but got "+ value.getClass().toString()));
                }
                return true;
            case "periodType":
                if (value instanceof Object) {
                    setPeriodType(((Object) value));
                } else {
                    throw new IllegalArgumentException(("property \"periodType\" is of type \"java.lang.Object\", but got "+ value.getClass().toString()));
                }
                return true;
            case "predictorGroups":
                if (value instanceof List) {
                    setPredictorGroups(((List<PredictorGroup> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"predictorGroups\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.PredictorGroup>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "publicAccess":
                if (value instanceof String) {
                    setPublicAccess(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"publicAccess\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "sampleSkipTest":
                if (value instanceof Expression) {
                    setSampleSkipTest(((Expression) value));
                } else {
                    throw new IllegalArgumentException(("property \"sampleSkipTest\" is of type \"org.hisp.dhis.api.model.v2_39_1.Expression\", but got "+ value.getClass().toString()));
                }
                return true;
            case "sequentialSampleCount":
                if (value instanceof Integer) {
                    setSequentialSampleCount(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"sequentialSampleCount\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "sequentialSkipCount":
                if (value instanceof Integer) {
                    setSequentialSkipCount(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"sequentialSkipCount\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "sharing":
                if (value instanceof Sharing) {
                    setSharing(((Sharing) value));
                } else {
                    throw new IllegalArgumentException(("property \"sharing\" is of type \"org.hisp.dhis.api.model.v2_39_1.Sharing\", but got "+ value.getClass().toString()));
                }
                return true;
            case "shortName":
                if (value instanceof String) {
                    setShortName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"shortName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "translations":
                if (value instanceof List) {
                    setTranslations(((List<Translation> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.Translation>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "user":
                if (value instanceof User) {
                    setUser(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v2_39_1.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userAccesses":
                if (value instanceof List) {
                    setUserAccesses(((List<UserAccess> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.UserAccess>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userGroupAccesses":
                if (value instanceof List) {
                    setUserGroupAccesses(((List<UserGroupAccess> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.UserGroupAccess>\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "access":
                return getAccess();
            case "annualSampleCount":
                return getAnnualSampleCount();
            case "attributeValues":
                return getAttributeValues();
            case "code":
                return getCode();
            case "created":
                return getCreated();
            case "createdBy":
                return getCreatedBy();
            case "description":
                return getDescription();
            case "displayDescription":
                return getDisplayDescription();
            case "displayFormName":
                return getDisplayFormName();
            case "displayName":
                return getDisplayName();
            case "displayShortName":
                return getDisplayShortName();
            case "externalAccess":
                return getExternalAccess();
            case "favorite":
                return getFavorite();
            case "favorites":
                return getFavorites();
            case "formName":
                return getFormName();
            case "generator":
                return getGenerator();
            case "href":
                return getHref();
            case "id":
                return getId();
            case "lastUpdated":
                return getLastUpdated();
            case "lastUpdatedBy":
                return getLastUpdatedBy();
            case "name":
                return getName();
            case "organisationUnitDescendants":
                return getOrganisationUnitDescendants();
            case "organisationUnitLevels":
                return getOrganisationUnitLevels();
            case "output":
                return getOutput();
            case "outputCombo":
                return getOutputCombo();
            case "periodType":
                return getPeriodType();
            case "predictorGroups":
                return getPredictorGroups();
            case "publicAccess":
                return getPublicAccess();
            case "sampleSkipTest":
                return getSampleSkipTest();
            case "sequentialSampleCount":
                return getSequentialSampleCount();
            case "sequentialSkipCount":
                return getSequentialSkipCount();
            case "sharing":
                return getSharing();
            case "shortName":
                return getShortName();
            case "translations":
                return getTranslations();
            case "user":
                return getUser();
            case "userAccesses":
                return getUserAccesses();
            case "userGroupAccesses":
                return getUserGroupAccesses();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, Predictor.NOT_FOUND_VALUE);
        if (Predictor.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public Predictor with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Predictor.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("annualSampleCount");
        sb.append('=');
        sb.append(((this.annualSampleCount == null)?"<null>":this.annualSampleCount));
        sb.append(',');
        sb.append("attributeValues");
        sb.append('=');
        sb.append(((this.attributeValues == null)?"<null>":this.attributeValues));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("createdBy");
        sb.append('=');
        sb.append(((this.createdBy == null)?"<null>":this.createdBy));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("displayDescription");
        sb.append('=');
        sb.append(((this.displayDescription == null)?"<null>":this.displayDescription));
        sb.append(',');
        sb.append("displayFormName");
        sb.append('=');
        sb.append(((this.displayFormName == null)?"<null>":this.displayFormName));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("displayShortName");
        sb.append('=');
        sb.append(((this.displayShortName == null)?"<null>":this.displayShortName));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("favorite");
        sb.append('=');
        sb.append(((this.favorite == null)?"<null>":this.favorite));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("formName");
        sb.append('=');
        sb.append(((this.formName == null)?"<null>":this.formName));
        sb.append(',');
        sb.append("generator");
        sb.append('=');
        sb.append(((this.generator == null)?"<null>":this.generator));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("organisationUnitDescendants");
        sb.append('=');
        sb.append(((this.organisationUnitDescendants == null)?"<null>":this.organisationUnitDescendants));
        sb.append(',');
        sb.append("organisationUnitLevels");
        sb.append('=');
        sb.append(((this.organisationUnitLevels == null)?"<null>":this.organisationUnitLevels));
        sb.append(',');
        sb.append("output");
        sb.append('=');
        sb.append(((this.output == null)?"<null>":this.output));
        sb.append(',');
        sb.append("outputCombo");
        sb.append('=');
        sb.append(((this.outputCombo == null)?"<null>":this.outputCombo));
        sb.append(',');
        sb.append("periodType");
        sb.append('=');
        sb.append(((this.periodType == null)?"<null>":this.periodType));
        sb.append(',');
        sb.append("predictorGroups");
        sb.append('=');
        sb.append(((this.predictorGroups == null)?"<null>":this.predictorGroups));
        sb.append(',');
        sb.append("publicAccess");
        sb.append('=');
        sb.append(((this.publicAccess == null)?"<null>":this.publicAccess));
        sb.append(',');
        sb.append("sampleSkipTest");
        sb.append('=');
        sb.append(((this.sampleSkipTest == null)?"<null>":this.sampleSkipTest));
        sb.append(',');
        sb.append("sequentialSampleCount");
        sb.append('=');
        sb.append(((this.sequentialSampleCount == null)?"<null>":this.sequentialSampleCount));
        sb.append(',');
        sb.append("sequentialSkipCount");
        sb.append('=');
        sb.append(((this.sequentialSkipCount == null)?"<null>":this.sequentialSkipCount));
        sb.append(',');
        sb.append("sharing");
        sb.append('=');
        sb.append(((this.sharing == null)?"<null>":this.sharing));
        sb.append(',');
        sb.append("shortName");
        sb.append('=');
        sb.append(((this.shortName == null)?"<null>":this.shortName));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.outputCombo == null)? 0 :this.outputCombo.hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.publicAccess == null)? 0 :this.publicAccess.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.generator == null)? 0 :this.generator.hashCode()));
        result = ((result* 31)+((this.displayShortName == null)? 0 :this.displayShortName.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.organisationUnitLevels == null)? 0 :this.organisationUnitLevels.hashCode()));
        result = ((result* 31)+((this.output == null)? 0 :this.output.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.organisationUnitDescendants == null)? 0 :this.organisationUnitDescendants.hashCode()));
        result = ((result* 31)+((this.sampleSkipTest == null)? 0 :this.sampleSkipTest.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.formName == null)? 0 :this.formName.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.sequentialSampleCount == null)? 0 :this.sequentialSampleCount.hashCode()));
        result = ((result* 31)+((this.annualSampleCount == null)? 0 :this.annualSampleCount.hashCode()));
        result = ((result* 31)+((this.displayDescription == null)? 0 :this.displayDescription.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.attributeValues == null)? 0 :this.attributeValues.hashCode()));
        result = ((result* 31)+((this.sequentialSkipCount == null)? 0 :this.sequentialSkipCount.hashCode()));
        result = ((result* 31)+((this.predictorGroups == null)? 0 :this.predictorGroups.hashCode()));
        result = ((result* 31)+((this.sharing == null)? 0 :this.sharing.hashCode()));
        result = ((result* 31)+((this.displayFormName == null)? 0 :this.displayFormName.hashCode()));
        result = ((result* 31)+((this.periodType == null)? 0 :this.periodType.hashCode()));
        result = ((result* 31)+((this.createdBy == null)? 0 :this.createdBy.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.shortName == null)? 0 :this.shortName.hashCode()));
        result = ((result* 31)+((this.favorite == null)? 0 :this.favorite.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Predictor) == false) {
            return false;
        }
        Predictor rhs = ((Predictor) other);
        return (((((((((((((((((((((((((((((((((((((((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites)))&&((this.outputCombo == rhs.outputCombo)||((this.outputCombo!= null)&&this.outputCombo.equals(rhs.outputCombo))))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.publicAccess == rhs.publicAccess)||((this.publicAccess!= null)&&this.publicAccess.equals(rhs.publicAccess))))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.generator == rhs.generator)||((this.generator!= null)&&this.generator.equals(rhs.generator))))&&((this.displayShortName == rhs.displayShortName)||((this.displayShortName!= null)&&this.displayShortName.equals(rhs.displayShortName))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.organisationUnitLevels == rhs.organisationUnitLevels)||((this.organisationUnitLevels!= null)&&this.organisationUnitLevels.equals(rhs.organisationUnitLevels))))&&((this.output == rhs.output)||((this.output!= null)&&this.output.equals(rhs.output))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.organisationUnitDescendants == rhs.organisationUnitDescendants)||((this.organisationUnitDescendants!= null)&&this.organisationUnitDescendants.equals(rhs.organisationUnitDescendants))))&&((this.sampleSkipTest == rhs.sampleSkipTest)||((this.sampleSkipTest!= null)&&this.sampleSkipTest.equals(rhs.sampleSkipTest))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.formName == rhs.formName)||((this.formName!= null)&&this.formName.equals(rhs.formName))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.sequentialSampleCount == rhs.sequentialSampleCount)||((this.sequentialSampleCount!= null)&&this.sequentialSampleCount.equals(rhs.sequentialSampleCount))))&&((this.annualSampleCount == rhs.annualSampleCount)||((this.annualSampleCount!= null)&&this.annualSampleCount.equals(rhs.annualSampleCount))))&&((this.displayDescription == rhs.displayDescription)||((this.displayDescription!= null)&&this.displayDescription.equals(rhs.displayDescription))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.attributeValues == rhs.attributeValues)||((this.attributeValues!= null)&&this.attributeValues.equals(rhs.attributeValues))))&&((this.sequentialSkipCount == rhs.sequentialSkipCount)||((this.sequentialSkipCount!= null)&&this.sequentialSkipCount.equals(rhs.sequentialSkipCount))))&&((this.predictorGroups == rhs.predictorGroups)||((this.predictorGroups!= null)&&this.predictorGroups.equals(rhs.predictorGroups))))&&((this.sharing == rhs.sharing)||((this.sharing!= null)&&this.sharing.equals(rhs.sharing))))&&((this.displayFormName == rhs.displayFormName)||((this.displayFormName!= null)&&this.displayFormName.equals(rhs.displayFormName))))&&((this.periodType == rhs.periodType)||((this.periodType!= null)&&this.periodType.equals(rhs.periodType))))&&((this.createdBy == rhs.createdBy)||((this.createdBy!= null)&&this.createdBy.equals(rhs.createdBy))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.shortName == rhs.shortName)||((this.shortName!= null)&&this.shortName.equals(rhs.shortName))))&&((this.favorite == rhs.favorite)||((this.favorite!= null)&&this.favorite.equals(rhs.favorite))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))));
    }

    @Generated("jsonschema2pojo")
    public enum OrganisationUnitDescendants {

        SELECTED("SELECTED"),
        DESCENDANTS("DESCENDANTS");
        private final String value;
        private final static Map<String, Predictor.OrganisationUnitDescendants> CONSTANTS = new HashMap<String, Predictor.OrganisationUnitDescendants>();

        static {
            for (Predictor.OrganisationUnitDescendants c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        OrganisationUnitDescendants(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Predictor.OrganisationUnitDescendants fromValue(String value) {
            Predictor.OrganisationUnitDescendants constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
