
package org.hisp.dhis.api.model.v2_39_1;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "aggregateDataExchanges",
    "analyticsTableHooks",
    "attributes",
    "categories",
    "categoryCombos",
    "categoryOptionCombos",
    "categoryOptionGroupSets",
    "categoryOptionGroups",
    "categoryOptions",
    "constants",
    "created",
    "dashboardItems",
    "dashboards",
    "dataApprovalLevels",
    "dataApprovalWorkflows",
    "dataElementGroupSets",
    "dataElementGroups",
    "dataElementOperands",
    "dataElements",
    "dataEntryForms",
    "dataSets",
    "dimensions",
    "documents",
    "eventCharts",
    "eventReports",
    "eventVisualizations",
    "events",
    "externalMapLayers",
    "indicatorGroupSets",
    "indicatorGroups",
    "indicatorTypes",
    "indicators",
    "interpretations",
    "items",
    "jobConfigurations",
    "legendSets",
    "mapViews",
    "maps",
    "metadataVersions",
    "optionGroupSets",
    "optionGroups",
    "optionSets",
    "options",
    "organisationUnitGroupSets",
    "organisationUnitGroups",
    "organisationUnitLevels",
    "organisationUnits",
    "predictorGroups",
    "predictors",
    "programIndicators",
    "programNotificationTemplates",
    "programRuleActions",
    "programRuleVariables",
    "programRules",
    "programStageSections",
    "programStages",
    "programs",
    "relationshipTypes",
    "reports",
    "schemas",
    "sections",
    "sqlViews",
    "trackedEntityAttributes",
    "trackedEntityTypes",
    "userGroups",
    "userRoles",
    "users",
    "validationNotificationTemplates",
    "validationRuleGroups",
    "validationRules",
    "visualizations"
})
@Generated("jsonschema2pojo")
public class Metadata implements Serializable
{

    @JsonProperty("aggregateDataExchanges")
    private List<AggregateDataExchange> aggregateDataExchanges = null;
    @JsonProperty("analyticsTableHooks")
    private List<AnalyticsTableHook> analyticsTableHooks = null;
    @JsonProperty("attributes")
    private List<Attribute> attributes = null;
    @JsonProperty("categories")
    private List<Category> categories = null;
    @JsonProperty("categoryCombos")
    private List<CategoryCombo> categoryCombos = null;
    @JsonProperty("categoryOptionCombos")
    private List<CategoryOptionCombo> categoryOptionCombos = null;
    @JsonProperty("categoryOptionGroupSets")
    private List<CategoryOptionGroupSet> categoryOptionGroupSets = null;
    @JsonProperty("categoryOptionGroups")
    private List<CategoryOptionGroup> categoryOptionGroups = null;
    @JsonProperty("categoryOptions")
    private List<CategoryOption> categoryOptions = null;
    @JsonProperty("constants")
    private List<Constant> constants = null;
    @JsonProperty("created")
    private Date created;
    @JsonProperty("dashboardItems")
    private List<DashboardItem> dashboardItems = null;
    @JsonProperty("dashboards")
    private List<Dashboard> dashboards = null;
    @JsonProperty("dataApprovalLevels")
    private List<DataApprovalLevel> dataApprovalLevels = null;
    @JsonProperty("dataApprovalWorkflows")
    private List<DataApprovalWorkflow> dataApprovalWorkflows = null;
    @JsonProperty("dataElementGroupSets")
    private List<DataElementGroupSet> dataElementGroupSets = null;
    @JsonProperty("dataElementGroups")
    private List<DataElementGroup> dataElementGroups = null;
    @JsonProperty("dataElementOperands")
    private List<DataElementOperand> dataElementOperands = null;
    @JsonProperty("dataElements")
    private List<DataElement> dataElements = null;
    @JsonProperty("dataEntryForms")
    private List<DataEntryForm> dataEntryForms = null;
    @JsonProperty("dataSets")
    private List<DataSet> dataSets = null;
    @JsonProperty("dimensions")
    private List<Object> dimensions = null;
    @JsonProperty("documents")
    private List<Document> documents = null;
    @JsonProperty("eventCharts")
    private List<EventChart> eventCharts = null;
    @JsonProperty("eventReports")
    private List<EventReport> eventReports = null;
    @JsonProperty("eventVisualizations")
    private List<EventVisualization> eventVisualizations = null;
    @JsonProperty("events")
    private List<Event> events = null;
    @JsonProperty("externalMapLayers")
    private List<ExternalMapLayer> externalMapLayers = null;
    @JsonProperty("indicatorGroupSets")
    private List<IndicatorGroupSet> indicatorGroupSets = null;
    @JsonProperty("indicatorGroups")
    private List<IndicatorGroup> indicatorGroups = null;
    @JsonProperty("indicatorTypes")
    private List<IndicatorType> indicatorTypes = null;
    @JsonProperty("indicators")
    private List<Indicator> indicators = null;
    @JsonProperty("interpretations")
    private List<Interpretation> interpretations = null;
    @JsonProperty("items")
    private List<Object> items = null;
    @JsonProperty("jobConfigurations")
    private List<JobConfiguration> jobConfigurations = null;
    @JsonProperty("legendSets")
    private List<LegendSet> legendSets = null;
    @JsonProperty("mapViews")
    private List<MapView> mapViews = null;
    @JsonProperty("maps")
    private List<org.hisp.dhis.api.model.v2_39_1.Map> maps = null;
    @JsonProperty("metadataVersions")
    private List<MetadataVersion> metadataVersions = null;
    @JsonProperty("optionGroupSets")
    private List<OptionGroupSet> optionGroupSets = null;
    @JsonProperty("optionGroups")
    private List<OptionGroup> optionGroups = null;
    @JsonProperty("optionSets")
    private List<OptionSet> optionSets = null;
    @JsonProperty("options")
    private List<Option> options = null;
    @JsonProperty("organisationUnitGroupSets")
    private List<OrganisationUnitGroupSet> organisationUnitGroupSets = null;
    @JsonProperty("organisationUnitGroups")
    private List<OrganisationUnitGroup> organisationUnitGroups = null;
    @JsonProperty("organisationUnitLevels")
    private List<OrganisationUnitLevel> organisationUnitLevels = null;
    @JsonProperty("organisationUnits")
    private List<OrganisationUnit> organisationUnits = null;
    @JsonProperty("predictorGroups")
    private List<PredictorGroup> predictorGroups = null;
    @JsonProperty("predictors")
    private List<Predictor> predictors = null;
    @JsonProperty("programIndicators")
    private List<ProgramIndicator> programIndicators = null;
    @JsonProperty("programNotificationTemplates")
    private List<ProgramNotificationTemplate> programNotificationTemplates = null;
    @JsonProperty("programRuleActions")
    private List<ProgramRuleAction> programRuleActions = null;
    @JsonProperty("programRuleVariables")
    private List<ProgramRuleVariable> programRuleVariables = null;
    @JsonProperty("programRules")
    private List<ProgramRule> programRules = null;
    @JsonProperty("programStageSections")
    private List<ProgramStageSection> programStageSections = null;
    @JsonProperty("programStages")
    private List<ProgramStage> programStages = null;
    @JsonProperty("programs")
    private List<Program> programs = null;
    @JsonProperty("relationshipTypes")
    private List<RelationshipType> relationshipTypes = null;
    @JsonProperty("reports")
    private List<Report> reports = null;
    @JsonProperty("schemas")
    private List<Schema> schemas = null;
    @JsonProperty("sections")
    private List<Section> sections = null;
    @JsonProperty("sqlViews")
    private List<SqlView> sqlViews = null;
    @JsonProperty("trackedEntityAttributes")
    private List<TrackedEntityAttribute> trackedEntityAttributes = null;
    @JsonProperty("trackedEntityTypes")
    private List<TrackedEntityType> trackedEntityTypes = null;
    @JsonProperty("userGroups")
    private List<UserGroup> userGroups = null;
    @JsonProperty("userRoles")
    private List<UserRole> userRoles = null;
    @JsonProperty("users")
    private List<User> users = null;
    @JsonProperty("validationNotificationTemplates")
    private List<ValidationNotificationTemplate> validationNotificationTemplates = null;
    @JsonProperty("validationRuleGroups")
    private List<ValidationRuleGroup> validationRuleGroups = null;
    @JsonProperty("validationRules")
    private List<ValidationRule> validationRules = null;
    @JsonProperty("visualizations")
    private List<Visualization> visualizations = null;
    @JsonIgnore
    private java.util.Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 6673384330578788514L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Metadata() {
    }

    /**
     * 
     * @param source
     */
    public Metadata(Metadata source) {
        super();
        this.aggregateDataExchanges = source.aggregateDataExchanges;
        this.analyticsTableHooks = source.analyticsTableHooks;
        this.attributes = source.attributes;
        this.categories = source.categories;
        this.categoryCombos = source.categoryCombos;
        this.categoryOptionCombos = source.categoryOptionCombos;
        this.categoryOptionGroupSets = source.categoryOptionGroupSets;
        this.categoryOptionGroups = source.categoryOptionGroups;
        this.categoryOptions = source.categoryOptions;
        this.constants = source.constants;
        this.created = source.created;
        this.dashboardItems = source.dashboardItems;
        this.dashboards = source.dashboards;
        this.dataApprovalLevels = source.dataApprovalLevels;
        this.dataApprovalWorkflows = source.dataApprovalWorkflows;
        this.dataElementGroupSets = source.dataElementGroupSets;
        this.dataElementGroups = source.dataElementGroups;
        this.dataElementOperands = source.dataElementOperands;
        this.dataElements = source.dataElements;
        this.dataEntryForms = source.dataEntryForms;
        this.dataSets = source.dataSets;
        this.dimensions = source.dimensions;
        this.documents = source.documents;
        this.eventCharts = source.eventCharts;
        this.eventReports = source.eventReports;
        this.eventVisualizations = source.eventVisualizations;
        this.events = source.events;
        this.externalMapLayers = source.externalMapLayers;
        this.indicatorGroupSets = source.indicatorGroupSets;
        this.indicatorGroups = source.indicatorGroups;
        this.indicatorTypes = source.indicatorTypes;
        this.indicators = source.indicators;
        this.interpretations = source.interpretations;
        this.items = source.items;
        this.jobConfigurations = source.jobConfigurations;
        this.legendSets = source.legendSets;
        this.mapViews = source.mapViews;
        this.maps = source.maps;
        this.metadataVersions = source.metadataVersions;
        this.optionGroupSets = source.optionGroupSets;
        this.optionGroups = source.optionGroups;
        this.optionSets = source.optionSets;
        this.options = source.options;
        this.organisationUnitGroupSets = source.organisationUnitGroupSets;
        this.organisationUnitGroups = source.organisationUnitGroups;
        this.organisationUnitLevels = source.organisationUnitLevels;
        this.organisationUnits = source.organisationUnits;
        this.predictorGroups = source.predictorGroups;
        this.predictors = source.predictors;
        this.programIndicators = source.programIndicators;
        this.programNotificationTemplates = source.programNotificationTemplates;
        this.programRuleActions = source.programRuleActions;
        this.programRuleVariables = source.programRuleVariables;
        this.programRules = source.programRules;
        this.programStageSections = source.programStageSections;
        this.programStages = source.programStages;
        this.programs = source.programs;
        this.relationshipTypes = source.relationshipTypes;
        this.reports = source.reports;
        this.schemas = source.schemas;
        this.sections = source.sections;
        this.sqlViews = source.sqlViews;
        this.trackedEntityAttributes = source.trackedEntityAttributes;
        this.trackedEntityTypes = source.trackedEntityTypes;
        this.userGroups = source.userGroups;
        this.userRoles = source.userRoles;
        this.users = source.users;
        this.validationNotificationTemplates = source.validationNotificationTemplates;
        this.validationRuleGroups = source.validationRuleGroups;
        this.validationRules = source.validationRules;
        this.visualizations = source.visualizations;
    }

    /**
     * 
     * @param validationRuleGroups
     * @param indicatorGroupSets
     * @param reports
     * @param documents
     * @param dataElementGroupSets
     * @param optionGroups
     * @param dashboards
     * @param eventVisualizations
     * @param programIndicators
     * @param trackedEntityTypes
     * @param options
     * @param categoryOptions
     * @param constants
     * @param organisationUnitGroups
     * @param interpretations
     * @param dataEntryForms
     * @param events
     * @param indicatorTypes
     * @param eventReports
     * @param maps
     * @param created
     * @param indicatorGroups
     * @param predictorGroups
     * @param indicators
     * @param categoryOptionCombos
     * @param sections
     * @param users
     * @param dataElementOperands
     * @param externalMapLayers
     * @param userGroups
     * @param userRoles
     * @param programNotificationTemplates
     * @param programRuleActions
     * @param schemas
     * @param optionSets
     * @param dataSets
     * @param legendSets
     * @param categoryOptionGroupSets
     * @param programs
     * @param items
     * @param sqlViews
     * @param predictors
     * @param programRuleVariables
     * @param dataApprovalLevels
     * @param analyticsTableHooks
     * @param aggregateDataExchanges
     * @param jobConfigurations
     * @param organisationUnitLevels
     * @param optionGroupSets
     * @param mapViews
     * @param categories
     * @param categoryCombos
     * @param organisationUnits
     * @param dataElements
     * @param visualizations
     * @param validationRules
     * @param dataElementGroups
     * @param eventCharts
     * @param dataApprovalWorkflows
     * @param organisationUnitGroupSets
     * @param programStages
     * @param metadataVersions
     * @param categoryOptionGroups
     * @param dashboardItems
     * @param validationNotificationTemplates
     * @param trackedEntityAttributes
     * @param attributes
     * @param relationshipTypes
     * @param programRules
     * @param programStageSections
     * @param dimensions
     */
    public Metadata(List<AggregateDataExchange> aggregateDataExchanges, List<AnalyticsTableHook> analyticsTableHooks, List<Attribute> attributes, List<Category> categories, List<CategoryCombo> categoryCombos, List<CategoryOptionCombo> categoryOptionCombos, List<CategoryOptionGroupSet> categoryOptionGroupSets, List<CategoryOptionGroup> categoryOptionGroups, List<CategoryOption> categoryOptions, List<Constant> constants, Date created, List<DashboardItem> dashboardItems, List<Dashboard> dashboards, List<DataApprovalLevel> dataApprovalLevels, List<DataApprovalWorkflow> dataApprovalWorkflows, List<DataElementGroupSet> dataElementGroupSets, List<DataElementGroup> dataElementGroups, List<DataElementOperand> dataElementOperands, List<DataElement> dataElements, List<DataEntryForm> dataEntryForms, List<DataSet> dataSets, List<Object> dimensions, List<Document> documents, List<EventChart> eventCharts, List<EventReport> eventReports, List<EventVisualization> eventVisualizations, List<Event> events, List<ExternalMapLayer> externalMapLayers, List<IndicatorGroupSet> indicatorGroupSets, List<IndicatorGroup> indicatorGroups, List<IndicatorType> indicatorTypes, List<Indicator> indicators, List<Interpretation> interpretations, List<Object> items, List<JobConfiguration> jobConfigurations, List<LegendSet> legendSets, List<MapView> mapViews, List<org.hisp.dhis.api.model.v2_39_1.Map> maps, List<MetadataVersion> metadataVersions, List<OptionGroupSet> optionGroupSets, List<OptionGroup> optionGroups, List<OptionSet> optionSets, List<Option> options, List<OrganisationUnitGroupSet> organisationUnitGroupSets, List<OrganisationUnitGroup> organisationUnitGroups, List<OrganisationUnitLevel> organisationUnitLevels, List<OrganisationUnit> organisationUnits, List<PredictorGroup> predictorGroups, List<Predictor> predictors, List<ProgramIndicator> programIndicators, List<ProgramNotificationTemplate> programNotificationTemplates, List<ProgramRuleAction> programRuleActions, List<ProgramRuleVariable> programRuleVariables, List<ProgramRule> programRules, List<ProgramStageSection> programStageSections, List<ProgramStage> programStages, List<Program> programs, List<RelationshipType> relationshipTypes, List<Report> reports, List<Schema> schemas, List<Section> sections, List<SqlView> sqlViews, List<TrackedEntityAttribute> trackedEntityAttributes, List<TrackedEntityType> trackedEntityTypes, List<UserGroup> userGroups, List<UserRole> userRoles, List<User> users, List<ValidationNotificationTemplate> validationNotificationTemplates, List<ValidationRuleGroup> validationRuleGroups, List<ValidationRule> validationRules, List<Visualization> visualizations) {
        super();
        this.aggregateDataExchanges = aggregateDataExchanges;
        this.analyticsTableHooks = analyticsTableHooks;
        this.attributes = attributes;
        this.categories = categories;
        this.categoryCombos = categoryCombos;
        this.categoryOptionCombos = categoryOptionCombos;
        this.categoryOptionGroupSets = categoryOptionGroupSets;
        this.categoryOptionGroups = categoryOptionGroups;
        this.categoryOptions = categoryOptions;
        this.constants = constants;
        this.created = created;
        this.dashboardItems = dashboardItems;
        this.dashboards = dashboards;
        this.dataApprovalLevels = dataApprovalLevels;
        this.dataApprovalWorkflows = dataApprovalWorkflows;
        this.dataElementGroupSets = dataElementGroupSets;
        this.dataElementGroups = dataElementGroups;
        this.dataElementOperands = dataElementOperands;
        this.dataElements = dataElements;
        this.dataEntryForms = dataEntryForms;
        this.dataSets = dataSets;
        this.dimensions = dimensions;
        this.documents = documents;
        this.eventCharts = eventCharts;
        this.eventReports = eventReports;
        this.eventVisualizations = eventVisualizations;
        this.events = events;
        this.externalMapLayers = externalMapLayers;
        this.indicatorGroupSets = indicatorGroupSets;
        this.indicatorGroups = indicatorGroups;
        this.indicatorTypes = indicatorTypes;
        this.indicators = indicators;
        this.interpretations = interpretations;
        this.items = items;
        this.jobConfigurations = jobConfigurations;
        this.legendSets = legendSets;
        this.mapViews = mapViews;
        this.maps = maps;
        this.metadataVersions = metadataVersions;
        this.optionGroupSets = optionGroupSets;
        this.optionGroups = optionGroups;
        this.optionSets = optionSets;
        this.options = options;
        this.organisationUnitGroupSets = organisationUnitGroupSets;
        this.organisationUnitGroups = organisationUnitGroups;
        this.organisationUnitLevels = organisationUnitLevels;
        this.organisationUnits = organisationUnits;
        this.predictorGroups = predictorGroups;
        this.predictors = predictors;
        this.programIndicators = programIndicators;
        this.programNotificationTemplates = programNotificationTemplates;
        this.programRuleActions = programRuleActions;
        this.programRuleVariables = programRuleVariables;
        this.programRules = programRules;
        this.programStageSections = programStageSections;
        this.programStages = programStages;
        this.programs = programs;
        this.relationshipTypes = relationshipTypes;
        this.reports = reports;
        this.schemas = schemas;
        this.sections = sections;
        this.sqlViews = sqlViews;
        this.trackedEntityAttributes = trackedEntityAttributes;
        this.trackedEntityTypes = trackedEntityTypes;
        this.userGroups = userGroups;
        this.userRoles = userRoles;
        this.users = users;
        this.validationNotificationTemplates = validationNotificationTemplates;
        this.validationRuleGroups = validationRuleGroups;
        this.validationRules = validationRules;
        this.visualizations = visualizations;
    }

    @JsonProperty("aggregateDataExchanges")
    public Optional<List<AggregateDataExchange>> getAggregateDataExchanges() {
        return Optional.ofNullable(aggregateDataExchanges);
    }

    @JsonProperty("aggregateDataExchanges")
    public void setAggregateDataExchanges(List<AggregateDataExchange> aggregateDataExchanges) {
        this.aggregateDataExchanges = aggregateDataExchanges;
    }

    public Metadata withAggregateDataExchanges(List<AggregateDataExchange> aggregateDataExchanges) {
        this.aggregateDataExchanges = aggregateDataExchanges;
        return this;
    }

    @JsonProperty("analyticsTableHooks")
    public Optional<List<AnalyticsTableHook>> getAnalyticsTableHooks() {
        return Optional.ofNullable(analyticsTableHooks);
    }

    @JsonProperty("analyticsTableHooks")
    public void setAnalyticsTableHooks(List<AnalyticsTableHook> analyticsTableHooks) {
        this.analyticsTableHooks = analyticsTableHooks;
    }

    public Metadata withAnalyticsTableHooks(List<AnalyticsTableHook> analyticsTableHooks) {
        this.analyticsTableHooks = analyticsTableHooks;
        return this;
    }

    @JsonProperty("attributes")
    public Optional<List<Attribute>> getAttributes() {
        return Optional.ofNullable(attributes);
    }

    @JsonProperty("attributes")
    public void setAttributes(List<Attribute> attributes) {
        this.attributes = attributes;
    }

    public Metadata withAttributes(List<Attribute> attributes) {
        this.attributes = attributes;
        return this;
    }

    @JsonProperty("categories")
    public Optional<List<Category>> getCategories() {
        return Optional.ofNullable(categories);
    }

    @JsonProperty("categories")
    public void setCategories(List<Category> categories) {
        this.categories = categories;
    }

    public Metadata withCategories(List<Category> categories) {
        this.categories = categories;
        return this;
    }

    @JsonProperty("categoryCombos")
    public Optional<List<CategoryCombo>> getCategoryCombos() {
        return Optional.ofNullable(categoryCombos);
    }

    @JsonProperty("categoryCombos")
    public void setCategoryCombos(List<CategoryCombo> categoryCombos) {
        this.categoryCombos = categoryCombos;
    }

    public Metadata withCategoryCombos(List<CategoryCombo> categoryCombos) {
        this.categoryCombos = categoryCombos;
        return this;
    }

    @JsonProperty("categoryOptionCombos")
    public Optional<List<CategoryOptionCombo>> getCategoryOptionCombos() {
        return Optional.ofNullable(categoryOptionCombos);
    }

    @JsonProperty("categoryOptionCombos")
    public void setCategoryOptionCombos(List<CategoryOptionCombo> categoryOptionCombos) {
        this.categoryOptionCombos = categoryOptionCombos;
    }

    public Metadata withCategoryOptionCombos(List<CategoryOptionCombo> categoryOptionCombos) {
        this.categoryOptionCombos = categoryOptionCombos;
        return this;
    }

    @JsonProperty("categoryOptionGroupSets")
    public Optional<List<CategoryOptionGroupSet>> getCategoryOptionGroupSets() {
        return Optional.ofNullable(categoryOptionGroupSets);
    }

    @JsonProperty("categoryOptionGroupSets")
    public void setCategoryOptionGroupSets(List<CategoryOptionGroupSet> categoryOptionGroupSets) {
        this.categoryOptionGroupSets = categoryOptionGroupSets;
    }

    public Metadata withCategoryOptionGroupSets(List<CategoryOptionGroupSet> categoryOptionGroupSets) {
        this.categoryOptionGroupSets = categoryOptionGroupSets;
        return this;
    }

    @JsonProperty("categoryOptionGroups")
    public Optional<List<CategoryOptionGroup>> getCategoryOptionGroups() {
        return Optional.ofNullable(categoryOptionGroups);
    }

    @JsonProperty("categoryOptionGroups")
    public void setCategoryOptionGroups(List<CategoryOptionGroup> categoryOptionGroups) {
        this.categoryOptionGroups = categoryOptionGroups;
    }

    public Metadata withCategoryOptionGroups(List<CategoryOptionGroup> categoryOptionGroups) {
        this.categoryOptionGroups = categoryOptionGroups;
        return this;
    }

    @JsonProperty("categoryOptions")
    public Optional<List<CategoryOption>> getCategoryOptions() {
        return Optional.ofNullable(categoryOptions);
    }

    @JsonProperty("categoryOptions")
    public void setCategoryOptions(List<CategoryOption> categoryOptions) {
        this.categoryOptions = categoryOptions;
    }

    public Metadata withCategoryOptions(List<CategoryOption> categoryOptions) {
        this.categoryOptions = categoryOptions;
        return this;
    }

    @JsonProperty("constants")
    public Optional<List<Constant>> getConstants() {
        return Optional.ofNullable(constants);
    }

    @JsonProperty("constants")
    public void setConstants(List<Constant> constants) {
        this.constants = constants;
    }

    public Metadata withConstants(List<Constant> constants) {
        this.constants = constants;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public Metadata withCreated(Date created) {
        this.created = created;
        return this;
    }

    @JsonProperty("dashboardItems")
    public Optional<List<DashboardItem>> getDashboardItems() {
        return Optional.ofNullable(dashboardItems);
    }

    @JsonProperty("dashboardItems")
    public void setDashboardItems(List<DashboardItem> dashboardItems) {
        this.dashboardItems = dashboardItems;
    }

    public Metadata withDashboardItems(List<DashboardItem> dashboardItems) {
        this.dashboardItems = dashboardItems;
        return this;
    }

    @JsonProperty("dashboards")
    public Optional<List<Dashboard>> getDashboards() {
        return Optional.ofNullable(dashboards);
    }

    @JsonProperty("dashboards")
    public void setDashboards(List<Dashboard> dashboards) {
        this.dashboards = dashboards;
    }

    public Metadata withDashboards(List<Dashboard> dashboards) {
        this.dashboards = dashboards;
        return this;
    }

    @JsonProperty("dataApprovalLevels")
    public Optional<List<DataApprovalLevel>> getDataApprovalLevels() {
        return Optional.ofNullable(dataApprovalLevels);
    }

    @JsonProperty("dataApprovalLevels")
    public void setDataApprovalLevels(List<DataApprovalLevel> dataApprovalLevels) {
        this.dataApprovalLevels = dataApprovalLevels;
    }

    public Metadata withDataApprovalLevels(List<DataApprovalLevel> dataApprovalLevels) {
        this.dataApprovalLevels = dataApprovalLevels;
        return this;
    }

    @JsonProperty("dataApprovalWorkflows")
    public Optional<List<DataApprovalWorkflow>> getDataApprovalWorkflows() {
        return Optional.ofNullable(dataApprovalWorkflows);
    }

    @JsonProperty("dataApprovalWorkflows")
    public void setDataApprovalWorkflows(List<DataApprovalWorkflow> dataApprovalWorkflows) {
        this.dataApprovalWorkflows = dataApprovalWorkflows;
    }

    public Metadata withDataApprovalWorkflows(List<DataApprovalWorkflow> dataApprovalWorkflows) {
        this.dataApprovalWorkflows = dataApprovalWorkflows;
        return this;
    }

    @JsonProperty("dataElementGroupSets")
    public Optional<List<DataElementGroupSet>> getDataElementGroupSets() {
        return Optional.ofNullable(dataElementGroupSets);
    }

    @JsonProperty("dataElementGroupSets")
    public void setDataElementGroupSets(List<DataElementGroupSet> dataElementGroupSets) {
        this.dataElementGroupSets = dataElementGroupSets;
    }

    public Metadata withDataElementGroupSets(List<DataElementGroupSet> dataElementGroupSets) {
        this.dataElementGroupSets = dataElementGroupSets;
        return this;
    }

    @JsonProperty("dataElementGroups")
    public Optional<List<DataElementGroup>> getDataElementGroups() {
        return Optional.ofNullable(dataElementGroups);
    }

    @JsonProperty("dataElementGroups")
    public void setDataElementGroups(List<DataElementGroup> dataElementGroups) {
        this.dataElementGroups = dataElementGroups;
    }

    public Metadata withDataElementGroups(List<DataElementGroup> dataElementGroups) {
        this.dataElementGroups = dataElementGroups;
        return this;
    }

    @JsonProperty("dataElementOperands")
    public Optional<List<DataElementOperand>> getDataElementOperands() {
        return Optional.ofNullable(dataElementOperands);
    }

    @JsonProperty("dataElementOperands")
    public void setDataElementOperands(List<DataElementOperand> dataElementOperands) {
        this.dataElementOperands = dataElementOperands;
    }

    public Metadata withDataElementOperands(List<DataElementOperand> dataElementOperands) {
        this.dataElementOperands = dataElementOperands;
        return this;
    }

    @JsonProperty("dataElements")
    public Optional<List<DataElement>> getDataElements() {
        return Optional.ofNullable(dataElements);
    }

    @JsonProperty("dataElements")
    public void setDataElements(List<DataElement> dataElements) {
        this.dataElements = dataElements;
    }

    public Metadata withDataElements(List<DataElement> dataElements) {
        this.dataElements = dataElements;
        return this;
    }

    @JsonProperty("dataEntryForms")
    public Optional<List<DataEntryForm>> getDataEntryForms() {
        return Optional.ofNullable(dataEntryForms);
    }

    @JsonProperty("dataEntryForms")
    public void setDataEntryForms(List<DataEntryForm> dataEntryForms) {
        this.dataEntryForms = dataEntryForms;
    }

    public Metadata withDataEntryForms(List<DataEntryForm> dataEntryForms) {
        this.dataEntryForms = dataEntryForms;
        return this;
    }

    @JsonProperty("dataSets")
    public Optional<List<DataSet>> getDataSets() {
        return Optional.ofNullable(dataSets);
    }

    @JsonProperty("dataSets")
    public void setDataSets(List<DataSet> dataSets) {
        this.dataSets = dataSets;
    }

    public Metadata withDataSets(List<DataSet> dataSets) {
        this.dataSets = dataSets;
        return this;
    }

    @JsonProperty("dimensions")
    public Optional<List<Object>> getDimensions() {
        return Optional.ofNullable(dimensions);
    }

    @JsonProperty("dimensions")
    public void setDimensions(List<Object> dimensions) {
        this.dimensions = dimensions;
    }

    public Metadata withDimensions(List<Object> dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    @JsonProperty("documents")
    public Optional<List<Document>> getDocuments() {
        return Optional.ofNullable(documents);
    }

    @JsonProperty("documents")
    public void setDocuments(List<Document> documents) {
        this.documents = documents;
    }

    public Metadata withDocuments(List<Document> documents) {
        this.documents = documents;
        return this;
    }

    @JsonProperty("eventCharts")
    public Optional<List<EventChart>> getEventCharts() {
        return Optional.ofNullable(eventCharts);
    }

    @JsonProperty("eventCharts")
    public void setEventCharts(List<EventChart> eventCharts) {
        this.eventCharts = eventCharts;
    }

    public Metadata withEventCharts(List<EventChart> eventCharts) {
        this.eventCharts = eventCharts;
        return this;
    }

    @JsonProperty("eventReports")
    public Optional<List<EventReport>> getEventReports() {
        return Optional.ofNullable(eventReports);
    }

    @JsonProperty("eventReports")
    public void setEventReports(List<EventReport> eventReports) {
        this.eventReports = eventReports;
    }

    public Metadata withEventReports(List<EventReport> eventReports) {
        this.eventReports = eventReports;
        return this;
    }

    @JsonProperty("eventVisualizations")
    public Optional<List<EventVisualization>> getEventVisualizations() {
        return Optional.ofNullable(eventVisualizations);
    }

    @JsonProperty("eventVisualizations")
    public void setEventVisualizations(List<EventVisualization> eventVisualizations) {
        this.eventVisualizations = eventVisualizations;
    }

    public Metadata withEventVisualizations(List<EventVisualization> eventVisualizations) {
        this.eventVisualizations = eventVisualizations;
        return this;
    }

    @JsonProperty("events")
    public Optional<List<Event>> getEvents() {
        return Optional.ofNullable(events);
    }

    @JsonProperty("events")
    public void setEvents(List<Event> events) {
        this.events = events;
    }

    public Metadata withEvents(List<Event> events) {
        this.events = events;
        return this;
    }

    @JsonProperty("externalMapLayers")
    public Optional<List<ExternalMapLayer>> getExternalMapLayers() {
        return Optional.ofNullable(externalMapLayers);
    }

    @JsonProperty("externalMapLayers")
    public void setExternalMapLayers(List<ExternalMapLayer> externalMapLayers) {
        this.externalMapLayers = externalMapLayers;
    }

    public Metadata withExternalMapLayers(List<ExternalMapLayer> externalMapLayers) {
        this.externalMapLayers = externalMapLayers;
        return this;
    }

    @JsonProperty("indicatorGroupSets")
    public Optional<List<IndicatorGroupSet>> getIndicatorGroupSets() {
        return Optional.ofNullable(indicatorGroupSets);
    }

    @JsonProperty("indicatorGroupSets")
    public void setIndicatorGroupSets(List<IndicatorGroupSet> indicatorGroupSets) {
        this.indicatorGroupSets = indicatorGroupSets;
    }

    public Metadata withIndicatorGroupSets(List<IndicatorGroupSet> indicatorGroupSets) {
        this.indicatorGroupSets = indicatorGroupSets;
        return this;
    }

    @JsonProperty("indicatorGroups")
    public Optional<List<IndicatorGroup>> getIndicatorGroups() {
        return Optional.ofNullable(indicatorGroups);
    }

    @JsonProperty("indicatorGroups")
    public void setIndicatorGroups(List<IndicatorGroup> indicatorGroups) {
        this.indicatorGroups = indicatorGroups;
    }

    public Metadata withIndicatorGroups(List<IndicatorGroup> indicatorGroups) {
        this.indicatorGroups = indicatorGroups;
        return this;
    }

    @JsonProperty("indicatorTypes")
    public Optional<List<IndicatorType>> getIndicatorTypes() {
        return Optional.ofNullable(indicatorTypes);
    }

    @JsonProperty("indicatorTypes")
    public void setIndicatorTypes(List<IndicatorType> indicatorTypes) {
        this.indicatorTypes = indicatorTypes;
    }

    public Metadata withIndicatorTypes(List<IndicatorType> indicatorTypes) {
        this.indicatorTypes = indicatorTypes;
        return this;
    }

    @JsonProperty("indicators")
    public Optional<List<Indicator>> getIndicators() {
        return Optional.ofNullable(indicators);
    }

    @JsonProperty("indicators")
    public void setIndicators(List<Indicator> indicators) {
        this.indicators = indicators;
    }

    public Metadata withIndicators(List<Indicator> indicators) {
        this.indicators = indicators;
        return this;
    }

    @JsonProperty("interpretations")
    public Optional<List<Interpretation>> getInterpretations() {
        return Optional.ofNullable(interpretations);
    }

    @JsonProperty("interpretations")
    public void setInterpretations(List<Interpretation> interpretations) {
        this.interpretations = interpretations;
    }

    public Metadata withInterpretations(List<Interpretation> interpretations) {
        this.interpretations = interpretations;
        return this;
    }

    @JsonProperty("items")
    public Optional<List<Object>> getItems() {
        return Optional.ofNullable(items);
    }

    @JsonProperty("items")
    public void setItems(List<Object> items) {
        this.items = items;
    }

    public Metadata withItems(List<Object> items) {
        this.items = items;
        return this;
    }

    @JsonProperty("jobConfigurations")
    public Optional<List<JobConfiguration>> getJobConfigurations() {
        return Optional.ofNullable(jobConfigurations);
    }

    @JsonProperty("jobConfigurations")
    public void setJobConfigurations(List<JobConfiguration> jobConfigurations) {
        this.jobConfigurations = jobConfigurations;
    }

    public Metadata withJobConfigurations(List<JobConfiguration> jobConfigurations) {
        this.jobConfigurations = jobConfigurations;
        return this;
    }

    @JsonProperty("legendSets")
    public Optional<List<LegendSet>> getLegendSets() {
        return Optional.ofNullable(legendSets);
    }

    @JsonProperty("legendSets")
    public void setLegendSets(List<LegendSet> legendSets) {
        this.legendSets = legendSets;
    }

    public Metadata withLegendSets(List<LegendSet> legendSets) {
        this.legendSets = legendSets;
        return this;
    }

    @JsonProperty("mapViews")
    public Optional<List<MapView>> getMapViews() {
        return Optional.ofNullable(mapViews);
    }

    @JsonProperty("mapViews")
    public void setMapViews(List<MapView> mapViews) {
        this.mapViews = mapViews;
    }

    public Metadata withMapViews(List<MapView> mapViews) {
        this.mapViews = mapViews;
        return this;
    }

    @JsonProperty("maps")
    public Optional<List<org.hisp.dhis.api.model.v2_39_1.Map>> getMaps() {
        return Optional.ofNullable(maps);
    }

    @JsonProperty("maps")
    public void setMaps(List<org.hisp.dhis.api.model.v2_39_1.Map> maps) {
        this.maps = maps;
    }

    public Metadata withMaps(List<org.hisp.dhis.api.model.v2_39_1.Map> maps) {
        this.maps = maps;
        return this;
    }

    @JsonProperty("metadataVersions")
    public Optional<List<MetadataVersion>> getMetadataVersions() {
        return Optional.ofNullable(metadataVersions);
    }

    @JsonProperty("metadataVersions")
    public void setMetadataVersions(List<MetadataVersion> metadataVersions) {
        this.metadataVersions = metadataVersions;
    }

    public Metadata withMetadataVersions(List<MetadataVersion> metadataVersions) {
        this.metadataVersions = metadataVersions;
        return this;
    }

    @JsonProperty("optionGroupSets")
    public Optional<List<OptionGroupSet>> getOptionGroupSets() {
        return Optional.ofNullable(optionGroupSets);
    }

    @JsonProperty("optionGroupSets")
    public void setOptionGroupSets(List<OptionGroupSet> optionGroupSets) {
        this.optionGroupSets = optionGroupSets;
    }

    public Metadata withOptionGroupSets(List<OptionGroupSet> optionGroupSets) {
        this.optionGroupSets = optionGroupSets;
        return this;
    }

    @JsonProperty("optionGroups")
    public Optional<List<OptionGroup>> getOptionGroups() {
        return Optional.ofNullable(optionGroups);
    }

    @JsonProperty("optionGroups")
    public void setOptionGroups(List<OptionGroup> optionGroups) {
        this.optionGroups = optionGroups;
    }

    public Metadata withOptionGroups(List<OptionGroup> optionGroups) {
        this.optionGroups = optionGroups;
        return this;
    }

    @JsonProperty("optionSets")
    public Optional<List<OptionSet>> getOptionSets() {
        return Optional.ofNullable(optionSets);
    }

    @JsonProperty("optionSets")
    public void setOptionSets(List<OptionSet> optionSets) {
        this.optionSets = optionSets;
    }

    public Metadata withOptionSets(List<OptionSet> optionSets) {
        this.optionSets = optionSets;
        return this;
    }

    @JsonProperty("options")
    public Optional<List<Option>> getOptions() {
        return Optional.ofNullable(options);
    }

    @JsonProperty("options")
    public void setOptions(List<Option> options) {
        this.options = options;
    }

    public Metadata withOptions(List<Option> options) {
        this.options = options;
        return this;
    }

    @JsonProperty("organisationUnitGroupSets")
    public Optional<List<OrganisationUnitGroupSet>> getOrganisationUnitGroupSets() {
        return Optional.ofNullable(organisationUnitGroupSets);
    }

    @JsonProperty("organisationUnitGroupSets")
    public void setOrganisationUnitGroupSets(List<OrganisationUnitGroupSet> organisationUnitGroupSets) {
        this.organisationUnitGroupSets = organisationUnitGroupSets;
    }

    public Metadata withOrganisationUnitGroupSets(List<OrganisationUnitGroupSet> organisationUnitGroupSets) {
        this.organisationUnitGroupSets = organisationUnitGroupSets;
        return this;
    }

    @JsonProperty("organisationUnitGroups")
    public Optional<List<OrganisationUnitGroup>> getOrganisationUnitGroups() {
        return Optional.ofNullable(organisationUnitGroups);
    }

    @JsonProperty("organisationUnitGroups")
    public void setOrganisationUnitGroups(List<OrganisationUnitGroup> organisationUnitGroups) {
        this.organisationUnitGroups = organisationUnitGroups;
    }

    public Metadata withOrganisationUnitGroups(List<OrganisationUnitGroup> organisationUnitGroups) {
        this.organisationUnitGroups = organisationUnitGroups;
        return this;
    }

    @JsonProperty("organisationUnitLevels")
    public Optional<List<OrganisationUnitLevel>> getOrganisationUnitLevels() {
        return Optional.ofNullable(organisationUnitLevels);
    }

    @JsonProperty("organisationUnitLevels")
    public void setOrganisationUnitLevels(List<OrganisationUnitLevel> organisationUnitLevels) {
        this.organisationUnitLevels = organisationUnitLevels;
    }

    public Metadata withOrganisationUnitLevels(List<OrganisationUnitLevel> organisationUnitLevels) {
        this.organisationUnitLevels = organisationUnitLevels;
        return this;
    }

    @JsonProperty("organisationUnits")
    public Optional<List<OrganisationUnit>> getOrganisationUnits() {
        return Optional.ofNullable(organisationUnits);
    }

    @JsonProperty("organisationUnits")
    public void setOrganisationUnits(List<OrganisationUnit> organisationUnits) {
        this.organisationUnits = organisationUnits;
    }

    public Metadata withOrganisationUnits(List<OrganisationUnit> organisationUnits) {
        this.organisationUnits = organisationUnits;
        return this;
    }

    @JsonProperty("predictorGroups")
    public Optional<List<PredictorGroup>> getPredictorGroups() {
        return Optional.ofNullable(predictorGroups);
    }

    @JsonProperty("predictorGroups")
    public void setPredictorGroups(List<PredictorGroup> predictorGroups) {
        this.predictorGroups = predictorGroups;
    }

    public Metadata withPredictorGroups(List<PredictorGroup> predictorGroups) {
        this.predictorGroups = predictorGroups;
        return this;
    }

    @JsonProperty("predictors")
    public Optional<List<Predictor>> getPredictors() {
        return Optional.ofNullable(predictors);
    }

    @JsonProperty("predictors")
    public void setPredictors(List<Predictor> predictors) {
        this.predictors = predictors;
    }

    public Metadata withPredictors(List<Predictor> predictors) {
        this.predictors = predictors;
        return this;
    }

    @JsonProperty("programIndicators")
    public Optional<List<ProgramIndicator>> getProgramIndicators() {
        return Optional.ofNullable(programIndicators);
    }

    @JsonProperty("programIndicators")
    public void setProgramIndicators(List<ProgramIndicator> programIndicators) {
        this.programIndicators = programIndicators;
    }

    public Metadata withProgramIndicators(List<ProgramIndicator> programIndicators) {
        this.programIndicators = programIndicators;
        return this;
    }

    @JsonProperty("programNotificationTemplates")
    public Optional<List<ProgramNotificationTemplate>> getProgramNotificationTemplates() {
        return Optional.ofNullable(programNotificationTemplates);
    }

    @JsonProperty("programNotificationTemplates")
    public void setProgramNotificationTemplates(List<ProgramNotificationTemplate> programNotificationTemplates) {
        this.programNotificationTemplates = programNotificationTemplates;
    }

    public Metadata withProgramNotificationTemplates(List<ProgramNotificationTemplate> programNotificationTemplates) {
        this.programNotificationTemplates = programNotificationTemplates;
        return this;
    }

    @JsonProperty("programRuleActions")
    public Optional<List<ProgramRuleAction>> getProgramRuleActions() {
        return Optional.ofNullable(programRuleActions);
    }

    @JsonProperty("programRuleActions")
    public void setProgramRuleActions(List<ProgramRuleAction> programRuleActions) {
        this.programRuleActions = programRuleActions;
    }

    public Metadata withProgramRuleActions(List<ProgramRuleAction> programRuleActions) {
        this.programRuleActions = programRuleActions;
        return this;
    }

    @JsonProperty("programRuleVariables")
    public Optional<List<ProgramRuleVariable>> getProgramRuleVariables() {
        return Optional.ofNullable(programRuleVariables);
    }

    @JsonProperty("programRuleVariables")
    public void setProgramRuleVariables(List<ProgramRuleVariable> programRuleVariables) {
        this.programRuleVariables = programRuleVariables;
    }

    public Metadata withProgramRuleVariables(List<ProgramRuleVariable> programRuleVariables) {
        this.programRuleVariables = programRuleVariables;
        return this;
    }

    @JsonProperty("programRules")
    public Optional<List<ProgramRule>> getProgramRules() {
        return Optional.ofNullable(programRules);
    }

    @JsonProperty("programRules")
    public void setProgramRules(List<ProgramRule> programRules) {
        this.programRules = programRules;
    }

    public Metadata withProgramRules(List<ProgramRule> programRules) {
        this.programRules = programRules;
        return this;
    }

    @JsonProperty("programStageSections")
    public Optional<List<ProgramStageSection>> getProgramStageSections() {
        return Optional.ofNullable(programStageSections);
    }

    @JsonProperty("programStageSections")
    public void setProgramStageSections(List<ProgramStageSection> programStageSections) {
        this.programStageSections = programStageSections;
    }

    public Metadata withProgramStageSections(List<ProgramStageSection> programStageSections) {
        this.programStageSections = programStageSections;
        return this;
    }

    @JsonProperty("programStages")
    public Optional<List<ProgramStage>> getProgramStages() {
        return Optional.ofNullable(programStages);
    }

    @JsonProperty("programStages")
    public void setProgramStages(List<ProgramStage> programStages) {
        this.programStages = programStages;
    }

    public Metadata withProgramStages(List<ProgramStage> programStages) {
        this.programStages = programStages;
        return this;
    }

    @JsonProperty("programs")
    public Optional<List<Program>> getPrograms() {
        return Optional.ofNullable(programs);
    }

    @JsonProperty("programs")
    public void setPrograms(List<Program> programs) {
        this.programs = programs;
    }

    public Metadata withPrograms(List<Program> programs) {
        this.programs = programs;
        return this;
    }

    @JsonProperty("relationshipTypes")
    public Optional<List<RelationshipType>> getRelationshipTypes() {
        return Optional.ofNullable(relationshipTypes);
    }

    @JsonProperty("relationshipTypes")
    public void setRelationshipTypes(List<RelationshipType> relationshipTypes) {
        this.relationshipTypes = relationshipTypes;
    }

    public Metadata withRelationshipTypes(List<RelationshipType> relationshipTypes) {
        this.relationshipTypes = relationshipTypes;
        return this;
    }

    @JsonProperty("reports")
    public Optional<List<Report>> getReports() {
        return Optional.ofNullable(reports);
    }

    @JsonProperty("reports")
    public void setReports(List<Report> reports) {
        this.reports = reports;
    }

    public Metadata withReports(List<Report> reports) {
        this.reports = reports;
        return this;
    }

    @JsonProperty("schemas")
    public Optional<List<Schema>> getSchemas() {
        return Optional.ofNullable(schemas);
    }

    @JsonProperty("schemas")
    public void setSchemas(List<Schema> schemas) {
        this.schemas = schemas;
    }

    public Metadata withSchemas(List<Schema> schemas) {
        this.schemas = schemas;
        return this;
    }

    @JsonProperty("sections")
    public Optional<List<Section>> getSections() {
        return Optional.ofNullable(sections);
    }

    @JsonProperty("sections")
    public void setSections(List<Section> sections) {
        this.sections = sections;
    }

    public Metadata withSections(List<Section> sections) {
        this.sections = sections;
        return this;
    }

    @JsonProperty("sqlViews")
    public Optional<List<SqlView>> getSqlViews() {
        return Optional.ofNullable(sqlViews);
    }

    @JsonProperty("sqlViews")
    public void setSqlViews(List<SqlView> sqlViews) {
        this.sqlViews = sqlViews;
    }

    public Metadata withSqlViews(List<SqlView> sqlViews) {
        this.sqlViews = sqlViews;
        return this;
    }

    @JsonProperty("trackedEntityAttributes")
    public Optional<List<TrackedEntityAttribute>> getTrackedEntityAttributes() {
        return Optional.ofNullable(trackedEntityAttributes);
    }

    @JsonProperty("trackedEntityAttributes")
    public void setTrackedEntityAttributes(List<TrackedEntityAttribute> trackedEntityAttributes) {
        this.trackedEntityAttributes = trackedEntityAttributes;
    }

    public Metadata withTrackedEntityAttributes(List<TrackedEntityAttribute> trackedEntityAttributes) {
        this.trackedEntityAttributes = trackedEntityAttributes;
        return this;
    }

    @JsonProperty("trackedEntityTypes")
    public Optional<List<TrackedEntityType>> getTrackedEntityTypes() {
        return Optional.ofNullable(trackedEntityTypes);
    }

    @JsonProperty("trackedEntityTypes")
    public void setTrackedEntityTypes(List<TrackedEntityType> trackedEntityTypes) {
        this.trackedEntityTypes = trackedEntityTypes;
    }

    public Metadata withTrackedEntityTypes(List<TrackedEntityType> trackedEntityTypes) {
        this.trackedEntityTypes = trackedEntityTypes;
        return this;
    }

    @JsonProperty("userGroups")
    public Optional<List<UserGroup>> getUserGroups() {
        return Optional.ofNullable(userGroups);
    }

    @JsonProperty("userGroups")
    public void setUserGroups(List<UserGroup> userGroups) {
        this.userGroups = userGroups;
    }

    public Metadata withUserGroups(List<UserGroup> userGroups) {
        this.userGroups = userGroups;
        return this;
    }

    @JsonProperty("userRoles")
    public Optional<List<UserRole>> getUserRoles() {
        return Optional.ofNullable(userRoles);
    }

    @JsonProperty("userRoles")
    public void setUserRoles(List<UserRole> userRoles) {
        this.userRoles = userRoles;
    }

    public Metadata withUserRoles(List<UserRole> userRoles) {
        this.userRoles = userRoles;
        return this;
    }

    @JsonProperty("users")
    public Optional<List<User>> getUsers() {
        return Optional.ofNullable(users);
    }

    @JsonProperty("users")
    public void setUsers(List<User> users) {
        this.users = users;
    }

    public Metadata withUsers(List<User> users) {
        this.users = users;
        return this;
    }

    @JsonProperty("validationNotificationTemplates")
    public Optional<List<ValidationNotificationTemplate>> getValidationNotificationTemplates() {
        return Optional.ofNullable(validationNotificationTemplates);
    }

    @JsonProperty("validationNotificationTemplates")
    public void setValidationNotificationTemplates(List<ValidationNotificationTemplate> validationNotificationTemplates) {
        this.validationNotificationTemplates = validationNotificationTemplates;
    }

    public Metadata withValidationNotificationTemplates(List<ValidationNotificationTemplate> validationNotificationTemplates) {
        this.validationNotificationTemplates = validationNotificationTemplates;
        return this;
    }

    @JsonProperty("validationRuleGroups")
    public Optional<List<ValidationRuleGroup>> getValidationRuleGroups() {
        return Optional.ofNullable(validationRuleGroups);
    }

    @JsonProperty("validationRuleGroups")
    public void setValidationRuleGroups(List<ValidationRuleGroup> validationRuleGroups) {
        this.validationRuleGroups = validationRuleGroups;
    }

    public Metadata withValidationRuleGroups(List<ValidationRuleGroup> validationRuleGroups) {
        this.validationRuleGroups = validationRuleGroups;
        return this;
    }

    @JsonProperty("validationRules")
    public Optional<List<ValidationRule>> getValidationRules() {
        return Optional.ofNullable(validationRules);
    }

    @JsonProperty("validationRules")
    public void setValidationRules(List<ValidationRule> validationRules) {
        this.validationRules = validationRules;
    }

    public Metadata withValidationRules(List<ValidationRule> validationRules) {
        this.validationRules = validationRules;
        return this;
    }

    @JsonProperty("visualizations")
    public Optional<List<Visualization>> getVisualizations() {
        return Optional.ofNullable(visualizations);
    }

    @JsonProperty("visualizations")
    public void setVisualizations(List<Visualization> visualizations) {
        this.visualizations = visualizations;
    }

    public Metadata withVisualizations(List<Visualization> visualizations) {
        this.visualizations = visualizations;
        return this;
    }

    @JsonAnyGetter
    public java.util.Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Metadata withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "aggregateDataExchanges":
                if (value instanceof List) {
                    setAggregateDataExchanges(((List<AggregateDataExchange> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"aggregateDataExchanges\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.AggregateDataExchange>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "analyticsTableHooks":
                if (value instanceof List) {
                    setAnalyticsTableHooks(((List<AnalyticsTableHook> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"analyticsTableHooks\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.AnalyticsTableHook>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "attributes":
                if (value instanceof List) {
                    setAttributes(((List<Attribute> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributes\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.Attribute>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "categories":
                if (value instanceof List) {
                    setCategories(((List<Category> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"categories\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.Category>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "categoryCombos":
                if (value instanceof List) {
                    setCategoryCombos(((List<CategoryCombo> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"categoryCombos\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.CategoryCombo>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "categoryOptionCombos":
                if (value instanceof List) {
                    setCategoryOptionCombos(((List<CategoryOptionCombo> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"categoryOptionCombos\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.CategoryOptionCombo>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "categoryOptionGroupSets":
                if (value instanceof List) {
                    setCategoryOptionGroupSets(((List<CategoryOptionGroupSet> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"categoryOptionGroupSets\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.CategoryOptionGroupSet>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "categoryOptionGroups":
                if (value instanceof List) {
                    setCategoryOptionGroups(((List<CategoryOptionGroup> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"categoryOptionGroups\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.CategoryOptionGroup>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "categoryOptions":
                if (value instanceof List) {
                    setCategoryOptions(((List<CategoryOption> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"categoryOptions\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.CategoryOption>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "constants":
                if (value instanceof List) {
                    setConstants(((List<Constant> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"constants\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.Constant>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "created":
                if (value instanceof Date) {
                    setCreated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dashboardItems":
                if (value instanceof List) {
                    setDashboardItems(((List<DashboardItem> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"dashboardItems\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.DashboardItem>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dashboards":
                if (value instanceof List) {
                    setDashboards(((List<Dashboard> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"dashboards\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.Dashboard>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataApprovalLevels":
                if (value instanceof List) {
                    setDataApprovalLevels(((List<DataApprovalLevel> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataApprovalLevels\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.DataApprovalLevel>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataApprovalWorkflows":
                if (value instanceof List) {
                    setDataApprovalWorkflows(((List<DataApprovalWorkflow> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataApprovalWorkflows\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.DataApprovalWorkflow>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataElementGroupSets":
                if (value instanceof List) {
                    setDataElementGroupSets(((List<DataElementGroupSet> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataElementGroupSets\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.DataElementGroupSet>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataElementGroups":
                if (value instanceof List) {
                    setDataElementGroups(((List<DataElementGroup> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataElementGroups\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.DataElementGroup>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataElementOperands":
                if (value instanceof List) {
                    setDataElementOperands(((List<DataElementOperand> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataElementOperands\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.DataElementOperand>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataElements":
                if (value instanceof List) {
                    setDataElements(((List<DataElement> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataElements\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.DataElement>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataEntryForms":
                if (value instanceof List) {
                    setDataEntryForms(((List<DataEntryForm> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataEntryForms\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.DataEntryForm>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataSets":
                if (value instanceof List) {
                    setDataSets(((List<DataSet> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataSets\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.DataSet>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dimensions":
                if (value instanceof List) {
                    setDimensions(((List<Object> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"dimensions\" is of type \"java.util.List<java.lang.Object>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "documents":
                if (value instanceof List) {
                    setDocuments(((List<Document> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"documents\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.Document>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "eventCharts":
                if (value instanceof List) {
                    setEventCharts(((List<EventChart> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"eventCharts\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.EventChart>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "eventReports":
                if (value instanceof List) {
                    setEventReports(((List<EventReport> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"eventReports\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.EventReport>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "eventVisualizations":
                if (value instanceof List) {
                    setEventVisualizations(((List<EventVisualization> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"eventVisualizations\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.EventVisualization>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "events":
                if (value instanceof List) {
                    setEvents(((List<Event> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"events\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.Event>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "externalMapLayers":
                if (value instanceof List) {
                    setExternalMapLayers(((List<ExternalMapLayer> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"externalMapLayers\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.ExternalMapLayer>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "indicatorGroupSets":
                if (value instanceof List) {
                    setIndicatorGroupSets(((List<IndicatorGroupSet> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"indicatorGroupSets\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.IndicatorGroupSet>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "indicatorGroups":
                if (value instanceof List) {
                    setIndicatorGroups(((List<IndicatorGroup> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"indicatorGroups\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.IndicatorGroup>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "indicatorTypes":
                if (value instanceof List) {
                    setIndicatorTypes(((List<IndicatorType> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"indicatorTypes\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.IndicatorType>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "indicators":
                if (value instanceof List) {
                    setIndicators(((List<Indicator> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"indicators\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.Indicator>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "interpretations":
                if (value instanceof List) {
                    setInterpretations(((List<Interpretation> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"interpretations\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.Interpretation>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "items":
                if (value instanceof List) {
                    setItems(((List<Object> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"items\" is of type \"java.util.List<java.lang.Object>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "jobConfigurations":
                if (value instanceof List) {
                    setJobConfigurations(((List<JobConfiguration> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"jobConfigurations\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.JobConfiguration>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "legendSets":
                if (value instanceof List) {
                    setLegendSets(((List<LegendSet> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"legendSets\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.LegendSet>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "mapViews":
                if (value instanceof List) {
                    setMapViews(((List<MapView> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"mapViews\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.MapView>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "maps":
                if (value instanceof List) {
                    setMaps(((List<org.hisp.dhis.api.model.v2_39_1.Map> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"maps\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.Map>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "metadataVersions":
                if (value instanceof List) {
                    setMetadataVersions(((List<MetadataVersion> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"metadataVersions\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.MetadataVersion>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "optionGroupSets":
                if (value instanceof List) {
                    setOptionGroupSets(((List<OptionGroupSet> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"optionGroupSets\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.OptionGroupSet>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "optionGroups":
                if (value instanceof List) {
                    setOptionGroups(((List<OptionGroup> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"optionGroups\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.OptionGroup>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "optionSets":
                if (value instanceof List) {
                    setOptionSets(((List<OptionSet> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"optionSets\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.OptionSet>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "options":
                if (value instanceof List) {
                    setOptions(((List<Option> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"options\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.Option>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "organisationUnitGroupSets":
                if (value instanceof List) {
                    setOrganisationUnitGroupSets(((List<OrganisationUnitGroupSet> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"organisationUnitGroupSets\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.OrganisationUnitGroupSet>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "organisationUnitGroups":
                if (value instanceof List) {
                    setOrganisationUnitGroups(((List<OrganisationUnitGroup> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"organisationUnitGroups\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.OrganisationUnitGroup>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "organisationUnitLevels":
                if (value instanceof List) {
                    setOrganisationUnitLevels(((List<OrganisationUnitLevel> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"organisationUnitLevels\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.OrganisationUnitLevel>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "organisationUnits":
                if (value instanceof List) {
                    setOrganisationUnits(((List<OrganisationUnit> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"organisationUnits\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.OrganisationUnit>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "predictorGroups":
                if (value instanceof List) {
                    setPredictorGroups(((List<PredictorGroup> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"predictorGroups\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.PredictorGroup>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "predictors":
                if (value instanceof List) {
                    setPredictors(((List<Predictor> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"predictors\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.Predictor>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "programIndicators":
                if (value instanceof List) {
                    setProgramIndicators(((List<ProgramIndicator> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"programIndicators\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.ProgramIndicator>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "programNotificationTemplates":
                if (value instanceof List) {
                    setProgramNotificationTemplates(((List<ProgramNotificationTemplate> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"programNotificationTemplates\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.ProgramNotificationTemplate>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "programRuleActions":
                if (value instanceof List) {
                    setProgramRuleActions(((List<ProgramRuleAction> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"programRuleActions\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.ProgramRuleAction>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "programRuleVariables":
                if (value instanceof List) {
                    setProgramRuleVariables(((List<ProgramRuleVariable> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"programRuleVariables\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.ProgramRuleVariable>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "programRules":
                if (value instanceof List) {
                    setProgramRules(((List<ProgramRule> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"programRules\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.ProgramRule>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "programStageSections":
                if (value instanceof List) {
                    setProgramStageSections(((List<ProgramStageSection> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"programStageSections\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.ProgramStageSection>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "programStages":
                if (value instanceof List) {
                    setProgramStages(((List<ProgramStage> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"programStages\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.ProgramStage>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "programs":
                if (value instanceof List) {
                    setPrograms(((List<Program> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"programs\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.Program>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "relationshipTypes":
                if (value instanceof List) {
                    setRelationshipTypes(((List<RelationshipType> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"relationshipTypes\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.RelationshipType>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "reports":
                if (value instanceof List) {
                    setReports(((List<Report> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"reports\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.Report>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "schemas":
                if (value instanceof List) {
                    setSchemas(((List<Schema> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"schemas\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.Schema>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "sections":
                if (value instanceof List) {
                    setSections(((List<Section> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"sections\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.Section>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "sqlViews":
                if (value instanceof List) {
                    setSqlViews(((List<SqlView> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"sqlViews\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.SqlView>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "trackedEntityAttributes":
                if (value instanceof List) {
                    setTrackedEntityAttributes(((List<TrackedEntityAttribute> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"trackedEntityAttributes\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.TrackedEntityAttribute>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "trackedEntityTypes":
                if (value instanceof List) {
                    setTrackedEntityTypes(((List<TrackedEntityType> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"trackedEntityTypes\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.TrackedEntityType>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userGroups":
                if (value instanceof List) {
                    setUserGroups(((List<UserGroup> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"userGroups\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.UserGroup>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userRoles":
                if (value instanceof List) {
                    setUserRoles(((List<UserRole> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"userRoles\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.UserRole>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "users":
                if (value instanceof List) {
                    setUsers(((List<User> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"users\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.User>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "validationNotificationTemplates":
                if (value instanceof List) {
                    setValidationNotificationTemplates(((List<ValidationNotificationTemplate> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"validationNotificationTemplates\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.ValidationNotificationTemplate>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "validationRuleGroups":
                if (value instanceof List) {
                    setValidationRuleGroups(((List<ValidationRuleGroup> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"validationRuleGroups\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.ValidationRuleGroup>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "validationRules":
                if (value instanceof List) {
                    setValidationRules(((List<ValidationRule> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"validationRules\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.ValidationRule>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "visualizations":
                if (value instanceof List) {
                    setVisualizations(((List<Visualization> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"visualizations\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.Visualization>\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "aggregateDataExchanges":
                return getAggregateDataExchanges();
            case "analyticsTableHooks":
                return getAnalyticsTableHooks();
            case "attributes":
                return getAttributes();
            case "categories":
                return getCategories();
            case "categoryCombos":
                return getCategoryCombos();
            case "categoryOptionCombos":
                return getCategoryOptionCombos();
            case "categoryOptionGroupSets":
                return getCategoryOptionGroupSets();
            case "categoryOptionGroups":
                return getCategoryOptionGroups();
            case "categoryOptions":
                return getCategoryOptions();
            case "constants":
                return getConstants();
            case "created":
                return getCreated();
            case "dashboardItems":
                return getDashboardItems();
            case "dashboards":
                return getDashboards();
            case "dataApprovalLevels":
                return getDataApprovalLevels();
            case "dataApprovalWorkflows":
                return getDataApprovalWorkflows();
            case "dataElementGroupSets":
                return getDataElementGroupSets();
            case "dataElementGroups":
                return getDataElementGroups();
            case "dataElementOperands":
                return getDataElementOperands();
            case "dataElements":
                return getDataElements();
            case "dataEntryForms":
                return getDataEntryForms();
            case "dataSets":
                return getDataSets();
            case "dimensions":
                return getDimensions();
            case "documents":
                return getDocuments();
            case "eventCharts":
                return getEventCharts();
            case "eventReports":
                return getEventReports();
            case "eventVisualizations":
                return getEventVisualizations();
            case "events":
                return getEvents();
            case "externalMapLayers":
                return getExternalMapLayers();
            case "indicatorGroupSets":
                return getIndicatorGroupSets();
            case "indicatorGroups":
                return getIndicatorGroups();
            case "indicatorTypes":
                return getIndicatorTypes();
            case "indicators":
                return getIndicators();
            case "interpretations":
                return getInterpretations();
            case "items":
                return getItems();
            case "jobConfigurations":
                return getJobConfigurations();
            case "legendSets":
                return getLegendSets();
            case "mapViews":
                return getMapViews();
            case "maps":
                return getMaps();
            case "metadataVersions":
                return getMetadataVersions();
            case "optionGroupSets":
                return getOptionGroupSets();
            case "optionGroups":
                return getOptionGroups();
            case "optionSets":
                return getOptionSets();
            case "options":
                return getOptions();
            case "organisationUnitGroupSets":
                return getOrganisationUnitGroupSets();
            case "organisationUnitGroups":
                return getOrganisationUnitGroups();
            case "organisationUnitLevels":
                return getOrganisationUnitLevels();
            case "organisationUnits":
                return getOrganisationUnits();
            case "predictorGroups":
                return getPredictorGroups();
            case "predictors":
                return getPredictors();
            case "programIndicators":
                return getProgramIndicators();
            case "programNotificationTemplates":
                return getProgramNotificationTemplates();
            case "programRuleActions":
                return getProgramRuleActions();
            case "programRuleVariables":
                return getProgramRuleVariables();
            case "programRules":
                return getProgramRules();
            case "programStageSections":
                return getProgramStageSections();
            case "programStages":
                return getProgramStages();
            case "programs":
                return getPrograms();
            case "relationshipTypes":
                return getRelationshipTypes();
            case "reports":
                return getReports();
            case "schemas":
                return getSchemas();
            case "sections":
                return getSections();
            case "sqlViews":
                return getSqlViews();
            case "trackedEntityAttributes":
                return getTrackedEntityAttributes();
            case "trackedEntityTypes":
                return getTrackedEntityTypes();
            case "userGroups":
                return getUserGroups();
            case "userRoles":
                return getUserRoles();
            case "users":
                return getUsers();
            case "validationNotificationTemplates":
                return getValidationNotificationTemplates();
            case "validationRuleGroups":
                return getValidationRuleGroups();
            case "validationRules":
                return getValidationRules();
            case "visualizations":
                return getVisualizations();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, Metadata.NOT_FOUND_VALUE);
        if (Metadata.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public Metadata with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Metadata.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("aggregateDataExchanges");
        sb.append('=');
        sb.append(((this.aggregateDataExchanges == null)?"<null>":this.aggregateDataExchanges));
        sb.append(',');
        sb.append("analyticsTableHooks");
        sb.append('=');
        sb.append(((this.analyticsTableHooks == null)?"<null>":this.analyticsTableHooks));
        sb.append(',');
        sb.append("attributes");
        sb.append('=');
        sb.append(((this.attributes == null)?"<null>":this.attributes));
        sb.append(',');
        sb.append("categories");
        sb.append('=');
        sb.append(((this.categories == null)?"<null>":this.categories));
        sb.append(',');
        sb.append("categoryCombos");
        sb.append('=');
        sb.append(((this.categoryCombos == null)?"<null>":this.categoryCombos));
        sb.append(',');
        sb.append("categoryOptionCombos");
        sb.append('=');
        sb.append(((this.categoryOptionCombos == null)?"<null>":this.categoryOptionCombos));
        sb.append(',');
        sb.append("categoryOptionGroupSets");
        sb.append('=');
        sb.append(((this.categoryOptionGroupSets == null)?"<null>":this.categoryOptionGroupSets));
        sb.append(',');
        sb.append("categoryOptionGroups");
        sb.append('=');
        sb.append(((this.categoryOptionGroups == null)?"<null>":this.categoryOptionGroups));
        sb.append(',');
        sb.append("categoryOptions");
        sb.append('=');
        sb.append(((this.categoryOptions == null)?"<null>":this.categoryOptions));
        sb.append(',');
        sb.append("constants");
        sb.append('=');
        sb.append(((this.constants == null)?"<null>":this.constants));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("dashboardItems");
        sb.append('=');
        sb.append(((this.dashboardItems == null)?"<null>":this.dashboardItems));
        sb.append(',');
        sb.append("dashboards");
        sb.append('=');
        sb.append(((this.dashboards == null)?"<null>":this.dashboards));
        sb.append(',');
        sb.append("dataApprovalLevels");
        sb.append('=');
        sb.append(((this.dataApprovalLevels == null)?"<null>":this.dataApprovalLevels));
        sb.append(',');
        sb.append("dataApprovalWorkflows");
        sb.append('=');
        sb.append(((this.dataApprovalWorkflows == null)?"<null>":this.dataApprovalWorkflows));
        sb.append(',');
        sb.append("dataElementGroupSets");
        sb.append('=');
        sb.append(((this.dataElementGroupSets == null)?"<null>":this.dataElementGroupSets));
        sb.append(',');
        sb.append("dataElementGroups");
        sb.append('=');
        sb.append(((this.dataElementGroups == null)?"<null>":this.dataElementGroups));
        sb.append(',');
        sb.append("dataElementOperands");
        sb.append('=');
        sb.append(((this.dataElementOperands == null)?"<null>":this.dataElementOperands));
        sb.append(',');
        sb.append("dataElements");
        sb.append('=');
        sb.append(((this.dataElements == null)?"<null>":this.dataElements));
        sb.append(',');
        sb.append("dataEntryForms");
        sb.append('=');
        sb.append(((this.dataEntryForms == null)?"<null>":this.dataEntryForms));
        sb.append(',');
        sb.append("dataSets");
        sb.append('=');
        sb.append(((this.dataSets == null)?"<null>":this.dataSets));
        sb.append(',');
        sb.append("dimensions");
        sb.append('=');
        sb.append(((this.dimensions == null)?"<null>":this.dimensions));
        sb.append(',');
        sb.append("documents");
        sb.append('=');
        sb.append(((this.documents == null)?"<null>":this.documents));
        sb.append(',');
        sb.append("eventCharts");
        sb.append('=');
        sb.append(((this.eventCharts == null)?"<null>":this.eventCharts));
        sb.append(',');
        sb.append("eventReports");
        sb.append('=');
        sb.append(((this.eventReports == null)?"<null>":this.eventReports));
        sb.append(',');
        sb.append("eventVisualizations");
        sb.append('=');
        sb.append(((this.eventVisualizations == null)?"<null>":this.eventVisualizations));
        sb.append(',');
        sb.append("events");
        sb.append('=');
        sb.append(((this.events == null)?"<null>":this.events));
        sb.append(',');
        sb.append("externalMapLayers");
        sb.append('=');
        sb.append(((this.externalMapLayers == null)?"<null>":this.externalMapLayers));
        sb.append(',');
        sb.append("indicatorGroupSets");
        sb.append('=');
        sb.append(((this.indicatorGroupSets == null)?"<null>":this.indicatorGroupSets));
        sb.append(',');
        sb.append("indicatorGroups");
        sb.append('=');
        sb.append(((this.indicatorGroups == null)?"<null>":this.indicatorGroups));
        sb.append(',');
        sb.append("indicatorTypes");
        sb.append('=');
        sb.append(((this.indicatorTypes == null)?"<null>":this.indicatorTypes));
        sb.append(',');
        sb.append("indicators");
        sb.append('=');
        sb.append(((this.indicators == null)?"<null>":this.indicators));
        sb.append(',');
        sb.append("interpretations");
        sb.append('=');
        sb.append(((this.interpretations == null)?"<null>":this.interpretations));
        sb.append(',');
        sb.append("items");
        sb.append('=');
        sb.append(((this.items == null)?"<null>":this.items));
        sb.append(',');
        sb.append("jobConfigurations");
        sb.append('=');
        sb.append(((this.jobConfigurations == null)?"<null>":this.jobConfigurations));
        sb.append(',');
        sb.append("legendSets");
        sb.append('=');
        sb.append(((this.legendSets == null)?"<null>":this.legendSets));
        sb.append(',');
        sb.append("mapViews");
        sb.append('=');
        sb.append(((this.mapViews == null)?"<null>":this.mapViews));
        sb.append(',');
        sb.append("maps");
        sb.append('=');
        sb.append(((this.maps == null)?"<null>":this.maps));
        sb.append(',');
        sb.append("metadataVersions");
        sb.append('=');
        sb.append(((this.metadataVersions == null)?"<null>":this.metadataVersions));
        sb.append(',');
        sb.append("optionGroupSets");
        sb.append('=');
        sb.append(((this.optionGroupSets == null)?"<null>":this.optionGroupSets));
        sb.append(',');
        sb.append("optionGroups");
        sb.append('=');
        sb.append(((this.optionGroups == null)?"<null>":this.optionGroups));
        sb.append(',');
        sb.append("optionSets");
        sb.append('=');
        sb.append(((this.optionSets == null)?"<null>":this.optionSets));
        sb.append(',');
        sb.append("options");
        sb.append('=');
        sb.append(((this.options == null)?"<null>":this.options));
        sb.append(',');
        sb.append("organisationUnitGroupSets");
        sb.append('=');
        sb.append(((this.organisationUnitGroupSets == null)?"<null>":this.organisationUnitGroupSets));
        sb.append(',');
        sb.append("organisationUnitGroups");
        sb.append('=');
        sb.append(((this.organisationUnitGroups == null)?"<null>":this.organisationUnitGroups));
        sb.append(',');
        sb.append("organisationUnitLevels");
        sb.append('=');
        sb.append(((this.organisationUnitLevels == null)?"<null>":this.organisationUnitLevels));
        sb.append(',');
        sb.append("organisationUnits");
        sb.append('=');
        sb.append(((this.organisationUnits == null)?"<null>":this.organisationUnits));
        sb.append(',');
        sb.append("predictorGroups");
        sb.append('=');
        sb.append(((this.predictorGroups == null)?"<null>":this.predictorGroups));
        sb.append(',');
        sb.append("predictors");
        sb.append('=');
        sb.append(((this.predictors == null)?"<null>":this.predictors));
        sb.append(',');
        sb.append("programIndicators");
        sb.append('=');
        sb.append(((this.programIndicators == null)?"<null>":this.programIndicators));
        sb.append(',');
        sb.append("programNotificationTemplates");
        sb.append('=');
        sb.append(((this.programNotificationTemplates == null)?"<null>":this.programNotificationTemplates));
        sb.append(',');
        sb.append("programRuleActions");
        sb.append('=');
        sb.append(((this.programRuleActions == null)?"<null>":this.programRuleActions));
        sb.append(',');
        sb.append("programRuleVariables");
        sb.append('=');
        sb.append(((this.programRuleVariables == null)?"<null>":this.programRuleVariables));
        sb.append(',');
        sb.append("programRules");
        sb.append('=');
        sb.append(((this.programRules == null)?"<null>":this.programRules));
        sb.append(',');
        sb.append("programStageSections");
        sb.append('=');
        sb.append(((this.programStageSections == null)?"<null>":this.programStageSections));
        sb.append(',');
        sb.append("programStages");
        sb.append('=');
        sb.append(((this.programStages == null)?"<null>":this.programStages));
        sb.append(',');
        sb.append("programs");
        sb.append('=');
        sb.append(((this.programs == null)?"<null>":this.programs));
        sb.append(',');
        sb.append("relationshipTypes");
        sb.append('=');
        sb.append(((this.relationshipTypes == null)?"<null>":this.relationshipTypes));
        sb.append(',');
        sb.append("reports");
        sb.append('=');
        sb.append(((this.reports == null)?"<null>":this.reports));
        sb.append(',');
        sb.append("schemas");
        sb.append('=');
        sb.append(((this.schemas == null)?"<null>":this.schemas));
        sb.append(',');
        sb.append("sections");
        sb.append('=');
        sb.append(((this.sections == null)?"<null>":this.sections));
        sb.append(',');
        sb.append("sqlViews");
        sb.append('=');
        sb.append(((this.sqlViews == null)?"<null>":this.sqlViews));
        sb.append(',');
        sb.append("trackedEntityAttributes");
        sb.append('=');
        sb.append(((this.trackedEntityAttributes == null)?"<null>":this.trackedEntityAttributes));
        sb.append(',');
        sb.append("trackedEntityTypes");
        sb.append('=');
        sb.append(((this.trackedEntityTypes == null)?"<null>":this.trackedEntityTypes));
        sb.append(',');
        sb.append("userGroups");
        sb.append('=');
        sb.append(((this.userGroups == null)?"<null>":this.userGroups));
        sb.append(',');
        sb.append("userRoles");
        sb.append('=');
        sb.append(((this.userRoles == null)?"<null>":this.userRoles));
        sb.append(',');
        sb.append("users");
        sb.append('=');
        sb.append(((this.users == null)?"<null>":this.users));
        sb.append(',');
        sb.append("validationNotificationTemplates");
        sb.append('=');
        sb.append(((this.validationNotificationTemplates == null)?"<null>":this.validationNotificationTemplates));
        sb.append(',');
        sb.append("validationRuleGroups");
        sb.append('=');
        sb.append(((this.validationRuleGroups == null)?"<null>":this.validationRuleGroups));
        sb.append(',');
        sb.append("validationRules");
        sb.append('=');
        sb.append(((this.validationRules == null)?"<null>":this.validationRules));
        sb.append(',');
        sb.append("visualizations");
        sb.append('=');
        sb.append(((this.visualizations == null)?"<null>":this.visualizations));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.validationRuleGroups == null)? 0 :this.validationRuleGroups.hashCode()));
        result = ((result* 31)+((this.indicatorGroupSets == null)? 0 :this.indicatorGroupSets.hashCode()));
        result = ((result* 31)+((this.reports == null)? 0 :this.reports.hashCode()));
        result = ((result* 31)+((this.documents == null)? 0 :this.documents.hashCode()));
        result = ((result* 31)+((this.dataElementGroupSets == null)? 0 :this.dataElementGroupSets.hashCode()));
        result = ((result* 31)+((this.optionGroups == null)? 0 :this.optionGroups.hashCode()));
        result = ((result* 31)+((this.dashboards == null)? 0 :this.dashboards.hashCode()));
        result = ((result* 31)+((this.eventVisualizations == null)? 0 :this.eventVisualizations.hashCode()));
        result = ((result* 31)+((this.programIndicators == null)? 0 :this.programIndicators.hashCode()));
        result = ((result* 31)+((this.trackedEntityTypes == null)? 0 :this.trackedEntityTypes.hashCode()));
        result = ((result* 31)+((this.options == null)? 0 :this.options.hashCode()));
        result = ((result* 31)+((this.categoryOptions == null)? 0 :this.categoryOptions.hashCode()));
        result = ((result* 31)+((this.constants == null)? 0 :this.constants.hashCode()));
        result = ((result* 31)+((this.organisationUnitGroups == null)? 0 :this.organisationUnitGroups.hashCode()));
        result = ((result* 31)+((this.interpretations == null)? 0 :this.interpretations.hashCode()));
        result = ((result* 31)+((this.dataEntryForms == null)? 0 :this.dataEntryForms.hashCode()));
        result = ((result* 31)+((this.events == null)? 0 :this.events.hashCode()));
        result = ((result* 31)+((this.indicatorTypes == null)? 0 :this.indicatorTypes.hashCode()));
        result = ((result* 31)+((this.eventReports == null)? 0 :this.eventReports.hashCode()));
        result = ((result* 31)+((this.maps == null)? 0 :this.maps.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.indicatorGroups == null)? 0 :this.indicatorGroups.hashCode()));
        result = ((result* 31)+((this.predictorGroups == null)? 0 :this.predictorGroups.hashCode()));
        result = ((result* 31)+((this.indicators == null)? 0 :this.indicators.hashCode()));
        result = ((result* 31)+((this.categoryOptionCombos == null)? 0 :this.categoryOptionCombos.hashCode()));
        result = ((result* 31)+((this.sections == null)? 0 :this.sections.hashCode()));
        result = ((result* 31)+((this.users == null)? 0 :this.users.hashCode()));
        result = ((result* 31)+((this.dataElementOperands == null)? 0 :this.dataElementOperands.hashCode()));
        result = ((result* 31)+((this.externalMapLayers == null)? 0 :this.externalMapLayers.hashCode()));
        result = ((result* 31)+((this.userGroups == null)? 0 :this.userGroups.hashCode()));
        result = ((result* 31)+((this.userRoles == null)? 0 :this.userRoles.hashCode()));
        result = ((result* 31)+((this.programNotificationTemplates == null)? 0 :this.programNotificationTemplates.hashCode()));
        result = ((result* 31)+((this.programRuleActions == null)? 0 :this.programRuleActions.hashCode()));
        result = ((result* 31)+((this.schemas == null)? 0 :this.schemas.hashCode()));
        result = ((result* 31)+((this.optionSets == null)? 0 :this.optionSets.hashCode()));
        result = ((result* 31)+((this.dataSets == null)? 0 :this.dataSets.hashCode()));
        result = ((result* 31)+((this.legendSets == null)? 0 :this.legendSets.hashCode()));
        result = ((result* 31)+((this.categoryOptionGroupSets == null)? 0 :this.categoryOptionGroupSets.hashCode()));
        result = ((result* 31)+((this.programs == null)? 0 :this.programs.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.items == null)? 0 :this.items.hashCode()));
        result = ((result* 31)+((this.sqlViews == null)? 0 :this.sqlViews.hashCode()));
        result = ((result* 31)+((this.predictors == null)? 0 :this.predictors.hashCode()));
        result = ((result* 31)+((this.programRuleVariables == null)? 0 :this.programRuleVariables.hashCode()));
        result = ((result* 31)+((this.dataApprovalLevels == null)? 0 :this.dataApprovalLevels.hashCode()));
        result = ((result* 31)+((this.analyticsTableHooks == null)? 0 :this.analyticsTableHooks.hashCode()));
        result = ((result* 31)+((this.aggregateDataExchanges == null)? 0 :this.aggregateDataExchanges.hashCode()));
        result = ((result* 31)+((this.jobConfigurations == null)? 0 :this.jobConfigurations.hashCode()));
        result = ((result* 31)+((this.organisationUnitLevels == null)? 0 :this.organisationUnitLevels.hashCode()));
        result = ((result* 31)+((this.optionGroupSets == null)? 0 :this.optionGroupSets.hashCode()));
        result = ((result* 31)+((this.mapViews == null)? 0 :this.mapViews.hashCode()));
        result = ((result* 31)+((this.categories == null)? 0 :this.categories.hashCode()));
        result = ((result* 31)+((this.categoryCombos == null)? 0 :this.categoryCombos.hashCode()));
        result = ((result* 31)+((this.organisationUnits == null)? 0 :this.organisationUnits.hashCode()));
        result = ((result* 31)+((this.dataElements == null)? 0 :this.dataElements.hashCode()));
        result = ((result* 31)+((this.visualizations == null)? 0 :this.visualizations.hashCode()));
        result = ((result* 31)+((this.validationRules == null)? 0 :this.validationRules.hashCode()));
        result = ((result* 31)+((this.dataElementGroups == null)? 0 :this.dataElementGroups.hashCode()));
        result = ((result* 31)+((this.eventCharts == null)? 0 :this.eventCharts.hashCode()));
        result = ((result* 31)+((this.dataApprovalWorkflows == null)? 0 :this.dataApprovalWorkflows.hashCode()));
        result = ((result* 31)+((this.organisationUnitGroupSets == null)? 0 :this.organisationUnitGroupSets.hashCode()));
        result = ((result* 31)+((this.programStages == null)? 0 :this.programStages.hashCode()));
        result = ((result* 31)+((this.metadataVersions == null)? 0 :this.metadataVersions.hashCode()));
        result = ((result* 31)+((this.categoryOptionGroups == null)? 0 :this.categoryOptionGroups.hashCode()));
        result = ((result* 31)+((this.dashboardItems == null)? 0 :this.dashboardItems.hashCode()));
        result = ((result* 31)+((this.validationNotificationTemplates == null)? 0 :this.validationNotificationTemplates.hashCode()));
        result = ((result* 31)+((this.trackedEntityAttributes == null)? 0 :this.trackedEntityAttributes.hashCode()));
        result = ((result* 31)+((this.attributes == null)? 0 :this.attributes.hashCode()));
        result = ((result* 31)+((this.relationshipTypes == null)? 0 :this.relationshipTypes.hashCode()));
        result = ((result* 31)+((this.programRules == null)? 0 :this.programRules.hashCode()));
        result = ((result* 31)+((this.programStageSections == null)? 0 :this.programStageSections.hashCode()));
        result = ((result* 31)+((this.dimensions == null)? 0 :this.dimensions.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Metadata) == false) {
            return false;
        }
        Metadata rhs = ((Metadata) other);
        return (((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((this.validationRuleGroups == rhs.validationRuleGroups)||((this.validationRuleGroups!= null)&&this.validationRuleGroups.equals(rhs.validationRuleGroups)))&&((this.indicatorGroupSets == rhs.indicatorGroupSets)||((this.indicatorGroupSets!= null)&&this.indicatorGroupSets.equals(rhs.indicatorGroupSets))))&&((this.reports == rhs.reports)||((this.reports!= null)&&this.reports.equals(rhs.reports))))&&((this.documents == rhs.documents)||((this.documents!= null)&&this.documents.equals(rhs.documents))))&&((this.dataElementGroupSets == rhs.dataElementGroupSets)||((this.dataElementGroupSets!= null)&&this.dataElementGroupSets.equals(rhs.dataElementGroupSets))))&&((this.optionGroups == rhs.optionGroups)||((this.optionGroups!= null)&&this.optionGroups.equals(rhs.optionGroups))))&&((this.dashboards == rhs.dashboards)||((this.dashboards!= null)&&this.dashboards.equals(rhs.dashboards))))&&((this.eventVisualizations == rhs.eventVisualizations)||((this.eventVisualizations!= null)&&this.eventVisualizations.equals(rhs.eventVisualizations))))&&((this.programIndicators == rhs.programIndicators)||((this.programIndicators!= null)&&this.programIndicators.equals(rhs.programIndicators))))&&((this.trackedEntityTypes == rhs.trackedEntityTypes)||((this.trackedEntityTypes!= null)&&this.trackedEntityTypes.equals(rhs.trackedEntityTypes))))&&((this.options == rhs.options)||((this.options!= null)&&this.options.equals(rhs.options))))&&((this.categoryOptions == rhs.categoryOptions)||((this.categoryOptions!= null)&&this.categoryOptions.equals(rhs.categoryOptions))))&&((this.constants == rhs.constants)||((this.constants!= null)&&this.constants.equals(rhs.constants))))&&((this.organisationUnitGroups == rhs.organisationUnitGroups)||((this.organisationUnitGroups!= null)&&this.organisationUnitGroups.equals(rhs.organisationUnitGroups))))&&((this.interpretations == rhs.interpretations)||((this.interpretations!= null)&&this.interpretations.equals(rhs.interpretations))))&&((this.dataEntryForms == rhs.dataEntryForms)||((this.dataEntryForms!= null)&&this.dataEntryForms.equals(rhs.dataEntryForms))))&&((this.events == rhs.events)||((this.events!= null)&&this.events.equals(rhs.events))))&&((this.indicatorTypes == rhs.indicatorTypes)||((this.indicatorTypes!= null)&&this.indicatorTypes.equals(rhs.indicatorTypes))))&&((this.eventReports == rhs.eventReports)||((this.eventReports!= null)&&this.eventReports.equals(rhs.eventReports))))&&((this.maps == rhs.maps)||((this.maps!= null)&&this.maps.equals(rhs.maps))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.indicatorGroups == rhs.indicatorGroups)||((this.indicatorGroups!= null)&&this.indicatorGroups.equals(rhs.indicatorGroups))))&&((this.predictorGroups == rhs.predictorGroups)||((this.predictorGroups!= null)&&this.predictorGroups.equals(rhs.predictorGroups))))&&((this.indicators == rhs.indicators)||((this.indicators!= null)&&this.indicators.equals(rhs.indicators))))&&((this.categoryOptionCombos == rhs.categoryOptionCombos)||((this.categoryOptionCombos!= null)&&this.categoryOptionCombos.equals(rhs.categoryOptionCombos))))&&((this.sections == rhs.sections)||((this.sections!= null)&&this.sections.equals(rhs.sections))))&&((this.users == rhs.users)||((this.users!= null)&&this.users.equals(rhs.users))))&&((this.dataElementOperands == rhs.dataElementOperands)||((this.dataElementOperands!= null)&&this.dataElementOperands.equals(rhs.dataElementOperands))))&&((this.externalMapLayers == rhs.externalMapLayers)||((this.externalMapLayers!= null)&&this.externalMapLayers.equals(rhs.externalMapLayers))))&&((this.userGroups == rhs.userGroups)||((this.userGroups!= null)&&this.userGroups.equals(rhs.userGroups))))&&((this.userRoles == rhs.userRoles)||((this.userRoles!= null)&&this.userRoles.equals(rhs.userRoles))))&&((this.programNotificationTemplates == rhs.programNotificationTemplates)||((this.programNotificationTemplates!= null)&&this.programNotificationTemplates.equals(rhs.programNotificationTemplates))))&&((this.programRuleActions == rhs.programRuleActions)||((this.programRuleActions!= null)&&this.programRuleActions.equals(rhs.programRuleActions))))&&((this.schemas == rhs.schemas)||((this.schemas!= null)&&this.schemas.equals(rhs.schemas))))&&((this.optionSets == rhs.optionSets)||((this.optionSets!= null)&&this.optionSets.equals(rhs.optionSets))))&&((this.dataSets == rhs.dataSets)||((this.dataSets!= null)&&this.dataSets.equals(rhs.dataSets))))&&((this.legendSets == rhs.legendSets)||((this.legendSets!= null)&&this.legendSets.equals(rhs.legendSets))))&&((this.categoryOptionGroupSets == rhs.categoryOptionGroupSets)||((this.categoryOptionGroupSets!= null)&&this.categoryOptionGroupSets.equals(rhs.categoryOptionGroupSets))))&&((this.programs == rhs.programs)||((this.programs!= null)&&this.programs.equals(rhs.programs))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.items == rhs.items)||((this.items!= null)&&this.items.equals(rhs.items))))&&((this.sqlViews == rhs.sqlViews)||((this.sqlViews!= null)&&this.sqlViews.equals(rhs.sqlViews))))&&((this.predictors == rhs.predictors)||((this.predictors!= null)&&this.predictors.equals(rhs.predictors))))&&((this.programRuleVariables == rhs.programRuleVariables)||((this.programRuleVariables!= null)&&this.programRuleVariables.equals(rhs.programRuleVariables))))&&((this.dataApprovalLevels == rhs.dataApprovalLevels)||((this.dataApprovalLevels!= null)&&this.dataApprovalLevels.equals(rhs.dataApprovalLevels))))&&((this.analyticsTableHooks == rhs.analyticsTableHooks)||((this.analyticsTableHooks!= null)&&this.analyticsTableHooks.equals(rhs.analyticsTableHooks))))&&((this.aggregateDataExchanges == rhs.aggregateDataExchanges)||((this.aggregateDataExchanges!= null)&&this.aggregateDataExchanges.equals(rhs.aggregateDataExchanges))))&&((this.jobConfigurations == rhs.jobConfigurations)||((this.jobConfigurations!= null)&&this.jobConfigurations.equals(rhs.jobConfigurations))))&&((this.organisationUnitLevels == rhs.organisationUnitLevels)||((this.organisationUnitLevels!= null)&&this.organisationUnitLevels.equals(rhs.organisationUnitLevels))))&&((this.optionGroupSets == rhs.optionGroupSets)||((this.optionGroupSets!= null)&&this.optionGroupSets.equals(rhs.optionGroupSets))))&&((this.mapViews == rhs.mapViews)||((this.mapViews!= null)&&this.mapViews.equals(rhs.mapViews))))&&((this.categories == rhs.categories)||((this.categories!= null)&&this.categories.equals(rhs.categories))))&&((this.categoryCombos == rhs.categoryCombos)||((this.categoryCombos!= null)&&this.categoryCombos.equals(rhs.categoryCombos))))&&((this.organisationUnits == rhs.organisationUnits)||((this.organisationUnits!= null)&&this.organisationUnits.equals(rhs.organisationUnits))))&&((this.dataElements == rhs.dataElements)||((this.dataElements!= null)&&this.dataElements.equals(rhs.dataElements))))&&((this.visualizations == rhs.visualizations)||((this.visualizations!= null)&&this.visualizations.equals(rhs.visualizations))))&&((this.validationRules == rhs.validationRules)||((this.validationRules!= null)&&this.validationRules.equals(rhs.validationRules))))&&((this.dataElementGroups == rhs.dataElementGroups)||((this.dataElementGroups!= null)&&this.dataElementGroups.equals(rhs.dataElementGroups))))&&((this.eventCharts == rhs.eventCharts)||((this.eventCharts!= null)&&this.eventCharts.equals(rhs.eventCharts))))&&((this.dataApprovalWorkflows == rhs.dataApprovalWorkflows)||((this.dataApprovalWorkflows!= null)&&this.dataApprovalWorkflows.equals(rhs.dataApprovalWorkflows))))&&((this.organisationUnitGroupSets == rhs.organisationUnitGroupSets)||((this.organisationUnitGroupSets!= null)&&this.organisationUnitGroupSets.equals(rhs.organisationUnitGroupSets))))&&((this.programStages == rhs.programStages)||((this.programStages!= null)&&this.programStages.equals(rhs.programStages))))&&((this.metadataVersions == rhs.metadataVersions)||((this.metadataVersions!= null)&&this.metadataVersions.equals(rhs.metadataVersions))))&&((this.categoryOptionGroups == rhs.categoryOptionGroups)||((this.categoryOptionGroups!= null)&&this.categoryOptionGroups.equals(rhs.categoryOptionGroups))))&&((this.dashboardItems == rhs.dashboardItems)||((this.dashboardItems!= null)&&this.dashboardItems.equals(rhs.dashboardItems))))&&((this.validationNotificationTemplates == rhs.validationNotificationTemplates)||((this.validationNotificationTemplates!= null)&&this.validationNotificationTemplates.equals(rhs.validationNotificationTemplates))))&&((this.trackedEntityAttributes == rhs.trackedEntityAttributes)||((this.trackedEntityAttributes!= null)&&this.trackedEntityAttributes.equals(rhs.trackedEntityAttributes))))&&((this.attributes == rhs.attributes)||((this.attributes!= null)&&this.attributes.equals(rhs.attributes))))&&((this.relationshipTypes == rhs.relationshipTypes)||((this.relationshipTypes!= null)&&this.relationshipTypes.equals(rhs.relationshipTypes))))&&((this.programRules == rhs.programRules)||((this.programRules!= null)&&this.programRules.equals(rhs.programRules))))&&((this.programStageSections == rhs.programStageSections)||((this.programStageSections!= null)&&this.programStageSections.equals(rhs.programStageSections))))&&((this.dimensions == rhs.dimensions)||((this.dimensions!= null)&&this.dimensions.equals(rhs.dimensions))));
    }

}
