
package org.hisp.dhis.api.model.v2_39_1;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "responseType",
    "stats",
    "status",
    "typeReports"
})
@Generated("jsonschema2pojo")
public class ImportReportWebMessageResponse implements Serializable
{

    @JsonProperty("responseType")
    private String responseType;
    @JsonProperty("stats")
    private Stats stats;
    @JsonProperty("status")
    private org.hisp.dhis.api.model.v2_39_1.DescriptiveWebMessage.Status status;
    @JsonProperty("typeReports")
    private List<TypeReport> typeReports = null;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 1201792071390541818L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ImportReportWebMessageResponse() {
    }

    /**
     * 
     * @param source
     */
    public ImportReportWebMessageResponse(ImportReportWebMessageResponse source) {
        super();
        this.responseType = source.responseType;
        this.stats = source.stats;
        this.status = source.status;
        this.typeReports = source.typeReports;
    }

    /**
     * 
     * @param typeReports
     * @param responseType
     * @param stats
     * @param status
     */
    public ImportReportWebMessageResponse(String responseType, Stats stats, org.hisp.dhis.api.model.v2_39_1.DescriptiveWebMessage.Status status, List<TypeReport> typeReports) {
        super();
        this.responseType = responseType;
        this.stats = stats;
        this.status = status;
        this.typeReports = typeReports;
    }

    @JsonProperty("responseType")
    public Optional<String> getResponseType() {
        return Optional.ofNullable(responseType);
    }

    @JsonProperty("responseType")
    public void setResponseType(String responseType) {
        this.responseType = responseType;
    }

    public ImportReportWebMessageResponse withResponseType(String responseType) {
        this.responseType = responseType;
        return this;
    }

    @JsonProperty("stats")
    public Optional<Stats> getStats() {
        return Optional.ofNullable(stats);
    }

    @JsonProperty("stats")
    public void setStats(Stats stats) {
        this.stats = stats;
    }

    public ImportReportWebMessageResponse withStats(Stats stats) {
        this.stats = stats;
        return this;
    }

    @JsonProperty("status")
    public Optional<org.hisp.dhis.api.model.v2_39_1.DescriptiveWebMessage.Status> getStatus() {
        return Optional.ofNullable(status);
    }

    @JsonProperty("status")
    public void setStatus(org.hisp.dhis.api.model.v2_39_1.DescriptiveWebMessage.Status status) {
        this.status = status;
    }

    public ImportReportWebMessageResponse withStatus(org.hisp.dhis.api.model.v2_39_1.DescriptiveWebMessage.Status status) {
        this.status = status;
        return this;
    }

    @JsonProperty("typeReports")
    public Optional<List<TypeReport>> getTypeReports() {
        return Optional.ofNullable(typeReports);
    }

    @JsonProperty("typeReports")
    public void setTypeReports(List<TypeReport> typeReports) {
        this.typeReports = typeReports;
    }

    public ImportReportWebMessageResponse withTypeReports(List<TypeReport> typeReports) {
        this.typeReports = typeReports;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ImportReportWebMessageResponse withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "responseType":
                if (value instanceof String) {
                    setResponseType(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"responseType\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "stats":
                if (value instanceof Stats) {
                    setStats(((Stats) value));
                } else {
                    throw new IllegalArgumentException(("property \"stats\" is of type \"org.hisp.dhis.api.model.v2_39_1.Stats\", but got "+ value.getClass().toString()));
                }
                return true;
            case "status":
                if (value instanceof org.hisp.dhis.api.model.v2_39_1.DescriptiveWebMessage.Status) {
                    setStatus(((org.hisp.dhis.api.model.v2_39_1.DescriptiveWebMessage.Status) value));
                } else {
                    throw new IllegalArgumentException(("property \"status\" is of type \"org.hisp.dhis.api.model.v2_39_1.DescriptiveWebMessage.Status\", but got "+ value.getClass().toString()));
                }
                return true;
            case "typeReports":
                if (value instanceof List) {
                    setTypeReports(((List<TypeReport> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"typeReports\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.TypeReport>\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "responseType":
                return getResponseType();
            case "stats":
                return getStats();
            case "status":
                return getStatus();
            case "typeReports":
                return getTypeReports();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ImportReportWebMessageResponse.NOT_FOUND_VALUE);
        if (ImportReportWebMessageResponse.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ImportReportWebMessageResponse with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ImportReportWebMessageResponse.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("responseType");
        sb.append('=');
        sb.append(((this.responseType == null)?"<null>":this.responseType));
        sb.append(',');
        sb.append("stats");
        sb.append('=');
        sb.append(((this.stats == null)?"<null>":this.stats));
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(((this.status == null)?"<null>":this.status));
        sb.append(',');
        sb.append("typeReports");
        sb.append('=');
        sb.append(((this.typeReports == null)?"<null>":this.typeReports));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.typeReports == null)? 0 :this.typeReports.hashCode()));
        result = ((result* 31)+((this.responseType == null)? 0 :this.responseType.hashCode()));
        result = ((result* 31)+((this.stats == null)? 0 :this.stats.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.status == null)? 0 :this.status.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ImportReportWebMessageResponse) == false) {
            return false;
        }
        ImportReportWebMessageResponse rhs = ((ImportReportWebMessageResponse) other);
        return ((((((this.typeReports == rhs.typeReports)||((this.typeReports!= null)&&this.typeReports.equals(rhs.typeReports)))&&((this.responseType == rhs.responseType)||((this.responseType!= null)&&this.responseType.equals(rhs.responseType))))&&((this.stats == rhs.stats)||((this.stats!= null)&&this.stats.equals(rhs.stats))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.status == rhs.status)||((this.status!= null)&&this.status.equals(rhs.status))));
    }

}
