
package org.hisp.dhis.api.model.v2_39_1;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "databaseVersion",
    "name",
    "spatialSupport",
    "url",
    "user"
})
@Generated("jsonschema2pojo")
public class DatabaseInfo implements Serializable
{

    @JsonProperty("databaseVersion")
    private String databaseVersion;
    @JsonProperty("name")
    private String name;
    @JsonProperty("spatialSupport")
    private Boolean spatialSupport;
    @JsonProperty("url")
    private String url;
    @JsonProperty("user")
    private String user;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -4482030187183880654L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DatabaseInfo() {
    }

    /**
     * 
     * @param source
     */
    public DatabaseInfo(DatabaseInfo source) {
        super();
        this.databaseVersion = source.databaseVersion;
        this.name = source.name;
        this.spatialSupport = source.spatialSupport;
        this.url = source.url;
        this.user = source.user;
    }

    /**
     * 
     * @param spatialSupport
     * @param name
     * @param databaseVersion
     * @param user
     * @param url
     */
    public DatabaseInfo(String databaseVersion, String name, Boolean spatialSupport, String url, String user) {
        super();
        this.databaseVersion = databaseVersion;
        this.name = name;
        this.spatialSupport = spatialSupport;
        this.url = url;
        this.user = user;
    }

    @JsonProperty("databaseVersion")
    public Optional<String> getDatabaseVersion() {
        return Optional.ofNullable(databaseVersion);
    }

    @JsonProperty("databaseVersion")
    public void setDatabaseVersion(String databaseVersion) {
        this.databaseVersion = databaseVersion;
    }

    public DatabaseInfo withDatabaseVersion(String databaseVersion) {
        this.databaseVersion = databaseVersion;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public DatabaseInfo withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("spatialSupport")
    public Optional<Boolean> getSpatialSupport() {
        return Optional.ofNullable(spatialSupport);
    }

    @JsonProperty("spatialSupport")
    public void setSpatialSupport(Boolean spatialSupport) {
        this.spatialSupport = spatialSupport;
    }

    public DatabaseInfo withSpatialSupport(Boolean spatialSupport) {
        this.spatialSupport = spatialSupport;
        return this;
    }

    @JsonProperty("url")
    public Optional<String> getUrl() {
        return Optional.ofNullable(url);
    }

    @JsonProperty("url")
    public void setUrl(String url) {
        this.url = url;
    }

    public DatabaseInfo withUrl(String url) {
        this.url = url;
        return this;
    }

    @JsonProperty("user")
    public Optional<String> getUser() {
        return Optional.ofNullable(user);
    }

    @JsonProperty("user")
    public void setUser(String user) {
        this.user = user;
    }

    public DatabaseInfo withUser(String user) {
        this.user = user;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public DatabaseInfo withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "databaseVersion":
                if (value instanceof String) {
                    setDatabaseVersion(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"databaseVersion\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "name":
                if (value instanceof String) {
                    setName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "spatialSupport":
                if (value instanceof Boolean) {
                    setSpatialSupport(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"spatialSupport\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "url":
                if (value instanceof String) {
                    setUrl(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"url\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "user":
                if (value instanceof String) {
                    setUser(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"user\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "databaseVersion":
                return getDatabaseVersion();
            case "name":
                return getName();
            case "spatialSupport":
                return getSpatialSupport();
            case "url":
                return getUrl();
            case "user":
                return getUser();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, DatabaseInfo.NOT_FOUND_VALUE);
        if (DatabaseInfo.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public DatabaseInfo with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DatabaseInfo.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("databaseVersion");
        sb.append('=');
        sb.append(((this.databaseVersion == null)?"<null>":this.databaseVersion));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("spatialSupport");
        sb.append('=');
        sb.append(((this.spatialSupport == null)?"<null>":this.spatialSupport));
        sb.append(',');
        sb.append("url");
        sb.append('=');
        sb.append(((this.url == null)?"<null>":this.url));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.spatialSupport == null)? 0 :this.spatialSupport.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.databaseVersion == null)? 0 :this.databaseVersion.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        result = ((result* 31)+((this.url == null)? 0 :this.url.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof DatabaseInfo) == false) {
            return false;
        }
        DatabaseInfo rhs = ((DatabaseInfo) other);
        return (((((((this.spatialSupport == rhs.spatialSupport)||((this.spatialSupport!= null)&&this.spatialSupport.equals(rhs.spatialSupport)))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.databaseVersion == rhs.databaseVersion)||((this.databaseVersion!= null)&&this.databaseVersion.equals(rhs.databaseVersion))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))))&&((this.url == rhs.url)||((this.url!= null)&&this.url.equals(rhs.url))));
    }

}
