
package org.hisp.dhis.api.model.v2_39_1;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "categoryOptionCombo",
    "dataElement",
    "period",
    "source",
    "value"
})
@Generated("jsonschema2pojo")
public class DataValue implements Serializable
{

    @JsonProperty("categoryOptionCombo")
    private CategoryOptionCombo categoryOptionCombo;
    @JsonProperty("dataElement")
    private DataElement dataElement;
    @JsonProperty("period")
    private Period period;
    @JsonProperty("source")
    private OrganisationUnit source;
    @JsonProperty("value")
    private String value;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -8433833311380024677L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DataValue() {
    }

    /**
     * 
     * @param source
     */
    public DataValue(DataValue source) {
        super();
        this.categoryOptionCombo = source.categoryOptionCombo;
        this.dataElement = source.dataElement;
        this.period = source.period;
        this.source = source.source;
        this.value = source.value;
    }

    /**
     * 
     * @param period
     * @param categoryOptionCombo
     * @param dataElement
     * @param source
     * @param value
     */
    public DataValue(CategoryOptionCombo categoryOptionCombo, DataElement dataElement, Period period, OrganisationUnit source, String value) {
        super();
        this.categoryOptionCombo = categoryOptionCombo;
        this.dataElement = dataElement;
        this.period = period;
        this.source = source;
        this.value = value;
    }

    @JsonProperty("categoryOptionCombo")
    public Optional<CategoryOptionCombo> getCategoryOptionCombo() {
        return Optional.ofNullable(categoryOptionCombo);
    }

    @JsonProperty("categoryOptionCombo")
    public void setCategoryOptionCombo(CategoryOptionCombo categoryOptionCombo) {
        this.categoryOptionCombo = categoryOptionCombo;
    }

    public DataValue withCategoryOptionCombo(CategoryOptionCombo categoryOptionCombo) {
        this.categoryOptionCombo = categoryOptionCombo;
        return this;
    }

    @JsonProperty("dataElement")
    public Optional<DataElement> getDataElement() {
        return Optional.ofNullable(dataElement);
    }

    @JsonProperty("dataElement")
    public void setDataElement(DataElement dataElement) {
        this.dataElement = dataElement;
    }

    public DataValue withDataElement(DataElement dataElement) {
        this.dataElement = dataElement;
        return this;
    }

    @JsonProperty("period")
    public Optional<Period> getPeriod() {
        return Optional.ofNullable(period);
    }

    @JsonProperty("period")
    public void setPeriod(Period period) {
        this.period = period;
    }

    public DataValue withPeriod(Period period) {
        this.period = period;
        return this;
    }

    @JsonProperty("source")
    public Optional<OrganisationUnit> getSource() {
        return Optional.ofNullable(source);
    }

    @JsonProperty("source")
    public void setSource(OrganisationUnit source) {
        this.source = source;
    }

    public DataValue withSource(OrganisationUnit source) {
        this.source = source;
        return this;
    }

    @JsonProperty("value")
    public Optional<String> getValue() {
        return Optional.ofNullable(value);
    }

    @JsonProperty("value")
    public void setValue(String value) {
        this.value = value;
    }

    public DataValue withValue(String value) {
        this.value = value;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public DataValue withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "categoryOptionCombo":
                if (value instanceof CategoryOptionCombo) {
                    setCategoryOptionCombo(((CategoryOptionCombo) value));
                } else {
                    throw new IllegalArgumentException(("property \"categoryOptionCombo\" is of type \"org.hisp.dhis.api.model.v2_39_1.CategoryOptionCombo\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataElement":
                if (value instanceof DataElement) {
                    setDataElement(((DataElement) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataElement\" is of type \"org.hisp.dhis.api.model.v2_39_1.DataElement\", but got "+ value.getClass().toString()));
                }
                return true;
            case "period":
                if (value instanceof Period) {
                    setPeriod(((Period) value));
                } else {
                    throw new IllegalArgumentException(("property \"period\" is of type \"org.hisp.dhis.api.model.v2_39_1.Period\", but got "+ value.getClass().toString()));
                }
                return true;
            case "source":
                if (value instanceof OrganisationUnit) {
                    setSource(((OrganisationUnit) value));
                } else {
                    throw new IllegalArgumentException(("property \"source\" is of type \"org.hisp.dhis.api.model.v2_39_1.OrganisationUnit\", but got "+ value.getClass().toString()));
                }
                return true;
            case "value":
                if (value instanceof String) {
                    setValue(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"value\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "categoryOptionCombo":
                return getCategoryOptionCombo();
            case "dataElement":
                return getDataElement();
            case "period":
                return getPeriod();
            case "source":
                return getSource();
            case "value":
                return getValue();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, DataValue.NOT_FOUND_VALUE);
        if (DataValue.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public DataValue with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DataValue.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("categoryOptionCombo");
        sb.append('=');
        sb.append(((this.categoryOptionCombo == null)?"<null>":this.categoryOptionCombo));
        sb.append(',');
        sb.append("dataElement");
        sb.append('=');
        sb.append(((this.dataElement == null)?"<null>":this.dataElement));
        sb.append(',');
        sb.append("period");
        sb.append('=');
        sb.append(((this.period == null)?"<null>":this.period));
        sb.append(',');
        sb.append("source");
        sb.append('=');
        sb.append(((this.source == null)?"<null>":this.source));
        sb.append(',');
        sb.append("value");
        sb.append('=');
        sb.append(((this.value == null)?"<null>":this.value));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.period == null)? 0 :this.period.hashCode()));
        result = ((result* 31)+((this.categoryOptionCombo == null)? 0 :this.categoryOptionCombo.hashCode()));
        result = ((result* 31)+((this.dataElement == null)? 0 :this.dataElement.hashCode()));
        result = ((result* 31)+((this.source == null)? 0 :this.source.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.value == null)? 0 :this.value.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof DataValue) == false) {
            return false;
        }
        DataValue rhs = ((DataValue) other);
        return (((((((this.period == rhs.period)||((this.period!= null)&&this.period.equals(rhs.period)))&&((this.categoryOptionCombo == rhs.categoryOptionCombo)||((this.categoryOptionCombo!= null)&&this.categoryOptionCombo.equals(rhs.categoryOptionCombo))))&&((this.dataElement == rhs.dataElement)||((this.dataElement!= null)&&this.dataElement.equals(rhs.dataElement))))&&((this.source == rhs.source)||((this.source!= null)&&this.source.equals(rhs.source))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.value == rhs.value)||((this.value!= null)&&this.value.equals(rhs.value))));
    }

}
