
package org.hisp.dhis.api.model.v2_39_1;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "activeUsers",
    "dataValueCount",
    "eventCount",
    "objectCounts",
    "userInvitations"
})
@Generated("jsonschema2pojo")
public class DataSummary implements Serializable
{

    /**
     * Undefined
     * 
     */
    @JsonProperty("activeUsers")
    private ActiveUsers activeUsers;
    /**
     * Undefined
     * 
     */
    @JsonProperty("dataValueCount")
    private DataValueCount dataValueCount;
    /**
     * Undefined
     * 
     */
    @JsonProperty("eventCount")
    private EventCount eventCount;
    /**
     * Undefined
     * 
     */
    @JsonProperty("objectCounts")
    private ObjectCounts objectCounts;
    /**
     * Undefined
     * 
     */
    @JsonProperty("userInvitations")
    private UserInvitations userInvitations;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 5547381438970924467L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DataSummary() {
    }

    /**
     * 
     * @param source
     */
    public DataSummary(DataSummary source) {
        super();
        this.activeUsers = source.activeUsers;
        this.dataValueCount = source.dataValueCount;
        this.eventCount = source.eventCount;
        this.objectCounts = source.objectCounts;
        this.userInvitations = source.userInvitations;
    }

    /**
     * 
     * @param userInvitations
     * @param dataValueCount
     * @param objectCounts
     * @param activeUsers
     * @param eventCount
     */
    public DataSummary(ActiveUsers activeUsers, DataValueCount dataValueCount, EventCount eventCount, ObjectCounts objectCounts, UserInvitations userInvitations) {
        super();
        this.activeUsers = activeUsers;
        this.dataValueCount = dataValueCount;
        this.eventCount = eventCount;
        this.objectCounts = objectCounts;
        this.userInvitations = userInvitations;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("activeUsers")
    public Optional<ActiveUsers> getActiveUsers() {
        return Optional.ofNullable(activeUsers);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("activeUsers")
    public void setActiveUsers(ActiveUsers activeUsers) {
        this.activeUsers = activeUsers;
    }

    public DataSummary withActiveUsers(ActiveUsers activeUsers) {
        this.activeUsers = activeUsers;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("dataValueCount")
    public Optional<DataValueCount> getDataValueCount() {
        return Optional.ofNullable(dataValueCount);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("dataValueCount")
    public void setDataValueCount(DataValueCount dataValueCount) {
        this.dataValueCount = dataValueCount;
    }

    public DataSummary withDataValueCount(DataValueCount dataValueCount) {
        this.dataValueCount = dataValueCount;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("eventCount")
    public Optional<EventCount> getEventCount() {
        return Optional.ofNullable(eventCount);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("eventCount")
    public void setEventCount(EventCount eventCount) {
        this.eventCount = eventCount;
    }

    public DataSummary withEventCount(EventCount eventCount) {
        this.eventCount = eventCount;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("objectCounts")
    public Optional<ObjectCounts> getObjectCounts() {
        return Optional.ofNullable(objectCounts);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("objectCounts")
    public void setObjectCounts(ObjectCounts objectCounts) {
        this.objectCounts = objectCounts;
    }

    public DataSummary withObjectCounts(ObjectCounts objectCounts) {
        this.objectCounts = objectCounts;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("userInvitations")
    public Optional<UserInvitations> getUserInvitations() {
        return Optional.ofNullable(userInvitations);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("userInvitations")
    public void setUserInvitations(UserInvitations userInvitations) {
        this.userInvitations = userInvitations;
    }

    public DataSummary withUserInvitations(UserInvitations userInvitations) {
        this.userInvitations = userInvitations;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public DataSummary withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "activeUsers":
                if (value instanceof ActiveUsers) {
                    setActiveUsers(((ActiveUsers) value));
                } else {
                    throw new IllegalArgumentException(("property \"activeUsers\" is of type \"org.hisp.dhis.api.model.v2_39_1.ActiveUsers\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataValueCount":
                if (value instanceof DataValueCount) {
                    setDataValueCount(((DataValueCount) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataValueCount\" is of type \"org.hisp.dhis.api.model.v2_39_1.DataValueCount\", but got "+ value.getClass().toString()));
                }
                return true;
            case "eventCount":
                if (value instanceof EventCount) {
                    setEventCount(((EventCount) value));
                } else {
                    throw new IllegalArgumentException(("property \"eventCount\" is of type \"org.hisp.dhis.api.model.v2_39_1.EventCount\", but got "+ value.getClass().toString()));
                }
                return true;
            case "objectCounts":
                if (value instanceof ObjectCounts) {
                    setObjectCounts(((ObjectCounts) value));
                } else {
                    throw new IllegalArgumentException(("property \"objectCounts\" is of type \"org.hisp.dhis.api.model.v2_39_1.ObjectCounts\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userInvitations":
                if (value instanceof UserInvitations) {
                    setUserInvitations(((UserInvitations) value));
                } else {
                    throw new IllegalArgumentException(("property \"userInvitations\" is of type \"org.hisp.dhis.api.model.v2_39_1.UserInvitations\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "activeUsers":
                return getActiveUsers();
            case "dataValueCount":
                return getDataValueCount();
            case "eventCount":
                return getEventCount();
            case "objectCounts":
                return getObjectCounts();
            case "userInvitations":
                return getUserInvitations();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, DataSummary.NOT_FOUND_VALUE);
        if (DataSummary.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public DataSummary with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DataSummary.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("activeUsers");
        sb.append('=');
        sb.append(((this.activeUsers == null)?"<null>":this.activeUsers));
        sb.append(',');
        sb.append("dataValueCount");
        sb.append('=');
        sb.append(((this.dataValueCount == null)?"<null>":this.dataValueCount));
        sb.append(',');
        sb.append("eventCount");
        sb.append('=');
        sb.append(((this.eventCount == null)?"<null>":this.eventCount));
        sb.append(',');
        sb.append("objectCounts");
        sb.append('=');
        sb.append(((this.objectCounts == null)?"<null>":this.objectCounts));
        sb.append(',');
        sb.append("userInvitations");
        sb.append('=');
        sb.append(((this.userInvitations == null)?"<null>":this.userInvitations));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.userInvitations == null)? 0 :this.userInvitations.hashCode()));
        result = ((result* 31)+((this.dataValueCount == null)? 0 :this.dataValueCount.hashCode()));
        result = ((result* 31)+((this.objectCounts == null)? 0 :this.objectCounts.hashCode()));
        result = ((result* 31)+((this.activeUsers == null)? 0 :this.activeUsers.hashCode()));
        result = ((result* 31)+((this.eventCount == null)? 0 :this.eventCount.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof DataSummary) == false) {
            return false;
        }
        DataSummary rhs = ((DataSummary) other);
        return (((((((this.userInvitations == rhs.userInvitations)||((this.userInvitations!= null)&&this.userInvitations.equals(rhs.userInvitations)))&&((this.dataValueCount == rhs.dataValueCount)||((this.dataValueCount!= null)&&this.dataValueCount.equals(rhs.dataValueCount))))&&((this.objectCounts == rhs.objectCounts)||((this.objectCounts!= null)&&this.objectCounts.equals(rhs.objectCounts))))&&((this.activeUsers == rhs.activeUsers)||((this.activeUsers!= null)&&this.activeUsers.equals(rhs.activeUsers))))&&((this.eventCount == rhs.eventCount)||((this.eventCount!= null)&&this.eventCount.equals(rhs.eventCount))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))));
    }

}
