
package org.hisp.dhis.api.model.v2_39_1;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "closingDate",
    "openingDate",
    "period"
})
@Generated("jsonschema2pojo")
public class DataInputPeriod implements Serializable
{

    @JsonProperty("closingDate")
    private Date closingDate;
    @JsonProperty("openingDate")
    private Date openingDate;
    @JsonProperty("period")
    private Period period;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -4539766940160382252L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DataInputPeriod() {
    }

    /**
     * 
     * @param source
     */
    public DataInputPeriod(DataInputPeriod source) {
        super();
        this.closingDate = source.closingDate;
        this.openingDate = source.openingDate;
        this.period = source.period;
    }

    /**
     * 
     * @param period
     * @param closingDate
     * @param openingDate
     */
    public DataInputPeriod(Date closingDate, Date openingDate, Period period) {
        super();
        this.closingDate = closingDate;
        this.openingDate = openingDate;
        this.period = period;
    }

    @JsonProperty("closingDate")
    public Optional<Date> getClosingDate() {
        return Optional.ofNullable(closingDate);
    }

    @JsonProperty("closingDate")
    public void setClosingDate(Date closingDate) {
        this.closingDate = closingDate;
    }

    public DataInputPeriod withClosingDate(Date closingDate) {
        this.closingDate = closingDate;
        return this;
    }

    @JsonProperty("openingDate")
    public Optional<Date> getOpeningDate() {
        return Optional.ofNullable(openingDate);
    }

    @JsonProperty("openingDate")
    public void setOpeningDate(Date openingDate) {
        this.openingDate = openingDate;
    }

    public DataInputPeriod withOpeningDate(Date openingDate) {
        this.openingDate = openingDate;
        return this;
    }

    @JsonProperty("period")
    public Optional<Period> getPeriod() {
        return Optional.ofNullable(period);
    }

    @JsonProperty("period")
    public void setPeriod(Period period) {
        this.period = period;
    }

    public DataInputPeriod withPeriod(Period period) {
        this.period = period;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public DataInputPeriod withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "closingDate":
                if (value instanceof Date) {
                    setClosingDate(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"closingDate\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "openingDate":
                if (value instanceof Date) {
                    setOpeningDate(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"openingDate\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "period":
                if (value instanceof Period) {
                    setPeriod(((Period) value));
                } else {
                    throw new IllegalArgumentException(("property \"period\" is of type \"org.hisp.dhis.api.model.v2_39_1.Period\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "closingDate":
                return getClosingDate();
            case "openingDate":
                return getOpeningDate();
            case "period":
                return getPeriod();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, DataInputPeriod.NOT_FOUND_VALUE);
        if (DataInputPeriod.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public DataInputPeriod with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DataInputPeriod.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("closingDate");
        sb.append('=');
        sb.append(((this.closingDate == null)?"<null>":this.closingDate));
        sb.append(',');
        sb.append("openingDate");
        sb.append('=');
        sb.append(((this.openingDate == null)?"<null>":this.openingDate));
        sb.append(',');
        sb.append("period");
        sb.append('=');
        sb.append(((this.period == null)?"<null>":this.period));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.period == null)? 0 :this.period.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.closingDate == null)? 0 :this.closingDate.hashCode()));
        result = ((result* 31)+((this.openingDate == null)? 0 :this.openingDate.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof DataInputPeriod) == false) {
            return false;
        }
        DataInputPeriod rhs = ((DataInputPeriod) other);
        return (((((this.period == rhs.period)||((this.period!= null)&&this.period.equals(rhs.period)))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.closingDate == rhs.closingDate)||((this.closingDate!= null)&&this.closingDate.equals(rhs.closingDate))))&&((this.openingDate == rhs.openingDate)||((this.openingDate!= null)&&this.openingDate.equals(rhs.openingDate))));
    }

}
