
package org.hisp.dhis.api.model.v2_39_1;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "fullUpdateHourOfDay",
    "lastYears",
    "skipTableTypes"
})
@Generated("jsonschema2pojo")
public class ContinuousAnalyticsJobParameters implements Serializable
{

    @JsonProperty("fullUpdateHourOfDay")
    private Integer fullUpdateHourOfDay;
    @JsonProperty("lastYears")
    private Integer lastYears;
    @JsonProperty("skipTableTypes")
    private List<AnalyticsTableType> skipTableTypes = null;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -5869679474765151587L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ContinuousAnalyticsJobParameters() {
    }

    /**
     * 
     * @param source
     */
    public ContinuousAnalyticsJobParameters(ContinuousAnalyticsJobParameters source) {
        super();
        this.fullUpdateHourOfDay = source.fullUpdateHourOfDay;
        this.lastYears = source.lastYears;
        this.skipTableTypes = source.skipTableTypes;
    }

    /**
     * 
     * @param fullUpdateHourOfDay
     * @param lastYears
     * @param skipTableTypes
     */
    public ContinuousAnalyticsJobParameters(Integer fullUpdateHourOfDay, Integer lastYears, List<AnalyticsTableType> skipTableTypes) {
        super();
        this.fullUpdateHourOfDay = fullUpdateHourOfDay;
        this.lastYears = lastYears;
        this.skipTableTypes = skipTableTypes;
    }

    @JsonProperty("fullUpdateHourOfDay")
    public Optional<Integer> getFullUpdateHourOfDay() {
        return Optional.ofNullable(fullUpdateHourOfDay);
    }

    @JsonProperty("fullUpdateHourOfDay")
    public void setFullUpdateHourOfDay(Integer fullUpdateHourOfDay) {
        this.fullUpdateHourOfDay = fullUpdateHourOfDay;
    }

    public ContinuousAnalyticsJobParameters withFullUpdateHourOfDay(Integer fullUpdateHourOfDay) {
        this.fullUpdateHourOfDay = fullUpdateHourOfDay;
        return this;
    }

    @JsonProperty("lastYears")
    public Optional<Integer> getLastYears() {
        return Optional.ofNullable(lastYears);
    }

    @JsonProperty("lastYears")
    public void setLastYears(Integer lastYears) {
        this.lastYears = lastYears;
    }

    public ContinuousAnalyticsJobParameters withLastYears(Integer lastYears) {
        this.lastYears = lastYears;
        return this;
    }

    @JsonProperty("skipTableTypes")
    public Optional<List<AnalyticsTableType>> getSkipTableTypes() {
        return Optional.ofNullable(skipTableTypes);
    }

    @JsonProperty("skipTableTypes")
    public void setSkipTableTypes(List<AnalyticsTableType> skipTableTypes) {
        this.skipTableTypes = skipTableTypes;
    }

    public ContinuousAnalyticsJobParameters withSkipTableTypes(List<AnalyticsTableType> skipTableTypes) {
        this.skipTableTypes = skipTableTypes;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ContinuousAnalyticsJobParameters withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "fullUpdateHourOfDay":
                if (value instanceof Integer) {
                    setFullUpdateHourOfDay(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"fullUpdateHourOfDay\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastYears":
                if (value instanceof Integer) {
                    setLastYears(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastYears\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "skipTableTypes":
                if (value instanceof List) {
                    setSkipTableTypes(((List<AnalyticsTableType> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"skipTableTypes\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.AnalyticsTableType>\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "fullUpdateHourOfDay":
                return getFullUpdateHourOfDay();
            case "lastYears":
                return getLastYears();
            case "skipTableTypes":
                return getSkipTableTypes();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ContinuousAnalyticsJobParameters.NOT_FOUND_VALUE);
        if (ContinuousAnalyticsJobParameters.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ContinuousAnalyticsJobParameters with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ContinuousAnalyticsJobParameters.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("fullUpdateHourOfDay");
        sb.append('=');
        sb.append(((this.fullUpdateHourOfDay == null)?"<null>":this.fullUpdateHourOfDay));
        sb.append(',');
        sb.append("lastYears");
        sb.append('=');
        sb.append(((this.lastYears == null)?"<null>":this.lastYears));
        sb.append(',');
        sb.append("skipTableTypes");
        sb.append('=');
        sb.append(((this.skipTableTypes == null)?"<null>":this.skipTableTypes));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.fullUpdateHourOfDay == null)? 0 :this.fullUpdateHourOfDay.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.lastYears == null)? 0 :this.lastYears.hashCode()));
        result = ((result* 31)+((this.skipTableTypes == null)? 0 :this.skipTableTypes.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ContinuousAnalyticsJobParameters) == false) {
            return false;
        }
        ContinuousAnalyticsJobParameters rhs = ((ContinuousAnalyticsJobParameters) other);
        return (((((this.fullUpdateHourOfDay == rhs.fullUpdateHourOfDay)||((this.fullUpdateHourOfDay!= null)&&this.fullUpdateHourOfDay.equals(rhs.fullUpdateHourOfDay)))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.lastYears == rhs.lastYears)||((this.lastYears!= null)&&this.lastYears.equals(rhs.lastYears))))&&((this.skipTableTypes == rhs.skipTableTypes)||((this.skipTableTypes!= null)&&this.skipTableTypes.equals(rhs.skipTableTypes))));
    }

}
