
package org.hisp.dhis.api.model.v2_39_1;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "burden",
    "cap",
    "regions",
    "total"
})
@Generated("jsonschema2pojo")
public class CacheInfo implements Serializable
{

    @JsonProperty("burden")
    private CacheBurdenInfo burden;
    @JsonProperty("cap")
    private CacheCapInfo cap;
    @JsonProperty("regions")
    private List<CacheGroupInfo> regions = null;
    @JsonProperty("total")
    private CacheGroupInfo total;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 2409880193453016076L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public CacheInfo() {
    }

    /**
     * 
     * @param source
     */
    public CacheInfo(CacheInfo source) {
        super();
        this.burden = source.burden;
        this.cap = source.cap;
        this.regions = source.regions;
        this.total = source.total;
    }

    /**
     * 
     * @param total
     * @param cap
     * @param regions
     * @param burden
     */
    public CacheInfo(CacheBurdenInfo burden, CacheCapInfo cap, List<CacheGroupInfo> regions, CacheGroupInfo total) {
        super();
        this.burden = burden;
        this.cap = cap;
        this.regions = regions;
        this.total = total;
    }

    @JsonProperty("burden")
    public Optional<CacheBurdenInfo> getBurden() {
        return Optional.ofNullable(burden);
    }

    @JsonProperty("burden")
    public void setBurden(CacheBurdenInfo burden) {
        this.burden = burden;
    }

    public CacheInfo withBurden(CacheBurdenInfo burden) {
        this.burden = burden;
        return this;
    }

    @JsonProperty("cap")
    public Optional<CacheCapInfo> getCap() {
        return Optional.ofNullable(cap);
    }

    @JsonProperty("cap")
    public void setCap(CacheCapInfo cap) {
        this.cap = cap;
    }

    public CacheInfo withCap(CacheCapInfo cap) {
        this.cap = cap;
        return this;
    }

    @JsonProperty("regions")
    public Optional<List<CacheGroupInfo>> getRegions() {
        return Optional.ofNullable(regions);
    }

    @JsonProperty("regions")
    public void setRegions(List<CacheGroupInfo> regions) {
        this.regions = regions;
    }

    public CacheInfo withRegions(List<CacheGroupInfo> regions) {
        this.regions = regions;
        return this;
    }

    @JsonProperty("total")
    public Optional<CacheGroupInfo> getTotal() {
        return Optional.ofNullable(total);
    }

    @JsonProperty("total")
    public void setTotal(CacheGroupInfo total) {
        this.total = total;
    }

    public CacheInfo withTotal(CacheGroupInfo total) {
        this.total = total;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public CacheInfo withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "burden":
                if (value instanceof CacheBurdenInfo) {
                    setBurden(((CacheBurdenInfo) value));
                } else {
                    throw new IllegalArgumentException(("property \"burden\" is of type \"org.hisp.dhis.api.model.v2_39_1.CacheBurdenInfo\", but got "+ value.getClass().toString()));
                }
                return true;
            case "cap":
                if (value instanceof CacheCapInfo) {
                    setCap(((CacheCapInfo) value));
                } else {
                    throw new IllegalArgumentException(("property \"cap\" is of type \"org.hisp.dhis.api.model.v2_39_1.CacheCapInfo\", but got "+ value.getClass().toString()));
                }
                return true;
            case "regions":
                if (value instanceof List) {
                    setRegions(((List<CacheGroupInfo> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"regions\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.CacheGroupInfo>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "total":
                if (value instanceof CacheGroupInfo) {
                    setTotal(((CacheGroupInfo) value));
                } else {
                    throw new IllegalArgumentException(("property \"total\" is of type \"org.hisp.dhis.api.model.v2_39_1.CacheGroupInfo\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "burden":
                return getBurden();
            case "cap":
                return getCap();
            case "regions":
                return getRegions();
            case "total":
                return getTotal();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, CacheInfo.NOT_FOUND_VALUE);
        if (CacheInfo.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public CacheInfo with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CacheInfo.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("burden");
        sb.append('=');
        sb.append(((this.burden == null)?"<null>":this.burden));
        sb.append(',');
        sb.append("cap");
        sb.append('=');
        sb.append(((this.cap == null)?"<null>":this.cap));
        sb.append(',');
        sb.append("regions");
        sb.append('=');
        sb.append(((this.regions == null)?"<null>":this.regions));
        sb.append(',');
        sb.append("total");
        sb.append('=');
        sb.append(((this.total == null)?"<null>":this.total));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.total == null)? 0 :this.total.hashCode()));
        result = ((result* 31)+((this.cap == null)? 0 :this.cap.hashCode()));
        result = ((result* 31)+((this.regions == null)? 0 :this.regions.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.burden == null)? 0 :this.burden.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof CacheInfo) == false) {
            return false;
        }
        CacheInfo rhs = ((CacheInfo) other);
        return ((((((this.total == rhs.total)||((this.total!= null)&&this.total.equals(rhs.total)))&&((this.cap == rhs.cap)||((this.cap!= null)&&this.cap.equals(rhs.cap))))&&((this.regions == rhs.regions)||((this.regions!= null)&&this.regions.equals(rhs.regions))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.burden == rhs.burden)||((this.burden!= null)&&this.burden.equals(rhs.burden))));
    }

}
