
package org.hisp.dhis.api.model.v2_38_1;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "authentication",
    "messageType",
    "trackerImportParams",
    "uid"
})
@Generated("jsonschema2pojo")
public class TrackerMessage implements Serializable
{

    @JsonProperty("authentication")
    private String authentication;
    @JsonProperty("messageType")
    private org.hisp.dhis.api.model.v2_38_1.Audit.MessageType messageType;
    @JsonProperty("trackerImportParams")
    private TrackerImportParams trackerImportParams;
    @JsonProperty("uid")
    private String uid;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 3812681315458075815L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TrackerMessage() {
    }

    /**
     * 
     * @param source
     */
    public TrackerMessage(TrackerMessage source) {
        super();
        this.authentication = source.authentication;
        this.messageType = source.messageType;
        this.trackerImportParams = source.trackerImportParams;
        this.uid = source.uid;
    }

    /**
     * 
     * @param uid
     * @param messageType
     * @param trackerImportParams
     * @param authentication
     */
    public TrackerMessage(String authentication, org.hisp.dhis.api.model.v2_38_1.Audit.MessageType messageType, TrackerImportParams trackerImportParams, String uid) {
        super();
        this.authentication = authentication;
        this.messageType = messageType;
        this.trackerImportParams = trackerImportParams;
        this.uid = uid;
    }

    @JsonProperty("authentication")
    public Optional<String> getAuthentication() {
        return Optional.ofNullable(authentication);
    }

    @JsonProperty("authentication")
    public void setAuthentication(String authentication) {
        this.authentication = authentication;
    }

    public TrackerMessage withAuthentication(String authentication) {
        this.authentication = authentication;
        return this;
    }

    @JsonProperty("messageType")
    public Optional<org.hisp.dhis.api.model.v2_38_1.Audit.MessageType> getMessageType() {
        return Optional.ofNullable(messageType);
    }

    @JsonProperty("messageType")
    public void setMessageType(org.hisp.dhis.api.model.v2_38_1.Audit.MessageType messageType) {
        this.messageType = messageType;
    }

    public TrackerMessage withMessageType(org.hisp.dhis.api.model.v2_38_1.Audit.MessageType messageType) {
        this.messageType = messageType;
        return this;
    }

    @JsonProperty("trackerImportParams")
    public Optional<TrackerImportParams> getTrackerImportParams() {
        return Optional.ofNullable(trackerImportParams);
    }

    @JsonProperty("trackerImportParams")
    public void setTrackerImportParams(TrackerImportParams trackerImportParams) {
        this.trackerImportParams = trackerImportParams;
    }

    public TrackerMessage withTrackerImportParams(TrackerImportParams trackerImportParams) {
        this.trackerImportParams = trackerImportParams;
        return this;
    }

    @JsonProperty("uid")
    public Optional<String> getUid() {
        return Optional.ofNullable(uid);
    }

    @JsonProperty("uid")
    public void setUid(String uid) {
        this.uid = uid;
    }

    public TrackerMessage withUid(String uid) {
        this.uid = uid;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public TrackerMessage withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "authentication":
                if (value instanceof String) {
                    setAuthentication(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"authentication\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "messageType":
                if (value instanceof org.hisp.dhis.api.model.v2_38_1.Audit.MessageType) {
                    setMessageType(((org.hisp.dhis.api.model.v2_38_1.Audit.MessageType) value));
                } else {
                    throw new IllegalArgumentException(("property \"messageType\" is of type \"org.hisp.dhis.api.model.v2_38_1.Audit.MessageType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "trackerImportParams":
                if (value instanceof TrackerImportParams) {
                    setTrackerImportParams(((TrackerImportParams) value));
                } else {
                    throw new IllegalArgumentException(("property \"trackerImportParams\" is of type \"org.hisp.dhis.api.model.v2_38_1.TrackerImportParams\", but got "+ value.getClass().toString()));
                }
                return true;
            case "uid":
                if (value instanceof String) {
                    setUid(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"uid\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "authentication":
                return getAuthentication();
            case "messageType":
                return getMessageType();
            case "trackerImportParams":
                return getTrackerImportParams();
            case "uid":
                return getUid();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, TrackerMessage.NOT_FOUND_VALUE);
        if (TrackerMessage.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public TrackerMessage with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TrackerMessage.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("authentication");
        sb.append('=');
        sb.append(((this.authentication == null)?"<null>":this.authentication));
        sb.append(',');
        sb.append("messageType");
        sb.append('=');
        sb.append(((this.messageType == null)?"<null>":this.messageType));
        sb.append(',');
        sb.append("trackerImportParams");
        sb.append('=');
        sb.append(((this.trackerImportParams == null)?"<null>":this.trackerImportParams));
        sb.append(',');
        sb.append("uid");
        sb.append('=');
        sb.append(((this.uid == null)?"<null>":this.uid));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.uid == null)? 0 :this.uid.hashCode()));
        result = ((result* 31)+((this.messageType == null)? 0 :this.messageType.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.trackerImportParams == null)? 0 :this.trackerImportParams.hashCode()));
        result = ((result* 31)+((this.authentication == null)? 0 :this.authentication.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TrackerMessage) == false) {
            return false;
        }
        TrackerMessage rhs = ((TrackerMessage) other);
        return ((((((this.uid == rhs.uid)||((this.uid!= null)&&this.uid.equals(rhs.uid)))&&((this.messageType == rhs.messageType)||((this.messageType!= null)&&this.messageType.equals(rhs.messageType))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.trackerImportParams == rhs.trackerImportParams)||((this.trackerImportParams!= null)&&this.trackerImportParams.equals(rhs.trackerImportParams))))&&((this.authentication == rhs.authentication)||((this.authentication!= null)&&this.authentication.equals(rhs.authentication))));
    }

}
