
package org.hisp.dhis.api.model.v2_38_1;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "additions",
    "deletions",
    "identifiableObjects"
})
@Generated("jsonschema2pojo")
public class IdentifiableObjects implements Serializable
{

    @JsonProperty("additions")
    private List<BaseIdentifiableObject> additions = null;
    @JsonProperty("deletions")
    private List<BaseIdentifiableObject> deletions = null;
    @JsonProperty("identifiableObjects")
    private List<BaseIdentifiableObject> identifiableObjects = null;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -3762427652445153641L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public IdentifiableObjects() {
    }

    /**
     * 
     * @param source
     */
    public IdentifiableObjects(IdentifiableObjects source) {
        super();
        this.additions = source.additions;
        this.deletions = source.deletions;
        this.identifiableObjects = source.identifiableObjects;
    }

    /**
     * 
     * @param identifiableObjects
     * @param additions
     * @param deletions
     */
    public IdentifiableObjects(List<BaseIdentifiableObject> additions, List<BaseIdentifiableObject> deletions, List<BaseIdentifiableObject> identifiableObjects) {
        super();
        this.additions = additions;
        this.deletions = deletions;
        this.identifiableObjects = identifiableObjects;
    }

    @JsonProperty("additions")
    public Optional<List<BaseIdentifiableObject>> getAdditions() {
        return Optional.ofNullable(additions);
    }

    @JsonProperty("additions")
    public void setAdditions(List<BaseIdentifiableObject> additions) {
        this.additions = additions;
    }

    public IdentifiableObjects withAdditions(List<BaseIdentifiableObject> additions) {
        this.additions = additions;
        return this;
    }

    @JsonProperty("deletions")
    public Optional<List<BaseIdentifiableObject>> getDeletions() {
        return Optional.ofNullable(deletions);
    }

    @JsonProperty("deletions")
    public void setDeletions(List<BaseIdentifiableObject> deletions) {
        this.deletions = deletions;
    }

    public IdentifiableObjects withDeletions(List<BaseIdentifiableObject> deletions) {
        this.deletions = deletions;
        return this;
    }

    @JsonProperty("identifiableObjects")
    public Optional<List<BaseIdentifiableObject>> getIdentifiableObjects() {
        return Optional.ofNullable(identifiableObjects);
    }

    @JsonProperty("identifiableObjects")
    public void setIdentifiableObjects(List<BaseIdentifiableObject> identifiableObjects) {
        this.identifiableObjects = identifiableObjects;
    }

    public IdentifiableObjects withIdentifiableObjects(List<BaseIdentifiableObject> identifiableObjects) {
        this.identifiableObjects = identifiableObjects;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public IdentifiableObjects withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "additions":
                if (value instanceof List) {
                    setAdditions(((List<BaseIdentifiableObject> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"additions\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.BaseIdentifiableObject>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "deletions":
                if (value instanceof List) {
                    setDeletions(((List<BaseIdentifiableObject> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"deletions\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.BaseIdentifiableObject>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "identifiableObjects":
                if (value instanceof List) {
                    setIdentifiableObjects(((List<BaseIdentifiableObject> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"identifiableObjects\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.BaseIdentifiableObject>\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "additions":
                return getAdditions();
            case "deletions":
                return getDeletions();
            case "identifiableObjects":
                return getIdentifiableObjects();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, IdentifiableObjects.NOT_FOUND_VALUE);
        if (IdentifiableObjects.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public IdentifiableObjects with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(IdentifiableObjects.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("additions");
        sb.append('=');
        sb.append(((this.additions == null)?"<null>":this.additions));
        sb.append(',');
        sb.append("deletions");
        sb.append('=');
        sb.append(((this.deletions == null)?"<null>":this.deletions));
        sb.append(',');
        sb.append("identifiableObjects");
        sb.append('=');
        sb.append(((this.identifiableObjects == null)?"<null>":this.identifiableObjects));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.identifiableObjects == null)? 0 :this.identifiableObjects.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.additions == null)? 0 :this.additions.hashCode()));
        result = ((result* 31)+((this.deletions == null)? 0 :this.deletions.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof IdentifiableObjects) == false) {
            return false;
        }
        IdentifiableObjects rhs = ((IdentifiableObjects) other);
        return (((((this.identifiableObjects == rhs.identifiableObjects)||((this.identifiableObjects!= null)&&this.identifiableObjects.equals(rhs.identifiableObjects)))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.additions == rhs.additions)||((this.additions!= null)&&this.additions.equals(rhs.additions))))&&((this.deletions == rhs.deletions)||((this.deletions!= null)&&this.deletions.equals(rhs.deletions))));
    }

}
