
package org.hisp.dhis.api.model.v2_38_1;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "activities",
    "appState",
    "appStorageSource",
    "appType",
    "app_hub_id",
    "authorities",
    "baseUrl",
    "bundled",
    "core_app",
    "default_locale",
    "description",
    "developer",
    "folderName",
    "icons",
    "installs_allowed_from",
    "key",
    "launchUrl",
    "launch_path",
    "name",
    "settings",
    "short_name",
    "version"
})
@Generated("jsonschema2pojo")
public class App implements Serializable
{

    @JsonProperty("activities")
    private AppActivities activities;
    @JsonProperty("appState")
    private App.AppStatus appState;
    @JsonProperty("appStorageSource")
    private App.AppStorageSource appStorageSource;
    @JsonProperty("appType")
    private App.AppType appType;
    @JsonProperty("app_hub_id")
    private String appHubId;
    @JsonProperty("authorities")
    private List<String> authorities = null;
    @JsonProperty("baseUrl")
    private String baseUrl;
    @JsonProperty("bundled")
    private Boolean bundled;
    @JsonProperty("core_app")
    private Boolean coreApp;
    @JsonProperty("default_locale")
    private String defaultLocale;
    @JsonProperty("description")
    private String description;
    @JsonProperty("developer")
    private AppDeveloper developer;
    @JsonProperty("folderName")
    private String folderName;
    @JsonProperty("icons")
    private AppIcons icons;
    @JsonProperty("installs_allowed_from")
    private List<String> installsAllowedFrom = null;
    @JsonProperty("key")
    private String key;
    @JsonProperty("launchUrl")
    private String launchUrl;
    @JsonProperty("launch_path")
    private String launchPath;
    @JsonProperty("name")
    private String name;
    @JsonProperty("settings")
    private AppSettings settings;
    @JsonProperty("short_name")
    private String shortName;
    @JsonProperty("version")
    private String version;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 1194350016394177214L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public App() {
    }

    /**
     * 
     * @param source
     */
    public App(App source) {
        super();
        this.activities = source.activities;
        this.appState = source.appState;
        this.appStorageSource = source.appStorageSource;
        this.appType = source.appType;
        this.appHubId = source.appHubId;
        this.authorities = source.authorities;
        this.baseUrl = source.baseUrl;
        this.bundled = source.bundled;
        this.coreApp = source.coreApp;
        this.defaultLocale = source.defaultLocale;
        this.description = source.description;
        this.developer = source.developer;
        this.folderName = source.folderName;
        this.icons = source.icons;
        this.installsAllowedFrom = source.installsAllowedFrom;
        this.key = source.key;
        this.launchUrl = source.launchUrl;
        this.launchPath = source.launchPath;
        this.name = source.name;
        this.settings = source.settings;
        this.shortName = source.shortName;
        this.version = source.version;
    }

    /**
     * 
     * @param appStorageSource
     * @param settings
     * @param appState
     * @param bundled
     * @param description
     * @param coreApp
     * @param installsAllowedFrom
     * @param icons
     * @param version
     * @param authorities
     * @param defaultLocale
     * @param baseUrl
     * @param activities
     * @param appType
     * @param launchPath
     * @param appHubId
     * @param name
     * @param developer
     * @param folderName
     * @param shortName
     * @param key
     * @param launchUrl
     */
    public App(AppActivities activities, App.AppStatus appState, App.AppStorageSource appStorageSource, App.AppType appType, String appHubId, List<String> authorities, String baseUrl, Boolean bundled, Boolean coreApp, String defaultLocale, String description, AppDeveloper developer, String folderName, AppIcons icons, List<String> installsAllowedFrom, String key, String launchUrl, String launchPath, String name, AppSettings settings, String shortName, String version) {
        super();
        this.activities = activities;
        this.appState = appState;
        this.appStorageSource = appStorageSource;
        this.appType = appType;
        this.appHubId = appHubId;
        this.authorities = authorities;
        this.baseUrl = baseUrl;
        this.bundled = bundled;
        this.coreApp = coreApp;
        this.defaultLocale = defaultLocale;
        this.description = description;
        this.developer = developer;
        this.folderName = folderName;
        this.icons = icons;
        this.installsAllowedFrom = installsAllowedFrom;
        this.key = key;
        this.launchUrl = launchUrl;
        this.launchPath = launchPath;
        this.name = name;
        this.settings = settings;
        this.shortName = shortName;
        this.version = version;
    }

    @JsonProperty("activities")
    public Optional<AppActivities> getActivities() {
        return Optional.ofNullable(activities);
    }

    @JsonProperty("activities")
    public void setActivities(AppActivities activities) {
        this.activities = activities;
    }

    public App withActivities(AppActivities activities) {
        this.activities = activities;
        return this;
    }

    @JsonProperty("appState")
    public Optional<App.AppStatus> getAppState() {
        return Optional.ofNullable(appState);
    }

    @JsonProperty("appState")
    public void setAppState(App.AppStatus appState) {
        this.appState = appState;
    }

    public App withAppState(App.AppStatus appState) {
        this.appState = appState;
        return this;
    }

    @JsonProperty("appStorageSource")
    public Optional<App.AppStorageSource> getAppStorageSource() {
        return Optional.ofNullable(appStorageSource);
    }

    @JsonProperty("appStorageSource")
    public void setAppStorageSource(App.AppStorageSource appStorageSource) {
        this.appStorageSource = appStorageSource;
    }

    public App withAppStorageSource(App.AppStorageSource appStorageSource) {
        this.appStorageSource = appStorageSource;
        return this;
    }

    @JsonProperty("appType")
    public Optional<App.AppType> getAppType() {
        return Optional.ofNullable(appType);
    }

    @JsonProperty("appType")
    public void setAppType(App.AppType appType) {
        this.appType = appType;
    }

    public App withAppType(App.AppType appType) {
        this.appType = appType;
        return this;
    }

    @JsonProperty("app_hub_id")
    public Optional<String> getAppHubId() {
        return Optional.ofNullable(appHubId);
    }

    @JsonProperty("app_hub_id")
    public void setAppHubId(String appHubId) {
        this.appHubId = appHubId;
    }

    public App withAppHubId(String appHubId) {
        this.appHubId = appHubId;
        return this;
    }

    @JsonProperty("authorities")
    public Optional<List<String>> getAuthorities() {
        return Optional.ofNullable(authorities);
    }

    @JsonProperty("authorities")
    public void setAuthorities(List<String> authorities) {
        this.authorities = authorities;
    }

    public App withAuthorities(List<String> authorities) {
        this.authorities = authorities;
        return this;
    }

    @JsonProperty("baseUrl")
    public Optional<String> getBaseUrl() {
        return Optional.ofNullable(baseUrl);
    }

    @JsonProperty("baseUrl")
    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public App withBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    @JsonProperty("bundled")
    public Optional<Boolean> getBundled() {
        return Optional.ofNullable(bundled);
    }

    @JsonProperty("bundled")
    public void setBundled(Boolean bundled) {
        this.bundled = bundled;
    }

    public App withBundled(Boolean bundled) {
        this.bundled = bundled;
        return this;
    }

    @JsonProperty("core_app")
    public Optional<Boolean> getCoreApp() {
        return Optional.ofNullable(coreApp);
    }

    @JsonProperty("core_app")
    public void setCoreApp(Boolean coreApp) {
        this.coreApp = coreApp;
    }

    public App withCoreApp(Boolean coreApp) {
        this.coreApp = coreApp;
        return this;
    }

    @JsonProperty("default_locale")
    public Optional<String> getDefaultLocale() {
        return Optional.ofNullable(defaultLocale);
    }

    @JsonProperty("default_locale")
    public void setDefaultLocale(String defaultLocale) {
        this.defaultLocale = defaultLocale;
    }

    public App withDefaultLocale(String defaultLocale) {
        this.defaultLocale = defaultLocale;
        return this;
    }

    @JsonProperty("description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    public App withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty("developer")
    public Optional<AppDeveloper> getDeveloper() {
        return Optional.ofNullable(developer);
    }

    @JsonProperty("developer")
    public void setDeveloper(AppDeveloper developer) {
        this.developer = developer;
    }

    public App withDeveloper(AppDeveloper developer) {
        this.developer = developer;
        return this;
    }

    @JsonProperty("folderName")
    public Optional<String> getFolderName() {
        return Optional.ofNullable(folderName);
    }

    @JsonProperty("folderName")
    public void setFolderName(String folderName) {
        this.folderName = folderName;
    }

    public App withFolderName(String folderName) {
        this.folderName = folderName;
        return this;
    }

    @JsonProperty("icons")
    public Optional<AppIcons> getIcons() {
        return Optional.ofNullable(icons);
    }

    @JsonProperty("icons")
    public void setIcons(AppIcons icons) {
        this.icons = icons;
    }

    public App withIcons(AppIcons icons) {
        this.icons = icons;
        return this;
    }

    @JsonProperty("installs_allowed_from")
    public Optional<List<String>> getInstallsAllowedFrom() {
        return Optional.ofNullable(installsAllowedFrom);
    }

    @JsonProperty("installs_allowed_from")
    public void setInstallsAllowedFrom(List<String> installsAllowedFrom) {
        this.installsAllowedFrom = installsAllowedFrom;
    }

    public App withInstallsAllowedFrom(List<String> installsAllowedFrom) {
        this.installsAllowedFrom = installsAllowedFrom;
        return this;
    }

    @JsonProperty("key")
    public Optional<String> getKey() {
        return Optional.ofNullable(key);
    }

    @JsonProperty("key")
    public void setKey(String key) {
        this.key = key;
    }

    public App withKey(String key) {
        this.key = key;
        return this;
    }

    @JsonProperty("launchUrl")
    public Optional<String> getLaunchUrl() {
        return Optional.ofNullable(launchUrl);
    }

    @JsonProperty("launchUrl")
    public void setLaunchUrl(String launchUrl) {
        this.launchUrl = launchUrl;
    }

    public App withLaunchUrl(String launchUrl) {
        this.launchUrl = launchUrl;
        return this;
    }

    @JsonProperty("launch_path")
    public Optional<String> getLaunchPath() {
        return Optional.ofNullable(launchPath);
    }

    @JsonProperty("launch_path")
    public void setLaunchPath(String launchPath) {
        this.launchPath = launchPath;
    }

    public App withLaunchPath(String launchPath) {
        this.launchPath = launchPath;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public App withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("settings")
    public Optional<AppSettings> getSettings() {
        return Optional.ofNullable(settings);
    }

    @JsonProperty("settings")
    public void setSettings(AppSettings settings) {
        this.settings = settings;
    }

    public App withSettings(AppSettings settings) {
        this.settings = settings;
        return this;
    }

    @JsonProperty("short_name")
    public Optional<String> getShortName() {
        return Optional.ofNullable(shortName);
    }

    @JsonProperty("short_name")
    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public App withShortName(String shortName) {
        this.shortName = shortName;
        return this;
    }

    @JsonProperty("version")
    public Optional<String> getVersion() {
        return Optional.ofNullable(version);
    }

    @JsonProperty("version")
    public void setVersion(String version) {
        this.version = version;
    }

    public App withVersion(String version) {
        this.version = version;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public App withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "activities":
                if (value instanceof AppActivities) {
                    setActivities(((AppActivities) value));
                } else {
                    throw new IllegalArgumentException(("property \"activities\" is of type \"org.hisp.dhis.api.model.v2_38_1.AppActivities\", but got "+ value.getClass().toString()));
                }
                return true;
            case "appState":
                if (value instanceof App.AppStatus) {
                    setAppState(((App.AppStatus) value));
                } else {
                    throw new IllegalArgumentException(("property \"appState\" is of type \"org.hisp.dhis.api.model.v2_38_1.App.AppStatus\", but got "+ value.getClass().toString()));
                }
                return true;
            case "appStorageSource":
                if (value instanceof App.AppStorageSource) {
                    setAppStorageSource(((App.AppStorageSource) value));
                } else {
                    throw new IllegalArgumentException(("property \"appStorageSource\" is of type \"org.hisp.dhis.api.model.v2_38_1.App.AppStorageSource\", but got "+ value.getClass().toString()));
                }
                return true;
            case "appType":
                if (value instanceof App.AppType) {
                    setAppType(((App.AppType) value));
                } else {
                    throw new IllegalArgumentException(("property \"appType\" is of type \"org.hisp.dhis.api.model.v2_38_1.App.AppType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "app_hub_id":
                if (value instanceof String) {
                    setAppHubId(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"app_hub_id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "authorities":
                if (value instanceof List) {
                    setAuthorities(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"authorities\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "baseUrl":
                if (value instanceof String) {
                    setBaseUrl(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"baseUrl\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "bundled":
                if (value instanceof Boolean) {
                    setBundled(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"bundled\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "core_app":
                if (value instanceof Boolean) {
                    setCoreApp(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"core_app\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "default_locale":
                if (value instanceof String) {
                    setDefaultLocale(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"default_locale\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "description":
                if (value instanceof String) {
                    setDescription(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"description\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "developer":
                if (value instanceof AppDeveloper) {
                    setDeveloper(((AppDeveloper) value));
                } else {
                    throw new IllegalArgumentException(("property \"developer\" is of type \"org.hisp.dhis.api.model.v2_38_1.AppDeveloper\", but got "+ value.getClass().toString()));
                }
                return true;
            case "folderName":
                if (value instanceof String) {
                    setFolderName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"folderName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "icons":
                if (value instanceof AppIcons) {
                    setIcons(((AppIcons) value));
                } else {
                    throw new IllegalArgumentException(("property \"icons\" is of type \"org.hisp.dhis.api.model.v2_38_1.AppIcons\", but got "+ value.getClass().toString()));
                }
                return true;
            case "installs_allowed_from":
                if (value instanceof List) {
                    setInstallsAllowedFrom(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"installs_allowed_from\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "key":
                if (value instanceof String) {
                    setKey(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"key\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "launchUrl":
                if (value instanceof String) {
                    setLaunchUrl(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"launchUrl\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "launch_path":
                if (value instanceof String) {
                    setLaunchPath(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"launch_path\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "name":
                if (value instanceof String) {
                    setName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "settings":
                if (value instanceof AppSettings) {
                    setSettings(((AppSettings) value));
                } else {
                    throw new IllegalArgumentException(("property \"settings\" is of type \"org.hisp.dhis.api.model.v2_38_1.AppSettings\", but got "+ value.getClass().toString()));
                }
                return true;
            case "short_name":
                if (value instanceof String) {
                    setShortName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"short_name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "version":
                if (value instanceof String) {
                    setVersion(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"version\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "activities":
                return getActivities();
            case "appState":
                return getAppState();
            case "appStorageSource":
                return getAppStorageSource();
            case "appType":
                return getAppType();
            case "app_hub_id":
                return getAppHubId();
            case "authorities":
                return getAuthorities();
            case "baseUrl":
                return getBaseUrl();
            case "bundled":
                return getBundled();
            case "core_app":
                return getCoreApp();
            case "default_locale":
                return getDefaultLocale();
            case "description":
                return getDescription();
            case "developer":
                return getDeveloper();
            case "folderName":
                return getFolderName();
            case "icons":
                return getIcons();
            case "installs_allowed_from":
                return getInstallsAllowedFrom();
            case "key":
                return getKey();
            case "launchUrl":
                return getLaunchUrl();
            case "launch_path":
                return getLaunchPath();
            case "name":
                return getName();
            case "settings":
                return getSettings();
            case "short_name":
                return getShortName();
            case "version":
                return getVersion();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, App.NOT_FOUND_VALUE);
        if (App.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public App with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(App.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("activities");
        sb.append('=');
        sb.append(((this.activities == null)?"<null>":this.activities));
        sb.append(',');
        sb.append("appState");
        sb.append('=');
        sb.append(((this.appState == null)?"<null>":this.appState));
        sb.append(',');
        sb.append("appStorageSource");
        sb.append('=');
        sb.append(((this.appStorageSource == null)?"<null>":this.appStorageSource));
        sb.append(',');
        sb.append("appType");
        sb.append('=');
        sb.append(((this.appType == null)?"<null>":this.appType));
        sb.append(',');
        sb.append("appHubId");
        sb.append('=');
        sb.append(((this.appHubId == null)?"<null>":this.appHubId));
        sb.append(',');
        sb.append("authorities");
        sb.append('=');
        sb.append(((this.authorities == null)?"<null>":this.authorities));
        sb.append(',');
        sb.append("baseUrl");
        sb.append('=');
        sb.append(((this.baseUrl == null)?"<null>":this.baseUrl));
        sb.append(',');
        sb.append("bundled");
        sb.append('=');
        sb.append(((this.bundled == null)?"<null>":this.bundled));
        sb.append(',');
        sb.append("coreApp");
        sb.append('=');
        sb.append(((this.coreApp == null)?"<null>":this.coreApp));
        sb.append(',');
        sb.append("defaultLocale");
        sb.append('=');
        sb.append(((this.defaultLocale == null)?"<null>":this.defaultLocale));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("developer");
        sb.append('=');
        sb.append(((this.developer == null)?"<null>":this.developer));
        sb.append(',');
        sb.append("folderName");
        sb.append('=');
        sb.append(((this.folderName == null)?"<null>":this.folderName));
        sb.append(',');
        sb.append("icons");
        sb.append('=');
        sb.append(((this.icons == null)?"<null>":this.icons));
        sb.append(',');
        sb.append("installsAllowedFrom");
        sb.append('=');
        sb.append(((this.installsAllowedFrom == null)?"<null>":this.installsAllowedFrom));
        sb.append(',');
        sb.append("key");
        sb.append('=');
        sb.append(((this.key == null)?"<null>":this.key));
        sb.append(',');
        sb.append("launchUrl");
        sb.append('=');
        sb.append(((this.launchUrl == null)?"<null>":this.launchUrl));
        sb.append(',');
        sb.append("launchPath");
        sb.append('=');
        sb.append(((this.launchPath == null)?"<null>":this.launchPath));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("settings");
        sb.append('=');
        sb.append(((this.settings == null)?"<null>":this.settings));
        sb.append(',');
        sb.append("shortName");
        sb.append('=');
        sb.append(((this.shortName == null)?"<null>":this.shortName));
        sb.append(',');
        sb.append("version");
        sb.append('=');
        sb.append(((this.version == null)?"<null>":this.version));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.appState == null)? 0 :this.appState.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.installsAllowedFrom == null)? 0 :this.installsAllowedFrom.hashCode()));
        result = ((result* 31)+((this.appType == null)? 0 :this.appType.hashCode()));
        result = ((result* 31)+((this.appHubId == null)? 0 :this.appHubId.hashCode()));
        result = ((result* 31)+((this.key == null)? 0 :this.key.hashCode()));
        result = ((result* 31)+((this.appStorageSource == null)? 0 :this.appStorageSource.hashCode()));
        result = ((result* 31)+((this.settings == null)? 0 :this.settings.hashCode()));
        result = ((result* 31)+((this.bundled == null)? 0 :this.bundled.hashCode()));
        result = ((result* 31)+((this.coreApp == null)? 0 :this.coreApp.hashCode()));
        result = ((result* 31)+((this.icons == null)? 0 :this.icons.hashCode()));
        result = ((result* 31)+((this.version == null)? 0 :this.version.hashCode()));
        result = ((result* 31)+((this.authorities == null)? 0 :this.authorities.hashCode()));
        result = ((result* 31)+((this.defaultLocale == null)? 0 :this.defaultLocale.hashCode()));
        result = ((result* 31)+((this.baseUrl == null)? 0 :this.baseUrl.hashCode()));
        result = ((result* 31)+((this.activities == null)? 0 :this.activities.hashCode()));
        result = ((result* 31)+((this.launchPath == null)? 0 :this.launchPath.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.developer == null)? 0 :this.developer.hashCode()));
        result = ((result* 31)+((this.folderName == null)? 0 :this.folderName.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.shortName == null)? 0 :this.shortName.hashCode()));
        result = ((result* 31)+((this.launchUrl == null)? 0 :this.launchUrl.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof App) == false) {
            return false;
        }
        App rhs = ((App) other);
        return ((((((((((((((((((((((((this.appState == rhs.appState)||((this.appState!= null)&&this.appState.equals(rhs.appState)))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.installsAllowedFrom == rhs.installsAllowedFrom)||((this.installsAllowedFrom!= null)&&this.installsAllowedFrom.equals(rhs.installsAllowedFrom))))&&((this.appType == rhs.appType)||((this.appType!= null)&&this.appType.equals(rhs.appType))))&&((this.appHubId == rhs.appHubId)||((this.appHubId!= null)&&this.appHubId.equals(rhs.appHubId))))&&((this.key == rhs.key)||((this.key!= null)&&this.key.equals(rhs.key))))&&((this.appStorageSource == rhs.appStorageSource)||((this.appStorageSource!= null)&&this.appStorageSource.equals(rhs.appStorageSource))))&&((this.settings == rhs.settings)||((this.settings!= null)&&this.settings.equals(rhs.settings))))&&((this.bundled == rhs.bundled)||((this.bundled!= null)&&this.bundled.equals(rhs.bundled))))&&((this.coreApp == rhs.coreApp)||((this.coreApp!= null)&&this.coreApp.equals(rhs.coreApp))))&&((this.icons == rhs.icons)||((this.icons!= null)&&this.icons.equals(rhs.icons))))&&((this.version == rhs.version)||((this.version!= null)&&this.version.equals(rhs.version))))&&((this.authorities == rhs.authorities)||((this.authorities!= null)&&this.authorities.equals(rhs.authorities))))&&((this.defaultLocale == rhs.defaultLocale)||((this.defaultLocale!= null)&&this.defaultLocale.equals(rhs.defaultLocale))))&&((this.baseUrl == rhs.baseUrl)||((this.baseUrl!= null)&&this.baseUrl.equals(rhs.baseUrl))))&&((this.activities == rhs.activities)||((this.activities!= null)&&this.activities.equals(rhs.activities))))&&((this.launchPath == rhs.launchPath)||((this.launchPath!= null)&&this.launchPath.equals(rhs.launchPath))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.developer == rhs.developer)||((this.developer!= null)&&this.developer.equals(rhs.developer))))&&((this.folderName == rhs.folderName)||((this.folderName!= null)&&this.folderName.equals(rhs.folderName))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.shortName == rhs.shortName)||((this.shortName!= null)&&this.shortName.equals(rhs.shortName))))&&((this.launchUrl == rhs.launchUrl)||((this.launchUrl!= null)&&this.launchUrl.equals(rhs.launchUrl))));
    }

    @Generated("jsonschema2pojo")
    public enum AppStatus {

        OK("OK"),
        INVALID_BUNDLED_APP_OVERRIDE("INVALID_BUNDLED_APP_OVERRIDE"),
        INVALID_CORE_APP("INVALID_CORE_APP"),
        NAMESPACE_TAKEN("NAMESPACE_TAKEN"),
        INVALID_ZIP_FORMAT("INVALID_ZIP_FORMAT"),
        MISSING_MANIFEST("MISSING_MANIFEST"),
        INVALID_MANIFEST_JSON("INVALID_MANIFEST_JSON"),
        INSTALLATION_FAILED("INSTALLATION_FAILED"),
        NOT_FOUND("NOT_FOUND"),
        MISSING_SYSTEM_BASE_URL("MISSING_SYSTEM_BASE_URL"),
        APPROVED("APPROVED"),
        PENDING("PENDING"),
        NOT_APPROVED("NOT_APPROVED"),
        DELETION_IN_PROGRESS("DELETION_IN_PROGRESS");
        private final String value;
        private final static Map<String, App.AppStatus> CONSTANTS = new HashMap<String, App.AppStatus>();

        static {
            for (App.AppStatus c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        AppStatus(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static App.AppStatus fromValue(String value) {
            App.AppStatus constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum AppStorageSource {

        LOCAL("LOCAL"),
        JCLOUDS("JCLOUDS");
        private final String value;
        private final static Map<String, App.AppStorageSource> CONSTANTS = new HashMap<String, App.AppStorageSource>();

        static {
            for (App.AppStorageSource c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        AppStorageSource(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static App.AppStorageSource fromValue(String value) {
            App.AppStorageSource constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum AppType {

        APP("APP"),
        RESOURCE("RESOURCE"),
        DASHBOARD_WIDGET("DASHBOARD_WIDGET"),
        TRACKER_DASHBOARD_WIDGET("TRACKER_DASHBOARD_WIDGET");
        private final String value;
        private final static Map<String, App.AppType> CONSTANTS = new HashMap<String, App.AppType>();

        static {
            for (App.AppType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        AppType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static App.AppType fromValue(String value) {
            App.AppType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
