
package org.hisp.dhis.api.model.v2_37_7;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "auditType",
    "created",
    "modifiedBy",
    "trackedEntityAttribute",
    "trackedEntityInstance",
    "value"
})
@Generated("jsonschema2pojo")
public class TrackedEntityAttributeValueAudit implements Serializable
{

    @JsonProperty("auditType")
    private AuditType auditType;
    @JsonProperty("created")
    private Date created;
    @JsonProperty("modifiedBy")
    private String modifiedBy;
    @JsonProperty("trackedEntityAttribute")
    private TrackedEntityAttribute trackedEntityAttribute;
    @JsonProperty("trackedEntityInstance")
    private TrackedEntityInstance__1 trackedEntityInstance;
    @JsonProperty("value")
    private String value;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -6636590883118904809L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TrackedEntityAttributeValueAudit() {
    }

    /**
     * 
     * @param source
     */
    public TrackedEntityAttributeValueAudit(TrackedEntityAttributeValueAudit source) {
        super();
        this.auditType = source.auditType;
        this.created = source.created;
        this.modifiedBy = source.modifiedBy;
        this.trackedEntityAttribute = source.trackedEntityAttribute;
        this.trackedEntityInstance = source.trackedEntityInstance;
        this.value = source.value;
    }

    /**
     * 
     * @param created
     * @param modifiedBy
     * @param auditType
     * @param value
     * @param trackedEntityAttribute
     * @param trackedEntityInstance
     */
    public TrackedEntityAttributeValueAudit(AuditType auditType, Date created, String modifiedBy, TrackedEntityAttribute trackedEntityAttribute, TrackedEntityInstance__1 trackedEntityInstance, String value) {
        super();
        this.auditType = auditType;
        this.created = created;
        this.modifiedBy = modifiedBy;
        this.trackedEntityAttribute = trackedEntityAttribute;
        this.trackedEntityInstance = trackedEntityInstance;
        this.value = value;
    }

    @JsonProperty("auditType")
    public Optional<AuditType> getAuditType() {
        return Optional.ofNullable(auditType);
    }

    @JsonProperty("auditType")
    public void setAuditType(AuditType auditType) {
        this.auditType = auditType;
    }

    public TrackedEntityAttributeValueAudit withAuditType(AuditType auditType) {
        this.auditType = auditType;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public TrackedEntityAttributeValueAudit withCreated(Date created) {
        this.created = created;
        return this;
    }

    @JsonProperty("modifiedBy")
    public Optional<String> getModifiedBy() {
        return Optional.ofNullable(modifiedBy);
    }

    @JsonProperty("modifiedBy")
    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public TrackedEntityAttributeValueAudit withModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
        return this;
    }

    @JsonProperty("trackedEntityAttribute")
    public Optional<TrackedEntityAttribute> getTrackedEntityAttribute() {
        return Optional.ofNullable(trackedEntityAttribute);
    }

    @JsonProperty("trackedEntityAttribute")
    public void setTrackedEntityAttribute(TrackedEntityAttribute trackedEntityAttribute) {
        this.trackedEntityAttribute = trackedEntityAttribute;
    }

    public TrackedEntityAttributeValueAudit withTrackedEntityAttribute(TrackedEntityAttribute trackedEntityAttribute) {
        this.trackedEntityAttribute = trackedEntityAttribute;
        return this;
    }

    @JsonProperty("trackedEntityInstance")
    public Optional<TrackedEntityInstance__1> getTrackedEntityInstance() {
        return Optional.ofNullable(trackedEntityInstance);
    }

    @JsonProperty("trackedEntityInstance")
    public void setTrackedEntityInstance(TrackedEntityInstance__1 trackedEntityInstance) {
        this.trackedEntityInstance = trackedEntityInstance;
    }

    public TrackedEntityAttributeValueAudit withTrackedEntityInstance(TrackedEntityInstance__1 trackedEntityInstance) {
        this.trackedEntityInstance = trackedEntityInstance;
        return this;
    }

    @JsonProperty("value")
    public Optional<String> getValue() {
        return Optional.ofNullable(value);
    }

    @JsonProperty("value")
    public void setValue(String value) {
        this.value = value;
    }

    public TrackedEntityAttributeValueAudit withValue(String value) {
        this.value = value;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public TrackedEntityAttributeValueAudit withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "auditType":
                if (value instanceof AuditType) {
                    setAuditType(((AuditType) value));
                } else {
                    throw new IllegalArgumentException(("property \"auditType\" is of type \"org.hisp.dhis.api.model.v2_37_7.AuditType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "created":
                if (value instanceof Date) {
                    setCreated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "modifiedBy":
                if (value instanceof String) {
                    setModifiedBy(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"modifiedBy\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "trackedEntityAttribute":
                if (value instanceof TrackedEntityAttribute) {
                    setTrackedEntityAttribute(((TrackedEntityAttribute) value));
                } else {
                    throw new IllegalArgumentException(("property \"trackedEntityAttribute\" is of type \"org.hisp.dhis.api.model.v2_37_7.TrackedEntityAttribute\", but got "+ value.getClass().toString()));
                }
                return true;
            case "trackedEntityInstance":
                if (value instanceof TrackedEntityInstance__1) {
                    setTrackedEntityInstance(((TrackedEntityInstance__1) value));
                } else {
                    throw new IllegalArgumentException(("property \"trackedEntityInstance\" is of type \"org.hisp.dhis.api.model.v2_37_7.TrackedEntityInstance__1\", but got "+ value.getClass().toString()));
                }
                return true;
            case "value":
                if (value instanceof String) {
                    setValue(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"value\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "auditType":
                return getAuditType();
            case "created":
                return getCreated();
            case "modifiedBy":
                return getModifiedBy();
            case "trackedEntityAttribute":
                return getTrackedEntityAttribute();
            case "trackedEntityInstance":
                return getTrackedEntityInstance();
            case "value":
                return getValue();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, TrackedEntityAttributeValueAudit.NOT_FOUND_VALUE);
        if (TrackedEntityAttributeValueAudit.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public TrackedEntityAttributeValueAudit with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TrackedEntityAttributeValueAudit.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("auditType");
        sb.append('=');
        sb.append(((this.auditType == null)?"<null>":this.auditType));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("modifiedBy");
        sb.append('=');
        sb.append(((this.modifiedBy == null)?"<null>":this.modifiedBy));
        sb.append(',');
        sb.append("trackedEntityAttribute");
        sb.append('=');
        sb.append(((this.trackedEntityAttribute == null)?"<null>":this.trackedEntityAttribute));
        sb.append(',');
        sb.append("trackedEntityInstance");
        sb.append('=');
        sb.append(((this.trackedEntityInstance == null)?"<null>":this.trackedEntityInstance));
        sb.append(',');
        sb.append("value");
        sb.append('=');
        sb.append(((this.value == null)?"<null>":this.value));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.modifiedBy == null)? 0 :this.modifiedBy.hashCode()));
        result = ((result* 31)+((this.auditType == null)? 0 :this.auditType.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.value == null)? 0 :this.value.hashCode()));
        result = ((result* 31)+((this.trackedEntityAttribute == null)? 0 :this.trackedEntityAttribute.hashCode()));
        result = ((result* 31)+((this.trackedEntityInstance == null)? 0 :this.trackedEntityInstance.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TrackedEntityAttributeValueAudit) == false) {
            return false;
        }
        TrackedEntityAttributeValueAudit rhs = ((TrackedEntityAttributeValueAudit) other);
        return ((((((((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created)))&&((this.modifiedBy == rhs.modifiedBy)||((this.modifiedBy!= null)&&this.modifiedBy.equals(rhs.modifiedBy))))&&((this.auditType == rhs.auditType)||((this.auditType!= null)&&this.auditType.equals(rhs.auditType))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.value == rhs.value)||((this.value!= null)&&this.value.equals(rhs.value))))&&((this.trackedEntityAttribute == rhs.trackedEntityAttribute)||((this.trackedEntityAttribute!= null)&&this.trackedEntityAttribute.equals(rhs.trackedEntityAttribute))))&&((this.trackedEntityInstance == rhs.trackedEntityInstance)||((this.trackedEntityInstance!= null)&&this.trackedEntityInstance.equals(rhs.trackedEntityInstance))));
    }

}
