
package org.hisp.dhis.api.model.v2_37_7;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "deliveryChannels",
    "messageTemplate",
    "notificationRecipient",
    "notificationTrigger",
    "sendRepeatable",
    "subjectTemplate"
})
@Generated("jsonschema2pojo")
public class ProgramNotificationTemplateSnapshot implements Serializable
{

    @JsonProperty("deliveryChannels")
    private List<DeliveryChannel> deliveryChannels = null;
    @JsonProperty("messageTemplate")
    private String messageTemplate;
    @JsonProperty("notificationRecipient")
    private org.hisp.dhis.api.model.v2_37_7.ProgramNotificationTemplate.ProgramNotificationRecipient notificationRecipient;
    @JsonProperty("notificationTrigger")
    private org.hisp.dhis.api.model.v2_37_7.ProgramNotificationTemplate.NotificationTrigger notificationTrigger;
    @JsonProperty("sendRepeatable")
    private Boolean sendRepeatable;
    @JsonProperty("subjectTemplate")
    private String subjectTemplate;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 1722170100203549554L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ProgramNotificationTemplateSnapshot() {
    }

    /**
     * 
     * @param source
     */
    public ProgramNotificationTemplateSnapshot(ProgramNotificationTemplateSnapshot source) {
        super();
        this.deliveryChannels = source.deliveryChannels;
        this.messageTemplate = source.messageTemplate;
        this.notificationRecipient = source.notificationRecipient;
        this.notificationTrigger = source.notificationTrigger;
        this.sendRepeatable = source.sendRepeatable;
        this.subjectTemplate = source.subjectTemplate;
    }

    /**
     * 
     * @param notificationTrigger
     * @param notificationRecipient
     * @param deliveryChannels
     * @param subjectTemplate
     * @param messageTemplate
     * @param sendRepeatable
     */
    public ProgramNotificationTemplateSnapshot(List<DeliveryChannel> deliveryChannels, String messageTemplate, org.hisp.dhis.api.model.v2_37_7.ProgramNotificationTemplate.ProgramNotificationRecipient notificationRecipient, org.hisp.dhis.api.model.v2_37_7.ProgramNotificationTemplate.NotificationTrigger notificationTrigger, Boolean sendRepeatable, String subjectTemplate) {
        super();
        this.deliveryChannels = deliveryChannels;
        this.messageTemplate = messageTemplate;
        this.notificationRecipient = notificationRecipient;
        this.notificationTrigger = notificationTrigger;
        this.sendRepeatable = sendRepeatable;
        this.subjectTemplate = subjectTemplate;
    }

    @JsonProperty("deliveryChannels")
    public Optional<List<DeliveryChannel>> getDeliveryChannels() {
        return Optional.ofNullable(deliveryChannels);
    }

    @JsonProperty("deliveryChannels")
    public void setDeliveryChannels(List<DeliveryChannel> deliveryChannels) {
        this.deliveryChannels = deliveryChannels;
    }

    public ProgramNotificationTemplateSnapshot withDeliveryChannels(List<DeliveryChannel> deliveryChannels) {
        this.deliveryChannels = deliveryChannels;
        return this;
    }

    @JsonProperty("messageTemplate")
    public Optional<String> getMessageTemplate() {
        return Optional.ofNullable(messageTemplate);
    }

    @JsonProperty("messageTemplate")
    public void setMessageTemplate(String messageTemplate) {
        this.messageTemplate = messageTemplate;
    }

    public ProgramNotificationTemplateSnapshot withMessageTemplate(String messageTemplate) {
        this.messageTemplate = messageTemplate;
        return this;
    }

    @JsonProperty("notificationRecipient")
    public Optional<org.hisp.dhis.api.model.v2_37_7.ProgramNotificationTemplate.ProgramNotificationRecipient> getNotificationRecipient() {
        return Optional.ofNullable(notificationRecipient);
    }

    @JsonProperty("notificationRecipient")
    public void setNotificationRecipient(org.hisp.dhis.api.model.v2_37_7.ProgramNotificationTemplate.ProgramNotificationRecipient notificationRecipient) {
        this.notificationRecipient = notificationRecipient;
    }

    public ProgramNotificationTemplateSnapshot withNotificationRecipient(org.hisp.dhis.api.model.v2_37_7.ProgramNotificationTemplate.ProgramNotificationRecipient notificationRecipient) {
        this.notificationRecipient = notificationRecipient;
        return this;
    }

    @JsonProperty("notificationTrigger")
    public Optional<org.hisp.dhis.api.model.v2_37_7.ProgramNotificationTemplate.NotificationTrigger> getNotificationTrigger() {
        return Optional.ofNullable(notificationTrigger);
    }

    @JsonProperty("notificationTrigger")
    public void setNotificationTrigger(org.hisp.dhis.api.model.v2_37_7.ProgramNotificationTemplate.NotificationTrigger notificationTrigger) {
        this.notificationTrigger = notificationTrigger;
    }

    public ProgramNotificationTemplateSnapshot withNotificationTrigger(org.hisp.dhis.api.model.v2_37_7.ProgramNotificationTemplate.NotificationTrigger notificationTrigger) {
        this.notificationTrigger = notificationTrigger;
        return this;
    }

    @JsonProperty("sendRepeatable")
    public Optional<Boolean> getSendRepeatable() {
        return Optional.ofNullable(sendRepeatable);
    }

    @JsonProperty("sendRepeatable")
    public void setSendRepeatable(Boolean sendRepeatable) {
        this.sendRepeatable = sendRepeatable;
    }

    public ProgramNotificationTemplateSnapshot withSendRepeatable(Boolean sendRepeatable) {
        this.sendRepeatable = sendRepeatable;
        return this;
    }

    @JsonProperty("subjectTemplate")
    public Optional<String> getSubjectTemplate() {
        return Optional.ofNullable(subjectTemplate);
    }

    @JsonProperty("subjectTemplate")
    public void setSubjectTemplate(String subjectTemplate) {
        this.subjectTemplate = subjectTemplate;
    }

    public ProgramNotificationTemplateSnapshot withSubjectTemplate(String subjectTemplate) {
        this.subjectTemplate = subjectTemplate;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ProgramNotificationTemplateSnapshot withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "deliveryChannels":
                if (value instanceof List) {
                    setDeliveryChannels(((List<DeliveryChannel> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"deliveryChannels\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.DeliveryChannel>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "messageTemplate":
                if (value instanceof String) {
                    setMessageTemplate(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"messageTemplate\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "notificationRecipient":
                if (value instanceof org.hisp.dhis.api.model.v2_37_7.ProgramNotificationTemplate.ProgramNotificationRecipient) {
                    setNotificationRecipient(((org.hisp.dhis.api.model.v2_37_7.ProgramNotificationTemplate.ProgramNotificationRecipient) value));
                } else {
                    throw new IllegalArgumentException(("property \"notificationRecipient\" is of type \"org.hisp.dhis.api.model.v2_37_7.ProgramNotificationTemplate.ProgramNotificationRecipient\", but got "+ value.getClass().toString()));
                }
                return true;
            case "notificationTrigger":
                if (value instanceof org.hisp.dhis.api.model.v2_37_7.ProgramNotificationTemplate.NotificationTrigger) {
                    setNotificationTrigger(((org.hisp.dhis.api.model.v2_37_7.ProgramNotificationTemplate.NotificationTrigger) value));
                } else {
                    throw new IllegalArgumentException(("property \"notificationTrigger\" is of type \"org.hisp.dhis.api.model.v2_37_7.ProgramNotificationTemplate.NotificationTrigger\", but got "+ value.getClass().toString()));
                }
                return true;
            case "sendRepeatable":
                if (value instanceof Boolean) {
                    setSendRepeatable(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"sendRepeatable\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "subjectTemplate":
                if (value instanceof String) {
                    setSubjectTemplate(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"subjectTemplate\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "deliveryChannels":
                return getDeliveryChannels();
            case "messageTemplate":
                return getMessageTemplate();
            case "notificationRecipient":
                return getNotificationRecipient();
            case "notificationTrigger":
                return getNotificationTrigger();
            case "sendRepeatable":
                return getSendRepeatable();
            case "subjectTemplate":
                return getSubjectTemplate();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ProgramNotificationTemplateSnapshot.NOT_FOUND_VALUE);
        if (ProgramNotificationTemplateSnapshot.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ProgramNotificationTemplateSnapshot with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ProgramNotificationTemplateSnapshot.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("deliveryChannels");
        sb.append('=');
        sb.append(((this.deliveryChannels == null)?"<null>":this.deliveryChannels));
        sb.append(',');
        sb.append("messageTemplate");
        sb.append('=');
        sb.append(((this.messageTemplate == null)?"<null>":this.messageTemplate));
        sb.append(',');
        sb.append("notificationRecipient");
        sb.append('=');
        sb.append(((this.notificationRecipient == null)?"<null>":this.notificationRecipient));
        sb.append(',');
        sb.append("notificationTrigger");
        sb.append('=');
        sb.append(((this.notificationTrigger == null)?"<null>":this.notificationTrigger));
        sb.append(',');
        sb.append("sendRepeatable");
        sb.append('=');
        sb.append(((this.sendRepeatable == null)?"<null>":this.sendRepeatable));
        sb.append(',');
        sb.append("subjectTemplate");
        sb.append('=');
        sb.append(((this.subjectTemplate == null)?"<null>":this.subjectTemplate));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.notificationTrigger == null)? 0 :this.notificationTrigger.hashCode()));
        result = ((result* 31)+((this.notificationRecipient == null)? 0 :this.notificationRecipient.hashCode()));
        result = ((result* 31)+((this.deliveryChannels == null)? 0 :this.deliveryChannels.hashCode()));
        result = ((result* 31)+((this.subjectTemplate == null)? 0 :this.subjectTemplate.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.messageTemplate == null)? 0 :this.messageTemplate.hashCode()));
        result = ((result* 31)+((this.sendRepeatable == null)? 0 :this.sendRepeatable.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ProgramNotificationTemplateSnapshot) == false) {
            return false;
        }
        ProgramNotificationTemplateSnapshot rhs = ((ProgramNotificationTemplateSnapshot) other);
        return ((((((((this.notificationTrigger == rhs.notificationTrigger)||((this.notificationTrigger!= null)&&this.notificationTrigger.equals(rhs.notificationTrigger)))&&((this.notificationRecipient == rhs.notificationRecipient)||((this.notificationRecipient!= null)&&this.notificationRecipient.equals(rhs.notificationRecipient))))&&((this.deliveryChannels == rhs.deliveryChannels)||((this.deliveryChannels!= null)&&this.deliveryChannels.equals(rhs.deliveryChannels))))&&((this.subjectTemplate == rhs.subjectTemplate)||((this.subjectTemplate!= null)&&this.subjectTemplate.equals(rhs.subjectTemplate))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.messageTemplate == rhs.messageTemplate)||((this.messageTemplate!= null)&&this.messageTemplate.equals(rhs.messageTemplate))))&&((this.sendRepeatable == rhs.sendRepeatable)||((this.sendRepeatable!= null)&&this.sendRepeatable.equals(rhs.sendRepeatable))));
    }

}
