
package org.hisp.dhis.api.model.v2_37_7;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "attributeValues",
    "code",
    "created",
    "createdBy",
    "deliveryChannels",
    "displayName",
    "externalAccess",
    "favorite",
    "favorites",
    "href",
    "id",
    "lastUpdated",
    "lastUpdatedBy",
    "messageStatus",
    "name",
    "notificationTemplate",
    "processedDate",
    "programInstance",
    "programStageInstance",
    "publicAccess",
    "recipients",
    "sharing",
    "storeCopy",
    "subject",
    "text",
    "translations",
    "user",
    "userAccesses",
    "userGroupAccesses"
})
@Generated("jsonschema2pojo")
public class ProgramMessage implements Serializable
{

    @JsonProperty("access")
    private Access access;
    @JsonProperty("attributeValues")
    private List<AttributeValue> attributeValues = null;
    @JsonProperty("code")
    private String code;
    @JsonProperty("created")
    private Date created;
    @JsonProperty("createdBy")
    private User createdBy;
    @JsonProperty("deliveryChannels")
    private List<DeliveryChannel> deliveryChannels = null;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    @JsonProperty("favorite")
    private Boolean favorite;
    @JsonProperty("favorites")
    private List<String> favorites = null;
    @JsonProperty("href")
    private String href;
    @JsonProperty("id")
    private String id;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    @JsonProperty("lastUpdatedBy")
    private User lastUpdatedBy;
    @JsonProperty("messageStatus")
    private ProgramMessage.ProgramMessageStatus messageStatus;
    @JsonProperty("name")
    private String name;
    @JsonProperty("notificationTemplate")
    private String notificationTemplate;
    @JsonProperty("processedDate")
    private Date processedDate;
    @JsonProperty("programInstance")
    private ProgramInstance programInstance;
    @JsonProperty("programStageInstance")
    private ProgramStageInstance programStageInstance;
    @JsonProperty("publicAccess")
    private String publicAccess;
    @JsonProperty("recipients")
    private ProgramMessageRecipients recipients;
    @JsonProperty("sharing")
    private Sharing sharing;
    @JsonProperty("storeCopy")
    private Boolean storeCopy;
    @JsonProperty("subject")
    private String subject;
    @JsonProperty("text")
    private String text;
    @JsonProperty("translations")
    private List<Translation> translations = null;
    @JsonProperty("user")
    private User user;
    @JsonProperty("userAccesses")
    private List<UserAccess> userAccesses = null;
    @JsonProperty("userGroupAccesses")
    private List<UserGroupAccess> userGroupAccesses = null;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -7756360367595440118L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ProgramMessage() {
    }

    /**
     * 
     * @param source
     */
    public ProgramMessage(ProgramMessage source) {
        super();
        this.access = source.access;
        this.attributeValues = source.attributeValues;
        this.code = source.code;
        this.created = source.created;
        this.createdBy = source.createdBy;
        this.deliveryChannels = source.deliveryChannels;
        this.displayName = source.displayName;
        this.externalAccess = source.externalAccess;
        this.favorite = source.favorite;
        this.favorites = source.favorites;
        this.href = source.href;
        this.id = source.id;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.messageStatus = source.messageStatus;
        this.name = source.name;
        this.notificationTemplate = source.notificationTemplate;
        this.processedDate = source.processedDate;
        this.programInstance = source.programInstance;
        this.programStageInstance = source.programStageInstance;
        this.publicAccess = source.publicAccess;
        this.recipients = source.recipients;
        this.sharing = source.sharing;
        this.storeCopy = source.storeCopy;
        this.subject = source.subject;
        this.text = source.text;
        this.translations = source.translations;
        this.user = source.user;
        this.userAccesses = source.userAccesses;
        this.userGroupAccesses = source.userGroupAccesses;
    }

    /**
     * 
     * @param favorites
     * @param access
     * @param code
     * @param displayName
     * @param publicAccess
     * @param subject
     * @param externalAccess
     * @param lastUpdated
     * @param processedDate
     * @param translations
     * @param href
     * @param id
     * @param text
     * @param notificationTemplate
     * @param lastUpdatedBy
     * @param programStageInstance
     * @param userGroupAccesses
     * @param created
     * @param deliveryChannels
     * @param storeCopy
     * @param attributeValues
     * @param sharing
     * @param messageStatus
     * @param programInstance
     * @param createdBy
     * @param recipients
     * @param userAccesses
     * @param name
     * @param favorite
     * @param user
     */
    public ProgramMessage(Access access, List<AttributeValue> attributeValues, String code, Date created, User createdBy, List<DeliveryChannel> deliveryChannels, String displayName, Boolean externalAccess, Boolean favorite, List<String> favorites, String href, String id, Date lastUpdated, User lastUpdatedBy, ProgramMessage.ProgramMessageStatus messageStatus, String name, String notificationTemplate, Date processedDate, ProgramInstance programInstance, ProgramStageInstance programStageInstance, String publicAccess, ProgramMessageRecipients recipients, Sharing sharing, Boolean storeCopy, String subject, String text, List<Translation> translations, User user, List<UserAccess> userAccesses, List<UserGroupAccess> userGroupAccesses) {
        super();
        this.access = access;
        this.attributeValues = attributeValues;
        this.code = code;
        this.created = created;
        this.createdBy = createdBy;
        this.deliveryChannels = deliveryChannels;
        this.displayName = displayName;
        this.externalAccess = externalAccess;
        this.favorite = favorite;
        this.favorites = favorites;
        this.href = href;
        this.id = id;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedBy = lastUpdatedBy;
        this.messageStatus = messageStatus;
        this.name = name;
        this.notificationTemplate = notificationTemplate;
        this.processedDate = processedDate;
        this.programInstance = programInstance;
        this.programStageInstance = programStageInstance;
        this.publicAccess = publicAccess;
        this.recipients = recipients;
        this.sharing = sharing;
        this.storeCopy = storeCopy;
        this.subject = subject;
        this.text = text;
        this.translations = translations;
        this.user = user;
        this.userAccesses = userAccesses;
        this.userGroupAccesses = userGroupAccesses;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public ProgramMessage withAccess(Access access) {
        this.access = access;
        return this;
    }

    @JsonProperty("attributeValues")
    public Optional<List<AttributeValue>> getAttributeValues() {
        return Optional.ofNullable(attributeValues);
    }

    @JsonProperty("attributeValues")
    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public ProgramMessage withAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public ProgramMessage withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public ProgramMessage withCreated(Date created) {
        this.created = created;
        return this;
    }

    @JsonProperty("createdBy")
    public Optional<User> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    @JsonProperty("createdBy")
    public void setCreatedBy(User createdBy) {
        this.createdBy = createdBy;
    }

    public ProgramMessage withCreatedBy(User createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @JsonProperty("deliveryChannels")
    public Optional<List<DeliveryChannel>> getDeliveryChannels() {
        return Optional.ofNullable(deliveryChannels);
    }

    @JsonProperty("deliveryChannels")
    public void setDeliveryChannels(List<DeliveryChannel> deliveryChannels) {
        this.deliveryChannels = deliveryChannels;
    }

    public ProgramMessage withDeliveryChannels(List<DeliveryChannel> deliveryChannels) {
        this.deliveryChannels = deliveryChannels;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ProgramMessage withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("externalAccess")
    public Optional<Boolean> getExternalAccess() {
        return Optional.ofNullable(externalAccess);
    }

    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public ProgramMessage withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    @JsonProperty("favorite")
    public Optional<Boolean> getFavorite() {
        return Optional.ofNullable(favorite);
    }

    @JsonProperty("favorite")
    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public ProgramMessage withFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public ProgramMessage withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public ProgramMessage withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public ProgramMessage withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public ProgramMessage withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    @JsonProperty("lastUpdatedBy")
    public Optional<User> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public ProgramMessage withLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    @JsonProperty("messageStatus")
    public Optional<ProgramMessage.ProgramMessageStatus> getMessageStatus() {
        return Optional.ofNullable(messageStatus);
    }

    @JsonProperty("messageStatus")
    public void setMessageStatus(ProgramMessage.ProgramMessageStatus messageStatus) {
        this.messageStatus = messageStatus;
    }

    public ProgramMessage withMessageStatus(ProgramMessage.ProgramMessageStatus messageStatus) {
        this.messageStatus = messageStatus;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public ProgramMessage withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("notificationTemplate")
    public Optional<String> getNotificationTemplate() {
        return Optional.ofNullable(notificationTemplate);
    }

    @JsonProperty("notificationTemplate")
    public void setNotificationTemplate(String notificationTemplate) {
        this.notificationTemplate = notificationTemplate;
    }

    public ProgramMessage withNotificationTemplate(String notificationTemplate) {
        this.notificationTemplate = notificationTemplate;
        return this;
    }

    @JsonProperty("processedDate")
    public Optional<Date> getProcessedDate() {
        return Optional.ofNullable(processedDate);
    }

    @JsonProperty("processedDate")
    public void setProcessedDate(Date processedDate) {
        this.processedDate = processedDate;
    }

    public ProgramMessage withProcessedDate(Date processedDate) {
        this.processedDate = processedDate;
        return this;
    }

    @JsonProperty("programInstance")
    public Optional<ProgramInstance> getProgramInstance() {
        return Optional.ofNullable(programInstance);
    }

    @JsonProperty("programInstance")
    public void setProgramInstance(ProgramInstance programInstance) {
        this.programInstance = programInstance;
    }

    public ProgramMessage withProgramInstance(ProgramInstance programInstance) {
        this.programInstance = programInstance;
        return this;
    }

    @JsonProperty("programStageInstance")
    public Optional<ProgramStageInstance> getProgramStageInstance() {
        return Optional.ofNullable(programStageInstance);
    }

    @JsonProperty("programStageInstance")
    public void setProgramStageInstance(ProgramStageInstance programStageInstance) {
        this.programStageInstance = programStageInstance;
    }

    public ProgramMessage withProgramStageInstance(ProgramStageInstance programStageInstance) {
        this.programStageInstance = programStageInstance;
        return this;
    }

    @JsonProperty("publicAccess")
    public Optional<String> getPublicAccess() {
        return Optional.ofNullable(publicAccess);
    }

    @JsonProperty("publicAccess")
    public void setPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
    }

    public ProgramMessage withPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    @JsonProperty("recipients")
    public Optional<ProgramMessageRecipients> getRecipients() {
        return Optional.ofNullable(recipients);
    }

    @JsonProperty("recipients")
    public void setRecipients(ProgramMessageRecipients recipients) {
        this.recipients = recipients;
    }

    public ProgramMessage withRecipients(ProgramMessageRecipients recipients) {
        this.recipients = recipients;
        return this;
    }

    @JsonProperty("sharing")
    public Optional<Sharing> getSharing() {
        return Optional.ofNullable(sharing);
    }

    @JsonProperty("sharing")
    public void setSharing(Sharing sharing) {
        this.sharing = sharing;
    }

    public ProgramMessage withSharing(Sharing sharing) {
        this.sharing = sharing;
        return this;
    }

    @JsonProperty("storeCopy")
    public Optional<Boolean> getStoreCopy() {
        return Optional.ofNullable(storeCopy);
    }

    @JsonProperty("storeCopy")
    public void setStoreCopy(Boolean storeCopy) {
        this.storeCopy = storeCopy;
    }

    public ProgramMessage withStoreCopy(Boolean storeCopy) {
        this.storeCopy = storeCopy;
        return this;
    }

    @JsonProperty("subject")
    public Optional<String> getSubject() {
        return Optional.ofNullable(subject);
    }

    @JsonProperty("subject")
    public void setSubject(String subject) {
        this.subject = subject;
    }

    public ProgramMessage withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    @JsonProperty("text")
    public Optional<String> getText() {
        return Optional.ofNullable(text);
    }

    @JsonProperty("text")
    public void setText(String text) {
        this.text = text;
    }

    public ProgramMessage withText(String text) {
        this.text = text;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public ProgramMessage withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    @JsonProperty("user")
    public Optional<User> getUser() {
        return Optional.ofNullable(user);
    }

    @JsonProperty("user")
    public void setUser(User user) {
        this.user = user;
    }

    public ProgramMessage withUser(User user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<UserAccess>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public ProgramMessage withUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<UserGroupAccess>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public ProgramMessage withUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ProgramMessage withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "access":
                if (value instanceof Access) {
                    setAccess(((Access) value));
                } else {
                    throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v2_37_7.Access\", but got "+ value.getClass().toString()));
                }
                return true;
            case "attributeValues":
                if (value instanceof List) {
                    setAttributeValues(((List<AttributeValue> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.AttributeValue>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "code":
                if (value instanceof String) {
                    setCode(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "created":
                if (value instanceof Date) {
                    setCreated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "createdBy":
                if (value instanceof User) {
                    setCreatedBy(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"createdBy\" is of type \"org.hisp.dhis.api.model.v2_37_7.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "deliveryChannels":
                if (value instanceof List) {
                    setDeliveryChannels(((List<DeliveryChannel> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"deliveryChannels\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.DeliveryChannel>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayName":
                if (value instanceof String) {
                    setDisplayName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "externalAccess":
                if (value instanceof Boolean) {
                    setExternalAccess(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "favorite":
                if (value instanceof Boolean) {
                    setFavorite(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"favorite\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "favorites":
                if (value instanceof List) {
                    setFavorites(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "href":
                if (value instanceof String) {
                    setHref(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "id":
                if (value instanceof String) {
                    setId(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdated":
                if (value instanceof Date) {
                    setLastUpdated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdatedBy":
                if (value instanceof User) {
                    setLastUpdatedBy(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"org.hisp.dhis.api.model.v2_37_7.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "messageStatus":
                if (value instanceof ProgramMessage.ProgramMessageStatus) {
                    setMessageStatus(((ProgramMessage.ProgramMessageStatus) value));
                } else {
                    throw new IllegalArgumentException(("property \"messageStatus\" is of type \"org.hisp.dhis.api.model.v2_37_7.ProgramMessage.ProgramMessageStatus\", but got "+ value.getClass().toString()));
                }
                return true;
            case "name":
                if (value instanceof String) {
                    setName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "notificationTemplate":
                if (value instanceof String) {
                    setNotificationTemplate(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"notificationTemplate\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "processedDate":
                if (value instanceof Date) {
                    setProcessedDate(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"processedDate\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "programInstance":
                if (value instanceof ProgramInstance) {
                    setProgramInstance(((ProgramInstance) value));
                } else {
                    throw new IllegalArgumentException(("property \"programInstance\" is of type \"org.hisp.dhis.api.model.v2_37_7.ProgramInstance\", but got "+ value.getClass().toString()));
                }
                return true;
            case "programStageInstance":
                if (value instanceof ProgramStageInstance) {
                    setProgramStageInstance(((ProgramStageInstance) value));
                } else {
                    throw new IllegalArgumentException(("property \"programStageInstance\" is of type \"org.hisp.dhis.api.model.v2_37_7.ProgramStageInstance\", but got "+ value.getClass().toString()));
                }
                return true;
            case "publicAccess":
                if (value instanceof String) {
                    setPublicAccess(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"publicAccess\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "recipients":
                if (value instanceof ProgramMessageRecipients) {
                    setRecipients(((ProgramMessageRecipients) value));
                } else {
                    throw new IllegalArgumentException(("property \"recipients\" is of type \"org.hisp.dhis.api.model.v2_37_7.ProgramMessageRecipients\", but got "+ value.getClass().toString()));
                }
                return true;
            case "sharing":
                if (value instanceof Sharing) {
                    setSharing(((Sharing) value));
                } else {
                    throw new IllegalArgumentException(("property \"sharing\" is of type \"org.hisp.dhis.api.model.v2_37_7.Sharing\", but got "+ value.getClass().toString()));
                }
                return true;
            case "storeCopy":
                if (value instanceof Boolean) {
                    setStoreCopy(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"storeCopy\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "subject":
                if (value instanceof String) {
                    setSubject(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"subject\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "text":
                if (value instanceof String) {
                    setText(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"text\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "translations":
                if (value instanceof List) {
                    setTranslations(((List<Translation> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.Translation>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "user":
                if (value instanceof User) {
                    setUser(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v2_37_7.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userAccesses":
                if (value instanceof List) {
                    setUserAccesses(((List<UserAccess> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.UserAccess>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userGroupAccesses":
                if (value instanceof List) {
                    setUserGroupAccesses(((List<UserGroupAccess> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.UserGroupAccess>\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "access":
                return getAccess();
            case "attributeValues":
                return getAttributeValues();
            case "code":
                return getCode();
            case "created":
                return getCreated();
            case "createdBy":
                return getCreatedBy();
            case "deliveryChannels":
                return getDeliveryChannels();
            case "displayName":
                return getDisplayName();
            case "externalAccess":
                return getExternalAccess();
            case "favorite":
                return getFavorite();
            case "favorites":
                return getFavorites();
            case "href":
                return getHref();
            case "id":
                return getId();
            case "lastUpdated":
                return getLastUpdated();
            case "lastUpdatedBy":
                return getLastUpdatedBy();
            case "messageStatus":
                return getMessageStatus();
            case "name":
                return getName();
            case "notificationTemplate":
                return getNotificationTemplate();
            case "processedDate":
                return getProcessedDate();
            case "programInstance":
                return getProgramInstance();
            case "programStageInstance":
                return getProgramStageInstance();
            case "publicAccess":
                return getPublicAccess();
            case "recipients":
                return getRecipients();
            case "sharing":
                return getSharing();
            case "storeCopy":
                return getStoreCopy();
            case "subject":
                return getSubject();
            case "text":
                return getText();
            case "translations":
                return getTranslations();
            case "user":
                return getUser();
            case "userAccesses":
                return getUserAccesses();
            case "userGroupAccesses":
                return getUserGroupAccesses();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ProgramMessage.NOT_FOUND_VALUE);
        if (ProgramMessage.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ProgramMessage with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ProgramMessage.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("attributeValues");
        sb.append('=');
        sb.append(((this.attributeValues == null)?"<null>":this.attributeValues));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("createdBy");
        sb.append('=');
        sb.append(((this.createdBy == null)?"<null>":this.createdBy));
        sb.append(',');
        sb.append("deliveryChannels");
        sb.append('=');
        sb.append(((this.deliveryChannels == null)?"<null>":this.deliveryChannels));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("favorite");
        sb.append('=');
        sb.append(((this.favorite == null)?"<null>":this.favorite));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("messageStatus");
        sb.append('=');
        sb.append(((this.messageStatus == null)?"<null>":this.messageStatus));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("notificationTemplate");
        sb.append('=');
        sb.append(((this.notificationTemplate == null)?"<null>":this.notificationTemplate));
        sb.append(',');
        sb.append("processedDate");
        sb.append('=');
        sb.append(((this.processedDate == null)?"<null>":this.processedDate));
        sb.append(',');
        sb.append("programInstance");
        sb.append('=');
        sb.append(((this.programInstance == null)?"<null>":this.programInstance));
        sb.append(',');
        sb.append("programStageInstance");
        sb.append('=');
        sb.append(((this.programStageInstance == null)?"<null>":this.programStageInstance));
        sb.append(',');
        sb.append("publicAccess");
        sb.append('=');
        sb.append(((this.publicAccess == null)?"<null>":this.publicAccess));
        sb.append(',');
        sb.append("recipients");
        sb.append('=');
        sb.append(((this.recipients == null)?"<null>":this.recipients));
        sb.append(',');
        sb.append("sharing");
        sb.append('=');
        sb.append(((this.sharing == null)?"<null>":this.sharing));
        sb.append(',');
        sb.append("storeCopy");
        sb.append('=');
        sb.append(((this.storeCopy == null)?"<null>":this.storeCopy));
        sb.append(',');
        sb.append("subject");
        sb.append('=');
        sb.append(((this.subject == null)?"<null>":this.subject));
        sb.append(',');
        sb.append("text");
        sb.append('=');
        sb.append(((this.text == null)?"<null>":this.text));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.publicAccess == null)? 0 :this.publicAccess.hashCode()));
        result = ((result* 31)+((this.subject == null)? 0 :this.subject.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.processedDate == null)? 0 :this.processedDate.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.text == null)? 0 :this.text.hashCode()));
        result = ((result* 31)+((this.notificationTemplate == null)? 0 :this.notificationTemplate.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.programStageInstance == null)? 0 :this.programStageInstance.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.deliveryChannels == null)? 0 :this.deliveryChannels.hashCode()));
        result = ((result* 31)+((this.storeCopy == null)? 0 :this.storeCopy.hashCode()));
        result = ((result* 31)+((this.attributeValues == null)? 0 :this.attributeValues.hashCode()));
        result = ((result* 31)+((this.sharing == null)? 0 :this.sharing.hashCode()));
        result = ((result* 31)+((this.messageStatus == null)? 0 :this.messageStatus.hashCode()));
        result = ((result* 31)+((this.programInstance == null)? 0 :this.programInstance.hashCode()));
        result = ((result* 31)+((this.createdBy == null)? 0 :this.createdBy.hashCode()));
        result = ((result* 31)+((this.recipients == null)? 0 :this.recipients.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.favorite == null)? 0 :this.favorite.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ProgramMessage) == false) {
            return false;
        }
        ProgramMessage rhs = ((ProgramMessage) other);
        return ((((((((((((((((((((((((((((((((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites)))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.publicAccess == rhs.publicAccess)||((this.publicAccess!= null)&&this.publicAccess.equals(rhs.publicAccess))))&&((this.subject == rhs.subject)||((this.subject!= null)&&this.subject.equals(rhs.subject))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.processedDate == rhs.processedDate)||((this.processedDate!= null)&&this.processedDate.equals(rhs.processedDate))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.text == rhs.text)||((this.text!= null)&&this.text.equals(rhs.text))))&&((this.notificationTemplate == rhs.notificationTemplate)||((this.notificationTemplate!= null)&&this.notificationTemplate.equals(rhs.notificationTemplate))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.programStageInstance == rhs.programStageInstance)||((this.programStageInstance!= null)&&this.programStageInstance.equals(rhs.programStageInstance))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.deliveryChannels == rhs.deliveryChannels)||((this.deliveryChannels!= null)&&this.deliveryChannels.equals(rhs.deliveryChannels))))&&((this.storeCopy == rhs.storeCopy)||((this.storeCopy!= null)&&this.storeCopy.equals(rhs.storeCopy))))&&((this.attributeValues == rhs.attributeValues)||((this.attributeValues!= null)&&this.attributeValues.equals(rhs.attributeValues))))&&((this.sharing == rhs.sharing)||((this.sharing!= null)&&this.sharing.equals(rhs.sharing))))&&((this.messageStatus == rhs.messageStatus)||((this.messageStatus!= null)&&this.messageStatus.equals(rhs.messageStatus))))&&((this.programInstance == rhs.programInstance)||((this.programInstance!= null)&&this.programInstance.equals(rhs.programInstance))))&&((this.createdBy == rhs.createdBy)||((this.createdBy!= null)&&this.createdBy.equals(rhs.createdBy))))&&((this.recipients == rhs.recipients)||((this.recipients!= null)&&this.recipients.equals(rhs.recipients))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.favorite == rhs.favorite)||((this.favorite!= null)&&this.favorite.equals(rhs.favorite))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))));
    }

    @Generated("jsonschema2pojo")
    public enum ProgramMessageStatus {

        SENT("SENT"),
        FAILED("FAILED"),
        SCHEDULED("SCHEDULED"),
        OUTBOUND("OUTBOUND");
        private final String value;
        private final static Map<String, ProgramMessage.ProgramMessageStatus> CONSTANTS = new HashMap<String, ProgramMessage.ProgramMessageStatus>();

        static {
            for (ProgramMessage.ProgramMessageStatus c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ProgramMessageStatus(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ProgramMessage.ProgramMessageStatus fromValue(String value) {
            ProgramMessage.ProgramMessageStatus constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
