
package org.hisp.dhis.api.model.v2_37_7;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "accessLevel",
    "attributeValues",
    "categoryCombo",
    "code",
    "completeEventsExpiryDays",
    "created",
    "createdBy",
    "dataEntryForm",
    "description",
    "displayDescription",
    "displayEnrollmentDateLabel",
    "displayFormName",
    "displayFrontPageList",
    "displayIncidentDate",
    "displayIncidentDateLabel",
    "displayName",
    "displayShortName",
    "enrollmentDateLabel",
    "expiryDays",
    "expiryPeriodType",
    "externalAccess",
    "favorite",
    "favorites",
    "featureType",
    "formName",
    "href",
    "id",
    "ignoreOverdueEvents",
    "incidentDateLabel",
    "lastUpdated",
    "lastUpdatedBy",
    "maxTeiCountToReturn",
    "minAttributesRequiredToSearch",
    "name",
    "notificationTemplates",
    "onlyEnrollOnce",
    "organisationUnits",
    "programIndicators",
    "programRuleVariables",
    "programSections",
    "programStages",
    "programTrackedEntityAttributes",
    "programType",
    "publicAccess",
    "registration",
    "relatedProgram",
    "selectEnrollmentDatesInFuture",
    "selectIncidentDatesInFuture",
    "sharing",
    "shortName",
    "skipOffline",
    "style",
    "trackedEntityType",
    "translations",
    "useFirstStageDuringRegistration",
    "user",
    "userAccesses",
    "userGroupAccesses",
    "userRoles",
    "version",
    "withoutRegistration"
})
@Generated("jsonschema2pojo")
public class Program implements Serializable
{

    @JsonProperty("access")
    private Access access;
    @JsonProperty("accessLevel")
    private AccessLevel accessLevel;
    @JsonProperty("attributeValues")
    private List<AttributeValue> attributeValues = null;
    @JsonProperty("categoryCombo")
    private CategoryCombo categoryCombo;
    @JsonProperty("code")
    private String code;
    @JsonProperty("completeEventsExpiryDays")
    private Integer completeEventsExpiryDays;
    @JsonProperty("created")
    private Date created;
    @JsonProperty("createdBy")
    private User createdBy;
    @JsonProperty("dataEntryForm")
    private DataEntryForm dataEntryForm;
    @JsonProperty("description")
    private String description;
    @JsonProperty("displayDescription")
    private String displayDescription;
    @JsonProperty("displayEnrollmentDateLabel")
    private String displayEnrollmentDateLabel;
    @JsonProperty("displayFormName")
    private String displayFormName;
    @JsonProperty("displayFrontPageList")
    private Boolean displayFrontPageList;
    @JsonProperty("displayIncidentDate")
    private Boolean displayIncidentDate;
    @JsonProperty("displayIncidentDateLabel")
    private String displayIncidentDateLabel;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("displayShortName")
    private String displayShortName;
    @JsonProperty("enrollmentDateLabel")
    private String enrollmentDateLabel;
    @JsonProperty("expiryDays")
    private Integer expiryDays;
    /**
     * Undefined
     * 
     */
    @JsonProperty("expiryPeriodType")
    private Object expiryPeriodType;
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    @JsonProperty("favorite")
    private Boolean favorite;
    @JsonProperty("favorites")
    private List<String> favorites = null;
    @JsonProperty("featureType")
    private ProgramStage.FeatureType featureType;
    @JsonProperty("formName")
    private String formName;
    @JsonProperty("href")
    private String href;
    @JsonProperty("id")
    private String id;
    @JsonProperty("ignoreOverdueEvents")
    private Boolean ignoreOverdueEvents;
    @JsonProperty("incidentDateLabel")
    private String incidentDateLabel;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    @JsonProperty("lastUpdatedBy")
    private User lastUpdatedBy;
    @JsonProperty("maxTeiCountToReturn")
    private Integer maxTeiCountToReturn;
    @JsonProperty("minAttributesRequiredToSearch")
    private Integer minAttributesRequiredToSearch;
    @JsonProperty("name")
    private String name;
    @JsonProperty("notificationTemplates")
    private List<ProgramNotificationTemplate> notificationTemplates = null;
    @JsonProperty("onlyEnrollOnce")
    private Boolean onlyEnrollOnce;
    @JsonProperty("organisationUnits")
    private List<OrganisationUnit> organisationUnits = null;
    @JsonProperty("programIndicators")
    private List<ProgramIndicator> programIndicators = null;
    @JsonProperty("programRuleVariables")
    private List<ProgramRuleVariable> programRuleVariables = null;
    @JsonProperty("programSections")
    private List<ProgramSection> programSections = null;
    @JsonProperty("programStages")
    private List<ProgramStage> programStages = null;
    @JsonProperty("programTrackedEntityAttributes")
    private List<ProgramTrackedEntityAttribute> programTrackedEntityAttributes = null;
    @JsonProperty("programType")
    private Program.ProgramType programType;
    @JsonProperty("publicAccess")
    private String publicAccess;
    @JsonProperty("registration")
    private Boolean registration;
    @JsonProperty("relatedProgram")
    private Program relatedProgram;
    @JsonProperty("selectEnrollmentDatesInFuture")
    private Boolean selectEnrollmentDatesInFuture;
    @JsonProperty("selectIncidentDatesInFuture")
    private Boolean selectIncidentDatesInFuture;
    @JsonProperty("sharing")
    private Sharing sharing;
    @JsonProperty("shortName")
    private String shortName;
    @JsonProperty("skipOffline")
    private Boolean skipOffline;
    @JsonProperty("style")
    private ObjectStyle style;
    @JsonProperty("trackedEntityType")
    private TrackedEntityType trackedEntityType;
    @JsonProperty("translations")
    private List<Translation> translations = null;
    @JsonProperty("useFirstStageDuringRegistration")
    private Boolean useFirstStageDuringRegistration;
    @JsonProperty("user")
    private User user;
    @JsonProperty("userAccesses")
    private List<UserAccess> userAccesses = null;
    @JsonProperty("userGroupAccesses")
    private List<UserGroupAccess> userGroupAccesses = null;
    @JsonProperty("userRoles")
    private List<UserAuthorityGroup> userRoles = null;
    @JsonProperty("version")
    private Integer version;
    @JsonProperty("withoutRegistration")
    private Boolean withoutRegistration;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 2103963229202667302L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Program() {
    }

    /**
     * 
     * @param source
     */
    public Program(Program source) {
        super();
        this.access = source.access;
        this.accessLevel = source.accessLevel;
        this.attributeValues = source.attributeValues;
        this.categoryCombo = source.categoryCombo;
        this.code = source.code;
        this.completeEventsExpiryDays = source.completeEventsExpiryDays;
        this.created = source.created;
        this.createdBy = source.createdBy;
        this.dataEntryForm = source.dataEntryForm;
        this.description = source.description;
        this.displayDescription = source.displayDescription;
        this.displayEnrollmentDateLabel = source.displayEnrollmentDateLabel;
        this.displayFormName = source.displayFormName;
        this.displayFrontPageList = source.displayFrontPageList;
        this.displayIncidentDate = source.displayIncidentDate;
        this.displayIncidentDateLabel = source.displayIncidentDateLabel;
        this.displayName = source.displayName;
        this.displayShortName = source.displayShortName;
        this.enrollmentDateLabel = source.enrollmentDateLabel;
        this.expiryDays = source.expiryDays;
        this.expiryPeriodType = source.expiryPeriodType;
        this.externalAccess = source.externalAccess;
        this.favorite = source.favorite;
        this.favorites = source.favorites;
        this.featureType = source.featureType;
        this.formName = source.formName;
        this.href = source.href;
        this.id = source.id;
        this.ignoreOverdueEvents = source.ignoreOverdueEvents;
        this.incidentDateLabel = source.incidentDateLabel;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.maxTeiCountToReturn = source.maxTeiCountToReturn;
        this.minAttributesRequiredToSearch = source.minAttributesRequiredToSearch;
        this.name = source.name;
        this.notificationTemplates = source.notificationTemplates;
        this.onlyEnrollOnce = source.onlyEnrollOnce;
        this.organisationUnits = source.organisationUnits;
        this.programIndicators = source.programIndicators;
        this.programRuleVariables = source.programRuleVariables;
        this.programSections = source.programSections;
        this.programStages = source.programStages;
        this.programTrackedEntityAttributes = source.programTrackedEntityAttributes;
        this.programType = source.programType;
        this.publicAccess = source.publicAccess;
        this.registration = source.registration;
        this.relatedProgram = source.relatedProgram;
        this.selectEnrollmentDatesInFuture = source.selectEnrollmentDatesInFuture;
        this.selectIncidentDatesInFuture = source.selectIncidentDatesInFuture;
        this.sharing = source.sharing;
        this.shortName = source.shortName;
        this.skipOffline = source.skipOffline;
        this.style = source.style;
        this.trackedEntityType = source.trackedEntityType;
        this.translations = source.translations;
        this.useFirstStageDuringRegistration = source.useFirstStageDuringRegistration;
        this.user = source.user;
        this.userAccesses = source.userAccesses;
        this.userGroupAccesses = source.userGroupAccesses;
        this.userRoles = source.userRoles;
        this.version = source.version;
        this.withoutRegistration = source.withoutRegistration;
    }

    /**
     * 
     * @param dataEntryForm
     * @param publicAccess
     * @param ignoreOverdueEvents
     * @param skipOffline
     * @param programIndicators
     * @param displayIncidentDateLabel
     * @param lastUpdated
     * @param categoryCombo
     * @param translations
     * @param href
     * @param id
     * @param displayDescription
     * @param enrollmentDateLabel
     * @param lastUpdatedBy
     * @param onlyEnrollOnce
     * @param userGroupAccesses
     * @param created
     * @param attributeValues
     * @param sharing
     * @param displayFormName
     * @param version
     * @param displayEnrollmentDateLabel
     * @param maxTeiCountToReturn
     * @param selectIncidentDatesInFuture
     * @param incidentDateLabel
     * @param userRoles
     * @param expiryPeriodType
     * @param userAccesses
     * @param name
     * @param selectEnrollmentDatesInFuture
     * @param registration
     * @param style
     * @param shortName
     * @param favorite
     * @param useFirstStageDuringRegistration
     * @param favorites
     * @param access
     * @param code
     * @param programRuleVariables
     * @param displayName
     * @param programTrackedEntityAttributes
     * @param completeEventsExpiryDays
     * @param description
     * @param relatedProgram
     * @param displayShortName
     * @param externalAccess
     * @param withoutRegistration
     * @param notificationTemplates
     * @param formName
     * @param featureType
     * @param minAttributesRequiredToSearch
     * @param displayFrontPageList
     * @param organisationUnits
     * @param programType
     * @param accessLevel
     * @param programSections
     * @param programStages
     * @param createdBy
     * @param trackedEntityType
     * @param displayIncidentDate
     * @param expiryDays
     * @param user
     */
    public Program(Access access, AccessLevel accessLevel, List<AttributeValue> attributeValues, CategoryCombo categoryCombo, String code, Integer completeEventsExpiryDays, Date created, User createdBy, DataEntryForm dataEntryForm, String description, String displayDescription, String displayEnrollmentDateLabel, String displayFormName, Boolean displayFrontPageList, Boolean displayIncidentDate, String displayIncidentDateLabel, String displayName, String displayShortName, String enrollmentDateLabel, Integer expiryDays, Object expiryPeriodType, Boolean externalAccess, Boolean favorite, List<String> favorites, ProgramStage.FeatureType featureType, String formName, String href, String id, Boolean ignoreOverdueEvents, String incidentDateLabel, Date lastUpdated, User lastUpdatedBy, Integer maxTeiCountToReturn, Integer minAttributesRequiredToSearch, String name, List<ProgramNotificationTemplate> notificationTemplates, Boolean onlyEnrollOnce, List<OrganisationUnit> organisationUnits, List<ProgramIndicator> programIndicators, List<ProgramRuleVariable> programRuleVariables, List<ProgramSection> programSections, List<ProgramStage> programStages, List<ProgramTrackedEntityAttribute> programTrackedEntityAttributes, Program.ProgramType programType, String publicAccess, Boolean registration, Program relatedProgram, Boolean selectEnrollmentDatesInFuture, Boolean selectIncidentDatesInFuture, Sharing sharing, String shortName, Boolean skipOffline, ObjectStyle style, TrackedEntityType trackedEntityType, List<Translation> translations, Boolean useFirstStageDuringRegistration, User user, List<UserAccess> userAccesses, List<UserGroupAccess> userGroupAccesses, List<UserAuthorityGroup> userRoles, Integer version, Boolean withoutRegistration) {
        super();
        this.access = access;
        this.accessLevel = accessLevel;
        this.attributeValues = attributeValues;
        this.categoryCombo = categoryCombo;
        this.code = code;
        this.completeEventsExpiryDays = completeEventsExpiryDays;
        this.created = created;
        this.createdBy = createdBy;
        this.dataEntryForm = dataEntryForm;
        this.description = description;
        this.displayDescription = displayDescription;
        this.displayEnrollmentDateLabel = displayEnrollmentDateLabel;
        this.displayFormName = displayFormName;
        this.displayFrontPageList = displayFrontPageList;
        this.displayIncidentDate = displayIncidentDate;
        this.displayIncidentDateLabel = displayIncidentDateLabel;
        this.displayName = displayName;
        this.displayShortName = displayShortName;
        this.enrollmentDateLabel = enrollmentDateLabel;
        this.expiryDays = expiryDays;
        this.expiryPeriodType = expiryPeriodType;
        this.externalAccess = externalAccess;
        this.favorite = favorite;
        this.favorites = favorites;
        this.featureType = featureType;
        this.formName = formName;
        this.href = href;
        this.id = id;
        this.ignoreOverdueEvents = ignoreOverdueEvents;
        this.incidentDateLabel = incidentDateLabel;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedBy = lastUpdatedBy;
        this.maxTeiCountToReturn = maxTeiCountToReturn;
        this.minAttributesRequiredToSearch = minAttributesRequiredToSearch;
        this.name = name;
        this.notificationTemplates = notificationTemplates;
        this.onlyEnrollOnce = onlyEnrollOnce;
        this.organisationUnits = organisationUnits;
        this.programIndicators = programIndicators;
        this.programRuleVariables = programRuleVariables;
        this.programSections = programSections;
        this.programStages = programStages;
        this.programTrackedEntityAttributes = programTrackedEntityAttributes;
        this.programType = programType;
        this.publicAccess = publicAccess;
        this.registration = registration;
        this.relatedProgram = relatedProgram;
        this.selectEnrollmentDatesInFuture = selectEnrollmentDatesInFuture;
        this.selectIncidentDatesInFuture = selectIncidentDatesInFuture;
        this.sharing = sharing;
        this.shortName = shortName;
        this.skipOffline = skipOffline;
        this.style = style;
        this.trackedEntityType = trackedEntityType;
        this.translations = translations;
        this.useFirstStageDuringRegistration = useFirstStageDuringRegistration;
        this.user = user;
        this.userAccesses = userAccesses;
        this.userGroupAccesses = userGroupAccesses;
        this.userRoles = userRoles;
        this.version = version;
        this.withoutRegistration = withoutRegistration;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public Program withAccess(Access access) {
        this.access = access;
        return this;
    }

    @JsonProperty("accessLevel")
    public Optional<AccessLevel> getAccessLevel() {
        return Optional.ofNullable(accessLevel);
    }

    @JsonProperty("accessLevel")
    public void setAccessLevel(AccessLevel accessLevel) {
        this.accessLevel = accessLevel;
    }

    public Program withAccessLevel(AccessLevel accessLevel) {
        this.accessLevel = accessLevel;
        return this;
    }

    @JsonProperty("attributeValues")
    public Optional<List<AttributeValue>> getAttributeValues() {
        return Optional.ofNullable(attributeValues);
    }

    @JsonProperty("attributeValues")
    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public Program withAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    @JsonProperty("categoryCombo")
    public Optional<CategoryCombo> getCategoryCombo() {
        return Optional.ofNullable(categoryCombo);
    }

    @JsonProperty("categoryCombo")
    public void setCategoryCombo(CategoryCombo categoryCombo) {
        this.categoryCombo = categoryCombo;
    }

    public Program withCategoryCombo(CategoryCombo categoryCombo) {
        this.categoryCombo = categoryCombo;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public Program withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("completeEventsExpiryDays")
    public Optional<Integer> getCompleteEventsExpiryDays() {
        return Optional.ofNullable(completeEventsExpiryDays);
    }

    @JsonProperty("completeEventsExpiryDays")
    public void setCompleteEventsExpiryDays(Integer completeEventsExpiryDays) {
        this.completeEventsExpiryDays = completeEventsExpiryDays;
    }

    public Program withCompleteEventsExpiryDays(Integer completeEventsExpiryDays) {
        this.completeEventsExpiryDays = completeEventsExpiryDays;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public Program withCreated(Date created) {
        this.created = created;
        return this;
    }

    @JsonProperty("createdBy")
    public Optional<User> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    @JsonProperty("createdBy")
    public void setCreatedBy(User createdBy) {
        this.createdBy = createdBy;
    }

    public Program withCreatedBy(User createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @JsonProperty("dataEntryForm")
    public Optional<DataEntryForm> getDataEntryForm() {
        return Optional.ofNullable(dataEntryForm);
    }

    @JsonProperty("dataEntryForm")
    public void setDataEntryForm(DataEntryForm dataEntryForm) {
        this.dataEntryForm = dataEntryForm;
    }

    public Program withDataEntryForm(DataEntryForm dataEntryForm) {
        this.dataEntryForm = dataEntryForm;
        return this;
    }

    @JsonProperty("description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    public Program withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty("displayDescription")
    public Optional<String> getDisplayDescription() {
        return Optional.ofNullable(displayDescription);
    }

    @JsonProperty("displayDescription")
    public void setDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
    }

    public Program withDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
        return this;
    }

    @JsonProperty("displayEnrollmentDateLabel")
    public Optional<String> getDisplayEnrollmentDateLabel() {
        return Optional.ofNullable(displayEnrollmentDateLabel);
    }

    @JsonProperty("displayEnrollmentDateLabel")
    public void setDisplayEnrollmentDateLabel(String displayEnrollmentDateLabel) {
        this.displayEnrollmentDateLabel = displayEnrollmentDateLabel;
    }

    public Program withDisplayEnrollmentDateLabel(String displayEnrollmentDateLabel) {
        this.displayEnrollmentDateLabel = displayEnrollmentDateLabel;
        return this;
    }

    @JsonProperty("displayFormName")
    public Optional<String> getDisplayFormName() {
        return Optional.ofNullable(displayFormName);
    }

    @JsonProperty("displayFormName")
    public void setDisplayFormName(String displayFormName) {
        this.displayFormName = displayFormName;
    }

    public Program withDisplayFormName(String displayFormName) {
        this.displayFormName = displayFormName;
        return this;
    }

    @JsonProperty("displayFrontPageList")
    public Optional<Boolean> getDisplayFrontPageList() {
        return Optional.ofNullable(displayFrontPageList);
    }

    @JsonProperty("displayFrontPageList")
    public void setDisplayFrontPageList(Boolean displayFrontPageList) {
        this.displayFrontPageList = displayFrontPageList;
    }

    public Program withDisplayFrontPageList(Boolean displayFrontPageList) {
        this.displayFrontPageList = displayFrontPageList;
        return this;
    }

    @JsonProperty("displayIncidentDate")
    public Optional<Boolean> getDisplayIncidentDate() {
        return Optional.ofNullable(displayIncidentDate);
    }

    @JsonProperty("displayIncidentDate")
    public void setDisplayIncidentDate(Boolean displayIncidentDate) {
        this.displayIncidentDate = displayIncidentDate;
    }

    public Program withDisplayIncidentDate(Boolean displayIncidentDate) {
        this.displayIncidentDate = displayIncidentDate;
        return this;
    }

    @JsonProperty("displayIncidentDateLabel")
    public Optional<String> getDisplayIncidentDateLabel() {
        return Optional.ofNullable(displayIncidentDateLabel);
    }

    @JsonProperty("displayIncidentDateLabel")
    public void setDisplayIncidentDateLabel(String displayIncidentDateLabel) {
        this.displayIncidentDateLabel = displayIncidentDateLabel;
    }

    public Program withDisplayIncidentDateLabel(String displayIncidentDateLabel) {
        this.displayIncidentDateLabel = displayIncidentDateLabel;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Program withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("displayShortName")
    public Optional<String> getDisplayShortName() {
        return Optional.ofNullable(displayShortName);
    }

    @JsonProperty("displayShortName")
    public void setDisplayShortName(String displayShortName) {
        this.displayShortName = displayShortName;
    }

    public Program withDisplayShortName(String displayShortName) {
        this.displayShortName = displayShortName;
        return this;
    }

    @JsonProperty("enrollmentDateLabel")
    public Optional<String> getEnrollmentDateLabel() {
        return Optional.ofNullable(enrollmentDateLabel);
    }

    @JsonProperty("enrollmentDateLabel")
    public void setEnrollmentDateLabel(String enrollmentDateLabel) {
        this.enrollmentDateLabel = enrollmentDateLabel;
    }

    public Program withEnrollmentDateLabel(String enrollmentDateLabel) {
        this.enrollmentDateLabel = enrollmentDateLabel;
        return this;
    }

    @JsonProperty("expiryDays")
    public Optional<Integer> getExpiryDays() {
        return Optional.ofNullable(expiryDays);
    }

    @JsonProperty("expiryDays")
    public void setExpiryDays(Integer expiryDays) {
        this.expiryDays = expiryDays;
    }

    public Program withExpiryDays(Integer expiryDays) {
        this.expiryDays = expiryDays;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("expiryPeriodType")
    public Optional<Object> getExpiryPeriodType() {
        return Optional.ofNullable(expiryPeriodType);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("expiryPeriodType")
    public void setExpiryPeriodType(Object expiryPeriodType) {
        this.expiryPeriodType = expiryPeriodType;
    }

    public Program withExpiryPeriodType(Object expiryPeriodType) {
        this.expiryPeriodType = expiryPeriodType;
        return this;
    }

    @JsonProperty("externalAccess")
    public Optional<Boolean> getExternalAccess() {
        return Optional.ofNullable(externalAccess);
    }

    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public Program withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    @JsonProperty("favorite")
    public Optional<Boolean> getFavorite() {
        return Optional.ofNullable(favorite);
    }

    @JsonProperty("favorite")
    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public Program withFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public Program withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    @JsonProperty("featureType")
    public Optional<ProgramStage.FeatureType> getFeatureType() {
        return Optional.ofNullable(featureType);
    }

    @JsonProperty("featureType")
    public void setFeatureType(ProgramStage.FeatureType featureType) {
        this.featureType = featureType;
    }

    public Program withFeatureType(ProgramStage.FeatureType featureType) {
        this.featureType = featureType;
        return this;
    }

    @JsonProperty("formName")
    public Optional<String> getFormName() {
        return Optional.ofNullable(formName);
    }

    @JsonProperty("formName")
    public void setFormName(String formName) {
        this.formName = formName;
    }

    public Program withFormName(String formName) {
        this.formName = formName;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public Program withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public Program withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("ignoreOverdueEvents")
    public Optional<Boolean> getIgnoreOverdueEvents() {
        return Optional.ofNullable(ignoreOverdueEvents);
    }

    @JsonProperty("ignoreOverdueEvents")
    public void setIgnoreOverdueEvents(Boolean ignoreOverdueEvents) {
        this.ignoreOverdueEvents = ignoreOverdueEvents;
    }

    public Program withIgnoreOverdueEvents(Boolean ignoreOverdueEvents) {
        this.ignoreOverdueEvents = ignoreOverdueEvents;
        return this;
    }

    @JsonProperty("incidentDateLabel")
    public Optional<String> getIncidentDateLabel() {
        return Optional.ofNullable(incidentDateLabel);
    }

    @JsonProperty("incidentDateLabel")
    public void setIncidentDateLabel(String incidentDateLabel) {
        this.incidentDateLabel = incidentDateLabel;
    }

    public Program withIncidentDateLabel(String incidentDateLabel) {
        this.incidentDateLabel = incidentDateLabel;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public Program withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    @JsonProperty("lastUpdatedBy")
    public Optional<User> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public Program withLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    @JsonProperty("maxTeiCountToReturn")
    public Optional<Integer> getMaxTeiCountToReturn() {
        return Optional.ofNullable(maxTeiCountToReturn);
    }

    @JsonProperty("maxTeiCountToReturn")
    public void setMaxTeiCountToReturn(Integer maxTeiCountToReturn) {
        this.maxTeiCountToReturn = maxTeiCountToReturn;
    }

    public Program withMaxTeiCountToReturn(Integer maxTeiCountToReturn) {
        this.maxTeiCountToReturn = maxTeiCountToReturn;
        return this;
    }

    @JsonProperty("minAttributesRequiredToSearch")
    public Optional<Integer> getMinAttributesRequiredToSearch() {
        return Optional.ofNullable(minAttributesRequiredToSearch);
    }

    @JsonProperty("minAttributesRequiredToSearch")
    public void setMinAttributesRequiredToSearch(Integer minAttributesRequiredToSearch) {
        this.minAttributesRequiredToSearch = minAttributesRequiredToSearch;
    }

    public Program withMinAttributesRequiredToSearch(Integer minAttributesRequiredToSearch) {
        this.minAttributesRequiredToSearch = minAttributesRequiredToSearch;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public Program withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("notificationTemplates")
    public Optional<List<ProgramNotificationTemplate>> getNotificationTemplates() {
        return Optional.ofNullable(notificationTemplates);
    }

    @JsonProperty("notificationTemplates")
    public void setNotificationTemplates(List<ProgramNotificationTemplate> notificationTemplates) {
        this.notificationTemplates = notificationTemplates;
    }

    public Program withNotificationTemplates(List<ProgramNotificationTemplate> notificationTemplates) {
        this.notificationTemplates = notificationTemplates;
        return this;
    }

    @JsonProperty("onlyEnrollOnce")
    public Optional<Boolean> getOnlyEnrollOnce() {
        return Optional.ofNullable(onlyEnrollOnce);
    }

    @JsonProperty("onlyEnrollOnce")
    public void setOnlyEnrollOnce(Boolean onlyEnrollOnce) {
        this.onlyEnrollOnce = onlyEnrollOnce;
    }

    public Program withOnlyEnrollOnce(Boolean onlyEnrollOnce) {
        this.onlyEnrollOnce = onlyEnrollOnce;
        return this;
    }

    @JsonProperty("organisationUnits")
    public Optional<List<OrganisationUnit>> getOrganisationUnits() {
        return Optional.ofNullable(organisationUnits);
    }

    @JsonProperty("organisationUnits")
    public void setOrganisationUnits(List<OrganisationUnit> organisationUnits) {
        this.organisationUnits = organisationUnits;
    }

    public Program withOrganisationUnits(List<OrganisationUnit> organisationUnits) {
        this.organisationUnits = organisationUnits;
        return this;
    }

    @JsonProperty("programIndicators")
    public Optional<List<ProgramIndicator>> getProgramIndicators() {
        return Optional.ofNullable(programIndicators);
    }

    @JsonProperty("programIndicators")
    public void setProgramIndicators(List<ProgramIndicator> programIndicators) {
        this.programIndicators = programIndicators;
    }

    public Program withProgramIndicators(List<ProgramIndicator> programIndicators) {
        this.programIndicators = programIndicators;
        return this;
    }

    @JsonProperty("programRuleVariables")
    public Optional<List<ProgramRuleVariable>> getProgramRuleVariables() {
        return Optional.ofNullable(programRuleVariables);
    }

    @JsonProperty("programRuleVariables")
    public void setProgramRuleVariables(List<ProgramRuleVariable> programRuleVariables) {
        this.programRuleVariables = programRuleVariables;
    }

    public Program withProgramRuleVariables(List<ProgramRuleVariable> programRuleVariables) {
        this.programRuleVariables = programRuleVariables;
        return this;
    }

    @JsonProperty("programSections")
    public Optional<List<ProgramSection>> getProgramSections() {
        return Optional.ofNullable(programSections);
    }

    @JsonProperty("programSections")
    public void setProgramSections(List<ProgramSection> programSections) {
        this.programSections = programSections;
    }

    public Program withProgramSections(List<ProgramSection> programSections) {
        this.programSections = programSections;
        return this;
    }

    @JsonProperty("programStages")
    public Optional<List<ProgramStage>> getProgramStages() {
        return Optional.ofNullable(programStages);
    }

    @JsonProperty("programStages")
    public void setProgramStages(List<ProgramStage> programStages) {
        this.programStages = programStages;
    }

    public Program withProgramStages(List<ProgramStage> programStages) {
        this.programStages = programStages;
        return this;
    }

    @JsonProperty("programTrackedEntityAttributes")
    public Optional<List<ProgramTrackedEntityAttribute>> getProgramTrackedEntityAttributes() {
        return Optional.ofNullable(programTrackedEntityAttributes);
    }

    @JsonProperty("programTrackedEntityAttributes")
    public void setProgramTrackedEntityAttributes(List<ProgramTrackedEntityAttribute> programTrackedEntityAttributes) {
        this.programTrackedEntityAttributes = programTrackedEntityAttributes;
    }

    public Program withProgramTrackedEntityAttributes(List<ProgramTrackedEntityAttribute> programTrackedEntityAttributes) {
        this.programTrackedEntityAttributes = programTrackedEntityAttributes;
        return this;
    }

    @JsonProperty("programType")
    public Optional<Program.ProgramType> getProgramType() {
        return Optional.ofNullable(programType);
    }

    @JsonProperty("programType")
    public void setProgramType(Program.ProgramType programType) {
        this.programType = programType;
    }

    public Program withProgramType(Program.ProgramType programType) {
        this.programType = programType;
        return this;
    }

    @JsonProperty("publicAccess")
    public Optional<String> getPublicAccess() {
        return Optional.ofNullable(publicAccess);
    }

    @JsonProperty("publicAccess")
    public void setPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
    }

    public Program withPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    @JsonProperty("registration")
    public Optional<Boolean> getRegistration() {
        return Optional.ofNullable(registration);
    }

    @JsonProperty("registration")
    public void setRegistration(Boolean registration) {
        this.registration = registration;
    }

    public Program withRegistration(Boolean registration) {
        this.registration = registration;
        return this;
    }

    @JsonProperty("relatedProgram")
    public Optional<Program> getRelatedProgram() {
        return Optional.ofNullable(relatedProgram);
    }

    @JsonProperty("relatedProgram")
    public void setRelatedProgram(Program relatedProgram) {
        this.relatedProgram = relatedProgram;
    }

    public Program withRelatedProgram(Program relatedProgram) {
        this.relatedProgram = relatedProgram;
        return this;
    }

    @JsonProperty("selectEnrollmentDatesInFuture")
    public Optional<Boolean> getSelectEnrollmentDatesInFuture() {
        return Optional.ofNullable(selectEnrollmentDatesInFuture);
    }

    @JsonProperty("selectEnrollmentDatesInFuture")
    public void setSelectEnrollmentDatesInFuture(Boolean selectEnrollmentDatesInFuture) {
        this.selectEnrollmentDatesInFuture = selectEnrollmentDatesInFuture;
    }

    public Program withSelectEnrollmentDatesInFuture(Boolean selectEnrollmentDatesInFuture) {
        this.selectEnrollmentDatesInFuture = selectEnrollmentDatesInFuture;
        return this;
    }

    @JsonProperty("selectIncidentDatesInFuture")
    public Optional<Boolean> getSelectIncidentDatesInFuture() {
        return Optional.ofNullable(selectIncidentDatesInFuture);
    }

    @JsonProperty("selectIncidentDatesInFuture")
    public void setSelectIncidentDatesInFuture(Boolean selectIncidentDatesInFuture) {
        this.selectIncidentDatesInFuture = selectIncidentDatesInFuture;
    }

    public Program withSelectIncidentDatesInFuture(Boolean selectIncidentDatesInFuture) {
        this.selectIncidentDatesInFuture = selectIncidentDatesInFuture;
        return this;
    }

    @JsonProperty("sharing")
    public Optional<Sharing> getSharing() {
        return Optional.ofNullable(sharing);
    }

    @JsonProperty("sharing")
    public void setSharing(Sharing sharing) {
        this.sharing = sharing;
    }

    public Program withSharing(Sharing sharing) {
        this.sharing = sharing;
        return this;
    }

    @JsonProperty("shortName")
    public Optional<String> getShortName() {
        return Optional.ofNullable(shortName);
    }

    @JsonProperty("shortName")
    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public Program withShortName(String shortName) {
        this.shortName = shortName;
        return this;
    }

    @JsonProperty("skipOffline")
    public Optional<Boolean> getSkipOffline() {
        return Optional.ofNullable(skipOffline);
    }

    @JsonProperty("skipOffline")
    public void setSkipOffline(Boolean skipOffline) {
        this.skipOffline = skipOffline;
    }

    public Program withSkipOffline(Boolean skipOffline) {
        this.skipOffline = skipOffline;
        return this;
    }

    @JsonProperty("style")
    public Optional<ObjectStyle> getStyle() {
        return Optional.ofNullable(style);
    }

    @JsonProperty("style")
    public void setStyle(ObjectStyle style) {
        this.style = style;
    }

    public Program withStyle(ObjectStyle style) {
        this.style = style;
        return this;
    }

    @JsonProperty("trackedEntityType")
    public Optional<TrackedEntityType> getTrackedEntityType() {
        return Optional.ofNullable(trackedEntityType);
    }

    @JsonProperty("trackedEntityType")
    public void setTrackedEntityType(TrackedEntityType trackedEntityType) {
        this.trackedEntityType = trackedEntityType;
    }

    public Program withTrackedEntityType(TrackedEntityType trackedEntityType) {
        this.trackedEntityType = trackedEntityType;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public Program withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    @JsonProperty("useFirstStageDuringRegistration")
    public Optional<Boolean> getUseFirstStageDuringRegistration() {
        return Optional.ofNullable(useFirstStageDuringRegistration);
    }

    @JsonProperty("useFirstStageDuringRegistration")
    public void setUseFirstStageDuringRegistration(Boolean useFirstStageDuringRegistration) {
        this.useFirstStageDuringRegistration = useFirstStageDuringRegistration;
    }

    public Program withUseFirstStageDuringRegistration(Boolean useFirstStageDuringRegistration) {
        this.useFirstStageDuringRegistration = useFirstStageDuringRegistration;
        return this;
    }

    @JsonProperty("user")
    public Optional<User> getUser() {
        return Optional.ofNullable(user);
    }

    @JsonProperty("user")
    public void setUser(User user) {
        this.user = user;
    }

    public Program withUser(User user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<UserAccess>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public Program withUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<UserGroupAccess>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public Program withUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    @JsonProperty("userRoles")
    public Optional<List<UserAuthorityGroup>> getUserRoles() {
        return Optional.ofNullable(userRoles);
    }

    @JsonProperty("userRoles")
    public void setUserRoles(List<UserAuthorityGroup> userRoles) {
        this.userRoles = userRoles;
    }

    public Program withUserRoles(List<UserAuthorityGroup> userRoles) {
        this.userRoles = userRoles;
        return this;
    }

    @JsonProperty("version")
    public Optional<Integer> getVersion() {
        return Optional.ofNullable(version);
    }

    @JsonProperty("version")
    public void setVersion(Integer version) {
        this.version = version;
    }

    public Program withVersion(Integer version) {
        this.version = version;
        return this;
    }

    @JsonProperty("withoutRegistration")
    public Optional<Boolean> getWithoutRegistration() {
        return Optional.ofNullable(withoutRegistration);
    }

    @JsonProperty("withoutRegistration")
    public void setWithoutRegistration(Boolean withoutRegistration) {
        this.withoutRegistration = withoutRegistration;
    }

    public Program withWithoutRegistration(Boolean withoutRegistration) {
        this.withoutRegistration = withoutRegistration;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Program withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "access":
                if (value instanceof Access) {
                    setAccess(((Access) value));
                } else {
                    throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v2_37_7.Access\", but got "+ value.getClass().toString()));
                }
                return true;
            case "accessLevel":
                if (value instanceof AccessLevel) {
                    setAccessLevel(((AccessLevel) value));
                } else {
                    throw new IllegalArgumentException(("property \"accessLevel\" is of type \"org.hisp.dhis.api.model.v2_37_7.AccessLevel\", but got "+ value.getClass().toString()));
                }
                return true;
            case "attributeValues":
                if (value instanceof List) {
                    setAttributeValues(((List<AttributeValue> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.AttributeValue>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "categoryCombo":
                if (value instanceof CategoryCombo) {
                    setCategoryCombo(((CategoryCombo) value));
                } else {
                    throw new IllegalArgumentException(("property \"categoryCombo\" is of type \"org.hisp.dhis.api.model.v2_37_7.CategoryCombo\", but got "+ value.getClass().toString()));
                }
                return true;
            case "code":
                if (value instanceof String) {
                    setCode(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "completeEventsExpiryDays":
                if (value instanceof Integer) {
                    setCompleteEventsExpiryDays(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"completeEventsExpiryDays\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "created":
                if (value instanceof Date) {
                    setCreated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "createdBy":
                if (value instanceof User) {
                    setCreatedBy(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"createdBy\" is of type \"org.hisp.dhis.api.model.v2_37_7.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataEntryForm":
                if (value instanceof DataEntryForm) {
                    setDataEntryForm(((DataEntryForm) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataEntryForm\" is of type \"org.hisp.dhis.api.model.v2_37_7.DataEntryForm\", but got "+ value.getClass().toString()));
                }
                return true;
            case "description":
                if (value instanceof String) {
                    setDescription(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"description\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayDescription":
                if (value instanceof String) {
                    setDisplayDescription(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayDescription\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayEnrollmentDateLabel":
                if (value instanceof String) {
                    setDisplayEnrollmentDateLabel(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayEnrollmentDateLabel\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayFormName":
                if (value instanceof String) {
                    setDisplayFormName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayFormName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayFrontPageList":
                if (value instanceof Boolean) {
                    setDisplayFrontPageList(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayFrontPageList\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayIncidentDate":
                if (value instanceof Boolean) {
                    setDisplayIncidentDate(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayIncidentDate\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayIncidentDateLabel":
                if (value instanceof String) {
                    setDisplayIncidentDateLabel(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayIncidentDateLabel\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayName":
                if (value instanceof String) {
                    setDisplayName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayShortName":
                if (value instanceof String) {
                    setDisplayShortName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayShortName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "enrollmentDateLabel":
                if (value instanceof String) {
                    setEnrollmentDateLabel(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"enrollmentDateLabel\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "expiryDays":
                if (value instanceof Integer) {
                    setExpiryDays(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"expiryDays\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "expiryPeriodType":
                if (value instanceof Object) {
                    setExpiryPeriodType(((Object) value));
                } else {
                    throw new IllegalArgumentException(("property \"expiryPeriodType\" is of type \"java.lang.Object\", but got "+ value.getClass().toString()));
                }
                return true;
            case "externalAccess":
                if (value instanceof Boolean) {
                    setExternalAccess(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "favorite":
                if (value instanceof Boolean) {
                    setFavorite(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"favorite\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "favorites":
                if (value instanceof List) {
                    setFavorites(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "featureType":
                if (value instanceof ProgramStage.FeatureType) {
                    setFeatureType(((ProgramStage.FeatureType) value));
                } else {
                    throw new IllegalArgumentException(("property \"featureType\" is of type \"org.hisp.dhis.api.model.v2_37_7.ProgramStage.FeatureType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "formName":
                if (value instanceof String) {
                    setFormName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"formName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "href":
                if (value instanceof String) {
                    setHref(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "id":
                if (value instanceof String) {
                    setId(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "ignoreOverdueEvents":
                if (value instanceof Boolean) {
                    setIgnoreOverdueEvents(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"ignoreOverdueEvents\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "incidentDateLabel":
                if (value instanceof String) {
                    setIncidentDateLabel(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"incidentDateLabel\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdated":
                if (value instanceof Date) {
                    setLastUpdated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdatedBy":
                if (value instanceof User) {
                    setLastUpdatedBy(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"org.hisp.dhis.api.model.v2_37_7.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "maxTeiCountToReturn":
                if (value instanceof Integer) {
                    setMaxTeiCountToReturn(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"maxTeiCountToReturn\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "minAttributesRequiredToSearch":
                if (value instanceof Integer) {
                    setMinAttributesRequiredToSearch(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"minAttributesRequiredToSearch\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "name":
                if (value instanceof String) {
                    setName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "notificationTemplates":
                if (value instanceof List) {
                    setNotificationTemplates(((List<ProgramNotificationTemplate> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"notificationTemplates\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.ProgramNotificationTemplate>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "onlyEnrollOnce":
                if (value instanceof Boolean) {
                    setOnlyEnrollOnce(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"onlyEnrollOnce\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "organisationUnits":
                if (value instanceof List) {
                    setOrganisationUnits(((List<OrganisationUnit> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"organisationUnits\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.OrganisationUnit>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "programIndicators":
                if (value instanceof List) {
                    setProgramIndicators(((List<ProgramIndicator> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"programIndicators\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.ProgramIndicator>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "programRuleVariables":
                if (value instanceof List) {
                    setProgramRuleVariables(((List<ProgramRuleVariable> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"programRuleVariables\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.ProgramRuleVariable>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "programSections":
                if (value instanceof List) {
                    setProgramSections(((List<ProgramSection> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"programSections\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.ProgramSection>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "programStages":
                if (value instanceof List) {
                    setProgramStages(((List<ProgramStage> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"programStages\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.ProgramStage>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "programTrackedEntityAttributes":
                if (value instanceof List) {
                    setProgramTrackedEntityAttributes(((List<ProgramTrackedEntityAttribute> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"programTrackedEntityAttributes\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.ProgramTrackedEntityAttribute>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "programType":
                if (value instanceof Program.ProgramType) {
                    setProgramType(((Program.ProgramType) value));
                } else {
                    throw new IllegalArgumentException(("property \"programType\" is of type \"org.hisp.dhis.api.model.v2_37_7.Program.ProgramType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "publicAccess":
                if (value instanceof String) {
                    setPublicAccess(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"publicAccess\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "registration":
                if (value instanceof Boolean) {
                    setRegistration(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"registration\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "relatedProgram":
                if (value instanceof Program) {
                    setRelatedProgram(((Program) value));
                } else {
                    throw new IllegalArgumentException(("property \"relatedProgram\" is of type \"org.hisp.dhis.api.model.v2_37_7.Program\", but got "+ value.getClass().toString()));
                }
                return true;
            case "selectEnrollmentDatesInFuture":
                if (value instanceof Boolean) {
                    setSelectEnrollmentDatesInFuture(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"selectEnrollmentDatesInFuture\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "selectIncidentDatesInFuture":
                if (value instanceof Boolean) {
                    setSelectIncidentDatesInFuture(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"selectIncidentDatesInFuture\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "sharing":
                if (value instanceof Sharing) {
                    setSharing(((Sharing) value));
                } else {
                    throw new IllegalArgumentException(("property \"sharing\" is of type \"org.hisp.dhis.api.model.v2_37_7.Sharing\", but got "+ value.getClass().toString()));
                }
                return true;
            case "shortName":
                if (value instanceof String) {
                    setShortName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"shortName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "skipOffline":
                if (value instanceof Boolean) {
                    setSkipOffline(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"skipOffline\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "style":
                if (value instanceof ObjectStyle) {
                    setStyle(((ObjectStyle) value));
                } else {
                    throw new IllegalArgumentException(("property \"style\" is of type \"org.hisp.dhis.api.model.v2_37_7.ObjectStyle\", but got "+ value.getClass().toString()));
                }
                return true;
            case "trackedEntityType":
                if (value instanceof TrackedEntityType) {
                    setTrackedEntityType(((TrackedEntityType) value));
                } else {
                    throw new IllegalArgumentException(("property \"trackedEntityType\" is of type \"org.hisp.dhis.api.model.v2_37_7.TrackedEntityType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "translations":
                if (value instanceof List) {
                    setTranslations(((List<Translation> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.Translation>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "useFirstStageDuringRegistration":
                if (value instanceof Boolean) {
                    setUseFirstStageDuringRegistration(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"useFirstStageDuringRegistration\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "user":
                if (value instanceof User) {
                    setUser(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v2_37_7.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userAccesses":
                if (value instanceof List) {
                    setUserAccesses(((List<UserAccess> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.UserAccess>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userGroupAccesses":
                if (value instanceof List) {
                    setUserGroupAccesses(((List<UserGroupAccess> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.UserGroupAccess>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userRoles":
                if (value instanceof List) {
                    setUserRoles(((List<UserAuthorityGroup> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"userRoles\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.UserAuthorityGroup>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "version":
                if (value instanceof Integer) {
                    setVersion(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"version\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "withoutRegistration":
                if (value instanceof Boolean) {
                    setWithoutRegistration(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"withoutRegistration\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "access":
                return getAccess();
            case "accessLevel":
                return getAccessLevel();
            case "attributeValues":
                return getAttributeValues();
            case "categoryCombo":
                return getCategoryCombo();
            case "code":
                return getCode();
            case "completeEventsExpiryDays":
                return getCompleteEventsExpiryDays();
            case "created":
                return getCreated();
            case "createdBy":
                return getCreatedBy();
            case "dataEntryForm":
                return getDataEntryForm();
            case "description":
                return getDescription();
            case "displayDescription":
                return getDisplayDescription();
            case "displayEnrollmentDateLabel":
                return getDisplayEnrollmentDateLabel();
            case "displayFormName":
                return getDisplayFormName();
            case "displayFrontPageList":
                return getDisplayFrontPageList();
            case "displayIncidentDate":
                return getDisplayIncidentDate();
            case "displayIncidentDateLabel":
                return getDisplayIncidentDateLabel();
            case "displayName":
                return getDisplayName();
            case "displayShortName":
                return getDisplayShortName();
            case "enrollmentDateLabel":
                return getEnrollmentDateLabel();
            case "expiryDays":
                return getExpiryDays();
            case "expiryPeriodType":
                return getExpiryPeriodType();
            case "externalAccess":
                return getExternalAccess();
            case "favorite":
                return getFavorite();
            case "favorites":
                return getFavorites();
            case "featureType":
                return getFeatureType();
            case "formName":
                return getFormName();
            case "href":
                return getHref();
            case "id":
                return getId();
            case "ignoreOverdueEvents":
                return getIgnoreOverdueEvents();
            case "incidentDateLabel":
                return getIncidentDateLabel();
            case "lastUpdated":
                return getLastUpdated();
            case "lastUpdatedBy":
                return getLastUpdatedBy();
            case "maxTeiCountToReturn":
                return getMaxTeiCountToReturn();
            case "minAttributesRequiredToSearch":
                return getMinAttributesRequiredToSearch();
            case "name":
                return getName();
            case "notificationTemplates":
                return getNotificationTemplates();
            case "onlyEnrollOnce":
                return getOnlyEnrollOnce();
            case "organisationUnits":
                return getOrganisationUnits();
            case "programIndicators":
                return getProgramIndicators();
            case "programRuleVariables":
                return getProgramRuleVariables();
            case "programSections":
                return getProgramSections();
            case "programStages":
                return getProgramStages();
            case "programTrackedEntityAttributes":
                return getProgramTrackedEntityAttributes();
            case "programType":
                return getProgramType();
            case "publicAccess":
                return getPublicAccess();
            case "registration":
                return getRegistration();
            case "relatedProgram":
                return getRelatedProgram();
            case "selectEnrollmentDatesInFuture":
                return getSelectEnrollmentDatesInFuture();
            case "selectIncidentDatesInFuture":
                return getSelectIncidentDatesInFuture();
            case "sharing":
                return getSharing();
            case "shortName":
                return getShortName();
            case "skipOffline":
                return getSkipOffline();
            case "style":
                return getStyle();
            case "trackedEntityType":
                return getTrackedEntityType();
            case "translations":
                return getTranslations();
            case "useFirstStageDuringRegistration":
                return getUseFirstStageDuringRegistration();
            case "user":
                return getUser();
            case "userAccesses":
                return getUserAccesses();
            case "userGroupAccesses":
                return getUserGroupAccesses();
            case "userRoles":
                return getUserRoles();
            case "version":
                return getVersion();
            case "withoutRegistration":
                return getWithoutRegistration();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, Program.NOT_FOUND_VALUE);
        if (Program.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public Program with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Program.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("accessLevel");
        sb.append('=');
        sb.append(((this.accessLevel == null)?"<null>":this.accessLevel));
        sb.append(',');
        sb.append("attributeValues");
        sb.append('=');
        sb.append(((this.attributeValues == null)?"<null>":this.attributeValues));
        sb.append(',');
        sb.append("categoryCombo");
        sb.append('=');
        sb.append(((this.categoryCombo == null)?"<null>":this.categoryCombo));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("completeEventsExpiryDays");
        sb.append('=');
        sb.append(((this.completeEventsExpiryDays == null)?"<null>":this.completeEventsExpiryDays));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("createdBy");
        sb.append('=');
        sb.append(((this.createdBy == null)?"<null>":this.createdBy));
        sb.append(',');
        sb.append("dataEntryForm");
        sb.append('=');
        sb.append(((this.dataEntryForm == null)?"<null>":this.dataEntryForm));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("displayDescription");
        sb.append('=');
        sb.append(((this.displayDescription == null)?"<null>":this.displayDescription));
        sb.append(',');
        sb.append("displayEnrollmentDateLabel");
        sb.append('=');
        sb.append(((this.displayEnrollmentDateLabel == null)?"<null>":this.displayEnrollmentDateLabel));
        sb.append(',');
        sb.append("displayFormName");
        sb.append('=');
        sb.append(((this.displayFormName == null)?"<null>":this.displayFormName));
        sb.append(',');
        sb.append("displayFrontPageList");
        sb.append('=');
        sb.append(((this.displayFrontPageList == null)?"<null>":this.displayFrontPageList));
        sb.append(',');
        sb.append("displayIncidentDate");
        sb.append('=');
        sb.append(((this.displayIncidentDate == null)?"<null>":this.displayIncidentDate));
        sb.append(',');
        sb.append("displayIncidentDateLabel");
        sb.append('=');
        sb.append(((this.displayIncidentDateLabel == null)?"<null>":this.displayIncidentDateLabel));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("displayShortName");
        sb.append('=');
        sb.append(((this.displayShortName == null)?"<null>":this.displayShortName));
        sb.append(',');
        sb.append("enrollmentDateLabel");
        sb.append('=');
        sb.append(((this.enrollmentDateLabel == null)?"<null>":this.enrollmentDateLabel));
        sb.append(',');
        sb.append("expiryDays");
        sb.append('=');
        sb.append(((this.expiryDays == null)?"<null>":this.expiryDays));
        sb.append(',');
        sb.append("expiryPeriodType");
        sb.append('=');
        sb.append(((this.expiryPeriodType == null)?"<null>":this.expiryPeriodType));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("favorite");
        sb.append('=');
        sb.append(((this.favorite == null)?"<null>":this.favorite));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("featureType");
        sb.append('=');
        sb.append(((this.featureType == null)?"<null>":this.featureType));
        sb.append(',');
        sb.append("formName");
        sb.append('=');
        sb.append(((this.formName == null)?"<null>":this.formName));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("ignoreOverdueEvents");
        sb.append('=');
        sb.append(((this.ignoreOverdueEvents == null)?"<null>":this.ignoreOverdueEvents));
        sb.append(',');
        sb.append("incidentDateLabel");
        sb.append('=');
        sb.append(((this.incidentDateLabel == null)?"<null>":this.incidentDateLabel));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("maxTeiCountToReturn");
        sb.append('=');
        sb.append(((this.maxTeiCountToReturn == null)?"<null>":this.maxTeiCountToReturn));
        sb.append(',');
        sb.append("minAttributesRequiredToSearch");
        sb.append('=');
        sb.append(((this.minAttributesRequiredToSearch == null)?"<null>":this.minAttributesRequiredToSearch));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("notificationTemplates");
        sb.append('=');
        sb.append(((this.notificationTemplates == null)?"<null>":this.notificationTemplates));
        sb.append(',');
        sb.append("onlyEnrollOnce");
        sb.append('=');
        sb.append(((this.onlyEnrollOnce == null)?"<null>":this.onlyEnrollOnce));
        sb.append(',');
        sb.append("organisationUnits");
        sb.append('=');
        sb.append(((this.organisationUnits == null)?"<null>":this.organisationUnits));
        sb.append(',');
        sb.append("programIndicators");
        sb.append('=');
        sb.append(((this.programIndicators == null)?"<null>":this.programIndicators));
        sb.append(',');
        sb.append("programRuleVariables");
        sb.append('=');
        sb.append(((this.programRuleVariables == null)?"<null>":this.programRuleVariables));
        sb.append(',');
        sb.append("programSections");
        sb.append('=');
        sb.append(((this.programSections == null)?"<null>":this.programSections));
        sb.append(',');
        sb.append("programStages");
        sb.append('=');
        sb.append(((this.programStages == null)?"<null>":this.programStages));
        sb.append(',');
        sb.append("programTrackedEntityAttributes");
        sb.append('=');
        sb.append(((this.programTrackedEntityAttributes == null)?"<null>":this.programTrackedEntityAttributes));
        sb.append(',');
        sb.append("programType");
        sb.append('=');
        sb.append(((this.programType == null)?"<null>":this.programType));
        sb.append(',');
        sb.append("publicAccess");
        sb.append('=');
        sb.append(((this.publicAccess == null)?"<null>":this.publicAccess));
        sb.append(',');
        sb.append("registration");
        sb.append('=');
        sb.append(((this.registration == null)?"<null>":this.registration));
        sb.append(',');
        sb.append("relatedProgram");
        sb.append('=');
        sb.append(((this.relatedProgram == null)?"<null>":this.relatedProgram));
        sb.append(',');
        sb.append("selectEnrollmentDatesInFuture");
        sb.append('=');
        sb.append(((this.selectEnrollmentDatesInFuture == null)?"<null>":this.selectEnrollmentDatesInFuture));
        sb.append(',');
        sb.append("selectIncidentDatesInFuture");
        sb.append('=');
        sb.append(((this.selectIncidentDatesInFuture == null)?"<null>":this.selectIncidentDatesInFuture));
        sb.append(',');
        sb.append("sharing");
        sb.append('=');
        sb.append(((this.sharing == null)?"<null>":this.sharing));
        sb.append(',');
        sb.append("shortName");
        sb.append('=');
        sb.append(((this.shortName == null)?"<null>":this.shortName));
        sb.append(',');
        sb.append("skipOffline");
        sb.append('=');
        sb.append(((this.skipOffline == null)?"<null>":this.skipOffline));
        sb.append(',');
        sb.append("style");
        sb.append('=');
        sb.append(((this.style == null)?"<null>":this.style));
        sb.append(',');
        sb.append("trackedEntityType");
        sb.append('=');
        sb.append(((this.trackedEntityType == null)?"<null>":this.trackedEntityType));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("useFirstStageDuringRegistration");
        sb.append('=');
        sb.append(((this.useFirstStageDuringRegistration == null)?"<null>":this.useFirstStageDuringRegistration));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("userRoles");
        sb.append('=');
        sb.append(((this.userRoles == null)?"<null>":this.userRoles));
        sb.append(',');
        sb.append("version");
        sb.append('=');
        sb.append(((this.version == null)?"<null>":this.version));
        sb.append(',');
        sb.append("withoutRegistration");
        sb.append('=');
        sb.append(((this.withoutRegistration == null)?"<null>":this.withoutRegistration));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.dataEntryForm == null)? 0 :this.dataEntryForm.hashCode()));
        result = ((result* 31)+((this.publicAccess == null)? 0 :this.publicAccess.hashCode()));
        result = ((result* 31)+((this.ignoreOverdueEvents == null)? 0 :this.ignoreOverdueEvents.hashCode()));
        result = ((result* 31)+((this.skipOffline == null)? 0 :this.skipOffline.hashCode()));
        result = ((result* 31)+((this.programIndicators == null)? 0 :this.programIndicators.hashCode()));
        result = ((result* 31)+((this.displayIncidentDateLabel == null)? 0 :this.displayIncidentDateLabel.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.categoryCombo == null)? 0 :this.categoryCombo.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.displayDescription == null)? 0 :this.displayDescription.hashCode()));
        result = ((result* 31)+((this.enrollmentDateLabel == null)? 0 :this.enrollmentDateLabel.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.onlyEnrollOnce == null)? 0 :this.onlyEnrollOnce.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.attributeValues == null)? 0 :this.attributeValues.hashCode()));
        result = ((result* 31)+((this.sharing == null)? 0 :this.sharing.hashCode()));
        result = ((result* 31)+((this.displayFormName == null)? 0 :this.displayFormName.hashCode()));
        result = ((result* 31)+((this.version == null)? 0 :this.version.hashCode()));
        result = ((result* 31)+((this.displayEnrollmentDateLabel == null)? 0 :this.displayEnrollmentDateLabel.hashCode()));
        result = ((result* 31)+((this.maxTeiCountToReturn == null)? 0 :this.maxTeiCountToReturn.hashCode()));
        result = ((result* 31)+((this.selectIncidentDatesInFuture == null)? 0 :this.selectIncidentDatesInFuture.hashCode()));
        result = ((result* 31)+((this.incidentDateLabel == null)? 0 :this.incidentDateLabel.hashCode()));
        result = ((result* 31)+((this.userRoles == null)? 0 :this.userRoles.hashCode()));
        result = ((result* 31)+((this.expiryPeriodType == null)? 0 :this.expiryPeriodType.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.selectEnrollmentDatesInFuture == null)? 0 :this.selectEnrollmentDatesInFuture.hashCode()));
        result = ((result* 31)+((this.registration == null)? 0 :this.registration.hashCode()));
        result = ((result* 31)+((this.style == null)? 0 :this.style.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.shortName == null)? 0 :this.shortName.hashCode()));
        result = ((result* 31)+((this.favorite == null)? 0 :this.favorite.hashCode()));
        result = ((result* 31)+((this.useFirstStageDuringRegistration == null)? 0 :this.useFirstStageDuringRegistration.hashCode()));
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.programRuleVariables == null)? 0 :this.programRuleVariables.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.programTrackedEntityAttributes == null)? 0 :this.programTrackedEntityAttributes.hashCode()));
        result = ((result* 31)+((this.completeEventsExpiryDays == null)? 0 :this.completeEventsExpiryDays.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.relatedProgram == null)? 0 :this.relatedProgram.hashCode()));
        result = ((result* 31)+((this.displayShortName == null)? 0 :this.displayShortName.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.withoutRegistration == null)? 0 :this.withoutRegistration.hashCode()));
        result = ((result* 31)+((this.notificationTemplates == null)? 0 :this.notificationTemplates.hashCode()));
        result = ((result* 31)+((this.formName == null)? 0 :this.formName.hashCode()));
        result = ((result* 31)+((this.featureType == null)? 0 :this.featureType.hashCode()));
        result = ((result* 31)+((this.minAttributesRequiredToSearch == null)? 0 :this.minAttributesRequiredToSearch.hashCode()));
        result = ((result* 31)+((this.displayFrontPageList == null)? 0 :this.displayFrontPageList.hashCode()));
        result = ((result* 31)+((this.organisationUnits == null)? 0 :this.organisationUnits.hashCode()));
        result = ((result* 31)+((this.programType == null)? 0 :this.programType.hashCode()));
        result = ((result* 31)+((this.accessLevel == null)? 0 :this.accessLevel.hashCode()));
        result = ((result* 31)+((this.programSections == null)? 0 :this.programSections.hashCode()));
        result = ((result* 31)+((this.programStages == null)? 0 :this.programStages.hashCode()));
        result = ((result* 31)+((this.createdBy == null)? 0 :this.createdBy.hashCode()));
        result = ((result* 31)+((this.trackedEntityType == null)? 0 :this.trackedEntityType.hashCode()));
        result = ((result* 31)+((this.displayIncidentDate == null)? 0 :this.displayIncidentDate.hashCode()));
        result = ((result* 31)+((this.expiryDays == null)? 0 :this.expiryDays.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Program) == false) {
            return false;
        }
        Program rhs = ((Program) other);
        return ((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((this.dataEntryForm == rhs.dataEntryForm)||((this.dataEntryForm!= null)&&this.dataEntryForm.equals(rhs.dataEntryForm)))&&((this.publicAccess == rhs.publicAccess)||((this.publicAccess!= null)&&this.publicAccess.equals(rhs.publicAccess))))&&((this.ignoreOverdueEvents == rhs.ignoreOverdueEvents)||((this.ignoreOverdueEvents!= null)&&this.ignoreOverdueEvents.equals(rhs.ignoreOverdueEvents))))&&((this.skipOffline == rhs.skipOffline)||((this.skipOffline!= null)&&this.skipOffline.equals(rhs.skipOffline))))&&((this.programIndicators == rhs.programIndicators)||((this.programIndicators!= null)&&this.programIndicators.equals(rhs.programIndicators))))&&((this.displayIncidentDateLabel == rhs.displayIncidentDateLabel)||((this.displayIncidentDateLabel!= null)&&this.displayIncidentDateLabel.equals(rhs.displayIncidentDateLabel))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.categoryCombo == rhs.categoryCombo)||((this.categoryCombo!= null)&&this.categoryCombo.equals(rhs.categoryCombo))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.displayDescription == rhs.displayDescription)||((this.displayDescription!= null)&&this.displayDescription.equals(rhs.displayDescription))))&&((this.enrollmentDateLabel == rhs.enrollmentDateLabel)||((this.enrollmentDateLabel!= null)&&this.enrollmentDateLabel.equals(rhs.enrollmentDateLabel))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.onlyEnrollOnce == rhs.onlyEnrollOnce)||((this.onlyEnrollOnce!= null)&&this.onlyEnrollOnce.equals(rhs.onlyEnrollOnce))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.attributeValues == rhs.attributeValues)||((this.attributeValues!= null)&&this.attributeValues.equals(rhs.attributeValues))))&&((this.sharing == rhs.sharing)||((this.sharing!= null)&&this.sharing.equals(rhs.sharing))))&&((this.displayFormName == rhs.displayFormName)||((this.displayFormName!= null)&&this.displayFormName.equals(rhs.displayFormName))))&&((this.version == rhs.version)||((this.version!= null)&&this.version.equals(rhs.version))))&&((this.displayEnrollmentDateLabel == rhs.displayEnrollmentDateLabel)||((this.displayEnrollmentDateLabel!= null)&&this.displayEnrollmentDateLabel.equals(rhs.displayEnrollmentDateLabel))))&&((this.maxTeiCountToReturn == rhs.maxTeiCountToReturn)||((this.maxTeiCountToReturn!= null)&&this.maxTeiCountToReturn.equals(rhs.maxTeiCountToReturn))))&&((this.selectIncidentDatesInFuture == rhs.selectIncidentDatesInFuture)||((this.selectIncidentDatesInFuture!= null)&&this.selectIncidentDatesInFuture.equals(rhs.selectIncidentDatesInFuture))))&&((this.incidentDateLabel == rhs.incidentDateLabel)||((this.incidentDateLabel!= null)&&this.incidentDateLabel.equals(rhs.incidentDateLabel))))&&((this.userRoles == rhs.userRoles)||((this.userRoles!= null)&&this.userRoles.equals(rhs.userRoles))))&&((this.expiryPeriodType == rhs.expiryPeriodType)||((this.expiryPeriodType!= null)&&this.expiryPeriodType.equals(rhs.expiryPeriodType))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.selectEnrollmentDatesInFuture == rhs.selectEnrollmentDatesInFuture)||((this.selectEnrollmentDatesInFuture!= null)&&this.selectEnrollmentDatesInFuture.equals(rhs.selectEnrollmentDatesInFuture))))&&((this.registration == rhs.registration)||((this.registration!= null)&&this.registration.equals(rhs.registration))))&&((this.style == rhs.style)||((this.style!= null)&&this.style.equals(rhs.style))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.shortName == rhs.shortName)||((this.shortName!= null)&&this.shortName.equals(rhs.shortName))))&&((this.favorite == rhs.favorite)||((this.favorite!= null)&&this.favorite.equals(rhs.favorite))))&&((this.useFirstStageDuringRegistration == rhs.useFirstStageDuringRegistration)||((this.useFirstStageDuringRegistration!= null)&&this.useFirstStageDuringRegistration.equals(rhs.useFirstStageDuringRegistration))))&&((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites))))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.programRuleVariables == rhs.programRuleVariables)||((this.programRuleVariables!= null)&&this.programRuleVariables.equals(rhs.programRuleVariables))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.programTrackedEntityAttributes == rhs.programTrackedEntityAttributes)||((this.programTrackedEntityAttributes!= null)&&this.programTrackedEntityAttributes.equals(rhs.programTrackedEntityAttributes))))&&((this.completeEventsExpiryDays == rhs.completeEventsExpiryDays)||((this.completeEventsExpiryDays!= null)&&this.completeEventsExpiryDays.equals(rhs.completeEventsExpiryDays))))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.relatedProgram == rhs.relatedProgram)||((this.relatedProgram!= null)&&this.relatedProgram.equals(rhs.relatedProgram))))&&((this.displayShortName == rhs.displayShortName)||((this.displayShortName!= null)&&this.displayShortName.equals(rhs.displayShortName))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.withoutRegistration == rhs.withoutRegistration)||((this.withoutRegistration!= null)&&this.withoutRegistration.equals(rhs.withoutRegistration))))&&((this.notificationTemplates == rhs.notificationTemplates)||((this.notificationTemplates!= null)&&this.notificationTemplates.equals(rhs.notificationTemplates))))&&((this.formName == rhs.formName)||((this.formName!= null)&&this.formName.equals(rhs.formName))))&&((this.featureType == rhs.featureType)||((this.featureType!= null)&&this.featureType.equals(rhs.featureType))))&&((this.minAttributesRequiredToSearch == rhs.minAttributesRequiredToSearch)||((this.minAttributesRequiredToSearch!= null)&&this.minAttributesRequiredToSearch.equals(rhs.minAttributesRequiredToSearch))))&&((this.displayFrontPageList == rhs.displayFrontPageList)||((this.displayFrontPageList!= null)&&this.displayFrontPageList.equals(rhs.displayFrontPageList))))&&((this.organisationUnits == rhs.organisationUnits)||((this.organisationUnits!= null)&&this.organisationUnits.equals(rhs.organisationUnits))))&&((this.programType == rhs.programType)||((this.programType!= null)&&this.programType.equals(rhs.programType))))&&((this.accessLevel == rhs.accessLevel)||((this.accessLevel!= null)&&this.accessLevel.equals(rhs.accessLevel))))&&((this.programSections == rhs.programSections)||((this.programSections!= null)&&this.programSections.equals(rhs.programSections))))&&((this.programStages == rhs.programStages)||((this.programStages!= null)&&this.programStages.equals(rhs.programStages))))&&((this.createdBy == rhs.createdBy)||((this.createdBy!= null)&&this.createdBy.equals(rhs.createdBy))))&&((this.trackedEntityType == rhs.trackedEntityType)||((this.trackedEntityType!= null)&&this.trackedEntityType.equals(rhs.trackedEntityType))))&&((this.displayIncidentDate == rhs.displayIncidentDate)||((this.displayIncidentDate!= null)&&this.displayIncidentDate.equals(rhs.displayIncidentDate))))&&((this.expiryDays == rhs.expiryDays)||((this.expiryDays!= null)&&this.expiryDays.equals(rhs.expiryDays))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))));
    }

    @Generated("jsonschema2pojo")
    public enum ProgramType {

        WITH_REGISTRATION("WITH_REGISTRATION"),
        WITHOUT_REGISTRATION("WITHOUT_REGISTRATION");
        private final String value;
        private final static Map<String, Program.ProgramType> CONSTANTS = new HashMap<String, Program.ProgramType>();

        static {
            for (Program.ProgramType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ProgramType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Program.ProgramType fromValue(String value) {
            Program.ProgramType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
