
package org.hisp.dhis.api.model.v2_37_7;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "direction",
    "propertyPath"
})
@Generated("jsonschema2pojo")
public class Order implements Serializable
{

    @JsonProperty("direction")
    private Direction direction;
    @JsonProperty("propertyPath")
    private String propertyPath;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 807777091860041302L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Order() {
    }

    /**
     * 
     * @param source
     */
    public Order(Order source) {
        super();
        this.direction = source.direction;
        this.propertyPath = source.propertyPath;
    }

    /**
     * 
     * @param propertyPath
     * @param direction
     */
    public Order(Direction direction, String propertyPath) {
        super();
        this.direction = direction;
        this.propertyPath = propertyPath;
    }

    @JsonProperty("direction")
    public Optional<Direction> getDirection() {
        return Optional.ofNullable(direction);
    }

    @JsonProperty("direction")
    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public Order withDirection(Direction direction) {
        this.direction = direction;
        return this;
    }

    @JsonProperty("propertyPath")
    public Optional<String> getPropertyPath() {
        return Optional.ofNullable(propertyPath);
    }

    @JsonProperty("propertyPath")
    public void setPropertyPath(String propertyPath) {
        this.propertyPath = propertyPath;
    }

    public Order withPropertyPath(String propertyPath) {
        this.propertyPath = propertyPath;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Order withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "direction":
                if (value instanceof Direction) {
                    setDirection(((Direction) value));
                } else {
                    throw new IllegalArgumentException(("property \"direction\" is of type \"org.hisp.dhis.api.model.v2_37_7.Direction\", but got "+ value.getClass().toString()));
                }
                return true;
            case "propertyPath":
                if (value instanceof String) {
                    setPropertyPath(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"propertyPath\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "direction":
                return getDirection();
            case "propertyPath":
                return getPropertyPath();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, Order.NOT_FOUND_VALUE);
        if (Order.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public Order with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Order.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("direction");
        sb.append('=');
        sb.append(((this.direction == null)?"<null>":this.direction));
        sb.append(',');
        sb.append("propertyPath");
        sb.append('=');
        sb.append(((this.propertyPath == null)?"<null>":this.propertyPath));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.propertyPath == null)? 0 :this.propertyPath.hashCode()));
        result = ((result* 31)+((this.direction == null)? 0 :this.direction.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Order) == false) {
            return false;
        }
        Order rhs = ((Order) other);
        return ((((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties)))&&((this.propertyPath == rhs.propertyPath)||((this.propertyPath!= null)&&this.propertyPath.equals(rhs.propertyPath))))&&((this.direction == rhs.direction)||((this.direction!= null)&&this.direction.equals(rhs.direction))));
    }

}
