
package org.hisp.dhis.api.model.v2_37_7;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "dataValuesPageSize",
    "eventProgramPageSize",
    "trackerProgramPageSize"
})
@Generated("jsonschema2pojo")
public class MetadataSyncJobParameters implements Serializable
{

    @JsonProperty("dataValuesPageSize")
    private Integer dataValuesPageSize;
    @JsonProperty("eventProgramPageSize")
    private Integer eventProgramPageSize;
    @JsonProperty("trackerProgramPageSize")
    private Integer trackerProgramPageSize;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -1013843282774286737L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public MetadataSyncJobParameters() {
    }

    /**
     * 
     * @param source
     */
    public MetadataSyncJobParameters(MetadataSyncJobParameters source) {
        super();
        this.dataValuesPageSize = source.dataValuesPageSize;
        this.eventProgramPageSize = source.eventProgramPageSize;
        this.trackerProgramPageSize = source.trackerProgramPageSize;
    }

    /**
     * 
     * @param eventProgramPageSize
     * @param dataValuesPageSize
     * @param trackerProgramPageSize
     */
    public MetadataSyncJobParameters(Integer dataValuesPageSize, Integer eventProgramPageSize, Integer trackerProgramPageSize) {
        super();
        this.dataValuesPageSize = dataValuesPageSize;
        this.eventProgramPageSize = eventProgramPageSize;
        this.trackerProgramPageSize = trackerProgramPageSize;
    }

    @JsonProperty("dataValuesPageSize")
    public Optional<Integer> getDataValuesPageSize() {
        return Optional.ofNullable(dataValuesPageSize);
    }

    @JsonProperty("dataValuesPageSize")
    public void setDataValuesPageSize(Integer dataValuesPageSize) {
        this.dataValuesPageSize = dataValuesPageSize;
    }

    public MetadataSyncJobParameters withDataValuesPageSize(Integer dataValuesPageSize) {
        this.dataValuesPageSize = dataValuesPageSize;
        return this;
    }

    @JsonProperty("eventProgramPageSize")
    public Optional<Integer> getEventProgramPageSize() {
        return Optional.ofNullable(eventProgramPageSize);
    }

    @JsonProperty("eventProgramPageSize")
    public void setEventProgramPageSize(Integer eventProgramPageSize) {
        this.eventProgramPageSize = eventProgramPageSize;
    }

    public MetadataSyncJobParameters withEventProgramPageSize(Integer eventProgramPageSize) {
        this.eventProgramPageSize = eventProgramPageSize;
        return this;
    }

    @JsonProperty("trackerProgramPageSize")
    public Optional<Integer> getTrackerProgramPageSize() {
        return Optional.ofNullable(trackerProgramPageSize);
    }

    @JsonProperty("trackerProgramPageSize")
    public void setTrackerProgramPageSize(Integer trackerProgramPageSize) {
        this.trackerProgramPageSize = trackerProgramPageSize;
    }

    public MetadataSyncJobParameters withTrackerProgramPageSize(Integer trackerProgramPageSize) {
        this.trackerProgramPageSize = trackerProgramPageSize;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public MetadataSyncJobParameters withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "dataValuesPageSize":
                if (value instanceof Integer) {
                    setDataValuesPageSize(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataValuesPageSize\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "eventProgramPageSize":
                if (value instanceof Integer) {
                    setEventProgramPageSize(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"eventProgramPageSize\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "trackerProgramPageSize":
                if (value instanceof Integer) {
                    setTrackerProgramPageSize(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"trackerProgramPageSize\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "dataValuesPageSize":
                return getDataValuesPageSize();
            case "eventProgramPageSize":
                return getEventProgramPageSize();
            case "trackerProgramPageSize":
                return getTrackerProgramPageSize();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, MetadataSyncJobParameters.NOT_FOUND_VALUE);
        if (MetadataSyncJobParameters.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public MetadataSyncJobParameters with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(MetadataSyncJobParameters.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("dataValuesPageSize");
        sb.append('=');
        sb.append(((this.dataValuesPageSize == null)?"<null>":this.dataValuesPageSize));
        sb.append(',');
        sb.append("eventProgramPageSize");
        sb.append('=');
        sb.append(((this.eventProgramPageSize == null)?"<null>":this.eventProgramPageSize));
        sb.append(',');
        sb.append("trackerProgramPageSize");
        sb.append('=');
        sb.append(((this.trackerProgramPageSize == null)?"<null>":this.trackerProgramPageSize));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.eventProgramPageSize == null)? 0 :this.eventProgramPageSize.hashCode()));
        result = ((result* 31)+((this.dataValuesPageSize == null)? 0 :this.dataValuesPageSize.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.trackerProgramPageSize == null)? 0 :this.trackerProgramPageSize.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof MetadataSyncJobParameters) == false) {
            return false;
        }
        MetadataSyncJobParameters rhs = ((MetadataSyncJobParameters) other);
        return (((((this.eventProgramPageSize == rhs.eventProgramPageSize)||((this.eventProgramPageSize!= null)&&this.eventProgramPageSize.equals(rhs.eventProgramPageSize)))&&((this.dataValuesPageSize == rhs.dataValuesPageSize)||((this.dataValuesPageSize!= null)&&this.dataValuesPageSize.equals(rhs.dataValuesPageSize))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.trackerProgramPageSize == rhs.trackerProgramPageSize)||((this.trackerProgramPageSize!= null)&&this.trackerProgramPageSize.equals(rhs.trackerProgramPageSize))));
    }

}
